from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_workshop_event_date'
    primary_key_columns = ['workshop_event_date_id']
    exclude_search_columns = []
    is_view = True

    def after_get_all(self, items):
        for i in items:
            if i.workshop_event_time_division == 'AM':
                i.workshop_event_time_division = '午前'
            elif i.workshop_event_time_division == 'PM':
                i.workshop_event_time_division = '午後'
            else:
                i.workshop_event_time_division = ''

            # ワークショップ開催日
            if i.workshop_event_date:
                i.workshop_event_date = i.workshop_event_date.strftime(
                    '%Y/%m/%d')

        pass
