from .view import Base, GV, json

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_auth0_user_info'
    primary_key_columns = ['auth_user_info_id']
    exclude_search_columns = []
    is_view = True

    def after_get_all(self, items):
        for i in items:
            if i.roles:
                try:
                    i.roles = json.loads(i.roles)
                except json.JSONDecodeError:
                    i.roles = None
        pass