from .model import Base, GV, CustomException, and_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_send_mail'
    primary_key_columns = ['mail_id']
    exclude_search_columns = []
                        
    def before_new_item(self, item):
        print('m_send_mail before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.service_id ==
                           item.service_id)
            filters.append(self.model_class.mail_type ==
                           item.mail_type)
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                raise CustomException('MSM_ERR_100')

            # 付与ロールのリスト
            item.mail_to = ';'.join(item.mail_to)
            item.mail_cc = ';'.join(item.mail_cc)
            item.mail_bcc = ';'.join(item.mail_bcc)
                
            item.mail_id = self.new_id('メールID', 'SM', 6)

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        
    def before_update_item(self, item=None, data=None):
        print('m_send_mail before_update_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.service_id ==
                           item.service_id)
            filters.append(self.model_class.mail_type ==
                           item.mail_type)
            filters.append(self.model_class.mail_id != item.mail_id)
            # filters = and_(
            #     self.model_class.mail_id != item.mail_id,
            #     or_(*filters)
            # )
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                raise CustomException('MSM_ERR_100')

            # 付与ロールのリスト
            item.mail_to = ';'.join(item.mail_to)
            item.mail_cc = ';'.join(item.mail_cc)
            item.mail_bcc = ';'.join(item.mail_bcc)

            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
