from .model import Base, GV, CustomException, and_
import json
    
class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'billing_infrastructure'
    table_name = 'm_product_groups'
    primary_key_columns = ['product_group_id']
    exclude_search_columns = []
    
    def before_new_item(self, item=None, data=None):
        print('m_product_groups before_new_item ----------------')
        try:

            # 同じ「商品グループID」のデータがすでに存在します。
            filters = []
            filters.append(self.model_class.product_group_id == item.product_group_id)
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.product_group_id == item.product_group_id:
                    raise CustomException('MPG_ERR_100')
        
            super().before_new_item(item)
            
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        
    def after_get_all(self, items):
        
        pass