from .model import Base, GV, CustomException, and_

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_env_stock'
    primary_key_columns = ['env_id']
    exclude_search_columns = []
          
    def before_new_item(self, item):
        print('m_env_stock before_new_item ----------------')
        try:
            if item.company_code is not None:
                filters = []
                filters.append(self.model_class.company_code ==
                           item.company_code)
                filters.append(self.model_class.system_id ==
                            item.system_id)
                filters.append(self.model_class.service_id ==
                            item.service_id)
                filters = and_(*filters)
                tmp = self._get_item_by_filters(filters)
                if tmp:
                    raise CustomException('MES_ERR_100')

            item.env_id = 'ENV' + self.new_id('環境ID', '', 5)

            super().before_new_item(item)
            
        except Exception as e:
            print(e)
            # 例外の再送出
            raise

    def before_update_item(self, item=None, data=None):
        print('m_env_stock before_update_item ----------------')
        try:
            if item.company_code is not None:
                filters = []
                filters.append(self.model_class.company_code ==
                               item.company_code)
                filters.append(self.model_class.system_id ==
                            item.system_id)
                filters.append(self.model_class.service_id ==
                            item.service_id)
                filters = and_(
                    self.model_class.env_id != item.env_id,
                    and_(*filters)
                )
                tmp = self._get_item_by_filters(filters)
                if tmp:
                    print(tmp.to_dict())
                    raise CustomException('MES_ERR_100')
                
            super().before_update_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise