import json
from .model import Base, GV, logging, and_

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_auth0_user_info'
    primary_key_columns = ['auth_user_info_id']
    exclude_search_columns = []

    def after_get_all(self, items):
        for i in items:
            if i.roles:
                try:
                    i.roles = json.loads(i.roles)
                except json.JSONDecodeError:
                    i.roles = None
        pass

    # 追加前の処理
    def before_new_item(self, item):
        logger.debug('----------------- m_auth0_user_info before_new_item')

        super().before_new_item(item)

        # 付与ロールのリスト
        # item.roles = json.dumps(item.roles)
        if type(item.roles) is list:
            item.roles = json.dumps(item.roles)

    def after_new_item(self, item=None, data=None):
        logger.debug('----------------- m_auth0_user_info after_new_item')
        # logger.debug(item)
        logger.debug(item.to_dict())

        query = self.session.query(self.model_class)
        items = query.filter(
            self.model_class.auth0_user_id == item.auth0_user_id).all()
        # logger.debug(items)
       
        user_metadata = []
        del_keys = ['auth_user_info_id', 'tenant', 'auth0_user_id', 'cdate', 'udate']
        for i in items:
            
            d = i.to_dict()
            
            for k in del_keys:
                if k in d:
                    del d[k]
            
            d['roles'] = json.loads(d['roles'])
            
            user_metadata.append(d)

        user_id = item.auth0_user_id
        user_data = {
            "user_metadata": {
                "data": user_metadata
            }
        }
        logger.debug('user_data<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
        logger.debug(user_data)

        # from ..auth0 import Sub as auth0_class
        # auth0 = auth0_class()
        auth0_class = GV.get_module_auth0()
        a0 = auth0_class()

        a0._update(user_id, user_data)

    # 更新前の処理
    def before_update_item(self, item=None, data=None):

        super().before_update_item(item, data)

        # 付与ロールのリスト
        # item.roles = json.dumps(item.roles)
        if type(item.roles) is list:
            item.roles = json.dumps(item.roles)

        # now = datetime.now()
        # # 更新日時
        # item.udate = now


    def append_metadata(self, item=None, data=None):
        logger.debug('----------------- m_auth0_user_info append_metadata')
        logger.debug(item)
        logger.debug(item.to_dict())

        query = self.session.query(self.model_class)
        items = query.filter(
            self.model_class.auth0_user_id == item.auth0_user_id).all()
        logger.debug('# items')
        logger.debug(items)
        

        # m_env_stock
        # from ..model.m_env_stock import Sub as MES
        # m_es = MES()
        MES = GV.get_module('m_env_stock')
        m_es = MES()
        
        user_metadata = []
        del_keys = ['auth_user_info_id', 'tenant', 'auth0_user_id', 'cdate', 'udate']
        for i in items:
            d = i.to_dict()
            d['roles'] = json.loads(d['roles'])
            for k in del_keys:
                if k in d:
                    del d[k]

            logger.debug('******************************')
            logger.debug('# 環境ID取得')

            env_id = None
            
            filters = []
            filters.append(m_es.model_class.company_code ==
                        d['company_code'])
            filters.append(m_es.model_class.system_id ==
                        d['system_id'])
            filters.append(m_es.model_class.service_id ==
                        d['service_id'])
            filters = and_(*filters)
            tmp_m_es = m_es._get_item_by_filters(filters)
            if tmp_m_es:
                env_id = tmp_m_es.env_id
            
            logger.debug('##############################')

            logger.debug('# d')
            logger.debug(d)
            
            user_metadata.append(d)

        logger.debug('# user_metadata')
        logger.debug(user_metadata)
        
        user_id = item.auth0_user_id
        user_data = {
            "user_metadata": {
                "data": user_metadata
            }
        }
        logger.debug('user_data<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
        logger.debug(user_data)

        # from ..auth0 import Sub as auth0_class
        # auth0 = auth0_class()
        auth0_class = GV.get_module_auth0()
        a0 = auth0_class()

        a0._update(user_id, user_data)

    def after_update_item(self, item=None, data=None):
        logger.debug('----------------- m_auth0_user_info after_update_item')
        self.append_metadata(item,data) 

    def after_delete_item(self, item=None, data=None):
        logger.debug('----------------- m_auth0_user_info after_delete_item')
        self.append_metadata(item,data) 
