
import boto3
import csv
from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
class Sub(Base):
  table_name = 'notice'
  def get_all(self, event, context):
    print("notice get_all")
    VN = GV.get_module('view_notice')
    v_n = VN()
    return v_n.get_all(event, context)
    pass
  
  def get_table_schema(self):
    print("notice get_table_schema")
    VN = GV.get_module('view_notice')
    v_n = VN()
    v_n.table_config = self.table_name
    return v_n.get_table_schema()
    pass

  # noticeデータを取得
  def get_notice_date(self):
      print('get_notice_date')

      if GV.PATH_PARAMETERS:
            logger.debug(GV.PATH_PARAMETERS)
      else:
          if GV.EVENT_BODY:
              logger.debug(GV.EVENT_BODY)
      data = GV.EVENT_BODY

      TN = GV.get_module('view_notice')
      t_n = TN()

      # 最新なKEYを取得する
      filters = []
      filters = and_(*filters)
      tmp_t_notice_get = t_n._get_item_by_filters(filters, get_all=True)
      print(tmp_t_notice_get)

      data_m_wed = []
      for item in tmp_t_notice_get:
          logger.debug(item)
          tmp_dc = item.to_dict()
          data_m_wed.append(tmp_dc)

      return data_m_wed

  # 更新する
  def update(self, event, context):
      
      if GV.EVENT_BODY is None:
          raise CustomException('SYS_ERR_100')

      data = GV.EVENT_BODY

      print('update t_notice')
      print(data['read_time'])

      # from ..model.t_notice import Sub as MWED
      # m_wed = MWED()
      # now = datetime.now()
      # print(data['read_at'])
      # dat = data['read_at'].strftime('%Y/%m/%d')
      # print(data['read_time'] )
      
      if data['read_time'] is not None:
        str_read_time = data['read_at'] + " " + data['read_time'] + ":00"
        data['read_time'] =  datetime.strptime(str_read_time, "%Y/%m/%d %H:%M:%S")
      if data['system_all'] == True:
         data['system_id'] = ''
         data['system_name'] = ''
         data['service_id'] = ''
         data['service_name'] = ''
      TN = GV.get_module('t_notice')
      t_n = TN()

      tmp_t_n = t_n._update(data)

      return {}
  
  # 作成する
  def add(self, event, context):
    #   print("notice add")
        
      if GV.EVENT_BODY is None:
          raise CustomException('SYS_ERR_100')

      data = GV.EVENT_BODY

      TN = GV.get_module('t_notice')
      t_n = TN()

      # 最新なKEYを取得する
      filters = []
      filters = and_(*filters)
      tmp_m_con_get = t_n._get_item_by_filters(filters, get_all=True)
      data['notice_id'] = 'N'+ str(len(tmp_m_con_get) + 1).zfill(7)

      if data['system_all'] == True:
         data['system_id'] = ''
         data['system_name'] = ''
         data['service_id'] = ''
         data['service_name'] = ''

      if data['read_time'] is not None:
        str_read_time = data['read_at'] + " " + data['read_time'] + ":00"
        data['read_time'] =  datetime.strptime(str_read_time, "%Y/%m/%d %H:%M:%S")

      tmp_t_n = t_n._add(data)

      return {}
  
  def import_csv(self):
    logger.debug('# ******************************')
    logger.debug('import_csv----------')
    logger.debug(self)

    s3 = boto3.resource('s3')
    BUCKET_NAME = GV.ENV.lower() + GV.S3_BUCKET_NAME
    bucket = s3.Bucket(BUCKET_NAME)
    s3_kintone_csv_path = 'kintone/csv'

    try:
        logger.debug('# ##############################')

        prefix = s3_kintone_csv_path
        file_list = bucket.objects.filter(Prefix=prefix)

        for o in file_list:
            print('-----------')
            target_csv_file = o.key
            if ".csv" in target_csv_file:
            
                filepath = '/tmp/'
                file_name = filepath + o.key.split('/')[-1]
                print('++++++++++++')
                print(file_name)
                # S3からファイルダウンロード 
                bucket.download_file(o.key, file_name)
                print('++++++++++++')
                
                # 申込ポータルサイト情報登録
                self.insert_infrastructure_m_entry_site(file_name)

        pass

        return {}

    except Exception as e:
        logger.debug(e)
        # 例外の再送出
        raise
    finally:
        logger.debug('# ##############################')

  # 申込ポータルサイト情報登録
  def insert_infrastructure_m_entry_site(self, file_name):
    print('insert_infrastructure_m_entry_site|||||')
    # strRow = ''
    cur = []
    
    # テーブルデータを削除する
    self.del_user_infrastructure_m_entry_site()

    with open(file_name, encoding='cp932') as f:
        d_reader = csv.DictReader(f)
        for row in d_reader:

            # user_infrastructure.m_entry_site_app_settings_confirmed更新
            self.int_user_infrastructure_m_entry_site_app_settings_confirmed(row)
            
            if row['資料説明タイトル'] != '' or row['資料説明本文'] != '':
              
              # user_infrastructure.m_entry_site_document_request_manage_confirmed 作成
              self.int_user_infrastructure_m_entry_site_document_request_manage_confirmed(row)
              
            if row['アンケート質問'] != '' or row['アンケート回答選択肢("|"区切り)'] != '' or row['アンケート回答タイプ'] != '' or row['必須項目[必須]'] != '':
              # user_infrastructure.m_entry_site_questionnaire_manage_confirmed 作成
              self.int_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(row)
                
              # strRow = row['レコード番号']
            

    # 課金アップロード履歴テーブル登録用のファイル名
    name = file_name.split('/')[-1]

    return 
  
  def int_user_infrastructure_m_entry_site_app_settings_confirmed(self,item):
    logger.info('int_user_infrastructure_m_entry_site_app_settings_confirmed!!!')

    res = {}
    print('-----------------------')
    logger.info(item)
    print('-----------------------')

    try:
      record = {
        '$id': {'value': None},
        'ステータス': {'value': None},
        '作業者': {'value': None},
        'レコード番号': {'value': None},
        '作成者': {'value': None},
        '作成日時': {'value': None},
        '更新者': {'value': None},
        '更新日時': {'value': None},
        'entry_site_app_setting_id': { 'value': ''},
        'supplier_id': { 'value': ''},
        'system_id': { 'value': ''},
        'app_display_flag': { 'value': ''},
        'app_display_name': { 'value': ''},
        'handling_of_personal_information': { 'value': ''},
        'top_app_description': { 'value': ''},
        'top_document_request_btn_flag': { 'value': ''},
        'top_trial_btn_flag': { 'value': ''},
        'top_workshop_btn_flag': { 'value': ''},
        'top_contract_btn_flag': { 'value': None},
        'document_request_descritpion': { 'value': None},
        'trial_description': { 'value': None},
        'trial_application_completed': { 'value': ''},
        'workshop_description': { 'value': None},
        'workshop_application_completed': { 'value': ''},
        'workshop_questionnaire_description': { 'value': ''},
        'contract_description': { 'value': ''},
        'contract_terms_text': { 'value': ''},
        'contract_application_completed': { 'value': ''},
        'top_app_image_url': { 'value': ''},
        'contract_terms_file_url': { 'value': ''},
      }
      
      # '申込ポータルサイトアプリ設定ID'
      record["entry_site_app_setting_id"]["value"] = item["レコード番号"]
      # 'サプライヤーID'
      record["supplier_id"]["value"] = item["サプライヤID"]
      # 'システムID'
      record["system_id"]["value"] = item["システムID"]
      # 'アプリ表示OnOff'
      # record["app_display_flag"]["value"] = item["アプリ表示"]
      if item["アプリ表示"] == 'Off':
        record["app_display_flag"]["value"] = False
      else:
        record["app_display_flag"]["value"] = True
      # 'アプリ表示名'
      record["app_display_name"]["value"] = item["アプリ表示名"]
      # '個人情報取り扱い'
      record["handling_of_personal_information"]["value"] = item["個人情報取り扱い本文"]
      # 'アプリ説明'
      record["top_app_description"]["value"] = item["アプリ説明"]
      # '資料請求OnOff'
      # record["top_document_request_btn_flag"]["value"] = item['ボタン表示[資料請求]']
      if item['ボタン表示[資料請求]'] == '1':
        record["top_document_request_btn_flag"]["value"] = True
      else:
        record["top_document_request_btn_flag"]["value"] = False
      # 'フリートライアルOnOff'
      # record["top_trial_btn_flag"]["value"] = item['ボタン表示[トライアル]']
      if item['ボタン表示[トライアル]'] == '1':
        record["top_trial_btn_flag"]["value"] = True
      else:
        record["top_trial_btn_flag"]["value"] = False
      # 'ワークショップOnOff'
      # record["top_workshop_btn_flag"]["value"] = item['ボタン表示[ワークショップ]']
      if item['ボタン表示[ワークショップ]'] == '1':
        record["top_workshop_btn_flag"]["value"] = True
      else:
        record["top_workshop_btn_flag"]["value"] = False
      # '本契約OnOff'
      # record["top_contract_btn_flag"]["value"] = item['ボタン表示[本契約]']
      if item['ボタン表示[本契約]'] == '1':
        record["top_contract_btn_flag"]["value"] = True
      else:
        record["top_contract_btn_flag"]["value"] = False
      # '資料請求説明'
      record["document_request_descritpion"]["value"] = item["資料請求説明"]
      # 'フリートライアル説明'
      record["trial_description"]["value"] = item["トライアル説明"]
      # '申込み完了'
      record["trial_application_completed"]["value"] = item["トライアル申込み完了"]
      # 'ワークショップ説明'
      record["workshop_description"]["value"] = item["ワークショップ説明"]
      # '申込み完了'
      record["workshop_application_completed"]["value"] = item["ワークショップ申し込み完了"]
      # 'アンケート説明'
      record["workshop_questionnaire_description"]["value"] = item["アンケート説明"]
      # '本契約説明'
      record["contract_description"]["value"] = item["本契約説明"]
      # '利用規約のテキスト'
      record["contract_terms_text"]["value"] = item["利用規約"]
      # '申込み完了'
      record["contract_application_completed"]["value"] = item["本契約申込み完了"]
      # # '登録日時'
      # record["cdate"]["value"] = item["作成日時"]
      # # '更新日時'
      # record["udate"]["value"] = item["更新日時"]
      'アプリ画像URL'
      record["top_app_image_url"]["value"] = item["アプリ画像URL"] 
      '利用規約のPDFファイルURL'
      record["contract_terms_file_url"]["value"] = item["利用規約のPDFファイルURL"]
      print('+++++++++++++++++++++++++++')
      print(record)
      print('+++++++++++++++++++++++++++')
      input_event = {
          'stageVariables': {
              'env': GV.ENV
          },
          'httpMethod': 'POST',
          'path': '/rds/user_infrastructure/m_entry_site_app_settings_confirmed',
          'body': json.dumps(
              {
                  'record': record
              }
          )
      }

      Payload = json.dumps(input_event)
      print("---01: Payload:", Payload)

      # 呼び出し
      response = boto3.client('lambda').invoke(
          FunctionName=GV.LAMBDA_SYS_RDS,
          InvocationType='RequestResponse',
          Payload=Payload
      )
      print("---02: response:", response)

      res = response

      result = None
      if 'StatusCode' in response and response['StatusCode'] == 200:

          # レスポンス読出し
          Payload = json.loads(response['Payload'].read())
          print("---03: body:", Payload)
          res = Payload

    except Exception as err:
        # return error_handling(inspect.currentframe().f_code.co_name, err)
        logger.debug(err)
        # 例外の再送出
        raise

    return res

  def int_user_infrastructure_m_entry_site_document_request_manage_confirmed(self,item):
    logger.info('int_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')

    res = {}
    print('-----------------------')
    logger.info(item)
    print('-----------------------')

    try:
      record = {
        '$id': {'value': None},
        'ステータス': {'value': None},
        '作業者': {'value': None},
        'レコード番号': {'value': None},
        '作成者': {'value': None},
        '作成日時': {'value': None},
        '更新者': {'value': None},
        '更新日時': {'value': None},
        'document_request_file_temp_id': { 'value': ''},
        'system_id': { 'value': ''},
        'document_request_file_title': { 'value': ''},
        'document_request_file_description': { 'value': ''},
        'document_request_file_image_url': { 'value': ''},
        'document_request_file_url': { 'value': ''},
      }
      
      # '申込ポータルサイトアプリ設定ID'
      # record["document_request_file_temp_id"]["value"] = item["レコード番号"]
      # 'システムID'
      record["system_id"]["value"] = item["システムID"]
      # '資料説明タイトル'
      record["document_request_file_title"]["value"] = item["資料説明タイトル"]
      # '資料説明本文'
      record["document_request_file_description"]["value"] = item["資料説明本文"]
      # '資料画像URL'
      record["document_request_file_image_url"]["value"] = item["資料画像URL"]
      # '資料URL'
      record["document_request_file_url"]["value"] = item["資料URL"]

      input_event = {
          'stageVariables': {
              'env': GV.ENV
          },
          'httpMethod': 'POST',
          'path': '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed',
          'body': json.dumps(
              {
                  'record': record
              }
          )
      }

      Payload = json.dumps(input_event)
      print("---01: Payload:", Payload)

      # 呼び出し
      response = boto3.client('lambda').invoke(
          FunctionName=GV.LAMBDA_SYS_RDS,
          InvocationType='RequestResponse',
          Payload=Payload
      )
      print("---02: response:", response)

      res = response

      result = None
      if 'StatusCode' in response and response['StatusCode'] == 200:

          # レスポンス読出し
          Payload = json.loads(response['Payload'].read())
          print("---03: body:", Payload)
          res = Payload

    except Exception as err:
        # return error_handling(inspect.currentframe().f_code.co_name, err)
        logger.debug(err)
        # 例外の再送出
        raise

    return res

  def int_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(self,item):
    logger.info('int_user_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')

    res = {}
    print('-----------------------')
    logger.info(item)
    print('-----------------------')

    try:
      record = {
        '$id': {'value': None},
        'ステータス': {'value': None},
        '作業者': {'value': None},
        'レコード番号': {'value': None},
        '作成者': {'value': None},
        '作成日時': {'value': None},
        '更新者': {'value': None},
        '更新日時': {'value': None},
        'questionnaire_temp_id': { 'value': ''},
        'system_id': { 'value': ''},
        'questionnaire_location': { 'value': ''},
        'questionnaire_question': { 'value': ''},
        'questionnaire_answer_choices': { 'value': ''},
        'questionnaire_anser_type': { 'value': ''},
        'required': { 'value': ''},
      }
      
      # 'アンケート一時管理ID'
      # record["questionnaire_temp_id"]["value"] = item["レコード番号"]
      # 'システムID'
      record["system_id"]["value"] = item["システムID"]
      # 'アンケートの場所'
      record["questionnaire_location"]["value"] = 'workshop'
      # 'アンケート質問'
      record["questionnaire_question"]["value"] = item["アンケート質問"]
      # 'アンケート回答選択肢'
      record["questionnaire_answer_choices"]["value"] = item['アンケート回答選択肢("|"区切り)']
      # 'アンケート回答タイプ'
      record["questionnaire_anser_type"]["value"] = item['アンケート回答タイプ']
      # '必須項目'
      # record["required"]["value"] = item['必須項目[必須]']
      if item['必須項目[必須]'] == '1':
        record["required"]["value"] = True
      else:
        record["required"]["value"] = False

      input_event = {
          'stageVariables': {
              'env': GV.ENV
          },
          'httpMethod': 'POST',
          'path': '/rds/user_infrastructure/m_entry_site_questionnaire_manage_confirmed',
          'body': json.dumps(
              {
                  'record': record
              }
          )
      }

      Payload = json.dumps(input_event)
      print("---01: Payload:", Payload)

      # 呼び出し
      response = boto3.client('lambda').invoke(
          FunctionName=GV.LAMBDA_SYS_RDS,
          InvocationType='RequestResponse',
          Payload=Payload
      )
      print("---02: response:", response)

      res = response

      result = None
      if 'StatusCode' in response and response['StatusCode'] == 200:

          # レスポンス読出し
          Payload = json.loads(response['Payload'].read())
          print("---03: body:", Payload)
          res = Payload

    except Exception as err:
        # return error_handling(inspect.currentframe().f_code.co_name, err)
        logger.debug(err)
        # 例外の再送出
        raise

    return res

  def del_user_infrastructure_m_entry_site_document_request_manage_confirmed(self,item):
    logger.info('del_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')

    res = {}
    print('-----------------------')
    logger.info(item)
    print('-----------------------')

    try:
      record = {
        '$id': {'value': None},
        'ステータス': {'value': None},
        '作業者': {'value': None},
        'レコード番号': {'value': None},
        '作成者': {'value': None},
        '作成日時': {'value': None},
        '更新者': {'value': None},
        '更新日時': {'value': None},
        'system_id': { 'value': ''},
      }
      
      # 'システムID'
      record["system_id"]["value"] = item["システムID"]

      input_event = {
          'stageVariables': {
              'env': GV.ENV
          },
          'httpMethod': 'POST',
          'path': '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed_del',
          'body': json.dumps(
              {
                  'record': record
              }
          )
      }

      Payload = json.dumps(input_event)
      print("---01: Payload:", Payload)

      # 呼び出し
      response = boto3.client('lambda').invoke(
          FunctionName=GV.LAMBDA_SYS_RDS,
          InvocationType='RequestResponse',
          Payload=Payload
      )
      print("---02: response:", response)

      res = response

      result = None
      if 'StatusCode' in response and response['StatusCode'] == 200:

          # レスポンス読出し
          Payload = json.loads(response['Payload'].read())
          print("---03: body:", Payload)
          res = Payload

    except Exception as err:
        # return error_handling(inspect.currentframe().f_code.co_name, err)
        logger.debug(err)
        # 例外の再送出
        raise

    return res

  def del_user_infrastructure_m_entry_site(self):
    logger.info('del_user_infrastructure_m_entry_site!!!')

    res = {}

    try:
      record = {
        '$id': {'value': None},
        'ステータス': {'value': None},
        '作業者': {'value': None},
        'レコード番号': {'value': None},
        '作成者': {'value': None},
        '作成日時': {'value': None},
        '更新者': {'value': None},
        '更新日時': {'value': None},
      }
      
      # 'システムID'
      # record["system_id"]["value"] = item["システムID"]

      input_event = {
          'stageVariables': {
              'env': GV.ENV
          },
          'httpMethod': 'POST',
          'path': '/rds/user_infrastructure/m_entry_site_del',
          'body': json.dumps(
              {
                  'record': record
              }
          )
      }

      Payload = json.dumps(input_event)
      print("---01: Payload:", Payload)

      # 呼び出し
      response = boto3.client('lambda').invoke(
          FunctionName=GV.LAMBDA_SYS_RDS,
          InvocationType='RequestResponse',
          Payload=Payload
      )
      print("---02: response:", response)

      res = response

      result = None
      if 'StatusCode' in response and response['StatusCode'] == 200:

          # レスポンス読出し
          Payload = json.loads(response['Payload'].read())
          print("---03: body:", Payload)
          res = Payload

    except Exception as err:
        # return error_handling(inspect.currentframe().f_code.co_name, err)
        logger.debug(err)
        # 例外の再送出
        raise

    return res


