from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, or_, datetime

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'new_biz_sys_info'

    CSV_COL = [
        "取込グループ",  # 0
        "登録者コード",  # 1
        "登録者",  # 2
        "案件番号",  # 3
        "案件名称",  # 4
        "注文主コード",  # 5
        "注文主",  # 6
        "受注見込税抜金額",  # 7
        "契約期間(自)",  # 8
        "契約期間(至)",  # 9
        "連携ステータス",  # 10
        "起票組織コード",  # 11
        "起票組織",  # 12
        "計上組織コード",  # 13
        "計上組織",  # 14
        "受注実績計上日",  # 15
        "プロジェクト種類コード",  # 16
        "プロジェクト種類",  # 17
        "受注番号",  # 18
        "受注名称",  # 19
        "受注税抜金額",  # 20
        "契約番号",  # 21
        "プロジェクト番号",  # 22
        "プロジェクト名称",  # 23
        "プロジェクト税抜金額"  # 24
    ]

    def get_all(self, event, context):

        # from ..view.view_new_biz_sys_info import Sub as VNBSI
        # v_nbsi = VNBSI()
        VNBSI = GV.get_module('view_new_biz_sys_info')
        v_nbsi = VNBSI()

        return v_nbsi.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_new_biz_sys_info import Sub as VNBSI
        # v_nbsi = VNBSI()
        VNBSI = GV.get_module('view_new_biz_sys_info')
        v_nbsi = VNBSI()

        v_nbsi.table_config = self.table_name
        return v_nbsi.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        MNBSI = GV.get_module('m_new_biz_sys_info')
        m_nbsi = MNBSI()

        tmp_m_nbsi = m_nbsi._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        MNBSI = GV.get_module('m_new_biz_sys_info')
        m_nbsi = MNBSI()

        tmp_m_nbsi = m_nbsi._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        MNBSI = GV.get_module('m_new_biz_sys_info')
        m_nbsi = MNBSI()

        tmp_m_nbsi = m_nbsi._delete(data)

        return {}
    

    def import_csv(self, data):
        print('import_csv-----------------')
        print(data)
    
        msg = ''

        try:
            
            records = []
            
            csv_data = data
            csv_rows = csv_data.split('\r\n')

            if len(csv_rows) < 2:
                raise CustomException('MNBSI_CSV_ERR_100')

            if csv_rows[0].strip() == '' or csv_rows[1].strip() == '':
                raise CustomException('MNBSI_CSV_ERR_100')

            for i, r in enumerate(csv_rows):
                # print(i)
                # print(r)

                if r != '':
                    r = r.replace('\n', '')
                    r = r.replace('\r', '')

                    if i == 0:
                        if r != ','.join(self.CSV_COL):
                            raise CustomException('MNBSI_CSV_ERR_101')
                        pass
                    else:
                        csv_cols = r.split(',')
                        # print(csv_cols)

                        if len(csv_cols) != len(self.CSV_COL):
                            raise CustomException('MNBSI_CSV_ERR_102')
                        
                        record = {}
                        
                        for j, c in enumerate(csv_cols):
                            if len(c) > 0 and c[0] == '"':
                                c = c[1:]
                            if len(c) > 0 and c[len(c) - 1] == '"':
                                c = c[0:len(c) - 1]
                            pass
                            # print(c)
                            
                            # 新業務システム情報マスタID
                            record['new_biz_sys_info_id'] = ''
                            # 企業コード
                            record['company_code'] = ''
                            # 取込グループ
                            if j == 0:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '取込グループ'])
                            # 登録者コード
                            if j == 1:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '登録者コード'])
                            # 登録者
                            if j == 2:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '登録者'])
                            # 案件番号:契約ID+YYYY
                            if j == 3:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '案件番号'])
                                record['contract_id'] = c[0: len(c) - 4]
                                record['案件番号'] = c
                            # 案件名称
                            if j == 4:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '案件名称'])
                            # 注文主コード:取引先コード
                            if j == 5:
                                record['new_biz_sys_company_id'] = c
                            # 注文主
                            if j == 6:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '注文主'])
                            # 受注見込税抜金額
                            if j == 7:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '受注見込税抜金額'])
                            # 契約期間(自):契約開始日
                            if j == 8:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '契約期間(自)'])
                                record['new_biz_sys_contract_start_date'] = c
                            # 契約期間(至):契約終了日
                            if j == 9:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '契約期間(至)'])
                                record['new_biz_sys_contract_end_date'] = c
                            # 連携ステータス
                            if j == 10:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '連携ステータス'])
                            # 起票組織コード
                            if j == 11:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '起票組織コード'])
                            # 起票組織
                            if j == 12:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '起票組織'])
                            # 計上組織コード
                            if j == 13:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '計上組織コード'])
                            # 計上組織
                            if j == 14:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '計上組織'])
                            # 受注実績計上日
                            if j == 15:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '受注実績計上日'])
                            # プロジェクト種類コード
                            if j == 16:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'プロジェクト種類コード'])
                                record['new_biz_sys_project_type'] = c
                            # プロジェクト種類:プロジェクト種類
                            if j == 17:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'プロジェクト種類'])
                            # 受注番号
                            if j == 18:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '受注番号'])
                            # 受注名称
                            if j == 19:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '受注名称'])
                            # 受注税抜金額
                            if j == 20:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '受注税抜金額'])
                            # 契約番号:契約番号
                            if j == 21:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '契約番号'])
                                record['new_biz_sys_contract_number'] = c
                            # プロジェクト番号:プロジェクトコード
                            # PJコード:プロジェクトコード
                            if j == 22:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'プロジェクト番号'])
                                record['new_biz_sys_project_code'] = c
                            # プロジェクト名称:プロジェクト名
                            if j == 23:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'プロジェクト名称'])
                                record['new_biz_sys_project_name'] = c
                            # プロジェクト税抜金額
                            if j == 24:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'プロジェクト税抜金額'])

                        records.append(record)
                        
                        pass
            
            # print('records-----------------')
            # print(records)
            
            print('*******************************')
            msg = self.bulk_insert(records)
            print('-------------------------------')
            
            res = {
                'message': msg
            }
            
            return res
                               
        except Exception as e:
            print(e)
            # 例外の再送出
            raise

        # return {
        #     'body': msg
        # }

    # ・同じ契約ID、プロジェクト種類のレコードがすでにある場合はそのレコードの契約番号、契約開始日、契約終了日、PJコードを上書きする。無い場合は新規登録。
    # ・契約IDは「案件番号」から取得する。
    # ・新規登録時は契約IDから企業コードとサービス名、プロジェクト種類から売上区分IDを取得する。
    # ・処理終了時に新規追加件数と更新件数をメッセージ表示する。
    def bulk_insert(self, records):
        print('bulk_insert -------------------------------')
        print('bulk_insert -------------------------------start')
        print(datetime.now())
        
        # ・処理終了時に新規追加件数と更新件数をメッセージ表示する。
        cnt_ins = []
        cnt_upd = []
        
        arr_contract_id = []
        
        temp_msg_top = ''

        VCI = GV.get_module('view_contract_info')
        v_ci = VCI()
        
        MNBSSC = GV.get_module('m_new_biz_sys_sales_category')
        m_nbssc = MNBSSC()
        
        VMNBSI = GV.get_module('view_new_biz_sys_info')
        v_m_nbsi = VMNBSI()

        MNBSI = GV.get_module('m_new_biz_sys_info')
        m_nbsi = MNBSI()
        
        for i, r in enumerate(records):
            
            arr_contract_id.append(r['contract_id'])
            
            temp_msg_top = '連携ファイル取り込みCSVのデータの' + str(i + 1) + '行目'
            
            # myapp.methods.check_input.check_new_biz_sys_info_bulk(record);
            
            # // 案件番号(契約ID+"YYYY")

            filters = []
            filters.append(v_ci.model_class.contract_id == r['contract_id'])
            filters = and_(*filters)
            tmp_ci = v_ci._get_item_by_filters(filters)
            if tmp_ci is None:
                raise CustomException('MNBSI_CSV_ERR_104', r['contract_id'])
            
            # 企業コードセット
            r['company_code'] = tmp_ci.company_code
            
            pass
        
            # Inputファイルの取引先コード、案件番号(契約ID+"YYYY")に、
            # 企業情報管理アプリに存在しない取引先コード、契約IDが含まれる場合はエラー表示
            # 取引先コード
            filters = []
            filters.append(v_ci.model_class.company_code == tmp_ci.company_code)
            filters.append(v_ci.model_class.new_biz_sys_company_id == r['new_biz_sys_company_id'])
            filters = and_(*filters)
            tmp_ci = v_ci._get_item_by_filters(filters)
            if tmp_ci is None:
                raise CustomException('MNBSI_CSV_ERR_105', r['new_biz_sys_company_id'])
            
            pass
        
            # Inputファイルに、新業務システム売上区分管理に存在しないプロジェクト種類が含まれる場合はエラー表示

            filters = []
            filters.append(m_nbssc.model_class.new_biz_sys_project_type == r['new_biz_sys_project_type'])
            filters = and_(*filters)
            tmp_m_nbssc = m_nbssc._get_item_by_filters(filters)
            if tmp_m_nbssc is None:
                raise CustomException('MNBSI_CSV_ERR_106', r['new_biz_sys_project_type'])
            
            r["sales_category_id"] = tmp_m_nbssc.sales_category_id
            
            pass
        
            # /**
            #  * プロジェクトコードは全レコードでユニークです。
            #  * 売上区分IDは1企業内ではユニークです。
            #  * 1プロジェクトコードに複数の売上区分IDがつくことはないです。
            #  * 1企業内で複数のプロジェクトコードに同じ売上区分IDがつくことはないです。
            #  */
            
            filters = []
            filters.append(v_m_nbsi.model_class.new_biz_sys_project_code == r['new_biz_sys_project_code'])
            filters = and_(*filters)
            tmp_v_m_nbsi = v_m_nbsi._get_item_by_filters(filters)
            if tmp_v_m_nbsi:
                # // 同じ契約ID、プロジェクト種類の場合は「プロジェクトコード」以外を更新
                if r['contract_id'] == tmp_v_m_nbsi.contract_id and \
                    r['new_biz_sys_project_type'] == tmp_v_m_nbsi.new_biz_sys_project_type:
                    pass
                else:
                    raise CustomException('MNBSI_CSV_ERR_107', r['new_biz_sys_project_code'])
                
            pass
        
            # // 売上区分ID
            v_m_nbsi = VMNBSI()
            filters = []
            filters.append(v_m_nbsi.model_class.company_code == r['company_code'])
            filters.append(v_m_nbsi.model_class.sales_category_id == r['sales_category_id'])
            filters = and_(*filters)
            tmp_v_m_nbsi = v_m_nbsi._get_item_by_filters(filters)
            if tmp_v_m_nbsi:
                # // 同じ契約ID、プロジェクト種類の場合は「プロジェクトコード」以外を更新
                if r['contract_id'] == tmp_v_m_nbsi.contract_id and \
                    r['new_biz_sys_project_type'] == tmp_v_m_nbsi.new_biz_sys_project_type:
                    pass
                else:
                    raise CustomException('MNBSI_CSV_ERR_108', [r['company_code'], r['sales_category_id'], r['案件番号'], r['new_biz_sys_project_type']])
                
            pass
        
            #   // ・同じ契約ID、プロジェクト種類のレコードがすでにある場合は
            #   // 　そのレコードの契約番号、契約開始日、契約終了日、PJコードを上書きする。
            #   // 　無い場合は新規登録。
            #   // ・契約IDは「案件番号」から取得する。
            #   // ・新規登録時は契約IDから企業コード、プロジェクト種類から売上区分IDを取得する。
            v_m_nbsi = VMNBSI()
            filters = []
            filters.append(v_m_nbsi.model_class.contract_id == r['contract_id'])
            filters.append(v_m_nbsi.model_class.new_biz_sys_project_type == r['new_biz_sys_project_type'])
            filters = and_(*filters)
            tmp_v_m_nbsi = v_m_nbsi._get_item_by_filters(filters)
                      
            if tmp_v_m_nbsi:
                
                r['new_biz_sys_info_id'] = tmp_v_m_nbsi.new_biz_sys_info_id
                
                tmp = m_nbsi._update(r)
                r = tmp.to_dict()

                # 更新件数
                if r['new_biz_sys_info_id'] not in cnt_upd:
                    cnt_upd.append(r['new_biz_sys_info_id'])
                                
                pass
            else:

                tmp = m_nbsi._add(r)
                r = tmp.to_dict()
                
                # 新規追加件数
                if r['new_biz_sys_info_id'] not in cnt_ins:
                    cnt_ins.append(r['new_biz_sys_info_id'])
                    
                pass
            
            pass
        
        #   // 一括取り込み成功後
        #   // 同じ契約IDで契約番号、プロジェクト種類、PJコード等が空の場合はレコードを削除
        for c_id in arr_contract_id:

            filters = []
            filters.append(v_m_nbsi.model_class.contract_id == c_id)
            filters.append(or_(v_m_nbsi.model_class.new_biz_sys_contract_number == '', v_m_nbsi.model_class.new_biz_sys_contract_number == (None)))
            filters.append(or_(v_m_nbsi.model_class.new_biz_sys_project_code == '', v_m_nbsi.model_class.new_biz_sys_project_code == (None)))
            filters.append(or_(v_m_nbsi.model_class.new_biz_sys_project_type == '', v_m_nbsi.model_class.new_biz_sys_project_type == (None)))
            filters = and_(*filters)
            tmp_v_m_nbsi = v_m_nbsi._get_item_by_filters(filters)
            if tmp_v_m_nbsi:

                m_nbsi._delete(tmp_v_m_nbsi.to_dict())
        
        pass
    
        # # // ・処理終了時に新規追加件数と更新件数をメッセージ表示する。
        # msg = '連携ファイル取り込み処理が完了しました。'
        # msg += '新規追加件数：' + str(len(cnt_ins))
        # msg += '更新件数：' + str(len(cnt_upd))
        msg = {
            'cnt_ins': cnt_ins,
            'cnt_upd': cnt_upd
        }
        
        print(datetime.now())
        print('bulk_insert -------------------------------end')
        
        return msg