from .controller import Base, CustomException, GV, os, logging, json, and_
import boto3

logger = logging.getLogger(__name__)


class Sub(Base):

    table_name = 'document_request'

    def get_all(self, event, context):

        VDR = GV.get_module('view_document_request')
        v_dr = VDR()

        return v_dr.get_all(event, context)

        pass

    def get_table_schema(self):

        VDR = GV.get_module('view_document_request')
        v_dr = VDR()

        v_dr.table_config = self.table_name
        return v_dr.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        try:

            if GV.EVENT_BODY is None:
                raise CustomException('SYS_ERR_100')

            data = GV.EVENT_BODY

            logger.debug('# ******************************')

            logger.debug('# アカウントがあり、ログインした場合')          
        
            data_t_mr = None
   
            if GV.LOGGEDIN_USER:

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': GV.LOGGEDIN_USER['sub'],
                    }
                }

                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            logger.debug('******************************')

            data_t_dr = {}
            # 資料請求ID
            # data_t_dr['document_req_id'] = data['document_req_id']
            # システムID
            data_t_dr['system_id'] = GV.SYSTEM_ID
            # サービスID
            data_t_dr['service_id'] = GV.SERVICE_ID

            # 企業コード
            if data_t_mr is not None:
                data_t_dr['company_code'] = data_t_mr['company_code']
            
            # 会社名
            data_t_dr['company_name'] = data['company_name']
            # 電話番号
            data_t_dr['telephone_number'] = data['telephone_number']
            # 氏名（姓）
            data_t_dr['last_name'] = data['last_name']
            # 氏名（名）
            data_t_dr['first_name'] = data['first_name']
            # メールアドレス
            data_t_dr['email_address'] = data['email_address']
            # # 登録日時
            # data_t_dr['cdate'] = data['cdate']
            # # 更新日時
            # data_t_dr['udate'] = data['udate']

            logger.debug('# データを検証する。')
            res_validate = self.validate('t_document_request', data_t_dr)
            if res_validate != True:
                return res_validate

            # t_document_request
            # from ..model.t_document_request import Sub as TDR
            # t_dr = TDR()
            TDR = GV.get_module('t_document_request')
            t_dr = TDR()
            
            tmp_t_dr = t_dr._add(data_t_dr)

            if tmp_t_dr:
                logger.debug(tmp_t_dr.to_dict())
                # return {
                #     # 'body': json.dumps(tmp_t_dr.to_dict())
                #     'body': tmp_t_dr.to_dict()
                # }
                pass
            else:
                raise CustomException('SYS_ERR_100')
                pass

            # logger.debug('# ******************************7')
            # logger.debug('# テーブル「申込管理情報」にデータ登録')
            # logger.debug('# t_manage_request')

            # # from ..model.t_manage_request import Sub as TMR
            # # t_mr = TMR()
            # TMR = GV.get_module('t_manage_request')
            # t_mr = TMR()

            # logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
            # logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

            # params = {
            #     'table_name': 't_manage_request',
            #     'filters': {
            #         'system_id': GV.SYSTEM_ID,
            #         'service_id': GV.SERVICE_ID,
            #         'auth0_user_id': data['auth0_user_id']
            #     }
            # }
            # data_t_mr = self.get_data(params)

            # if data_t_mr:
            #     logger.debug('# 存在する場合、どうする？')
            #     logger.debug('# ???')
                
            #     # トライアル申込ID
            #     data_t_mr['trial_req_id'] = data['trial_req_id']

            #     logger.debug('# データ更新')
            #     tmp_t_mr_1 = t_mr._update(data_t_mr)

            #     if tmp_t_mr_1:
            #         data_t_mr_1 = tmp_t_mr_1.to_dict()
            #         logger.debug(data_t_mr_1)
            #         pass
            #     else:
            #         raise CustomException('SYS_ERR_100')
            #         pass
                
            #     pass
            # else:
            #     logger.debug('# 存在しない場合、データを登録')

            #     data_t_mr = {}
            #     # # 申込管理ID
            #     # data_t_mr['manage_req_id'] =
            #     # 企業コード
            #     data_t_mr['company_code'] = data_m_tes['trial_company_code']
            #     # システムID
            #     data_t_mr['system_id'] = GV.SYSTEM_ID
            #     # サービスID
            #     data_t_mr['service_id'] = GV.SERVICE_ID
            #     # # 契約ID
            #     # data_t_mr['contract_id'] =
            #     # Auth0ユーザーID
            #     data_t_mr['auth0_user_id'] = data['auth0_user_id']
            #     # # 資料請求ID
            #     # data_t_mr['document_req_id'] =
            #     # # トライアル環境ストックID
            #     # data_t_mr['trial_env_stock_id'] = trial_env_stock_id
            #     # トライアル申込ID
            #     data_t_mr['trial_req_id'] = data['trial_req_id']
            #     # # ワークショップ申込ID
            #     # data_t_mr['workshop_req_id'] =
            #     # # 本契約申込ID
            #     # data_t_mr['contract_req_id'] =
            #     # # 担当営業コード
            #     # data_t_mr['salesman_code'] =
            #     # システム利用可能フラグ
            #     # ???
            #     data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG[
            #         '使用不可(申込情報の変更が将来的には使用可能)']
            #     # ステータス
            #     data_t_mr['status'] = ''  # ??? ステータスはどう決まる？
            #     # # 作成日時
            #     # data_t_mr['cdate'] =
            #     # # 更新日時
            #     # data_t_mr['udate'] =

            #     logger.debug('# データ登録')
            #     tmp_t_mr_1 = t_mr._add(data_t_mr)

            #     if tmp_t_mr_1:
            #         data_t_mr_1 = tmp_t_mr_1.to_dict()
            #         logger.debug(data_t_mr_1)
            #         pass
            #     else:
            #         raise CustomException('SYS_ERR_100')
            #         pass

            # logger.debug('# ##############################')

            logger.debug('# 資料請求完了連絡 メール送信')
            # self.send_email_document_request(data)
            
            data_email = {}
            data_email['service_id'] = GV.SERVICE_ID
            data_email['mail_type'] = '資料請求申込のお礼'
            data_email['email_address'] = data['email_address']
            data_email['company_name'] = data['company_name']
            data_email['last_name'] = data['last_name']
            data_email['first_name'] = data['first_name']
            data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

            self.send_email_document(data_email)
                
        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

        return {
            # 'statusCode': 200,
            # 'body': json.dumps(tmp_t_dr.to_dict())
            'body': ''
        }
        pass

    def send_email_document_request(self, data):
        print('*******************************')
        print('send_email_document_request')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            mail_parameter['to_address'].append(data['email_address'])

            print('mail_parameter ----------------')
            print(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == GV.SERVICE_ID)  # ???
            filters.append(m_sm.model_class.mail_type == '資料請求申込のお礼')
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                print(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            print(mail_template)
            print(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
        finally:
            pass
            print('---------------------------------')

    def send_email_document(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_document')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id']) 
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')


    # 資料ファイルのURLを取得する
    def get_file_urls(self):

        # from ..model.m_file_manage import Sub as MFM
        # m_fm = MFM()
        MFM = GV.get_module('m_file_manage')
        m_fm = MFM()

        filters = []
        filters.append(m_fm.model_class.system_id == GV.SYSTEM_ID)
        filters.append(m_fm.model_class.service_id == GV.SERVICE_ID)
        # filters.append(m_fm.model_class.file_type == 'document')
        filters = and_(*filters)
        
        tmp_m_fm = m_fm._get_item_by_filters(filters, get_all=True)

        data_m_fm = []
        for t in tmp_m_fm:
            d = t.to_dict()
            
            del d['file_manage_id']
            del d['file_no']
            del d['file_type']
            del d['system_id']
            del d['service_id']
            del d['cdate']
            del d['udate']

            data_m_fm.append(d)
        
        return data_m_fm
    
        pass
    
    # jsonファイルの取得
    def get_jsonFile(self,data):
        print('get_jsonFile!!!')
        # print(self)
        # print(data)
        data_dict = json.loads(data)

        try:
          productFileArr1 = []
          productFileArr2 = []
          lenI = 0
          
          if (data_dict['company_name_for_sub_dir'] != '') and data_dict['company_name_for_sub_dir'] != None:

              # DB m_contract
              # 申込ポータルサイトjsonのproductFileを取得。
              #   result = self.setect_infrastructure_m_entry_site_app_settings_confirmed()
              result = self.setect_infrastructure_m_entry_site_app_settings_confirmed(data_dict['company_name_for_sub_dir'])
              
              rows = result
            #   print(rows)
              
              for item in rows:
                if item['app_display_flag']:
                    lenI = lenI + 1
                    dataItem1 = self.data_productFilejson(item,lenI)
                    productFileArr1.append(dataItem1)
                    
                    dataItem = self.data_surveysArrjson(item)
                    
                    dataItem1 = self.data_downloadArrjson(item)
    
                    dataItem2 = self.data_productFiletArrjson(item,dataItem,dataItem1,lenI)
                    productFileArr2.append(dataItem2)
              pass
      
        except Exception as e:
          print(e)
          # 例外の再送出
          raise
        finally:
          print('# ##############################')
          
        return {'productFileBody': json.loads(json.dumps(productFileArr1))
            ,'productFileArrBody': json.loads(json.dumps(productFileArr2))
        }

    # jsonファイルの取得
    def data_productFilejson(self,item,intI):
        print('data_productFilejson!!!')
        try:
            record = {
              'no': intI,
              'id': item['id'],
              'fileName': item['filename'],
              'showName': item['app_display_name'],
              'company_name_for_sub_dir': item['company_name_for_sub_dir'],
              'tab_string': item['tab_string'],
              'tab_favicon_url': item['tab_favicon_url'],
              'header_image_url': item['header_image_url'],
              'site_title': item['site_title'],
              'site_desctiption': item['site_desctiption'],
              'site_back_image_url': item['site_back_image_url'],
              'fotter_company_name': item['fotter_company_name'],
              'fotter_copyright': item['fotter_copyright'],
              'handling_of_personal_information_file_url': item['handling_of_personal_information_file_url']
            }
            # print(record)
            
            return  record
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
            
    # jsonファイルの取得
    def data_productFiletArrjson(self,item,item1,item2,intI):
        print('data_productFiletArrjson!!!')
        try:
            record = {
              "home": [
                {
                  "home_img": {
                    "img_src": item['top_app_image_url'],
                    "img_text1": item['top_app_description'],
                  },
                  "home_btn":self.get_home_btn(item)
                }
              ],
              "資料請求": {
                "情報入力": {
                  "top_message": item['document_request_descritpion'],
                  "workshop_application_completed": item['workshop_application_completed'],
                  "documentArr": item2
                }
              },
              "トライアル申し込み": {
                "情報入力": {
                  "top_message": item['trial_description'],
                  "trial_application_completed": item['trial_application_completed'],

                },
                "controls": [
                  {
                    "id": 1,
                    "label": "氏名（姓）",
                    "type": "text",
                    "value": "",
                    "need": "true",
                    "dbid": "name_last"
                  },
                  {
                    "id": 2,
                    "label": "氏名（名）",
                    "type": "text",
                    "value": "",
                    "need": "true",
                    "dbid": "name_first"
                  },
                  {
                    "id": 3,
                    "label": "会社メールアドレス",
                    "type": "text",
                    "value": "",
                    "need": "true",
                    "dbid": "email"
                  },
                  {
                    "id": 4,
                    "label": "電話番号",
                    "type": "text",
                    "value": "",
                    "need": "false",
                    "dbid": "tel"
                  },
                  {
                    "id": 5,
                    "label": "会社名",
                    "type": "text",
                    "value": "",
                    "need": "true",
                    "dbid": "company_name"
                  },
                  {
                    "id": 6,
                    "label": "プライバシーポリシーに同意する",
                    "type": "checkboxhref",
                    "href": "https://www.ndes.co.jp/privacy/",
                    "checked": "false"
                  }
                ]
              },
              "ワークショップの申し込み": {
                "情報入力": {
                  "top_message": item['workshop_description'],
                  "workshop_application_completed": item['workshop_application_completed'],
                },
                "surveys": item1['productFileBody']
              },
              "利用申し込み": {
                "情報入力": {
                  "contract_description": item['contract_description'],
                #   "contract_terms_text": item['contract_terms_text'],
                  "contract_application_completed": item['contract_application_completed'],
                  "contract_terms_file_url": item['contract_terms_file_url'],
                  "billing_identifierList": item['billing_identifierList'],
                  "listOptionsShow": item['listOptionsShow'],
                  "payment_method_explanation_image_url": item['payment_method_explanation_image_url'],
                  "use_gmo_payment": item['use_gmo_payment']
                }
              },
            }
            
            # print(record)
            
            return  {item['id']:record}
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
            
    # json home_btnの取得
    def get_home_btn(self,item):
        print('get_home_btn!!!')
        # print(self)
        try:
            home_btn = []
            if item['top_document_request_btn_flag']:
                record = {
                  'btn': '資料請求',
                  'value': 'download',
                  'show': item['top_document_request_btn_flag'],
                }
                home_btn.append(record)
            if item['top_trial_btn_flag']:
                record = {
                  'btn': '無料トライアル申し込み',
                  'value': 'trial',
                  'show': item['top_trial_btn_flag'],
                }
                home_btn.append(record)
            if item['top_workshop_btn_flag']:
                record = {
                  'btn': 'ワークショップ申し込み',
                  'value': 'workshop',
                  'show': item['top_workshop_btn_flag'],
                }
                home_btn.append(record)
            if item['top_contract_btn_flag']:
                record = {
                  'btn': '利用申し込み',
                  'value': 'entry',
                  'show': item['top_contract_btn_flag'],
                }
                home_btn.append(record)

            return  home_btn
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
        
    # json surveys 申込ポータルサイトアンケート確定管理の取得
    def data_surveysArrjson(self,item):
        print('data_surveysArrjson!!!')
        # print(self)
        
        try:
          productFileArr1 = []
          lenI = 0
          print('# ##############################')
          
          # DB m_contract
          # 申込ポータルサイトアンケートjsonのsurveysを取得。
        #   result = self.setect_infrastructure_m_entry_site_questionnaire_manage_confirmed(item)
          rows = self.setect_infrastructure_m_entry_site_questionnaire_manage_confirmed(item)
          

          for item in rows:
            print(item)
            lenI = lenI + 1
            dataItem1 = self.data_surveysFilejson(item,lenI)
            productFileArr1.append(dataItem1)
            
        #   print('||||||||||||||3')
        #   print(productFileArr1)
          
          pass
      
        except Exception as e:
          print(e)
          # 例外の再送出
          raise
        finally:
          print('# ##############################')
          
        return {'productFileBody': json.loads(json.dumps(productFileArr1))}
    
    
    # json surveys 申込ポータルサイト申込ポータルサイト資料請求確定管理の取得
    def data_downloadArrjson(self,item):
        print('data_downloadArrjson!!!')
        # print(self)
        
        try:
          productFileArr1 = []
          lenI = 0
          print('# ##############################')
          
          # DB m_contract
          # ト申込ポータルサイト資料請求確定管理トを取得。
        #   result = self.setect_infrastructure_m_entry_site_document_request_manage_confirmed(item)
          rows = self.setect_infrastructure_m_entry_site_document_request_manage_confirmed(item)
          

          for item in rows:
            # print(item)
            dataItem = self.data_documentjson(item)
            productFileArr1.append(dataItem)
            
        #   print('||||||||||||||4')
        #   print(productFileArr1)
          pass
      
        except Exception as e:
          print(e)
          # 例外の再送出
          raise
        finally:
          print('# ##############################')
          
        return {'downloadBody': json.loads(json.dumps(productFileArr1))}
    
    # jsonファイルの取得
    def data_documentjson(self,item):
        print('data_documentjson!!!')
        try:
            record = {
              'system_id': item['system_id'],
              'document_request_file_title': item['document_request_file_title'],
              'document_request_file_description': item['document_request_file_description'],
              'document_request_file_image_url': item['document_request_file_image_url'],
              'document_request_file_url': item['document_request_file_url'],
            }
            return  record
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
            
    # jsonファイルの取得
    def data_surveysFilejson(self,item,intI):
        print('data_surveysFilejson!!!')
        try:
            survey_answerData = None
            if item['questionnaire_anser_type'] == 'checkbox':
                survey_answerData = []
            else:
                survey_answerData = ''
            record = {
              'survey_number': intI,
              'survey_question': item['questionnaire_question'],
              'survey_answer_options': self.datasurvey_answer_options(item['questionnaire_answer_choices']),
              'type': item['questionnaire_anser_type'],
              'required': item['required'],
              'survey_answer': survey_answerData,
            }
            # print('||||||||||||||2')
            # print(record)
            return  record
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
            
    # jsonファイルの取得
    def datasurvey_answer_options(self,str1):
        print('datasurvey_answer_options!!!')
        arrData = []
        retArrData = []
        try:
            if (str1 is not None):
                arrData = str1.split('|')
                for strLab in arrData:
                    record = {
                      'label': strLab,
                      'value': strLab,
                    }
                    retArrData.append(record)
                # print('||||||||||||||1')
                # print(retArrData)
            return  retArrData
      
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        finally:
            print('# ##############################')
         
    #  Db m_entry_site_app_settings_confirmedデータを取得する。
    def setect_infrastructure_m_entry_site_app_settings_confirmed(self,sys_id):
        print('setect_infrastructure_m_entry_site_app_settings_confirmed!!!')
        
        res = {}
    
        try:
            
            VARISUB = GV.get_module('view_company_name_for_sub_dir_list')
            v_sys_list = VARISUB()

            print(sys_id)

            filters = [] 
            filters.append(v_sys_list.model_class.company_name_for_sub_dir == sys_id)
            filters = and_(*filters)

            items_sys = v_sys_list._get_item_by_filters(filters, get_all=True)
 
            ditemArr = []

            for t in items_sys:
                ditemSys = t.to_dict()
                ditemArr.append(ditemSys['system_id'])
                
            # print("||||ditemArr2|||||")
            # print(ditemArr)
            
            VPG = GV.get_module('view_product_groups_billing_identifier')
            v_pg = VPG()

            filters = []
            filters = and_(*filters)

            items1 = v_pg._get_item_by_filters(filters, get_all=True)

            data_arr1 = []

            for t1 in items1:
                ditem = t1.to_dict()
                user_info = {
                    'product_group_id': ditem['product_group_id'],
                    'billing_identifier': ditem['billing_identifier'],
                    'main_product_id': ditem['main_product_id'],
                    'product_group_id': ditem['product_group_id'],
                    'system_id': ditem['system_id'],
                    'service_id': ditem['service_id'],
                }
                data_arr1.append(user_info)
                
            # print("||||ditemArr3|||||")
            # print(data_arr1)

            
            VARI = GV.get_module('view_entry_site_app_settings_confirmed')
            v_sys = VARI()

            filters = []
            filters.append(v_sys.model_class.company_name_for_sub_dir == sys_id)
            filters = and_(*filters)

            items = v_sys._get_item_by_filters(filters, get_all=True)

            data_arr = []

            for t in items:
                ditem = t.to_dict()
                if (ditem['system_id'] in ditemArr):
                    # -----------------バグ #6076-------------S
                    data_arr2 = []
                    for t1 in data_arr1:
                        print("---ditem1---")
                        print(t1)
                        if (t1['system_id'] == ditem['system_id']):
                            data_arr2.append(t1)
                    print("||||ditemArr4|||||")
                    print(data_arr2)
                    # -----------------バグ #6076-------------E
                    user_info = {
                        'entry_site_app_setting_id': ditem['entry_site_app_setting_id'],
                        'supplier_id': ditem['supplier_id'],
                        'system_id': ditem['system_id'],
                        'app_display_flag': ditem['app_display_flag'],
                        'app_display_name': ditem['app_display_name'],
                        # 'handling_of_personal_information': ditem['handling_of_personal_information'],
                        'top_app_description': ditem['top_app_description'],
                        'top_document_request_btn_flag': ditem['top_document_request_btn_flag'],
                        'top_trial_btn_flag': ditem['top_trial_btn_flag'],
                        'top_workshop_btn_flag': ditem['top_workshop_btn_flag'],
                        'top_contract_btn_flag': ditem['top_contract_btn_flag'],
                        'document_request_descritpion': ditem['document_request_descritpion'],
                        'trial_description': ditem['trial_description'],
                        'trial_application_completed': ditem['trial_application_completed'],
                        'workshop_description': ditem['workshop_description'],
                        'workshop_application_completed': ditem['workshop_application_completed'],
                        'workshop_questionnaire_description': ditem['workshop_questionnaire_description'],
                        'contract_description': ditem['contract_description'],
                        # 'contract_terms_text': ditem['contract_terms_text'],
                        'contract_application_completed': ditem['contract_application_completed'],
                        'cdate': ditem['cdate'],
                        'udate': ditem['udate'],
                        'top_app_image_url': ditem['top_app_image_url'],
                        'contract_terms_file_url': ditem['contract_terms_file_url'],
                        'id': ditem['id'],
                        'filename': ditem['filename'],
                        'entry_site_app_setting_registration_code': ditem['entry_site_app_setting_registration_code'],
                        'handling_of_personal_information_file_url': ditem['handling_of_personal_information_file_url'],
                        'company_name_for_sub_dir': ditem['company_name_for_sub_dir'],
                        'tab_string': ditem['tab_string'],
                        'tab_favicon_url': ditem['tab_favicon_url'],
                        'header_image_url': ditem['header_image_url'],
                        'site_title': ditem['site_title'],
                        'site_desctiption': ditem['site_desctiption'],
                        'site_back_image_url': ditem['site_back_image_url'],
                        'fotter_company_name': ditem['fotter_company_name'],
                        'fotter_copyright': ditem['fotter_copyright'],
                        # -----------------バグ #6076-------------S
                        'billing_identifierList': data_arr2,
                        # -----------------バグ #6076-------------E
                        'listOptionsShow': '',
                        'payment_method_explanation_image_url': ditem['payment_method_explanation_image_url'],
                        'use_gmo_payment': ditem['use_gmo_payment']
                    }
                    data_arr.append(user_info)
   
            res = items
    
            # レスポンス読出し
            Payload = data_arr
            print("---01: body:", Payload)
            res = Payload
    
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
    
        return res
    
    #  Db m_entry_site_questionnaire_manage_confirmedデータを取得する。
    def setect_infrastructure_m_entry_site_questionnaire_manage_confirmed(self,item):
        print('setect_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')
        
        res = {}
    
        try:
            
            VARI = GV.get_module('view_entry_site_questionnaire_manage_confirmed')
            v_sys = VARI()

            filters = []
            filters.append(v_sys.model_class.system_id == item['system_id'])
            filters = and_(*filters)

            items = v_sys._get_item_by_filters(filters, get_all=True)

            data_arr = []

            for t in items:
                ditem = t.to_dict()
                user_info = {
                    'system_id': ditem['system_id'],
                    'questionnaire_location': ditem['questionnaire_location'],
                    'questionnaire_question': ditem['questionnaire_question'],
                    'questionnaire_answer_choices': ditem['questionnaire_answer_choices'],
                    'required': ditem['required'],
                    'questionnaire_anser_type': ditem['questionnaire_anser_type']
                }
                data_arr.append(user_info)
   
            res = items
    
            # レスポンス読出し
            Payload = data_arr
            print("---01: body:", Payload)
            res = Payload
    
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
    
        return res

    #  Db setect_infrastructure_m_entry_site_document_request_manage_confirmed。
    def setect_infrastructure_m_entry_site_document_request_manage_confirmed(self,item):
        print('setect_infrastructure_m_entry_site_document_request_manage_confirmed!!!')
        
        res = {}
    
        try:
            
            VARI = GV.get_module('view_entry_site_document_request_manage_confirmed')
            v_sys = VARI()

            filters = []
            filters.append(v_sys.model_class.system_id == item['system_id'])
            filters = and_(*filters)

            items = v_sys._get_item_by_filters(filters, get_all=True)

            data_arr = []

            for t in items:
                ditem = t.to_dict()
                user_info = {
                    'system_id': ditem['system_id'],
                    'document_request_file_title': ditem['document_request_file_title'],
                    'document_request_file_description': ditem['document_request_file_description'],
                    'document_request_file_image_url': ditem['document_request_file_image_url'],
                    'document_request_file_url': ditem['document_request_file_url']
                }
                data_arr.append(user_info)
   
            res = items
    
            # レスポンス読出し
            Payload = data_arr
            print("---01: body:", Payload)
            res = Payload
    
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
    
        return res

    #  Db get_m_entry_site_app_settings_confirmedデータを取得する。
    def get_m_entry_site_app_settings_confirmed(self,data):
        print('get_m_entry_site_app_settings_confirmed!!!')
        # print(data)
        data_dict = json.loads(data)

        try:
          print('# ##############################')
          if (data_dict['company_name_for_sub_dir'] != '') and data_dict['company_name_for_sub_dir'] != None:
              # DB m_contract
              # 申込ポータルサイトjsonのproductFileを取得。
              result = self.setect_infrastructure_m_entry_site_app_settings_confirmed_sql(data_dict['company_name_for_sub_dir'])
              
              pass
      
        except Exception as e:
          logger.debug(e)
          # 例外の再送出
          raise
        finally:
          print('# ##############################')
          
          result = json.loads(json.dumps(result))
          
        return result
        
    #  Db m_entry_site_app_settings_confirmedデータを取得する。
    def setect_infrastructure_m_entry_site_app_settings_confirmed_sql(self,sys_id):
        print('setect_infrastructure_m_entry_site_app_settings_confirmed_sql!!!')
        
        res = {}
    
        try:

            VARISUB = GV.get_module('view_company_name_for_sub_dir_list')
            v_sys_list = VARISUB()

            print(sys_id)

            filters = [] 
            filters.append(v_sys_list.model_class.company_name_for_sub_dir == sys_id)
            filters = and_(*filters)

            items_sys = v_sys_list._get_item_by_filters(filters, get_all=True)
 
            ditemArr = []

            for t in items_sys:
                ditemSys = t.to_dict()
                ditemArr.append(ditemSys['system_id'])
                
            # print("||||ditemArr1|||||")
            # print(ditemArr)
            

            VARI = GV.get_module('view_entry_site_app_settings_confirmed')
            v_sys = VARI()

            filters = []
            filters.append(v_sys.model_class.company_name_for_sub_dir == sys_id)
            filters = and_(*filters)

            items = v_sys._get_item_by_filters(filters, get_all=True)

            data_arr = []

            for t in items:
                ditem = t.to_dict()
                if (ditem['system_id'] in ditemArr):
                    user_info = {
                        'system_id': ditem['system_id'],
                        'sub_domain_name': ditem['sub_domain_name'],
                        'top_document_request_btn_flag': ditem['top_document_request_btn_flag'],
                        'top_trial_btn_flag': ditem['top_trial_btn_flag'],
                        'top_workshop_btn_flag': ditem['top_workshop_btn_flag'],
                        'top_contract_btn_flag': ditem['top_contract_btn_flag']
                    }
                    data_arr.append(user_info)
   
            res = items
    
            # レスポンス読出し
            Payload = data_arr
            print("---01: body:", Payload)
            res = Payload
    
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
    
        return res




        try:

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/email/send',
                'body': json.dumps(
                    {
                        'from_address': from_address,
                        'to_address': to_address,
                        'cc_address': cc_address,
                        'bcc_address': bcc_address,
                        'title': title,
                        'message': message
                    }
                )
            }

            Payload = json.dumps(input_event, ensure_ascii=False)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            if DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_EMAIL,
                    # InvocationType='RequestResponse',
                    InvocationType='Event',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)
                # response = {}

                res = response

                # if 'StatusCode' in response and response['StatusCode'] == 200:

                #     # レスポンス読出し
                #     Payload = json.loads(response['Payload'].read())
                #     logger.debug("---03: body:")
                #     logger.debug(Payload)
                #     res = Payload

            return res
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')