from .controller import Base, CustomException, GV, logging, and_, datetime, json, boto3, date, timedelta, asc

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)


class Sub(Base):

    table_name = 'contract'

    def get_all(self, event, context):

        VC = GV.get_module('view_contract')
        v_c = VC()

        return v_c.get_all(event, context)

        pass

    def get_table_schema(self):

        VC = GV.get_module('view_contract')
        v_c = VC()

        v_c.table_config = self.table_name
        # --> 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
        if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
            v_c.table_config = 'contract_supplier'
        # <-- 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
        return v_c.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        logger.debug('# contract add')

        try:

            if GV.EVENT_BODY is None:
                raise CustomException('SYS_ERR_100')
                
            logger.debug('# ************0704******************') 
            if "tenant" in GV.EVENT_BODY:
                params = {
                    'table_name': 'm_auth0_management',
                    'filters': {
                        'tenant': GV.EVENT_BODY["tenant"]
                    }
                }
                data_m_am = self.get_data(params)
                logger.debug(data_m_am)
    
                if data_m_am:
                    logger.debug('# ************Auth0情報を設定する******************')
                    GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                    GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                    GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                    GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                    GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                    GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                    logger.debug(GV.CONFIG)
                    pass
                else:
                    return {"error": "tenant:" + GV.EVENT_BODY["tenant"] + " は存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 

            data = GV.EVENT_BODY

            is_not_request_user = False

            logger.debug('# ******************************')

            data_t_crh = None

            if '# データを検証する。':

                logger.debug('# データを検証する。')

                data_t_crh = {}
                data_t_crh = data.copy()

                data_t_crh['entry_code'] = self.generate_entry_code()

                data_t_crh['contract_req_id'] = None
                data_t_crh['system_id'] = GV.SYSTEM_ID
                data_t_crh['service_id'] = GV.SERVICE_ID
                data_t_crh['cdate'] = None
                data_t_crh['udate'] = None

                logger.debug('# 本契約申込履歴')
                res_validate = self.validate(
                    't_contract_request_history', data_t_crh)
                if res_validate != True:
                    return res_validate

            logger.debug('# ##############################')

            auth0_user = None

            if GV.LOGGEDIN_USER:
                logger.debug('# アカウントがあり、ログインした場合')
                pass
            else:
                logger.debug('# ログインしてない場合')

                logger.debug('# ******************************')
                logger.debug('# 申込のメールアドレスのAuth0アカウントが存在するかどうかチェックする')

                auth0_class = GV.get_module_auth0()
                a0 = auth0_class()

                users = a0._get_users_by_email(data['contract_email_address'])

                if users and len(users) > 0:
                    # 存在する場合

                    auth0_user = users[0]
                    logger.debug('auth0_user')
                    logger.debug(auth0_user)

                    logger.debug('存在する場合')
                    if auth0_user['email_verified']:

                        is_request_user = False
                        if 'user_metadata' in auth0_user:
                            if 'data' in auth0_user['user_metadata']:
                                for d in auth0_user['user_metadata']['data']:
                                    if 'roles' in d:
                                        if 'request_user' in d['roles']:
                                            is_request_user = True
                                            break

                        if is_request_user == True:

                            # メールアドレス検証済の場合
                            # アカウント作成済みのメッセージを返し、
                            # クライアント側でログイン画面へ遷移するようにする
                            logger.debug('# メールアドレス検証済の場合')
                            logger.debug('# アカウント作成済みのメッセージを返し、')
                            logger.debug('# クライアント側でログイン画面へ遷移するようにする')

                            res = {}
                            res = GV.INFO_CODE['CONTRACT_I_ACCOUNT_ALREADY_EXISTS']
                            return res
                        else:

                            is_not_request_user = True

                        pass
                    else:
                        # メールアドレス未検証の場合
                        # 検証メールを再送信する
                        # ???
                        logger.debug('# メールアドレス未検証の場合')
                        logger.debug('# 検証メールを再送信する')

                        code = None
                        if 'app_metadata' in auth0_user:
                            if 'contrac_req_vefification_code' in auth0_user['app_metadata']:
                                code = auth0_user['app_metadata']['contrac_req_vefification_code']

                        if code is not None:
                            logger.debug('# 本契約申込情報がある場合')

                            logger.debug('# ******************************')
                            logger.debug('# 本契約申込完了連絡 本人認証とパスワード設定 メール送信')

                            data_email = {}
                            data_email['service_id'] = GV.SERVICE_ID
                            data_email['mail_type'] = '本人認証とパスワード設定'
                            data_email['email_address'] = data['contract_email_address']
                            data_email['company_name'] = data['company_name']
                            data_email['last_name'] = data['contract_last_name']
                            data_email['first_name'] = data['contract_first_name']
                            data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                            data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                            self.send_email_contract(data_email)

                            logger.debug('# ##############################')

                            return {}
                        pass
                else:
                    # 存在しない場合
                    # 処理継続
                    logger.debug('# 存在しない場合')
                    logger.debug('# 処理継続')

                    pass

                pass

                logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['contract_email_address']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスでプロセスのステータスが「本契約申込～本契約利用中」の場合：':

                logger.debug(
                    '# ・申込者が同じシステム＋サービスでプロセスのステータスが「本契約申込～本契約利用中」の場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                        data_t_mr['contract_req_id'] is not None:

                    if data_t_mr['status'] == GV.STATUS['本契約申請'] or \
                            data_t_mr['status'] == GV.STATUS['本契約受付'] or \
                            data_t_mr['status'] == GV.STATUS['本契約利用中']:

                        res = {}
                        res = GV.INFO_CODE['CONTRACT_I_ALREADY_COMPLETED']

                        logger.debug('# 本契約中')

                        logger.debug('# ******************************')
                        logger.debug('# 既に本契約中のためエラー 既に本契約中のためエラー メール送信')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['mail_type'] = '既に本契約中のためエラー'

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']
                        data_email['company_code'] = data_t_mr['company_code']
                        data_email['contract_last_name'] = data['contract_last_name']
                        data_email['contract_first_name'] = data['contract_first_name']
                        data_email['contract_affiliation_department'] = data['contract_affiliation_department']
                        data_email['contract_email_address'] = data['contract_email_address']
                        data_email['contract_telephone_number'] = data['contract_telephone_number']
                        data_email['status'] = data_t_mr['status']

                        self.send_email_contract(data_email)
                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスの他の申込中に本契約を申し込んだ場合：':

                logger.debug('# ・申込者が同じシステム＋サービスの他の申込中に本契約を申し込んだ場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                    (data_t_mr['trial_req_id'] is not None or
                        data_t_mr['workshop_req_id'] is not None):

                    if data_t_mr['status'] in GV.STATUS_APPLYING_TRIAL.keys() or \
                            data_t_mr['status'] in GV.STATUS_APPLYING_WORKSHOP.keys():

                        res = {}
                        res = GV.INFO_CODE['CONTRACT_I_ANOTHER_APPLYING']

                        logger.debug('# 他に申込中なのでエラー 本契約時、他に申込中のためエラー メール送信')

                        # logger.debug('# ******************************')
                        # logger.debug('# 他に申込中なのでエラー 本契約時、他に申込中のためエラー メール送信')

                        # data_email = {}
                        # data_email['service_id'] = GV.SERVICE_ID
                        # data_email['mail_type'] = '本契約時、他に申込中のためエラー'

                        # self.send_email_contract(data_email)
                        # logger.debug('# ##############################')

                        # logger.debug('# ******************************')

                        # data_user_info = None

                        # if '# ユーザー情報を取得する':

                        #     logger.debug('# ユーザー情報を取得する')

                        #     if data_t_mr['workshop_req_id'] is not None:
                                    
                        #         logger.debug('# 「ワークショップ申込情報（確認済み）」から情報を取得する')

                        #         params = {
                        #             'table_name': 't_workshop_request_confirmed',
                        #             'filters': {
                        #                 'workshop_req_id': data_t_mr['workshop_req_id']
                        #             }
                        #         }
                        #         data_t_wrc = self.get_data(params)
                        #         if data_t_wrc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_wrc['company_name']
                        #             data_user_info['company_code'] = data_t_wrc['company_code']
                        #             data_user_info['last_name'] = data_t_wrc['last_name']
                        #             data_user_info['first_name'] = data_t_wrc['first_name']
                        #             data_user_info['affiliation_department'] = data_t_wrc['affiliation_department']
                        #             data_user_info['email_address'] = data_t_wrc['email_address']
                        #             data_user_info['telephone_number'] = data_t_wrc['telephone_number']

                        #     elif data_t_mr['trial_req_id'] is not None:
                                    
                        #         logger.debug('# 「トライアル申込情報（確認済み）」から情報を取得する')

                        #         params = {
                        #             'table_name': 't_trial_request_confirmed',
                        #             'filters': {
                        #                 'trial_req_id': data_t_mr['trial_req_id']
                        #             }
                        #         }
                        #         data_t_trc = self.get_data(params)
                        #         if data_t_trc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_trc['company_name']
                        #             data_user_info['company_code'] = data_t_trc['company_code']
                        #             data_user_info['last_name'] = data_t_trc['last_name']
                        #             data_user_info['first_name'] = data_t_trc['first_name']
                        #             data_user_info['affiliation_department'] = ''
                        #             data_user_info['email_address'] = data_t_trc['email_address']
                        #             data_user_info['telephone_number'] = data_t_trc['telephone_number']

                        # logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']

                        # if data_user_info is not None:
                        #     data_email['company_code'] = data_user_info['company_code']
                        # else:
                        #     data_email['company_code'] = ''
                        data_email['company_code'] = data_t_mr['company_code']

                        data_email['contract_last_name'] = data['contract_last_name']
                        data_email['contract_first_name'] = data['contract_first_name']
                        data_email['contract_affiliation_department'] = data['contract_affiliation_department']
                        data_email['contract_email_address'] = data['contract_email_address']
                        data_email['contract_telephone_number'] = data['contract_telephone_number']

                        data_email['status'] = data_t_mr['status']

                        data_email['mail_type'] = '本契約時、他に申込中のためエラー'

                        self.send_email_contract(data_email)
                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# ・上記以外：申込完了画面を表示する。本人認証へ進む。')
            
            logger.debug('# ##############################')

            logger.debug('# ******************************')

            contract_req_id = None

            if '# テーブル「本契約申込履歴」にデータ登録する':

                logger.debug('# テーブル「本契約申込履歴」にデータ登録する')
                logger.debug('t_contract_request_history')

                TCRH = GV.get_module('t_contract_request_history')
                t_crh = TCRH()

                tmp_t_crh = t_crh._add(data_t_crh)

                if tmp_t_crh:
                    contract_req_id = tmp_t_crh.contract_req_id
                    data_t_crh1 = tmp_t_crh.to_dict()
                    logger.debug(data_t_crh1)
                else:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            if is_not_request_user:

                data_tr = {}
                data_tr['auth0_user_id'] = auth0_user['user_id']
                data_tr['contract_req_id'] = contract_req_id
                res = self.regist_contract_data(data_tr)

                pass

            elif GV.LOGGEDIN_USER:

                data_tr = {}
                data_tr['auth0_user_id'] = GV.LOGGEDIN_USER['sub']
                data_tr['contract_req_id'] = contract_req_id
                res = self.regist_contract_data(data_tr)

                pass
            else:
                import uuid
                code = str(uuid.uuid4())

                logger.debug('# 認証コード生成')
                
                logger.debug('# ************0704******************') 
                code = 'c-' + str(data_m_am['id']) + '-' + code
                logger.debug('# ************0704******************')

                if auth0_user is not None:
                    logger.debug('# Auth0アカウントがある場合')

                    logger.debug(auth0_user['app_metadata'])

                    app_metadata = auth0_user['app_metadata']

                    if 'data' not in app_metadata:
                        app_metadata['data'] = []

                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'contract_req_id': contract_req_id,
                            'contract_req_vefification_code': code,
                            'contract_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )

                    data_auth0 = {}
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# ******************************')
                    logger.debug('# atuh0 update')
                    a0._update(auth0_user['user_id'], data_auth0)
                    logger.debug('# ##############################')

                    pass
                else:
                    logger.debug('# Auth0アカウントがない場合')

                    app_metadata = {}
                    app_metadata['data'] = []
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'contract_req_id': contract_req_id,
                            'contract_req_vefification_code': code,
                            'contract_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )

                    data_auth0 = {}
                    data_auth0['email_address'] = data['contract_email_address']
                    data_auth0['app_metadata'] = app_metadata
                    data_auth0['tenant'] = data_t_crh['tenant']

                    logger.debug('# data_auth0')
                    logger.debug(data_auth0)

                    logger.debug('# ******************************')
                    logger.debug('# create_data_atuh0')
                    self.create_data_atuh0(data_auth0)
                    logger.debug('# ##############################')

                logger.debug('# ******************************')
                logger.debug('# 本契約申込完了連絡 本人認証とパスワード設定 メール送信')

                data_email = {}
                data_email['service_id'] = GV.SERVICE_ID
                data_email['mail_type'] = '本人認証とパスワード設定'
                data_email['email_address'] = data['contract_email_address']
                data_email['company_name'] = data['company_name']
                data_email['last_name'] = data['contract_last_name']
                data_email['first_name'] = data['contract_first_name']
                data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                self.send_email_contract(data_email)

                logger.debug('# ##############################')

                pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass

    # 更新する
    def update(self, event, context):

        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        logger.debug(data)

        self.update1(data)

        self.update2(data)

    # 更新する
    def update1(self, data=None):
        logger.debug('# ******************************')
        logger.debug('# update')
        logger.debug('# ##############################')
        try:

            # if GV.EVENT_BODY is None:
            #     raise CustomException('SYS_ERR_100')

            # data = GV.EVENT_BODY
            # logger.debug(data)

            dt_now = datetime.now()

            logger.debug('# ******************************')
            logger.debug('更新前のデータ取得')
            VC = GV.get_module('view_contract')
            v_c = VC()
            old_item = v_c._get_item_by_id(data)
            logger.debug(old_item)
            old_data = old_item.to_dict()
            logger.debug(old_data)
            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('サービスデータ取得')
            # サービスデータ取得
            # m_services

            item_service = None
            if data['service_id'] is not None:

                MSRV = GV.get_module('m_services')
                m_srv = MSRV()
                filters = []
                filters.append(m_srv.model_class.service_id ==
                               data['service_id'])
                filters = and_(*filters)
                tmp_m_srv = m_srv._get_item_by_filters(filters)
                if tmp_m_srv:
                    item_service = tmp_m_srv
                pass
            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug(
                '「契約情報:請求書の送付方法」で「郵送(書類)」を選択する場合は、事前に「サービス管理」アプリで「請求書の郵送手数料の商品ID」を設定してください。')

            print(data['gmo_invoice_mail'])
            if '# 「契約情報:請求書の送付方法」で「郵送(書類)」を選択する場合は、事前に「サービス管理」アプリで「請求書の郵送手数料の商品ID」を設定してください。':
                if data['status'] == '本契約受付' or \
                        data['status'] == "本契約利用中":
                    if data['gmo_invoice_mail'] == '郵送(書類)':
                        if item_service.handling_charge_product_id is None:
                            raise CustomException('CI_ERR_100')

            logger.debug('# ##############################')

            # m_update_company_info_history
            # 企業情報更新履歴取得
            logger.debug('# ******************************')
            logger.debug('企業情報更新履歴取得')

            if data['company_code'] is not None:

                # from ..model.m_update_company_info_history import Sub as MUCIH
                # m_ucih = MUCIH()
                MUCIH = GV.get_module('m_update_company_info_history')
                m_ucih = MUCIH()
                filters = []
                filters.append(m_ucih.model_class.company_code ==
                               data['company_code'])
                filters = and_(*filters)
                tmp_m_ucih = m_ucih._get_item_by_filters(filters)
                if tmp_m_ucih:
                    logger.debug(tmp_m_ucih.to_dict())
                pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('最初の企業情報登録かどうか')
            # フェーズ3で、企業データ登録のタイミングが変わるため、必要ないかも ???
            self.is_first_register = False
            logger.debug('# ##############################')

        # #   const resp1 = await myapp.methods.kintone.get_service_data(record["service_id"]["value"]);
        # #   if ("records" in resp1 && resp1["records"].length > 0) {
        # #   } else {
        # #     myapp.data.temp_error_title = "";
        # #     myapp.data.temp_error = "サービスデータ取得に失敗しました。";
        # #     myapp.methods.error.show_error();
        # #     return;
        # #   }
        # #   myapp.data.use_smartbilling = resp1["records"][0]["use_smartbilling"]["value"];
        #     logger.debug('# ******************************')
        #     # logger.debug('サービスデータ取得')
        #     # # サービスデータ取得
        #     # # m_services
        #     # if data['service_id'] is not None:
        #     #     from ..model.m_services import Sub as MSer
        #     #     m_ser = MSer()
        #     #     filters = []
        #     #     filters.append(m_ser.model_class.service_id ==
        #     #                    data['service_id'])
        #     #     filters = and_(*filters)
        #     #     tmp = m_ser._get_item_by_filters(filters)
        #     #     if tmp:
        #     #         self.use_smartbilling = tmp.use_smartbilling
        #     #         logger.debug(tmp.to_dict())
        #     #     pass
        #     if item_service:
        #         self.use_smartbilling = item_service.use_smartbilling
        #     logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('枠保証審査ステータス')
            # # 枠保証審査ステータス
            # if data['examination_status'] is not None:
            #     if self.diff_gmo_data(old_data, data):
            #         logger.debug('diff_gmo_data True')
            #         data['need_gmo_ps_creditfacility_modifybuyer'] = True
            #     else:
            #         logger.debug('diff_gmo_data False')
            #         data['need_gmo_ps_creditfacility_modifybuyer'] = False
            #     pass
            
            # https://redmine-comn.ndes-dx.com/issues/4078　　対応 20230921
            # if self.diff_gmo_data(old_data, data):
            #     logger.debug('diff_gmo_data True')
            #     data['need_gmo_ps_creditfacility_modifybuyer'] = True
            # else:
            #     logger.debug('diff_gmo_data False')
            #     data['need_gmo_ps_creditfacility_modifybuyer'] = False
            if data['need_gmo_ps_creditfacility_modifybuyer'] is None:
                data['need_gmo_ps_creditfacility_modifybuyer'] = False
                # 支払方法がGMO掛け払いの場合
                if data['payment_method'] is not None and data['payment_method'] == 'GMO掛け払い':
                    if self.diff_gmo_data(old_data, data):
                        logger.debug('diff_gmo_data True')
                        data['need_gmo_ps_creditfacility_modifybuyer'] = True
                    else:
                        logger.debug('diff_gmo_data False')
                        data['need_gmo_ps_creditfacility_modifybuyer'] = False
                else:
                    logger.debug('GMO掛け払い以外')
                
            # https://redmine-comn.ndes-dx.com/issues/4078　　対応 20230921
            
            pass
            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_com = None

            if '# 「m_company」を更新する':

                if self.diff_m_company_data(old_data, data):
                    logger.debug('diff_m_company_data True')

                    logger.debug('# 「m_company」を更新する')

                    MCOM = GV.get_module('m_company')
                    m_com = MCOM()

                    params_m_com = {}
                    # 企業コード
                    params_m_com['company_code'] = data['company_code']
                    #  企業名
                    params_m_com['company_name'] = data['company_name']
                    # 企業名(カナ)
                    params_m_com['company_name_kana'] = data['company_name_kana']
                    # 郵便番号
                    params_m_com['company_zipcode'] = data['company_zip_code']
                    #  住所(都道府県)
                    params_m_com['company_address_pref'] = data['company_address_pref']
                    # 住所1
                    params_m_com['company_address_1'] = data['company_address_1']
                    # 住所2
                    params_m_com['company_address_2'] = data['company_address_2']
                    # 住所3
                    params_m_com['company_address_3'] = data['company_address_3']
                    # 電話番号1
                    params_m_com['company_tel_1'] = data['company_telephone_number']
                    # 代表者名(姓)
                    params_m_com['company_leader_last'] = data['company_last_name']
                    # 代表者名(名)
                    params_m_com['company_leader_first'] = data['company_first_name']
                    # 代表者名(姓)(カナ)
                    params_m_com['company_leader_kana_last'] = data['company_last_name_kana']
                    # 代表者名(名)(カナ)
                    params_m_com['company_leader_kana_first'] = data['company_first_name_kana']
                    # 代表者の生年月日
                    params_m_com['company_leader_date_of_birth'] = data['company_leader_date_of_birth']
                    # 企業備考欄
                    params_m_com['customer_notes'] = data['company_remarks_column']
                    # GMO掛け払いのデータ更新あり
                    params_m_com['need_gmo_ps_creditfacility_modifybuyer'] = data['need_gmo_ps_creditfacility_modifybuyer']
                    # 新業務システムの取引先コード
                    params_m_com['new_biz_sys_company_id'] = data['new_biz_sys_company_id']

                    tmp_m_com = m_com._update(params_m_com)

                    if tmp_m_com:
                        data_m_com = tmp_m_com.to_dict()
                        logger.debug(data_m_com)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# 「m_user」を更新する':

                if self.diff_m_user_data(old_data, data):
                    logger.debug('diff_m_user_data True')

                    logger.debug('# 「m_user」を更新する')

                    params = {
                        'table_name': 'm_user',
                        'filters': {
                            'auth0_user_id': data['auth0_user_id'],
                            'company_code': data['company_code']
                        }
                    }
                    data_m_u = self.get_data(params)

                    if data_m_u is not None:

                        MU = GV.get_module('m_user')
                        m_u = MU()

                        # 企業コード
                        data_m_u['company_code'] = data['company_code']
                        # 名前
                        data_m_u['name_last'] = data['name_last']
                        # 名前(姓)
                        data_m_u['name_first'] = data['name_first']
                        # 名前(名)
                        data_m_u['name_last_kana'] = data['name_last_kana']
                        # 名前(カナ)(姓)
                        data_m_u['name_first_kana'] = data['name_first_kana']
                        # 部署名(カナ)(名)
                        data_m_u['department'] = data['department']
                        # 役職
                        data_m_u['position'] = data['position']
                        # メールアドレス
                        data_m_u['email'] = data['email']
                        # 電話番号
                        data_m_u['tel'] = data['tel']

                        logger.debug('# データ更新')
                        tmp_m_u = m_u._update(data_m_u)

                        if tmp_m_u:
                            logger.debug(tmp_m_u.to_dict())
                            pass
                        else:
                            raise CustomException('SYS_ERR_100')
                            pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_con = None

            is_first_register_m_contract = False

            if '# 「m_contract」を登録或いは更新する':

                if data['contract_id'] is None or self.diff_m_contract_data(old_data, data):

                    logger.debug('# 「m_contract」を登録或いは更新する')

                    # if data['contract_id'] is not None:

                    # if '# 「m_contract」を更新する':

                    MCON = GV.get_module('m_contract')
                    m_con = MCON()

                    params_m_con = {}
                    # 契約ID
                    params_m_con['contract_id'] = data['contract_id']
                    # 申込コード
                    params_m_con['entry_code'] = data['entry_code']
                    # 企業コード
                    params_m_con['company_code'] = data['company_code']
                    # 契約名
                    params_m_con['subscription_name'] = data['service_name']
                    # 契約者名(姓)
                    params_m_con['contract_last_name'] = data['contract_last_name']
                    # 契約者名(名)
                    params_m_con['contract_first_name'] = data['contract_first_name']
                    # 契約者名カナ(姓)
                    params_m_con['contract_last_name_kana'] = data['contract_last_name_kana']
                    # 契約者名カナ(名)
                    params_m_con['contract_first_name_kana'] = data['contract_first_name_kana']
                    # 契約開始日
                    params_m_con['subscription_start_date'] = data['subscription_start_date']
                    # 契約終了日
                    params_m_con['subscription_end_date'] = data['subscription_end_date']
                    # 送付先名 ???
                    params_m_con['postal_address'] = data['postal_address']
                    # 郵便番号
                    params_m_con['contract_zipcode'] = data['contract_zip_code']
                    # 都道府県
                    params_m_con['contract_address_pref'] = data['contract_address_pref']
                    # 住所１
                    params_m_con['contract_address_1'] = data['contract_address_1']
                    # 住所２
                    params_m_con['contract_address_2'] = data['contract_address_2']
                    # 住所３
                    params_m_con['contract_address_3'] = data['contract_address_3']
                    # 電話番号
                    params_m_con['contract_tel_1'] = data['contract_telephone_number']
                    # メールアドレス
                    params_m_con['contract_email'] = data['contract_email_address']
                    # 部署名
                    params_m_con['contract_department'] = data['contract_affiliation_department']
                    # 担当営業名
                    params_m_con['salesman_name'] = data['salesman_name']
                    # # 適用開始日
                    # params_m_con['applicable_start_date'] = data['applicable_start_date']
                    # # 適用終了日
                    # params_m_con['applicable_end_date'] = data['applicable_end_date']
                    # テキ05 役職(顧客)
                    params_m_con['contract_position'] = data['contract_director']
                    # テキ08 請求方法
                    params_m_con['payment_method'] = data['payment_method']
                    # テキ09 担当営業(職番)
                    params_m_con['salesman_code'] = data['salesman_code']
                    # --> 共通PF4 職番の重複許可 2024/02/06 nakamura.e
                    # スタッフID
                    params_m_con['staff_id'] = data['staff_id']
                    # <-- 共通PF4 職番の重複許可 2024/02/06 nakamura.e
                    # 備考
                    params_m_con['subscription_notes'] = data['subscription_notes']
                    # 請求書の送付方法
                    params_m_con['invoice_sending_method'] = data['gmo_invoice_mail']
                    # # 一時休止予定日
                    # params_m_con['temp_service_sleep_start_date'] = data['temp_service_sleep_start_date']
                    # # 一時休止からの再開予定日
                    # params_m_con['temp_service_sleep_restart_date'] = data['temp_service_sleep_restart_date']
                    # # 停止予定日
                    # params_m_con['ndes_service_stop_start_date'] = data['ndes_service_stop_start_date']
                    # # 停止からの再開予定日
                    # params_m_con['ndes_service_stop_restart_date'] = data['ndes_service_stop_restart_date']
                    # # サービスの解約メール送信日
                    # params_m_con['termination_of_service_mail_send_date'] = data['termination_of_service_mail_send_date']
                    # # サービスの利用ステータス
                    # params_m_con['service_usable_status'] = data['service_usable_status']
                    # 解約理由
                    params_m_con['reason_for_termination'] = data['reason_for_termination']
                    # # サービスの再開事前通知実施日
                    # params_m_con['pre_notification_resumption_of_service_mael_send_date'] = data['pre_notification_resumption_of_service_mael_send_date']
                    # # 申込完了メール送信日
                    # params_m_con['application_completion_email_sent_date'] = data['application_completion_email_sent_date']
                    # # 商談中止メール送信日
                    # params_m_con['cancellation_email_sent_date'] = data['cancellation_email_sent_date']

                    filters = []
                    filters.append(
                        m_con.model_class.entry_code == data['entry_code'])
                    filters.append(
                        m_con.model_class.company_code == data['company_code'])
                    filters = and_(*filters)

                    tmp_m_con_get = m_con._get_item_by_filters(filters)

                    logger.debug('tmp_m_con_get')
                    logger.debug(tmp_m_con_get)

                    tmp_m_con = None

                    # if params_m_con['contract_id'] is None:
                    if tmp_m_con_get is None:
                        logger.debug('# 「m_contract」を登録する')

                        # # 2022-09-14
                        # # 初回登録時に適用開始日に月初を入れて、適用終了日は空欄固定になりました。
                        # # 適用開始日
                        # params_m_con['applicable_start_date'] = dt_now.replace(day=1).date()
                        # # 適用終了日
                        # params_m_con['applicable_end_date'] = None

                        tmp_m_con = m_con._add(params_m_con)

                        is_first_register_m_contract = True

                    else:
                        logger.debug('# 「m_contract」を更新する')

                        tmp_m_con = m_con._update(params_m_con)

                    # if params_m_con['contract_id'] is not None:
                    #     tmp_m_con = m_con._update(params_m_con)

                    if tmp_m_con is not None:
                        data_m_con = tmp_m_con.to_dict()
                        logger.debug(data_m_con)

                    if data_m_con is not None:
                        data['contract_id'] = data_m_con['contract_id']

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# 「t_manage_request」を更新する':

                if self.diff_t_manage_request_data(old_data, data):

                    logger.debug('# 「t_manage_request」を更新する')

                    TMR = GV.get_module('t_manage_request')
                    t_mr = TMR()

                    params_t_mr = {}
                    # 申込管理ID
                    params_t_mr['manage_req_id'] = data['manage_req_id']
                    # 企業コード
                    params_t_mr['company_code'] = data['company_code']
                    # システムID
                    params_t_mr['system_id'] = data['system_id']
                    # サービスID
                    params_t_mr['service_id'] = data['service_id']
                    # 契約ID
                    if data['contract_id'] is not None:
                        params_t_mr['contract_id'] = data['contract_id']
                    # # Auth0ユーザーID
                    # params_t_mr['auth0_user_id'] = data['auth0_user_id']
                    # # 資料請求ID
                    # params_t_mr['document_req_id'] = data['document_req_id']
                    # # トライアル申込ID
                    # params_t_mr['trial_req_id'] = data['trial_req_id']
                    # # ワークショップ申込ID
                    # params_t_mr['workshop_req_id'] = data['workshop_req_id']
                    # # 本契約申込ID
                    # params_t_mr['contract_req_id'] = data['contract_req_id']
                    # 担当営業コード
                    params_t_mr['salesman_code'] = data['salesman_code']
                    # --> 共通PF4 職番の重複許可 2024/02/06 nakamura.e
                    # スタッフID
                    params_t_mr['staff_id'] = data['staff_id']
                    # <-- 共通PF4 職番の重複許可 2024/02/06 nakamura.e
                    # # ステータス
                    # params_t_mr['status'] = data['status']
                    # # システム利用可能フラグ
                    # params_t_mr['system_usable_flag'] = data['system_usable_flag']
                    # # 環境ID
                    # params_t_mr['env_id'] = data['env_id']
                    # 信用調査
                    params_t_mr['credit_check'] = data['credit_check']
                    # 信用調査結果登録日
                    # params_t_mr['credit_check_regist_date'] = data['credit_check_regist_date']
                    if params_t_mr['credit_check'] is not None:
                        params_t_mr['credit_check_regist_date'] = dt_now
                    # プロスペクト申請
                    params_t_mr['prospect_request'] = data['prospect_request']
                    # プロスペクト申請結果登録日
                    # params_t_mr['prospect_request_regist_date'] = data['prospect_request_regist_date']
                    if params_t_mr['prospect_request'] is not None:
                        params_t_mr['prospect_request_regist_date'] = dt_now
                    # 本契約可否判断
                    params_t_mr['contract_judgment'] = data['contract_judgment']

                    tmp_t_mr = t_mr._update(params_t_mr)

                    if tmp_t_mr:
                        data_t_mr = tmp_t_mr.to_dict()
                        logger.debug(data_t_mr)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「契約商品マスタ」にデータを登録する':

                logger.debug('# テーブル「契約商品マスタ」からデータを取得する')
                logger.debug('# m_contract_product')

                MCP = GV.get_module('m_contract_product')
                m_cp = MCP()

                filters = []
                filters.append(
                    m_cp.model_class.contract_id == data_m_con['contract_id'])
                filters = and_(*filters)

                tmp_m_cp = m_cp._get_item_by_filters(filters)

                if tmp_m_cp is None:

                    logger.debug('# ******************************')

                    data_m_rp = None

                    if '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する':

                        logger.debug(
                            '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する')

                        logger.debug('# ???')
                        logger.debug('# 「請求書発行手数料」どう特定するか？')
                        logger.debug('# ???')

                        MRP = GV.get_module('m_regular_products')
                        m_rp = MRP()

                        filters = []
                        filters.append(
                            m_rp.model_class.product_name == '請求書発行手数料')
                        filters = and_(*filters)

                        tmp_m_rp = m_rp._get_item_by_filters(filters)

                        if tmp_m_rp is not None:

                            data_m_rp = tmp_m_rp.to_dict()

                    logger.debug('# ##############################')
                    
                    
                    # ------------------0614---------------S
                    logger.debug('# テーブル「本契約申込情報（確認済み）」からデータ検索---------')
                    # logger.debug('# t_contract_request_confirmed')
                    # print(data['contract_req_id'])
    
                    params = {
                        'table_name': 't_contract_request_confirmed',
                        'filters': {
                            'contract_req_id': data['contract_req_id']
                        }
                    }
                    data_t_crc = self.get_data(params)
                    product_group_idArr = []
                    if data_t_crc:
                        logger.debug('# 存在する場合')
                        
                        for t2 in data_t_crc['contract_product_request']:
                            # print(t2)
                            product_group_idArr.append(t2['product_group_id'])
                            pass
                    # ------------------0614---------------E

                    logger.debug('# ******************************')
                    logger.debug('# テーブル「通常商品マスタ」からデータを取得する')
                    logger.debug('# m_regular_products')

                    MRP = GV.get_module('m_regular_products')
                    m_rp = MRP()

                    filters = []
                    filters.append(
                        m_rp.model_class.service_id == data['service_id'])
                    # -------------0614------------S
                    filters.append(
                        m_rp.model_class.product_group_id.in_(product_group_idArr))
                    # -------------0614------------E
                    filters = and_(*filters)
                    
                    # print("----------product_group_idArr------------")
                    # print(product_group_idArr)

                    tmp_m_rp = m_rp._get_item_by_filters(filters, get_all=True)

                    if tmp_m_rp is not None and len(tmp_m_rp) > 0:
                        # print("----------product_group_idArr1------------")

                        for t in tmp_m_rp:
                            # print("----------product_group_idArr2------------")

                            d_m_rp = t.to_dict()

                            if data_m_rp is not None and \
                                    data_m_rp['product_id'] == d_m_rp['product_id']:
                                logger.debug(
                                    '# ******************************')
                                logger.debug('# 「請求書発行手数料」のIDの場合登録しない')
                                logger.debug('# あとの処理で行う')
                                logger.debug(
                                    '# ##############################')
                                pass
                            else:
                                logger.debug(
                                    '# ******************************')
                                logger.debug('# テーブル「契約商品マスタ」にデータを登録する')
                                logger.debug('# m_contract_product')

                                param_m_cp = {}
                                param_m_cp['contract_id'] = data_m_con['contract_id']
                                param_m_cp['product_id'] = d_m_rp['product_id']
                                param_m_cp['product_group_id'] = d_m_rp['product_group_id']
                                
                                # -------------0614------------S
                                # 契約商品マスタに登録する。利用開始日は契約開始日と同日を設定する。利用終了日は空白。
                                for t3 in data_t_crc['contract_product_request']:
                                    # print(t3)
                                    if param_m_cp['product_group_id'] == t3['product_group_id']:
                                        param_m_cp['quantity'] = t3['quantity']
                                        param_m_cp['use_start_date'] = data['subscription_start_date']
                                        break

                                param_m_cp['use_end_date'] = None
                                # print("param_m_cp-------")
                                # print(param_m_cp)
                                # -------------0614------------E
                                
                                tmp_m_cp_add = m_cp._add(param_m_cp)

                                if tmp_m_cp_add is None:
                                    logger.debug('# テーブル「契約商品マスタ」にデータを登録する')
                                    logger.debug(param_m_cp)
                                    raise CustomException('SYS_ERR_100')

                                logger.debug(
                                    '# ##############################')
                    # -------------0719------------S
                    # requiredがtrueのとき、契約に必ず契約商品として契約商品マスタに追加する。（同時実行数は空白でOKです）
                    MPG = GV.get_module('m_product_groups')
                    m_pg = MPG()

                    filters = []
                    filters.append(
                        m_pg.model_class.required == True)
                    filters.append(
                        m_pg.model_class.display_flag == False)
                    filters = and_(*filters)
                    
                    tmp_m_pg = m_pg._get_item_by_filters(filters, get_all=True)

                    if tmp_m_pg is not None and len(tmp_m_pg) > 0:
                        # print("----------tmp_m_pg------------")

                        for t in tmp_m_pg:
                            # print("----------tmp_m_pg------------")
                            t_mpgItem = t.to_dict()
                            filters1 = []
                            filters1.append(
                                m_rp.model_class.product_group_id == t_mpgItem['product_group_id'])
                            filters1.append(
                                m_rp.model_class.system_id == data['system_id'])
                            filters1 = and_(*filters1)
                            
                            tmp_m_rp = m_rp._get_item_by_filters(filters1, get_all=True)

                            if tmp_m_rp is not None and len(tmp_m_rp) > 0:
                                # print("----------tmp_m_rp------------")

                                for t1 in tmp_m_rp:
                                    param_m_cp = {}
                                    t_mpgrpItem = t1.to_dict()
                                    logger.debug('# m_regular_products 存在する場合')
                                    # print(t2)
                                    param_m_cp['contract_id'] = data_m_con['contract_id']
                                    param_m_cp['product_id'] = t_mpgrpItem['product_id']
                                    param_m_cp['use_start_date'] = data['subscription_start_date']
                                    tmp_m_cp_add = m_cp._add(param_m_cp)
                
                                    if tmp_m_cp_add is None:
                                        logger.debug('# テーブル「契約商品マスタ」にデータを登録する')
                                        logger.debug(param_m_cp)
                                        raise CustomException('SYS_ERR_100')
                                    pass
                    # -------------0719------------E
                    

                    logger.debug('# ##############################')
                    
                    

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # if '# ・GMO掛け払いの請求書の郵送がON(郵送(書類))の場合はこの企業コードの契約中の契約すべてをチェックし、' and \
            #         'GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。':

            #     if data['gmo_invoice_mail'] == '郵送(書類)':

            #         if data_m_rp is not None:

            #             logger.debug('# ******************************')

            #             data_t_mr = None
            #             list_contract_id = None

            #             if '# この企業コードの契約中の契約すべてをチェック':

            #                 logger.debug('# この企業コードの契約中の契約すべてをチェック')
            #                 logger.debug(data['company_code'])

            #                 filters = []
            #                 filters.append(
            #                     t_mr.model_class.company_code == data['company_code'])
            #                 filters = and_(*filters)

            #                 tmp_t_mr = t_mr._get_item_by_filters(
            #                     filters, get_all=True)

            #                 if tmp_t_mr is not None and len(tmp_t_mr) > 0:

            #                     data_t_mr = []

            #                     for t in tmp_t_mr:
            #                         d = t.to_dict()
            #                         data_t_mr.append(d)

            #                 logger.debug('# 契約IDのリストを取得')
            #                 logger.debug(data_t_mr)

            #                 if data_t_mr is not None:

            #                     list_contract_id = []

            #                     for d in data_t_mr:

            #                         list_contract_id.append(
            #                             d['contract_id'])

            #                     logger.debug(list_contract_id)

            #             logger.debug(
            #                 '# ##############################')

            #             logger.debug(
            #                 '# ******************************')

            #             if '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。':

            #                 logger.debug(
            #                     '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

            #                 if list_contract_id is not None:

            #                     list_contract_id.sort()
            #                     logger.debug(list_contract_id)

            #                     MCP = GV.get_module(
            #                         'm_contract_product')
            #                     m_cp = MCP()

            #                     filters = []
            #                     filters.append(
            #                         m_cp.model_class.contract_id.in_(list_contract_id))
            #                     filters = and_(*filters)

            #                     tmp_m_cp = m_cp._get_item_by_filters(
            #                         filters)

            #                     if tmp_m_cp is None:

            #                         logger.debug(
            #                             '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

            #                         param_m_cp = {}
            #                         param_m_cp['contract_id'] = list_contract_id[0]
            #                         param_m_cp['product_id'] = data_m_rp['product_id']

            #                         tmp_m_cp_add = m_cp._add(
            #                             param_m_cp)

            #                         if tmp_m_cp_add is None:
            #                             logger.debug('# 1番古い契約に追加する。')
            #                             logger.debug(param_m_cp)
            #                             raise CustomException(
            #                                 'SYS_ERR_100')

            #             logger.debug(
            #                 '# ##############################')

            # logger.debug('# ##############################')

            # 企業情報の登録、更新の際に以下の処理をする。
            # ・請求書を郵送する場合は契約商品マスタ(user_infrastructure.m_contract_product)にレコード「請求書の郵送手数料の商品ID」を追加する。
            # ・請求書を郵送しない場合は契約商品マスタ(user_infrastructure.m_contract_product)からレコード「請求書の郵送手数料の商品IDを削除する。
            logger.debug('# ******************************')
            # 契約商品マスタ
            logger.debug('# 契約商品マスタを更新')
            logger.debug('# 「invoice_sending_method」と「gmo_invoice_mail」は同じ')
            logger.debug('# 「gmo_invoice_mail」を使う')
            logger.debug(data['status'])
            logger.debug(data['gmo_invoice_mail'])
            logger.debug(item_service.handling_charge_product_id)

            if data['contract_id'] is not None:

                if data['status'] == GV.STATUS['本契約申請'] or \
                    data['status'] == GV.STATUS['本契約受付'] or \
                        data['status'] == GV.STATUS['本契約利用中']:
                    # if True:
                    if data['gmo_invoice_mail'] == '郵送(書類)':
                        if item_service.handling_charge_product_id:
                            # 「請求書の郵送手数料の商品ID」を追加する。

                            if data['company_code'] is not None:

                                logger.debug(
                                    '# 請求書の郵送手数料の契約商品は1企業では1つのみにする必要がある。')

                                # list_contract = None

                                # logger.debug(
                                #     '# ******************************')
                                # logger.debug('# 契約マスタから該当企業コードの全ての契約データを取得する')

                                # MCON = GV.get_module('m_contract')
                                # m_con = MCON()

                                # filters = []
                                # filters.append(
                                #     m_con.model_class.company_code == data['company_code'])
                                # filters = and_(*filters)

                                # tmp_m_con_get = m_con._get_item_by_filters(
                                #     filters, get_all=True)

                                # if tmp_m_con_get is not None and len(tmp_m_con_get) > 0:
                                #     list_contract = []
                                #     for t in tmp_m_con_get:
                                #         d = t.to_dict()
                                #         list_contract.append(d)

                                # logger.debug(
                                #     '# ##############################')


                                list_contract = None

                                logger.debug('# ******************************')
                                logger.debug('# 「申込管理情報」から該当企業コードの全ての契約データを取得する')

                                TMR = GV.get_module('t_manage_request')
                                t_mr = TMR()

                                tmp_list_status = [GV.STATUS['本契約申請'], GV.STATUS['本契約受付'], GV.STATUS['本契約利用中']]

                                filters = []
                                filters.append(
                                    t_mr.model_class.company_code == data['company_code'])
                                filters.append(
                                    t_mr.model_class.contract_id != None)
                                filters.append(
                                    t_mr.model_class.status.in_(tmp_list_status))
                                filters = and_(*filters)

                                tmp_t_mr_get = t_mr._get_item_by_filters(
                                    filters, get_all=True)

                                if tmp_t_mr_get is not None and len(tmp_t_mr_get) > 0:
                                    list_contract = []
                                    for t in tmp_t_mr_get:
                                        d = t.to_dict()
                                        list_contract.append(d)

                                logger.debug('list_contract')
                                logger.debug(list_contract)

                                logger.debug('# ##############################')

                                if '# 契約データがある場合':

                                    if list_contract is not None:

                                        list_contract_id = []
                                        for d in list_contract:
                                            list_contract_id.append(
                                                d['contract_id'])

                                        list_contract_id.sort()
                                        logger.debug(list_contract_id)

                                        logger.debug('list_contract_id')
                                        logger.debug(list_contract_id)

                                        first_contract_id = list_contract_id[0]

                                        if '# 「契約商品マスタ（m_contract_product）」関連の処理':

                                            list_data_m_cp = None

                                            logger.debug(
                                                '# ******************************')
                                            logger.debug(
                                                '# 契約商品マスタから該当企業コードの全ての契約の「請求書の郵送手数料の商品ID」のデータを取得する')

                                            MCP = GV.get_module(
                                                'm_contract_product')
                                            m_cp = MCP()

                                            filters = []
                                            filters.append(
                                                m_cp.model_class.contract_id.in_(list_contract_id))
                                            filters.append(
                                                m_cp.model_class.product_id == item_service.handling_charge_product_id)
                                            filters = and_(*filters)

                                            tmp_m_cp_get = m_cp._get_item_by_filters(
                                                filters, get_all=True)

                                            logger.debug('tmp_m_cp_get')
                                            logger.debug(tmp_m_cp_get)

                                            if tmp_m_cp_get is not None and len(tmp_m_cp_get) > 0:
                                                list_data_m_cp = []
                                                for t in tmp_m_cp_get:
                                                    d = t.to_dict()
                                                    logger.debug('d')
                                                    logger.debug(d)
                                                    list_data_m_cp.append(d)

                                            logger.debug('list_data_m_cp')
                                            logger.debug(list_data_m_cp)

                                            logger.debug(
                                                '# ##############################')

                                            if list_data_m_cp is None:

                                                logger.debug(
                                                    '# 該当企業コードの「請求書の郵送手数料の商品ID」の契約データがない場合')

                                                if data['contract_id'] is not None:

                                                    logger.debug(
                                                        '# ******************************')
                                                    logger.debug(
                                                        '# 「請求書の郵送手数料の商品ID」を追加する。')
                                                    # m_contract_product

                                                    MCP = GV.get_module(
                                                        'm_contract_product')
                                                    m_cp = MCP()

                                                    filters = []
                                                    # filters.append(
                                                    #     m_cp.model_class.contract_id == data['contract_id'])
                                                    filters.append(
                                                        m_cp.model_class.contract_id == first_contract_id)
                                                    filters.append(
                                                        m_cp.model_class.product_id == item_service.handling_charge_product_id)
                                                    filters = and_(*filters)

                                                    tmp_m_cp_get = m_cp._get_item_by_filters(
                                                        filters)

                                                    if tmp_m_cp_get is None:

                                                        params_m_cp = {
                                                            # 'contract_id': data['contract_id'],
                                                            'contract_id': first_contract_id,
                                                            'product_id': item_service.handling_charge_product_id
                                                        }
                                                        # -------------0614------------S
                                                        # 契約商品マスタに登録する。利用開始日は契約開始日と同日を設定する。利用終了日は空白。
                                                        for t3 in data_t_crc['contract_product_request']:
                                                            # print(t3)
                                                            if params_m_cp['product_id'] == t3['main_product_id']:
                                                                params_m_cp['quantity'] = t3['quantity']
                                                                params_m_cp['use_start_date'] = data['subscription_start_date']
                                                                break
                        
                                                        params_m_cp['use_end_date'] = None
                                                        # print("params_m_cp-------")
                                                        # print(params_m_cp)
                                                        # -------------0614------------E

                                                        tmp_m_cp_add = m_cp._add(
                                                            params_m_cp)

                                                        if tmp_m_cp_add is None:
                                                            logger.debug(
                                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                                            logger.debug(
                                                                '# 「請求書の郵送手数料の商品ID」を追加する。')
                                                            logger.debug(
                                                                params_m_cp)
                                                            raise CustomException(
                                                                'SYS_ERR_100')

                                                        logger.debug(
                                                            tmp_m_cp_add)
                                                    logger.debug(
                                                        '# ##############################')
                                                pass

                                        if '# 「契約マスタ（m_contract）」関連の処理':

                                            for d in list_contract:

                                                data_m_con_get = None

                                                logger.debug(
                                                    '# ******************************')
                                                logger.debug('# 契約マスタからデータを取得する')

                                                MCON = GV.get_module('m_contract')
                                                m_con = MCON()

                                                filters = []
                                                filters.append(
                                                    m_con.model_class.contract_id == d['contract_id'])
                                                filters = and_(*filters)

                                                tmp_m_con_get = m_con._get_item_by_filters(filters)

                                                if tmp_m_con_get is not None:
                                                    data_m_con_get = tmp_m_con_get.to_dict()

                                                logger.debug(
                                                    '# ##############################')
                                                
                                                if data_m_con_get is not None:

                                                    if data_m_con_get['invoice_sending_method'] != 1:
                                                        logger.debug(
                                                            '# 「郵送(書類)」ではない場合')

                                                        logger.debug(
                                                            '# ******************************')
                                                        logger.debug(
                                                            '# 契約マスタデータを更新する')

                                                        MCON = GV.get_module(
                                                            'm_contract')
                                                        m_con = MCON()

                                                        data_m_con_get['invoice_sending_method'] = '郵送(書類)'

                                                        tmp_m_con_update = m_con._update(
                                                            data_m_con_get)

                                                        if tmp_m_con_update is None:
                                                            logger.debug(
                                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                                            logger.debug(
                                                                '#  契約マスタデータを更新する。')
                                                            logger.debug(data_m_con_get)
                                                            raise CustomException(
                                                                'SYS_ERR_100')

                                                        logger.debug(
                                                            '# ##############################')

                                            pass

                                if '# 契約データがない場合':

                                    if list_contract is None:

                                        if data['contract_id'] is not None:

                                            logger.debug(
                                                '# ******************************')
                                            logger.debug(
                                                '# 「請求書の郵送手数料の商品ID」を追加する。')
                                            # m_contract_product

                                            MCP = GV.get_module(
                                                'm_contract_product')
                                            m_cp = MCP()

                                            filters = []
                                            filters.append(
                                                m_cp.model_class.contract_id == data['contract_id'])
                                            filters.append(
                                                m_cp.model_class.product_id == item_service.handling_charge_product_id)
                                            filters = and_(*filters)

                                            tmp_m_cp_get = m_cp._get_item_by_filters(
                                                filters)

                                            if tmp_m_cp_get is None:

                                                params_m_cp = {
                                                    'contract_id': data['contract_id'],
                                                    'product_id': item_service.handling_charge_product_id
                                                }
                                                # -------------0614------------S
                                                # 契約商品マスタに登録する。利用開始日は契約開始日と同日を設定する。利用終了日は空白。
                                                for t3 in data_t_crc['contract_product_request']:
                                                    # print(t3)
                                                    if params_m_cp['product_id'] == t3['main_product_id']:
                                                        params_m_cp['quantity'] = t3['quantity']
                                                        params_m_cp['use_start_date'] = data['subscription_start_date']
                                                        break
                
                                                params_m_cp['use_end_date'] = None
                                                # print("params_m_cp-------")
                                                # print(params_m_cp)
                                                # -------------0614------------E

                                                tmp_m_cp_add = m_cp._add(
                                                    params_m_cp)

                                                if tmp_m_cp_add is None:
                                                    logger.debug(
                                                        '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                                    logger.debug(
                                                        '# 「請求書の郵送手数料の商品ID」を追加する。')
                                                    logger.debug(params_m_cp)
                                                    raise CustomException(
                                                        'SYS_ERR_100')

                                                logger.debug(tmp_m_cp_add)
                                            logger.debug(
                                                '# ##############################')

                                        pass

                        else:
                            raise CustomException('CI_ERR_100')
                            pass
                        pass
                    else:
                        if item_service.handling_charge_product_id:
                            # 「請求書の郵送手数料の商品IDを削除する。

                            if data['company_code'] is not None:

                                logger.debug(
                                    '# 請求書の郵送手数料の契約商品は1企業では1つのみにする必要がある。')
                                logger.debug(
                                    '# PDFにした場合該当企業コードの「請求書の郵送手数料の商品ID」を全部削除する')

                                # list_contract = None

                                # logger.debug(
                                #     '# ******************************')
                                # logger.debug('# 契約マスタから該当企業コードの全ての契約データを取得する')

                                # MCON = GV.get_module('m_contract')
                                # m_con = MCON()

                                # filters = []
                                # filters.append(
                                #     m_con.model_class.company_code == data['company_code'])
                                # filters = and_(*filters)

                                # tmp_m_con_get = m_con._get_item_by_filters(
                                #     filters, get_all=True)

                                # if tmp_m_con_get is not None and len(tmp_m_con_get) > 0:
                                #     list_contract = []
                                #     for t in tmp_m_con_get:
                                #         d = t.to_dict()
                                #         list_contract.append(d)

                                # logger.debug(
                                #     '# ##############################')

                                list_contract = None

                                logger.debug('# ******************************')
                                logger.debug('# 「申込管理情報」から該当企業コードの全ての契約データを取得する')

                                TMR = GV.get_module('t_manage_request')
                                t_mr = TMR()

                                tmp_list_status = [GV.STATUS['本契約申請'], GV.STATUS['本契約受付'], GV.STATUS['本契約利用中']]

                                filters = []
                                filters.append(
                                    t_mr.model_class.company_code == data['company_code'])
                                filters.append(
                                    t_mr.model_class.contract_id != None)
                                filters.append(
                                    t_mr.model_class.status.in_(tmp_list_status))
                                filters = and_(*filters)

                                tmp_t_mr_get = t_mr._get_item_by_filters(
                                    filters, get_all=True)

                                if tmp_t_mr_get is not None and len(tmp_t_mr_get) > 0:
                                    list_contract = []
                                    for t in tmp_t_mr_get:
                                        d = t.to_dict()
                                        list_contract.append(d)

                                logger.debug('# ##############################')

                                if '# 契約データがある場合':

                                    if list_contract is not None:

                                        list_contract_id = []
                                        for d in list_contract:
                                            list_contract_id.append(
                                                d['contract_id'])

                                        if '# 「契約商品マスタ（m_contract_product）」関連の処理':

                                            list_data_m_cp = None

                                            logger.debug(
                                                '# ******************************')
                                            logger.debug(
                                                '# 契約商品マスタから該当企業コードの全ての契約の「請求書の郵送手数料の商品ID」のデータを取得する')

                                            MCP = GV.get_module(
                                                'm_contract_product')
                                            m_cp = MCP()

                                            filters = []
                                            filters.append(
                                                m_cp.model_class.contract_id.in_(list_contract_id))
                                            filters.append(
                                                m_cp.model_class.product_id == item_service.handling_charge_product_id)
                                            filters = and_(*filters)

                                            tmp_m_cp_get = m_cp._get_item_by_filters(
                                                filters, get_all=True)

                                            if tmp_m_cp_get is not None and len(tmp_m_cp_get) > 0:
                                                list_data_m_cp = []
                                                for t in tmp_m_cp_get:
                                                    d = t.to_dict()
                                                    list_data_m_cp.append(d)

                                            logger.debug(
                                                '# ##############################')

                                            if list_data_m_cp is not None:

                                                logger.debug(
                                                    '# 該当企業コードの「請求書の郵送手数料の商品ID」の契約データがある場合')

                                                for d in list_data_m_cp:

                                                    MCP = GV.get_module(
                                                        'm_contract_product')
                                                    m_cp = MCP()

                                                    tmp_m_cp_delete = m_cp._delete(
                                                        d)

                                                    logger.debug(
                                                        'tmp_m_cp_delete')
                                                    logger.debug(
                                                        tmp_m_cp_delete)

                                        # if '# 「契約マスタ（m_contract）」関連の処理':

                                        #     for d in list_contract:
                                        #         if d['invoice_sending_method'] != 0:
                                        #             logger.debug(
                                        #                 '# 「PDF」ではない場合')

                                        #             logger.debug(
                                        #                 '# ******************************')
                                        #             logger.debug(
                                        #                 '# 契約マスタデータを更新する')

                                        #             MCON = GV.get_module(
                                        #                 'm_contract')
                                        #             m_con = MCON()

                                        #             d['invoice_sending_method'] = 'PDF'

                                        #             tmp_m_con_update = m_con._update(
                                        #                 d)

                                        #             if tmp_m_con_update is None:
                                        #                 logger.debug(
                                        #                     '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                        #                 logger.debug(
                                        #                     '#  契約マスタデータを更新する。')
                                        #                 logger.debug(d)
                                        #                 raise CustomException(
                                        #                     'SYS_ERR_100')

                                        #             logger.debug(
                                        #                 '# ##############################')
                                        if '# 「契約マスタ（m_contract）」関連の処理':

                                            for d in list_contract:

                                                data_m_con_get = None

                                                logger.debug(
                                                    '# ******************************')
                                                logger.debug('# 契約マスタからデータを取得する')

                                                MCON = GV.get_module('m_contract')
                                                m_con = MCON()

                                                filters = []
                                                filters.append(
                                                    m_con.model_class.contract_id == d['contract_id'])
                                                filters = and_(*filters)

                                                tmp_m_con_get = m_con._get_item_by_filters(filters)

                                                if tmp_m_con_get is not None:
                                                    data_m_con_get = tmp_m_con_get.to_dict()

                                                logger.debug(
                                                    '# ##############################')
                                                
                                                if data_m_con_get is not None:

                                                    if data_m_con_get['invoice_sending_method'] != 0:
                                                        logger.debug(
                                                            '# 「郵送(書類)」ではない場合')

                                                        logger.debug(
                                                            '# ******************************')
                                                        logger.debug(
                                                            '# 契約マスタデータを更新する')

                                                        MCON = GV.get_module(
                                                            'm_contract')
                                                        m_con = MCON()

                                                        data_m_con_get['invoice_sending_method'] = 'PDF'

                                                        tmp_m_con_update = m_con._update(
                                                            data_m_con_get)

                                                        if tmp_m_con_update is None:
                                                            logger.debug(
                                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                                            logger.debug(
                                                                '#  契約マスタデータを更新する。')
                                                            logger.debug(data_m_con_get)
                                                            raise CustomException(
                                                                'SYS_ERR_100')

                                                        logger.debug(
                                                            '# ##############################')

                                            pass


                                            pass

                            logger.debug('# 「請求書の郵送手数料の商品IDを削除する。')
                            # m_contract_product

                            MCP = GV.get_module('m_contract_product')
                            m_cp = MCP()

                            if data['contract_id'] is not None:

                                filters = []
                                filters.append(
                                    m_cp.model_class.contract_id == data['contract_id'])
                                filters.append(
                                    m_cp.model_class.product_id == item_service.handling_charge_product_id)
                                filters = and_(*filters)

                                tmp_m_cp_get = m_cp._get_item_by_filters(
                                    filters, get_all=True)

                                if tmp_m_cp_get is not None and len(tmp_m_cp_get) > 0:

                                    for t in tmp_m_cp_get:
                                        d = t.to_dict()

                                        tmp_m_cp_delete = m_cp._delete(d)

                                        if tmp_m_cp_delete is None:
                                            logger.debug(
                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                            logger.debug(
                                                '# 「請求書の郵送手数料の商品IDを削除する。')
                                            logger.debug(d)
                                            raise CustomException(
                                                'SYS_ERR_100')

                                        logger.debug(tmp_m_cp_delete)
                            pass
                        else:
                            pass
                        pass
                    
                    # -------------0614------------S
                    # print("aaaaaaaaaaaaaaaaaaaa")
                    # print(data)
                    # print(old_data)
                    if data['contract_id'] is not None and data['subscription_start_date'] is not None:
    
                        MCP = GV.get_module('m_contract_product')
                        m_cp = MCP()
    
                        filters = []
                        filters.append(m_cp.model_class.contract_id == data['contract_id'])
                        filters.append(m_cp.model_class.use_start_date  == old_data['subscription_start_date'])
                        filters.append(m_cp.model_class.use_end_date  == None)
                        filters = and_(*filters)
    
                        tmp_m_cp_get = m_cp._get_item_by_filters(filters, get_all=True)
    
                        if tmp_m_cp_get is not None:
                            for t in tmp_m_cp_get:
                                if t is not None:
                                    params_m_cp = t.to_dict()
                                    params_m_cp['use_start_date'] = data['subscription_start_date']
                                    # print("params_m_cp-------")
                                    # print(params_m_cp)
                                    
                                    tmp_t_cp = m_cp._update(params_m_cp)
    
                                    if tmp_t_cp is None:
                                        raise CustomException('SYS_ERR_100')
                                    # print("tmp_m_cp_get------------")
                                    
                    pass
                    # -------------0614------------E    

            logger.debug('# ##############################')

            # # await myapp.methods.register.register_auth0();

            # logger.debug('# ******************************')
            # # auth0
            # logger.debug('auth0')

            # # from ..auth0 import Sub as Auth0
            # # auth0 = Auth0()
            # auth0_class = GV.get_module_auth0()
            # a0 = auth0_class()

            # data_auth0 = {
            #     'user_id': data['administrator_email'],
            #     'username': data['company_code'] + '_' + data['administrator_email'].split('@')[0],
            #     'name': data['administrator_email'],
            #     'family_name': data['administrator_name_last'],
            #     'given_name': data['administrator_name_first']
            # }
            # logger.debug(data_auth0)
            # if data['auth0_user_id'] is None:
            #     tmp = a0._add(data_auth0)
            #     logger.debug(tmp)
            # else:
            #     tmp = a0._update(data['auth0_user_id'], data_auth0)
            #     logger.debug(tmp)
            # logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# auth0の情報を更新する':
                         
                logger.debug('# auth0の情報を更新する')
                logger.debug('# 必要無いかも???')

                if self.diff_auth0_data(old_data, data):

                    auth0_class = GV.get_module_auth0()
                    a0 = auth0_class()

                    params_a0 = {
                        'family_name': data['name_last'],
                        'given_name': data['name_first']
                    }

                    if data['auth0_user_id'] is not None:

                        tmp_a0 = a0._update(data['auth0_user_id'], params_a0)

                        if tmp_a0 is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# auth0の情報を更新失敗')
                            logger.debug(data['auth0_user_id'])
                            logger.debug(params_a0)
                            raise CustomException('SYS_ERR_100')

                        logger.debug(tmp_a0)

            logger.debug('# ##############################')

            # logger.debug('# ******************************')
            # logger.debug('???????????????????????????????????????????')
            # logger.debug('# ##############################')

            # # await myapp.methods.register.register_system_info(event);

            # logger.debug('# ******************************')
            # logger.debug('mscone_lic_m_company')
            # if data['stack_name'] is not None and \
            #         data['netuse_command'] is not None and \
            #         data['access_key'] is not None and \
            #         data['bridge_instance_id'] is not None:

            #     # mscone_lic_m_company
            #     from .mscone_lic_m_company import Sub as MLMCom
            #     ml_m_com = MLMCom()

            #     filters = []
            #     filters.append(ml_m_com.model_class.company_code ==
            #                    data['company_code'])
            #     filters = and_(*filters)
            #     tmp_ml_m_com = ml_m_com._get_item_by_filters(filters)

            #     if tmp_ml_m_com is None:
            #         tmp = ml_m_com._add(data)
            #         logger.debug(tmp)
            #     else:
            #         tmp = ml_m_com._update(data)
            #         logger.debug(tmp)

            #     pass

            # logger.debug('# ##############################')

            # logger.debug('# ******************************')
            # logger.debug('mscone_lic_m_directory_user')

            # # m_directory_user
            # from ..model.m_directory_user import Sub as MDU
            # ml_m_du = MDU()

            # logger.debug("data['company_code']<<<<<<<<<<<<<<<<<<<<<<<<")
            # logger.debug(data['company_code'])

            # filters = []
            # filters.append(ml_m_du.model_class.company_code ==
            #                data['company_code'])
            # filters = and_(*filters)
            # tmp_ml_m_du = ml_m_du._get_item_by_filters(filters)

            # if tmp_ml_m_du is None:
            #     for i in range(10):
            #         data_ml_m_du = {
            #             'company_code': data['company_code'],
            #             'directory_username': data['company_code'] + '.user' + str(i).zfill(3)
            #         }
            #         tmp = ml_m_du._add(data_ml_m_du)
            #         logger.debug(tmp)
            # else:
            #     pass

            # pass

            logger.debug('# ##############################')

            # await myapp.methods.register.register_new_biz_sys_info(event);

            logger.debug('# ******************************')
            logger.debug('新業務システム情報')
            logger.debug('m_new_biz_sys_info')

            if '# 契約データ作成時に新業務システム情報のレコードを追加し、受注見込み金額を設定するようにする。':

                if is_first_register_m_contract == True and data_m_con is not None:

                    logger.debug('# ******************************')

                    # m_services_and_related_sales_categories
                    # サービスと関連する売上区分マスタ
                    logger.debug('サービスと関連する売上区分マスタ')

                    if data['service_id'] is not None:

                        # from ..model.m_services_and_related_sales_categories import Sub as MSARSC
                        # m_sarsc = MSARSC()
                        MSARSC = GV.get_module(
                            'm_services_and_related_sales_categories')
                        m_sarsc = MSARSC()

                        filters = []
                        filters.append(
                            m_sarsc.model_class.service_id == data['service_id'])
                        filters = and_(*filters)

                        tmp_m_sarsc = m_sarsc._get_item_by_filters(
                            filters, get_all=True)

                        if tmp_m_sarsc is not None and len(tmp_m_sarsc) > 0:

                            for i in tmp_m_sarsc:

                                d_m_sarsc = i.to_dict()
                                logger.debug(d_m_sarsc)

                                logger.debug(
                                    '# ******************************')

                                # m_new_biz_sys_sales_category
                                # 新業務システム売上区分マスタ
                                logger.debug('新業務システム売上区分マスタ')

                                # from ..model.m_new_biz_sys_sales_category import Sub as MNBSSC
                                # m_nbssc = MNBSSC()
                                MNBSSC = GV.get_module(
                                    'm_new_biz_sys_sales_category')
                                m_nbssc = MNBSSC()

                                filters = []
                                filters.append(m_nbssc.model_class.sales_category_id ==
                                               d_m_sarsc['sales_category_id'])
                                filters = and_(*filters)

                                tmp_m_nbssc = m_nbssc._get_item_by_filters(
                                    filters)

                                if tmp_m_nbssc:

                                    data_m_nbssc = tmp_m_nbssc.to_dict()

                                    logger.debug(
                                        '# ******************************')
                                    logger.debug('新業務システム情報マスタ')

                                    # m_new_biz_sys_info
                                    # from ..model.m_new_biz_sys_info import Sub as MNBSI
                                    # m_nbsi = MNBSI()
                                    MNBSI = GV.get_module('m_new_biz_sys_info')
                                    m_nbsi = MNBSI()

                                    filters = []
                                    filters.append(m_nbsi.model_class.contract_id ==
                                                   data['contract_id'])
                                    filters.append(m_nbsi.model_class.company_code ==
                                                   data['company_code'])
                                    filters.append(m_nbsi.model_class.sales_category_id ==
                                                   d_m_sarsc['sales_category_id'])
                                    filters.append(m_nbsi.model_class.estimated_order_amount ==
                                                   data_m_nbssc['estimated_order_amount_default'])
                                    filters = and_(*filters)
                                    tmp_m_nbsi = m_nbsi._get_item_by_filters(
                                        filters)

                                    if tmp_m_nbsi is None:
                                        logger.debug(
                                            'add?????????????????????')
                                        data_m_nbsi = {
                                            'contract_id': data['contract_id'],
                                            'company_code': data['company_code'],
                                            'sales_category_id': d_m_sarsc['sales_category_id'],
                                            'estimated_order_amount': data_m_nbssc['estimated_order_amount_default']
                                        }

                                        tmp_m_nbsi_add = m_nbsi._add(
                                            data_m_nbsi)

                                        if tmp_m_nbsi_add is None:
                                            logger.debug(
                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                            logger.debug(
                                                '# 新業務システム情報マスタにデータ追加失敗')
                                            logger.debug(data_m_nbsi)
                                            raise CustomException(
                                                'SYS_ERR_100')

                                        pass
                                    # else:
                                    #     logger.debug('update?????????????????????')
                                    #     data_m_nbsi = {
                                    #         'new_biz_sys_info_id': data['new_biz_sys_info_id'],
                                    #         'contract_id': data['contract_id'],
                                    #         'company_code': data['company_code'],
                                    #         'new_biz_sys_company_id': data['new_biz_sys_company_id']
                                    #     }
                                    #     m_nbsi._update(data_m_nbsi)
                                    #     pass

                                    logger.debug(
                                        '# ##############################')

                                logger.debug(
                                    '# ##############################')

                    logger.debug('# ##############################')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# GMO掛け払い情報  枠保証額を更新する':
                if data['payment_method'] is not None and data['payment_method'] == 'GMO掛け払い':

                    if self.diff_m_gmo_payment_service_data(old_data, data):

                        logger.debug('# GMO掛け払い情報  枠保証額を更新する')
                        logger.debug('m_gmo_payment_service')

                        MGPS = GV.get_module('m_gmo_payment_service')
                        m_gps = MGPS()

                        filters = []
                        filters.append(m_gps.model_class.company_code ==
                                    data['company_code'])
                        filters = and_(*filters)
                        tmp_m_gps = m_gps._get_item_by_filters(filters)

                        if tmp_m_gps is not None:

                            data_m_gps = tmp_m_gps.to_dict()

                            if 'creditfacility_application' in data:
                                data_m_gps['creditfacility_application'] = data['creditfacility_application']
                            # バグ #5345 2024/03/07 li  S
                            dt_nowdata = datetime.now()
                            # print('|||||||||||||||||||||||||1')
                            # print(data)
                            # print('|||||||||||||||||||||||||1')
                            if 'examination_request_date' in data:
                                data_m_gps['examination_request_date'] = dt_nowdata
                            # バグ #5345 2024/03/07 li  E
                            

                            m_gps._update(data_m_gps)

            logger.debug('# ##############################')

        except NameError as e:
            logger.debug(e)
        except KeyError as e:
            logger.debug(e)
            logger.debug('KeyError will be handled here.')
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
    
    def update2(self, data=None):
        logger.debug('# ******************************')
        logger.debug('# update2')
        logger.debug('# ##############################')
        try:

            # if GV.EVENT_BODY is None:
            #     raise CustomException('SYS_ERR_100')

            # data = GV.EVENT_BODY
            logger.debug(data)

            dt_now = datetime.now()

            logger.debug('# ******************************')
            logger.debug('サービスデータ取得')
            # サービスデータ取得
            # m_services

            item_service = None
            if data['service_id'] is not None:

                MSRV = GV.get_module('m_services')
                m_srv = MSRV()
                filters = []
                filters.append(m_srv.model_class.service_id ==
                               data['service_id'])
                filters = and_(*filters)
                tmp_m_srv = m_srv._get_item_by_filters(filters)
                if tmp_m_srv:
                    item_service = tmp_m_srv
                pass
            logger.debug('# ##############################')

            # 支払方法がGMO掛け払いの場合
            if data['payment_method'] is not None and data['payment_method'] == 'GMO掛け払い':
            # 取得した枠保証の審査状況を企業情報管理アプリに更新
            # set_payment_creditfacility_getbuyercreditfacility
                logger.debug('set_payment_creditfacility_getbuyercreditfacility')
                logger.debug('??????')

            logger.debug('# ******************************')

            # 6708----------10/16----------S
            item_system_id = None
            item_authenticationId = None
            item_shopCode = None
            item_connectPassword = None
            if data['system_id'] is not None:
                item_system_id = data['system_id']

                data_m_si = None

                logger.debug('# ******************************')
                MSI = GV.get_module('m_supplier_info')
                m_si = MSI()

                filters = []
                filters.append(m_si.model_class.system_id == item_system_id)
                filters = and_(*filters)

                tmp_m_si = m_si._get_item_by_filters(filters)

                if tmp_m_si is not None:
                    data_m_si = tmp_m_si.to_dict()
                    item_authenticationId = data_m_si['gmo_payment_frame_guarantee_id']
                    item_shopCode = data_m_si['gmo_payment_frame_guarantee_shopcode']
                    item_connectPassword = data_m_si['gmo_payment_frame_guarantee_password']
            # 6708----------10/16----------E

            if '# 「枠保証審査ステータス」を確認する':

                logger.debug('# 「枠保証審査ステータス」を確認する')

                if data['examination_status'] is None:

                    logger.debug('# 枠保証申請 未申請')

                    if '# 「枠保証申請」を行う':

                        logger.debug(
                            'register_payment_creditfacility_registerbuyer')

                        # // 枠保証申込
                        apply = 1
                        # // 希望上限金額
                        reqUpperLimit = item_service.gmo_ps_req_upper_limit
                        # 住所
                        address = data['contract_address_pref'] + \
                            data['contract_address_1'] + \
                            data['contract_address_2']
                        if data['contract_address_3']:
                            address = address + data['contract_address_3']
                        
                        

                        params_rpcr = {
                            'buyer': {
                                #   // 'buyerNameFamily': '掛払',
                                'buyerNameFamily': data['contract_last_name'],
                                #   // 'buyerName': '太郎',
                                'buyerName': data['contract_first_name'],
                                #   // 'buyerNameFamilyKana': 'カケバライ',
                                'buyerNameFamilyKana': data['contract_last_name_kana'],
                                #   // 'buyerNameKana': 'タロウ',
                                'buyerNameKana': data['contract_first_name_kana'],
                                #   // 'zipCode': '150-0043',
                                'zipCode': data['contract_zip_code'],
                                #   // zipCode: data['company_zipcode'],
                                #   // 'address': '東京都渋谷区道玄坂 1−14−6',
                                'address': address,
                                #   // 'companyName': 'サンプル株式会社',
                                'companyName': data['company_name'],
                                #   // 'departmentName': 'サンプル部',
                                'departmentName': data['contract_affiliation_department'],
                                #   // 'tel1': '01234567',
                                'tel1': data['contract_telephone_number'],
                                #   // tel1: data['company_tel_1'],
                                #   // // 'tel2': '01234567',
                                #   // 'tel2': data['tel2'],
                                #   // 'email1': 'sample1@localhost.localdomain',
                                'email1': data['contract_email_address'],
                                #   // // 'email2': 'sample1@localhost.localdomain',
                                #   // 'email2': data['email2'],
                                #   // 'presidentNameFamily': '代表',
                                'presidentNameFamily': data['company_last_name'],
                                #   // 'presidentName': '花子',
                                'presidentName': data['company_first_name'],
                                #   // 'presidentNameFamilyKana': 'ダイヒョウ',
                                'presidentNameFamilyKana': data['company_last_name_kana'],
                                #   // 'presidentNameKana': 'ハナコ',
                                'presidentNameKana': data['company_first_name_kana'],
                                #   // 'birthday': '20201029',
                                'birthday': data['company_leader_date_of_birth'],
                                #   // 'shopCustomerId': '5',
                                'shopCustomerId': data['company_code'],
                                #   // // 'corpNumber': '1234567890123'
                                #   // 'corpNumber': data['corpNumber'],
                            },
                            'creditFacility': {
                                #   // 'apply': '1',
                                'apply': apply,
                                #   // 'reqUpperLimit': 10000000
                                'reqUpperLimit': reqUpperLimit,
                            },
                            # 6708----------10/16----------S
                            'relatedData': {
                                #   // 'system_id': 'SYS00001',
                                'system_id': item_system_id,
                                #   // 'authenticationId': '0000000000',
                                'authenticationId': item_authenticationId,
                                #   // 'shopCode': 's00001486',
                                'shopCode': item_shopCode,
                                #   // 'connectPassword': '00001486',
                                'connectPassword': item_connectPassword,
                            },
                            # 6708----------10/16----------E
                        }

                        res_rpcr = self.register_payment_creditfacility_registerbuyer(
                            params_rpcr)
                        logger.debug('res_rpcr')
                        logger.debug(res_rpcr)

                        # [DEBUG]	2023-08-09T08:12:37.331Z	221ca74e-d928-402e-aed1-1e186a943957
                        # {
                        #   'statusCode': 400,
                        #   'headers': {
                        #      'Access-Control-Allow-Headers': 'Content-Type',
                        #      'Access-Control-Allow-Origin': '*',
                        #      'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
                        #   },
                        #   'body': '{\n  "result": "NG",\n  "errors": [\n    {\n      "errCode": "BCT0033",\n      "errorMessage": "購入企業IDが重複しています。"\n    }\n  ]\n}'}

                        if 'statusCode' in res_rpcr and res_rpcr['statusCode'] == 400:
                            if 'body' in res_rpcr:

                                tmp_error = json.loads(res_rpcr['body'])

                                logger.debug('tmp_error')
                                logger.debug(tmp_error)

                                error_message = ''

                                if 'errors' in tmp_error:
                                    for e in tmp_error['errors']:
                                        error_message += '【GMO枠保証申請】' + '<br/>'
                                        error_message += '<br/>'
                                        if 'errCode' in e and e['errCode'] is not None:
                                            error_message += e['errCode'] + '<br/>'
                                        if 'errorMessage' in e and e['errorMessage'] is not None:
                                            error_message += e['errorMessage'] + '<br/>'
                                error = {
                                    'code': 400,
                                    'message': error_message
                                }

                                return GV.handle_error('ERROR', None, error)

                        logger.debug('# ******************************')
                        logger.debug('# GMO掛け払い情報')
                        logger.debug('m_gmo_payment_service')

                        MGPS = GV.get_module('m_gmo_payment_service')
                        m_gps = MGPS()

                        filters = []
                        filters.append(m_gps.model_class.company_code ==
                                       data['company_code'])
                        filters = and_(*filters)
                        tmp_m_gps = m_gps._get_item_by_filters(filters)
                        # バグ #5345 2024/03/07 li  S
                        # GMO-PSにデータ登録する＋企業コードが存在しない(初回)：枠保証審査依頼日時を登録
                        # GMO-PSにデータ登録する＋企業コードが存在する＋枠保証申請額が変更されている：枠保証審査依頼日時を更新
                        # バグ #5345 2024/03/07 li  E
                        if tmp_m_gps is not None:

                            data_m_gps = tmp_m_gps.to_dict()
                            # バグ #5345 2024/03/07 li  S
                            # logger.debug('# 枠保証審査依頼日時')
                            # if 'creditfacility_application' in data:
                            #     data_m_gps['creditfacility_application'] = data['creditfacility_application']
                            # if dt_now.strftime('%Y/%m/%d') != data_m_gps['udate'][:10]:
                            if 'creditfacility_application' in data:
                                data_m_gps['creditfacility_application'] = data['creditfacility_application']
                                # if 'examination_request_date' in data:
                                #     data_m_gps['examination_request_date'] = dt_now
                            # バグ #5345 2024/03/07 li  E

                            m_gps._update(data_m_gps)

                            pass

                        else:
                            
                            params_m_gps = {}

                            logger.debug('# 企業コード')
                            params_m_gps['company_code'] = data['company_code']

                            print('# 枠保証審査依頼日時')
                            # print('|||||||||||||||||||||||||2')
                            # print('|||||||||||||||||||||||||2')
                            if data['examination_request_date'] is None:
                                params_m_gps['examination_request_date'] = dt_now

                            m_gps._add(params_m_gps)

                        logger.debug('# ##############################')

                        pass

                pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            # 枠保証状況取得
            # get_payment_creditfacility_getbuyercreditfacility
            logger.debug('get_payment_creditfacility_getbuyercreditfacility')
            logger.debug('??????')

            if '# 枠保証状況取得する':

                logger.debug('# 枠保証状況取得する')

                params_gpcg = {}
                params_gpcg['targetBuyer'] = {}
                params_gpcg['targetBuyer']['shopCustomerId'] = data['company_code']

                # 6708----------10/16----------S
                params_gpcg['relatedData'] = {}
                params_gpcg['relatedData']['system_id'] = item_system_id
                params_gpcg['relatedData']['authenticationId'] = item_authenticationId
                params_gpcg['relatedData']['shopCode'] = item_shopCode
                params_gpcg['relatedData']['connectPassword'] = item_connectPassword
                # 6708----------10/16----------E

                res_gpcg = self.get_payment_creditfacility_getbuyercreditfacility(
                    params_gpcg)

                # {
                #   'statusCode': 200,
                #   'headers': {
                #     'Access-Control-Allow-Headers': 'Content-Type',
                #     'Access-Control-Allow-Origin': '*',
                #     'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
                #   },
                #   'body': '{\n
                #      "result": "OK",\n
                #      "errors": [],\n
                #      "buyer": {\n
                #         "shopCustomerId": "K30029"\n
                #       },\n
                #       "examination": {\n
                #          "status": "審査中",\n
                #          "resultReasons": []\n
                #       }\n
                #   }'
                # }

                logger.debug('res_gpcg')
                logger.debug(res_gpcg)

                if 'statusCode' in res_gpcg and res_gpcg['statusCode'] == 400:

                    if 'body' in res_gpcg:

                        tmp_error = json.loads(res_gpcg['body'])

                        logger.debug('tmp_error')
                        logger.debug(tmp_error)

                        error_message = ''

                        if 'errors' in tmp_error:
                            for e in tmp_error['errors']:
                                error_message += '【GMO枠保証申請】' + '<br/>'
                                error_message += '<br/>'
                                if 'errCode' in e and e['errCode'] is not None:
                                    error_message += e['errCode'] + '<br/>'
                                if 'errorMessage' in e and e['errorMessage'] is not None:
                                    error_message += e['errorMessage'] + '<br/>'

                        error = {
                            'code': 400,
                            'message': error_message
                        }

                        return GV.handle_error('ERROR', None, error)

                        pass

                if 'body' in res_gpcg:

                    body_gpcg = json.loads(res_gpcg['body'])

                    params_m_gps = {
                        'examination_status': None,
                        'creditfacility_upperlimit': None,
                        'creditfacility_balance': None,
                        'creditfacility_startdate': None,
                        'creditfacility_enddate': None,
                        'examination_resultreasons': None,
                        'examination_request_date': None
                    }

                    logger.debug('# 審査情報')
                    if 'examination' in body_gpcg:

                        logger.debug('# 枠保証審査ステータス')
                        if 'status' in body_gpcg['examination']:
                            examination_status = body_gpcg['examination']['status']
                            params_m_gps['examination_status'] = examination_status

                        logger.debug('# 枠保証審査結果事由情報')
                        if 'resultReasons' in body_gpcg['examination']:
                            resultReasons = body_gpcg['examination']['resultReasons']

                            examination_resultreasons = ''

                            if type(resultReasons) == list:
                                for r in resultReasons:
                                    examination_resultreasons += r + '\n'

                            params_m_gps['examination_resultreasons'] = examination_resultreasons

                    logger.debug('# 枠保証情報')
                    if 'creditFacility' in body_gpcg:

                        logger.debug('# 枠保証上限額')
                        if 'upperLimit' in body_gpcg['creditFacility']:
                            creditfacility_upperlimit = body_gpcg['creditFacility']['upperLimit']
                            params_m_gps['creditfacility_upperlimit'] = creditfacility_upperlimit

                        logger.debug('# 枠保証残高')
                        if 'balance' in body_gpcg['creditFacility']:
                            creditfacility_balance = body_gpcg['creditFacility']['balance']
                            params_m_gps['creditfacility_balance'] = creditfacility_balance

                        logger.debug('# 枠保証利用開始日')
                        if 'startDate' in body_gpcg['creditFacility']:
                            creditfacility_startdate = body_gpcg['creditFacility']['startDate']
                            params_m_gps['creditfacility_startdate'] = creditfacility_startdate

                        logger.debug('# 枠保証利用終了日')
                        if 'endDate' in body_gpcg['creditFacility']:
                            creditfacility_enddate = body_gpcg['creditFacility']['endDate']
                            params_m_gps['creditfacility_enddate'] = creditfacility_enddate

                    logger.debug('# ******************************')
                    logger.debug('# GMO掛け払い情報を更新する')
                    logger.debug('m_gmo_payment_service')

                    MGPS = GV.get_module('m_gmo_payment_service')
                    m_gps = MGPS()

                    filters = []
                    filters.append(m_gps.model_class.company_code ==
                                   data['company_code'])
                    filters = and_(*filters)
                    tmp_m_gps = m_gps._get_item_by_filters(filters)

                    if tmp_m_gps is not None:

                        data_m_gps = tmp_m_gps.to_dict()
                        if params_m_gps['examination_status'] is not None:
                            data_m_gps['examination_status'] = params_m_gps['examination_status']
                        if params_m_gps['creditfacility_upperlimit'] is not None:
                            data_m_gps['creditfacility_upperlimit'] = params_m_gps['creditfacility_upperlimit']
                        if params_m_gps['creditfacility_balance'] is not None:
                            data_m_gps['creditfacility_balance'] = params_m_gps['creditfacility_balance']
                        if params_m_gps['creditfacility_startdate'] is not None:
                            data_m_gps['creditfacility_startdate'] = params_m_gps['creditfacility_startdate']
                        if params_m_gps['creditfacility_enddate'] is not None:
                            data_m_gps['creditfacility_enddate'] = params_m_gps['creditfacility_enddate']
                        if params_m_gps['examination_resultreasons'] is not None:
                            data_m_gps['examination_resultreasons'] = params_m_gps['examination_resultreasons']
                        # バグ #5345 2024/03/07 li  S
                        dt_nowdata = datetime.now()
                        # print('|||||||||||||||||||||||||4')
                        # print(params_m_gps['examination_request_date'])
                        # print('|||||||||||||||||||||||||4')
                        # if params_m_gps['examination_request_date'] is not None:
                        data_m_gps['examination_request_date'] = dt_nowdata
                        # バグ #5345 2024/03/07 li  E

                        tmp_m_gps_update = m_gps._update(data_m_gps)

                        if tmp_m_gps_update is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# GMO掛け払い情報を更新失敗')
                            logger.debug(data_m_gps)
                            raise CustomException('SYS_ERR_100')

                        pass

                    pass

                    logger.debug('# ##############################')

            self.get_frame_guarantee_status(data)

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# 企業情報更新履歴更新')
            logger.debug('# m_update_company_info_history')

            # m_update_company_info_history
            MUCIH = GV.get_module('m_update_company_info_history')
            m_ucih = MUCIH()

            params_m_ucih = {
                # // 更新履歴ID
                # //
                # // 企業コード
                'company_code': data['company_code'],
                # // Auth0ユーザーID
                'auth0_user_id': data['auth0_user_id'],
                # // 名前(姓)
                'name_last': data['name_last'],
                # // 名前(名)
                'name_first': data['name_first'],
                # // メールアドレス
                'email': data['email'],
                # // 更新元
                'update_from': '企業情報管理アプリ'
                # // 更新日時
            }
            tmp_m_ucih = m_ucih._add(params_m_ucih)
            logger.debug(tmp_m_ucih)

            logger.debug('# ##############################')

        except NameError as e:
            logger.debug(e)
        except KeyError as e:
            logger.debug(e)
            logger.debug('KeyError will be handled here.')
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise

        return {}

    # 削除する
    def delete(self, event, context):
        return {}
        pass

    def regist_contract_data(self, data):
        try:
            logger.debug(data)
            res = {}

            company_code = None

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        # 'system_id': GV.SYSTEM_ID,
                        # 'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr is None:
                    pass
                else:
                    if 'company_code' in data_t_mr:
                        if data_t_mr['company_code'].startswith("K"):
                            company_code = data_t_mr['company_code']

            logger.debug('# ##############################')

            data_t_crh = None

            logger.debug('# ******************************')

            if '# テーブル「本契約申込履歴」からデータ取得':

                logger.debug('# テーブル「本契約申込履歴」からデータ取得')
                logger.debug('# t_contract_request_history')

                params = {
                    'table_name': 't_contract_request_history',
                    'filters': {
                        'contract_req_id': data['contract_req_id']
                    }
                }
                data_t_crh = self.get_data(params)

                if data_t_crh is None:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「企業マスタ」にデータ登録':

                logger.debug('# テーブル「企業マスタ」にデータ登録')
                logger.debug('# m_company')

                data_m_com = None

                if company_code is None:

                    logger.debug('# 存在しない場合、データを登録')

                    MCOM = GV.get_module('m_company')
                    m_com = MCOM()

                    params_m_c_add = {}
                    # 企業コード
                    # params_m_c_add['company_code'] = data['company_code']
                    # # 申込みコード
                    # params_m_c_add['entry_code'] = data['entry_code']
                    # # 営業コード
                    # params_m_c_add['salesman_code'] = data['salesman_code']
                    # 企業名
                    params_m_c_add['company_name'] = data_t_crh['company_name']
                    # 企業名(カナ)
                    params_m_c_add['company_name_kana'] = data_t_crh['company_name_kana']
                    # 郵便番号
                    params_m_c_add['company_zipcode'] = data_t_crh['company_zip_code']
                    # 住所(都道府県)
                    params_m_c_add['company_address_pref'] = data_t_crh['company_address_pref']
                    # 住所1
                    params_m_c_add['company_address_1'] = data_t_crh['company_address_1']
                    # 住所2
                    params_m_c_add['company_address_2'] = data_t_crh['company_address_2']
                    # 住所3
                    params_m_c_add['company_address_3'] = data_t_crh['company_address_3']
                    # # 住所1(カナ)
                    # params_m_c_add['company_address_1_kana'] = data['company_address_1_kana']
                    # # 住所2(カナ)
                    # params_m_c_add['company_address_2_kana'] = data['company_address_2_kana']
                    # # 住所3(カナ)
                    # params_m_c_add['company_address_3_kana'] = data['company_address_3_kana']
                    # 電話番号1
                    params_m_c_add['company_tel_1'] = data_t_crh['company_telephone_number']
                    # # FAX1
                    # params_m_c_add['company_fax_1'] = data['company_fax_1']
                    # 代表者名(姓)
                    params_m_c_add['company_leader_last'] = data_t_crh['company_last_name']
                    # 代表者名(名)
                    params_m_c_add['company_leader_first'] = data_t_crh['company_first_name']
                    # 代表者名(姓)(カナ)
                    params_m_c_add['company_leader_kana_last'] = data_t_crh['company_last_name_kana']
                    # 代表者名(名)(カナ)
                    params_m_c_add['company_leader_kana_first'] = data_t_crh['company_first_name_kana']
                    # 登録日
                    params_m_c_add['insert_date'] = self.NOW
                    # 更新日
                    params_m_c_add['update_date'] = self.NOW
                    # # 削除フラグ
                    # params_m_c_add['delete_flg'] = data['delete_flg']
                    # # system_usable_flag
                    # params_m_c_add['system_usable_flag'] = data['system_usable_flag']
                    # 代表者の生年月日
                    params_m_c_add['company_leader_date_of_birth'] = data_t_crh['company_leader_date_of_birth']
                    # 企業備考欄
                    params_m_c_add['customer_notes'] = data_t_crh['company_remarks_column']
                    # # GMO掛け払いのデータ更新あり
                    # params_m_c_add['need_gmo_ps_creditfacility_modifybuyer'] = data['need_gmo_ps_creditfacility_modifybuyer']

                    logger.debug('# データ登録')
                    tmp_m_com = m_com._add(params_m_c_add)

                    if tmp_m_com is None:
                        logger.debug('# テーブル「企業マスタ」にデータ登録失敗')
                        logger.debug(params_m_c_add)
                        raise CustomException('SYS_ERR_100')
                        pass

                    data_m_com = tmp_m_com.to_dict()
                    logger.debug(data_m_com)
                    pass

                    if data_m_com is not None:
                        company_code = data_m_com['company_code']

                else:

                    logger.debug('# ・同一のシステム、サービス、企業コード、契約者のメールアドレスの場合に以下の処理をする。')
                    logger.debug('# ・新しい本契約申込情報で企業マスタを上書きする')

                    MCOM = GV.get_module('m_company')
                    m_com = MCOM()

                    params_m_c_update = {}
                    # 企業コード
                    params_m_c_update['company_code'] = company_code
                    # # 申込みコード
                    # params_m_c_update['entry_code'] = data['entry_code']
                    # # 営業コード
                    # params_m_c_update['salesman_code'] = data['salesman_code']
                    # 企業名
                    params_m_c_update['company_name'] = data_t_crh['company_name']
                    # 企業名(カナ)
                    params_m_c_update['company_name_kana'] = data_t_crh['company_name_kana']
                    # 郵便番号
                    params_m_c_update['company_zipcode'] = data_t_crh['company_zip_code']
                    # 住所(都道府県)
                    params_m_c_update['company_address_pref'] = data_t_crh['company_address_pref']
                    # 住所1
                    params_m_c_update['company_address_1'] = data_t_crh['company_address_1']
                    # 住所2
                    params_m_c_update['company_address_2'] = data_t_crh['company_address_2']
                    # 住所3
                    params_m_c_update['company_address_3'] = data_t_crh['company_address_3']
                    # # 住所1(カナ)
                    # params_m_c_update['company_address_1_kana'] = data['company_address_1_kana']
                    # # 住所2(カナ)
                    # params_m_c_update['company_address_2_kana'] = data['company_address_2_kana']
                    # # 住所3(カナ)
                    # params_m_c_update['company_address_3_kana'] = data['company_address_3_kana']
                    # 電話番号1
                    params_m_c_update['company_tel_1'] = data_t_crh['company_telephone_number']
                    # # FAX1
                    # params_m_c_update['company_fax_1'] = data['company_fax_1']
                    # 代表者名(姓)
                    params_m_c_update['company_leader_last'] = data_t_crh['company_last_name']
                    # 代表者名(名)
                    params_m_c_update['company_leader_first'] = data_t_crh['company_first_name']
                    # 代表者名(姓)(カナ)
                    params_m_c_update['company_leader_kana_last'] = data_t_crh['company_last_name_kana']
                    # 代表者名(名)(カナ)
                    params_m_c_update['company_leader_kana_first'] = data_t_crh['company_first_name_kana']
                    # 登録日
                    params_m_c_update['insert_date'] = self.NOW
                    # 更新日
                    params_m_c_update['update_date'] = self.NOW
                    # # 削除フラグ
                    # params_m_c_update['delete_flg'] = data['delete_flg']
                    # # system_usable_flag
                    # params_m_c_update['system_usable_flag'] = data['system_usable_flag']
                    # 代表者の生年月日
                    params_m_c_update['company_leader_date_of_birth'] = data_t_crh['company_leader_date_of_birth']
                    # 企業備考欄
                    params_m_c_update['customer_notes'] = data_t_crh['company_remarks_column']
                    # # GMO掛け払いのデータ更新あり
                    # params_m_c_update['need_gmo_ps_creditfacility_modifybuyer'] = data['need_gmo_ps_creditfacility_modifybuyer']

                    logger.debug('# データ登録')
                    tmp_m_com = m_com._update(params_m_c_update)

                    if tmp_m_com is None:
                        logger.debug('# テーブル「企業マスタ」にデータ更新失敗')
                        logger.debug(params_m_c_update)
                        raise CustomException('SYS_ERR_100')
                        pass

                    data_m_com = tmp_m_com.to_dict()
                    logger.debug(data_m_com)
                    
                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_crc = None

            if '# テーブル「本契約申込情報（確認済み）」からデータ検索':

                logger.debug('# テーブル「本契約申込情報（確認済み）」からデータ検索')
                logger.debug('# t_contract_request_confirmed')

                params = {
                    'table_name': 't_contract_request_confirmed',
                    'filters': {
                        'contract_req_id': data['contract_req_id']
                    }
                }
                data_t_crc = self.get_data(params)

                if data_t_crc:
                    logger.debug('# 存在する場合、なにもしない')
                    pass
                else:
                    logger.debug('# 存在しない場合、履歴からのデータを登録')

                    logger.debug('# 履歴のデータをコピー')
                    data_t_crc = {}
                    data_t_crc = data_t_crh.copy()

                    logger.debug('# ******************************')

                    if '# テーブル「本契約申込情報（確認済み）」にデータ登録':

                        logger.debug('# テーブル「本契約申込情報（確認済み）」にデータ登録')
                        logger.debug('# t_contract_request_confirmed')

                        logger.debug('# 「企業コード」をセットする')
                        data_t_crc['company_code'] = company_code

                        # from ..model.t_contract_request_confirmed import Sub as TCRC
                        # t_crc = TCRC()
                        TCRC = GV.get_module('t_contract_request_confirmed')
                        t_crc = TCRC()

                        logger.debug('# データ登録')
                        tmp_t_crc = t_crc._add(data_t_crc)

                        if tmp_t_crc is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# データ登録失敗')
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# データ登録成功')

                        data_t_crc = tmp_t_crc.to_dict()
                        logger.debug(data_t_crc)

                    logger.debug('# ##############################')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                # from ..model.t_manage_request import Sub as TMR
                # t_mr = TMR()
                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')

                    logger.debug('・同一のシステム、サービス、企業コード、契約者のメールアドレスの場合に以下の処理をする。')
                    logger.debug('・新しい本契約申込IDで申込管理情報のテーブルを上書きする')

                    # 企業コード
                    data_t_mr['company_code'] = company_code
                    # 契約ID
                    data_t_mr['contract_id'] = None
                    # 本契約申込ID
                    data_t_mr['contract_req_id'] = data['contract_req_id']
                    # ステータス
                    data_t_mr['status'] = GV.STATUS['本契約申請']
                    # システム利用可能フラグ
                    data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']

                    # 信用調査
                    del data_t_mr['credit_check'] 
                    # 信用調査結果登録日
                    del data_t_mr['credit_check_regist_date'] 
                    # プロスペクト申請
                    del data_t_mr['prospect_request'] 
                    # プロスペクト申請結果登録日
                    del data_t_mr['prospect_request_regist_date'] 

                    logger.debug('# データ更新')
                    tmp_t_mr_1 = t_mr._update(data_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    data_t_mr = {}
                    # # 申込管理ID
                    # data_t_mr['manage_req_id'] =
                    # 企業コード
                    data_t_mr['company_code'] = company_code
                    # システムID
                    data_t_mr['system_id'] = GV.SYSTEM_ID
                    # サービスID
                    data_t_mr['service_id'] = GV.SERVICE_ID
                    # # 契約ID
                    # data_t_mr['contract_id'] =
                    # Auth0ユーザーID
                    data_t_mr['auth0_user_id'] = data['auth0_user_id']
                    # # 資料請求ID
                    # data_t_mr['document_req_id'] =
                    # # トライアル環境ストックID
                    # data_t_mr['trial_env_stock_id'] = trial_env_stock_id
                    # # トライアル申込ID
                    # data_t_mr['trial_req_id'] =
                    # ワークショップ申込ID
                    data_t_mr['contract_req_id'] = data['contract_req_id']
                    # # 本契約申込ID
                    # data_t_mr['contract_req_id'] =
                    # # 担当営業コード
                    # data_t_mr['salesman_code'] =
                    # システム利用可能フラグ
                    logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                    data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                    # ステータス
                    data_t_mr['status'] = GV.STATUS['本契約申請']
                    # # 作成日時
                    # data_t_mr['cdate'] =
                    # # 更新日時
                    # data_t_mr['udate'] =

                    logger.debug('# データ登録')
                    tmp_t_mr_1 = t_mr._add(data_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_sys = None

            if '# テーブル「システムマスタ」からデータ取得':

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }
                data_m_sys = self.get_data(params)
                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ取得OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】':

                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】')
                logger.debug('# m_auth_user_info')

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                param_m_aui = {}
                # # Auth0ユーザー情報管理ID
                # param_m_aui['auth_user_info_id'] = ''
                logger.debug('# **************0702****S************')
                # テナント
                param_m_aui['tenant'] = data_t_crc['tenant']
                logger.debug('# **************0702****E************')
               
                # Auth0ユーザーID
                param_m_aui['auth0_user_id'] = data['auth0_user_id']
                # ログイン先企業コード
                param_m_aui['company_code'] = company_code
                # ログイン先システムID
                param_m_aui['system_id'] = GV.REQUEST_USER_SYSTEM_ID
                # ログイン先サービスID
                param_m_aui['service_id'] = GV.REQUEST_USER_SERVICE_ID

                logger.debug('# 本契約申し込みする際、metadataにはアプリ環境情報はセットしない。')
                # 付与ロールのリスト
                param_m_aui['roles'] = [GV.ROLES_REQUEST_USER]
                # # 作成日時
                # param_m_aui['cdate'] = ''
                # # 更新日時
                # param_m_aui['udate'] = ''

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': param_m_aui['auth0_user_id'],
                        'company_code': param_m_aui['company_code'],
                        'system_id': param_m_aui['system_id'],
                        'service_id': param_m_aui['service_id']
                    }
                }
                data_m_aui = self.get_data(params)
                logger.debug(data_m_aui)

                tmp_m_aui = None

                if data_m_aui:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                    param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                    tmp_m_aui = m_aui._update(param_m_aui)
                    pass
                else:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                    tmp_m_aui = m_aui._add(param_m_aui)
                    pass

                if tmp_m_aui is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録 company_code = None':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'auth0_user_id': data['auth0_user_id'],
                        'company_code': 'NONE'
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u is not None:
                    logger.debug('# 存在する場合、どうする？')

                    MU = GV.get_module('m_user')
                    m_u = MU()

                    # 企業コード
                    data_m_u['company_code'] = company_code
                    # 名前
                    data_m_u['name_last'] = data_t_crc['contract_last_name']
                    # 名前(姓)
                    data_m_u['name_first'] = data_t_crc['contract_first_name']
                    # 名前(名)
                    data_m_u['name_last_kana'] = data_t_crc['contract_last_name_kana']
                    # 名前(カナ)(姓)
                    data_m_u['name_first_kana'] = data_t_crc['contract_first_name_kana']
                    # 部署名(カナ)(名)
                    data_m_u['department'] = data_t_crc['contract_affiliation_department']
                    # 役職
                    data_m_u['position'] = data_t_crc['contract_director']
                    # メールアドレス
                    data_m_u['email'] = data_t_crc['contract_email_address']
                    # 電話番号
                    data_m_u['tel'] = data_t_crc['contract_telephone_number']

                    logger.debug('# データ更新')
                    tmp_m_u = m_u._update(data_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録 company_code != None':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'auth0_user_id': data['auth0_user_id'],
                        'company_code': company_code
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u is not None:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')
                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    # from ..model.m_user import Sub as MU
                    # m_u = MU()
                    MU = GV.get_module('m_user')
                    m_u = MU()

                    param_m_u = {}
                    # # ユーザーマスタID
                    # param_m_u['user_master_id'] = data['user_master_id']
                    # Auth0ユーザーID
                    param_m_u['auth0_user_id'] = data['auth0_user_id']
                    # 企業コード
                    param_m_u['company_code'] = company_code
                    # 名前
                    param_m_u['name_last'] = data_t_crc['contract_last_name']
                    # 名前(姓)
                    param_m_u['name_first'] = data_t_crc['contract_first_name']
                    # 名前(名)
                    param_m_u['name_last_kana'] = data_t_crc['contract_last_name_kana']
                    # 名前(カナ)(姓)
                    param_m_u['name_first_kana'] = data_t_crc['contract_first_name_kana']
                    # 部署名(カナ)(名)
                    param_m_u['department'] = data_t_crc['contract_affiliation_department']
                    # 役職
                    param_m_u['position'] = data_t_crc['contract_director']
                    # メールアドレス
                    param_m_u['email'] = data_t_crc['contract_email_address']
                    # 電話番号
                    param_m_u['tel'] = data_t_crc['contract_telephone_number']
                    # # 招待コード
                    # param_m_u['invitation_code'] = ''
                    # # 招待日時
                    # param_m_u['invitation_date'] = ''
                    # # 登録日時
                    # param_m_u['cdate'] = ''
                    # # 更新日時
                    # param_m_u['udate'] = ''

                    logger.debug('# データ登録')
                    tmp_m_u = m_u._add(param_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # if '# テーブル「m_directory_user」にデータ登録':

            #     logger.debug('# テーブル「m_directory_user」にデータ登録')
            #     logger.debug('# m_directory_user')

            #     params = {
            #         'table_name': 'm_directory_user',
            #         'filters': {
            #             'company_code': company_code,
            #             'user_email': data_t_crc['contract_email_address']
            #         }
            #     }
            #     data_m_u = self.get_data(params)

            #     if data_m_u:
            #         logger.debug('# 存在する場合、どうする？')
            #         logger.debug('# ???')
            #         pass
            #     else:
            #         logger.debug('# 存在しない場合、データを登録')

            #         # ???
            #         # ワークショップの場合
            #         # 10 ユーザー作成？

            #         # from ..model.m_directory_user import Sub as MDU
            #         # m_du = MDU()
            #         MDU = GV.get_module('m_directory_user')
            #         m_du = MDU()

            #         param_m_du = {}

            #         # company_code
            #         param_m_du['company_code'] = company_code
            #         # directory_username
            #         param_m_du['directory_username'] = company_code + \
            #             '.' + 'user000'
            #         # user_email
            #         param_m_du['user_email'] = data_t_crc['contract_email_address']

            #         logger.debug('# データ登録')
            #         tmp_m_du = m_du._add(param_m_du)

            #         if tmp_m_du:
            #             logger.debug(tmp_m_du.to_dict())
            #             pass
            #         else:
            #             raise CustomException('SYS_ERR_100')
            #             pass

            # logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# 「環境ストックマスタ」からデータ取得':

                logger.debug('# 「環境ストックマスタ」からデータ取得')
                logger.debug('# m_env_stock')

                params = {
                    'table_name': 'm_env_stock',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'company_code': 'NONE',
                        'use_flg': False,
                        'startup_flg': False,
                        'deleted_flag': False
                    },
                    'order_by': {
                        'env_id': 'asc'
                    }
                }
                tmp_m_es = self.get_data(params, is_get_dict=False)

                if tmp_m_es is None:
                    logger.debug('# 「未使用」のデータがない場合')

                    logger.debug('# ******************************')

                    logger.debug('# 申込成功後、環境ストックが無くて自動割り当てができない')
                    logger.debug('# 本契約時の環境作成、割り当て依頼')
                    logger.debug('# メール送信')

                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = '本契約時の環境作成、割り当て依頼'

                    data_email['system_id'] = GV.SYSTEM_ID
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['system_name'] = GV.SYSTEM_NAME
                    data_email['service_name'] = GV.SERVICE_NAME
                    data_email['company_name'] = data_t_crh['company_name']
                    data_email['company_code'] = company_code

                    self.send_email_contract(data_email)

                    logger.debug('# ##############################')

                    # return res
                    # pass

                else:
                    logger.debug('# 「未使用」のデータがある場合')

                    data_m_es = tmp_m_es.to_dict()

                    # logger.debug('# ******************************')

                    # if '# 「企業コード」をセットする':

                    #     MES = GV.get_module('m_env_stock')
                    #     m_es = MES()

                    #     logger.debug('# 「企業コード」をセットする')
                    #     logger.debug('# company_code')

                    #     data_m_es['company_code'] = company_code

                    #     # logger.debug('# 「使用フラグ」をTrueにする')
                    #     # logger.debug('# use_flg')

                    #     # data_m_es['use_flg'] = True

                    #     m_es._update(data_m_es)

                    # logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# 「企業コード」をセットする':

                        ES = GV.get_module('env_stock')
                        es = ES()

                        logger.debug('# 「企業コード」をセットする')
                        logger.debug('# company_code')
                        
                        data_m_es['company_code'] = company_code
            
                        # data_m_es['use_flg'] = True

                        es._update(data_m_es)

                    logger.debug('# ##############################')

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            if '# テーブル「サプライヤー情報」からGMO掛け払いの使用有無をデータ取得':

                logger.debug('# テーブル「サプライヤー情報」からGMO掛け払いの使用有無をデータ取得')
                logger.debug('# m_supplier_info')

                params = {
                    'table_name': 'm_supplier_info',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }
                data_m_supinfo = self.get_data(params)

                if data_m_supinfo is None:
                    raise CustomException('SYS_ERR_100')
            # 支払方法がGMO掛け払いの場合
            print(data_m_supinfo)
            if data_m_supinfo['use_gmo_payment'] is not None and data_m_supinfo['use_gmo_payment'] == True:
                if '# GMO掛け払いの枠保証申請額を登録する':

                    logger.debug('# GMO掛け払い情報')
                    logger.debug('m_gmo_payment_service')

                    params_m_gps = {}

                    logger.debug('# 企業コード')
                    params_m_gps['company_code'] = company_code

                    MGPS = GV.get_module('m_gmo_payment_service')
                    m_gps = MGPS()

                    filters = []
                    filters.append(m_gps.model_class.company_code ==
                                company_code)
                    filters = and_(*filters)
                    tmp_m_gps = m_gps._get_item_by_filters(filters)

                    if tmp_m_gps is not None:

                        data_m_gps = tmp_m_gps.to_dict()

                        logger.debug('# 「枠保証申請額」をセットする')
                        logger.debug('# 契約しているサービスの枠保証額を加算する')

                        if data_m_gps['creditfacility_application'] is None:
                            data_m_gps['creditfacility_application'] = 0

                        if GV.SERVICE['gmo_ps_req_upper_limit'] is None:
                            GV.SERVICE['gmo_ps_req_upper_limit'] = 0

                        data_m_gps['creditfacility_application'] += GV.SERVICE['gmo_ps_req_upper_limit']

                        m_gps._update(data_m_gps)

                        pass
                    else:

                        logger.debug('# 「枠保証申請額」をセットする')
                        logger.debug('# 契約しているサービスの枠保証額を加算する')

                        if GV.SERVICE['gmo_ps_req_upper_limit'] is None:
                            GV.SERVICE['gmo_ps_req_upper_limit'] = 0

                        params_m_gps['creditfacility_application'] = GV.SERVICE['gmo_ps_req_upper_limit']

                        m_gps._add(params_m_gps)

                        pass

            logger.debug('# ##############################')
            
            logger.debug('# **************0611****S*******検証')
            
            
            # if '# テーブル「商品グループマスタ」からデータ検索':
            #     # 選択された商品グループIDを持つ通常商品と指定された
            

            
            

            #     logger.debug('# テーブル「商品グループマスタ」からデータ検索')
            #     logger.debug('# m_product_groups')
                
            #     for t2 in data_t_crc['contract_product_request']:
            #         ditem2 = t2
            #         logger.debug(ditem2)
            #         logger.debug(ditem2['main_product_id'])

            #         params = {
            #             'table_name': 'm_product_groups',
            #             'filters': {
            #                 'main_product_id': ditem2['main_product_id']
            #             }
            #         }
            #         data_m_pg = self.get_data(params)
    
            #         if data_m_pg:
            #             logger.debug('# テーブル「通常商品マス」からデータ検索')

            #             if '# 「通常商品マスタ」をセットする':
                            
            #                 params1 = {
            #                     'table_name': 'm_regular_products',
            #                     'filters': {
            #                         'product_id': ditem2['main_product_id']
            #                     }
            #                 }
            #                 data_m_rp = self.get_data(params1)
                            
            #                 if data_m_rp:
            #                     logger.debug('# 存在する場合、通常商品と指定され')
    
            #                     ES = GV.get_module('m_regular_products')
            #                     es = ES()
        
            #                     logger.debug('# 「商品グループID」をセットする')
            #                     logger.debug('# product_group_id')
                                
            #                     data_m_rp['product_group_id'] = data_m_pg['product_group_id']

            #                     es._update(data_m_rp)
                                
            #                 pass

            # if '# テーブル「契約商品マスタ」にデータ登録する':
            #     # 契約商品マスタに登録する。利用開始日は契約開始日と同日を設定する。利用終了日は空白。
            #     logger.debug('# テーブル「契約商品マスタ」にデータ登録する')
            #     logger.debug('m_contract_product')
            #     for t2 in data_t_crc['contract_product_request']:
            #         ditem2 = t2
            #         logger.debug(ditem2)
            #         logger.debug(ditem2['main_product_id'])
            #         logger.debug(data_t_crc['entry_code'])
                    
            #         params = {
            #             'table_name': 'm_contract',
            #             'filters': {
            #                 'company_code': company_code,
            #                 'entry_code': data_t_crc['entry_code']
            #             }
            #         }
            #         data_m_c = self.get_data(params)
    
            #         if data_m_c is not None:
            #             logger.debug('# contract_product_request 存在する場合')

            #             params = {
            #                 'table_name': 'm_contract_product',
            #                 'filters': {
            #                     'contract_id': data_m_c['contract_id'],
            #                     'product_id': ditem2['main_product_id'] 
            #                 }
            #             }
            #             data_c_p = self.get_data(params)
        
            #             if data_c_p is not None:
            #                 logger.debug('#m_contract_product 存在する場合')
        
            #                 MCP = GV.get_module('m_contract_product')
            #                 m_cp = MCP()
                            
            #                 # 第一回　更新作成
            #                 if data_c_p['quantity'] == None:
            #                     # 数量
            #                     data_c_p['quantity'] = ditem2['quantity']
            #                     # 利用開始日
            #                     data_c_p['use_start_date'] = data_m_c['subscription_start_date']
            #                     # 利用終了日
            #                     data_c_p['use_end_date'] = None
        
            #                     logger.debug('# データ更新')
            #                     tmp_m_cp = m_cp._update(data_c_p)
            
            #                     if tmp_m_cp:
            #                         logger.debug(tmp_m_cp.to_dict())
            #                         pass
            #                     else:
            #                         raise CustomException('SYS_ERR_100')
            #                         pass
            #                 # else:
            #                 #     # 数量を変更場合
            #                 #     current_year = datetime.now().year
            #                 #     current_month = datetime.now().month
            #                 #     if data_c_p['quantity'] > ditem2['quantity']:
            #                 #         # 利用開始日＞＝今月		そのまま
            #                 #         # 利用開始日＜今月		利用終了日に先月末日を設定。新規レコードは追加

            #                 #         if data_c_p['use_start_date'].year < current_year or \
            #                 #           (data_c_p['use_start_date'].year == current_year and data_c_p['use_start_date'].month < current_month):
            #                 #             last_day_of_previous_month = datetime.datetime(current_year, current_month, 1) - datetime.timedelta(days=1)
            #                 #             # 利用終了日に先月末日を設定。
            #                 #             # 利用終了日
            #                 #             data_c_p['use_end_date'] = last_day_of_previous_month

            #                 #             logger.debug('# データ更新')
            #                 #             tmp_m_cp = m_cp._update(data_c_p)
                    
            #                 #             if tmp_m_cp:
            #                 #                 logger.debug(tmp_m_cp.to_dict())
            #                 #                 pass
            #                 #             else:
            #                 #                 raise CustomException('SYS_ERR_100')
            #                 #                 pass
            #                 #             # 新規レコードは追加
            #                 #             param_m_cp = {}
            #                 #             param_m_cp['contract_id'] = data_c_p['contract_id']
            #                 #             param_m_cp['product_id'] = data_c_p['product_id']
            #                 #             # 数量
            #                 #             param_m_cp['quantity'] = ditem2['quantity']
            #                 #             # 利用開始日
            #                 #             param_m_cp['use_start_date'] = datetime(current_year, current_month, 1)
            #                 #             # 利用終了日
            #                 #             param_m_cp['use_end_date'] = None
        
            #                 #             tmp_m_cp_add = m_cp._add(param_m_cp)
            #                 #         else:
                                        
            #                 #             # 数量
            #                 #             data_c_p['quantity'] = ditem2['quantity']

            #                 #             logger.debug('# データ更新')
            #                 #             tmp_m_cp = m_cp._update(data_c_p)
                    
            #                 #             if tmp_m_cp:
            #                 #                 logger.debug(tmp_m_cp.to_dict())
            #                 #                 pass
            #                 #             else:
            #                 #                 raise CustomException('SYS_ERR_100')
            #                 #                 pass
                                        
                                        
            #                 #     if data_c_p['quantity'] < ditem2['quantity']:
            #                 #         # 利用開始日＜＝今月		今月末日を設定		変更された数量でレコードを追加		
            #                 #         # 利用開始日＞今月		数量を変更

            #                 #         if data_c_p['use_start_date'].year < current_year or \
            #                 #           (data_c_p['use_start_date'].year == current_year and data_c_p['use_start_date'].month <= current_month):
                                        
            #                 #             # 来月月初を指定
            #                 #             first_day_of_next_month = datetime(current_date.year, current_month.month, 1) + timedelta(days=32)
                                        
            #                 #             # 今月末日を設定
            #                 #             last_day_of_current_month = first_day_of_next_month - timedelta(days=1)
                                        
            #                 #             # 利用終了日に今月末日を設定。
            #                 #             # 利用終了日
            #                 #             data_c_p['use_end_date'] = last_day_of_current_month

            #                 #             logger.debug('# データ更新')
            #                 #             tmp_m_cp = m_cp._update(data_c_p)
                    
            #                 #             if tmp_m_cp:
            #                 #                 logger.debug(tmp_m_cp.to_dict())
            #                 #                 pass
            #                 #             else:
            #                 #                 raise CustomException('SYS_ERR_100')
            #                 #                 pass
            #                 #             # 新規レコードは追加
            #                 #             param_m_cp = {}
            #                 #             param_m_cp['contract_id'] = data_c_p['contract_id']
            #                 #             param_m_cp['product_id'] = data_c_p['product_id']
            #                 #             # 数量
            #                 #             param_m_cp['quantity'] = ditem2['quantity']
            #                 #             # 利用開始日
            #                 #             param_m_cp['use_start_date'] = first_day_of_next_month
            #                 #             # 利用終了日
            #                 #             param_m_cp['use_end_date'] = None
        
            #                 #             tmp_m_cp_add = m_cp._add(param_m_cp)
            #                 #         else:
                                        
            #                 #             # 数量
            #                 #             data_c_p['quantity'] = ditem2['quantity']

            #                 #             logger.debug('# データ更新')
            #                 #             tmp_m_cp = m_cp._update(data_c_p)
                    
            #                 #             if tmp_m_cp:
            #                 #                 logger.debug(tmp_m_cp.to_dict())
            #                 #                 pass
            #                 #             else:
            #                 #                 raise CustomException('SYS_ERR_100')
            #                 #                 pass

            logger.debug('# #############0611########E#########')
            
            logger.debug('# ******************************')
            logger.debug('# 本契約申込完了連絡 本契約申込受付_お客様用 メール送信')

            # data_email = {}
            # data_email = data_t_crc.copy()

            # data_email['contract_zipcode'] = data_email['contract_zip_code']
            # data_email['contract_tel_1'] = data_email['contract_telephone_number']
            # data_email['contract_email'] = data_email['contract_email_address']
            # data_email['contract_department'] = data_email['contract_affiliation_department']
            # data_email['contract_position'] = data_email['contract_director']
            # data_email['invoice_sending_method'] = data_email['gmo_invoice_mail']

            # data_email['email_address'] = data_t_crc['contract_email_address']

            # data_email['system_id'] = GV.SYSTEM_ID
            # data_email['system_name'] = GV.SYSTEM_NAME
            # data_email['service_id'] = GV.SERVICE_ID
            # data_email['service_name'] = GV.SERVICE_NAME
            # data_email['company_code'] = company_code

            data_email = {}
            data_email['service_id'] = GV.SERVICE_ID
            data_email['email_address'] = data_t_crc['contract_email_address']
            data_email['mail_type'] = '本契約申込受付_お客様用'

            data_email['company_name'] = data_t_crc['company_name']
            data_email['contract_affiliation_department'] = data_t_crc['contract_affiliation_department']
            data_email['contract_last_name'] = data_t_crc['contract_last_name']
            data_email['contract_first_name'] = data_t_crc['contract_first_name']
            data_email['entry_code'] = data_t_crc['entry_code']
            
            cdate = data_t_crc["cdate"]
            cdate = datetime.strptime(
                cdate[0:19], '%Y-%m-%dT%H:%M:%S')
            cdate = cdate.strftime('%Y/%m/%d %H:%M:%S')
            data_email['cdate'] = cdate
            
            logger.debug('# **************0611****S************')
            data_email['service_name'] =   GV.SERVICE_NAME
            contract_product_listStr = ""
            for product_request in data_t_crh['contract_product_request']:
                billing_identifier = product_request['billing_identifier']
                quantity = product_request['quantity']
                contract_product_listStr += billing_identifier + ' 同時実行数：' + quantity + '\n'
            data_email['contract_product_list'] = contract_product_listStr[:-1]
            logger.debug('# **************0611****E************')

            data_email['contract_zip_code'] = data_t_crc['contract_zip_code']
            data_email['contract_address_pref'] = data_t_crc['contract_address_pref']
            data_email['contract_address_1'] = data_t_crc['contract_address_1']
            data_email['contract_address_2'] = data_t_crc['contract_address_2']
            data_email['contract_address_3'] = data_t_crc['contract_address_3']
            data_email['contract_last_name'] = data_t_crc['contract_last_name']
            data_email['contract_first_name'] = data_t_crc['contract_first_name']
            data_email['contract_last_name_kana'] = data_t_crc['contract_last_name_kana']
            data_email['contract_first_name_kana'] = data_t_crc['contract_first_name_kana']
            data_email['contract_affiliation_department'] = data_t_crc['contract_affiliation_department']
            data_email['contract_director'] = data_t_crc['contract_director']
            data_email['contract_email_address'] = data_t_crc['contract_email_address']
            data_email['contract_telephone_number'] = data_t_crc['contract_telephone_number']
            data_email['company_name'] = data_t_crc['company_name']
            data_email['company_name_kana'] = data_t_crc['company_name_kana']
            data_email['company_zip_code'] = data_t_crc['company_zip_code']
            data_email['company_address_pref'] = data_t_crc['company_address_pref']
            data_email['company_address_1'] = data_t_crc['company_address_1']
            data_email['company_address_2'] = data_t_crc['company_address_2']
            data_email['company_address_3'] = data_t_crc['company_address_3']
            data_email['company_last_name'] = data_t_crc['company_last_name']
            data_email['company_first_name'] = data_t_crc['company_first_name']
            data_email['company_last_name_kana'] = data_t_crc['company_last_name_kana']
            data_email['company_first_name_kana'] = data_t_crc['company_first_name_kana']
            data_email['company_telephone_number'] = data_t_crc['company_telephone_number']

            company_leader_date_of_birth = data_t_crc["company_leader_date_of_birth"]
            company_leader_date_of_birth = datetime.strptime(
                company_leader_date_of_birth[0:19], '%Y-%m-%dT%H:%M:%S')
            company_leader_date_of_birth = company_leader_date_of_birth.strftime(
                '%Y/%m/%d')
            data_email['company_leader_date_of_birth'] = company_leader_date_of_birth
            data_email['company_remarks_column'] = data_t_crc['company_remarks_column']

            if data_t_crc['gmo_invoice_mail'] == 1:
                data_email['gmo_invoice_mail'] = '書面で請求書を郵送する。'
            else:
                data_email['gmo_invoice_mail'] = ''

            self.send_email_contract(data_email)

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# 本契約申込完了連絡 本契約申込受付_NDES用 メール送信')

            data_email = {}
            data_email['service_id'] = GV.SERVICE_ID
            data_email['mail_type'] = '本契約申込受付_NDES用'

            data_email['entry_code'] = data_t_crc['entry_code']

            cdate = data_t_crc["cdate"]
            cdate = datetime.strptime(cdate[0:19], '%Y-%m-%dT%H:%M:%S')
            cdate = cdate.strftime('%Y/%m/%d %H:%M:%S')
            data_email['cdate'] = cdate

            data_email['company_name'] = data_t_crc['company_name']
            data_email['company_address_pref'] = data_t_crc['company_address_pref']
            data_email['company_address_1'] = data_t_crc['company_address_1']
            data_email['company_address_2'] = data_t_crc['company_address_2']
            data_email['company_address_3'] = data_t_crc['company_address_3']
            data_email['contract_affiliation_department'] = data_t_crc['contract_affiliation_department']
            data_email['contract_last_name'] = data_t_crc['contract_last_name']
            data_email['contract_first_name'] = data_t_crc['contract_first_name']
            data_email['company_remarks_column'] = data_t_crc['company_remarks_column']

            if data_t_crc['gmo_invoice_mail'] == 1:
                data_email['gmo_invoice_mail'] = '書面で請求書を郵送する。'
            else:
                data_email['gmo_invoice_mail'] = ''

            self.send_email_contract(data_email)

            logger.debug('# ##############################')

            # logger.debug('# ******************************')
            # logger.debug('# 本契約申込完了連絡 プロスペクト申請 メール送信')

            # # data_email = {}
            # # data_email = data_t_crc.copy()

            # # data_email['contract_zipcode'] = data_email['contract_zip_code']
            # # data_email['contract_tel_1'] = data_email['contract_telephone_number']
            # # data_email['contract_email'] = data_email['contract_email_address']
            # # data_email['contract_department'] = data_email['contract_affiliation_department']
            # # data_email['contract_position'] = data_email['contract_director']
            # # data_email['invoice_sending_method'] = data_email['gmo_invoice_mail']

            # # data_email['email_address'] = data_t_crc['contract_email_address']

            # # data_email['system_id'] = GV.SYSTEM_ID
            # # data_email['system_name'] = GV.SYSTEM_NAME
            # # data_email['service_id'] = GV.SERVICE_ID
            # # data_email['service_name'] = GV.SERVICE_NAME
            # # data_email['company_code'] = company_code

            # data_email = {}
            # data_email['service_id'] = GV.SERVICE_ID
            # data_email['mail_type'] = 'プロスペクト申請'

            # self.send_email_contract(data_email)

            # logger.debug('# ##############################')

            logger.debug('# ##############################')

            if '# 信用調査':

                logger.debug('# ・選択されたシステムがSimSPかつプロスペクト申請実施日が3か月以内ではない場合、')
                logger.debug('# プロスペクト申請メールを送信する。プロスペクト申請結果をNULLにする。')
                logger.debug('# ・信用調査実施日が3か月以内ではない場合、')
                logger.debug('# 信用調査結果をNULLにする。')
                logger.debug('# 本契約可否判断をNULLにする。')

                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                filters = []
                filters.append(t_mr.model_class.system_id == GV.SYSTEM_ID)
                filters.append(t_mr.model_class.service_id == GV.SERVICE_ID)
                filters.append(t_mr.model_class.company_code == company_code)
                filters = and_(*filters)

                tmp_t_mr = t_mr._get_item_by_filters(filters)

                data_t_mr = None

                if tmp_t_mr:

                    data_t_mr = tmp_t_mr.to_dict()
                    logger.debug(data_t_mr)

                if data_t_mr is not None:

                    # 判定？？？
                    if '# ・選択されたシステムがSimSPかつプロスペクト申請実施日が3か月以内ではない場合、':

                        if GV.SERVICE_PATH == 'simsp':

                            if data_t_mr['prospect_request_regist_date'] is not None:

                                # プロスペクト申請結果登録日
                                prospect_request_regist_date = data_t_mr['prospect_request_regist_date']
                                prospect_request_regist_date = datetime.strptime(
                                    prospect_request_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')
                
                                if prospect_request_regist_date is not None:

                                    logger.debug(
                                        '# ******************************')
                                    logger.debug('# 3か月後日付を取得する')

                                    # from datetime import datetime, date, timedelta
                                    from dateutil.relativedelta import relativedelta

                                    three_month_after = prospect_request_regist_date.date() + relativedelta(months=3)
                                    logger.debug(
                                        '# ##############################')

                                    today = datetime.today().date()

                                    if '# プロスペクト申請実施日が3か月以内ではない場合':

                                        logger.debug('# プロスペクト申請実施日が3か月以内ではない場合')

                                        if today > three_month_after:

                                            logger.debug('# プロスペクト申請メールを送信する。')

                                            logger.debug(
                                                '# ******************************')
                                            logger.debug('# 申込成功 プロスペクト申請 メール送信')

                                            logger.debug('# ******************************')
                                            logger.debug('# 企業情報取得')

                                            params = {
                                                'table_name': 'm_company',
                                                'filters': {
                                                    'company_code': company_code
                                                }
                                            }
                                            data_m_com = self.get_data(params)

                                            logger.debug('# ##############################')

                                            data_email = {}
                                            data_email['service_id'] = GV.SERVICE_ID
                                            data_email['mail_type'] = 'プロスペクト申請'

                                            data_email['company_name'] = data_m_com['company_name']
                                            data_email['company_address_pref'] = data_m_com['company_address_pref']
                                            data_email['company_address_1'] = data_m_com['company_address_1']
                                            data_email['company_address_2'] = data_m_com['company_address_2']
                                            data_email['company_address_3'] = data_m_com['company_address_3']
                                            data_email['contract_department'] = data_t_crc['contract_affiliation_department']
                                            data_email['contract_name_last'] = data_t_crc['contract_last_name']
                                            data_email['contract_name_first'] = data_t_crc['contract_first_name']

                                            self.send_email_contract(data_email)

                                            logger.debug(
                                                '# ##############################')

                                            logger.debug('# プロスペクト申請結果をNULLにする。')

                                            # プロスペクト申請
                                            data_t_mr['prospect_request'] = None
                                            
                                            # プロスペクト申請結果登録日
                                            data_t_mr['prospect_request_regist_date'] = None
                            else:

                                logger.debug(
                                    '# ******************************')
                                logger.debug('# 申込成功 プロスペクト申請 メール送信')

                                logger.debug('# ******************************')
                                logger.debug('# 企業情報取得')

                                params = {
                                    'table_name': 'm_company',
                                    'filters': {
                                        'company_code': company_code
                                    }
                                }
                                data_m_com = self.get_data(params)

                                logger.debug('# ##############################')

                                data_email = {}
                                data_email['service_id'] = GV.SERVICE_ID
                                data_email['mail_type'] = 'プロスペクト申請'

                                data_email['company_name'] = data_m_com['company_name']
                                data_email['company_address_pref'] = data_m_com['company_address_pref']
                                data_email['company_address_1'] = data_m_com['company_address_1']
                                data_email['company_address_2'] = data_m_com['company_address_2']
                                data_email['company_address_3'] = data_m_com['company_address_3']
                                data_email['contract_department'] = data_t_crc['contract_affiliation_department']
                                data_email['contract_name_last'] = data_t_crc['contract_last_name']
                                data_email['contract_name_first'] = data_t_crc['contract_first_name']

                                self.send_email_contract(data_email)

                                logger.debug(
                                    '# ##############################')    

                    if '# ・信用調査実施日が3か月以内ではない場合':

                        if data_t_mr['credit_check_regist_date'] is not None:

                            # 信用調査結果登録日
                            credit_check_regist_date = data_t_mr['credit_check_regist_date']
                            credit_check_regist_date = datetime.strptime(
                                credit_check_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')
                            
                            if credit_check_regist_date is not None:

                                logger.debug('# ******************************')
                                logger.debug('# 3か月後日付を取得する')

                                # from datetime import datetime, date, timedelta
                                from dateutil.relativedelta import relativedelta

                                three_month_after = credit_check_regist_date.date() + relativedelta(months=3)
                                logger.debug('# ##############################')

                                today = datetime.today().date()

                                if '# ・信用調査実施日が3か月以内ではない場合':

                                    logger.debug('# ・信用調査実施日が3か月以内ではない場合')

                                    if today > three_month_after:

                                        logger.debug('# 信用調査結果をNULLにする。')

                                        # 信用調査
                                        data_t_mr['credit_check'] = None
                                        # 信用調査結果登録日
                                        data_t_mr['credit_check_regist_date'] = None

                                        logger.debug('# 本契約可否判断をNULLにする。')

                                        # 本契約可否判断
                                        data_t_mr['contract_judgment'] = None

                else:

                    logger.debug('# ******************************')
                    logger.debug('# 申込成功 プロスペクト申請 メール送信')
                    
                    logger.debug('# ******************************')
                    logger.debug('# 企業情報取得')

                    params = {
                        'table_name': 'm_company',
                        'filters': {
                            'company_code': company_code
                        }
                    }
                    data_m_com = self.get_data(params)

                    logger.debug('# ##############################')

                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'プロスペクト申請'

                    data_email['company_name'] = data_m_com['company_name']
                    data_email['company_address_pref'] = data_m_com['company_address_pref']
                    data_email['company_address_1'] = data_m_com['company_address_1']
                    data_email['company_address_2'] = data_m_com['company_address_2']
                    data_email['company_address_3'] = data_m_com['company_address_3']
                    data_email['contract_department'] = data_t_crc['contract_affiliation_department']
                    data_email['contract_name_last'] = data_t_crc['contract_last_name']
                    data_email['contract_name_first'] = data_t_crc['contract_first_name']

                    self.send_email_contract(data_email)

                    logger.debug('# ##############################')

                    pass

            logger.debug('# ******************************')

            pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {
            'statusCode': 200,
            'body': 'OK'
        }
        pass

    def get_document_request(self):

        logger.debug('# get_document_request')

        VCDRL = GV.get_module('view_contract_document_request_list')
        v_cdrl = VCDRL()

        return v_cdrl.get_all(None, None)

        # pass
    
    # クラウドストレージ設定一覧
    def get_cloud_strage(self):

        logger.debug('# get_cloud_strage')

        VCS = GV.get_module('view_cloud_strage')
        v_cs = VCS()

        return v_cs.get_all(None, None)

        # pass

    def get_workshop(self):

        logger.debug('# get_workshop')

        VCWL = GV.get_module('view_contract_workshop_list')
        t_cwl = VCWL()

        return t_cwl.get_all(None, None)

        # pass

    def get_trial(self):

        logger.debug('# get_trial')

        VCTL = GV.get_module('view_contract_trial_list')
        t_ctl = VCTL()

        return t_ctl.get_all(None, None)

        # pass
    
    def get_ma_contract(self):

        logger.debug('# get_ma_contract')

        VCTL = GV.get_module('view_contract_ma_contract_list')
        t_ctl = VCTL()

        return t_ctl.get_all(None, None)

        # pass

    def get_questionnaire_answer(self):

        logger.debug('# get_questionnaire_answer')

        VCQAL = GV.get_module('view_contract_questionnaire_answer_list')
        v_cqal = VCQAL()

        return v_cqal.get_all(None, None)

        # pass

    def get_other_contract(self):

        logger.debug('# get_other_contract')

        VC = GV.get_module('view_contract')
        v_c = VC()

        return v_c.get_all(None, None)

        # pass

    # プロセス管理
    def process(self, params, data):
        try:
            logger.debug('# ******************************')
            logger.debug('プロセス管理')
            logger.debug(params)
            logger.debug(data)

            if 'status' in params:

                if params['status'] == '本契約受付':

                    logger.debug('# ******************************')

                    logger.debug('# ・社内与信、プロスペクト申請、')
                    logger.debug('#   GMO掛け払いの枠保証の申請を実施した結果をみて営業がOKを出す')

                    tmp_m_con_get = None
                    data_m_con = None

                    if '# テーブル「契約情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約情報」にデータを登録する')
                        logger.debug('# m_contract')

                        param_m_con = {}
                        param_m_con['contract_id'] = data['contract_id']
                        param_m_con['entry_code'] = data['entry_code']
                        param_m_con['company_code'] = data['company_code']
                        param_m_con['subscription_name'] = data['service_name']
                        param_m_con['contract_last_name'] = data['contract_last_name']
                        param_m_con['contract_first_name'] = data['contract_first_name']
                        param_m_con['contract_last_name_kana'] = data['contract_last_name_kana']
                        param_m_con['contract_first_name_kana'] = data['contract_first_name_kana']
                        param_m_con['subscription_start_date'] = data['subscription_start_date']
                        param_m_con['subscription_end_date'] = data['subscription_end_date']
                        param_m_con['postal_address'] = data['postal_address']
                        param_m_con['contract_zipcode'] = data['contract_zip_code']
                        param_m_con['contract_address_pref'] = data['contract_address_pref']
                        param_m_con['contract_address_1'] = data['contract_address_1']
                        param_m_con['contract_address_2'] = data['contract_address_2']
                        param_m_con['contract_address_3'] = data['contract_address_3']
                        param_m_con['contract_tel_1'] = data['contract_telephone_number']
                        param_m_con['contract_email'] = data['contract_email_address']
                        param_m_con['contract_department'] = data['contract_affiliation_department']
                        param_m_con['salesman_name'] = data['salesman_name']

                        # param_m_con['applicable_start_date'] = data['applicable_start_date']
                        # param_m_con['applicable_end_date'] = data['applicable_end_date']
                        # 初回登録時に適用開始日に月初を入れて、適用終了日は空欄固定になりました。
                        # 適用開始日
                        param_m_con['applicable_start_date'] = datetime.now().replace(
                            day=1).date()
                        # 適用終了日
                        param_m_con['applicable_end_date'] = None

                        param_m_con['contract_position'] = data['contract_director']
                        param_m_con['payment_method'] = data['payment_method']
                        param_m_con['salesman_code'] = data['salesman_code']
	                    # --> 共通PF4 職番の重複許可 2024/02/06 nakamura.e
	                    # スタッフID
                        param_m_con['staff_id'] = data['staff_id']
	                    # <-- 共通PF4 職番の重複許可 2024/02/06 nakamura.e
                        # param_m_con['udate'] = data['udate']
                        param_m_con['subscription_notes'] = data['subscription_notes']
                        param_m_con['invoice_sending_method'] = data['gmo_invoice_mail']
                        # param_m_con['temp_service_sleep_start_date'] = data['temp_service_sleep_start_date']
                        # param_m_con['temp_service_sleep_restart_date'] = data['temp_service_sleep_restart_date']
                        # param_m_con['ndes_service_stop_start_date'] = data['ndes_service_stop_start_date']
                        # param_m_con['ndes_service_stop_restart_date'] = data['ndes_service_stop_restart_date']
                        # param_m_con['termination_of_service_mail_send_date'] = data['termination_of_service_mail_send_date']
                        # param_m_con['service_usable_status'] = data['service_usable_status']
                        # param_m_con['reason_for_termination'] = data['reason_for_termination']
                        # param_m_con['pre_notification_resumption_of_service_mael_send_date'] = data['pre_notification_resumption_of_service_mael_send_date']
                        param_m_con['application_completion_email_sent_date'] = datetime.now(
                        )
                        # param_m_con['cancellation_email_sent_date'] = data['cancellation_email_sent_date']

                        MCON = GV.get_module('m_contract')
                        m_con = MCON()

                        logger.debug(data['contract_id'])

                        # if 'contract_id' in data and \
                        #         data['contract_id'] is not None and \
                        #         data['contract_id'] != '':

                        #     filters = []
                        #     filters.append(
                        #         m_con.model_class.contract_id == data['contract_id'])
                        #     filters = and_(*filters)

                        #     tmp_m_con_get = m_con._get_item_by_filters(filters)
  
                        filters = []
                        filters.append(
                            m_con.model_class.entry_code == data['entry_code'])
                        filters.append(
                            m_con.model_class.company_code == data['company_code'])
                        filters = and_(*filters)

                        tmp_m_con_get = m_con._get_item_by_filters(filters)

                        logger.debug('tmp_m_con_get')
                        logger.debug(tmp_m_con_get)

                        if tmp_m_con_get is None:

                            tmp_m_con = m_con._add(param_m_con)

                            if tmp_m_con is None:
                                raise CustomException('SYS_ERR_100')

                            data_m_con = tmp_m_con.to_dict()

                        else:

                            tmp_m_con = m_con._update(param_m_con)

                            if tmp_m_con is None:
                                raise CustomException('SYS_ERR_100')

                            data_m_con = tmp_m_con.to_dict()

                        logger.debug('# ##############################')

                        if data_m_con is None:
                            raise CustomException('SYS_ERR_100')
                    
                    if '# テーブル「契約商品情報」の利用開始日を更新する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約商品情報」の利用開始日を更新する')
                        logger.debug('# m_contract_product')
                        
                        if data['contract_id'] is not None and data['subscription_start_date'] is not None:
    
                            MCP = GV.get_module('m_contract_product')
                            m_cp = MCP()
        
                            filters = []
                            filters.append(m_cp.model_class.contract_id == data['contract_id'])
                            filters.append(m_cp.model_class.use_end_date  == None)
                            filters = and_(*filters)
        
                            tmp_m_cp_get = m_cp._get_item_by_filters(filters, get_all=True)
        
                            if tmp_m_cp_get is not None:
                                for t in tmp_m_cp_get:
                                    if t is not None:
                                        params_m_cp = t.to_dict()
                                        params_m_cp['use_start_date'] = data['subscription_start_date']
                                        # print("params_m_cp-------")
                                        # print(params_m_cp)
                                        
                                        tmp_t_cp = m_cp._update(params_m_cp)
        
                                        if tmp_t_cp is None:
                                            raise CustomException('SYS_ERR_100')
                                        # print("tmp_m_cp_get------------")
                                        
                        pass
                        logger.debug('# ##############################')

                    t_mr = None

                    if '# テーブル「申込管理情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「申込管理情報」にデータを更新する')
                        logger.debug('# t_manage_request')

                        data_t_mr = {}

                        data_t_mr['manage_req_id'] = data['manage_req_id']
                        data_t_mr['company_code'] = data['company_code']
                        data_t_mr['system_id'] = data['system_id']
                        data_t_mr['service_id'] = data['service_id']

                        data_t_mr['contract_id'] = data_m_con['contract_id']

                        logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能): 0」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']

                        logger.debug('# 「ステータス」を「本契約受付」にする')
                        data_t_mr['status'] = GV.STATUS['本契約受付']

                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        tmp_t_mr = t_mr._update(data_t_mr)

                        if tmp_t_mr is None:
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')

                    # logger.debug('# ******************************')

                    # data_m_rp = None

                    # if '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する':

                    #     logger.debug(
                    #         '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する')

                    #     logger.debug('# ???')
                    #     logger.debug('# 「請求書発行手数料」どう特定するか？')
                    #     logger.debug('# ???')

                    #     MRP = GV.get_module('m_regular_products')
                    #     m_rp = MRP()

                    #     filters = []
                    #     filters.append(
                    #         m_rp.model_class.product_name == '請求書発行手数料')
                    #     filters = and_(*filters)

                    #     tmp_m_rp = m_rp._get_item_by_filters(filters)

                    #     if tmp_m_rp is not None:

                    #         data_m_rp = tmp_m_rp.to_dict()

                    # logger.debug('# ##############################')

                    # if '# テーブル「契約商品マスタ」にデータを登録する':

                    #     logger.debug('# ******************************')
                    #     logger.debug('# テーブル「契約商品マスタ」からデータを取得する')
                    #     logger.debug('# m_contract_product')

                    #     MCP = GV.get_module('m_contract_product')
                    #     m_cp = MCP()

                    #     filters = []
                    #     filters.append(
                    #         m_cp.model_class.contract_id == data_m_con['contract_id'])
                    #     filters = and_(*filters)

                    #     tmp_m_cp = m_cp._get_item_by_filters(filters)

                    #     if tmp_m_cp is None:

                    #         logger.debug('# ******************************')
                    #         logger.debug('# テーブル「通常商品マスタ」からデータを取得する')
                    #         logger.debug('# m_regular_products')

                    #         MRP = GV.get_module('m_regular_products')
                    #         m_rp = MRP()

                    #         filters = []
                    #         filters.append(
                    #             m_rp.model_class.service_id == data['service_id'])
                    #         filters = and_(*filters)

                    #         tmp_m_rp = m_rp._get_item_by_filters(
                    #             filters, get_all=True)

                    #         if tmp_m_rp is not None and len(tmp_m_rp) > 0:

                    #             for t in tmp_m_rp:

                    #                 d_m_rp = t.to_dict()

                    #                 if data_m_rp is not None and \
                    #                         data_m_rp['product_id'] == d_m_rp['product_id']:
                    #                     logger.debug(
                    #                         '# ******************************')
                    #                     logger.debug('# 「請求書発行手数料」のIDの場合登録しない')
                    #                     logger.debug('# あとの処理で行う')
                    #                     logger.debug(
                    #                         '# ##############################')
                    #                     pass
                    #                 else:
                    #                     logger.debug(
                    #                         '# ******************************')
                    #                     logger.debug(
                    #                         '# テーブル「契約商品マスタ」にデータを登録する')
                    #                     logger.debug('# m_contract_product')

                    #                     param_m_cp = {}
                    #                     param_m_cp['contract_id'] = data_m_con['contract_id']
                    #                     param_m_cp['product_id'] = d_m_rp['product_id']

                    #                     tmp_m_cp_add = m_cp._add(param_m_cp)

                    #                     if tmp_m_cp_add is None:
                    #                         logger.debug(
                    #                             '# テーブル「契約商品マスタ」にデータを登録する')
                    #                         logger.debug(param_m_cp)
                    #                         raise CustomException(
                    #                             'SYS_ERR_100')

                    #                     logger.debug(
                    #                         '# ##############################')

                    #         logger.debug('# ##############################')

                    #     logger.debug('# ##############################')

                    #     pass

                    logger.debug('# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。')
                    logger.debug('# ・サポート(新事推開)に環境起動依頼メールを送信。「本契約時の環境起動依頼」。')
                    logger.debug(
                        '# ・GMO掛け払いの請求書の郵送がON(郵送(書類))の場合はこの企業コードの契約中の契約すべてをチェックし、')
                    logger.debug(
                        '#   GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

                    if '# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。':

                        logger.debug('# ******************************')
                        logger.debug('# ・お客様にメールを送信。スタッフにメールを送信。')

                        logger.debug('# メール 受注決定 申込完了連絡')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['email_address'] = data['contract_email_address']
                        data_email['mail_type'] = '申込完了連絡'

                        data_email['company_name'] = data['company_name']
                        data_email['contract_department'] = data['contract_affiliation_department']
                        data_email['contract_name_last'] = data['contract_last_name']
                        data_email['contract_name_first'] = data['contract_first_name']
                        data_email['entry_code'] = data['entry_code']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')

                    if '# ・サポート(新事推開)に環境起動依頼メールを送信。「本契約時の環境起動依頼」。':

                        logger.debug('# ******************************')
                        logger.debug(
                            '# ・サポート(新事推開)に環境起動依頼メールを送信。「本契約時の環境起動依頼」。')

                        logger.debug('# メール 受注決定 本契約時の環境起動依頼')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['mail_type'] = '本契約時の環境起動依頼'

                        if data['env_id'] is not None:
                            data_email['env_id'] = data['env_id']
                        else:
                            data_email['env_id'] = ''
                        data_email['system_id'] = data['system_id']
                        data_email['service_id'] = data['service_id']
                        data_email['system_name'] = data['system_name']
                        data_email['service_name'] = data['service_name']
                        data_email['company_code'] = data['company_code']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')

                    # if '# ・GMO掛け払いの請求書の郵送がON(郵送(書類))の場合はこの企業コードの契約中の契約すべてをチェックし、' and \
                    #    'GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。':

                    #     if data['gmo_invoice_mail'] == '郵送(書類)':

                    #         # logger.debug('# ******************************')

                    #         # data_m_rp = None

                    #         # if '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する':

                    #         #     logger.debug(
                    #         #         '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する')

                    #         #     logger.debug('# ???')
                    #         #     logger.debug('# 「請求書発行手数料」どう特定するか？')
                    #         #     logger.debug('# ???')

                    #         #     MRP = GV.get_module('m_regular_products')
                    #         #     m_rp = MRP()

                    #         #     filters = []
                    #         #     filters.append(
                    #         #         m_rp.model_class.product_name == '請求書発行手数料')
                    #         #     filters = and_(*filters)

                    #         #     tmp_m_rp = m_rp._get_item_by_filters(filters)

                    #         #     if tmp_m_rp is not None:

                    #         #         data_m_rp = tmp_m_rp.to_dict()

                    #         # logger.debug('# ##############################')

                    #         if data_m_rp is not None:

                    #             logger.debug(
                    #                 '# ******************************')

                    #             data_t_mr = None
                    #             list_contract_id = None

                    #             if '# この企業コードの契約中の契約すべてをチェック':

                    #                 logger.debug('# この企業コードの契約中の契約すべてをチェック')
                    #                 logger.debug(data['company_code'])

                    #                 filters = []
                    #                 filters.append(
                    #                     t_mr.model_class.company_code == data['company_code'])
                    #                 filters = and_(*filters)

                    #                 tmp_t_mr = t_mr._get_item_by_filters(
                    #                     filters, get_all=True)

                    #                 if tmp_t_mr is not None and len(tmp_t_mr) > 0:

                    #                     data_t_mr = []

                    #                     for t in tmp_t_mr:
                    #                         d = t.to_dict()
                    #                         data_t_mr.append(d)

                    #                 logger.debug('# 契約IDのリストを取得')
                    #                 logger.debug(data_t_mr)

                    #                 if data_t_mr is not None:

                    #                     list_contract_id = []

                    #                     for d in data_t_mr:

                    #                         list_contract_id.append(
                    #                             d['contract_id'])

                    #                     logger.debug(list_contract_id)

                    #             logger.debug(
                    #                 '# ##############################')

                    #             logger.debug(
                    #                 '# ******************************')

                    #             if '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。':

                    #                 logger.debug(
                    #                     '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

                    #                 if list_contract_id is not None:

                    #                     list_contract_id.sort()
                    #                     logger.debug(list_contract_id)

                    #                     MCP = GV.get_module(
                    #                         'm_contract_product')
                    #                     m_cp = MCP()

                    #                     filters = []
                    #                     filters.append(
                    #                         m_cp.model_class.contract_id.in_(list_contract_id))
                    #                     filters = and_(*filters)

                    #                     tmp_m_cp = m_cp._get_item_by_filters(
                    #                         filters)

                    #                     if tmp_m_cp is None:

                    #                         logger.debug(
                    #                             '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

                    #                         param_m_cp = {}
                    #                         param_m_cp['contract_id'] = list_contract_id[0]
                    #                         param_m_cp['product_id'] = data_m_rp['product_id']

                    #                         tmp_m_cp_add = m_cp._add(
                    #                             param_m_cp)

                    #                         if tmp_m_cp_add is None:
                    #                             logger.debug('# 1番古い契約に追加する。')
                    #                             logger.debug(param_m_cp)
                    #                             raise CustomException(
                    #                                 'SYS_ERR_100')

                    #             logger.debug(
                    #                 '# ##############################')

                    logger.debug('# ##############################')

                    pass

                elif params['status'] == '本契約利用中':

                    logger.debug('# ・利用する環境の割り当てが完了している。')
                    logger.debug('# ・割り当てられたマシンが稼働中になっている。')

                    logger.debug('# ユーザ管理サイトの本契約管理で利用可能通知メール送信ボタンを押す')

                    logger.debug('# ******************************')

                    if 'env_id' in data and data['env_id'] is not None and data['env_id'] != '':
                        pass
                    else:
                        error_message = '利用する環境の割り当てが完了していません。'
                        error = {
                            'code': 400,
                            'message': error_message
                        }
                        raise CustomException('ERROR', error_params=error)

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if 'startup_flg' in data and data['startup_flg'] is not None and data['startup_flg'] == True:
                        pass
                    else:
                        error_message = '割り当てられたマシンが稼働中になっていません。'
                        error = {
                            'code': 400,
                            'message': error_message
                        }
                        raise CustomException('ERROR', error_params=error)

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    t_mr = None

                    if '# テーブル「申込管理情報」にデータを登録する':

                        logger.debug('# テーブル「申込管理情報」にデータを更新する')
                        logger.debug('# t_manage_request')

                        data_t_mr = {}

                        data_t_mr['manage_req_id'] = data['manage_req_id']
                        data_t_mr['company_code'] = data['company_code']
                        data_t_mr['system_id'] = data['system_id']
                        data_t_mr['service_id'] = data['service_id']

                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能: 2」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']

                        logger.debug('# 「ステータス」を「本契約利用中」にする')
                        data_t_mr['status'] = GV.STATUS['本契約利用中']

                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        tmp_t_mr = t_mr._update(data_t_mr)

                        if tmp_t_mr is None:
                            raise CustomException('SYS_ERR_100')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# テーブル「契約情報」にデータを更新する':

                        logger.debug('# テーブル「契約情報」にデータを更新する')
                        logger.debug('# m_contract')

                        MCON = GV.get_module('m_contract')
                        m_con = MCON()

                        param_m_con = {}
                        param_m_con['contract_id'] = data['contract_id']
                        param_m_con['service_usable_status'] = GV.SERVICE_USABLE_STATUS['利用中']

                        tmp_m_con = m_con._update(param_m_con)

                        if tmp_m_con is None:
                            raise CustomException('SYS_ERR_100')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# 「環境ストックマスタ」からデータ取得':

                        logger.debug('# 「環境ストックマスタ」からデータ取得')
                        logger.debug('# m_env_stock')

                        params = {
                            'table_name': 'm_env_stock',
                            'filters': {
                                'env_id': data['env_id']
                            }
                        }
                        tmp_m_es = self.get_data(params, is_get_dict=False)

                        if tmp_m_es is not None:

                            data_m_es = tmp_m_es.to_dict()

                            logger.debug('# ******************************')

                            if '# 「使用フラグ」をTrueにする':

                                MES = GV.get_module('m_env_stock')
                                m_es = MES()

                                logger.debug('# 「使用フラグ」をTrueにする')
                                logger.debug('# use_flg')

                                data_m_es['use_flg'] = True

                                m_es._update(data_m_es)

                            logger.debug('# ##############################')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    data_m_sys = None

                    if '# テーブル「システムマスタ」からデータ取得':

                        logger.debug('# テーブル「システムマスタ」からデータ取得')
                        logger.debug('# m_systems')

                        params_m_systems = {
                            'table_name': 'm_systems',
                            'filters': {
                                'system_id': data['system_id']
                            }
                        }

                        data_m_sys = self.get_data(params_m_systems)

                        if data_m_sys is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# データ取得NGの場合')
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# データ取得OKの場合')

                    logger.debug('# ##############################')

                    if '# ・お客様のAuth0アカウントのメタデータを更新して本番環境を利用可能にする。':

                        logger.debug('# ******************************')
                        logger.debug(
                            '# ・お客様のAuth0アカウントのメタデータを更新して本番環境を利用可能にする。')

                        if '# テーブル「Auth0ユーザー情報管理」にデータ登録【本契約ユーザー】':

                            logger.debug(
                                '# テーブル「Auth0ユーザー情報管理」にデータ登録【本契約ユーザー】')
                            logger.debug('# m_auth_user_info')

                            MAUI = GV.get_module('m_auth0_user_info')
                            m_aui = MAUI()

                            param_m_aui = {}
                            # Auth0ユーザーID
                            param_m_aui['auth0_user_id'] = data['auth0_user_id']
                            # ログイン先企業コード
                            param_m_aui['company_code'] = data['company_code']
                            # ログイン先システムID
                            param_m_aui['system_id'] = data['system_id']
                            # ログイン先サービスID
                            param_m_aui['service_id'] = data['service_id']
                            # activedirectory_username
                            # ENV00001.user001@simulation.space
                            logger.debug('# **************0702****S************')
                            param_m_aui['tenant'] = data['tenant']
                            logger.debug('# **************0702****E************')
                            tmp_adun = data['env_id']
                            # tmp_adun += '.' + 'user001'
                            tmp_adun += '.' + 'user000'
                            tmp_adun += '@' + data_m_sys['ad_domain_name']
                            param_m_aui['activedirectory_username'] = tmp_adun
                            # appstream_stackname
                            # SYS00001-SRV00001-appstream-stack-activedirectory-ENV00001
                            tmp_assn = data['system_id'] + '-'
                            tmp_assn += data['service_id'] + '-'
                            tmp_assn += 'appstream-stack-activedirectory' + '-'
                            tmp_assn += data['env_id']
                            param_m_aui['appstream_stackname'] = tmp_assn
                            # 付与ロールのリスト
                            param_m_aui['roles'] = [GV.ROLES_ADMIN_USER]

                            params_m_auth0_user_info = {
                                'table_name': 'm_auth0_user_info',
                                'filters': {
                                    'auth0_user_id': param_m_aui['auth0_user_id'],
                                    'company_code': param_m_aui['company_code'],
                                    'system_id': param_m_aui['system_id'],
                                    'service_id': param_m_aui['service_id']
                                }
                            }
                            data_m_aui = self.get_data(
                                params_m_auth0_user_info)
                            logger.debug(data_m_aui)

                            tmp_m_aui = None

                            if data_m_aui:
                                logger.debug(
                                    '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                                param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                                tmp_m_aui = m_aui._update(param_m_aui)
                                pass
                            else:
                                logger.debug(
                                    '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                                tmp_m_aui = m_aui._add(param_m_aui)
                                pass

                            if tmp_m_aui is None:
                                logger.debug(
                                    '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                logger.debug('# データ登録NGの場合')
                                raise CustomException('SYS_ERR_100')

                            logger.debug('# データ登録OKの場合')

                        logger.debug('# ##############################')

                    if '# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。':

                        logger.debug('# ******************************')
                        logger.debug('# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。')

                        logger.debug('# メール 利用開始 利用開始可能連絡')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['email_address'] = data['email']
                        data_email['mail_type'] = '利用開始可能連絡'

                        data_email['company_name'] = data['company_name']
                        data_email['administrator_name_last'] = data['name_last']
                        data_email['administrator_name_first'] = data['name_first']
                        data_email['login_url'] = GV.URL_LOGIN_SIMSP
                        data_email['entry_code'] = data['entry_code']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')

                    pass

                elif params['status'] == '本契約解約済み':

                    logger.debug('# ・お客様がサービスの一時休止・停止・再開サイトで解約を申し込んでいる')
                    logger.debug('# ・契約終了日が設定済み')

                    logger.debug('# ユーザ管理サイトの本契約管理でサービスの解約ボタンを押す')

                    logger.debug('# ******************************')

                    t_mr = None

                    if '# テーブル「申込管理情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「申込管理情報」にデータを更新する')
                        logger.debug('# t_manage_request')

                        data_t_mr = {}

                        data_t_mr['manage_req_id'] = data['manage_req_id']
                        data_t_mr['company_code'] = data['company_code']
                        data_t_mr['system_id'] = data['system_id']
                        data_t_mr['service_id'] = data['service_id']

                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                        
                        logger.debug('# 「ステータス」を「本契約解約済み」にする')
                        data_t_mr['status'] = GV.STATUS['本契約解約済み']

                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        tmp_t_mr = t_mr._update(data_t_mr)

                        if tmp_t_mr is None:
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    data_m_con = None

                    if '# テーブル「契約情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約情報」にデータを登録する')
                        logger.debug('# m_contract')

                        param_m_con = {}

                        logger.debug('# 「契約終了日」に当日の日付を設定する')
                        param_m_con['subscription_end_date'] = datetime.now()

                        logger.debug('# 「サービスの利用ステータス」を「解約」に設定する')
                        param_m_con['service_usable_status'] = GV.SERVICE_USABLE_STATUS['解約']

                        logger.debug('# 「サービスの解約メール送信日」に当日の日付を設定する')
                        param_m_con['termination_of_service_mail_send_date'] = datetime.now(
                        )

                        MCON = GV.get_module('m_contract')
                        m_con = MCON()

                        if 'contract_id' in data and \
                                data['contract_id'] is not None and \
                                data['contract_id'] != '':

                            filters = []
                            filters.append(
                                m_con.model_class.contract_id == data['contract_id'])
                            filters = and_(*filters)

                            tmp_m_con_get = None
                            tmp_m_con_get = m_con._get_item_by_filters(filters)

                            if tmp_m_con_get is not None:

                                param_m_con['contract_id'] = data['contract_id']

                                tmp_m_con = m_con._update(param_m_con)

                                if tmp_m_con is None:
                                    raise CustomException('SYS_ERR_100')

                                data_m_con = tmp_m_con.to_dict()

                            else:

                                logger.debug('# 契約データが存在しない')
                                logger.debug(data)

                                raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')

                        if data_m_con is None:
                            raise CustomException('SYS_ERR_100')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    
                    logger.debug('# ************0802***************S***') 
                    
                    data_m_conpr = None
                    
                    if '# テーブル「契約商品情報」にデータを更新する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約商品情報」にデータを更新する')
                        logger.debug('# m_contract_product')

                        MCONPR = GV.get_module('m_contract_product')
                        m_conpr = MCONPR()

                        if 'contract_id' in data and \
                                data['contract_id'] is not None and \
                                data['contract_id'] != '':

                            filters = []
                            filters.append(m_conpr.model_class.contract_id == data['contract_id'])
                            filters.append(m_conpr.model_class.use_end_date == None)
                            filters = and_(*filters)

                            tmp_m_conpr_get = None
                            tmp_m_conpr_get = m_conpr._get_item_by_filters(filters, get_all=True)
                            
                            if tmp_m_conpr_get is not None:
                                    
                                for t_m_conpr in tmp_m_conpr_get:

                                    data_m_conpr = t_m_conpr.to_dict()
        
                                    logger.debug('# 「利用終了日」に契約終了日「当日の日付」を設定する')
                                    data_m_conpr['use_end_date'] = datetime.now()
    
                                    tmp_m_conpr = m_conpr._update(data_m_conpr)
    
                                    if tmp_m_conpr is None:
                                        raise CustomException('SYS_ERR_100')
                                        
                                    data_m_conpr = tmp_m_conpr.to_dict()
                            else:
                                logger.debug('# 契約商品情報データが存在しない')
                                logger.debug(data)

                                raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')

                        if data_m_conpr is None:
                            raise CustomException('SYS_ERR_100')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    logger.debug('# ************0802**************E****') 

                    if '# テーブル「契約商品マスタ」にデータを更新する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約商品マスタ」にデータを更新する')
                        logger.debug('# m_contract_product')

                        logger.debug(
                            '# 複数サービス契約時、請求書の郵送手数料の契約商品がついている方の契約を解約した場合、')
                        logger.debug(
                            '# 他の契約中の契約の内、契約開始日が一番古いものに請求書の郵送手数料の契約商品が付く必要がある。')

                        # if data['gmo_invoice_mail'] == '郵送(書類)':

                        #     logger.debug('# ******************************')

                        #     data_m_rp = None

                        #     if '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する':

                        #         logger.debug(
                        #             '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する')

                        #         logger.debug('# ???')
                        #         logger.debug('# 「請求書発行手数料」どう特定するか？')
                        #         logger.debug('# ???')

                        #         MRP = GV.get_module('m_regular_products')
                        #         m_rp = MRP()

                        #         filters = []
                        #         filters.append(
                        #             m_rp.model_class.product_name == '請求書発行手数料')
                        #         filters = and_(*filters)

                        #         tmp_m_rp = m_rp._get_item_by_filters(filters)

                        #         if tmp_m_rp is not None:

                        #             data_m_rp = tmp_m_rp.to_dict()

                        #     logger.debug('# ##############################')

                        #     if data_m_rp is not None:

                        #         logger.debug(
                        #             '# ******************************')

                        #         data_t_mr = None
                        #         list_contract_id = None

                        #         if '# この企業コードの契約中の契約すべてをチェック':

                        #             logger.debug('# この企業コードの契約中の契約すべてをチェック')
                        #             logger.debug(data['company_code'])

                        #             filters = []
                        #             filters.append(
                        #                 t_mr.model_class.company_code == data['company_code'])
                        #             filters = and_(*filters)

                        #             tmp_t_mr = t_mr._get_item_by_filters(
                        #                 filters, get_all=True)

                        #             if tmp_t_mr is not None and len(tmp_t_mr) > 0:

                        #                 data_t_mr = []

                        #                 for t in tmp_t_mr:
                        #                     d = t.to_dict()
                        #                     data_t_mr.append(d)

                        #             logger.debug('# 契約IDのリストを取得')
                        #             logger.debug(data_t_mr)

                        #             if data_t_mr is not None:

                        #                 list_contract_id = []

                        #                 for d in data_t_mr:

                        #                     if d['contract_id'] != data['contract_id']:

                        #                         list_contract_id.append(
                        #                             d['contract_id'])

                        #                 logger.debug(list_contract_id)

                        #         logger.debug(
                        #             '# ##############################')

                        #         logger.debug(
                        #             '# ******************************')

                        #         if '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。':

                        #             logger.debug(
                        #                 '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

                        #             if list_contract_id is not None:

                        #                 list_contract_id.sort()
                        #                 logger.debug(list_contract_id)

                        #                 MCP = GV.get_module(
                        #                     'm_contract_product')
                        #                 m_cp = MCP()

                        #                 filters = []
                        #                 filters.append(
                        #                     m_cp.model_class.contract_id.in_(list_contract_id))
                        #                 filters = and_(*filters)

                        #                 tmp_m_cp = m_cp._get_item_by_filters(
                        #                     filters)

                        #                 if tmp_m_cp is None:

                        #                     logger.debug(
                        #                         '# GMO掛け払いの請求書の郵送手数料の契約商品が存在しない場合は1番古い契約に追加する。')

                        #                     param_m_cp = {}
                        #                     param_m_cp['contract_id'] = list_contract_id[0]
                        #                     param_m_cp['product_id'] = data_m_rp['product_id']

                        #                     tmp_m_cp_add = m_cp._add(
                        #                         param_m_cp)

                        #                     if tmp_m_cp_add is None:
                        #                         logger.debug('# 1番古い契約に追加する。')
                        #                         logger.debug(param_m_cp)
                        #                         raise CustomException(
                        #                             'SYS_ERR_100')

                        #         logger.debug(
                        #             '# ##############################')


                        if data['gmo_invoice_mail'] == '郵送(書類)':

                            logger.debug('# ******************************')

                            data_m_rp = None

                            if '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する':

                                logger.debug(
                                    '# テーブル「通常商品マスタ」から「請求書発行手数料」のIDを取得する')

                                logger.debug('# ???')
                                logger.debug('# 「請求書発行手数料」どう特定するか？')
                                logger.debug('# ???')

                                MRP = GV.get_module('m_regular_products')
                                m_rp = MRP()

                                filters = []
                                filters.append(
                                    m_rp.model_class.product_name == '請求書発行手数料')
                                filters = and_(*filters)

                                tmp_m_rp = m_rp._get_item_by_filters(filters)

                                if tmp_m_rp is not None:

                                    data_m_rp = tmp_m_rp.to_dict()

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')
                            logger.debug('# 「請求書の郵送手数料の商品ID」を削除する。')
                            # m_contract_product

                            MCP = GV.get_module('m_contract_product')
                            m_cp = MCP()

                            filters = []
                            filters.append(
                                m_cp.model_class.contract_id == data['contract_id'])
                            filters.append(
                                m_cp.model_class.product_id == data_m_rp['product_id'])
                            filters = and_(*filters)

                            tmp_m_cp_get = m_cp._get_item_by_filters(filters)

                            if tmp_m_cp_get is not None:
                                data_m_cp_get = tmp_m_cp_get.to_dict()
                                
                                tmp_m_cp_delete = m_cp._delete(data_m_cp_get)

                            logger.debug('# ##############################')

                            if data['company_code'] is not None:

                                logger.debug(
                                    '# 請求書の郵送手数料の契約商品は1企業では1つのみにする必要がある。')

                                list_contract = None

                                logger.debug('# ******************************')
                                logger.debug('# 「申込管理情報」から該当企業コードの全ての契約データを取得する')

                                TMR = GV.get_module('t_manage_request')
                                t_mr = TMR()

                                tmp_list_status = [GV.STATUS['本契約申請'], GV.STATUS['本契約受付'], GV.STATUS['本契約利用中']]

                                filters = []
                                filters.append(
                                    t_mr.model_class.company_code == data['company_code'])
                                filters.append(
                                    t_mr.model_class.contract_id != None)
                                filters.append(
                                    t_mr.model_class.status.in_(tmp_list_status))
                                filters = and_(*filters)

                                tmp_t_mr_get = t_mr._get_item_by_filters(
                                    filters, get_all=True)

                                if tmp_t_mr_get is not None and len(tmp_t_mr_get) > 0:
                                    list_contract = []
                                    for t in tmp_t_mr_get:
                                        d = t.to_dict()
                                        list_contract.append(d)

                                logger.debug('list_contract')
                                logger.debug(list_contract)

                                logger.debug('# ##############################')

                                if '# 契約データがある場合':

                                    if list_contract is not None:

                                        list_contract_id = []
                                        for d in list_contract:
                                            if d['contract_id'] != data['contract_id']:
                                                list_contract_id.append(
                                                    d['contract_id'])

                                        list_contract_id.sort()
                                        logger.debug(list_contract_id)

                                        logger.debug('list_contract_id')
                                        logger.debug(list_contract_id)

                                        first_contract_id = list_contract_id[0]

                                        if '# 「契約商品マスタ（m_contract_product）」関連の処理':

                                            list_data_m_cp = None

                                            logger.debug(
                                                '# ******************************')
                                            logger.debug(
                                                '# 契約商品マスタから該当企業コードの全ての契約の「請求書の郵送手数料の商品ID」のデータを取得する')

                                            MCP = GV.get_module(
                                                'm_contract_product')
                                            m_cp = MCP()

                                            filters = []
                                            filters.append(
                                                m_cp.model_class.contract_id.in_(list_contract_id))
                                            filters.append(
                                                m_cp.model_class.product_id == data_m_rp['product_id'])
                                            filters = and_(*filters)

                                            tmp_m_cp_get = m_cp._get_item_by_filters(
                                                filters, get_all=True)

                                            logger.debug('tmp_m_cp_get')
                                            logger.debug(tmp_m_cp_get)

                                            if tmp_m_cp_get is not None and len(tmp_m_cp_get) > 0:
                                                list_data_m_cp = []
                                                for t in tmp_m_cp_get:
                                                    d = t.to_dict()
                                                    logger.debug('d')
                                                    logger.debug(d)
                                                    list_data_m_cp.append(d)

                                            logger.debug('list_data_m_cp')
                                            logger.debug(list_data_m_cp)

                                            logger.debug(
                                                '# ##############################')

                                            if list_data_m_cp is None:

                                                logger.debug(
                                                    '# 該当企業コードの「請求書の郵送手数料の商品ID」の契約データがない場合')

                                                if data['contract_id'] is not None:

                                                    logger.debug(
                                                        '# ******************************')
                                                    logger.debug(
                                                        '# 「請求書の郵送手数料の商品ID」を追加する。')
                                                    # m_contract_product

                                                    MCP = GV.get_module(
                                                        'm_contract_product')
                                                    m_cp = MCP()

                                                    filters = []
                                                    filters.append(
                                                        m_cp.model_class.contract_id == first_contract_id)
                                                    filters.append(
                                                        m_cp.model_class.product_id == data_m_rp['product_id'])
                                                    filters = and_(*filters)

                                                    tmp_m_cp_get = m_cp._get_item_by_filters(
                                                        filters)

                                                    if tmp_m_cp_get is None:

                                                        params_m_cp = {
                                                            'contract_id': first_contract_id,
                                                            'product_id': data_m_rp['product_id']
                                                        }
                                                        # -------------0614------------S
                                                        # 契約商品マスタに登録する。利用開始日は契約開始日と同日を設定する。利用終了日は空白。
                                                        for t3 in data_t_crc['contract_product_request']:
                                                            # print(t3)
                                                            if params_m_cp['product_id'] == t3['main_product_id']:
                                                                params_m_cp['quantity'] = t3['quantity']
                                                                params_m_cp['use_start_date'] = data['subscription_start_date']
                                                                break
                        
                                                        params_m_cp['use_end_date'] = None
                                                        # print("params_m_cp-------")
                                                        # print(params_m_cp)
                                                        # -------------0614------------E

                                                        tmp_m_cp_add = m_cp._add(
                                                            params_m_cp)

                                                        if tmp_m_cp_add is None:
                                                            logger.debug(
                                                                '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                                            logger.debug(
                                                                '# 「請求書の郵送手数料の商品ID」を追加する。')
                                                            logger.debug(
                                                                params_m_cp)
                                                            raise CustomException(
                                                                'SYS_ERR_100')

                                                        logger.debug(
                                                            tmp_m_cp_add)
                                                    logger.debug(
                                                        '# ##############################')
                                                pass


                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。':

                        logger.debug('# ******************************')
                        logger.debug('# ・環境が起動済みなら環境の削除依頼メールを送信')

                        logger.debug('# メール サービスの解約 サービスの解約通知')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['email_address'] = data['contract_email_address']
                        data_email['mail_type'] = 'サービスの解約通知'
                        
                        data_email['company_name'] = data['company_name']
                        data_email['contract_name_last'] = data['contract_last_name']
                        data_email['contract_name_first'] = data['contract_first_name']
                        data_email['entry_code'] = data['entry_code']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')
                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# ・お客様のAuth0アカウントのメタデータを更新して本番環境を利用不可能にする。':

                        logger.debug('# ******************************')
                        logger.debug(
                            '# ・お客様のAuth0アカウントのメタデータを更新して本番環境を利用不可能にする。')

                        if '# テーブル「Auth0ユーザー情報管理」からデータ削除【本契約ユーザー】':

                            logger.debug('# ******************************')
                            logger.debug(
                                '# テーブル「Auth0ユーザー情報管理」からデータ削除【本契約ユーザー】')
                            logger.debug('# m_auth_user_info')

                            MAUI = GV.get_module('m_auth0_user_info')
                            m_aui = MAUI()

                            param_m_aui = {}
                            # Auth0ユーザーID
                            param_m_aui['auth0_user_id'] = data['auth0_user_id']
                            # ログイン先企業コード
                            param_m_aui['company_code'] = data['company_code']
                            # ログイン先システムID
                            param_m_aui['system_id'] = data['system_id']
                            # ログイン先サービスID
                            param_m_aui['service_id'] = data['service_id']

                            params_m_auth0_user_info = {
                                'table_name': 'm_auth0_user_info',
                                'filters': {
                                    'auth0_user_id': param_m_aui['auth0_user_id'],
                                    'company_code': param_m_aui['company_code'],
                                    'system_id': param_m_aui['system_id'],
                                    'service_id': param_m_aui['service_id'],
                                    'roles': {
                                        'expression': 'CONTAINS',
                                        'value': GV.ROLES_ADMIN_USER
                                    }
                                }
                            }

                            data_m_aui = self.get_data(
                                params_m_auth0_user_info)
                            logger.debug(data_m_aui)

                            if data_m_aui:

                                param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                                tmp_m_aui = m_aui._delete(param_m_aui)

                                if tmp_m_aui is None:
                                    logger.debug(
                                        '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                    logger.debug('# データ削除NGの場合')
                                    raise CustomException('SYS_ERR_100')

                            logger.debug('# デー削除OKの場合')

                            logger.debug('# ##############################')

                        logger.debug('# ##############################')

                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# ・環境の割り当ての解除':

                        if '# 環境の割り当てられている場合':

                            if 'env_id' in data and data['env_id'] is not None:

                                logger.debug('# 環境の割り当てられている場合')

                                # logger.debug(
                                #     '# ******************************')
                                # logger.debug('# ・環境の割り当ての解除')

                                # if '# 「環境ストックマスタ」からデータ取得':

                                #     logger.debug('# 「環境ストックマスタ」からデータ取得')
                                #     logger.debug('# m_env_stock')

                                #     MES = GV.get_module('m_env_stock')
                                #     m_es = MES()

                                #     filters = []
                                #     filters.append(
                                #         m_es.model_class.env_id == data['env_id'])
                                #     filters.append(
                                #         m_es.model_class.system_id == data['system_id'])
                                #     filters.append(
                                #         m_es.model_class.service_id == data['service_id'])
                                #     filters.append(
                                #         m_es.model_class.company_code == data['company_code'])
                                #     filters = and_(*filters)

                                #     tmp_m_es_get = None
                                #     tmp_m_es_get = m_es._get_item_by_filters(
                                #         filters)

                                #     if tmp_m_es_get is not None:
                                #         data_m_es = tmp_m_es_get.to_dict()

                                #         data_m_es['company_code'] = None
                                #         data_m_es['use_flg'] = False
                                #         data_m_es['startup_flg'] = False

                                #         tmp_m_es_update = m_es._update(
                                #             data_m_es)

                                #         if tmp_m_es_update is None:
                                #             logger.debug(
                                #                 '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                #             logger.debug('# データ更新NGの場合')
                                #             raise CustomException(
                                #                 'SYS_ERR_100')

                                # logger.debug(
                                #     '# ##############################')

                                logger.debug('# ******************************')
                                logger.debug('# ・環境の割り当ての解除')

                                if '# 「環境ストックマスタ」からデータ取得':

                                    logger.debug('# 「環境ストックマスタ」からデータ取得')
                                    logger.debug('# m_env_stock')

                                    MES = GV.get_module('m_env_stock')
                                    m_es = MES()

                                    filters = []
                                    filters.append(m_es.model_class.env_id == data['env_id'])
                                    filters.append(m_es.model_class.system_id == data['system_id'])
                                    filters.append(m_es.model_class.service_id == data['service_id'])
                                    filters.append(m_es.model_class.company_code == data['company_code'])
                                    filters = and_(*filters)

                                    tmp_m_es_get = None
                                    tmp_m_es_get = m_es._get_item_by_filters(filters)

                                    if tmp_m_es_get is not None:
                                        data_m_es = tmp_m_es_get.to_dict()

                                        data_m_es['company_code'] = None
                                        # Tureのまま
                                        # data_m_es['use_flg'] = False
                                        # Tureのまま
                                        # data_m_es['startup_flg'] = False

                                        logger.debug('# 更新する')
                                        ES = GV.get_module('env_stock')
                                        es = ES()
                                        tmp_es_update = es._update(data_m_es)

                                        if tmp_es_update is None:
                                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                            logger.debug('# m_env_stockデータ更新NGの場合')
                                            logger.debug(data_m_es)
                                            raise CustomException('SYS_ERR_100')

                                logger.debug('# ##############################')

                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    if '# ・環境が起動済みなら環境の削除依頼メールを送信':
                        logger.debug('# ******************************')
                        logger.debug('# ・環境が起動済みなら環境の削除依頼メールを送信')

                        logger.debug('# メール サービスの解約 システムの削除依頼')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['mail_type'] = 'システムの削除依頼'

                        if data['env_id'] is not None:
                            data_email['env_id'] = data['env_id']
                        else:
                            data_email['env_id'] = ''
                            
                        data_email['system_id'] = data['system_id']
                        data_email['service_id'] = data['service_id']
                        data_email['system_name'] = data['system_name']
                        data_email['service_name'] = data['service_name']
                        data_email['company_code'] = data['company_code']
                        data_email['company_name'] = data['company_name']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')
                        pass

                    logger.debug('# ##############################')

                    pass

                elif params['status'] == '本契約申込キャンセル':

                    logger.debug(
                        '# ・社内与信、プロスペクト申請、GMO掛け払いの枠保証の申請を実施した結果をみて営業がNGを出す。')
                    logger.debug('# もしくはお客様から何らかの手段で本契約の申し込みのキャンセル依頼を受ける。')

                    logger.debug('# ユーザ管理サイトの本契約管理で商談中止メール送信ボタンを押す')

                    t_mr = None

                    if '# テーブル「申込管理情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「申込管理情報」にデータを更新する')
                        logger.debug('# t_manage_request')

                        data_t_mr = {}

                        data_t_mr['manage_req_id'] = data['manage_req_id']
                        data_t_mr['company_code'] = data['company_code']
                        data_t_mr['system_id'] = data['system_id']
                        data_t_mr['service_id'] = data['service_id']

                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                        
                        logger.debug('# 「ステータス」を「本契約申込キャンセル」にする')
                        data_t_mr['status'] = GV.STATUS['本契約申込キャンセル']

                        logger.debug('# 「商談中止メール送信日」に当日の日付を設定する')
                        data_t_mr['cancellation_email_sent_date'] = datetime.now()

                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        tmp_t_mr = t_mr._update(data_t_mr)

                        if tmp_t_mr is None:
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')

                    data_m_con = None

                    if '# テーブル「契約情報」にデータを登録する':

                        logger.debug('# ******************************')
                        logger.debug('# テーブル「契約情報」にデータを登録する')
                        logger.debug('# m_contract')

                        param_m_con = {}

                        logger.debug('# 「商談中止メール送信日」に当日の日付を設定する')
                        param_m_con['cancellation_email_sent_date'] = datetime.now()

                        MCON = GV.get_module('m_contract')
                        m_con = MCON()

                        if 'contract_id' in data and \
                                data['contract_id'] is not None and \
                                data['contract_id'] != '':

                            filters = []
                            filters.append(
                                m_con.model_class.contract_id == data['contract_id'])
                            filters = and_(*filters)

                            tmp_m_con_get = None
                            tmp_m_con_get = m_con._get_item_by_filters(filters)

                            if tmp_m_con_get is not None:

                                param_m_con['contract_id'] = data['contract_id']

                                tmp_m_con = m_con._update(param_m_con)

                                if tmp_m_con is None:
                                    raise CustomException('SYS_ERR_100')

                                data_m_con = tmp_m_con.to_dict()

                                if data_m_con is None:
                                    raise CustomException('SYS_ERR_100')
                            
                            else:

                                logger.debug('# 契約データが存在しない')
                                logger.debug(data)

                                raise CustomException('SYS_ERR_100')

                        logger.debug('# ##############################')



                    if '# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。':
                        logger.debug('# ******************************')
                        logger.debug('# ・お客様にメールを送信。スタッフにメールを送信。メールの証跡保存。')

                        logger.debug('# メール 商談中止 申込キャンセル連絡')

                        data_email = {}
                        data_email['service_id'] = data['service_id']
                        data_email['email_address'] = data['contract_email_address']
                        data_email['mail_type'] = '申込キャンセル連絡'

                        data_email['company_name'] = data['company_name']
                        data_email['contract_department'] = data['contract_affiliation_department']
                        data_email['contract_name_last'] = data['contract_first_name']
                        data_email['contract_name_first'] = data['contract_last_name']
                        data_email['entry_code'] = data['entry_code']

                        self.send_email_contract(data_email)

                        logger.debug('# ##############################')
                        pass

                    if '# ・環境の割り当ての解除':

                        if '# 環境の割り当てられている場合':

                            if 'env_id' in data and data['env_id'] is not None:

                                logger.debug('# 環境の割り当てられている場合')

                                # logger.debug(
                                #     '# ******************************')
                                # logger.debug('# ・環境の割り当ての解除')

                                # if '# 「環境ストックマスタ」からデータ取得':

                                #     logger.debug('# 「環境ストックマスタ」からデータ取得')
                                #     logger.debug('# m_env_stock')

                                #     MES = GV.get_module('m_env_stock')
                                #     m_es = MES()

                                #     filters = []
                                #     filters.append(
                                #         m_es.model_class.env_id == data['env_id'])
                                #     filters.append(
                                #         m_es.model_class.system_id == data['system_id'])
                                #     filters.append(
                                #         m_es.model_class.service_id == data['service_id'])
                                #     filters.append(
                                #         m_es.model_class.company_code == data['company_code'])
                                #     filters = and_(*filters)

                                #     tmp_m_es_get = None
                                #     tmp_m_es_get = m_es._get_item_by_filters(
                                #         filters)

                                #     if tmp_m_es_get is not None:
                                #         data_m_es = tmp_m_es_get.to_dict()

                                #         data_m_es['company_code'] = None
                                #         data_m_es['use_flg'] = False
                                #         data_m_es['startup_flg'] = False

                                #         tmp_m_es_update = m_es._update(
                                #             data_m_es)

                                #         if tmp_m_es_update is None:
                                #             logger.debug(
                                #                 '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                #             logger.debug('# データ更新NGの場合')
                                #             raise CustomException(
                                #                 'SYS_ERR_100')

                                # logger.debug(
                                #     '# ##############################')

                                logger.debug('# ******************************')
                                logger.debug('# ・環境の割り当ての解除')

                                if '# 「環境ストックマスタ」からデータ取得':

                                    logger.debug('# 「環境ストックマスタ」からデータ取得')
                                    logger.debug('# m_env_stock')

                                    MES = GV.get_module('m_env_stock')
                                    m_es = MES()

                                    filters = []
                                    filters.append(m_es.model_class.env_id == data['env_id'])
                                    filters.append(m_es.model_class.system_id == data['system_id'])
                                    filters.append(m_es.model_class.service_id == data['service_id'])
                                    filters.append(m_es.model_class.company_code == data['company_code'])
                                    filters = and_(*filters)

                                    tmp_m_es_get = None
                                    tmp_m_es_get = m_es._get_item_by_filters(filters)

                                    if tmp_m_es_get is not None:
                                        data_m_es = tmp_m_es_get.to_dict()

                                        data_m_es['company_code'] = None
                                        data_m_es['use_flg'] = False
                                        data_m_es['startup_flg'] = False
                                        # NO.5284 の対応　li 2023/03/06 S
                                        data_m_es['deleted_flag'] = False
                                        # NO.5284 の対応　li 2023/03/06 E

                                        logger.debug('# 更新する')
                                        ES = GV.get_module('env_stock')
                                        es = ES()
                                        tmp_es_update = es._update(data_m_es)

                                        if tmp_es_update is None:
                                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                            logger.debug('# m_env_stockデータ更新NGの場合')
                                            logger.debug(data_m_es)
                                            raise CustomException('SYS_ERR_100')

                                logger.debug('# ##############################')
                                
                        pass

                    pass

            return data
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:

            logger.debug('# ##############################')
        pass

    # 「申込完了」メール送信
    def send_application_completion_email(self, data):

        pass

    # 「利用開始可能連絡」メール送信
    def send_availability_contact_email(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_availability_contact_email')

        logger.debug(data)

        logger.debug('# 「利用開始可能連絡」メール送信')

        data_email = {}
        data_email['service_id'] = data['service_id']
        data_email['email_address'] = data['email']
        data_email['mail_type'] = '利用開始可能連絡'

        self.send_email_contract(data_email)

        logger.debug('# ##############################')

        pass

    # 「解約」メール送信
    def send_termination_email(self, data):

        logger.debug('# ******************************')
        logger.debug('# send_termination_email')

        logger.debug(data)

        logger.debug('# ##############################')

        pass

    # 「商談中止」メール送信
    def send_cancellation_email(self, data):

        logger.debug('# ******************************')
        logger.debug('# send_termination_email')

        logger.debug(data)

        logger.debug('# ##############################')

        pass

    def send_email_contract(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_contract')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if 'email_address' in data:
                mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id'])
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}

            # ???
            result = self.send_email(mail_template, mail_parameter)

            return result

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

    def diff_gmo_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_gmo_data')

        try:

            # 代表者の生年月日
            old_company_leader_date_of_birth = old_data["company_leader_date_of_birth"]
            if old_company_leader_date_of_birth is not None:
                old_company_leader_date_of_birth = datetime.strptime(
                    old_company_leader_date_of_birth[0:19], '%Y-%m-%dT%H:%M:%S')
                old_company_leader_date_of_birth = old_company_leader_date_of_birth.strftime(
                    '%Y/%m/%d')

            new_company_leader_date_of_birth = new_data["company_leader_date_of_birth"]

            logger.debug('# ##############################')
            # 会社名
            if old_data["company_name"] != new_data["company_name"]:
                logger.debug('# company_name')
                return True
            # 代表者（姓）
            elif old_data["company_last_name"] != new_data["company_last_name"]:
                logger.debug('# company_last_name')
                return True
            # 代表者（名）
            elif old_data["company_first_name"] != new_data["company_first_name"]:
                logger.debug('# company_first_name')
                return True
            # 代表者の生年月日
            elif old_company_leader_date_of_birth != new_company_leader_date_of_birth:
                logger.debug('# company_leader_date_of_birth')
                return True
                # 契約者の郵便番号
            elif old_data["contract_zip_code"] != new_data["contract_zip_code"]:
                logger.debug('# contract_zip_code')
                return True
                # 契約者の住所
            # 契約者都道府県
            elif old_data["contract_address_pref"] != new_data["contract_address_pref"]:
                logger.debug('# contract_address_pref')
                return True
                # 契約者住所１(市区町村)
            elif old_data["contract_address_1"] != new_data["contract_address_1"]:
                logger.debug('# contract_address_1')
                return True
                # 契約者住所２(番地)
            elif old_data["contract_address_2"] != new_data["contract_address_2"]:
                logger.debug('# contract_address_2')
                return True
                # 契約者住所３(ビル、マンション名)
            elif old_data["contract_address_3"] != new_data["contract_address_3"]:
                logger.debug('# contract_address_3')
                return True
                # 契約者の電話番号
            elif old_data["contract_telephone_number"] != new_data["contract_telephone_number"]:
                logger.debug('# contract_telephone_number')
                return True
                # 契約者のメールアドレス
            elif old_data["contract_email_address"] != new_data["contract_email_address"]:
                logger.debug('# contract_email_address')
                return True

            return False
    
        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
            
    def diff_m_company_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_m_company_data')

        try:

            # 代表者の生年月日
            old_company_leader_date_of_birth = old_data["company_leader_date_of_birth"]
            if old_company_leader_date_of_birth is not None:
                old_company_leader_date_of_birth = datetime.strptime(
                    old_company_leader_date_of_birth[0:19], '%Y-%m-%dT%H:%M:%S')
                old_company_leader_date_of_birth = old_company_leader_date_of_birth.strftime(
                    '%Y/%m/%d')

            new_company_leader_date_of_birth = new_data["company_leader_date_of_birth"]

            # 企業コード
            if old_data['company_code'] != new_data['company_code']:
                logger.debug('# company_code')
                return True
            #  企業名
            if old_data['company_name'] != new_data['company_name']:
                logger.debug('# company_name')
                return True
            # 企業名(カナ)
            if old_data['company_name_kana'] != new_data['company_name_kana']:
                logger.debug('# company_name_kana')
                return True
            # 郵便番号
            if old_data['company_zip_code'] != new_data['company_zip_code']:
                logger.debug('# company_zip_code')
                return True
            #  住所(都道府県)
            if old_data['company_address_pref'] != new_data['company_address_pref']:
                logger.debug('# company_address_pref')
                return True
            # 住所1
            if old_data['company_address_1'] != new_data['company_address_1']:
                logger.debug('# company_address_1')
                return True
            # 住所2
            if old_data['company_address_2'] != new_data['company_address_2']:
                logger.debug('# company_address_2')
                return True
            # 住所3
            if old_data['company_address_3'] != new_data['company_address_3']:
                logger.debug('# company_address_3')
                return True
            # 電話番号1
            if old_data['company_telephone_number'] != new_data['company_telephone_number']:
                logger.debug('# company_telephone_number')
                return True
            # 代表者名(姓)
            if old_data['company_last_name'] != new_data['company_last_name']:
                logger.debug('# company_last_name')
                return True
            # 代表者名(名)
            if old_data['company_first_name'] != new_data['company_first_name']:
                logger.debug('# company_first_name')
                return True
            # 代表者名(姓)(カナ)
            if old_data['company_last_name_kana'] != new_data['company_last_name_kana']:
                logger.debug('# company_last_name_kana')
                return True
            # 代表者名(名)(カナ)
            if old_data['company_first_name_kana'] != new_data['company_first_name_kana']:
                logger.debug('# company_first_name_kana')
                return True
            # 代表者の生年月日
            if old_company_leader_date_of_birth != new_company_leader_date_of_birth:
                logger.debug('# company_leader_date_of_birth')
                return True
            # 企業備考欄
            if old_data['company_remarks_column'] != new_data['company_remarks_column']:
                logger.debug('# company_remarks_column')
                return True
            # GMO掛け払いのデータ更新あり
            if old_data['need_gmo_ps_creditfacility_modifybuyer'] != new_data['need_gmo_ps_creditfacility_modifybuyer']:
                logger.debug('# need_gmo_ps_creditfacility_modifybuyer')
                return True
            # 新業務システムの取引先コード
            if old_data['new_biz_sys_company_id'] != new_data['new_biz_sys_company_id']:
                logger.debug('# new_biz_sys_company_id')
                return True

            return False
    
        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def diff_m_user_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_m_company_data')

        try:

            # # ユーザーマスタID
            # if old_data['user_master_id'] != new_data['user_master_id']:
                # logger.debug('# user_master_id')
                # return True
            # Auth0ユーザーID
            if old_data['auth0_user_id'] != new_data['auth0_user_id']:
                logger.debug('# company_code')
                return True
            # 企業コード
            if old_data['company_code'] != new_data['company_code']:
                logger.debug('# company_code')
                return True
            # 名前
            if old_data['name_last'] != new_data['name_last']:
                logger.debug('# name_last')
                return True
            # 名前(姓)
            if old_data['name_first'] != new_data['name_first']:
                logger.debug('# name_first')
                return True
            # 名前(名)
            if old_data['name_last_kana'] != new_data['name_last_kana']:
                logger.debug('# name_last_kana')
                return True
            # 名前(カナ)(姓)
            if old_data['name_first_kana'] != new_data['name_first_kana']:
                logger.debug('# name_first_kana')
                return True
            # 部署名(カナ)(名)
            if old_data['department'] != new_data['department']:
                logger.debug('# department')
                return True
            # 役職
            if old_data['position'] != new_data['position']:
                logger.debug('# position')
                return True
            # メールアドレス
            if old_data['email'] != new_data['email']:
                logger.debug('# email')
                return True
            # 電話番号
            if old_data['tel'] != new_data['tel']:
                logger.debug('# tel')
                return True
            # # 招待コード
            # if old_data['invitation_code'] != new_data['invitation_code']:
                # logger.debug('# invitation_code')
                # return True
            # # 招待日時
            # if old_data['invitation_date'] != new_data['invitation_date']:
                # logger.debug('# invitation_date')
                # return True
            # # 登録日時
            # if old_data['cdate'] != new_data['cdate']:
                # logger.debug('# cdate')
                # return True
            # # 更新日時
            # if old_data['udate'] != new_data['udate']:
                # logger.debug('# udate')
                # return True

            return False
    
        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def diff_m_contract_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_m_contract_data')

        try:

            # 契約開始日
            old_subscription_start_date = old_data["subscription_start_date"]
            if old_subscription_start_date is not None:
                old_subscription_start_date = datetime.strptime(
                    old_subscription_start_date[0:19], '%Y-%m-%dT%H:%M:%S')
                old_subscription_start_date = old_subscription_start_date.strftime(
                    '%Y/%m/%d')

            new_subscription_start_date = new_data["subscription_start_date"]

            # 契約終了日
            old_subscription_end_date = old_data["subscription_end_date"]
            if old_subscription_end_date is not None:
                old_subscription_end_date = datetime.strptime(
                    old_subscription_end_date[0:19], '%Y-%m-%dT%H:%M:%S')
                old_subscription_end_date = old_subscription_end_date.strftime(
                    '%Y/%m/%d')

            new_subscription_end_date = new_data["subscription_end_date"]

            # 契約ID
            if old_data['contract_id'] != new_data['contract_id']:
                logger.debug('# contract_id')
                return True
            # 申込コード
            if old_data['entry_code'] != new_data['entry_code']:
                logger.debug('# entry_code')
                return True
            # 企業コード
            if old_data['company_code'] != new_data['company_code']:
                logger.debug('# company_code')
                return True
            # 契約名
            if old_data['subscription_name'] != new_data['subscription_name']:
                logger.debug('# subscription_name')
                return True
            # 契約者名(姓)
            if old_data['contract_last_name'] != new_data['contract_last_name']:
                logger.debug('# contract_last_name')
                return True
            # 契約者名(名)
            if old_data['contract_first_name'] != new_data['contract_first_name']:
                logger.debug('# contract_first_name')
                return True
            # 契約者名カナ(姓)
            if old_data['contract_last_name_kana'] != new_data['contract_last_name_kana']:
                logger.debug('# contract_last_name_kana')
                return True
            # 契約者名カナ(名)
            if old_data['contract_first_name_kana'] != new_data['contract_first_name_kana']:
                logger.debug('# contract_first_name_kana')
                return True
            # 契約開始日
            # if old_data['subscription_start_date'] != new_data['subscription_start_date']:
            if old_subscription_start_date != new_subscription_start_date:
                logger.debug('# subscription_start_date')
                return True
            # 契約終了日
            # if old_data['subscription_end_date'] != new_data['subscription_end_date']:
            if old_subscription_end_date != new_subscription_end_date:
                logger.debug('# subscription_end_date')
                return True
            # 送付先名 ???
            if old_data['postal_address'] != new_data['postal_address']:
                logger.debug('# postal_address')
                return True
            # 郵便番号
            if old_data['contract_zip_code'] != new_data['contract_zip_code']:
                logger.debug('# contract_zip_code')
                return True
            # 都道府県
            if old_data['contract_address_pref'] != new_data['contract_address_pref']:
                logger.debug('# contract_address_pref')
                return True
            # 住所１
            if old_data['contract_address_1'] != new_data['contract_address_1']:
                logger.debug('# contract_address_1')
                return True
            # 住所２
            if old_data['contract_address_2'] != new_data['contract_address_2']:
                logger.debug('# contract_address_2')
                return True
            # 住所３
            if old_data['contract_address_3'] != new_data['contract_address_3']:
                logger.debug('# contract_address_3')
                return True
            # 電話番号
            if old_data['contract_telephone_number'] != new_data['contract_telephone_number']:
                logger.debug('# contract_telephone_number')
                return True
            # メールアドレス
            if old_data['contract_email_address'] != new_data['contract_email_address']:
                logger.debug('# contract_email_address')
                return True
            # 部署名
            if old_data['contract_affiliation_department'] != new_data['contract_affiliation_department']:
                logger.debug('# contract_affiliation_department')
                return True
            # 担当営業名
            if old_data['salesman_name'] != new_data['salesman_name']:
                logger.debug('# salesman_name')
                return True
            # # 適用開始日
            # if old_data['applicable_start_date'] != new_data['applicable_start_date']:
            #     logger.debug('# applicable_start_date')
            #     return True
            # # 適用終了日
            # if old_data['applicable_end_date'] != new_data['applicable_end_date']:
            #     logger.debug('# applicable_end_date')
            #     return True
            # テキ05 役職(顧客)
            if old_data['contract_director'] != new_data['contract_director']:
                logger.debug('# contract_director')
                return True
            # テキ08 請求方法
            if old_data['payment_method'] != new_data['payment_method']:
                logger.debug('# payment_method')
                return True
            # テキ09 担当営業(職番)
            if old_data['salesman_code'] != new_data['salesman_code']:
                logger.debug('# salesman_code')
                return True
            # --> 共通PF4 職番の重複許可 2024/02/06 nakamura.e
            # スタッフID
            if old_data['staff_id'] != new_data['staff_id']:
                logger.debug('# staff_id')
                return True
            # <-- 共通PF4 職番の重複許可 2024/02/06 nakamura.e

            # 備考
            if old_data['subscription_notes'] != new_data['subscription_notes']:
                logger.debug('# subscription_notes')
                return True
            # 請求書の送付方法
            if old_data['gmo_invoice_mail'] != new_data['gmo_invoice_mail']:
                logger.debug('# gmo_invoice_mail')
                return True
            # # 一時休止予定日
            # if old_data['temp_service_sleep_start_date'] != new_data['temp_service_sleep_start_date']:
            #     logger.debug('# temp_service_sleep_start_date')
            #     return True
            # # 一時休止からの再開予定日
            # if old_data['temp_service_sleep_restart_date'] != new_data['temp_service_sleep_restart_date']:
            #     logger.debug('# temp_service_sleep_restart_date')
            #     return True
            # # 停止予定日
            # if old_data['ndes_service_stop_start_date'] != new_data['ndes_service_stop_start_date']:
            #     logger.debug('# ndes_service_stop_start_date')
            #     return True
            # # 停止からの再開予定日
            # if old_data['ndes_service_stop_restart_date'] != new_data['ndes_service_stop_restart_date']:
            #     logger.debug('# ndes_service_stop_restart_date')
            #     return True
            # # サービスの解約メール送信日
            # if old_data['termination_of_service_mail_send_date'] != new_data['termination_of_service_mail_send_date']:
            #     logger.debug('# termination_of_service_mail_send_date')
            #     return True
            # # サービスの利用ステータス
            # if old_data['service_usable_status'] != new_data['service_usable_status']:
            #     logger.debug('# service_usable_status')
            #     return True
            # 解約理由
            if old_data['reason_for_termination'] != new_data['reason_for_termination']:
                logger.debug('# reason_for_termination')
                return True
            # # サービスの再開事前通知実施日
            # if old_data['pre_notification_resumption_of_service_mael_send_date'] != new_data['pre_notification_resumption_of_service_mael_send_date']:
            #     logger.debug('# pre_notification_resumption_of_service_mael_send_date')
            #     return True
            # # 申込完了メール送信日
            # if old_data['application_completion_email_sent_date'] != new_data['application_completion_email_sent_date']:
            #     logger.debug('# application_completion_email_sent_date')
            #     return True
            # # 商談中止メール送信日
            # if old_data['cancellation_email_sent_date'] != new_data['cancellation_email_sent_date']:
            #     logger.debug('# cancellation_email_sent_date')
            #     return True

            return False

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def diff_t_manage_request_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_t_manage_request_data')

        try:

            # 信用調査結果登録日
            old_credit_check_regist_date = old_data["credit_check_regist_date"]
            if old_credit_check_regist_date is not None:
                old_credit_check_regist_date = datetime.strptime(
                    old_credit_check_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')
                old_credit_check_regist_date = old_credit_check_regist_date.strftime(
                    '%Y/%m/%d')

            new_credit_check_regist_date = new_data["credit_check_regist_date"]

            # プロスペクト申請結果登録日
            old_prospect_request_regist_date = old_data["prospect_request_regist_date"]
            if old_prospect_request_regist_date is not None:
                old_prospect_request_regist_date = datetime.strptime(
                    old_prospect_request_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')
                old_prospect_request_regist_date = old_prospect_request_regist_date.strftime(
                    '%Y/%m/%d')

            new_prospect_request_regist_date = new_data["prospect_request_regist_date"]

            # 申込管理ID
            if old_data['manage_req_id'] != new_data['manage_req_id']:
                logger.debug('# manage_req_id')
                return True
            # 企業コード
            if old_data['company_code'] != new_data['company_code']:
                logger.debug('# company_code')
                return True
            # システムID
            if old_data['system_id'] != new_data['system_id']:
                logger.debug('# system_id')
                return True
            # サービスID
            if old_data['service_id'] != new_data['service_id']:
                logger.debug('# service_id')
                return True
            # 契約ID
            if old_data['contract_id'] != new_data['contract_id']:
                logger.debug('# contract_id')
                return True
            # # Auth0ユーザーID
            # if old_data['auth0_user_id'] != new_data['auth0_user_id']:
                # logger.debug('# auth0_user_id')
                # return True
            # # 資料請求ID
            # if old_data['document_req_id'] != new_data['document_req_id']:
                # logger.debug('# document_req_id')
                # return True
            # # トライアル申込ID
            # if old_data['trial_req_id'] != new_data['trial_req_id']:
                # logger.debug('# trial_req_id')
                # return True
            # # ワークショップ申込ID
            # if old_data['workshop_req_id'] != new_data['workshop_req_id']:
                # logger.debug('# workshop_req_id')
                # return True
            # # 本契約申込ID
            # if old_data['contract_req_id'] != new_data['contract_req_id']:
                # logger.debug('# contract_req_id')
                # return True
            # 担当営業コード
            if old_data['salesman_code'] != new_data['salesman_code']:
                logger.debug('# salesman_code')
                return True
            # --> 共通PF4 職番の重複許可 2024/02/06 nakamura.e
            # スタッフID
            if old_data['staff_id'] != new_data['staff_id']:
                logger.debug('# staff_id')
                return True
            # <-- 共通PF4 職番の重複許可 2024/02/06 nakamura.e
            # # ステータス
            # if old_data['status'] != new_data['status']:
                # logger.debug('# status')
                # return True
            # # システム利用可能フラグ
            # if old_data['system_usable_flag'] != new_data['system_usable_flag']:
                # logger.debug('# system_usable_flag')
                # return True
            # # 環境ID
            # if old_data['env_id'] != new_data['env_id']:
                # logger.debug('# env_id')
                # return True
            # 信用調査
            if old_data['credit_check'] != new_data['credit_check']:
                logger.debug('# credit_check')
                return True
            # 信用調査結果登録日
            # if old_data['credit_check_regist_date'] != new_data['credit_check_regist_date']:
            if old_credit_check_regist_date != new_credit_check_regist_date:
                logger.debug('# credit_check_regist_date')
                return True
            # プロスペクト申請
            if old_data['prospect_request'] != new_data['prospect_request']:
                logger.debug('# prospect_request')
                return True
            # プロスペクト申請結果登録日
            # if old_data['prospect_request_regist_date'] != new_data['prospect_request_regist_date']:
            if old_prospect_request_regist_date != new_prospect_request_regist_date:
                logger.debug('# prospect_request_regist_date')
                return True
            # 本契約可否判断
            if old_data['contract_judgment'] != new_data['contract_judgment']:
                logger.debug('# contract_judgment')
                return True
            
            return False

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def diff_auth0_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_auth0_data')

        try:

            # システム管理者 （姓）
            if old_data['name_last'] != new_data['name_last']:
                logger.debug('# name_last')
                return True
            # システム管理者 （名）
            if old_data['name_first'] != new_data['name_first']:
                logger.debug('# name_first')
                return True
            
            return False

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def diff_m_gmo_payment_service_data(self, old_data, new_data):
        logger.debug('# ******************************')
        logger.debug('# diff_m_gmo_payment_service_data')

        try:

            # 枠保証申請額
            if old_data['creditfacility_application'] != new_data['creditfacility_application']:
                logger.debug('# creditfacility_application')
                return True
            
            return False

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
    def generate_entry_code(self):

        # // # ML-YYYYMMDD-半角英字ランダム10文字(大文字)
        # var dt = new Date()
        # var y = dt.getFullYear();
        # var m = ('00' + (dt.getMonth() + 1)).slice(-2);
        # var d = ('00' + dt.getDate()).slice(-2);
        # var h = ('00' + dt.getHours()).slice(-2);
        # var mm = ('00' + dt.getMinutes()).slice(-2);
        # var resultdt = y + m + d;
        # // console.log(resultdt);

        # state.record['sysdateTime3']['value'] = y + "年" + m + "月" + d + "日 " + h + "時" + mm + "分";

        # //使用文字の定義
        # var str = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

        # //桁数の定義
        # var len = 10;

        # //ランダムな文字列の生成
        # var resultrandom = "";
        # for (var i = 0; i < len; i++) {
        #   resultrandom += str.charAt(Math.floor(Math.random() * str.length));
        # }
        # console.log(resultrandom);

        # var entry_code = 'ML' + '-' + resultdt + '-' + resultrandom
        # // console.log(entry_code);
        # state.record['entry_code3']['value'] = entry_code;

        dt_now = datetime.now().strftime('%Y%m%d')

        # 使用文字の定義
        tmp_str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'

        # 桁数の定義
        tmp_len = 10

        # ランダムな文字列の生成
        import random

        tmp_random = ''
        for i in range(tmp_len):
            tmp_random += tmp_str[random.randint(0, len(tmp_str) - 1)]

        entry_code = 'ML' + '-' + dt_now + '-' + tmp_random
        logger.debug(entry_code)

        return entry_code

        pass

    # 枠保証状況取得する
    def get_frame_guarantee_status(self, data):
        logger.debug('# ******************************')
        logger.debug('枠保証状況取得する')
        logger.debug('get_frame_guarantee_status')

        try:
            # 支払方法がGMO掛け払いの場合
            if data['payment_method'] is not None and data['payment_method'] != 'GMO掛け払い':
                logger.debug('### GMO掛け払いではない')
                return
            params_gpcg = {}
            params_gpcg['targetBuyer'] = {}
            params_gpcg['targetBuyer']['shopCustomerId'] = data['company_code']

            # 6708----------10/16----------S
            item_system_id = None
            item_authenticationId = None
            item_shopCode = None
            item_connectPassword = None
            if data['system_id'] is not None:
                item_system_id = data['system_id']

                data_m_si = None

                logger.debug('# ******************************')
                MSI = GV.get_module('m_supplier_info')
                m_si = MSI()

                filters = []
                filters.append(m_si.model_class.system_id == item_system_id)
                filters = and_(*filters)

                tmp_m_si = m_si._get_item_by_filters(filters)

                if tmp_m_si is not None:
                    data_m_si = tmp_m_si.to_dict()
                    item_authenticationId = data_m_si['gmo_payment_frame_guarantee_id']
                    item_shopCode = data_m_si['gmo_payment_frame_guarantee_shopcode']
                    item_connectPassword = data_m_si['gmo_payment_frame_guarantee_password']

            params_gpcg['relatedData'] = {}
            params_gpcg['relatedData']['system_id'] = item_system_id
            params_gpcg['relatedData']['authenticationId'] = item_authenticationId
            params_gpcg['relatedData']['shopCode'] = item_shopCode
            params_gpcg['relatedData']['connectPassword'] = item_connectPassword
            # 6708----------10/16----------E

            res_gpcg = self.get_payment_creditfacility_getbuyercreditfacility(
                params_gpcg)

            # {
            #   'statusCode': 200,
            #   'headers': {
            #     'Access-Control-Allow-Headers': 'Content-Type',
            #     'Access-Control-Allow-Origin': '*',
            #     'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
            #   },
            #   'body': '{\n
            #      "result": "OK",\n
            #      "errors": [],\n
            #      "buyer": {\n
            #         "shopCustomerId": "K30029"\n
            #       },\n
            #       "examination": {\n
            #          "status": "審査中",\n
            #          "resultReasons": []\n
            #       }\n
            #   }'
            # }

            logger.debug('res_gpcg')
            logger.debug(res_gpcg)

            if 'statusCode' in res_gpcg and res_gpcg['statusCode'] == 400:

                if 'body' in res_gpcg:

                    tmp_error = json.loads(res_gpcg['body'])

                    logger.debug('tmp_error')
                    logger.debug(tmp_error)

                    error_message = ''

                    if 'errors' in tmp_error:
                        for e in tmp_error['errors']:
                            error_message += '【GMO枠保証申請】' + '<br/>'
                            error_message += '<br/>'
                            if 'errCode' in e and e['errCode'] is not None:
                                error_message += e['errCode'] + '<br/>'
                            if 'errorMessage' in e and e['errorMessage'] is not None:
                                error_message += e['errorMessage'] + '<br/>'

                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)

                    pass

            if 'body' in res_gpcg:

                body_gpcg = json.loads(res_gpcg['body'])

                params_m_gps = {
                    'examination_status': None,
                    'creditfacility_upperlimit': None,
                    'creditfacility_balance': None,
                    'creditfacility_startdate': None,
                    'creditfacility_enddate': None,
                    'examination_resultreasons': None,
                    'examination_request_date': None
                }

                logger.debug('# 審査情報')
                if 'examination' in body_gpcg:

                    logger.debug('# 枠保証審査ステータス')
                    if 'status' in body_gpcg['examination']:
                        examination_status = body_gpcg['examination']['status']
                        params_m_gps['examination_status'] = examination_status

                    logger.debug('# 枠保証審査結果事由情報')
                    if 'resultReasons' in body_gpcg['examination']:
                        resultReasons = body_gpcg['examination']['resultReasons']

                        examination_resultreasons = ''

                        if type(resultReasons) == list:
                            for r in resultReasons:
                                examination_resultreasons += r + '\n'

                        params_m_gps['examination_resultreasons'] = examination_resultreasons

                logger.debug('# 枠保証情報')
                if 'creditFacility' in body_gpcg:

                    logger.debug('# 枠保証上限額')
                    if 'upperLimit' in body_gpcg['creditFacility']:
                        creditfacility_upperlimit = body_gpcg['creditFacility']['upperLimit']
                        params_m_gps['creditfacility_upperlimit'] = creditfacility_upperlimit

                    logger.debug('# 枠保証残高')
                    if 'balance' in body_gpcg['creditFacility']:
                        creditfacility_balance = body_gpcg['creditFacility']['balance']
                        params_m_gps['creditfacility_balance'] = creditfacility_balance

                    logger.debug('# 枠保証利用開始日')
                    if 'startDate' in body_gpcg['creditFacility']:
                        creditfacility_startdate = body_gpcg['creditFacility']['startDate']
                        params_m_gps['creditfacility_startdate'] = creditfacility_startdate

                    logger.debug('# 枠保証利用終了日')
                    if 'endDate' in body_gpcg['creditFacility']:
                        creditfacility_enddate = body_gpcg['creditFacility']['endDate']
                        params_m_gps['creditfacility_enddate'] = creditfacility_enddate

                logger.debug('# ******************************')
                logger.debug('# GMO掛け払い情報を更新する')
                logger.debug('m_gmo_payment_service')

                MGPS = GV.get_module('m_gmo_payment_service')
                m_gps = MGPS()

                filters = []
                filters.append(m_gps.model_class.company_code ==
                               data['company_code'])
                filters = and_(*filters)
                tmp_m_gps = m_gps._get_item_by_filters(filters)

                if tmp_m_gps is not None:

                    data_m_gps = tmp_m_gps.to_dict()
                    if params_m_gps['examination_status'] is not None:
                        data_m_gps['examination_status'] = params_m_gps['examination_status']
                    if params_m_gps['creditfacility_upperlimit'] is not None:
                        data_m_gps['creditfacility_upperlimit'] = params_m_gps['creditfacility_upperlimit']
                    if params_m_gps['creditfacility_balance'] is not None:
                        data_m_gps['creditfacility_balance'] = params_m_gps['creditfacility_balance']
                    if params_m_gps['creditfacility_startdate'] is not None:
                        data_m_gps['creditfacility_startdate'] = params_m_gps['creditfacility_startdate']
                    if params_m_gps['creditfacility_enddate'] is not None:
                        data_m_gps['creditfacility_enddate'] = params_m_gps['creditfacility_enddate']
                    if params_m_gps['examination_resultreasons'] is not None:
                        data_m_gps['examination_resultreasons'] = params_m_gps['examination_resultreasons']
                    # バグ #5345 2024/03/07 li  S
                    # print('|||||||||||||||||||||||||3')
                    # print(params_m_gps['examination_request_date'])
                    # print('|||||||||||||||||||||||||3')
                    dt_nowdata = datetime.now()
                    # if params_m_gps['examination_request_date'] is not None:
                    data_m_gps['examination_request_date'] = dt_nowdata
                    # バグ #5345 2024/03/07 li  E

                    tmp_m_gps_update = m_gps._update(data_m_gps)

                    if tmp_m_gps_update is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# GMO掛け払い情報を更新失敗')
                        logger.debug(data_m_gps)
                        raise CustomException('SYS_ERR_100')

                    pass

                pass

                logger.debug('# ##############################')

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    # 枠保証再申請
    def reapply_for_frame_guarantee(self, data):
        logger.debug('# ******************************')
        logger.debug('枠保証再申請')
        logger.debug('reapply_for_frame_guarantee')

        try:
            data_m_srv = None
            # 支払方法がGMO掛け払いの場合
            logger.debug(data['payment_method'])
            if data['payment_method'] is not None and data['payment_method'] != 'GMO掛け払い':
                logger.debug('GMO掛け払いではない')
                return {}


            logger.debug('# ******************************')
            logger.debug('サービスデータ取得')
            # サービスデータ取得
            # m_services

            if data['service_id'] is not None:

                # from ..model.m_services import Sub as MSer
                # m_ser = MSer()
                MSRV = GV.get_module('m_services')
                m_srv = MSRV()

                filters = []
                filters.append(m_srv.model_class.service_id ==
                               data['service_id'])
                filters = and_(*filters)

                tmp_m_srv = m_srv._get_item_by_filters(filters)

                if tmp_m_srv is not None:
                    data_m_srv = tmp_m_srv.to_dict()

            logger.debug('# ##############################')

            # # 枠保証再申請 # 申請する
            # apply = 1
            # # 希望上限金額
            # reqUpperLimit = 0
            # if data_m_srv:
            #     reqUpperLimit = data_m_srv['gmo_ps_req_upper_limit']

            # address = ''
            # address = data['contract_address_pref'] + \
            #     data['contract_address_1'] + data['contract_address_2']
            # if 'contract_address_3' in data and data['contract_address_3']:
            #     address = address + data['contract_address_3']

            # params_rpcm = {
            #     'targetBuyer': {
            #         'shopCustomerId': data['company_code']
            #     },
            #     'buyer': {
            #         # 'buyerNameFamily': '掛払',
            #         'buyerNameFamily': data['contract_name_last'],
            #         # 'buyerName': '太郎',
            #         'buyerName': data['contract_name_first'],
            #         # 'buyerNameFamilyKana': 'カケバライ',
            #         'buyerNameFamilyKana': data['contract_name_last_kana'],
            #         # 'buyerNameKana': 'タロウ',
            #         'buyerNameKana': data['contract_name_first_kana'],
            #         # 'zipCode': '150-0043',
            #         'zipCode': data['contract_zipcode'],
            #         # zipCode: data['company_zipcode'],
            #         # 'address': '東京都渋谷区道玄坂 1−14−6',
            #         'address': address,
            #         # 'companyName': 'サンプル株式会社',
            #         'companyName': data['company_name'],
            #         # 'departmentName': 'サンプル部',
            #         'departmentName': data['contract_department'],
            #         # 'tel1': '01234567',
            #         'tel1': data['contract_tel_1'],
            #         # tel1: data['company_tel_1'],
            #         # # 'tel2': '01234567',
            #         # 'tel2': data['tel2'],,
            #         # 'email1': 'sample1@localhost.localdomain',
            #         'email1': data['contract_email'],
            #         # # 'email2': 'sample1@localhost.localdomain',
            #         # 'email2': data['email2'],,
            #         # 'presidentNameFamily': '代表',
            #         'presidentNameFamily': data['company_leader_last'],
            #         # 'presidentName': '花子',
            #         'presidentName': data['company_leader_first'],
            #         # 'presidentNameFamilyKana': 'ダイヒョウ',
            #         'presidentNameFamilyKana': data['company_leader_kana_last'],
            #         # 'presidentNameKana': 'ハナコ',
            #         'presidentNameKana': data['company_leader_kana_first'],
            #         # 'birthday': '20201029',
            #         'birthday': data['company_leader_date_of_birth'],
            #         # 'shopCustomerId': '5',
            #         'shopCustomerId': data['company_code'],
            #         # # 'corpNumber': '1234567890123'
            #         # 'corpNumber': data['corpNumber'],
            #     },
            #     'creditFacility': {
            #         # 'apply': '1',
            #         'apply': apply,
            #         # 'reqUpperLimit': 10000000
            #         'reqUpperLimit': reqUpperLimit
            #     }
            # }

            # // 枠保証申込
            apply = 1
            # // 希望上限金額
            reqUpperLimit = 0
            if data_m_srv:
                reqUpperLimit = data_m_srv['gmo_ps_req_upper_limit']
            # 住所
            address = data['contract_address_pref'] + \
                data['contract_address_1'] + data['contract_address_2']
            if data['contract_address_3']:
                address = address + data['contract_address_3']

            # 6708----------10/16----------S
            item_system_id = None
            item_authenticationId = None
            item_shopCode = None
            item_connectPassword = None
            if data['system_id'] is not None:
                item_system_id = data['system_id']

                data_m_si = None

                logger.debug('# ******************************')
                MSI = GV.get_module('m_supplier_info')
                m_si = MSI()

                filters = []
                filters.append(m_si.model_class.system_id == item_system_id)
                filters = and_(*filters)

                tmp_m_si = m_si._get_item_by_filters(filters)

                if tmp_m_si is not None:
                    data_m_si = tmp_m_si.to_dict()
                    item_authenticationId = data_m_si['gmo_payment_frame_guarantee_id']
                    item_shopCode = data_m_si['gmo_payment_frame_guarantee_shopcode']
                    item_connectPassword = data_m_si['gmo_payment_frame_guarantee_password']
            # 6708----------10/16----------E
                                
            params_rpcm = {
                'targetBuyer': {
                    'shopCustomerId': data['company_code']
                },
                'buyer': {
                    #   // 'buyerNameFamily': '掛払',
                    'buyerNameFamily': data['contract_last_name'],
                    #   // 'buyerName': '太郎',
                    'buyerName': data['contract_first_name'],
                    #   // 'buyerNameFamilyKana': 'カケバライ',
                    'buyerNameFamilyKana': data['contract_last_name_kana'],
                    #   // 'buyerNameKana': 'タロウ',
                    'buyerNameKana': data['contract_first_name_kana'],
                    #   // 'zipCode': '150-0043',
                    'zipCode': data['contract_zip_code'],
                    #   // zipCode: data['company_zipcode'],
                    #   // 'address': '東京都渋谷区道玄坂 1−14−6',
                    'address': address,
                    #   // 'companyName': 'サンプル株式会社',
                    'companyName': data['company_name'],
                    #   // 'departmentName': 'サンプル部',
                    'departmentName': data['contract_affiliation_department'],
                    #   // 'tel1': '01234567',
                    'tel1': data['contract_telephone_number'],
                    #   // tel1: data['company_tel_1'],
                    #   // // 'tel2': '01234567',
                    #   // 'tel2': data['tel2'],
                    #   // 'email1': 'sample1@localhost.localdomain',
                    'email1': data['contract_email_address'],
                    #   // // 'email2': 'sample1@localhost.localdomain',
                    #   // 'email2': data['email2'],
                    #   // 'presidentNameFamily': '代表',
                    'presidentNameFamily': data['company_last_name'],
                    #   // 'presidentName': '花子',
                    'presidentName': data['company_first_name'],
                    #   // 'presidentNameFamilyKana': 'ダイヒョウ',
                    'presidentNameFamilyKana': data['company_last_name_kana'],
                    #   // 'presidentNameKana': 'ハナコ',
                    'presidentNameKana': data['company_first_name_kana'],
                    #   // 'birthday': '20201029',
                    'birthday': data['company_leader_date_of_birth'],
                    #   // 'shopCustomerId': '5',
                    'shopCustomerId': data['company_code'],
                    #   // // 'corpNumber': '1234567890123'
                    #   // 'corpNumber': data['corpNumber'],
                },
                'creditFacility': {
                    #   // 'apply': '1',
                    'apply': apply,
                    #   // 'reqUpperLimit': 10000000
                    'reqUpperLimit': reqUpperLimit,
                },
                # 6708----------10/16----------S
                'relatedData': {
                    #   // 'system_id': 'SYS00001',
                    'system_id': item_system_id,
                    #   // 'authenticationId': '0000000000',
                    'authenticationId': item_authenticationId,
                    #   // 'shopCode': 's00001486',
                    'shopCode': item_shopCode,
                    #   // 'connectPassword': '00001486',
                    'connectPassword': item_connectPassword,
                },
                # 6708----------10/16----------E
            }

            res_rpcm = self.register_payment_creditfacility_modifybuyer(
                params_rpcm)

            logger.debug('res_rpcm')
            logger.debug(res_rpcm)

            # [DEBUG]	2023-08-09T08:12:37.331Z	221ca74e-d928-402e-aed1-1e186a943957
            # {
            #   'statusCode': 400,
            #   'headers': {
            #      'Access-Control-Allow-Headers': 'Content-Type',
            #      'Access-Control-Allow-Origin': '*',
            #      'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
            #   },
            #   'body': '{\n  "result": "NG",\n  "errors": [\n    {\n      "errCode": "BCT0033",\n      "errorMessage": "購入企業IDが重複しています。"\n    }\n  ]\n}'}

            if 'statusCode' in res_rpcm and res_rpcm['statusCode'] == 400:
                if 'body' in res_rpcm:

                    tmp_error = json.loads(res_rpcm['body'])

                    logger.debug('tmp_error')
                    logger.debug(tmp_error)

                    error_message = ''

                    if 'errors' in tmp_error:
                        for e in tmp_error['errors']:
                            error_message += '【GMO枠保証申請】' + '<br/>'
                            error_message += '<br/>'
                            if 'errCode' in e and e['errCode'] is not None:
                                error_message += e['errCode'] + '<br/>'
                            if 'errorMessage' in e and e['errorMessage'] is not None:
                                error_message += e['errorMessage'] + '<br/>'

                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)

            logger.debug('# ******************************')
            logger.debug('枠保証状況取得する')

            self.get_frame_guarantee_status(data)

            logger.debug('# ##############################')

            pass

            return {}

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    # 「クラウドストレージの登録完了」メール送信
    def cloud_strage_email(self, data):
        logger.debug('# ******************************')
        logger.debug('「クラウドストレージの登録完了」メール送信')
        logger.debug('cloud_strage_email')
        logger.debug(data)

        try:
            logger.debug('# ******************************')

            logger.debug('# メール送信')
            
            VCS = GV.get_module('view_cloud_strage')
            v_cs = VCS()

            filters = []
            filters.append(
                v_cs.model_class.contract_id == data['contract_id'])
            filters = and_(*filters)

            tmp_m_cs = v_cs._get_item_by_filters(filters, get_all=True)

            logger.debug(tmp_m_cs)
            if tmp_m_cs is not None and len(tmp_m_cs) > 0:
                for t_m_cs in tmp_m_cs:
                    data_v_cs = t_m_cs.to_dict()

                    data_email = {}
                    data_email['mail_type'] = 'クラウドストレージ登録完了通知'
        
                    data_email['system_id'] = GV.SYSTEM_ID
                    data_email['service_id'] = data['service_id']
                    data_email['system_name'] = GV.SYSTEM_NAME
                    data_email['service_name'] = data['service_name']
                    data_email['company_name'] = data['company_name']
                    data_email['administrator_name_last'] = data['name_last']
                    data_email['administrator_name_first'] = data['name_first']
                    if data_v_cs['enable_flg']:
                        strEnable_flg = '有効化する'
                    else:
                        strEnable_flg = '有効化しない'
                    data_email['enable_flg'] = strEnable_flg
                    data_email['cloud_strage_type'] = data_v_cs['cloud_strage_type']
                    if data_v_cs['user_name'] is None:
                        strUser_name = ''
                    else:
                        strUser_name = data_v_cs['user_name']
                    data_email['user_name'] = strUser_name
                    self.send_email_contract(data_email)

            logger.debug('# ##############################')

            pass

            return {}

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    def register_payment_creditfacility_registerbuyer(self, data):

        logger.debug('# register_payment_creditfacility_registerbuyer')

        res = {}

        try:

            logger.debug('# ******************************')

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/payment/creditfacility/registerbuyer',
                'body': json.dumps(data)
            }

            Payload = json.dumps(input_event, ensure_ascii=False)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            if GV.DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_PAYMENT,
                    InvocationType='RequestResponse',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)
                # response = {}

                res = response

                if 'StatusCode' in response and response['StatusCode'] == 200:

                    # レスポンス読出し
                    Payload = json.loads(response['Payload'].read())
                    logger.debug("---03: body:")
                    logger.debug(Payload)
                    res = Payload

            return res

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    def get_payment_creditfacility_getbuyercreditfacility(self, data):

        logger.debug('# get_payment_creditfacility_getbuyercreditfacility')
        logger.debug('# 枠保証状況取得')

        res = {}

        try:

            logger.debug('# ******************************')

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/payment/creditfacility/getbuyercreditfacility',
                'body': json.dumps(data)
            }

            Payload = json.dumps(input_event, ensure_ascii=False)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            if GV.DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_PAYMENT,
                    InvocationType='RequestResponse',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)
                # response = {}

                res = response

                if 'StatusCode' in response and response['StatusCode'] == 200:

                    # レスポンス読出し
                    Payload = json.loads(response['Payload'].read())
                    logger.debug("---03: body:")
                    logger.debug(Payload)
                    res = Payload

            return res

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    def register_payment_creditfacility_modifybuyer(self, data):
        logger.debug('# ******************************')
        logger.debug('枠保証再申請 GMOのAPI呼出')
        logger.debug('register_payment_creditfacility_modifybuyer')

        res = {}

        try:

            logger.debug('# ******************************')

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/payment/creditfacility/modifybuyer',
                'body': json.dumps(data)
            }

            Payload = json.dumps(input_event, ensure_ascii=False)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            if GV.DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_PAYMENT,
                    InvocationType='RequestResponse',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)
                # response = {}

                res = response

                if 'StatusCode' in response and response['StatusCode'] == 200:

                    # レスポンス読出し
                    Payload = json.loads(response['Payload'].read())
                    logger.debug("---03: body:")
                    logger.debug(Payload)
                    res = Payload

            return res

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    #   // サービスを翌日から停止ボタン
    #   /*
    #    ・サービスを翌日から停止
    #    ・サービスを翌日から再開
    #    →ステータスが「2.申込受付」「3.環境構築依頼」「4.環境構築完了」「5.利用中」の場合に押せる。
    #    ※契約が終わってたけど緊急で止めたい場合を想定。

    #   確認メッセージを表示「サービスの停止予定処理を実行しますか？」。
    #   「はい」を選んだ場合、「停止予定日」に明日の日付を入力。
    #   「ユーザー管理基盤_外部設計書_08_サービスの一時休止サイト.xlsx」の「02_サービスの一時休止設定画面」シートの処理を参照。
    #   */

    def ndes_service_stop_start(self, data):
        try:
            logger.debug('# ******************************')
            # m_contract
            MCON = GV.get_module('m_contract')
            m_con = MCON()

            if data['contract_id'] is not None:

                tomorrow_day = date.today() + timedelta(days=1)
                data['ndes_service_stop_start_date'] = tomorrow_day.isoformat()
                logger.debug(data['ndes_service_stop_start_date'])

                tmp_m_con = m_con._update(data)
                logger.debug(tmp_m_con)
            logger.debug('# ##############################')

            return {
                'ndes_service_stop_start_date': data['ndes_service_stop_start_date']
            }

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        pass

    # // サービスを翌日から再開ボタン
    # /*
    # ・サービスを翌日から停止
    # ・サービスを翌日から再開
    # →ステータスが「2.申込受付」「3.環境構築依頼」「4.環境構築完了」「5.利用中」の場合に押せる。
    # ※契約が終わってたけど緊急で止めたい場合を想定。

    # 「停止予定日」が空欄の場合は押下不可。
    # 「停止予定日」が入力済みかつ明日の場合、、確認メッセージを表示「サービスの停止予定をキャンセルしますか？」。
    # 「はい」を選んだ場合、「停止予定日」を空欄にする。
    # 「停止予定日」が入力済みかつ明日以外の場合、確認メッセージを表示「サービスの再開予定処理を実行しますか？」。
    # 「はい」を選んだ場合、「停止からの再開予定日」に明日の日付を入力。
    # 「ユーザー管理基盤_外部設計書_08_サービスの一時休止サイト.xlsx」の「02_サービスの一時休止設定画面」シートの処理を参照。
    # */
    def ndes_service_stop_restart(self, data):
        try:
            logger.debug('# ******************************')
            # m_contract
            # from ..model.m_contract import Sub as MCon
            # m_con = MCon()
            MCON = GV.get_module('m_contract')
            m_con = MCON()

            if data['contract_id'] is not None:

                tomorrow_day = date.today() + timedelta(days=1)

                if data['ndes_service_stop_start_date'] and \
                        data['ndes_service_stop_start_date'] == tomorrow_day.strftime('%Y/%m/%d'):
                    # // 「停止予定日」が入力済みかつ明日の場合、、確認メッセージを表示「サービスの停止予定をキャンセルしますか？」。

                    data['ndes_service_stop_start_date'] = None
                    logger.debug(data['ndes_service_stop_start_date'])

                    tmp_m_con = m_con._update(data)
                    logger.debug(tmp_m_con)

                elif data['ndes_service_stop_start_date'] and \
                        data['ndes_service_stop_start_date'] != tomorrow_day.strftime('%Y/%m/%d'):
                    # // 「停止予定日」が入力済みかつ明日以外の場合、確認メッセージを表示「サービスの再開予定処理を実行しますか？」。

                    data['ndes_service_stop_restart_date'] = tomorrow_day
                    logger.debug(data['ndes_service_stop_restart_date'])

                    tmp_m_con = m_con._update(data)
                    logger.debug(tmp_m_con)
            logger.debug('# ##############################')

            print(data['ndes_service_stop_start_date'])
            print(data['ndes_service_stop_restart_date'])

            # ndes_service_stop_start_date = data['ndes_service_stop_start_date'],
            # ndes_service_stop_restart_date  = data['ndes_service_stop_restart_date']
            # if ndes_service_stop_restart_date is not None:
            #     ndes_service_stop_restart_date = ndes_service_stop_restart_date.strftime('%Y/%m/%d')
            return {
                'ndes_service_stop_start_date': data['ndes_service_stop_start_date'],
                'ndes_service_stop_restart_date': data['ndes_service_stop_restart_date']
            }

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        pass

    # データの更新(GMO掛け払い)
    # GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う。
    # 企業情報管理アプリの「GMO掛け払いのデータ更新あり」にチェックが入っている(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerがTrue)の企業のみを対象にする。
    # 処理が正常終了した場合、RDSの「GMO掛け払いのデータ更新あり」をfalseにする。(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)
    # 処理結果を営業ML、サポートMLにメールで通知する。
    # 以下の情報が変更されている場合、GMO掛け払いで枠保証の再審査が発生する。同月中に2回目の審査をした、もしくは審査中(月跨ぎで)だった場合にエラーが出る。
    # ・会社名
    # ・代表者姓名
    # ・代表者の生年月日
    # ・契約者の郵便番号
    # ・契約者の住所
    # ・契約者の電話番号
    # ・契約者のメールアドレス"
    def need_gmo_ps_creditfacility_modifybuyer(self, data=None):

        logger.debug('# GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う')

        logger.debug(
            '# -----------------------------------------------------S')
        logger.debug('# need_gmo_ps_creditfacility_modifybuyer!!!')

        res = {}
        res['error_code'] = None
        res['error_message'] = None

        try:
            ok_company_code = {}
            ng_company_code = {}

            logger.debug('# GMO掛け払いの購入企業情報編集を定期実行処理で月に1度月末に行う')
            logger.debug(
                '# 実施開始日時：' + datetime.now().strftime('%Y-%m-%d %H:%M:%S'))
            logger.debug(
                '# -----------------------------------------------------S')

            logger.debug(
                '# 「GMO掛け払いのデータ更新あり」にチェックが入っている(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerがTrue)の企業のみ取得')

            logger.debug('# ******************************')
            logger.debug('# 企業情報取得')

            data_m_com = None

            MCOM = GV.get_module('m_company')
            m_com = MCOM()

            filters = []
            filters.append(
                m_com.model_class.need_gmo_ps_creditfacility_modifybuyer == True)
            filters = and_(*filters)

            tmp_m_com = m_com._get_item_by_filters(filters, get_all=True)

            if tmp_m_com is not None and len(tmp_m_com) > 0:

                data_m_com = []

                for t in tmp_m_com:
                    d = t.to_dict()
                    data_m_com.append(d)

                logger.debug(data_m_com)
            else:
                logger.debug('# 失敗 企業情報取得')
                logger.debug('# GMO掛け払いの購入企業情報編集を定期実行処理：エラー' + ' 企業情報取得')

            logger.debug('# ##############################')

            if data_m_com is not None:

                for d_m_c in data_m_com:

                    logger.debug('d_m_c')
                    logger.debug(d_m_c)

                    logger.debug('# ----------------------------------------')

                    company_code = d_m_c['company_code']

                    logger.debug('# 企業コード：' + d_m_c['company_code'])
                    logger.debug('# 企業名：' + d_m_c['company_name'])

                    ng_company_code[company_code] = ''

                    logger.debug('# ******************************')
                    logger.debug('# 契約情報取得')

                    data_m_con = None

                    MCON = GV.get_module('m_contract')
                    m_con = MCON()

                    filters = []
                    filters.append(
                        m_con.model_class.company_code == d_m_c['company_code'])
                    filters = and_(*filters)
                    
                    logger.debug('# 並び替え 契約ID 古い順')
                    col = getattr(m_con.model_class, 'contract_id', None)
                    order_by = asc(col)

                    tmp_m_con = m_con._get_item_by_filters(filters, order_by=order_by)

                    if tmp_m_con is not None:

                        data_m_con = tmp_m_con.to_dict()
                        # NULLを空文字列に置換する
                        super().replace_none_with_empty_string(data_m_con)

                        logger.debug(data_m_con)
                    else:
                        logger.debug('# 失敗 契約情報取得')
                        logger.debug(
                            '# GMO掛け払いの購入企業情報編集を定期実行処理：エラー' + ' 契約情報取得')

                        continue

                    logger.debug('# ##############################')
	                # 支払方法がGMO掛け払い以外の場合はスキップ
                    if data_m_con['payment_method'] != 'GMO掛け払い':
                        logger.debug('GMO掛け払い以外')
                        continue

                    if data_m_con is not None:

                        logger.debug('# ******************************')
                        logger.debug('# GMO掛け払い情報を取得する')
                        logger.debug('m_gmo_payment_service')

                        data_m_gps = None

                        MGPS = GV.get_module('m_gmo_payment_service')
                        m_gps = MGPS()

                        filters = []
                        filters.append(m_gps.model_class.company_code ==
                                       d_m_c['company_code'])
                        filters = and_(*filters)
                        tmp_m_gps = m_gps._get_item_by_filters(filters)

                        if tmp_m_gps is not None:
                            data_m_gps = tmp_m_gps.to_dict()
                        else:
                            logger.debug('# 失敗 GMO掛け払い情報取得')
                            logger.debug(
                                '# GMO掛け払いで枠保証の再審査：エラー' + ' GMO掛け払い情報取得')

                            continue

                        logger.debug('# ##############################')

                        if data_m_gps is not None:

                            logger.debug('# ******************************')
                            logger.debug('# GMO掛け払いで枠保証の再審査実施')
                            # 申請する
                            apply = 1
                            # 住所
                            address = data_m_con["contract_address_pref"] + \
                                data_m_con["contract_address_1"] + \
                                data_m_con["contract_address_2"] + \
                                data_m_con["contract_address_3"]
                            # 生年月日
                            company_leader_date_of_birth = d_m_c["company_leader_date_of_birth"]
                            company_leader_date_of_birth = datetime.strptime(
                                company_leader_date_of_birth[0:19], '%Y-%m-%dT%H:%M:%S')
                            company_leader_date_of_birth = company_leader_date_of_birth.strftime(
                                '%Y/%m/%d')

                            # 6708----------10/16----------S
                            item_system_id = None
                            item_contract_id = None
                            item_authenticationId = None
                            item_shopCode = None
                            item_connectPassword = None
                            if data_m_con['contract_id'] is not None:
                                item_contract_id = data_m_con['contract_id']

                                data_v_con = None

                                logger.debug('# ******************************')
                                VCON = GV.get_module('view_contract')
                                v_con = VCON()

                                filters = []
                                filters.append(v_con.model_class.contract_id == item_contract_id)
                                filters = and_(*filters)

                                tmp_v_con = v_con._get_item_by_filters(filters)

                                if tmp_v_con is not None:
                                    data_v_con = tmp_v_con.to_dict()
                                    item_system_id = data_v_con['system_id']
                                    item_authenticationId = data_v_con['gmo_payment_frame_guarantee_id']
                                    item_shopCode = data_v_con['gmo_payment_frame_guarantee_shopcode']
                                    item_connectPassword = data_v_con['gmo_payment_frame_guarantee_password']
                            # 6708----------10/16----------E

                            params_rpcm = {
                                'targetBuyer': {
                                    'shopCustomerId': d_m_c["company_code"]
                                },
                                'buyer': {
                                    'buyerNameFamily': data_m_con["contract_last_name"],
                                    'buyerName': data_m_con["contract_first_name"],
                                    'buyerNameFamilyKana': data_m_con["contract_last_name_kana"],
                                    'buyerNameKana': data_m_con["contract_first_name_kana"],
                                    'zipCode': data_m_con["contract_zipcode"],
                                    'address': address,
                                    'companyName': d_m_c["company_name"],
                                    'departmentName': data_m_con["contract_department"],
                                    'tel1': data_m_con["contract_tel_1"],
                                    'email1': data_m_con["contract_email"],
                                    'presidentNameFamily': d_m_c["company_leader_last"],
                                    'presidentName': d_m_c["company_leader_first"],
                                    'presidentNameFamilyKana': d_m_c["company_leader_kana_last"],
                                    'presidentNameKana': d_m_c["company_leader_kana_first"],
                                    'birthday': company_leader_date_of_birth,
                                    'shopCustomerId': d_m_c["company_code"]
                                },
                                'creditFacility': {
                                    'apply': apply,
                                    'reqUpperLimit': data_m_gps["creditfacility_application"]
                                },
                                # 6708----------10/16----------S
                                'relatedData': {
                                    #   // 'system_id': 'SYS00001',
                                    'system_id': item_system_id,
                                    #   // 'authenticationId': '0000000000',
                                    'authenticationId': item_authenticationId,
                                    #   // 'shopCode': 's00001486',
                                    'shopCode': item_shopCode,
                                    #   // 'connectPassword': '00001486',
                                    'connectPassword': item_connectPassword,
                                },
                                # 6708----------10/16----------E
                            }

                            logger.debug('params_rpcm')
                            logger.debug(params_rpcm)

                            res_rpcm = self.register_payment_creditfacility_modifybuyer(
                                params_rpcm)

                            logger.debug('res_rpcm')
                            logger.debug(res_rpcm)

                            # [DEBUG]	2023-08-09T08:12:37.331Z	221ca74e-d928-402e-aed1-1e186a943957
                            # {
                            #   'statusCode': 400,
                            #   'headers': {
                            #      'Access-Control-Allow-Headers': 'Content-Type',
                            #      'Access-Control-Allow-Origin': '*',
                            #      'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
                            #   },
                            #   'body': '{\n  "result": "NG",\n  "errors": [\n    {\n      "errCode": "BCT0033",\n      "errorMessage": "購入企業IDが重複しています。"\n    }\n  ]\n}'}

                            if 'statusCode' in res_rpcm and \
                                    (res_rpcm['statusCode'] == 400 or res_rpcm['statusCode'] == 500 or res_rpcm['statusCode'] == 503):

                                if 'body' in res_rpcm:

                                    tmp_error = json.loads(res_rpcm['body'])

                                    logger.debug('tmp_error')
                                    logger.debug(tmp_error)

                                    error_message = ''

                                    if 'errors' in tmp_error:
                                        for e in tmp_error['errors']:
                                            error_message += '【GMO枠保証申請】' + '<br/>'
                                            error_message += '<br/>'
                                            if 'errCode' in e and e['errCode'] is not None:
                                                error_message += e['errCode'] + '<br/>'
                                            if 'errorMessage' in e and e['errorMessage'] is not None:
                                                error_message += e['errorMessage'] + '<br/>'

                                    ng_company_code[company_code] = error_message

                                    logger.debug('# 失敗 GMO掛け払いで枠保証の再審査実施')
                                    logger.debug('# GMO掛け払いで枠保証の再審査：失敗' + '\n')

                                    continue

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')
                            logger.debug(
                                '# 「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)')

                            d_m_c['need_gmo_ps_creditfacility_modifybuyer'] = False

                            tmp_m_com_update = m_com._update(d_m_c)

                            if tmp_m_com_update is None:

                                ng_company_code[
                                    company_code] = '失敗 RDS「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)'
                                logger.debug(
                                    '# 失敗 RDS「GMO掛け払いのデータ更新あり」にチェックを外す(user_infrastructure.m_company.need_gmo_ps_creditfacility_modifybuyerをFalseにする)')
                                logger.debug(
                                    '# GMO掛け払いで枠保証の再審査：エラー' + ' RDS「GMO掛け払いのデータ更新あり」にチェックを外す')

                                continue

                            logger.debug('# ##############################')

                            if ng_company_code[company_code] == '':
                                del ng_company_code[company_code]

                            ok_company_code[company_code] = 'GMO掛け払いで枠保証の再審査：成功'

                            logger.debug('# GMO掛け払いで枠保証の再審査：成功' + '\n')

            logger.debug(
                '# -----------------------------------------------------E')
            logger.debug(
                '# 実施終了日時：' + datetime.now().strftime('%Y-%m-%d %H:%M:%S'))

            # 結果
            if data_m_com is None:
                logger.debug('# 処理対象データがありません。')

            logger.debug('# 正常終了した企業：')

            mail_parameter_ok_company_code = ''

            for k, v in ok_company_code.items():
                logger.debug(k)
                mail_parameter_ok_company_code += k + '\n'

            logger.debug('mail_parameter_ok_company_code')
            logger.debug(mail_parameter_ok_company_code)

            logger.debug('# 処理中にエラーが出た企業：')

            mail_parameter_ng_company_code = ''

            for k, v in ng_company_code.items():
                logger.debug(k + ':' + '\n' + v)
                mail_parameter_ng_company_code += k + ':' + '\n' + v + '\n'

            logger.debug('mail_parameter_ng_company_code')
            logger.debug(mail_parameter_ng_company_code)

            data_email = {}
            data_email['service_id'] = 'SRV00001'
            data_email['mail_type'] = '定期実行(月末)'
            data_email['ok_company_code'] = mail_parameter_ok_company_code
            data_email['ng_company_code'] = mail_parameter_ng_company_code
            self.send_email_contract(data_email)

            # return {
            #     'statusCode': 200,
            #     'headers': RESPONSE_HEADERS,
            #     # 'body': json.dumps(res, default=str)
            #     'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
            # }
            return {}

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# need_gmo_ps_creditfacility_modifybuyer!!!')
            logger.debug(
                '# -----------------------------------------------------E')

    # 定期実行
    # GMO掛け払い　枠保証状況取得
    def gmo_credit_facility(self, data=None):
        logger.debug('# ******************************')
        logger.debug('# 定期実行')
        logger.debug('# GMO掛け払い　枠保証状況取得')
        logger.debug('# gmo_credit_facility')

        res = {}

        try:

            logger.debug('# ******************************')
            logger.debug('# view_contract')

            data_v_con = None

            VCON = GV.get_module('view_contract')
            v_con = VCON()

            list_status = ['審査中', 'OK', '保留']

            filters = []
            filters.append(
                v_con.model_class.examination_status.in_(list_status))
            filters = and_(*filters)
            tmp_v_con = v_con._get_item_by_filters(filters, get_all=True)

            if tmp_v_con is not None and len(tmp_v_con) > 0:

                data_v_con = []

                for t in tmp_v_con:
                    d = t.to_dict()
                    data_v_con.append(d)

            logger.debug('# ##############################')

            if data_v_con is not None:

                logger.debug('data_v_con')
                logger.debug(data_v_con)

                for d in data_v_con:

                    buyer_info = self.get_gmo_credit_facility_info(d)
                    logger.debug(buyer_info)

                    record = None
                    if buyer_info is not None:
                        if 'result' in buyer_info and buyer_info['result'] == 'OK':
                            record = {}
                            # 審査情報
                            if 'examination' in buyer_info:
                                if 'status' in buyer_info['examination']:
                                    # 枠保証審査ステータス
                                    record['examination_status'] = buyer_info['examination']['status']
                                if 'resultReasons' in buyer_info['examination']:
                                    if isinstance(buyer_info['examination']['resultReasons'], list):
                                        tmp = ''
                                        for rr in buyer_info['examination']['resultReasons']:
                                            tmp = tmp + rr + '\n'
                                        # 枠保証審査結果事由情報
                                        record['examination_resultreasons'] = tmp
                            # 枠保証情報
                            if 'creditFacility' in buyer_info:
                                if 'upperLimit' in buyer_info['creditFacility']:
                                    # 枠保証上限額
                                    record['creditfacility_upperlimit'] = buyer_info['creditFacility']['upperLimit']
                                if 'balance' in buyer_info['creditFacility']:
                                    # 枠保証残高
                                    record['creditfacility_balance'] = buyer_info['creditFacility']['balance']
                                if 'startDate' in buyer_info['creditFacility']:
                                    # 枠保証利用開始日
                                    record['creditfacility_startdate'] = buyer_info['creditFacility']['startDate']
                                if 'endDate' in buyer_info['creditFacility']:
                                    # 枠保証利用終了日
                                    record['creditfacility_enddate'] = buyer_info['creditFacility']['endDate']

                            if record is not None and len(record) > 0:

                                logger.debug(
                                    '# ******************************')
                                logger.debug('# GMO掛け払い情報を更新する')
                                logger.debug('m_gmo_payment_service')

                                MGPS = GV.get_module('m_gmo_payment_service')
                                m_gps = MGPS()

                                filters = []
                                filters.append(
                                    m_gps.model_class.company_code == d['company_code'])
                                filters = and_(*filters)
                                tmp_m_gps = m_gps._get_item_by_filters(filters)

                                if tmp_m_gps is not None:

                                    data_m_gps = tmp_m_gps.to_dict()
                                    if 'examination_status' in record:
                                        data_m_gps['examination_status'] = record['examination_status']
                                    if 'creditfacility_upperlimit' in record:
                                        data_m_gps['creditfacility_upperlimit'] = record['creditfacility_upperlimit']
                                    if 'creditfacility_balance' in record:
                                        data_m_gps['creditfacility_balance'] = record['creditfacility_balance']
                                    if 'creditfacility_startdate' in record:
                                        data_m_gps['creditfacility_startdate'] = record['creditfacility_startdate']
                                    if 'creditfacility_enddate' in record:
                                        data_m_gps['creditfacility_enddate'] = record['creditfacility_enddate']
                                    if 'examination_resultreasons' in record:
                                        data_m_gps['examination_resultreasons'] = record['examination_resultreasons']

                                    tmp_m_gps_update = m_gps._update(
                                        data_m_gps)

                                    if tmp_m_gps_update is None:
                                        logger.debug(
                                            '# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                        logger.debug('# GMO掛け払い情報を更新失敗')
                                        logger.debug(data_m_gps)
                                        raise CustomException('SYS_ERR_100')

                                logger.debug(
                                    '# ##############################')

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

        return res

    def get_gmo_credit_facility_info(self, data=None):
        logger.debug('# ******************************')
        logger.debug('get_gmo_credit_facility_info!!!')

        logger.debug(data)

        res = {}

        try:

            logger.debug('# ******************************')

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/payment/creditfacility_getbuyercreditfacility',
                'body': json.dumps(
                    {
                        'targetBuyer': {
                            'shopCustomerId': data['company_code']
                        },
                        # 6708----------10/16----------S
                        'relatedData': {
                            #   // 'system_id': 'SYS00001',
                            'system_id': data['system_id'],
                            #   // 'authenticationId': '0000000000',
                            'authenticationId': data['gmo_payment_frame_guarantee_id'],
                            #   // 'shopCode': 's00001486',
                            'shopCode': data['gmo_payment_frame_guarantee_shopcode'],
                            #   // 'connectPassword': '00001486',
                            'connectPassword': data['gmo_payment_frame_guarantee_password'],
                        },
                        # 6708----------10/16----------E
                    }
                )
            }

            Payload = json.dumps(input_event)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            buyer_info = None

            if GV.DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_PAYMENT,
                    InvocationType='RequestResponse',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)

                if 'StatusCode' in response and response['StatusCode'] == 200:

                    # レスポンス読出し
                    Payload = json.loads(response['Payload'].read())
                    logger.debug("---03: body:")
                    logger.debug(Payload)
                    if 'body' in Payload:
                        buyer_info = json.loads(Payload['body'])
                        logger.debug(buyer_info)

            return buyer_info

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    def test1(self, data=None):
        return {}
        pass

    def test2(self, data=None):
        return {}
        pass