from .controller import Base, CustomException, GV, logging, and_, datetime, json, boto3, date, timedelta, asc
from Crypto.Cipher import AES
from Crypto.Random import get_random_bytes
from Crypto.Util import Padding
from hashlib import pbkdf2_hmac

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'cloud_strage'

    def get_all(self, event, context):

        # from ..view.view_cloud_strage import Sub as VCS
        # v_cs = VCS()
        VCS = GV.get_module('view_cloud_strage')
        v_cs = VCS()

        return v_cs.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_cloud_strage import Sub as VCS
        # v_cs = VCS()
        VCS = GV.get_module('view_cloud_strage')
        v_cs = VCS()

        v_cs.table_config = self.table_name
        return v_cs.get_table_schema()

        pass

        # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_cloud_strage import Sub as MCS
        # m_cs = MCS()
        MCS = GV.get_module('m_cloud_strage')
        m_cs = MCS()

        tmp_m_cs = m_cs._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_cloud_strage import Sub as MCS
        # m_cs = MCS()
        MCS = GV.get_module('m_cloud_strage')
        m_cs = MCS()

        tmp_m_cs = m_cs._delete(data)

        return {}
    
    # 「クラウドストレージの登録完了」メール送信
    def cloud_strage_email(self, data):
        logger.debug('# ******************************')
        logger.debug('「クラウドストレージの登録完了」メール送信')
        logger.debug('cloud_strage_email')
        logger.debug(data)

        try:
            logger.debug('# ******************************')
            logger.debug('# メール送信')

            VCON = GV.get_module('view_contract')
            v_con = VCON()

            filters = []
            filters.append(
                v_con.model_class.contract_id == data['contract_id'])
            filters = and_(*filters)

            tmp_v_con_get = v_con._get_item_by_filters(filters)

            if tmp_v_con_get is not None:
                data_v_con_get = tmp_v_con_get.to_dict()
        
            data_email = {}
            data_email['mail_type'] = 'クラウドストレージ登録完了通知'
                
            data_email['system_id'] = GV.SYSTEM_ID
            data_email['service_id'] = data['service_id']
            data_email['system_name'] = GV.SYSTEM_NAME
            data_email['service_name'] = data['service_name']
            data_email['company_name'] = data['company_name']
            data_email['administrator_name_last'] = data_v_con_get['name_last']
            data_email['administrator_name_first'] = data_v_con_get['name_first']
            data_email['email_address'] = data_v_con_get['email']
            if data['enable_flg']:
                strEnable_flg = '有効化する'
            else:
                strEnable_flg = '有効化しない'
            data_email['enable_flg'] = strEnable_flg
            data_email['cloud_strage_type'] = data['cloud_strage_type']
            if data['user_name'] is None:
                strUser_name = ''
            else:
                strUser_name = data['user_name']
            data_email['user_name'] = strUser_name
            if data['cloud_strage_domain'] is None:
                data_email['cloud_strage_domain'] = ''
            else:
                data_email['cloud_strage_domain'] = data['cloud_strage_domain']
            if data['folder_id'] is None:
                data_email['folder_id'] = ''
            else:
                data_email['folder_id'] = data['folder_id']
            self.send_email_contract(data_email)

            logger.debug('# ##############################')

            pass

            return {}

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    
    # 登録エラーメール送信
    def send_error_email(self, data):
        logger.debug('# ******************************')
        logger.debug('登録エラーメール送信')
        logger.debug('send_error_email')
        logger.debug(data)

        try:
            logger.debug('# ******************************')
            logger.debug('# メール送信')

            VCON = GV.get_module('view_contract')
            v_con = VCON()

            filters = []
            filters.append(
                v_con.model_class.contract_id == data['contract_id'])
            filters = and_(*filters)

            tmp_v_con_get = v_con._get_item_by_filters(filters)

            if tmp_v_con_get is not None:
                data_v_con_get = tmp_v_con_get.to_dict()

            data_email = {}
            data_email['mail_type'] = 'クラウドストレージ登録エラー通知'

            data_email['system_id'] = GV.SYSTEM_ID
            data_email['service_id'] = data['service_id']
            data_email['system_name'] = GV.SYSTEM_NAME
            data_email['service_name'] = data['service_name']
            data_email['company_name'] = data['company_name']
            data_email['administrator_name_last'] = data_v_con_get['name_last']
            data_email['administrator_name_first'] = data_v_con_get['name_first']
            data_email['email_address'] = data_v_con_get['email']
            if data['enable_flg']:
                strEnable_flg = '有効化する'
            else:
                strEnable_flg = '有効化しない'
            data_email['enable_flg'] = strEnable_flg
            data_email['cloud_strage_type'] = data['cloud_strage_type']
            if data['user_name'] is None:
                strUser_name = ''
            else:
                strUser_name = data['user_name']
            data_email['user_name'] = strUser_name
            if data['cloud_strage_domain'] is None:
                data_email['cloud_strage_domain'] = ''
            else:
                data_email['cloud_strage_domain'] = data['cloud_strage_domain']
            if data['folder_id'] is None:
                data_email['folder_id'] = ''
            else:
                data_email['folder_id'] = data['folder_id']
            self.send_email_contract(data_email)

            logger.debug('# ##############################')

            pass

            return {}
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')    

    # パスワード表示
    def display_password(self, data):
        logger.debug('# ******************************')
        logger.debug('パスワード表示')
        logger.debug('display_password')
        logger.debug(data)

        try:
            logger.debug('# ******************************')
            logger.debug('# パスワード複合化')

            # バグ #5338 パスフレーズがプログラムに直接記載されている 2024/02/29 L S
            passPhrase = ''
            # if 'pass_phrase' in data and data['pass_phrase']:  
            #     passPhrase = data['pass_phrase']
            # else:
            #     logger.debug('# パスフレーズ未入力')
            #     error_message = 'パスフレーズを入力してください。'
            #     error = {
            #         'code': 400,
            #         'message': error_message
            #     }
            passPhrase = GV.CONFIG_PASSPHRASE['PASSPHRASE']
            # バグ #5338 パスフレーズがプログラムに直接記載されている 2024/02/29 L E

            #     return GV.handle_error('ERROR', None, error)
            
            MCS = GV.get_module('m_cloud_strage')
            m_cs = MCS()

            filters = []
            filters.append(m_cs.model_class.cloud_strage_id == data['cloud_strage_id'])
            filters = and_(*filters)

            tmp_m_cs = m_cs._get_item_by_filters(filters, get_all=True)

            logger.debug(tmp_m_cs)
            if tmp_m_cs is not None and len(tmp_m_cs) > 0:
                try:
                    for t_m_cs in tmp_m_cs:
                        data_v_cs = t_m_cs.to_dict()
                        encryptedData = {}
                        encryptedData['salt'] = data_v_cs['salt']
                        encryptedData['iv'] = data_v_cs['iv']
                        encryptedData['encrypted'] = data_v_cs['password']
                        password = self.decrypt(encryptedData, passPhrase)
                        #print('password: ' + password)
                except Exception as e:
                    logger.debug('# パスワード復号化エラー')
                    error_message = 'パスワードの復号化に失敗しました。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)
            
            msg = ''
            msg += 'この情報を使用してストレージサービスの連携を実施してください。' + '</br></br>'
            msg += 'ユーザ名： ' + data['user_name'] + '</br>'
            msg += 'パスワード： ' + password
            
            logger.debug('# ******************************')
            res = {
                'message': msg
            }

            return res

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')      

    # 復号
    def decrypt(self, encryptedData, passPhrase):

        # AESキーの生成(128bit、5万回)
        key = pbkdf2_hmac('sha256', bytes(passPhrase, encoding='utf-8'), encryptedData['salt'], 50000, int(128 / 8))

        # print('複合化key:' + key)

        # 復号
        aes = AES.new(key, AES.MODE_CBC, encryptedData['iv'])
        plaintext = Padding.unpad(aes.decrypt(encryptedData['encrypted']), AES.block_size, 'pkcs7')

        return plaintext.decode(encoding='utf-8')

    # rclone.confのダウンロード
    def download_rclone_conf(self, data):
        logger.debug('# ******************************')
        logger.debug('rclone.confダウンロード')
        logger.debug('download_rclone_conf')
        logger.debug(data)

        try:
            logger.debug('# ******************************')
            logger.debug('# ダウンロードURL発行')

            s3 = boto3.resource('s3')
            BUCKET_NAME = GV.ENV.lower() + GV.S3_BUCKET_NAME
            #BUCKET_NAME = 'dev-s3-bt-comn-pf-001'
            s3_client = boto3.client('s3')
            s3_rclone_conf_path = 'user-infrastructure/cloud_strage/{}/rclone.conf'.format(data['contract_id'])

            print('++++++++++++')
            url = s3_client.generate_presigned_url('get_object',
            Params={'Bucket': BUCKET_NAME, 'Key': s3_rclone_conf_path},
            ExpiresIn=300)

            print(url)
            print('++++++++++++')

            logger.debug('# ******************************')

            res = {
                'result' : 'OK',
                'url': url
            }
            
            return res

        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')  

    def send_email_contract(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_contract')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if 'email_address' in data:
                mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id'])
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}

            # ???
            result = self.send_email(mail_template, mail_parameter)

            return result

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')