from .controller import Base, CustomException, GV, os, logging, json, datetime, timedelta, and_, desc
from pprint import pprint

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)


class Sub(Base):

    table_name = 'account'

    # 取得する
    def get_all(self, event, context):
        pass

    def add(self, event, context):
        '''
        作成する
        '''

        logger.debug('# ******************************')
        logger.debug('# account add')

        if GV.EVENT_BODY is None:
            # メッセージ用検討 ???
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        logger.debug(data)
        
        logger.debug('# ************0717******************') 
        params = {
            'table_name': 'm_auth0_management',
            'filters': {
                'tenant': data['tenant']
            }
        }
        data_m_am = self.get_data(params)
        logger.debug(data_m_am)

        if data_m_am:
            logger.debug('# ************Auth0情報を設定する******************')
            GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
            GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
            GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
            GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
            GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
            GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
            logger.debug(GV.CONFIG)
            pass
        else:
            return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0717******************') 
        
        # ??? 
        # self.check_permissions(data)

        logger.debug('# ******************************')
        logger.debug('# パラメータチェック')

        # メールアドレスは必須項目
        if 'email_address' not in data:
            raise CustomException('ACCOUNT_ERR_001')
        # 苗字(姓)は必須項目
        if 'last_name' not in data:
            raise CustomException('ACCOUNT_ERR_002')
        # 名前(名)は必須項目
        if 'first_name' not in data:
            raise CustomException('ACCOUNT_ERR_003')
        # 企業コードは必須項目
        if 'company_code' not in data:
            raise CustomException('ACCOUNT_ERR_COMPANY_CODE')
        # ロールは必須項目
        if 'roles' not in data:
            raise CustomException('ACCOUNT_ERR_ROLES')

        logger.debug('# ##############################')

        try:

            logger.debug('# ******************************')

            logger.debug('# 「mscone_lic.m_directory_user」にすでに登録済みかどうか確認する')

            params_mdu = {
                'table_name': 'm_directory_user',
                'filters': {
                    'company_code': data['company_code'],
                    'user_email': data['email_address']
                }
            }
            data_m_du = self.get_data(params_mdu)

            if data_m_du is not None:
                logger.debug('# 「mscone_lic.m_directory_user」にすでに登録済')
                # raise CustomException('SYS_ERR_100')
                pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if data_m_du is None:

                logger.debug('# 「mscone_lic.m_directory_user」に空きがあるかどうか確認する')
                logger.debug(data['roles'])

                if GV.ROLES_GENERAL_USER in data['roles']:
                    params_mdu = {
                        'table_name': 'm_directory_user',
                        'filters': {
                            'company_code': data['company_code'],
                            'user_email': 'NONE',
                            'directory_username': {
                                'expression': 'NOT CONTAINS',
                                'value': 'user000'
                            }
                        },
                        'order_by': {
                            'directory_username': 'asc'
                        }
                    }
                    logger.debug(params_mdu)
                elif GV.ROLES_ADMIN_USER in data['roles']:
                    params_mdu = {
                        'table_name': 'm_directory_user',
                        'filters': {
                            'company_code': data['company_code'],
                            'user_email': 'NONE',
                            'directory_username': {
                                'expression': 'CONTAINS',
                                'value': 'user000'
                            }
                        },
                        'order_by': {
                            'directory_username': 'asc'
                        }
                    }
                    logger.debug(params_mdu)

                data_m_du = self.get_data(params_mdu)

                if data_m_du is None:
                    logger.debug('# 「mscone_lic.m_directory_user」に空きが無い')
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「mscone_lic.m_directory_user」に空きがありません。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)
                    pass

            logger.debug('# ##############################')

            if data_m_du is not None:
                if data_m_du['directory_username'] is None:
                    logger.debug(
                        '# 「mscone_lic.m_directory_user」の「directory_username」がNULLです。')
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「mscone_lic.m_directory_user」の「directory_username」がNULLです。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)

            logger.debug('# ******************************')

            logger.debug('# 「mscone_lic.m_directory_user」にデータ登録する')

            if data_m_du is not None:

                # from ..model.m_directory_user import Sub as MDU
                # m_du = MDU()
                MDU = GV.get_module('m_directory_user')
                m_du = MDU()

                data_m_du['user_email'] = data['email_address']

                tmp_m_du = m_du._update(data_m_du)

                if tmp_m_du is None:
                    logger.debug('# 「mscone_lic.m_directory_user」にデータ登録失敗')
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「mscone_lic.m_directory_user」にデータ登録失敗しました。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# Auth0アカウントがすでに存在するかどうか確認する')

            '''
            社内ネットワークからは下記のエラーになります。
            
            HTTPSConnectionPool(host='mscone-ndes-dx.jp.auth0.com', port=443): 
            Max retries exceeded with url: /oauth/token (
                Caused by ProxyError(
                    'Your proxy appears to only use HTTP and not HTTPS, try changing your proxy URL to be HTTP. 
                    See: https://urllib3.readthedocs.io/en/1.26.x/advanced-usage.html#https-proxy-error-http-proxy', 
                    SSLError(SSLError(1, '[SSL: WRONG_VERSION_NUMBER] wrong version number (_ssl.c:1129)'))
                )
            )
            '''

            # from ..auth0 import Sub as auth0_class
            # auth0 = auth0_class()
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()
            users_auth0 = a0._get_users_by_email(data['email_address'])

            data_auth0 = None

            if users_auth0 and len(users_auth0) > 0:
                # 存在する場合
                logger.debug('存在する場合')
                # raise CustomException('ACCOUNT_ERR_ACCOUNT_EXIST')

                data_auth0 = users_auth0[0]

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if data_auth0 is None:

                logger.debug('# Auth0アカウントを作成する')
                logger.debug('# create_data_atuh0')

                param_auth0 = {}
                param_auth0['email_address'] = data['email_address']

                logger.debug('# param_auth0')
                logger.debug(param_auth0)

                data_auth0 = self.create_data_atuh0(param_auth0)

            logger.debug('# ##############################')

            if GV.SERVICE_PATH is not None:

                logger.debug('# サービスパスが存在する場合')
                logger.debug('# アプリ側からの呼び出し')

                logger.debug(GV.SYSTEM_ID)
                logger.debug(GV.SERVICE_ID)

                logger.debug('# ******************************3')

                logger.debug('# 「環境ストックマスタ」からデータ取得')
                logger.debug('# m_env_stock')

                params = {
                    'table_name': 'm_env_stock',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'company_code': data['company_code']
                    }
                }
                data_m_es = self.get_data(params)

                if data_m_es is None:
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「環境ストックマスタ(user_infrastructure.m_env_stock)」にデータが登録されていません。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)
                    pass

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# 「activedirectory_username」にセットするドメインを取得するため')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }

                data_m_sys = self.get_data(params)

                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「システムマスタ」からデータ取得に失敗しました。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)
                    pass

                logger.debug('# データ取得OKの場合')
                logger.debug(data_m_sys)

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録')
                logger.debug('# m_auth_user_info')

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                # ワークショップユーザーメタデータサンプル
                # "company_code":"K00001",
                # "system_id":"SYS00001",
                # "service_id":"SRV00001",
                # "activedirectory_username":"ENV00001.user001@simulation.space",
                # "appstream_stackname":"SYS00001-SRV00001-appstream-stack-activedirectory-ENV00001",
                # "roles":[
                #     "workshop_user"
                # ]

                data_m_aui = {}

                # # Auth0ユーザー情報管理ID
                # data_m_aui['auth_user_info_id'] = ''
                logger.debug('# **************0702****S************')
                # テナント
                data_m_aui['tenant'] = data['tenant']
                logger.debug('# **************0702****E************')

                # Auth0ユーザーID
                data_m_aui['auth0_user_id'] = data_auth0['user_id']
                # ログイン先企業コード
                data_m_aui['company_code'] = data['company_code']
                # ログイン先システムID
                data_m_aui['system_id'] = GV.SYSTEM_ID
                # ログイン先サービスID
                data_m_aui['service_id'] = GV.SERVICE_ID

                # activedirectory_username
                # ENV00001.user001@simulation.space
                tmp_adun = data_m_es['env_id']
                # tmp_adun += '.' + 'user001'
                tmp_adun += '.' + data_m_du['directory_username'].split('.')[1]
                tmp_adun += '@' + data_m_sys['ad_domain_name']
                data_m_aui['activedirectory_username'] = tmp_adun

                # appstream_stackname
                # SYS00001-SRV00001-appstream-stack-activedirectory-ENV00001
                tmp_assn = GV.SYSTEM_ID + '-'
                tmp_assn += GV.SERVICE_ID + '-'
                tmp_assn += 'appstream-stack-activedirectory' + '-'
                tmp_assn += data_m_es['env_id']
                data_m_aui['appstream_stackname'] = tmp_assn

                # 付与ロールのリスト
                data_m_aui['roles'] = data['roles']

                # # 作成日時
                # data_m_aui['cdate'] = ''
                # # 更新日時
                # data_m_aui['udate'] = ''

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': data_auth0['user_id'],
                        'company_code': data['company_code'],
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID
                    }
                }
                data_m_aui1 = self.get_data(params)
                logger.debug(data_m_aui1)

                tmp_m_aui_1 = None

                if data_m_aui1:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                    data_m_aui['auth_user_info_id'] = data_m_aui1['auth_user_info_id']
                    tmp_m_aui_1 = m_aui._update(data_m_aui)
                    pass
                else:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                    tmp_m_aui_1 = m_aui._add(data_m_aui)
                    pass

                if tmp_m_aui_1 is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録NGの場合')
                    # raise CustomException('SYS_ERR_100')
                    error_message = '「Auth0ユーザー情報管理(user_infrastructure.m_auth_user_info)」へのデータ登録が失敗しました。'
                    error = {
                        'code': 400,
                        'message': error_message
                    }

                    return GV.handle_error('ERROR', None, error)

                logger.debug('# データ登録OKの場合')

                logger.debug('# ##############################')

            # logger.debug('# ******************************')
            # logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
            # logger.debug('# m_user')

            # params = {
            #     'table_name': 'm_user',
            #     'filters': {
            #         'auth0_user_id': data_auth0['user_id'],
            #         'company_code': data_m_es['company_code']
            #     }
            # }
            # data_m_u = self.get_data(params)

            # if data_m_u:
            #     logger.debug('# 存在する場合、どうする？')
            #     logger.debug('# ???')
            #     pass
            # else:
            #     logger.debug('# 存在しない場合、データを登録')

            #     # from ..model.m_user import Sub as MU
            #     # m_u = MU()
            #     MU = GV.get_module('m_user')
            #     m_u = MU()

            #     data_m_u_add = {}
            #     # # ユーザーマスタID
            #     # data_m_u_add['user_master_id'] = ''
            #     # Auth0ユーザーID
            #     data_m_u_add['auth0_user_id'] = data_auth0['user_id']
            #     # 企業コード
            #     data_m_u_add['company_code'] = data_m_es['company_code']
            #     # 名前
            #     data_m_u_add['name_last'] = data['last_name']
            #     # 名前(姓)
            #     data_m_u_add['name_first'] = data['first_name']
            #     # 名前(名)
            #     data_m_u_add['name_last_kana'] = ''
            #     # 名前(カナ)(姓)
            #     data_m_u_add['name_first_kana'] = ''
            #     # 部署名(カナ)(名)
            #     data_m_u_add['department'] = ''
            #     # 役職
            #     data_m_u_add['position'] = ''
            #     # メールアドレス
            #     data_m_u_add['email'] = data['email_address']
            #     # # 電話番号
            #     # data_m_u_add['tel'] = ''
            #     # # 招待コード
            #     # data_m_u_add['invitation_code'] = ''
            #     # # 招待日時
            #     # data_m_u_add['invitation_date'] = ''
            #     # # 登録日時
            #     # data_m_u_add['cdate'] = ''
            #     # # 更新日時
            #     # data_m_u_add['udate'] = ''

            #     logger.debug('# データ登録')
            #     tmp_m_u = m_u._add(data_m_u_add)

            #     if tmp_m_u:
            #         logger.debug(tmp_m_u.to_dict())
            #         pass
            #     else:
            #         # raise CustomException('SYS_ERR_100')
            #         error_message = '「ユーザーマスタ(user_infrastructure.m_user)」にデータ登録失敗しました。'
            #         error = {
            #             'code': 400,
            #             'message': error_message
            #         }

            #         return GV.handle_error('ERROR', None, error)
            #         pass

            # logger.debug('# ##############################')

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
        finally:
            pass
            print('---------------------------------')

        return {}
        pass

    # 更新する
    def update(self, event, context):
        '''
        更新する
        '''

        logger.debug('# ******************************')
        logger.debug('# update update')

        if GV.EVENT_BODY is None:
            # メッセージ用検討 ???
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        logger.debug(data)
        
        logger.debug('# ************0717******************') 
        params = {
            'table_name': 'm_auth0_management',
            'filters': {
                'tenant': data['tenant']
            }
        }
        data_m_am = self.get_data(params)
        logger.debug(data_m_am)

        if data_m_am:
            logger.debug('# ************Auth0情報を設定する******************')
            GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
            GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
            GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
            GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
            GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
            GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
            logger.debug(GV.CONFIG)
            pass
        else:
            return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0717******************') 

        # ???
        # self.check_permissions(data)

        logger.debug('# ******************************')
        logger.debug('# パラメータチェック')

        # メールアドレスは必須項目
        if 'email_address' not in data:
            raise CustomException('ACCOUNT_ERR_001')
        # 企業コードは必須項目
        if 'company_code' not in data:
            error_message = '企業コード(company_code)は必須項目です。'
            error = {
                'code': 400,
                'message': error_message
            }
            return GV.handle_error('ERROR', None, error)
        # blockedは必須項目
        if 'blocked' not in data:
            error_message = 'blockedは必須項目です。'
            error = {
                'code': 400,
                'message': error_message
            }
            return GV.handle_error('ERROR', None, error)

        logger.debug('# ##############################')

        try:

            logger.debug('# ******************************')
            logger.debug('# Auth0アカウントがすでに存在するかどうか確認する')

            # from ..auth0 import Sub as auth0_class
            # auth0 = auth0_class()
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            auth0_users = a0._get_users_by_email(data['email_address'])

            if auth0_users is None or len(auth0_users) < 1:
                # 存在しない場合
                logger.debug('存在しない場合')
                raise CustomException('ACCOUNT_ERR_ACCOUNT_NOT_EXIST')

            logger.debug('存在する場合')

            data_auth0 = auth0_users[0]

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # logger.debug('# Auth0アカウントの情報を更新する')

            # param_auth0 = {
            #     'blocked': data['blocked']
            # }
            # logger.debug('# param_auth0')
            # logger.debug(param_auth0)

            # tmp_auth0 = a0._update(data_auth0['user_id'], param_auth0)

            # logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ更新')
            logger.debug('# m_auth_user_info')

            # from ..model.m_auth0_user_info import Sub as MAUI
            # m_aui = MAUI()
            MAUI = GV.get_module('m_auth0_user_info')
            m_aui = MAUI()

            params_m_aui = {}

            # Auth0ユーザーID
            params_m_aui['auth0_user_id'] = data_auth0['user_id']
            # ログイン先企業コード
            params_m_aui['company_code'] = data['company_code']
            # ログイン先システムID
            params_m_aui['system_id'] = GV.SYSTEM_ID
            # ログイン先サービスID
            params_m_aui['service_id'] = GV.SERVICE_ID

            if 'blocked' in data:
                params_m_aui['blocked'] = data['blocked']

            params = {
                'table_name': 'm_auth0_user_info',
                'filters': {
                    'auth0_user_id': params_m_aui['auth0_user_id'],
                    'company_code': params_m_aui['company_code'],
                    'system_id': params_m_aui['system_id'],
                    'service_id': params_m_aui['service_id']
                }
            }
            data_m_aui1 = self.get_data(params)
            logger.debug('data_m_aui1')
            logger.debug(data_m_aui1)

            tmp_m_aui_1 = None

            if data_m_aui1 is None:
                error_message = '「Auth0ユーザー情報管理(user_infrastructure.m_auth0_user_info)」に指定ユーザーのデータが存在しません。'
                error = {
                    'code': 400,
                    'message': error_message
                }
                return GV.handle_error('ERROR', None, error)
                pass

            if data_m_aui1:
                logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')

                try:
                    params_m_aui['roles'] = json.loads(data_m_aui1['roles'])
                except json.JSONDecodeError:
                    params_m_aui['roles'] = None

                params_m_aui['auth_user_info_id'] = data_m_aui1['auth_user_info_id']

                tmp_m_aui_1 = m_aui._update(params_m_aui)

                pass

            if tmp_m_aui_1 is None:
                logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                logger.debug('# データ登録NGの場合')
                raise CustomException('SYS_ERR_100')

            logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
        finally:
            pass
            print('---------------------------------')

        return {}
        pass

    # 削除する
    def delete(self, event, context):
        '''
        削除する
        '''

        logger.debug('# ******************************')
        logger.debug('# delete update')

        if GV.EVENT_BODY is None:
            # メッセージ用検討 ???
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        logger.debug(data)

        # ???
        # self.check_permissions(data)

        logger.debug('# ******************************')
        logger.debug('# パラメータチェック')

        # メールアドレスは必須項目
        if 'email_address' not in data:
            raise CustomException('ACCOUNT_ERR_001')
        # 企業コードは必須項目
        if 'company_code' not in data:
            raise CustomException('ACCOUNT_ERR_COMPANY_CODE')

        logger.debug('# ##############################')

        try:

            logger.debug('# ******************************')

            logger.debug('# 「mscone_lic.m_directory_user」検索する')

            params_mdu = {
                'table_name': 'm_directory_user',
                'filters': {
                    'company_code': data['company_code'],
                    'user_email': data['email_address']
                }
            }

            data_m_du = self.get_data(params_mdu)

            if data_m_du is None:
                logger.debug('# 「mscone_lic.m_directory_user」にデータが無い')
                # raise CustomException('SYS_ERR_100')
                pass

            # return data_m_du

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# 「mscone_lic.m_directory_user」からデータ更新する')

            if data_m_du is not None:

                # from ..model.m_directory_user import Sub as MDU
                # m_du = MDU()
                MDU = GV.get_module('m_directory_user')
                m_du = MDU()

                data_m_du['user_email'] = None

                tmp_m_du = m_du._update(data_m_du)

                if tmp_m_du is None:
                    logger.debug('# 「mscone_lic.m_directory_user」にデータ更新失敗')
                    raise CustomException('SYS_ERR_100')
                    pass

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # logger.debug('# テーブル「ユーザーマスタ」検索する')
            # logger.debug('# m_user')

            # params_m_u = {
            #     'table_name': 'm_user',
            #     'filters': {
            #         'company_code': data['company_code'],
            #         'email': data['email_address']
            #     }
            # }

            # data_m_u = self.get_data(params_m_u)

            # if data_m_u is None:
            #     logger.debug('# 「m_user」にデータが無い')
            #     # raise CustomException('SYS_ERR_100')
            #     pass

            # # return data_m_u

            # logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # logger.debug('# 「m_user」からデータ削除する')

            # if data_m_u is not None:

            #     # from ..model.m_user import Sub as MU
            #     # m_u = MU()
            #     MU = GV.get_module('m_user')
            #     m_u = MU()

            #     tmp_m_u = m_u._delete(data_m_u)

            #     logger.debug(tmp_m_u)

            #     # if tmp_m_u is None:
            #     #     logger.debug('# 「m_user」にデータ削除失敗')
            #     #     raise CustomException('SYS_ERR_100')
            #     #     pass

            # logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# Auth0アカウントがすでに存在するかどうか確認する')

            # from ..auth0 import Sub as auth0_class
            # auth0 = auth0_class()
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            auth0_users = a0._get_users_by_email(data['email_address'])

            if auth0_users is None or len(auth0_users) < 1:
                # 存在しない場合
                logger.debug('存在しない場合')
                # raise CustomException('ACCOUNT_ERR_ACCOUNT_NOT_EXIST')

            logger.debug('存在する場合')

            data_auth0 = None

            if auth0_users is not None and len(auth0_users) > 0:

                data_auth0 = auth0_users[0]

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ削除する')
            logger.debug('# m_auth_user_info')

            if data_auth0 is not None:

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                params_m_aui = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': data_auth0['user_id'],
                        'company_code': data['company_code'],
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID
                    }
                }
                data_m_aui = self.get_data(params_m_aui)
                logger.debug(data_m_aui)

                tmp_m_aui = None

                if data_m_aui:
                    delete_params_m_aui = {}
                    delete_params_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                    tmp_m_aui = m_aui._delete(delete_params_m_aui)

                # if tmp_m_aui is None:
                #     logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                #     logger.debug('# データ登録NGの場合')
                #     raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            # logger.debug('# ******************************')

            # logger.debug('# Auth0アカウントの情報を更新する')

            # if data_auth0 is not None:

            #     data_m_aui = None

            #     # from ..model.m_auth0_user_info import Sub as MAUI
            #     # m_aui = MAUI()
            #     MAUI = GV.get_module('m_auth0_user_info')
            #     m_aui = MAUI()

            #     params_m_aui = {
            #         'table_name': 'm_auth0_user_info',
            #         'filters': {
            #             'auth0_user_id': data_auth0['user_id']
            #         }
            #     }
            #     data_m_aui = self.get_data(params_m_aui)
            #     logger.debug(data_m_aui)

            #     if data_m_aui is None:

            #         logger.debug('# ******************************')

            #         logger.debug('# Auth0アカウントの情報を削除する')

            #         if data_auth0 is not None:

            #             tmp_auth0 = a0._delete(data_auth0['user_id'])

            #             logger.debug(tmp_auth0)

            #         logger.debug('# ##############################')

            # logger.debug('# ##############################')

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            print(err)
            # 例外の再送出
            raise
        finally:
            pass
            print('---------------------------------')

        return {}
        pass

    def check_verification_code(self, data):
        logger.debug('# ******************************')
        logger.debug('# 申込サイトコード(URL)が有効かどうか確認する')
        logger.debug(data)

        status = False
        message = None

        if 'code' in data:

            logger.debug('# 申込コード')
            code = data['code']

            logger.debug('# 申込タイプ')
            logger.debug('# s:スタッフ、t:トライアル、m:保守契約企業、w:ワークショップ、c:本契約、a:システム管理者変更')
            t_code = code[0]
            
            logger.debug('# ************0704******************') 
            t_m_auth0_management_id = code[2]
            params = {
                'table_name': 'm_auth0_management',
                'filters': {
                    'id': t_m_auth0_management_id
                }
            }
            data_m_am = self.get_data(params)
            logger.debug(data_m_am)

            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "m_auth0_managementのID" + t_m_auth0_management_id + " は存在しないので、システム者にご連絡ください。"}
            logger.debug(GV.CONFIG)
            logger.debug('# ************0704******************') 

            logger.debug('# Auth0を検索する')
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            result = None

            user = None
            if t_code == 's':
                logger.debug('# トライアル申込')
                query = f'app_metadata.data.staff_req_vefification_code: "{code}"'
                result = a0._search_user(query=query)
            elif t_code == 't':
                logger.debug('# トライアル申込')
                query = f'app_metadata.data.trial_req_vefification_code: "{code}"'
                logger.debug(query)
                result = a0._search_user(query=query)
            elif t_code == 'm':
                logger.debug('# 保守契約企業申込')
                query = f'app_metadata.data.ma_contract_req_vefification_code: "{code}"'
                result = a0._search_user(query=query)
            elif t_code == 'w':
                logger.debug('# ワークショップ申込')
                query = f'app_metadata.data.workshop_req_vefification_code: "{code}"'
                result = a0._search_user(query=query)
            elif t_code == 'c':
                logger.debug('# 本契約申込')
                query = f'app_metadata.data.contract_req_vefification_code: "{code}"'
                result = a0._search_user(query=query)
            elif t_code == 'a':
                logger.debug('# システム管理者変更')
                query = f'app_metadata.data.change_admin_user_vefification_code: "{code}"'
                result = a0._search_user(query=query)
            else:
                result = None

            logger.debug(result)
            if result == '':
                logger.debug('MS未承認')
                res = {}
                res['status'] = False
                res['message'] = 'Microsoftからの招待を承諾してください。'
                return res
            logger.debug('MS承認済')
            logger.debug('# Auth0にデータがある場合、有効期限を確認する')
            if result and 'users' in result and len(result['users']) > 0:

                user = result['users'][0]
                print(user)

                regist_datetime = None

                app_metadata_data = None

                if 'data' in user['app_metadata']:
                    print(user['app_metadata'])
                    print(type(user['app_metadata']))
                    app_metadata_data = user['app_metadata']['data']

                if app_metadata_data is not None:

                    for d in app_metadata_data:

                        logger.debug('# 各申込テーブルから「登録日時」を取得する')

                        if t_code == 's':

                            if 'staff_req_vefification_code' in d and d['staff_req_vefification_code'] == code:

                                staff_req_date = d['staff_req_date']
                                regist_datetime = datetime.strptime(
                                    staff_req_date, '%Y-%m-%d %H:%M:%S.%f')

                        elif t_code == 't':

                            if 'trial_req_vefification_code' in d and d['trial_req_vefification_code'] == code:

                                trial_req_date = d['trial_req_date']
                                regist_datetime = datetime.strptime(
                                    trial_req_date, '%Y-%m-%d %H:%M:%S.%f')
                        
                        elif t_code == 'm':

                            if 'ma_contract_req_vefification_code' in d and d['ma_contract_req_vefification_code'] == code:

                                ma_contract_req_date = d['ma_contract_req_date']
                                regist_datetime = datetime.strptime(
                                    ma_contract_req_date, '%Y-%m-%d %H:%M:%S.%f')

                        elif t_code == 'w':

                            if 'workshop_req_vefification_code' in d and d['workshop_req_vefification_code'] == code:

                                workshop_req_date = d['workshop_req_date']
                                regist_datetime = datetime.strptime(
                                    workshop_req_date, '%Y-%m-%d %H:%M:%S.%f')

                        elif t_code == 'c':

                            if 'contract_req_vefification_code' in d and d['contract_req_vefification_code'] == code:

                                contract_req_date = d['contract_req_date']
                                regist_datetime = datetime.strptime(
                                    contract_req_date, '%Y-%m-%d %H:%M:%S.%f')
                                
                        elif t_code == 'a':

                            if 'change_admin_user_vefification_code' in d and d['change_admin_user_vefification_code'] == code:
                                logger.debug('# 次へ進む')
                                status = True
                                pass
                                break

                        logger.debug('# 「登録日時」がある場合')
                        if regist_datetime is not None:

                            logger.debug('# 時間差計算')
                            td = datetime.now() - regist_datetime
                            logger.debug(td)

                            logger.debug('# 時間に換算')
                            tdh = td / timedelta(hours=1)
                            logger.debug(tdh)

                            logger.debug('# 有効期限と比較')
                            logger.debug('# 有効期限を超えたら次へ進められない')
                            if tdh > GV.ACCOUNT_REGIST_CODE_EXPIRATION_TIME:
                                # return {
                                #     'status': status,
                                #     'message': '有効期限が切れました。'
                                # }
                                message = '有効期限が切れました。'
                            else:
                                logger.debug('# 次へ進む')
                                status = True

                            break

        res = {}
        res['status'] = status
        if status == True:
            res['email'] = user['email']
        if message is not None:
            res['message'] = message

        return res
        pass

    def set_password(self, data):
        logger.debug(data)

        status = False

        if 'code' not in data:
            pass

        # if 'password' not in data:
        #     pass

        logger.debug('Auth0アカウントのパスワードを設定する')
        if 'code' in data:

            code = data['code']

            t_code = code[0]
            
            logger.debug('# ************0704******************') 
            t_m_auth0_management_id = code[2]
            params = {
                'table_name': 'm_auth0_management',
                'filters': {
                    'id': t_m_auth0_management_id
                }
            }
            data_m_am = self.get_data(params)
            logger.debug(data_m_am)

            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "m_auth0_managementのID" + t_m_auth0_management_id + " は存在しないので、システム者にご連絡ください。"}
            logger.debug(GV.CONFIG)
            logger.debug('# ************0704******************') 

            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            if t_code == 's':

                if '# スタッフ パスワードリセット':

                    logger.debug('# ******************************')
                    logger.debug('# スタッフ パスワードリセット')

                    logger.debug('ユーザー検索')
                    query = f'app_metadata.data.staff_req_vefification_code: "{code}"'
                    result = a0._search_user(query=query)

                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

            elif t_code == 't':

                if '# トライアル申込':

                    logger.debug('# ******************************')
                    logger.debug('# トライアル申込')
                    logger.debug('ユーザー検索')
                    # entraid対応にあたりDB読み込みに変更
                    query = f'app_metadata.data.trial_req_vefification_code: "{code}"'
                    result = a0._search_user(query=query)
                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]
                        logger.debug(user)

                        logger.debug('# ******************************')

                        logger.debug('トライアル申込処理を行う')

                        data_tr = None

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」から申込情報取得する')

                        app_metadata_data = None

                        if 'data' in user['app_metadata']:
                            app_metadata_data = user['app_metadata']['data']

                        if app_metadata_data is not None:

                            for d in app_metadata_data:

                                if 'trial_req_vefification_code' in d and d['trial_req_vefification_code'] == code:

                                    data_tr = {}
                                    data_tr['auth0_user_id'] = user['user_id']
                                    data_tr['trial_req_id'] = d['trial_req_id']
                                    GV.SERVICE_PATH = d['service_path']

                                    break

                        logger.debug('# ##############################')

                        if data_tr is None:
                            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.error('# 「app_metadata」から申込情報取得')
                            logger.error(code)
                            logger.error(app_metadata_data)
                            raise CustomException('SYS_ERR_100')

                        from .trial import Sub as TR
                        tr = TR()
                        res = tr.regist_trial_data(data_tr)

                        logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

            elif t_code == 'm':

                if '# 保守契約企業申込':

                    logger.debug('# ******************************')
                    logger.debug('# 保守契約企業申込')

                    logger.debug('ユーザー検索')
                    query = f'app_metadata.data.ma_contract_req_vefification_code: "{code}"'
                    result = a0._search_user(query=query)

                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]

                        logger.debug('# ******************************')

                        logger.debug('保守契約企業申込処理を行う')

                        data_tr = None

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」から申込情報取得する')

                        app_metadata_data = None

                        if 'data' in user['app_metadata']:
                            app_metadata_data = user['app_metadata']['data']

                        if app_metadata_data is not None:

                            for d in app_metadata_data:

                                if 'ma_contract_req_vefification_code' in d and d['ma_contract_req_vefification_code'] == code:

                                    data_tr = {}
                                    data_tr['auth0_user_id'] = user['user_id']
                                    data_tr['ma_contract_req_id'] = d['ma_contract_req_id']
                                    GV.SERVICE_PATH = d['service_path']

                                    break

                        logger.debug('# ##############################')

                        if data_tr is None:
                            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.error('# 「app_metadata」から申込情報取得')
                            logger.error(code)
                            logger.error(app_metadata_data)
                            raise CustomException('SYS_ERR_100')

                        from .ma_contract import Sub as TR
                        tr = TR()
                        res = tr.regist_ma_contract_data(data_tr)

                        logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

            elif t_code == 'w':

                if '# ワークショップ申込':

                    logger.debug('# ******************************')
                    logger.debug('# ワークショップ申込')

                    logger.debug('ユーザー検索')
                    query = f'app_metadata.data.workshop_req_vefification_code: "{code}"'
                    result = a0._search_user(query=query)

                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]

                        logger.debug('# ******************************')

                        logger.debug('ワークショップ申込処理を行う')

                        data_ws = None

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」から申込情報取得する')

                        app_metadata_data = None

                        if 'data' in user['app_metadata']:
                            app_metadata_data = user['app_metadata']['data']

                        if app_metadata_data is not None:

                            for d in app_metadata_data:

                                if 'workshop_req_vefification_code' in d and d['workshop_req_vefification_code'] == code:

                                    data_ws = {}
                                    data_ws['auth0_user_id'] = user['user_id']
                                    data_ws['workshop_req_id'] = d['workshop_req_id']
                                    GV.SERVICE_PATH = d['service_path']

                                    break

                        logger.debug('# ##############################')

                        if data_ws is None:
                            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.error('# 「app_metadata」から申込情報取得')
                            logger.error(code)
                            logger.error(app_metadata_data)
                            raise CustomException('SYS_ERR_100')

                        from .workshop import Sub as WS
                        ws = WS()
                        res = ws.regist_workshop_data(data_ws)

                        logger.debug(res)

                        if 'code' in res:
                            return res

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

            elif t_code == 'c':

                if '# 本契約申込':

                    logger.debug('# ******************************')
                    logger.debug('# 本契約申込')

                    logger.debug('ユーザー検索')
                    query = f'app_metadata.data.contract_req_vefification_code: "{code}"'
                    result = a0._search_user(query=query)

                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]

                        logger.debug('# ******************************')

                        logger.debug('本契約申込処理を行う')

                        data_ct = None

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」から申込情報取得する')

                        app_metadata_data = None

                        if 'data' in user['app_metadata']:
                            app_metadata_data = user['app_metadata']['data']

                        if app_metadata_data is not None:

                            for d in app_metadata_data:

                                if 'contract_req_vefification_code' in d and d['contract_req_vefification_code'] == code:

                                    data_ct = {}
                                    data_ct['auth0_user_id'] = user['user_id']
                                    data_ct['contract_req_id'] = d['contract_req_id']
                                    GV.SERVICE_PATH = d['service_path']

                                    break

                        logger.debug('# ##############################')

                        if data_ct is None:
                            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.error('# 「app_metadata」から申込情報取得')
                            logger.error(code)
                            logger.error(app_metadata_data)
                            raise CustomException('SYS_ERR_100')

                        from .contract import Sub as CT
                        ct = CT()
                        res = ct.regist_contract_data(data_ct)

                        logger.debug(res)

                        if 'code' in res:
                            return res

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

            elif t_code == 'a':

                if '# システム管理者変更':

                    logger.debug('# ******************************')
                    logger.debug('# システム管理者変更')

                    logger.debug('ユーザー検索')
                    query = f'app_metadata.data.change_admin_user_vefification_code: "{code}"'
                    result = a0._search_user(query=query)

                    logger.debug(result)

                    if result and 'users' in result and len(result['users']) > 0:
                        user = result['users'][0]

                        # logger.debug('# ******************************')

                        # logger.debug('本契約申込処理を行う')

                        # data_ct = None

                        # logger.debug('# ******************************')
                        # logger.debug('# 「app_metadata」から申込情報取得する')

                        # app_metadata_data = None

                        # if 'data' in user['app_metadata']:
                        #     app_metadata_data = user['app_metadata']['data']

                        # if app_metadata_data is not None:

                        #     for d in app_metadata_data:

                        #         if 'contract_req_vefification_code' in d and d['contract_req_vefification_code'] == code:

                        #             data_ct = {}
                        #             data_ct['auth0_user_id'] = user['user_id']
                        #             data_ct['contract_req_id'] = d['contract_req_id']
                        #             GV.SERVICE_PATH = d['service_path']

                        #             break

                        # logger.debug('# ##############################')

                        # if data_ct is None:
                        #     logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        #     logger.error('# 「app_metadata」から申込情報取得')
                        #     logger.error(code)
                        #     logger.error(app_metadata_data)
                        #     raise CustomException('SYS_ERR_100')

                        # from .contract import Sub as CT
                        # ct = CT()
                        # res = ct.regist_contract_data(data_ct)

                        # logger.debug(res)

                        # if 'code' in res:
                        #     return res

                        # logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        # user_data = {}
                        # user_data['password'] = data['password']

                        # logger.debug('パスワード設定')
                        # res = a0._update(user['user_id'], user_data)
                        # logger.debug(res)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        user_data = {}
                        user_data['email_verified'] = True

                        logger.debug('メール検証済')
                        res = a0._update(user['user_id'], user_data)
                        logger.debug(res)

                        logger.debug('# ##############################')

                        status = True

                        logger.debug('# ******************************')
                        logger.debug('# 「app_metadata」の「data」をクリアする')

                        if status == True:

                            user['app_metadata']['data'] = []

                            data_auth0 = {}
                            data_auth0['app_metadata'] = user['app_metadata']
                            data_auth0['user_metadata'] = user['user_metadata']

                            logger.debug('# atuh0 update')
                            a0._update(user['user_id'], data_auth0)

                        logger.debug('# ##############################')

                    logger.debug('# ##############################')

        return {
            'status': status
        }
        pass

    def get_system_info(self, data=None):
        logger.debug('# ******************************')
        logger.debug('# システム情報を取得する')

        if GV.LOGGEDIN_USER is None:
            return {}
        pprint(GV.LOGGEDIN_USER)

        if 'user_metadata' in GV.LOGGEDIN_USER and \
                'data' in GV.LOGGEDIN_USER['user_metadata']:

            user_metadata = GV.LOGGEDIN_USER['user_metadata']['data']

            logger.debug('# ******************************')
            logger.debug('# 企業名を取得する')

            list_company_code = []
            for d in user_metadata:
                if d['company_code'] not in list_company_code:
                    if d['company_code'] != GV.STAFF_COMPANY_CODE:
                        list_company_code.append(d['company_code'])

            # from ..model.m_company import Sub as MC
            # m_c = MC()
            MC = GV.get_module('m_company')
            m_c = MC()

            filters = []
            filters.append(m_c.model_class.company_code.in_(list_company_code))
            filters = and_(*filters)

            tmp_m_c = m_c._get_item_by_filters(filters, get_all=True)
            pprint(tmp_m_c)

            dict_company = {}
            for t in tmp_m_c:
                dict_company[t.company_code] = t.company_name

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# サービス名を取得する')

            list_service_id = []
            for d in user_metadata:
                if d['service_id'] not in list_service_id:
                    list_service_id.append(d['service_id'])

            # from ..model.m_services import Sub as MSRV
            # m_srv = MSRV()
            MSRV = GV.get_module('m_services')
            m_srv = MSRV()

            filters = []
            filters.append(m_srv.model_class.service_id.in_(list_service_id))
            filters.append(m_srv.model_class.service_id != GV.STAFF_SERVICE_ID)
            filters = and_(*filters)

            tmp_m_srv = m_srv._get_item_by_filters(filters, get_all=True)

            dict_service = {}
            for t in tmp_m_srv:
                logger.debug(t.to_dict())
                dict_service[t.service_id] = t.service_name

            logger.debug('# ##############################')

            res = {}
            for d in user_metadata:
                cc = d['company_code']
                if cc != GV.STAFF_COMPANY_CODE:
                    
                    if 'roles' in d and len(d['roles']) > 0:
                        if GV.ROLES_TRIAL_USER in d['roles'] or \
                            GV.ROLES_WORKSHOP_USER in d['roles'] or \
                            GV.ROLES_ADMIN_USER in d['roles'] or \
                            GV.ROLES_MA_CONTRACT_USER in d['roles'] or \
                            GV.ROLES_GENERAL_USER in d['roles']:

                            if cc not in res:
                                res[cc] = {}
                                if cc in dict_company:
                                    res[cc]['company_name'] = dict_company[cc]
                                else:
                                    res[cc]['company_name'] = cc

                                res[cc]['services'] = {}

                            si = d['service_id']

                            if (si != GV.REQUEST_USER_SYSTEM_ID and si != GV.REQUEST_USER_SYSTEM_ID) and \
                            (si != GV.STAFF_SERVICE_ID and si != GV.REQUEST_USER_SERVICE_ID):

                                if si not in res[cc]['services']:
                                    res[cc]['services'][si] = {}
                                    res[cc]['services'][si]['service_name'] = dict_service[si]

            pprint(res)

            for k in list(res):
                if 'services' in res[k]:
                    if len(res[k]['services']) == 0:
                        res.pop(k)
                else:
                    res.pop(k)

            pprint(res)

            return res
        pass

        return {
            'body': 'OK'
        }

    def get_user_info(self, data=None):
        try:
            logger.debug('# ******************************')
            logger.debug('# ユーザー情報を取得する')
            logger.debug(
                '# ・自動入力のデータ取得元の優先度「m_company,m_user,m_contract＞ワークショップ申込履歴(作成日が新しいもの)>トライアル申込履歴(作成日が新しいもの)」。')

            if GV.LOGGEDIN_USER is None:
                return {}

            user_info = {
                'company_zip_code': '',
                'company_address_1': '',
                'company_address_2': '',
                'company_address_3': '',
                'company_address_pref': '',
                'company_first_name': '',
                'company_first_name_kana': '',
                'company_last_name': '',
                'company_last_name_kana': '',
                'company_leader_date_of_birth': None,
                'company_name': '',
                'company_name_kana': '',
                'company_remarks_column': '',
                'company_telephone_number': '',
                'contract_zip_code': '',
                'contract_address_1': '',
                'contract_address_2': '',
                'contract_address_3': '',
                'contract_address_pref': '',
                'contract_affiliation_department': '',
                'contract_director': '',
                'contract_first_name': '',
                'contract_first_name_kana': '',
                'contract_last_name': '',
                'contract_last_name_kana': '',
                'contract_req_id': '',
                'contract_telephone_number': '',
                'contract_email_address': '',
                'gmo_invoice_mail': None,
                'status': None,
                'contract_product_request': None,
                'tenant': None
            }

            logger.debug(data)

            logger.debug('# ******************************')
            logger.debug(
                '# そのユーザの全ての申込情報管理うち1つでもプロセスのステータスが「本契約申込～本契約利用中」の場合は')
            logger.debug('# このページの入力項目の編集不可能。ページの上部にメッセージ表示「本契約中のお客様はこちらのサイト')
            logger.debug('# から契約者情報の変更はできません。')

            TMR = GV.get_module('t_manage_request')
            t_mr = TMR()

            filters = []
            filters.append(t_mr.model_class.auth0_user_id ==
                           GV.LOGGEDIN_USER['sub'])
            filters = and_(*filters)

            tmp_t_mr = t_mr._get_item_by_filters(filters, get_all=True)

            for t in tmp_t_mr:

                d = t.to_dict()

                if d is not None:
                    # if d['status'] in [GV.STATUS['本契約申請'], GV.STATUS['本契約受付'], GV.STATUS['本契約利用中']]:
                    #     user_info['status'] = True
                    user_info['status'] = d['status']

            logger.debug('# ##############################')

            data_t_mr = None

            logger.debug('# ******************************')
            if '# 選択したサービスのデータを検索する':

                logger.debug('# 選択したサービスのデータを検索する')

                logger.debug('# ******************************')

                logger.debug('# テーブル「t_manage_request」からデータ取得')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': GV.LOGGEDIN_USER['sub']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr is not None:

                    logger.debug('# データがある場合')
                    logger.debug(data_t_mr)
                    
                    logger.debug('# ******************************')
                    logger.debug('# 「契約ID」登録されている場合')

                    if data_t_mr['contract_id'] is not None:

                        logger.debug('# テーブル「契約情報」と「企業マスタ」からデータ取得')

                        logger.debug('# ******************************')

                        logger.debug('# テーブル「企業マスタ」からデータ取得')
                        logger.debug('# m_company')

                        # from ..model.m_company import Sub as MC
                        # m_c = MC()
                        MC = GV.get_module('m_company')
                        m_c = MC()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(m_c.model_class.company_code ==
                                       data_t_mr['company_code'])
                        filters = and_(*filters)

                        tmp_m_c = m_c._get_item_by_filters(filters)

                        if tmp_m_c is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_m_c = tmp_m_c.to_dict()

                        logger.debug(data_m_c)

                        user_info['company_zip_code'] = data_m_c['company_zipcode'] or ''
                        user_info['company_address_1'] = data_m_c['company_address_1'] or ''
                        user_info['company_address_2'] = data_m_c['company_address_2'] or ''
                        user_info['company_address_3'] = data_m_c['company_address_3'] or ''
                        user_info['company_address_pref'] = data_m_c['company_address_pref'] or ''
                        user_info['company_first_name'] = data_m_c['company_leader_first'] or ''
                        user_info['company_first_name_kana'] = data_m_c['company_leader_kana_first'] or ''
                        user_info['company_last_name'] = data_m_c['company_leader_last'] or ''
                        user_info['company_last_name_kana'] = data_m_c['company_leader_kana_last'] or ''
                        user_info['company_leader_date_of_birth'] = data_m_c['company_leader_date_of_birth']
                        user_info['company_name'] = data_m_c['company_name'] or ''
                        user_info['company_name_kana'] = data_m_c['company_name_kana'] or ''
                        user_info['company_remarks_column'] = data_m_c['customer_notes'] or ''
                        user_info['company_telephone_number'] = data_m_c['company_tel_1'] or ''

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        logger.debug('# テーブル「契約情報」からデータ取得')
                        logger.debug('# m_contract')

                        # from ..model.m_contract import Sub as MCTR
                        # m_ctr = MCTR()
                        MCTR = GV.get_module('m_contract')
                        m_ctr = MCTR()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(m_ctr.model_class.contract_id ==
                                       data_t_mr['contract_id'])
                        filters = and_(*filters)

                        tmp_m_ctr = m_ctr._get_item_by_filters(filters)

                        if tmp_m_ctr is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_m_ctr = tmp_m_ctr.to_dict()

                        logger.debug(data_m_ctr)

                        user_info['contract_zip_code'] = data_m_ctr['contract_zipcode'] or ''
                        user_info['contract_address_1'] = data_m_ctr['contract_address_1'] or ''
                        user_info['contract_address_2'] = data_m_ctr['contract_address_2'] or ''
                        user_info['contract_address_3'] = data_m_ctr['contract_address_3'] or ''
                        user_info['contract_address_pref'] = data_m_ctr['contract_address_pref'] or ''
                        user_info['contract_affiliation_department'] = data_m_ctr['contract_department'] or ''
                        user_info['contract_director'] = data_m_ctr['contract_position'] or ''
                        user_info['contract_first_name'] = data_m_ctr['contract_first_name'] or ''
                        user_info['contract_first_name_kana'] = data_m_ctr['contract_first_name_kana'] or ''
                        user_info['contract_last_name'] = data_m_ctr['contract_last_name'] or ''
                        user_info['contract_last_name_kana'] = data_m_ctr['contract_last_name_kana'] or ''
                        user_info['contract_telephone_number'] = data_m_ctr['contract_tel_1'] or ''
                        user_info['contract_email_address'] = data_m_ctr['contract_email'] or ''
                        user_info['gmo_invoice_mail'] = data_m_ctr['invoice_sending_method']
                        
                        logger.debug('# **************0611****S************')
                        logger.debug('# テーブル「本契約申込情報（確認済み）」からデータ取得')
                        logger.debug('# t_contract_request_confirmed')

                        # from ..model.t_contract_request_confirmed import Sub as TCRC
                        # t_crc = TCRC()
                        TCRC = GV.get_module('t_contract_request_confirmed')
                        t_crc = TCRC()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(t_crc.model_class.contract_req_id ==
                                       data_t_mr['contract_req_id'])
                        filters = and_(*filters)

                        tmp_t_crc = t_crc._get_item_by_filters(filters)

                        if tmp_t_crc is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_t_crc = tmp_t_crc.to_dict()
                        filtersT2 = []

                        for t2 in data_t_crc['contract_product_request']:
                            ditem2 = t2
                            logger.debug(ditem2)
                            logger.debug(ditem2['billing_identifier'])
                        
                            data_tr = {}
            
                            data_tr['selectLink'] = ditem2['billing_identifier'] + ' 同時実行数：' + ditem2['quantity']
                            
                            filtersT2.append(data_tr)

                        user_info['contract_product_request'] = filtersT2
                        
                        logger.debug('# **************0611****E************')
                        
                        logger.debug('# **************0702****S************')
                        user_info['tenant'] = data_t_crc['tenant']
                        logger.debug('# **************0702****E************')

                        logger.debug('# ##############################')

                        return user_info
                    else:
                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    logger.debug('# 「本契約申込ID」登録されている場合')
                    logger.debug('# 「契約ID」登録されて無い場合')

                    if data_t_mr['contract_req_id'] is not None and \
                            data_t_mr['contract_id'] is None:

                        logger.debug('# 本契約申込履歴(作成日が新しいもの)')

                        logger.debug('# ******************************')

                        logger.debug('# テーブル「本契約申込情報（確認済み）」からデータ取得')
                        logger.debug('# t_contract_request_confirmed')

                        # from ..model.t_contract_request_confirmed import Sub as TCRC
                        # t_crc = TCRC()
                        TCRC = GV.get_module('t_contract_request_confirmed')
                        t_crc = TCRC()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(t_crc.model_class.contract_req_id ==
                                       data_t_mr['contract_req_id'])
                        filters = and_(*filters)

                        tmp_t_crc = t_crc._get_item_by_filters(filters)

                        if tmp_t_crc is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_t_crc = tmp_t_crc.to_dict()

                        logger.debug(data_t_crc)

                        user_info['company_zip_code'] = data_t_crc['company_zip_code'] or ''
                        user_info['company_address_1'] = data_t_crc['company_address_1'] or ''
                        user_info['company_address_2'] = data_t_crc['company_address_2'] or ''
                        user_info['company_address_3'] = data_t_crc['company_address_3'] or ''
                        user_info['company_address_pref'] = data_t_crc['company_address_pref'] or ''
                        user_info['company_first_name'] = data_t_crc['company_first_name'] or ''
                        user_info['company_first_name_kana'] = data_t_crc['company_first_name_kana'] or ''
                        user_info['company_last_name'] = data_t_crc['company_last_name'] or ''
                        user_info['company_last_name_kana'] = data_t_crc['company_last_name_kana'] or ''
                        user_info['company_leader_date_of_birth'] = data_t_crc['company_leader_date_of_birth']
                        user_info['company_name'] = data_t_crc['company_name'] or ''
                        user_info['company_name_kana'] = data_t_crc['company_name_kana'] or ''
                        user_info['company_remarks_column'] = data_t_crc['company_remarks_column'] or ''
                        user_info['company_telephone_number'] = data_t_crc['company_telephone_number'] or ''
                        user_info['contract_zip_code'] = data_t_crc['contract_zip_code'] or ''
                        user_info['contract_address_1'] = data_t_crc['contract_address_1'] or ''
                        user_info['contract_address_2'] = data_t_crc['contract_address_2'] or ''
                        user_info['contract_address_3'] = data_t_crc['contract_address_3'] or ''
                        user_info['contract_address_pref'] = data_t_crc['contract_address_pref'] or ''
                        user_info['contract_affiliation_department'] = data_t_crc['contract_affiliation_department'] or ''
                        user_info['contract_director'] = data_t_crc['contract_director'] or ''
                        user_info['contract_first_name'] = data_t_crc['contract_first_name'] or ''
                        user_info['contract_first_name_kana'] = data_t_crc['contract_first_name_kana'] or ''
                        user_info['contract_last_name'] = data_t_crc['contract_last_name'] or ''
                        user_info['contract_last_name_kana'] = data_t_crc['contract_last_name_kana'] or ''
                        user_info['contract_req_id'] = data_t_crc['contract_req_id'] or ''
                        user_info['contract_telephone_number'] = data_t_crc['contract_telephone_number'] or ''
                        user_info['contract_email_address'] = data_t_crc['contract_email_address'] or ''
                        user_info['gmo_invoice_mail'] = data_t_crc['gmo_invoice_mail']
                        
                        
                        logger.debug('# **************0611****S************')
                        filtersT2 = []

                        for t2 in data_t_crc['contract_product_request']:
                            ditem2 = t2
                            logger.debug(ditem2)
                            logger.debug(ditem2['billing_identifier'])
                        
                            data_tr = {}
            
                            data_tr['selectLink'] = ditem2['billing_identifier'] + ' 同時実行数：' + ditem2['quantity']
                            
                            filtersT2.append(data_tr)

                        user_info['contract_product_request'] = filtersT2
                        
                        logger.debug('# **************0611****E************')
                        
                        logger.debug('# **************0702****S************')
                        user_info['tenant'] = data_t_crc['tenant']
                        logger.debug('# **************0702****E************')

                        return user_info

                        logger.debug('# ##############################')
                    else:
                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    logger.debug('# 「ワークショップ申込ID」登録されている場合')
                    logger.debug('# 「本契約申込ID」登録されて無い場合')

                    if data_t_mr['workshop_req_id'] is not None and \
                            data_t_mr['contract_req_id'] is None and \
                            data_t_mr['contract_id'] is None:

                        logger.debug('# ワークショップ申込履歴(作成日が新しいもの)')

                        logger.debug('# ******************************')

                        logger.debug('# テーブル「ワークショップ申込情報（確認済み）」からデータ取得')
                        logger.debug('# t_workshop_request_confirmed')

                        # from ..model.t_workshop_request_confirmed import Sub as TWRC
                        # t_wrc = TWRC()
                        TWRC = GV.get_module('t_workshop_request_confirmed')
                        t_wrc = TWRC()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(t_wrc.model_class.workshop_req_id ==
                                       data_t_mr['workshop_req_id'])
                        filters = and_(*filters)

                        tmp_t_wrc = t_wrc._get_item_by_filters(filters)

                        if tmp_t_wrc is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_t_wrc = tmp_t_wrc.to_dict()

                        logger.debug(data_t_wrc)

                        user_info['company_name'] = data_t_wrc['company_name'] or ''
                        user_info['contract_zip_code'] = data_t_wrc['zip_code'] or ''
                        user_info['contract_address_pref'] = data_t_wrc['address_pref'] or ''
                        user_info['contract_address_1'] = data_t_wrc['address_1'] or ''
                        user_info['contract_address_2'] = data_t_wrc['address_2'] or ''
                        user_info['contract_address_3'] = data_t_wrc['address_3'] or ''
                        user_info['contract_last_name'] = data_t_wrc['last_name'] or ''
                        user_info['contract_first_name'] = data_t_wrc['first_name'] or ''
                        user_info['contract_first_name'] = data_t_wrc['first_name'] or ''
                        user_info['contract_affiliation_department'] = data_t_wrc['affiliation_department'] or ''
                        user_info['contract_email_address'] = data_t_wrc['email_address'] or ''
                        user_info['contract_telephone_number'] = data_t_wrc['telephone_number'] or ''

                        return user_info

                        logger.debug('# ##############################')
                    else:
                        pass

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    logger.debug('# 「トライアル申込ID」だけ登録されている場合')
                    logger.debug('# トライアル申込履歴(作成日が新しいもの)')

                    if data_t_mr['trial_req_id'] is not None and \
                            data_t_mr['workshop_req_id'] is None and \
                            data_t_mr['contract_req_id'] is None and \
                            data_t_mr['contract_id'] is None:

                        logger.debug('# ******************************')

                        logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ取得')
                        logger.debug('# t_trial_request_confirmed')

                        # from ..model.t_trial_request_confirmed import Sub as TTRC
                        # t_trc = TTRC()
                        TTRC = GV.get_module('t_trial_request_confirmed')
                        t_trc = TTRC()

                        logger.debug('# 検索条件')
                        filters = []
                        filters.append(t_trc.model_class.trial_req_id ==
                                       data_t_mr['trial_req_id'])
                        filters = and_(*filters)

                        tmp_t_trc = t_trc._get_item_by_filters(filters)

                        if tmp_t_trc is None:
                            raise CustomException('SYS_ERR_100')
                            pass

                        data_t_trc = tmp_t_trc.to_dict()

                        logger.debug(data_t_trc)

                        user_info['company_name'] = data_t_trc['company_name'] or ''
                        user_info['contract_last_name'] = data_t_trc['last_name'] or ''
                        user_info['contract_first_name'] = data_t_trc['first_name'] or ''
                        user_info['contract_email_address'] = data_t_trc['email_address'] or ''
                        user_info['contract_telephone_number'] = data_t_trc['telephone_number'] or ''

                        logger.debug('# ##############################')

                        return user_info
                    else:
                        pass

                    # 或いは

                    # if data_t_mr['company_code'][0] != 'K':
                    #     logger.debug('# 「company_code」が「K」から始まらない場合、トライアル')
                    #     logger.debug('# トライアル申込履歴(作成日が新しいもの)')

                    #     logger.debug('# ******************************')

                    #     logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ取得')
                    #     logger.debug('# t_trial_request_confirmed')

                    #     # from ..model.t_trial_request_confirmed import Sub as TTRC
                    #     # t_trc = TTRC()
                    #     TTRC = GV.get_module('t_trial_request_confirmed')
                    #     t_trc = TTRC()

                    #     logger.debug('# 検索条件')
                    #     filters = []
                    #     filters.append(t_trc.model_class.system_id == GV.SYSTEM_ID)
                    #     filters.append(t_trc.model_class.service_id == GV.SERVICE_ID)
                    #     filters.append(t_trc.model_class.email_address ==
                    #                    GV.LOGGEDIN_USER['email'])
                    #     filters = and_(*filters)

                    #     logger.debug('# 並び替え 開催日順')
                    #     col = getattr(t_trc.model_class, 'cdate', None)
                    #     order_by = desc(col)

                    #     tmp_t_trc = t_trc._get_item_by_filters(
                    #         filters, order_by=order_by)

                    #     if tmp_t_trc is None:
                    #         raise CustomException('SYS_ERR_100')
                    #         pass

                    #     data_t_trc = tmp_t_trc.to_dict()

                    #     logger.debug(data_t_trc)

                    #     return data_t_trc

                    #     logger.debug('# ##############################')

            if '# 他のサービスを利用中の場合、そのサービスのデータを検索する':
                
                logger.debug('# 他のサービスを利用中の場合、そのサービスのデータを検索する')

                if data_t_mr is None:
                    # from ..model.t_manage_request import Sub as TMR
                    # t_mr = TMR()
                    TMR = GV.get_module('t_manage_request')
                    t_mr = TMR()

                    logger.debug(GV.SYSTEM_ID)
                    logger.debug(GV.SERVICE_ID)

                    filters = []
                    filters.append(t_mr.model_class.system_id != GV.SYSTEM_ID)
                    filters.append(
                        t_mr.model_class.service_id != GV.SERVICE_ID)
                    filters.append(t_mr.model_class.auth0_user_id ==
                                   GV.LOGGEDIN_USER['sub'])
                    filters = and_(*filters)

                    tmp_t_mr = t_mr._get_item_by_filters(filters, get_all=True)
                    logger.debug('tmp_t_mr')
                    logger.debug(tmp_t_mr)

                    for t in tmp_t_mr:
                        d = t.to_dict()

                        if d is not None:

                            logger.debug('# データがある場合')
                            logger.debug(d)

                            logger.debug('# ******************************')
                            logger.debug('# 「契約ID」登録されている場合')

                            if d['contract_id'] is not None:

                                logger.debug('# テーブル「契約情報」と「企業マスタ」からデータ取得')

                                logger.debug(
                                    '# ******************************')

                                logger.debug('# テーブル「企業マスタ」からデータ取得')
                                logger.debug('# m_company')

                                # from ..model.m_company import Sub as MC
                                # m_c = MC()
                                MC = GV.get_module('m_company')
                                m_c = MC()

                                logger.debug('# 検索条件')
                                filters = []
                                filters.append(m_c.model_class.company_code ==
                                               d['company_code'])
                                filters = and_(*filters)

                                tmp_m_c = m_c._get_item_by_filters(filters)

                                if tmp_m_c is None:
                                    raise CustomException('SYS_ERR_100')
                                    pass

                                data_m_c = tmp_m_c.to_dict()

                                logger.debug(data_m_c)

                                user_info['company_zip_code'] = data_m_c['company_zipcode'] or ''
                                user_info['company_address_1'] = data_m_c['company_address_1'] or ''
                                user_info['company_address_2'] = data_m_c['company_address_2'] or ''
                                user_info['company_address_3'] = data_m_c['company_address_3'] or ''
                                user_info['company_address_pref'] = data_m_c['company_address_pref'] or ''
                                user_info['company_first_name'] = data_m_c['company_leader_first'] or ''
                                user_info['company_first_name_kana'] = data_m_c['company_leader_kana_first'] or ''
                                user_info['company_last_name'] = data_m_c['company_leader_last'] or ''
                                user_info['company_last_name_kana'] = data_m_c['company_leader_kana_last'] or ''
                                user_info['company_leader_date_of_birth'] = data_m_c['company_leader_date_of_birth']
                                user_info['company_name'] = data_m_c['company_name'] or ''
                                user_info['company_name_kana'] = data_m_c['company_name_kana'] or ''
                                user_info['company_remarks_column'] = data_m_c['customer_notes'] or ''
                                user_info['company_telephone_number'] = data_m_c['company_tel_1'] or ''

                                logger.debug(
                                    '# ##############################')

                                logger.debug(
                                    '# ******************************')

                                logger.debug('# テーブル「契約情報」からデータ取得')
                                logger.debug('# m_contract')

                                # from ..model.m_contract import Sub as MCTR
                                # m_ctr = MCTR()
                                MCTR = GV.get_module('m_contract')
                                m_ctr = MCTR()

                                logger.debug('# 検索条件')
                                filters = []
                                filters.append(m_ctr.model_class.contract_id ==
                                               d['contract_id'])
                                filters = and_(*filters)

                                tmp_m_ctr = m_ctr._get_item_by_filters(filters)

                                if tmp_m_ctr is None:
                                    raise CustomException('SYS_ERR_100')
                                    pass

                                data_m_ctr = tmp_m_ctr.to_dict()

                                logger.debug(data_m_ctr)

                                user_info['contract_zip_code'] = data_m_ctr['contract_zipcode'] or ''
                                user_info['contract_address_1'] = data_m_ctr['contract_address_1'] or ''
                                user_info['contract_address_2'] = data_m_ctr['contract_address_2'] or ''
                                user_info['contract_address_3'] = data_m_ctr['contract_address_3'] or ''
                                user_info['contract_address_pref'] = data_m_ctr['contract_address_pref'] or ''
                                user_info['contract_affiliation_department'] = data_m_ctr['contract_department'] or ''
                                user_info['contract_director'] = data_m_ctr['contract_position'] or ''
                                user_info['contract_first_name'] = data_m_ctr['contract_first_name'] or ''
                                user_info['contract_first_name_kana'] = data_m_ctr['contract_first_name_kana'] or ''
                                user_info['contract_last_name'] = data_m_ctr['contract_last_name'] or ''
                                user_info['contract_last_name_kana'] = data_m_ctr['contract_last_name_kana'] or ''
                                user_info['contract_telephone_number'] = data_m_ctr['contract_tel_1'] or ''
                                user_info['contract_email_address'] = data_m_ctr['contract_email'] or ''
                                user_info['gmo_invoice_mail'] = data_m_ctr['invoice_sending_method']

                                logger.debug(
                                    '# ##############################')

                                return user_info
                            else:
                                pass

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')
                            logger.debug('# 「本契約申込ID」登録されている場合')
                            logger.debug('# 「契約ID」登録されて無い場合')

                            if d['contract_req_id'] is not None and \
                                    d['contract_id'] is None:

                                logger.debug('# 本契約申込履歴(作成日が新しいもの)')

                                logger.debug(
                                    '# ******************************')

                                logger.debug('# テーブル「本契約申込情報（確認済み）」からデータ取得')
                                logger.debug('# t_contract_request_confirmed')

                                # from ..model.t_contract_request_confirmed import Sub as TCRC
                                # t_crc = TCRC()
                                TCRC = GV.get_module(
                                    't_contract_request_confirmed')
                                t_crc = TCRC()

                                logger.debug('# 検索条件')
                                filters = []
                                filters.append(t_crc.model_class.contract_req_id ==
                                               d['contract_req_id'])
                                filters = and_(*filters)

                                tmp_t_crc = t_crc._get_item_by_filters(filters)

                                if tmp_t_crc is None:
                                    raise CustomException('SYS_ERR_100')
                                    pass

                                data_t_crc = tmp_t_crc.to_dict()

                                logger.debug(data_t_crc)

                                user_info['company_zip_code'] = data_t_crc['company_zip_code'] or ''
                                user_info['company_address_1'] = data_t_crc['company_address_1'] or ''
                                user_info['company_address_2'] = data_t_crc['company_address_2'] or ''
                                user_info['company_address_3'] = data_t_crc['company_address_3'] or ''
                                user_info['company_address_pref'] = data_t_crc['company_address_pref'] or ''
                                user_info['company_first_name'] = data_t_crc['company_first_name'] or ''
                                user_info['company_first_name_kana'] = data_t_crc['company_first_name_kana'] or ''
                                user_info['company_last_name'] = data_t_crc['company_last_name'] or ''
                                user_info['company_last_name_kana'] = data_t_crc['company_last_name_kana'] or ''
                                user_info['company_leader_date_of_birth'] = data_t_crc['company_leader_date_of_birth']
                                user_info['company_name'] = data_t_crc['company_name'] or ''
                                user_info['company_name_kana'] = data_t_crc['company_name_kana'] or ''
                                user_info['company_remarks_column'] = data_t_crc['company_remarks_column'] or ''
                                user_info['company_telephone_number'] = data_t_crc['company_telephone_number'] or ''
                                user_info['contract_zip_code'] = data_t_crc['contract_zip_code'] or ''
                                user_info['contract_address_1'] = data_t_crc['contract_address_1'] or ''
                                user_info['contract_address_2'] = data_t_crc['contract_address_2'] or ''
                                user_info['contract_address_3'] = data_t_crc['contract_address_3'] or ''
                                user_info['contract_address_pref'] = data_t_crc['contract_address_pref'] or ''
                                user_info['contract_affiliation_department'] = data_t_crc['contract_affiliation_department'] or ''
                                user_info['contract_director'] = data_t_crc['contract_director'] or ''
                                user_info['contract_first_name'] = data_t_crc['contract_first_name'] or ''
                                user_info['contract_first_name_kana'] = data_t_crc['contract_first_name_kana'] or ''
                                user_info['contract_last_name'] = data_t_crc['contract_last_name'] or ''
                                user_info['contract_last_name_kana'] = data_t_crc['contract_last_name_kana'] or ''
                                user_info['contract_req_id'] = data_t_crc['contract_req_id'] or ''
                                user_info['contract_telephone_number'] = data_t_crc['contract_telephone_number'] or ''
                                user_info['contract_email_address'] = data_t_crc['contract_email_address'] or ''
                                user_info['gmo_invoice_mail'] = data_t_crc['gmo_invoice_mail']
                                
                                
                                logger.debug('# **************0611****S************')
                                
                                filtersT2 = []
        
                                for t2 in data_t_crc['contract_product_request']:
                                    ditem2 = t2
                                    logger.debug(ditem2)
                                
                                    data_tr = {}
                    
                                    data_tr['selectLink'] = ditem2['billing_identifier'] + ' 同時実行数：' + ditem2['quantity']
                                    
                                    filtersT2.append(data_tr)
                
                                user_info['contract_product_request'] = filtersT2
                                
                                logger.debug('# **************0611****E************')
                                
                                logger.debug('# **************0702****S************')
                                user_info['tenant'] = data_t_crc['tenant']
                                logger.debug('# **************0702****E************')

                                return user_info

                                logger.debug(
                                    '# ##############################')
                            else:
                                pass

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')
                            logger.debug('# 「ワークショップ申込ID」登録されている場合')
                            logger.debug('# 「本契約申込ID」登録されて無い場合')

                            if d['workshop_req_id'] is not None and \
                                    d['contract_req_id'] is None and \
                                    d['contract_id'] is None:

                                logger.debug('# ワークショップ申込履歴(作成日が新しいもの)')

                                logger.debug(
                                    '# ******************************')

                                logger.debug(
                                    '# テーブル「ワークショップ申込情報（確認済み）」からデータ取得')
                                logger.debug('# t_workshop_request_confirmed')

                                # from ..model.t_workshop_request_confirmed import Sub as TWRC
                                # t_wrc = TWRC()
                                TWRC = GV.get_module(
                                    't_workshop_request_confirmed')
                                t_wrc = TWRC()

                                logger.debug('# 検索条件')
                                filters = []
                                filters.append(t_wrc.model_class.workshop_req_id ==
                                               d['workshop_req_id'])
                                filters = and_(*filters)

                                tmp_t_wrc = t_wrc._get_item_by_filters(filters)

                                if tmp_t_wrc is None:
                                    raise CustomException('SYS_ERR_100')
                                    pass

                                data_t_wrc = tmp_t_wrc.to_dict()

                                logger.debug(data_t_wrc)

                                user_info['company_name'] = data_t_wrc['company_name'] or ''
                                user_info['contract_zip_code'] = data_t_wrc['zip_code'] or ''
                                user_info['contract_address_pref'] = data_t_wrc['address_pref'] or ''
                                user_info['contract_address_1'] = data_t_wrc['address_1'] or ''
                                user_info['contract_address_2'] = data_t_wrc['address_2'] or ''
                                user_info['contract_address_3'] = data_t_wrc['address_3'] or ''
                                user_info['contract_last_name'] = data_t_wrc['last_name'] or ''
                                user_info['contract_first_name'] = data_t_wrc['first_name'] or ''
                                user_info['contract_first_name'] = data_t_wrc['first_name'] or ''
                                user_info['contract_affiliation_department'] = data_t_wrc['affiliation_department'] or ''
                                user_info['contract_email_address'] = data_t_wrc['email_address'] or ''
                                user_info['contract_telephone_number'] = data_t_wrc['telephone_number'] or ''

                                return user_info

                                logger.debug(
                                    '# ##############################')
                            else:
                                pass

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')
                            logger.debug('# 「トライアル申込ID」だけ登録されている場合')
                            logger.debug('# トライアル申込履歴(作成日が新しいもの)')

                            if d['trial_req_id'] is not None and \
                                d['workshop_req_id'] is None and \
                                d['contract_req_id'] is None and \
                                    d['contract_id'] is None:

                                logger.debug(
                                    '# ******************************')

                                logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ取得')
                                logger.debug('# t_trial_request_confirmed')

                                # from ..model.t_trial_request_confirmed import Sub as TTRC
                                # t_trc = TTRC()
                                TTRC = GV.get_module(
                                    't_trial_request_confirmed')
                                t_trc = TTRC()

                                logger.debug('# 検索条件')
                                filters = []
                                filters.append(t_trc.model_class.trial_req_id ==
                                               d['trial_req_id'])
                                filters = and_(*filters)

                                tmp_t_trc = t_trc._get_item_by_filters(filters)

                                if tmp_t_trc is None:
                                    raise CustomException('SYS_ERR_100')
                                    pass

                                data_t_trc = tmp_t_trc.to_dict()

                                logger.debug(data_t_trc)

                                user_info['company_name'] = data_t_trc['company_name'] or ''
                                user_info['contract_last_name'] = data_t_trc['last_name'] or ''
                                user_info['contract_first_name'] = data_t_trc['first_name'] or ''
                                user_info['contract_email_address'] = data_t_trc['email_address'] or ''
                                user_info['contract_telephone_number'] = data_t_trc['telephone_number'] or ''

                                logger.debug(
                                    '# ##############################')

                                return user_info
                            else:
                                pass

                            # 或いは

                            # if d['company_code'][0] != 'K':
                            #     logger.debug('# 「company_code」が「K」から始まらない場合、トライアル')
                            #     logger.debug('# トライアル申込履歴(作成日が新しいもの)')

                            #     logger.debug('# ******************************')

                            #     logger.debug('# テーブル「トライアル申込情報（確認済み）」からデータ取得')
                            #     logger.debug('# t_trial_request_confirmed')

                            #     from ..model.t_trial_request_confirmed import Sub as TTRC
                            #     t_trc = TTRC()

                            #     logger.debug('# 検索条件')
                            #     filters = []
                            #     filters.append(t_trc.model_class.system_id == GV.SYSTEM_ID)
                            #     filters.append(t_trc.model_class.service_id == GV.SERVICE_ID)
                            #     filters.append(t_trc.model_class.email_address ==
                            #                    GV.LOGGEDIN_USER['email'])
                            #     filters = and_(*filters)

                            #     logger.debug('# 並び替え 開催日順')
                            #     col = getattr(t_trc.model_class, 'cdate', None)
                            #     order_by = desc(col)

                            #     tmp_t_trc = t_trc._get_item_by_filters(
                            #         filters, order_by=order_by)

                            #     if tmp_t_trc is None:
                            #         raise CustomException('SYS_ERR_100')
                            #         pass

                            #     data_t_trc = tmp_t_trc.to_dict()

                            #     logger.debug(data_t_trc)

                            #     return data_t_trc

                            #     logger.debug('# ##############################')

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

        return {
            'body': 'OK'
        }

    def get_staff_info(self, data=None):
        print("|||get_staff_info|||")

        logger.debug(data)

        staff_info = {}

        try:
            logger.debug('# ******************************')
            logger.debug('# スタッフ情報を取得する')
            # logger.debug(GV.LOGGEDIN_USER)
            if GV.LOGGEDIN_USER is None:
                return {}

            logger.debug(GV.LOGGEDIN_USER)
            logger.debug('# ******************************')

            logger.debug('# テーブル「Auth0ユーザー情報管理」からデータ取得する')
            logger.debug('# m_auth_user_info')

            params_m_aui = {
                'table_name': 'm_auth0_user_info',
                'filters': {
                    'auth0_user_id': GV.LOGGEDIN_USER['sub'],
                    'company_code': GV.STAFF_COMPANY_CODE,
                    'system_id': GV.STAFF_SYSTEM_ID,
                    'service_id': GV.STAFF_SERVICE_ID
                }
            }
            logger.debug(params_m_aui)   
            data_m_aui = self.get_data(params_m_aui)
            logger.debug(data_m_aui)

            roles = None
            if data_m_aui and \
                    data_m_aui['roles'] is not None and \
                    data_m_aui['roles'].strip() != '':
                roles = json.loads(data_m_aui['roles'])

            if roles is not None:
                staff_info['roles'] = roles

            logger.debug('# roles')
            logger.debug(roles)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# 「システムID」を取得する')
            logger.debug('# テーブル「システムマスタ」からデータ検索')
            logger.debug('# m_systems')

            sub_domain_names = []
            if roles is not None:
                for r in roles:
                    if r == GV.ROLES_ADMIN_STAFF:
                        pass
                    else:
                        l = r.split('_')
                        if len(l) > 1:
                            sub_domain_names.append(l[0])

            logger.debug(sub_domain_names)

            # from ..model.m_systems import Sub as MSYS
            # m_sys = MSYS()
            MSYS = GV.get_module('m_systems')
            m_sys = MSYS()

            logger.debug(m_sys)

            filters = []
            logger.debug(roles)
            if GV.ROLES_ADMIN_STAFF in roles:
                logger.debug('''# 管理者用は制限なしです。''')
                filters = and_(*filters)
                pass
            else:
                logger.debug('''# 一般スタッフの場合''')

                filters.append(
                    m_sys.model_class.sub_domain_name.in_(sub_domain_names))
                filters = and_(*filters)

            logger.debug('''# デフォルト値は担当しているシステムのうちシステムIDが
                         最小のものにしてください(システムID昇順でドロップダウンリストに表示)''')

            col = getattr(m_sys.model_class, 'system_id', None)
            order_by = col

            logger.debug('''# 検索実施''')
            tmp_m_sys = m_sys._get_item_by_filters(
                filters, order_by, get_all=True)
            logger.debug(tmp_m_sys)

            if tmp_m_sys is None:
                pass
                raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            systems = []
            for t in tmp_m_sys:
                d = t.to_dict()
                systems.append(
                    {
                        'system_id': d['system_id'],
                        'system_name': d['system_name'],
                        'sub_domain_name': d['sub_domain_name']
                    }
                )

            staff_info['systems'] = systems

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

        return staff_info

    # change_admin_user
    def change_admin_user(self, data=None):
        logger.debug('# change_admin_user')

        logger.debug(data['company_code'])
        logger.debug(data['old_email_address'])
        logger.debug(data['new_email_address'])

        try:
            logger.debug('# ******************************')
            logger.debug('# t_manage_request を更新する')
            
            strTenant = ''

            TMR = GV.get_module('t_manage_request')
            t_mr = TMR()

            filters = []
            filters.append(t_mr.model_class.system_id == GV.SYSTEM_ID)
            filters.append(t_mr.model_class.service_id == GV.SERVICE_ID)
            filters.append(t_mr.model_class.company_code == data['company_code'])
            filters.append(t_mr.model_class.auth0_user_id == data['old_email_address'])
            filters = and_(*filters)

            tmp_t_mr = t_mr._get_item_by_filters(filters)

            if tmp_t_mr is not None:
                data_t_mr = tmp_t_mr.to_dict()

                data_t_mr['auth0_user_id'] = data['new_email_address']

                t_mr._update(data_t_mr)
            
            logger.debug('# ##############################')
        
            logger.debug('# ******************************')
            logger.debug('# Auth0アカウントがすでに存在するかどうか確認する')

            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()
            users_auth0 = a0._get_users_by_email(data['new_email_address'])

            is_new_auth0_user = False
            data_auth0 = None

            if users_auth0 and len(users_auth0) > 0:
                # 存在する場合
                logger.debug('存在する場合')
                # raise CustomException('ACCOUNT_ERR_ACCOUNT_EXIST')

                data_auth0 = users_auth0[0]

            logger.debug('data_auth0')
            logger.debug(data_auth0)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if data_auth0 is None:

                logger.debug('# Auth0アカウントを作成する')
                logger.debug('# create_data_atuh0')

                param_auth0 = {}
                param_auth0['email_address'] = data['new_email_address']

                logger.debug('# param_auth0')
                logger.debug(param_auth0)

                data_auth0 = self.create_data_atuh0(param_auth0)

                is_new_auth0_user = True

            logger.debug('data_auth0')
            logger.debug(data_auth0)

            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# m_auth0_user_info')
            logger.debug('変更前のユーザーの情報と同じデータを追加する')

            MAUI = GV.get_module('m_auth0_user_info')
            m_aui = MAUI()

            filters = []
            filters.append(m_aui.model_class.system_id == GV.SYSTEM_ID)
            filters.append(m_aui.model_class.service_id == GV.SERVICE_ID)
            filters.append(m_aui.model_class.company_code == data['company_code'])
            filters.append(m_aui.model_class.auth0_user_id == data['old_email_address'])
            filters = and_(*filters)
            tmp_m_aui = m_aui._get_item_by_filters(filters, get_all=True)
            logger.debug('tmp_m_aui')
            logger.debug(tmp_m_aui)

            if tmp_m_aui is not None and len(tmp_m_aui) > 0:
                for t in tmp_m_aui:
                    d = t.to_dict()
                    logger.debug(d)
                    
                    strTenant =  d['tenant']
                    
                    del d['auth_user_info_id']
                    d['auth0_user_id'] = data['new_email_address']
                    # d['roles'] = json.loads(d['roles'])

                    logger.debug(d)

                    if GV.ROLES_REQUEST_USER in d['roles']:
                        pass
                    else:
                        tmp_m_aui_add = m_aui._add(d)
                        if tmp_m_aui_add is None:
                            logger.debug('change_admin_user m_auth0_user_info add 失敗')
                            logger.debug(d)
                            raise CustomException('SYS_ERR_100')
                    
            logger.debug('# ##############################')
            
            
            
            logger.debug('# ************0704******************') 
            if strTenant != '':
                params = {
                    'table_name': 'm_auth0_management',
                    'filters': {
                        'tenant': strTenant
                    }
                }
                data_m_am = self.get_data(params)
                logger.debug(data_m_am)
    
                if data_m_am:
                    logger.debug('# ************Auth0情報を設定する******************')
                    GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                    GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                    GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                    GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                    GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                    GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                    logger.debug(GV.CONFIG)
                    pass
                else:
                    return {"error": "tenant:" + strTenant + " は存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 

            logger.debug('# ******************************')
            logger.debug('# m_auth0_user_info')
            logger.debug('変更前のユーザーの情報を更新する')

            MAUI = GV.get_module('m_auth0_user_info')
            m_aui = MAUI()

            filters = []
            filters.append(m_aui.model_class.system_id == GV.SYSTEM_ID)
            filters.append(m_aui.model_class.service_id == GV.SERVICE_ID)
            filters.append(m_aui.model_class.company_code == data['company_code'])
            filters.append(m_aui.model_class.auth0_user_id == data['old_email_address'])
            filters = and_(*filters)
            tmp_m_aui = m_aui._get_item_by_filters(filters, get_all=True)
            logger.debug('tmp_m_aui')
            logger.debug(tmp_m_aui)

            if tmp_m_aui is not None and len(tmp_m_aui) > 0:
                for t in tmp_m_aui:
                    d = t.to_dict()
                    logger.debug(d)
                    
                    logger.debug(d)

                    if GV.ROLES_ADMIN_USER in d['roles']:
                        tmp_m_aui_delete = m_aui._delete(d)
                        if tmp_m_aui_delete is None:
                            logger.debug('change_admin_user m_auth0_user_info delete 失敗')
                            logger.debug(d)
                            raise CustomException('SYS_ERR_100')

                    
            logger.debug('# ##############################')
            
            logger.debug('# ******************************')
            logger.debug('# m_directory_user')
            logger.debug('変更前のユーザーのメールアドレスを置き換える')

            MDU = GV.get_module('m_directory_user')
            m_du = MDU()

            filters = []
            filters.append(m_du.model_class.company_code == data['company_code'])
            filters.append(m_du.model_class.user_email == data['old_email_address'])
            filters = and_(*filters)
            tmp_m_du = m_du._get_item_by_filters(filters)

            if tmp_m_du is not None:
                data_m_du = tmp_m_du.to_dict()
                data_m_du['user_email'] = data['new_email_address']

                tmp_m_du_update = m_du._update(data_m_du)
                if tmp_m_du_update is None:
                    logger.debug('change_admin_user m_directory_user update 失敗')
                    logger.debug(data_m_du)
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# 新しいシステム管理者のAuth0アカウントが作成される場合':

                if is_new_auth0_user:

                    logger.debug('# 招待メールはフェーズ2の仕様なのでフェーズ3にはないです。')
                    logger.debug('# Auth0のアカウントが無い場合は有効期限なしでパスワード設定が可能なメールの送信を行うよう仕様変更します。')
                    logger.debug('# 申込内容修正サイトでシステム管理者を変更して、新しいシステム管理者のAuth0アカウントが作成される場合は')
                    logger.debug('# 「システム管理者変更連絡」の代わりに「システム管理者変更連絡_アカウント作成」を送信してください。')

                    logger.debug('# m_directory_user')
                    logger.debug('変更前のユーザーのメールアドレスを置き換える')

                    import uuid
                    code = str(uuid.uuid4())

                    logger.debug('# 認証コード生成')
                    logger.debug('# ************0704******************') 
                    code = 'a-' + str(data_m_am['id']) + '-' + code
                    logger.debug('# ************0704******************')

                    if data_auth0 is not None:
                        logger.debug('# Auth0アカウントがある場合')
                        logger.debug(data_auth0)

                        user_id = data_auth0['user_id']

                        app_metadata = None

                        if 'app_metadata' in data_auth0:

                            logger.debug(data_auth0['app_metadata'])

                            app_metadata = data_auth0['app_metadata']
                        
                        else:

                            app_metadata = {}
                        

                        if 'data' not in app_metadata:
                            app_metadata['data'] = []

                        app_metadata['data'].append(
                            {
                                'change_admin_user_vefification_code': code
                            }
                        )

                        data_auth0_update = {}
                        data_auth0_update['app_metadata'] = app_metadata

                        logger.debug('# ******************************')
                        logger.debug('# atuh0 update')
                        a0._update(user_id, data_auth0_update)
                        logger.debug('# ##############################')

                        pass

                    logger.debug('# ******************************')
                    logger.debug('# システム管理者変更連絡 システム管理者変更連絡_アカウント作成 メール送信')

                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'システム管理者変更連絡_アカウント作成'

                    data_email['email_address'] = data['new_email_address']
                    data_email['company_name'] = data['company_name']
                    data_email['administrator_name_last'] = data['administrator_name_last']
                    data_email['administrator_name_first'] = data['administrator_name_first']
                    data_email['entry_code'] = data['entry_code']
                    data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                    data_email['login_url'] = GV.URL_CLOUD_SERVICE_PORTAL

                    self.send_email_account(data_email)

                    logger.debug('# ##############################')
                    
            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

        return {}
    

    def send_email_account(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_account')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if 'email_address' in data:
                mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id'])
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}

            # ???
            result = self.send_email(mail_template, mail_parameter)

            return result

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')