DEV_ENV = 'prod'

import json
from six.moves.urllib.request import urlopen
from jose import jwt as jose_jwt
import jwt
import http
import base64
import logging

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

if DEV_ENV == 'local':
    from .lambda_function import GV
    # from .env import *
else:
    from lambda_function import GV
    # from env import *
    
ALGORITHMS = ["RS256"]

# Format error response and append status code


def get_token_auth_header(auth):
    """Authorizationヘッダーからアクセストークンを取得
    """

    token = None

    if not auth:
        # Authorization ヘッダーが必要です
        print({"code": "authorization_header_missing",
              "description": "Authorization header is expected"})
        return token

    parts = auth.split()

    if parts[0].lower() != "bearer":
        # Authorization ヘッダーは Bearer で始まる必要があります
        print({"code": "invalid_header",
              "description": "Authorization header must start with Bearer"})
        return token
    elif len(parts) == 1:
        # トークンが見つかりません
        print({"code": "invalid_header", "description": "Token not found"})
        return token
    elif len(parts) > 2:
        # Authorization ヘッダーは Bearer トークンでなければなりません
        print({"code": "invalid_header",
              "description": "Authorization header must be Bearer token"})
        return token

    token = parts[1]
    return token

def parse_id_token(id_token):
    try:
        # 解析ID token
        ENTRA_ENDPOINT = "graph.microsoft.com"
        conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {id_token}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")

        conv_dic = json.loads(data)
        print(conv_dic)
        auth_dic={}

        auth_dic['user_id']=conv_dic['id']
        auth_dic['sub']=conv_dic['mail']
        auth_dic['username']=conv_dic['userPrincipalName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['email']=conv_dic['mail']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata'] = {'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
        
        #Attribute2はJSONではないと仮定
        auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']

        conn.close()
        return auth_dic
    
    except:
        # 解析错误
        return None

def requires_auth(event, context=None):
    """アクセス トークンが有効かどうかを判断します
    """

    # # !!!
    # # 社内環境で場合
    # effect = 'Allow'
    # return effect
    # # !!!

    user_metadata = None
    effect = 'Deny'

    auth = None
    if 'Authorization' in event['headers']:
        auth = event['headers']['Authorization']
    if 'authorization' in event['headers']:
        auth = event['headers']['authorization']
    token = get_token_auth_header(auth)
    
    # print('token<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<')
    # print(token)
    
    if token is None:
        pass
    else:
        ENTRA_ENDPOINT = "graph.microsoft.com"
        conn = http.client.HTTPSConnection(ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {token}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")

        conv_dic = json.loads(data)
        logger.debug(conv_dic)
        auth_dic={}

        auth_dic['user_id']=conv_dic['id']
        auth_dic['username']=conv_dic['userPrincipalName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['email']=conv_dic['mail']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata'] = {'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']
        #Attribute2はJSONではないと仮定
        auth_dic['app_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute2']

        conn.close()
        user_metadata = auth_dic['user_metadata']
        effect = 'Allow'

    # print('effect------------------------------')
    # print(effect)

    res = {}
    res['effect'] = effect
    if effect == 'Allow':
        if user_metadata is not None:
            res['user_metadata'] = user_metadata

    return res
