import subprocess
import sys
import datetime
# sys.path.append('/opt/app/MSCOneProject/')
import psycopg2
import requests
import boto3
import csv
import os
import json
import configparser
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText

s3 = boto3.client('s3')

config = configparser.ConfigParser()
config.read('./setting.cfg', 'UTF-8')

DB_NAME = 'msconedb'
DB_HOST = 'dev-rds-datamart-001.cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com'
DB_USER = 'mscone'
DB_PASS = 'NDESpass0'
DB_PORT = '5432'
PROD_DB_NAME ='rds_datamart_msconedb'
PROD_DB_HOST = 'eval-rds-datamart-001.cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com'

COM_DB_NAME = config['COMMON']['DB_NAME']
COM_DB_HOST = config['COMMON']['DB_HOST']
COM_DB_USER = config['COMMON']['DB_USER']
COM_DB_PASS = config['COMMON']['DB_PASSWORD']

# CSV ダブルクォーテーション条件
class CustomFormat(csv.excel):
    quoting = csv.QUOTE_ALL

# FILE_NAME_CPU = 'billing_cpu_'
# FILE_NAME_PRE = 'billing_license_msc_lic_'
# FILE_NAME_SOL = 'billing_server_msc_lic_'
# FILE_NAME_CONT = 'mscone_contract_'
# FILE_NAME_MONTHLY = 'billing_monthly_msc_lic_'
# FILE_NAME_LICENSE = 'simsp_license_'
# FILE_NAME_CLOUD = 'simsp_cloud_'
FILE_NAME_CPU = 'billing_cpu'
FILE_NAME_PRE = 'billing_license_msc_lic'
FILE_NAME_SOL = 'billing_server_msc_lic'
FILE_NAME_CONT = 'mscone_contract'
FILE_NAME_MONTHLY = 'billing_monthly_msc_lic'
FILE_NAME_LICENSE = 'simsp_license'
FILE_NAME_CLOUD = 'simsp_cloud'
EXTENTION = '.csv'
# CSV ヘッダー部
HEADER = ['通番','課金ID','開始日','開始時刻','終了日','終了時刻','発生日時','説明','利用量','削除キー']
HEADER_HI = ['company_code','contract_start','contract_status','mrr_tax','mrr_no_tax','service_class','output_date']

# フェーズ2 ------------------------S
HEADER_NEW = ['project_id','chargingid','product_id','start_day','start_time','end_day','end_time','date_time','explanation','usage','deletionkey']
# フェーズ2 ------------------------E

#ログ出力
# ログファイルの場所
LOG_FILE_DIR=os.getcwd()
#LOG_FILE_DIR='/opt/app/MSCOneProject'
# フェーズ2 ------------------------S
LOG_FILE_DIR='/tmp'
# フェーズ2 ------------------------E
LOG_FOLDER = LOG_FILE_DIR + '/' + 'logs'+ '/' + datetime.date.today().strftime('%Y')
LOG_FILEPATH = LOG_FOLDER + '/' + datetime.date.today().strftime('%Y%m') + '.txt'

#ログファイル初期化
from logging import getLogger, StreamHandler, Formatter, FileHandler, DEBUG
def setup_logger(log_folder=LOG_FILEPATH, modname=__name__):
    if not os.path.exists(LOG_FOLDER):
        os.makedirs(LOG_FOLDER)
    logger = getLogger(modname)
    logger.setLevel(DEBUG)

    sh = StreamHandler()
    sh.setLevel(DEBUG)
    formatter = Formatter('%(asctime)s, %(levelname)s %(message)s')
    sh.setFormatter(formatter)
    logger.addHandler(sh)

    fh = FileHandler(log_folder) #fh = file handler
    fh.setLevel(DEBUG)
    fh_formatter = Formatter('%(asctime)s, %(levelname)s %(message)s')
    fh.setFormatter(fh_formatter)
    logger.addHandler(fh)
    return logger

#ログインスタンス取得
#def get_logger():
#    return _logger

##API送信
def get_api(url, params, headers, api_id, api_pass):
    return requests.get(url=url, params=params, headers=headers, auth=(api_id,api_pass))

def get_api_upload(file, url, params, headers, my_proxies,api_id, api_pass):
    return requests.get(fileName=file, url=url, params=params, headers=headers, auth=(api_id,api_pass), proxies = my_proxies)

def query(sql,data):
    print('local用　query()')
    try:
        with psycopg2.connect(
                "dbname=" + PROD_DB_NAME,
                "host=" + PROD_DB_HOST,
                "user=" + DB_USER,
                "password=" + DB_PASS,
                "port=" + DB_PORT) as conn:
            with conn.cursor() as cur:
                cur.execute(sql, data)
                result = cur.fetchall()
                return result
    except Exception as e:
        print(e.args)
        return

def mscone_query(sql):
    with psycopg2.connect(
            "dbname=rds_datamart_msconedb host=eval-rds-datamart-001.cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com user=mscone password=NDESpass0 port=5432") as conn:
        with conn.cursor() as cur:
            cur.execute(sql)
            result = cur.fetchall()
            return result

# ローカル開発用
def query_local(sql,data):
    print('query_local')
    try:
        with psycopg2.connect(
                "dbname=rds_datamart_msconedb host=localhost user=mscone password=NDESpass0 port=123") as conn:
            with conn.cursor() as cur:
                cur.execute(sql,data)
                result = cur.fetchall()
                return result
    except Exception as e:
        print(e.args)

def mscone_query_env(sql,db_name,db_host,db_user,db_pass,db_port,data):
    with psycopg2.connect(  "dbname=" + db_name + \
                            " host=" + db_host + \
                            " user=" + db_user + \
                            " password=" + db_pass + \
                            " port=" + db_port) as conn:
        with conn.cursor() as cur:
            if data is None:
                cur.execute(sql)
            else:
                cur.execute(sql, data)
            result = cur.fetchall()
            return result

# 共通PFDB
def common_query(sql):
    try:
        with psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS) as conn:
            with conn.cursor() as cur:
                cur.execute(sql)
                result = cur.fetchall()
                #print(result)
                return result
    except Exception as e:
        print('erro ユーザー管理DB取得失敗')
        print(e.args)
        return
def common_query_param(sql, data):
    try:
        with psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS) as conn:
            with conn.cursor() as cur:
                if data is None:
                    cur.execute(sql)
                else:
                    cur.execute(sql, data)
                result = cur.fetchall()
                #print(result)
                return result
    except Exception as e:
        print('erro ユーザー管理DB取得失敗')
        print(e.args)
        return

"""
INSERT実行
"""
def insert_param(sql, param, db_name, db_host):
    con = psycopg2.connection("dbname=comn_pf_db host=dev-rds-comn-pf-001-instance-1.cfhdc00wr5rm.ap-northeast-1.rds.amazonaws.com user=postgres password=postgresql port=5432")
    try:
        new_id = None
        with con.cursor() as cur:
            cur.execute(sql, param)
            new_id = cur.fetchone()[0]
        con.commit()
        return new_id
    except Exception as e:
        print(e)
        #app.logger.warning('Failed to insertSingle execution. Check the details.: %s, e)

def insert_hs(dic):
    try:
        connect = psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS)
        connect.autocommit = True
        cursor = connect.cursor()
        #DB登録
        sql = '''
                INSERT 
                INTO "billing_infrastructure".billing_upload_history( 
                    file_name,
                    status,
                    remarks,
                    capture_date
                )
                VALUES (
                    %(file_name)s,
                    %(status)s,
                    %(remarks)s,
                    %(capture_date)s
                )
                RETURNING upload_id;
        '''
        cursor.execute(sql, dic)
        new_id = cursor.fetchone()[0]

    except Exception as e:
        print('利用量の履歴テーブル登録失敗')
        print(e)

    return new_id

# 課金アップロード履歴の更新
# ステータス、メッセージ
def update_billing_history(dic):
    try:
        connect = psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS)
        connect.autocommit = True
        cursor = connect.cursor()
        #DB登録
        sql = '''
                UPDATE "billing_infrastructure".billing_upload_history
                SET status = %(status)s, remarks = %(remarks)s
                WHERE upload_id = %(upload_id)s
                RETURNING upload_id;
        '''
        cursor.execute(sql, dic)
    except Exception as e:
        print('利用量の履歴テーブル更新の失敗 common.update_billing_history()')
        print(e)

def insert_billing_information(arry):
    try:
        print('insert_billing_information() start')
        connect = psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS)
        connect.autocommit = True
        cursor = connect.cursor()
        print(arry)      #DB登録
        sql = '''
                INSERT 
                INTO "billing_infrastructure".billing_information( 
                    upload_id,
                    serial_number,
                    chargingid,
                    contract_product_id,
                    contract_id,
                    start_date,
                    end_date,
                    usage,
                    usage_h,
                    amount,
                    deletion_key,
                    dateandtimeofoccurrence,
                    registrationsituation
                )
                VALUES ( 
                    %(upload_id)s, 
                    %(serial_number)s, 
                    %(chargingid)s,
                    %(contract_product_id)s,
                    %(contract_id)s,
                    %(start_date)s, 
                    %(end_date)s, 
                    %(usage)s,
                    %(usage_h)s,
                    %(amount)s,
                    %(deletion_key)s,
                    %(dateandtimeofoccurrence)s,
                    %(registrationsituation)s
                );
        '''
        cursor.execute(sql, arry)
        
    except Exception as e:
        print(e)
    finally:
        cursor.close()
        connect.close()
        print('insert_billing_information() end')

def insert_billing_information_new(arry):
    try:
        print('insert_billing_information_new() start')
        connect = psycopg2.connect(database=COM_DB_NAME, user=COM_DB_USER, host=COM_DB_HOST, password=COM_DB_PASS)
        connect.autocommit = True
        cursor = connect.cursor()
        print(arry)      #DB登録
        sql = '''
                INSERT 
                INTO "billing_infrastructure".billing_information( 
                    upload_id,
                    serial_number,
                    system_name,
                    chargingid,
                    contract_product_id,
                    contract_id,
                    start_date,
                    end_date,
                    usage,
                    amount,
                    deletion_key,
                    dateandtimeofoccurrence,
                    registrationsituation
                )
                VALUES ( 
                    %(upload_id)s, 
                    %(serial_number)s, 
                    %(system_name)s,
                    %(chargingid)s,
                    %(contract_product_id)s,
                    %(contract_id)s,
                    %(start_date)s, 
                    %(end_date)s, 
                    %(usage)s,
                    %(amount)s,
                    %(deletion_key)s,
                    %(dateandtimeofoccurrence)s,
                    %(registrationsituation)s
                );
        '''
        cursor.execute(sql, arry)
        
    except Exception as e:
        print(e)
    finally:
        cursor.close()
        connect.close()
        print('insert_billing_information_new() end')


# 契約商品情報を取得する
def get_contract_product(data):
    sql_str = '''
            WITH tab as (
                SELECT com.company_code,
                    con.contract_id,
                    userprod.contract_product_id,
                    prod.product_code,
                    con.contract_id || prod.product_code as chargingid,
                    prod.applicable_start_date AS sales_start_date,
                    prod.applicable_end_date AS salese_end_date,
                    prod.calc_method,
                    prod.system_id,
                    prod.system_name,
                    con.subscription_start_date,
                    con.subscription_end_date,
                    prod.calc_unit,
                    prod.one_off_payment
                FROM ((user_infrastructure.m_company com
                    JOIN user_infrastructure.m_contract con ON (((com.company_code)::text = (con.company_code)::text)))
                    JOIN user_infrastructure.m_contract_product userprod ON (((con.contract_id)::text = (userprod.contract_id)::text)))
                    JOIN ( SELECT reg.product_id,
                            reg.product_code,
                            reg.product_name,
                            reg.billing_identifier,
                            reg.applicable_start_date,
                            reg.applicable_end_date,
                            reg.calc_method,
                            reg.calc_unit,
                            reg.one_off_payment,
                            reg.catalog_amount,
                            reg.udate,
                            ser.service_name,
                            sys.system_id,
                            sys.system_name
                           FROM ((billing_infrastructure.m_regular_products reg
                             JOIN billing_infrastructure.m_services ser ON (((reg.service_id)::text = (ser.service_id)::text)))
                             JOIN billing_infrastructure.m_systems sys ON (((reg.system_id)::text = (sys.system_id)::text)))
                           WHERE
                                %(target_date)s between reg.applicable_start_date and reg.applicable_end_date
                                or (%(target_date)s >= reg.applicable_start_date and reg.applicable_end_date IS NULL)
                           ) prod
                    ON ((prod.product_id)::text = (userprod.product_id)::text) 
                    AND (con.applicable_start_date >= prod.applicable_start_date)
                )
					select to_json(tab)
                	from tab
    '''
    return common_query_param(sql_str, data)

# Phase3 ADD START
# 企業コードと商品コードから契約IDを取得する
def get_contract_id(company_code, product_code):
    data = {}
    data['company_code'] = company_code
    data['product_code'] = product_code
    sql_str = '''
            WITH tab as (
                SELECT mc.company_code,
                    mcp.product_id,
                    mrp.product_code,
                    mc.contract_id
                FROM ((user_infrastructure.m_contract_product mcp
                    JOIN user_infrastructure.m_contract mc ON (((mcp.contract_id)::text = (mc.contract_id)::text)))
                    JOIN billing_infrastructure.m_regular_products mrp ON (((mcp.product_id)::text = (mrp.product_id)::text)))
                WHERE
                    mc.company_code = %(company_code)s
                AND
                    mrp.product_code = %(product_code)s
                )
					select to_json(tab)
                	from tab
    '''
    return common_query_param(sql_str, data)    
# Phase3 ADD END

# Phase3 ADD START
# 契約情報を取得する
def get_m_contract_company_code(company_code, target_date):
    
    print('get_m_contract_company_code() ------------------------------')
    try:
        strCompany_list = "'" + "','".join(company_code) + "'"
        sql = '''
            WITH tab as (
                select
                    distinct(con.company_code) as project_id
                from user_infrastructure.m_contract con
                where
                    con.subscription_name='Simulation-Space' and company_code IN ( ''' + strCompany_list + ''') AND 
            ('target_date' between con.subscription_start_date AND con.subscription_end_date
            OR ('target_date' >= con.subscription_start_date AND con.subscription_end_date IS NULL))
            )
            select to_json(tab)
            from tab                    
        '''
        sql_str_fr = sql.replace('target_date', target_date)
        print(sql_str_fr)
        return common_query_param(sql_str_fr, company_code)  
    except Exception as e:
        print('get_m_contract_company_code() ERROR')
        print(e.args)
# Phase3 ADD END


### GET Mail Address
def get_error_mail_address():
    sql = '''
        with tab as (
                select
                    mail_to
                    , mail_cc
                    , mail_send_from
                    , mail_subject
                    , mail_body
                from
                    user_infrastructure.m_send_mail
                where
                    mail_type = '利用量登録失敗(1回目)'
        ) select to_json(tab) from tab;
    '''
    return common_query(sql)

def get_error_mail_address_id(data):
    sql = '''
        with tab as (
                select
                    mail_to
                    , mail_cc
                    , mail_send_from
                    , mail_subject
                    , mail_body
                from
                    user_infrastructure.m_send_mail
                where
                    mail_id = %(mail_id)s
        ) select to_json(tab) from tab;
    '''
    return common_query_param(sql, data)

##API送信
def get_api(url, params ,headers , my_proxies,api_id,api_pass):
    return requests.get(url=url, params = params, headers=headers, auth=(api_id,api_pass), proxies = my_proxies)

def get_api_url(url, headers , my_proxies,api_id,api_pass):
    return requests.get(url=url, headers=headers, auth=(api_id,api_pass), proxies = my_proxies)

def post_api(url, params ,headers , my_proxies,api_id,api_pass):
    return requests.post(url=url, params = json.dumps(params), headers=headers, auth=(api_id,api_pass), proxies = my_proxies)

def post(auth_key_encoded, path, tenant_id, url, proxy, chargeType, sourceService):
    try:
        r = subprocess.check_output(["./post.sh", auth_key_encoded.decode('utf-8'), path, tenant_id, url, proxy,chargeType, sourceService])
        r = r.decode('utf-8').replace('\n', '')
        print(r)
    except Exception as e:
        print('課金情報ファイルのアップロードに失敗しました。[common_func.post()]')
        print(e.args)
        return
    return r

##カタログ情報（通常商品）検索（料⾦情報履歴取得）
def get_productlist(url, params,headers, api_id, api_pass):
    res =get_api(url, params, headers, api_id, api_pass)
    print(res.status_code)
    if str(res.status_code) == '200':
        print('Success')
        print(res.text)
    else:
        print('Failure')
        print(res.text)

    return res
# 月初の日付を取得
def get_first_date(dt):
    return dt.replace(day=1).strftime("%Y-%m-%d")
# 月末の日付を取得
def get_last_date(dt):
    return (dt + datetime.timedelta(days=-1)).strftime("%Y-%m-%d")

# 前日の日付を取得
def get_yesterday():
    return str((datetime.datetime.today() - datetime.timedelta(1)).strftime("%Y%m%d"))

def get_YYYY_MM_beforeMonth():
    today = datetime.datetime.today()
    thismonth = datetime.datetime(today.year, today.month, 1)
    lastmonth = thismonth + datetime.timedelta(days=-1)
    return lastmonth.replace(day=1).strftime("%Y-%m")

def check_key_of_s3(bucket_name: str, dir: str):
    result = s3.list_objects(Bucket=bucket_name, Prefix=dir)
    if not "Contents" in result:
        s3.put_object(Bucket=bucket_name, Key=dir)

def create_file_name(path:str, file_name: str):
    d_today = datetime.date.today() + datetime.timedelta(days=-1)
    #str_key = create_key(d_today,path)
    return create_filename(d_today, file_name)

def create_filename(d_today :datetime, file_name: str):
    # Create download File Name
    file_name = file_name + str(d_today) + '.csv'
    #file_name = FILENAME_STR + '2021-07-30.csv'
    print(file_name)
    return file_name

def create_s3_key(path: str):
    d_today = datetime.date.today() + datetime.timedelta(days=-1)
    # date today
    str_year = str(d_today)[0:4]
    str_month = str(d_today)[5:7]
    str_key = path + '/year=' + str_year + '/month=' + str_month + '/'
    # str_key = KEY + '/year=2021/month=07/'
    print(str_key)
    return str_key

# ルートからファイル名までのパス
def create_local_fulpath(path, val:str, target_date=None):
    date = ''
    if target_date == '' or target_date == None:
        date = get_yesterday()
    else:
        date = (datetime.datetime.strptime(target_date, '%Y-%m-%d')).strftime("%Y%m%d")

    # if 'cpu' == val:
    #     filename = path + FILE_NAME_CPU + date + EXTENTION
    # elif 'pre' == val:
    #     filename = path + FILE_NAME_PRE + date + EXTENTION
    # elif 'sol' == val:
    #     filename = path + FILE_NAME_SOL + date + EXTENTION
    # elif 'month' == val:
    #     filename = path + FILE_NAME_MONTHLY + date + EXTENTION
    # else:
    #     filename = path + FILE_NAME_CONT + date + EXTENTION
    if 'cpu' == val:
        filename = path + date + '_' + FILE_NAME_CPU + EXTENTION
    elif 'pre' == val:
        filename = path + date + '_' + FILE_NAME_PRE + EXTENTION
    elif 'sol' == val:
        filename = path + date + '_' + FILE_NAME_SOL + EXTENTION
    elif 'month' == val:
        filename = path + date + '_' + FILE_NAME_MONTHLY + EXTENTION
    else:
        filename = path + date + '_' + FILE_NAME_CONT + EXTENTION
    print(filename)
    return filename
# CSVのファイル名を返します。
def creat_file_name(val:str, target_date=None):
    date = ''
    if target_date == '' or target_date == None:
        date = get_yesterday()
    else:
        date = (datetime.datetime.strptime(target_date, '%Y-%m-%d')).strftime("%Y%m%d")

    # if 'cpu' == val:
    #     filename = FILE_NAME_CPU + date + EXTENTION
    # elif 'pre' == val:
    #     filename = FILE_NAME_PRE + date + EXTENTION
    # elif 'sol' == val:
    #     filename = FILE_NAME_SOL + date + EXTENTION
    # elif 'license' == val:
    #     filename = FILE_NAME_LICENSE + date + EXTENTION
    # elif 'cloud' == val:
    #     filename = FILE_NAME_CLOUD + date + EXTENTION
    # elif 'month' == val:
    #     filename = FILE_NAME_MONTHLY + date + EXTENTION
    # else:
    #     filename = FILE_NAME_CONT + date + EXTENTION
    if 'cpu' == val:
        filename = date + '_' + FILE_NAME_CPU + EXTENTION
    elif 'pre' == val:
        filename = date + '_' + FILE_NAME_PRE + EXTENTION
    elif 'sol' == val:
        filename = date + '_' + FILE_NAME_SOL + EXTENTION
    elif 'license' == val:
        filename = date + '_' + FILE_NAME_LICENSE + EXTENTION
    elif 'cloud' == val:
        filename = date + '_' + FILE_NAME_CLOUD + EXTENTION
    elif 'month' == val:
        filename = date + '_' + FILE_NAME_MONTHLY + EXTENTION
    else:
        filename = date + '_' + FILE_NAME_CONT + EXTENTION
    print(filename)
    return  filename

def create_csv(data, path):
    try:
        with open(path, 'w') as f:
            writer = csv.writer(f)
            writer.writerow(HEADER)
            writer.writerows(data)
        f.close()
    except Exception as e:
        print('CSVの作成に失敗しました。')
        print(e.args)
    return

def create_csv_at_list_dic(data, filename):
    with open(filename, 'w') as f:
        writer = csv.DictWriter(f,fieldnames=HEADER, delimiter=",", dialect=CustomFormat(), lineterminator='\n')
        writer.writeheader()
        for elem in data:
            writer.writerow(elem)
# フェーズ2 ------------------------S
def create_csv_at_list_dic_new(data, filename):
    with open(filename, 'w') as f:
        writer = csv.DictWriter(f,fieldnames=HEADER_NEW, delimiter=",", dialect=CustomFormat(), lineterminator='\n')
        writer.writeheader()
        for elem in data:
            writer.writerow(elem)
# フェーズ2 ------------------------E

def create_csv_at_list_dic_mscone_contract(data, filename):
    with open(filename, 'w') as f:
        writer = csv.DictWriter(f,fieldnames=HEADER_HI, delimiter=",", lineterminator='\n')
        writer.writeheader()
        for elem in data:
            writer.writerow(elem)

#AWS　SESを使用してメール送信　失敗時の通知用            
def send_mail(title, body, From_ADDRESS, to, cc, bcc):
    client = boto3.client('ses')
    try:
        mail_to = []
        mail_cc = []
        mail_bcc = []
        if not to is None:
            mail_to = to.split(';')          
        if not cc is None:
            mail_cc = cc.split(';')       
        if not bcc is None:
            mail_bcc = bcc.split(';')

        # メール送信
        msg = MIMEMultipart()
        msg["Subject"] = title
        msg["From"] = From_ADDRESS
        if len(mail_to) > 0:
            msg["To"] = ', '.join(mail_to)
        if len(mail_cc) > 0:
            msg["Cc"] = ', '.join(mail_cc)
        if len(mail_bcc) > 0:
            msg["Bcc"] = ', '.join(mail_bcc)
        part = MIMEText(body)      # メッセージBody
        msg.attach(part)

        client.send_raw_email(
                    RawMessage={
                        "Data": msg.as_string(),
                    },
                    Destinations=[],
                )
    except Exception as e:
        print(e.args)

def log_upload(bucket, S3_path):
    try:
        bucket.upload_file(LOG_FILEPATH, S3_path)
        return 'success'
    except Exception as e:
        print('ログファイルのアップロードに失敗しました。')
        print(e.args)
        return 'failed'