from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_workshop'
    primary_key_columns = ['workshop_req_id']
    exclude_search_columns = []
    is_view = True


    def after_get_all(self, items):

        for item in items:

            if item.credit_check == True:
                item.credit_check = 'OK'
            elif item.credit_check == False:
                item.credit_check = 'NG'
            else:
                item.credit_check = None

            if item.prospect_request == True:
                item.prospect_request = 'OK'
            elif item.prospect_request == False:
                item.prospect_request = 'NG'
            else:
                item.prospect_request = None

            # ワークショップ実施日
            if item.workshop_event_result_date:
                item.workshop_event_result_date = item.workshop_event_result_date.strftime(
                    '%Y/%m/%d %H:%M')
            # 信用調査結果登録日
            if item.credit_check_regist_date:
                item.credit_check_regist_date = item.credit_check_regist_date.strftime(
                    '%Y/%m/%d')
            # プロスペクト申請結果登録日
            if item.prospect_request_regist_date:
                item.prospect_request_regist_date = item.prospect_request_regist_date.strftime(
                    '%Y/%m/%d')
            
        pass
