from .view import Base, GV

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'view_contract_workshop_list'
    primary_key_columns = ['workshop_req_id']
    exclude_search_columns = []
    is_view = True

    def after_get_all(self, items):

        for item in items:

            # ワークショップ開催日
            if item.workshop_event_date:
                item.workshop_event_date = item.workshop_event_date.strftime(
                    '%Y/%m/%d')

            # ワークショップ時刻区分
            if item.workshop_event_time_division:
                if item.workshop_event_time_division == 'AM':
                    item.workshop_event_time_division = '午前'
                elif item.workshop_event_time_division == 'PM':
                    item.workshop_event_time_division = '午後'
                else:
                    item.workshop_event_time_division = ''
