DEV_ENV = 'prod'

import os
import json
from datetime import datetime, timezone, timedelta, date
from sqlalchemy import and_, or_, asc, desc, not_
import importlib
import re

PATH_MODEL = 'model'

if DEV_ENV == 'local':
    from .lambda_function import DEV_ENV, GV, CustomException, boto3, logging
    PATH_MODEL = '..' + PATH_MODEL
else:
    from lambda_function import DEV_ENV, GV, CustomException, boto3, logging
    PATH_MODEL = PATH_MODEL

logger = logging.getLogger(__name__)
# logger.setLevel(logging.DEBUG)

# 基底クラス
class Base:

    NOW = datetime.now()

    VALIDATION_METHODS = {
        # 必須
        'required': lambda val: (val is not None and val is not None and len(str(val)) > 0) or '必須項目です。',
        # メールアドレス
        'email': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or (re.match(r"^[a-zA-Z0-9_.+-]+@([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\.)+[a-zA-Z]{2,}$", val) is not None)) or 'メールアドレスが正しくありません。',
        # 全角ひらがな
        'hiragana': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[\u3040-\u309F]*$', val)) or '全角ひらがなを入力してください。',
        # 全角カタカナ
        'zenkakuKatakana': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[\u30A0-\u30FF]*$', val)) or '全角カタカナを入力してください。',
        # 半角カタカナ
        'hankakuKatakana': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[ｦ-ﾟ]+$', val)) or '半角カタカナを入力してください。',
        # 全角
        'zenkaku': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[^\x01-\x7E]+$', val)) or '全角を入力してください。',
        # 日本語全角
        'zenkakuJapanese': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or (re.match(r'^[^\x01-\x7E\xA1-\xDF]+$', val) and re.search(r'[ぁ-んァ-ン一-龠]', val))) or '全角の日本語を入力してください。',
        # 半角
        'hankaku': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[\x01-\x7E]+$', val)) or '半角を入力してください。',
        # 半角
        'hankakuJapanese': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or re.match(r'^[ｦ-ﾟ]+$', val)) or '半角の日本語を入力してください。',
        # 整数値範囲
        'rangeInteger': lambda val, min, max: True if val is None else (isinstance(val, int) and val >= int(min) and val <= int(max)) or f'値は {min} と {max} の間である必要があります',
        # 値範囲
        'rangeFloat': lambda val, min, max: True if val is None else (isinstance(val, float) and val >= float(min) and val <= float(max)) or f'値は {min} と {max} の間である必要があります',
        # 文字列長さ範囲
        'length': lambda val, min, max: (val is None or (isinstance(val, str) and len(val) == 0) or (val is not None and val is not None and len(str(val)) > 0 and len(val) >= int(min) and len(val) <= int(max))) or f'長さは {min} から {max} の間である必要があります',
        # # 日付範囲
        # 'dateRange': lambda val, minDate, maxDate: True if val is None or (isinstance(val, str) and len(val) == 0) else (datetime.strptime(val, '%Y-%m-%d') >= datetime.strptime(minDate, '%Y-%m-%d') and datetime.strptime(val, '%Y-%m-%d') <= datetime.strptime(maxDate, '%Y-%m-%d')) or f'日付は {minDate} から {maxDate} の間である必要があります',
        # # 日付
        # # 'isValidDate': lambda val: True if val is None or (isinstance(val, str) and len(val) == 0) else (datetime.strptime(val.replace('/', '-'), '%Y-%m-%d') if isinstance(datetime.strptime(val.replace('/', '-'), '%Y-%m-%d'), datetime) and not isinstance(datetime.strptime(val.replace('/', '-'), '%Y-%m-%d'), bool) else '正しい日付ではありません。'),
        # # 'isValidDate': lambda val: (val is None or (isinstance(val, str) and len(val) == 0) or check_date(val) or '正しい日付ではありません。'),
        # 'isValidDate': lambda val: check_date(val),
        # bool
        'isBool': lambda val: (val is None or (type(val) == bool)) or '型が正しくありません。',
    }

    def __init__(self, event=None, context=None):
        logger.debug('process __init__')
        logger.debug(self)
        
        if GV.SERVICE_PATH:

            logger.debug('# ******************************')

            logger.debug('# 「システムID」を取得する')
            logger.debug('# テーブル「システムマスタ」からデータ検索')
            logger.debug('# m_systems')

            params = {
                'table_name': 'm_systems',
                'filters': {
                    'system_name': GV.SYSTEM_SERVICE[GV.SERVICE_PATH]['system_name']
                }
            }
            data_m_sys = self.get_data(params)

            if data_m_sys:
                GV.SYSTEM_ID = data_m_sys['system_id']
                GV.SYSTEM_NAME = data_m_sys['system_name']
                GV.SYSTEM = data_m_sys
                pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# 「サービスID」を取得する')
            logger.debug('# テーブル「サービスマスタ」からデータ検索')
            logger.debug('# m_services')

            params = {
                'table_name': 'm_services',
                'filters': {
                    'service_name': GV.SYSTEM_SERVICE[GV.SERVICE_PATH]['service_name']
                }
            }
            data_m_srv = self.get_data(params)

            if data_m_srv:
                GV.SERVICE_ID = data_m_srv['service_id']
                GV.SERVICE_NAME = data_m_srv['service_name']
                GV.SERVICE = data_m_srv
                pass

            logger.debug('# ##############################')
        
        else:
            
            if GV.SYSTEM_ID is not None:

                logger.debug('# ******************************')

                logger.debug('# 「システムID」を取得する')
                logger.debug('# テーブル「システムマスタ」からデータ検索')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }
                data_m_sys = self.get_data(params)

                if data_m_sys:
                    GV.SYSTEM_ID = data_m_sys['system_id']
                    GV.SYSTEM_NAME = data_m_sys['system_name']
                    GV.SYSTEM = data_m_sys
                    pass

                logger.debug('# ##############################')

        pass

    def check_date(self, val):
        try:
            if val is None or (isinstance(val, str) and len(val) == 0):
                return True
            new_date = datetime.strptime(val.replace('/', '-'), '%Y-%m-%d')
            return True
        except ValueError:
            return '正しい日付ではありません。'
    
    def check_date_range(self, val, min_date, max_date):
        try:
            logger.debug(val)
            logger.debug(min_date)
            logger.debug(max_date)
            
            if val is None or (isinstance(val, str) and len(val) == 0):
                return '正しい日付ではありません。'
            
            tmp_val = datetime.strptime(val.replace('/', '-'), '%Y-%m-%d')
            tmp_min_date = datetime.strptime(min_date.replace('/', '-'), '%Y-%m-%d')
            tmp_max_date = datetime.strptime(max_date.replace('/', '-'), '%Y-%m-%d')
            if tmp_val >= tmp_min_date and tmp_val <= tmp_max_date:
                return True
            else:
                return f'日付は {min_date} から {max_date} の間である必要があります' 
        except ValueError:
            return '正しい日付ではありません。'
        
    def validate(self, table_name, data):

        ci_t_trh = None
        json_file = f'{GV.CUR_PATH}/config/{table_name}.json'
        if os.path.isfile(json_file):
            with open(json_file, encoding='utf-8') as f:
                ci_t_trh = json.load(f)
        if ci_t_trh:
            for f in ci_t_trh['fieldConfig']:
                if 'rules' in f:
                    rules = f['rules']
                    rule_list = rules.split("|")
                    for r in rule_list:
                        tmp_r = r.split(':')
                        if len(tmp_r) > 0:
                            rule_name = tmp_r[0]
                            rule_args = []
                            if len(tmp_r) > 1:
                                rule_args = tmp_r[1:]
                            if rule_name == 'dateRange':
                                valiedate_result = self.check_date_range(data[f['name']], *rule_args )
                            elif rule_name == 'isValidDate':
                                valiedate_result = self.check_date(data[f['name']])
                            else:
                                valiedate_result = self.VALIDATION_METHODS[rule_name](
                                data[f['name']], *rule_args)
                            if valiedate_result == True:
                                # logger.debug('True<<<<<<<<<<<<<<<<<<<<<')
                                pass
                            else:
                                logger.debug(valiedate_result)
                                error = {
                                    'code': 400,
                                    'message': f['label'] + ':' + valiedate_result
                                }
                                return GV.handle_error('ERROR', None, error)
                            
        return True
        pass

    # 取得する
    def get_all(self, event, context):

        pass

    # 作成する
    def add(self, event, context):
        return {}
        pass

    # 更新する
    def update(self, event, context):
        return {}
        pass

    # 削除する
    def delete(self, event, context):
        return {}
        pass

    # ******************************'
    # テーブルからデータ取得
    # data
    # params
    #   table_name
    #   filter_cols
    # ##############################'
    def get_data(self, params, is_get_dict=True):

        res = None
        logger.debug(params)
        try:

            helper_module = None

            if DEV_ENV == 'local':
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{GV.CURRENT_DIR}.controller.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{GV.CURRENT_DIR}.view.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{GV.CURRENT_DIR}.model.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
            else:
                # helper_module = importlib.import_module(
                #     f'modules.{params["table_name"]}')
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'controller.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'view.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'model.{params["table_name"]}')
                    except Exception as e:
                        helper_module = None
                        pass
            logger.debug(params["table_name"] + 'module読み込み終了')

            cls = getattr(helper_module, 'Sub')
            ins = cls()

            filters = []

            for k in params['filters']:
                col = getattr(ins.model_class, k)
                if params['filters'][k] == 'NONE':
                    filters.append(col == None)
                elif params['filters'][k] == 'NOT NONE':
                    filters.append(col != None)
                elif type(params['filters'][k]) is dict:
                    if 'expression' in params['filters'][k]:
                        if params['filters'][k]['expression'] == 'NOT CONTAINS':
                            # filters.append(not_(col.contains(params['filters'][k]['value'])))
                            filters.append(
                                or_(
                                    col == None,
                                    not_(col.contains(params['filters'][k]['value']))
                                )
                            )
                        elif params['filters'][k]['expression'] == 'CONTAINS':
                            filters.append(col.contains(params['filters'][k]['value']))
                else:
                    filters.append(col
                                   == params['filters'][k])

            filters = and_(*filters)

            order_by = None
            if 'order_by' in params:
                for k in params['order_by']:
                    col = getattr(ins.model_class, k)
                    if params['order_by'][k] == 'desc':
                        order_by = desc(col)
                    else:
                        order_by = asc(col)

            # order_by = []
            # if 'order_by' in params:
            #     for k in params['order_by']:
            #         col = getattr(ins.model_class, k)
            #         if params['order_by'][k] == 'desc':
            #             order_by.append(desc(col))
            #         else:
            #             order_by.append(asc(col))

            tmp = ins._get_item_by_filters(filters, order_by=order_by)

            if tmp:
                if is_get_dict:
                    res = tmp.to_dict()
                else:
                    res = tmp

        except Exception as e:
            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug(res)
            logger.debug(type(res))
            return res
            pass

    def send_email(self, mail_template, mail_parameter):
        from_address = ''
        to_address = []
        cc_address = []
        bcc_address = []
        title = ""
        message = ""

        logger.debug('******************************')
        
        if mail_template is None:
            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.error('# mail_templateがNoneです。')

            error_message = 'メールテンプレートがありません。'
            error = {
                'code': 400,
                'message': error_message
            }
            raise CustomException('ERROR', error_params=error)
        
        logger.debug('##############################')

        logger.debug('******************************')
        
        if mail_parameter is None:
            logger.error('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.error('# mail_parameterがNoneです。')

            error_message = 'メールパラメータがありません。'
            error = {
                'code': 400,
                'message': error_message
            }
            raise CustomException('ERROR', error_params=error)
        logger.debug('##############################')
        

        if "mail_send_from" in mail_template:
            from_address = mail_template["mail_send_from"]

        if not from_address:
            raise CustomException('SEND_EMAIL_ERR_000')

        if "mail_to" in mail_template:
            if not mail_template["mail_to"] is None and len(mail_template["mail_to"]) > 0:
                arr_value = mail_template["mail_to"].split(';')
                for val in arr_value:
                    to_address.append(val)

        if "to_address" in mail_parameter:
            to_address.extend(mail_parameter["to_address"])
            set(to_address)

        if len(to_address) < 1:
            raise CustomException('SEND_EMAIL_ERR_001')

        if "mail_cc" in mail_template:
            if not mail_template["mail_cc"] is None and len(mail_template["mail_cc"]) > 0:
                arr_value = mail_template["mail_cc"].split(';')
                for val in arr_value:
                    cc_address.append(val)

        if "cc_address" in mail_parameter:
            cc_address.extend(mail_parameter["cc_address"])
            set(cc_address)

        if "mail_bcc" in mail_template:
            if not mail_template["mail_bcc"] is None and len(mail_template["mail_bcc"]) > 0:
                arr_value = mail_template["mail_bcc"].split(';')
                for val in arr_value:
                    bcc_address.append(val)

        if "bcc_address" in mail_parameter:
            bcc_address.extend(mail_parameter["bcc_address"])
            set(bcc_address)

        if "mail_subject" in mail_template:
            title = mail_template["mail_subject"]

        if not title:
            raise CustomException('SEND_EMAIL_ERR_002')

        if "mail_body" in mail_template:
            message = mail_template["mail_body"]

        if not message:
            raise CustomException('SEND_EMAIL_ERR_003')

        if 'to_address' in mail_parameter:
            del mail_parameter['to_address']
        if 'cc_address' in mail_parameter:
            del mail_parameter['cc_address']
        if 'bcc_address' in mail_parameter:
            del mail_parameter['bcc_address']

        for key in mail_parameter:
            title = title.replace("{{" + key + "}}", str(mail_parameter[key]))
        logger.debug('title')
        logger.debug(title)

        for key in mail_parameter:
            message = message.replace(
                "{{" + key + "}}", str(mail_parameter[key]))
        logger.debug('message')
        logger.debug(message)

        res = {}

        try:

            input_event = {
                'stageVariables': {
                    'env': GV.ENV
                },
                'httpMethod': 'POST',
                'path': '/email/send',
                'body': json.dumps(
                    {
                        'from_address': from_address,
                        'to_address': to_address,
                        'cc_address': cc_address,
                        'bcc_address': bcc_address,
                        'title': title,
                        'message': message
                    }
                )
            }

            Payload = json.dumps(input_event, ensure_ascii=False)
            logger.debug("---01: Payload:")
            logger.debug(Payload)

            if DEV_ENV == 'local':
                pass
            else:
                # 呼び出し
                response = boto3.client('lambda').invoke(
                    FunctionName=GV.LAMBDA_SYS_EMAIL,
                    # InvocationType='RequestResponse',
                    InvocationType='Event',
                    Payload=Payload
                )
                logger.debug("---02: response:")
                logger.debug(response)
                # response = {}

                res = response

                # if 'StatusCode' in response and response['StatusCode'] == 200:

                #     # レスポンス読出し
                #     Payload = json.loads(response['Payload'].read())
                #     logger.debug("---03: body:")
                #     logger.debug(Payload)
                #     res = Payload

            return res

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise

    def create_data_atuh0(self, data):
        try:
            logger.debug('# ******************************')
            logger.debug('# # Auth0のアカウント作成')

            # from ..auth0 import Sub as auth0_class
            # auth0 = auth0_class()
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            data_auth0 = {
                'user_id': data['email_address'],
                'email': data['email_address'],
                'username': data['email_address'].split('@')[0],
                'password': 'P@ssW0rd202305'
            }

            if 'user_metadata' in data:
                data_auth0['user_metadata'] = data['user_metadata']

            if 'app_metadata' in data:
                data_auth0['app_metadata'] = data['app_metadata']
                
            return a0._add(data_auth0)

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            print(e)
            # 例外の再送出
            raise

    def check_permissions(self, data=None):
        try:
            
            logger.debug('# ******************************')
            logger.debug('# 権限チェック')
            logger.debug(GV.USER_METADATA)

            authorized = False

            if GV.USER_METADATA is not None and \
                'data' in GV.USER_METADATA and \
                type(GV.USER_METADATA['data']) == list and \
                    len(GV.USER_METADATA['data']) > 0:
                pass

                if data is not None:

                    company_code = None
                    if 'company_code' in data:
                        company_code = data['company_code']

                        for d in GV.USER_METADATA['data']:

                            if 'company_code' in d and d['company_code'] == company_code and \
                                 'system_id' in d and d['system_id'] == GV.SYSTEM_ID and \
                                    'service_id' in d and d['service_id'] == GV.SERVICE_ID:
                                    
                                    if 'roles' in d and \
                                        type(d['roles']) == list and \
                                        GV.ROLES_ADMIN_USER in d['roles']:
                                    
                                        authorized = True

                                        break     
            else:
                authorized = False
            
            if authorized == False:

                logger.debug('# 権限がありません。')

                error_message = '権限がありません。'
                error = {
                    'code': 400,
                    'message': error_message
                }
                raise CustomException('ERROR', error_params=error)

            logger.debug('# 権限があります。')

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            print(e)
            # 例外の再送出
            raise

    # 辞書型のデータにNULLが混じっていたら空文字列に置換する
    def replace_none_with_empty_string(self, data):
        if isinstance(data, dict):
            for key, value in data.items():
                if value is None:
                    data[key] = ""
        elif isinstance(data, list):
            for index in range(len(data)):
                if data[index] is None:
                    data[index] = ""
        