from .model import Base, GV
    
class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 't_manage_request'
    primary_key_columns = ['manage_req_id']
    exclude_search_columns = []
       
    def before_new_item(self, item):
        print('t_manage_request before_new_item ----------------')
        try:

            if item.credit_check == 'OK':
                item.credit_check = True
            elif item.credit_check == 'NG':
                item.credit_check = False
            else:
                item.credit_check = None

            if item.prospect_request == 'OK':
                item.prospect_request = True
            elif item.prospect_request == 'NG':
                item.prospect_request = False
            else:
                item.prospect_request = None

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        
    def before_update_item(self, item=None, data=None):
        print('t_manage_request before_update_item ----------------')
        try:

            if 'credit_check' in data:
                if item.credit_check == 'OK':
                    item.credit_check = True
                elif item.credit_check == 'NG':
                    item.credit_check = False
                else:
                    item.credit_check = None
                    item.credit_check_regist_date = None

            if 'prospect_request' in data:
                if item.prospect_request == 'OK':
                    item.prospect_request = True
                elif item.prospect_request == 'NG':
                    item.prospect_request = False
                else:
                    item.prospect_request = None
                    item.prospect_request_regist_date = None

            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise