from .model import Base, GV
    
class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_workshop_event_date'
    primary_key_columns = ['workshop_event_date_id']
    exclude_search_columns = []

    def before_new_item(self, item=None, data=None):
        print('m_workshop_event_date before_new_item ----------------')
        try:            
            if item.workshop_event_time_division == '午前':
                item.workshop_event_time_division = 'AM'
            elif item.workshop_event_time_division == '午後':
                item.workshop_event_time_division = 'PM'

            super().before_new_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
    
    def before_update_item(self, item=None, data=None):
        print('m_workshop_event_date before_update_item ----------------')
        try:
            if item.workshop_event_time_division == '午前':
                item.workshop_event_time_division = 'AM'
            elif item.workshop_event_time_division == '午後':
                item.workshop_event_time_division = 'PM'

            super().before_update_item(item, data)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise