from .model import Base, GV, CustomException, logging, and_, or_

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_staff'
    primary_key_columns = ['staff_id']
    exclude_search_columns = []

    def before_new_item(self, item, data=None):
        print('m_staff before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.salesman_code ==
                           item.salesman_code)
            filters.append(self.model_class.email == item.email)
            filters = or_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                # --> 共通PF4 #5383スタッフの職番の重複をOKにする 2024/03/06 nakamura.e
                # if tmp.salesman_code == item.salesman_code:
                #    raise CustomException('MST_ERR_100')
                #elif tmp.email == item.email:
                if tmp.email == item.email:
                    raise CustomException('MST_ERR_101')
                # <-- 共通PF4 #5383スタッフの職番の重複をOKにする 2024/03/06 nakamura.e

            # from ..auth0 import Sub as auth0_class
            # auth0 = auth0_class()
            auth0_class = GV.get_module_auth0()
            a0 = auth0_class()

            logger.debug('# ******************************')

            if '指定の「email」でAuth0側にユーザーが存在するかどうか確認する':

                logger.debug('# 指定の「email」でAuth0側にユーザーが存在するかどうか確認する')

                tmp_user = None

                if item.email is not None:
                    tmp_user = a0._get_users_by_email(item.email)

                if tmp_user:

                    logger.debug('# ******************************')

                    if 'Auth0側にユーザーが存在する場合':
                       
                        item.auth0_user_id = tmp_user[0]['user_id']

                    logger.debug('# ##############################')

                else:

                    logger.debug('# ******************************')

                    if 'Auth0側にユーザーが存在しない場合':

                        logger.debug('# Auth0側にユーザーが存在しない場合')
                        logger.debug('# アカウントを作成する')
                        
                        user_data = {
                            'user_id': item.email,
                            'email': item.email,
                            'username': 'NDES_' + item.email.split('@')[0],
                            'password': 'P@ssW0rdNDES'
                        }
                        created_user = a0._add(user_data)
                        logger.debug(created_user)
                        item.auth0_user_id = created_user['user_id']

                    logger.debug('# ##############################')

            logger.debug('# ##############################')
            
            super().before_new_item(item)
            
        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        
    def before_update_item(self, item=None, data=None):
        print('m_staff before_update_item ----------------')
        print(data)
        print(item.to_dict())
        try:
            
            filters = []
            filters.append(self.model_class.salesman_code ==
                           item.salesman_code)
            filters.append(self.model_class.email == item.email)
            filters = and_(
                self.model_class.auth0_user_id != item.auth0_user_id,
                or_(*filters)
            )
            tmp = self._get_item_by_filters(filters)
            if tmp:
                # --> 共通PF4 #5383スタッフの職番の重複をOKにする 2024/03/06 nakamura.e
                # if tmp.salesman_code == item.salesman_code:
                #     raise CustomException('MST_ERR_100')
                #elif tmp.email == item.email:
                if tmp.email == item.email:
                     raise CustomException('MST_ERR_101')
                # <-- 共通PF4 #5383スタッフの職番の重複をOKにする 2024/03/06 nakamura.e
                
            # if data:
            #     print(data['roles'])
            #     pass

            super().before_update_item(item)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise