from .model import Base, GV, CustomException, and_

# 新業務システム売上区分マスタ
class Sub(Base):
    database = GV.DB_COMN_PF
    schema = 'user_infrastructure'
    table_name = 'm_new_biz_sys_sales_category'
    primary_key_columns = ['sales_category_id']
    exclude_search_columns = []

    def before_new_item(self, item):
        print('m_new_biz_sys_sales_category before_new_item ----------------')
        try:

            filters = []
            filters.append(self.model_class.new_biz_sys_project_name ==
                           item.new_biz_sys_project_name)
            filters = and_(*filters)
            tmp = self._get_item_by_filters(filters)
            if tmp:
                if tmp.new_biz_sys_project_name == item.new_biz_sys_project_name:
                    raise CustomException('MNBSSC_ERR_100')

            item.sales_category_id = self.new_id('売上区分ID', 'SC', 6)

        except Exception as e:
            print(e)
            # 例外の再送出
            raise