DEV_ENV = 'prod'

# 必要なモジュールをインポートする
import os
import json
import importlib
from sqlalchemy import and_

import logging
logging.basicConfig(format='%(asctime)s,%(msecs)03d %(levelname)-8s [%(filename)s:%(lineno)d] %(message)s',
                    datefmt='%Y-%m-%d:%H:%M:%S',
                    level=logging.DEBUG)
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

if DEV_ENV == 'local':
    import boto3

    pass
else:
    # 設定ファイル
    import boto3
    s3 = boto3.resource('s3')

current_dir = os.path.basename(os.path.dirname(__file__))
logger.debug(current_dir)

if DEV_ENV == 'local':
    from . import global_value as GV
    from .global_value import CustomException
    GV.CURRENT_DIR = current_dir
else:
    import global_value as GV
    from global_value import CustomException
    GV.CURRENT_DIR = ''

GV.CUR_PATH = os.path.dirname(__file__)

# Lambdaハンドラー関数
def lambda_handler(event, context):
    logger.debug(event)
    http_method = event['httpMethod']
    path = event['path']


    logger.debug('# ******************************')
    logger.debug('# 初期化')
    GV.URL_PATH_SERVICE_NAME = None
    GV.URL_PATH_TABLE_NAME = None
    GV.PATH_PARAMETERS = None
    GV.EVENT_BODY = None
    GV.QUERY_STRING_PARAMETERS = None
    GV.USER_METADATA = None
    GV.LOGGEDIN_USER = None
    GV.LOGGEDIN_USER_IS_ADMIN = False
    # --> 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
    GV.LOGGEDIN_USER_IS_SUPPLIER = False
    # <-- 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e

    GV.SERVICE_PATH = None

    GV.SYSTEM = None
    GV.SYSTEM_ID = None
    GV.SYSTEM_NAME = None
    GV.SERVICE = None
    GV.SERVICE_ID = None
    GV.SERVICE_NAME = None

    GV.DB_COMN_PF = None
    GV.DB_MSCONE_LIC = None
    GV.DB_GRADEHULL = None
    GV.DB_BEAGLE = None

    GV.SCHEMA_MSCONE_LIC = None
    GV.SCHEMA_GRADEHULL = None
    GV.SCHEMA_BEAGLE = None

    GV.CONFIG_COMN_PF = None
    GV.CONFIG_MSCONE_LIC = None

    GV.ENV_CONFIG = None

    logger.debug('# ##############################')

    logger.debug('# ******************************')
    logger.debug('# 定義ファイルを読み込み')

    ENV_CONFIG = None

    if DEV_ENV == 'local':
        GV.ENV = 'LOCAL'

        PATH_NAME = 'dev_env_local/'
        OBJECT_KEY_NAME = 'config.json'
        logger.debug(GV.CUR_PATH + '/' + PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        with open(GV.CUR_PATH + '/' + PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME) as f:
            ENV_CONFIG = json.load(f)

    else:
        if 'stageVariables' in event and 'env' in event['stageVariables'] and event['stageVariables']['env'] is not None:
            GV.ENV = event['stageVariables']['env'].upper()
        else:
            res = {}
            res['error_code'] = ''
            res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
            return {
                'statusCode': 500,
                'headers': RESPONSE_HEADERS,
                'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
            }

    # S3から設定ファイルを読み込む
    BUCKET_NAME = GV.ENV.lower() + GV.S3_BUCKET_NAME
    PATH_NAME = 'user-infrastructure/'
    OBJECT_KEY_NAME = 'config.json'

    bucket = s3.Bucket(BUCKET_NAME)
    obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
    response = obj.get()    
    body = response['Body'].read()
    ENV_CONFIG = json.loads(body.decode('utf-8'))
    
    # logger.debug(ENV_CONFIG)

    logger.debug('# ******************************')
    logger.debug('# load config')
    logger.debug(ENV_CONFIG)

    GV.ENV_CONFIG = ENV_CONFIG

    GV.CONFIG = {}
    GV.CONFIG['AUTH0_TENANT'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_TENANT']
    GV.ENTRA_ID_TENANT = GV.CONFIG['AUTH0_TENANT'] # デフォルトのテナント
    GV.CONFIG['ALGORITHMS'] = ["RS256"]
    
    GV.CONFIG_MSCONE_LIC = {}
    GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
    GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
    GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
    GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
    GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']
    GV.CONFIG_MSCONE_LIC['DATABASE_SCHEMA'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_SCHEMA']

    GV.CONFIG_GRADEHULL = {}
    GV.CONFIG_GRADEHULL['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_HOST']
    GV.CONFIG_GRADEHULL['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_PORT']
    GV.CONFIG_GRADEHULL['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_NAME']
    GV.CONFIG_GRADEHULL['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_USERNAME']
    GV.CONFIG_GRADEHULL['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_PASSWORD']
    GV.CONFIG_GRADEHULL['DATABASE_SCHEMA'] = ENV_CONFIG[GV.ENV]['GRADEHULL'][GV.ENV + '_' + 'DATABASE_SCHEMA']

    GV.CONFIG_BEAGLE = {}
    GV.CONFIG_BEAGLE['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_HOST']
    GV.CONFIG_BEAGLE['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_PORT']
    GV.CONFIG_BEAGLE['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_NAME']
    GV.CONFIG_BEAGLE['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_USERNAME']
    GV.CONFIG_BEAGLE['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_PASSWORD']
    GV.CONFIG_BEAGLE['DATABASE_SCHEMA'] = ENV_CONFIG[GV.ENV]['BEAGLE'][GV.ENV + '_' + 'DATABASE_SCHEMA']
    
    GV.CONFIG_COMN_PF = {}
    GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
    GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
    GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
    GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
    GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']
    # logger.debug('# load config111111111')
    GV.SYSTEM_SERVICE = ENV_CONFIG[GV.ENV]['SYSTEM_SERVICE']

    GV.URL_CLOUD_SERVICE_ENTRY_PORTAL = ENV_CONFIG[GV.ENV]['URL']['URL_CLOUD_SERVICE_ENTRY_PORTAL']
    GV.URL_CLOUD_SERVICE_PORTAL = ENV_CONFIG[GV.ENV]['URL']['URL_CLOUD_SERVICE_PORTAL']
    GV.URL_CLOUD_SERVICE_USER_MANAGE = ENV_CONFIG[GV.ENV]['URL']['URL_CLOUD_SERVICE_USER_MANAGE']
    GV.URL_LOGIN_SIMSP = ENV_CONFIG[GV.ENV]['URL']['URL_LOGIN_SIMSP']
    # logger.debug('# load config22222222')

    GV.WORKSHOP_PEEAR_LIST_N_DAYS_AGO = json.loads(ENV_CONFIG[GV.ENV]['WORKSHOP']['WORKSHOP_PEEAR_LIST_N_DAYS_AGO'])
    print(GV.WORKSHOP_PEEAR_LIST_N_DAYS_AGO)
    # logger.debug('# load config33333333')
    
    # GV.MACONTRACT_COUNT = ENV_CONFIG[GV.ENV]['MACONTRACT']['MACONTRACT_COUNT']
    GV.MACONTRACT_END_TIME = ENV_CONFIG[GV.ENV]['MACONTRACT']['MACONTRACT_END_TIME']
    GV.MA_CONTRACT_COMPANY_CODE = ENV_CONFIG[GV.ENV]['MACONTRACT']['MA_CONTRACT_COMPANY_CODE']
    # logger.debug('# load config4444444')
    
    

    GV.DB_COMN_PF = GV.CONFIG_COMN_PF['DATABASE_NAME']
    GV.DB_MSCONE_LIC = GV.CONFIG_MSCONE_LIC['DATABASE_NAME']
    GV.DB_GRADEHULL = GV.CONFIG_GRADEHULL['DATABASE_NAME']
    GV.DB_BEAGLE = GV.CONFIG_BEAGLE['DATABASE_NAME']
    # logger.debug('# load config555555')

    # print(GV.DB_COMN_PF)
    # print(GV.DB_MSCONE_LIC)
    # print(GV.DB_GRADEHULL)
    # print(GV.DB_BEAGLE)

    GV.SCHEMA_MSCONE_LIC = GV.CONFIG_MSCONE_LIC['DATABASE_SCHEMA']
    GV.SCHEMA_GRADEHULL = GV.CONFIG_GRADEHULL['DATABASE_SCHEMA']
    GV.SCHEMA_BEAGLE = GV.CONFIG_BEAGLE['DATABASE_SCHEMA']

    # print(GV.SCHEMA_MSCONE_LIC)
    # print(GV.SCHEMA_GRADEHULL)
    # print(GV.SCHEMA_BEAGLE)

    logger.debug('# ##############################')


    print("path.split('/')<<<<<<<<<<<<<<<<<<<<")
    print(path.split('/'))

    api_path = ''

    arr_path = path.split('/')
    if len(arr_path) == 4:
        api_path = arr_path[0] + '/' + arr_path[1] + '/' + arr_path[3]

        GV.SERVICE_PATH = arr_path[2]

        GV.URL_PATH_SERVICE_NAME = arr_path[2]
        GV.URL_PATH_TABLE_NAME = arr_path[3]

        pass
    elif len(arr_path) == 3:
        api_path = path

        GV.URL_PATH_SERVICE_NAME = None
        GV.URL_PATH_TABLE_NAME = arr_path[2]

        if arr_path[2] == 'ma_contract':
           system_name1 = ''
           
           if 'headers' in event:
                headers = event['headers']
                if (headers.get('AuthorizationIDToken') or headers.get('authorizationidtoken')) :
                    id_token1 = None
                    app_meta1 = None

                    if headers.get('AuthorizationIDToken'):
                        tmp = headers['AuthorizationIDToken'].split()
                        if len(tmp) > 1:
                            id_token1 = tmp[1]
                        if len(tmp) > 2:
                            app_meta1 = tmp[2]
                    if headers.get('authorizationidtoken'):
                        tmp = headers['authorizationidtoken'].split()
                        if len(tmp) > 1:
                            id_token1 = tmp[1]
                        if len(tmp) > 2:
                            app_meta1 = tmp[2]

                    if app_meta1:
                        app_meta1 = json.loads(app_meta1)
                        if 'system_id' in app_meta1:
                            GV.SYSTEM_ID = app_meta1['system_id']
                        # print("|||||")
                        # print(GV.SYSTEM_ID)
                        
                        data_m_sys = None
                        MSYS = GV.get_module('m_systems')
                        m_sys = MSYS()

                        filters = []
                        filters.append(m_sys.model_class.system_id == GV.SYSTEM_ID)
                        filters = and_(*filters)
                        tmp_m_sys = m_sys._get_item_by_filters(filters)

                        if tmp_m_sys is not None:
                            data_m_sys = tmp_m_sys.to_dict()
                            # print('data_m_sys')
                            # print(data_m_sys)
                        if data_m_sys is not None:
                            system_name1 = data_m_sys['sub_domain_name']
           GV.SERVICE_PATH = system_name1
           GV.URL_PATH_SERVICE_NAME = system_name1
           if 'pathParameters' in event and event['pathParameters'] is not None:
                event['pathParameters']['service_name'] = system_name1

        pass

    if 'pathParameters' in event and event['pathParameters'] is not None:
        GV.PATH_PARAMETERS = event['pathParameters']
        logger.info(GV.PATH_PARAMETERS)
    strma_contract_req_id = ''

    if 'body' in event and event['body'] is not None and event['body'] != '':
        if isinstance(event['body'], dict):
            GV.EVENT_BODY = event['body']
        else:
            GV.EVENT_BODY = json.loads(event['body'])
           
        logger.info(GV.EVENT_BODY)

        if "tenant" in GV.EVENT_BODY:
            GV.ENTRA_ID_TENANT = GV.EVENT_BODY["tenant"] 

        # print("event['body']")
        # print(event['body'])
        if 'ma_contract_req_id' in GV.EVENT_BODY:
            strma_contract_req_id = GV.EVENT_BODY['ma_contract_req_id']

        # GV.EVENT_BODY = json.loads(event['body'])
    print(event)
    if 'queryStringParameters' in event and event['queryStringParameters'] is not None:
        GV.QUERY_STRING_PARAMETERS = event['queryStringParameters']
        logger.info(GV.QUERY_STRING_PARAMETERS)

    if GV.PATH_PARAMETERS:
        if "table_name" in GV.PATH_PARAMETERS:
            GV.URL_PATH_TABLE_NAME = GV.PATH_PARAMETERS["table_name"]

    if GV.EVENT_BODY:
        if "table_name" in GV.EVENT_BODY:
            GV.URL_PATH_TABLE_NAME = GV.EVENT_BODY["table_name"]

    if GV.QUERY_STRING_PARAMETERS:
        if "table_name" in GV.QUERY_STRING_PARAMETERS:
            GV.URL_PATH_TABLE_NAME = GV.QUERY_STRING_PARAMETERS["table_name"]

   
    if 'headers' in event:
        headers = event['headers']

        # logger.debug("headers.get('Authorization')---------------------")
        # logger.debug(headers.get('Authorization'))

        # if headers.get('Authorization') and GV.URL_PATH_TABLE_NAME != 'ma_contract':
        if headers.get('Authorization'):    
            if DEV_ENV == 'local':
                from .auth0_authorizer import requires_auth
            else:
                from auth0_authorizer import requires_auth

            r = requires_auth(event)
            # logger.debug('r = requires_auth(event)')
            # logger.debug(r)
            print('r', r)
            if r['effect'] == 'Allow':
                GV.USER_LOGGEDIN = True
                if 'user_metadata' in r and r['user_metadata'] is not None:
                    GV.USER_METADATA = r['user_metadata']
                logger.debug('GV.USER_METADATA')
                logger.debug(GV.USER_METADATA)
            else:
                return GV.handle_error('ACCOUNT_ERR_NOT_ROLES')
            # ---------------------------------------------------------------

            # access_token = headers['Authorization'].split()[1]
            # users = Users(AUTH0_DOMAIN)
            # userInof = users.userinfo(access_token)

            # logger.debug('userInof---------------------------------')
            # logger.debug(userInof)

            # print(json.dumps(userInof))

            # GV.LOGGEDIN_USER = userInof
        else:
            if GV.IS_NEED_AUTHORIZATION == True:
                if GV.URL_PATH_SERVICE_NAME == None:
                    if GV.URL_PATH_TABLE_NAME == 'account' and \
                        GV.EVENT_BODY is not None and \
                        'func' in GV.EVENT_BODY and \
                        ( GV.EVENT_BODY['func'] == 'check_verification_code' or \
                        GV.EVENT_BODY['func'] == 'set_password' ):
                        pass
                    elif GV.URL_PATH_TABLE_NAME == 'file_manage' and \
                        GV.QUERY_STRING_PARAMETERS is not None and \
                        'func' in GV.QUERY_STRING_PARAMETERS and \
                        ( GV.QUERY_STRING_PARAMETERS['func'] == 'get_file_urls_terms'):
                        pass
                    elif GV.URL_PATH_TABLE_NAME == 'notice' and \
                        GV.QUERY_STRING_PARAMETERS is not None and \
                        'func' in GV.QUERY_STRING_PARAMETERS and \
                        ( GV.QUERY_STRING_PARAMETERS['func'] == 'get_notice_date'):
                        print("headers4")
                        pass
                    else:
                        return GV.handle_error('ACCOUNT_ERR_NOT_ROLES')
        logger.debug(headers)
        # print("11111111111")
        if (headers.get('AuthorizationIDToken') or headers.get('authorizationidtoken')) and strma_contract_req_id == '' :
            # print("222222222222")
        # if (headers.get('AuthorizationIDToken') or headers.get('authorizationidtoken')) and GV.URL_PATH_TABLE_NAME != 'ma_contract' :
            if DEV_ENV == 'local':
                from .auth0_authorizer import parse_id_token
            else:
                from auth0_authorizer import parse_id_token

            id_token = None
            app_meta = None

            if headers.get('AuthorizationIDToken'):
                tmp = headers['AuthorizationIDToken'].split()
                if len(tmp) > 1:
                    id_token = tmp[1]
                if len(tmp) > 2:
                    app_meta = tmp[2]
            if headers.get('authorizationidtoken'):
                tmp = headers['authorizationidtoken'].split()
                if len(tmp) > 1:
                    id_token = tmp[1]
                if len(tmp) > 2:
                    app_meta = tmp[2]

            if id_token:

                logger.debug('parsed_token---------------------------------')
                # 解析ID token
                parsed_token = parse_id_token(id_token)

                # 输出解析结果
                if parsed_token:
                    # print(parsed_token)
                    GV.LOGGEDIN_USER = parsed_token

                    logger.debug('# ******************************')
                    logger.debug('# ログインユーザーが管理者かどうか判定する')

                    if GV.LOGGEDIN_USER:
                        if 'user_metadata' in GV.LOGGEDIN_USER:
                            if 'data' in GV.LOGGEDIN_USER['user_metadata']:
                                for d in GV.LOGGEDIN_USER['user_metadata']['data']:
                                    if 'company_code' in d and d['company_code'] == GV.STAFF_COMPANY_CODE and \
                                        'system_id' in d and d['system_id'] == GV.STAFF_SYSTEM_ID and \
                                            'service_id' in d and d['service_id'] == GV.STAFF_SERVICE_ID:

                                        if 'roles' in d and \
                                                d['roles'] is not None and \
                                                type(d['roles']) is list and \
                                                len(d['roles']) > 0:
                                            pass
                                        else:
                                            return GV.handle_error('ACCOUNT_ERR_NOT_ROLES')
                                            break

                                        if 'admin_staff' in d['roles']:

                                            # GV.LOGGEDIN_USER_IS_ADMIN = True
                                            # break

                                            AUI = GV.get_module('auth0_user_info')
                                            aui = AUI()

                                            params = {
                                                'table_name': 'm_auth0_user_info',
                                                'filters': {
                                                    'auth0_user_id': GV.LOGGEDIN_USER['sub'],
                                                    'system_id': GV.STAFF_SYSTEM_ID,
                                                    'service_id': GV.STAFF_SERVICE_ID,
                                                    'company_code': GV.STAFF_COMPANY_CODE
                                                }
                                            }
                                            logger.debug(params)
                                            data_aui = aui.get_data(params)

                                            # print('data_aui-------------')
                                            # print(data_aui)

                                            if data_aui is not None:
                                                if 'admin_staff' in data_aui['roles']:
                                                
                                                    GV.LOGGEDIN_USER_IS_ADMIN = True
                                                    logger.debug('LOGGEDIN_USER_IS_ADMIN:true')
                                                    break

                                            pass

                                        # --> 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
                                        if 'supplier_staff' in d['roles']:

                                            # GV.LOGGEDIN_USER_IS_ADMIN = True
                                            # break

                                            AUI = GV.get_module('auth0_user_info')
                                            aui = AUI()

                                            params = {
                                                'table_name': 'm_auth0_user_info',
                                                'filters': {
                                                    'auth0_user_id': GV.LOGGEDIN_USER['sub'],
                                                    'system_id': GV.STAFF_SYSTEM_ID,
                                                    'service_id': GV.STAFF_SERVICE_ID,
                                                    'company_code': GV.STAFF_COMPANY_CODE
                                                }
                                            }
                                            data_aui = aui.get_data(params)

                                            # print('data_aui-------------')
                                            # print(data_aui)

                                            if data_aui is not None:
                                                if 'supplier_staff' in data_aui['roles']:
                                                
                                                    GV.LOGGEDIN_USER_IS_SUPPLIER = True
                                                    logger.debug('LOGGEDIN_USER_IS_SUPPLIER:true')
                                                    break
                                            pass
                    #logger.debug(GV.LOGGEDIN_USER_IS_ADMIN)
                    # <-- 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e

                    logger.debug('# ##############################')

                else:
                    print("解析ID token失败")
                pass

            if app_meta:
                app_meta = json.loads(app_meta)
                if 'system_id' in app_meta:
                    GV.SYSTEM_ID = app_meta['system_id']

        # if headers.get('System_id') or headers.get('system_id'):
        #     if headers.get('System_id'):
        #         GV.SYSTEM_ID = headers.get('System_id')
        #     if headers.get('system_id'):
        #         GV.SYSTEM_ID = headers.get('system_id')

    
    response = None

    table_name = None

    table_name = GV.URL_PATH_TABLE_NAME
    logger.info(f'table_name = {GV.URL_PATH_TABLE_NAME}')
    logger.info(table_name)

    if not table_name:
        return {"error": "Table name is required"}

    if api_path == '/api/auth0':

        try:

            if DEV_ENV == 'local':
                helper_module = importlib.import_module(
                    f'{current_dir}.{table_name}')
            else:
                helper_module = importlib.import_module(
                    f'{table_name}')

            api_class = getattr(helper_module, 'Sub')

            if not api_class:
                return {
                    'statusCode': 404,
                    'body': json.dumps({'error': 'Resource not found'})
                }

            api = api_class()
            logger.debug(api)

            # from .modules.auth0 import Auth0API
            # api = Auth0API()

            # HTTPメソッドに応じたAPIメソッドを実行
            method_map = {
                'GET': api.get_all,
                'POST': api.add,
                'PUT': api.update,
                'DELETE': api.delete
            }

            response = method_map[http_method](event, context)

        except CustomException as e:
            logger.debug(
                'lambda_function CustomException ************************************')
            logger.debug(e)
            return GV.handle_error(e.error_type, e.error_params, None)
        except Exception as e:
            logger.debug(
                'lambda_function Exception ************************************')
            logger.debug(e)
            return GV.handle_error('ERROR', None, e)
        finally:
            pass
        pass

    elif api_path == '/api/config':
        print(api_path)

        try:

            config_file_name = 'config_staff.json'

            if GV.LOGGEDIN_USER_IS_ADMIN == True:
                config_file_name = 'config_admin.json'
            # --> 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
            if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
                config_file_name = 'config_supplier.json'
            # <-- 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e

            if DEV_ENV == 'local':
                with open(f'{GV.CUR_PATH}/config/{config_file_name}', 'r', encoding='utf-8') as f:
                    content = f.read()
            else:
                with open(f'config/{config_file_name}', 'r', encoding='utf-8') as f:
                    content = f.read()

            if DEV_ENV == 'local':
                return json.loads(content)
            else:
                response = json.loads(content)

        except CustomException as e:
            logger.debug(
                'lambda_function CustomException ************************************')
            logger.debug(e)
            return GV.handle_error(e.error_type, e.error_params, None)
        except Exception as e:
            logger.debug(
                'lambda_function Exception ************************************')
            logger.debug(e)
            return GV.handle_error('ERROR', None, e)
        finally:
            pass

        pass
    else:
        # リソースに応じたAPIクラスを取得
        try:

            data = None
            if http_method == 'GET':
                if GV.QUERY_STRING_PARAMETERS:
                    logger.debug(GV.QUERY_STRING_PARAMETERS)
                    data = GV.QUERY_STRING_PARAMETERS
            else:
                if GV.EVENT_BODY is None:
                    pass
                else:
                    data = GV.EVENT_BODY
            # print("|||||||||||")
            # print(data)
            # print(DEV_ENV)
            # print(table_name)
            # print("|||||||||||")
            
            helper_module = None

            if DEV_ENV == 'local':
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{current_dir}.controller.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{current_dir}.view.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'{current_dir}.model.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass
            else:
                # helper_module = importlib.import_module(
                #     f'modules.{table_name}')
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'controller.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'view.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass
                if helper_module is None:
                    try:
                        helper_module = importlib.import_module(
                            f'model.{table_name}')
                    except Exception as e:
                        helper_module = None
                        pass

            print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa1')
            print(helper_module)
            print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa1')

            api_class = getattr(helper_module, 'Sub')
            
            # print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa5')
            logger.debug(api_class)

            if not api_class:
                return {
                    'statusCode': 404,
                    'body': json.dumps({'error': 'Resource not found'})
                }
            # print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa6')
            api = api_class()
            # print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa7')
            logger.debug(api_path)

            if api_path == '/api/get-table-schema':
                logger.debug('/api/get-table-schema の呼び出し')
                # print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa8')

                table_schema = api.get_table_schema()

                response = {"table_schema": table_schema}

                pass
            else:
                print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa2')
                print(data)
                print('aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa2')
                if 'ma_contract_req_id' in data:
                    if (data['ma_contract_req_id'] != '') and data['ma_contract_req_id'] != None:
                        print("DataUpdate")
                        response = getattr(api, 'DataUpdate')(data)
                    
                if data is not None and 'func' in data and data['func'] != '':
                    func = getattr(api, data['func'])
                    print("aaaaaaaaaaaa3")
                    print(func)
                    if 'funcParams' in data and 'data' in data:
                        response = func(data['funcParams'], data['data'])
                    elif 'funcParams' in data:
                        response = func(data['funcParams'])
                    elif 'data' in data:
                        response = func(data['data'])
                    else:
                        response = func()
                    pass
                else:
                    # HTTPメソッドに応じたAPIメソッドを実行
                    method_map = {
                        'GET': api.get_all,
                        'POST': api.add,
                        'PUT': api.update,
                        'DELETE': api.delete
                    }
                    print(http_method)
                    response = method_map[http_method](event, context)

        except CustomException as e:
            logger.debug(
                'lambda_function CustomException ************************************')
            logger.debug(e)
            return GV.handle_error(e.error_type, e.error_params, None)
        except Exception as e:
            logger.debug(
                'lambda_function Exception ************************************')
            logger.debug(e)
            return GV.handle_error('ERROR', None, e)
        finally:
            logger.debug('api.close_session()')
            if api:
                if hasattr(api, 'close_session'):
                    api.close_session()

    if DEV_ENV == 'local':
        return response
    else:
        RESPONSE_HEADERS = {
            'Access-Control-Allow-Headers': 'Content-Type',
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
        }

        return {
            'statusCode': 200,
            'headers': RESPONSE_HEADERS,
            'body': json.dumps(response, default=str, ensure_ascii=False, indent=2)
        }
