DEV_ENV = 'prod'

import json
import importlib

ENV = 'DEV'

CURRENT_DIR = ''
CUR_PATH = ''

URL_PATH_SERVICE_NAME = None
URL_PATH_TABLE_NAME = None

PATH_PARAMETERS = None
EVENT_BODY = None
QUERY_STRING_PARAMETERS = None

ENTRA_ID_TENANT = ''

IS_NEED_AUTHORIZATION = False

def get_module_auth0():

    helper_module = None

    if DEV_ENV == 'local':
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'{CURRENT_DIR}.base_auth0')
            except Exception as e:
                print(e)
                helper_module = None
                pass
    else:
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'base_auth0')
            except Exception as e:
                print(e)
                helper_module = None
                pass
    
    attributes = dir(helper_module)
    print("Attributes and classes in the module:")
    for attribute in attributes:
        print(attribute)

    return getattr(helper_module, 'Sub')

def get_module(table_name):

    helper_module = None

    if DEV_ENV == 'local':
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'{CURRENT_DIR}.controller.{table_name}')
            except Exception as e:
                helper_module = None
                pass
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'{CURRENT_DIR}.view.{table_name}')
            except Exception as e:
                helper_module = None
                pass
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'{CURRENT_DIR}.model.{table_name}')
            except Exception as e:
                helper_module = None
                pass
    else:
        # helper_module = importlib.import_module(
        #     f'modules.{table_name}')
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'controller.{table_name}')
            except Exception as e:
                helper_module = None
                pass
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'view.{table_name}')
            except Exception as e:
                helper_module = None
                pass
        if helper_module is None:
            try:
                helper_module = importlib.import_module(
                    f'model.{table_name}')
            except Exception as e:
                helper_module = None
                pass

    return getattr(helper_module, 'Sub')

# URL_CLOUD_SERVICE_ENTRY_PORTAL = 'https://eval-mscone-lic-management-cpp.ndes-dx.com/entry/#/'
# URL_CLOUD_SERVICE_PORTAL = 'https://eval-mscone-lic-management-cpp.ndes-dx.com/user_portal/#/'
# URL_CLOUD_SERVICE_USER_MANAGE = 'https://eval-mscone-lic-management-cpp.ndes-dx.com/user_manage/#/'
# URL_LOGIN_SIMSP = 'https://eval-mscone-lic-management-cpp.ndes-dx.com/'
URL_CLOUD_SERVICE_ENTRY_PORTAL = None
URL_CLOUD_SERVICE_PORTAL = None
URL_CLOUD_SERVICE_USER_MANAGE = None
URL_LOGIN_SIMSP = None

# # SYSTEM_SERVICE = {
# #     'simsp': {
# #         'system_name': 'SimSP',
# #         'service_name': 'Simulation-Space'
# #     },
# #     'gh': {
# #         'system_name': 'GradeHull',
# #         'service_name': 'GRADE/HULL'
# #     },
# #     'beagle': {
# #         'system_name': 'Beagle',
# #         'service_name': 'Beagle'
# #     }
# # }
# SYSTEM_SERVICE = {
#     "simsp": {
#         "system_name": "SimSP",
#         "service_name": "Simulation-Space"
#     },
#     "gradehcld": {
#         "system_name": "GradeHCLD",
#         "service_name": "GRADE/HULL-Cloud"
#     },
#     "beaglecld": {
#         "system_name": "BeagleCLD",
#         "service_name": "Beagle-Cloud"
#     }
# }

SERVICE_PATH = None

SYSTEM = None
SYSTEM_ID = None
SYSTEM_NAME = None
SERVICE = None
SERVICE_ID = None
SERVICE_NAME = None

USER_LOGGEDIN = False
USER_METADATA = None
LOGGEDIN_USER = None
LOGGEDIN_USER_IS_ADMIN = False
# --> 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e
LOGGEDIN_USER_IS_SUPPLIER = False
# <-- 共通PF4 サプライヤー用表示 2024/02/06 nakamura.e

ROLES_REQUEST_USER = 'request_user'
ROLES_TRIAL_USER = 'trial_user'
ROLES_MA_CONTRACT_USER = 'mainte_contract_user'
ROLES_WORKSHOP_USER = 'workshop_user'
ROLES_ADMIN_USER = 'admin_user'
ROLES_GENERAL_USER = 'general_user'

ROLES_ADMIN_STAFF = 'admin_staff'

REQUEST_USER_SYSTEM_ID = 'SYS00000'
REQUEST_USER_SERVICE_ID = 'SRV00000'

STAFF_COMPANY_CODE = '000000'
STAFF_SYSTEM_ID = 'SYS90001'
STAFF_SERVICE_ID = 'SRV90001'

# DB_COMN_PF = 'comn_pf_db_phase3'
# DB_MSCONE_LIC = 'mscone_lic'
DB_COMN_PF = None
DB_MSCONE_LIC = None
DB_GRADEHULL = None
DB_BEAGLE = None

# WORKSHOP_PEEAR_LIST_N_DAYS_AGO = [1, 3, 10]
WORKSHOP_PEEAR_LIST_N_DAYS_AGO = []

# プロセス管理のステータス
STATUS = {
    '未申請': '未申請',
    'ワークショップ申請': 'ワークショップ申請',
    'ワークショップ受付': 'ワークショップ受付',
    'ワークショップ実施中': 'ワークショップ実施中',
    'ワークショップ終了': 'ワークショップ終了',
    'ワークショップキャンセル': 'ワークショップキャンセル',
    'フリートライアル利用中': 'フリートライアル利用中',
    'フリートライアル終了': 'フリートライアル終了',
    'フリートライアルキャンセル': 'フリートライアルキャンセル',
    '保守契約企業利用可能': '保守契約企業利用可能',
    '保守契約企業利用中': '保守契約企業利用中',
    '保守契約企業利用終了': '保守契約企業利用終了',
    '保守契約企業利用キャンセル': '保守契約企業利用キャンセル',
    '本契約申請': '本契約申請',
    '本契約受付': '本契約受付',
    '本契約利用中': '本契約利用中',
    '本契約解約済み': '本契約解約済み',
    '本契約申込キャンセル': '本契約申込キャンセル'
}

# 申込み中ステータス、別の種類の申し込み不可期間
# トライアル
STATUS_APPLYING_TRIAL = {
    'フリートライアル利用中': 'フリートライアル利用中'
}

# 申込み中ステータス、別の種類の申し込み不可期間
# 保守契約企業利用
STATUS_APPLYING_MA_CONTRACT = {
    '保守契約企業利用中': '保守契約企業利用中'
}

# 申込み中ステータス、別の種類の申し込み不可期間
# ワークショップ
STATUS_APPLYING_WORKSHOP = {
    'ワークショップ申請': 'ワークショップ申請',
    'ワークショップ受付': 'ワークショップ受付',
    'ワークショップ実施中': 'ワークショップ実施中'
}

# 申込み中ステータス、別の種類の申し込み不可期間
# 本契約
STATUS_APPLYING_CONTRACT = {
    '本契約申請': '本契約申請',
    '本契約受付': '本契約受付',
    '本契約利用中': '本契約利用中'
}

# システム利用可能フラグ	system_usable_flag
# 0:使用不可(申込情報の変更が将来的には使用可能)
# 1:利用状況確認、利用明細確認のみ使用可能
# 2:全機能使用可能
SYSTEM_USABLE_FLAG = {
    '使用不可(申込情報の変更が将来的には使用可能)': 0,
    '利用状況確認、利用明細確認のみ使用可能': 1,
    '全機能使用可能': 2
}

# サービスの利用ステータス
SERVICE_USABLE_STATUS = {
    '一時休止': '一時休止',
    '停止': '停止',
    '利用中': '利用中',
    '解約': '解約'
}

RESPONSE_HEADERS = {
    'Access-Control-Allow-Headers': 'Content-Type',
    'Access-Control-Allow-Origin': '*',
    'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
}

# アカウント登録のURL内のcodeの有効期限 4時間
ACCOUNT_REGIST_CODE_EXPIRATION_TIME = 4


class CustomException(Exception):
    def __init__(self, error_type, error_params=None):
        self.error_type = error_type
        self.error_params = error_params


INFO_CODE = {
    'TRIAL_I_ALREADY_COMPLETED': {
        'code': 'TRIAL_I_ALREADY_COMPLETED',
        'message': '大変申し訳ございません。過去にトライアルを実施済みのため、再度のお申し込みはお受付できません。'
    },
    'TRIAL_I_ANOTHER_APPLYING': {
        'code': 'TRIAL_I_ANOTHER_APPLYING',
        'message': '同じサービスのワークショップか本契約をお申し込み中のため、トライアルのお申し込みをお受付できません。'
    },
    'TRIAL_I_BUSY': {
        'code': 'TRIAL_I_BUSY',
        'message': '現在大変込み合っており新規のお申し込みを受け付けできません。<br/>お時間をおいてから再度お申し込みください'
    },
    'TRIAL_I_ACCOUNT_ALREADY_EXISTS': {
        'code': 'TRIAL_I_ACCOUNT_ALREADY_EXISTS',
        'message': 'ユーザ登録済みのメールアドレスが入力されました。<br>ログインを行ってから再度お申し込みください。'
    },
    'MA_CONTRACT_I_COUNT': {
        'code': 'MA_CONTRACT_I_COUNT',
        'message': '利用可能上限回数が今月利用下回数を上回るエラーが発生しています。<br>再度ご提出ください。'
    },
    
    'WORKSHOP_I_ALREADY_COMPLETED': {
        'code': 'WORKSHOP_I_ALREADY_COMPLETED',
        'message': '大変申し訳ございません。過去にワークショップを実施済みのため、再度のお申し込みはお受付できません。'
    },
    'WORKSHOP_I_ANOTHER_APPLYING': {
        'code': 'WORKSHOP_I_ANOTHER_APPLYING',
        'message': '同じサービスのワークショップか本契約をお申し込み中のため、トライアルのお申し込みをお受付できません。'
    },
    'WORKSHOP_I_BUSY': {
        'code': 'WORKSHOP_I_BUSY',
        'message': '現在大変込み合っており新規のお申し込みを受け付けできません。<br/>お時間をおいてから再度お申し込みください'
    },
    'WORKSHOP_I_ACCOUNT_ALREADY_EXISTS': {
        'code': 'WORKSHOP_I_ACCOUNT_ALREADY_EXISTS',
        'message': 'ユーザ登録済みのメールアドレスが入力されました。<br>ログインを行ってから再度お申し込みください。'
    },
    'WORKSHOP_CANNOT_SELECTED': {
        'code': 'WORKSHOP_CANNOT_SELECTED',
        'message': '選択された日程でワークショップのお申し込みをお受付できません。<br>別の日程を選択して再度お申し込みください'
    },  
    'CONTRACT_I_ALREADY_COMPLETED': {
        'code': 'CONTRACT_I_ALREADY_COMPLETED',
        'message': '既に本契約中をお申し込み中のため、複数のお申し込みはお受付できません。'
    },
    'CONTRACT_I_ANOTHER_APPLYING': {
        'code': 'CONTRACT_I_ANOTHER_APPLYING',
        'message': '同じサービスのワークショップか本契約をお申し込み中のため、トライアルのお申し込みをお受付できません。'
    },
    'CONTRACT_I_BUSY': {
        'code': 'CONTRACT_I_BUSY',
        'message': '現在大変込み合っており新規のお申し込みを受け付けできません。<br/>お時間をおいてから再度お申し込みください'
    },
    'CONTRACT_I_ACCOUNT_ALREADY_EXISTS': {
        'code': 'CONTRACT_I_ACCOUNT_ALREADY_EXISTS',
        'message': 'ユーザ登録済みのメールアドレスが入力されました。<br>ログインを行ってから再度お申し込みください。'
    },    
    'WORKSHOP_INFO_100': {
        'code': 'WORKSHOP_INFO_100',
        'message': 'すでにワークショップ申込済です。'
    },
    'WORKSHOP_INFO_001': {
        'code': 'WORKSHOP_INFO_001',
        'message': '現在、ワークショップは大変込み合っています。日を改めて申込下さい。'
    },
    'WORKSHOP_INFO_002': {
        'code': 'WORKSHOP_INFO_002',
        'message': '大変申し訳ございません。同時に多数のお客様から同じ日程でお申し込みがあったため満席になってしまいました。<br>ワークショップ開催希望日を変更して、再度お申し込みください。'
    },
    'CONTRACT_INFO_001': {
        'code': 'CONTRACT_INFO_001',
        'message': '本契約時、他に申込中のためエラー'
    }
}

ERROR_CODE = {
    'SYS_ERR_100': {
        'code': 'SYS_ERR_100',
        'message': 'システムエラーが発生しました。<br>再度、処理の実行をお試しください。'
    },
    'MSYS_ERR_100': {
        'code': 100,
        'message': '「システム名」はすでに存在します。'
    },
    'MSYS_ERR_101': {
        'code': 101,
        'message': '「prefix」はすでに存在します。'
    },
    'MSYS_ERR_102': {
        'code': 102,
        'message': '「ADドメイン名」はすでに存在します。'
    },
    'MSYS_ERR_103': {
        'code': 103,
        'message': '「サブドメイン名」はすでに存在します。'
    },
    'MSRV_ERR_100': {
        'code': 100,
        'message': '「サービス名」はすでに存在します。'
    },
    'MNUM_ERR_100': {
        'code': 'MNUM_ERR_100',
        'message': '「連番ID」はすでに存在します。'
    },
    'MNUM_ERR_101': {
        'code': 'MNUM_ERR_101',
        'message': '「連番名称」はすでに存在します。'
    },
    'MNBSI_ERR_100': {
        'code': 'MNBSI_ERR_100',
        'message': '「契約ID」はすでに存在します。'
    },
    'MNBSI_CSV_ERR_100': {
        'code': 'MNBSI_CSV_ERR_100',
        'message': '対象のCSVファイルにはヘッダー行と最低1行のデータ行が必要です。'
    },
    'MNBSI_CSV_ERR_101': {
        'code': 'MNBSI_CSV_ERR_101',
        'message': 'CSVのヘッダー項目が正しくありません。'
    },
    'MNBSI_CSV_ERR_102': {
        'code': 'MNBSI_CSV_ERR_102',
        'message': 'CSVのデータ項目（数）が正しくありません。'
    },
    'MNBSI_CSV_ERR_103': {
        'code': 'MNBSI_CSV_ERR_103',
        'message': '{0[0]}行目の「{0[1]}」が空白です。'
    },
    'MNBSI_CSV_ERR_104': {
        'code': 'MNBSI_CSV_ERR_104',
        'message': '契約ID（案件番号）：「{0}」は登録されていません。'
    },
    'MNBSI_CSV_ERR_105': {
        'code': 'MNBSI_CSV_ERR_105',
        'message': '取引先コード（注文主）：「{0}」が登録されていません。'
    },
    'MNBSI_CSV_ERR_106': {
        'code': 'MNBSI_CSV_ERR_106',
        'message': 'プロジェクト種類：「{0}」は登録されていません。'
    },
    'MNBSI_CSV_ERR_107': {
        'code': 'MNBSI_CSV_ERR_107',
        'message': 'プロジェクトコード（{0}）はすでに存在します。'
    },
    'MNBSI_CSV_ERR_108': {
        'code': 'MNBSI_CSV_ERR_108',
        'message': '企業（{0[0]}）の売上区分ID（{0[1]}）はすでに存在します。・契約IDは案件番号（{0[2]}）から取得する。・契約IDから企業コード、プロジェクト種類（{0[3]}）から売上区分IDを取得する。'
    },
    'MRP_ERR_100': {
        'code': 'MRP_ERR_100',
        'message': '同じ「適用開始日」のデータがすでに存在します。'
    },
    'MRP_ERR_101': {
        'code': 'MRP_ERR_101',
        'message': '同じ「商品名」のデータがすでに存在します。'
    },
    'MRP_ERR_102': {
        'code': 'MRP_ERR_102',
        'message': '商品コードのPrefixが正しくありません。'
    },
    'MRP_ERR_103': {
        'code': 'MRP_ERR_103',
        'message': '商品スペックはjsonで定義してください。'
    },
    'MCP_ERR_100': {
        'code': 'MCP_ERR_100',
        'message': '同じ「商品ID」のデータがすでに存在します。'
    },
    'MCP_ERR_101': {
        'code': 'MCP_ERR_101',
        'message': '異なるサービスの商品が選択されています。'
    },
    'MSM_ERR_100': {
        'code': 'MSM_ERR_100',
        'message': 'サービスに同じメールの種類がすでに存在します。'
    },
    'MLI_ERR_100': {
        'code': 'MLI_ERR_100',
        'message': '対象「種類」に同じ「表示名」がすでに存在します。'
    },
    'MLI_ERR_101': {
        'code': 'MLI_ERR_101',
        'message': '対象「種類」に同じ「値」がすでに存在します。'
    },
    'TR_ERR_100': {
        'code': 'TR_ERR_100',
        'message': '同じ「課税名称」のデータがすでに存在します。'
    },
    'MST_ERR_100': {
        'code': 'MST_ERR_100',
        'message': '「職番」はすでに存在します。'
    },
    'MST_ERR_101': {
        'code': 'MST_ERR_101',
        'message': '「メールアドレス」はすでに存在します。'
    },
    'CI_ERR_100': {
        'code': 'CI_ERR_100',
        'message': '「契約情報:請求書の送付方法」で「郵送(書類)」を選択する場合は、事前に「サービス管理」アプリで「請求書の郵送手数料の商品ID」を設定してください。'
    },
    'MNBSSC_ERR_100': {
        'code': 'MNBSSC_ERR_100',
        'message': '「プロジェクト名」はすでに存在します。'
    },
    'MPG_ERR_100': {
        'code': 'MPG_ERR_100',
        'message': '同じ「商品グループID」のデータがすでに存在します。'
    },
    'DATABASE_ERROR': {
        'code': 102,
        'message': 'Database error occurred.'
    },
    'SEND_EMAIL_ERR_000': {
        'code': 'SEND_EMAIL_ERR_000',
        'message': '送信元アドレスが設定されていません。'
    },
    'SEND_EMAIL_ERR_001': {
        'code': 'SEND_EMAIL_ERR_001',
        'message': '宛先アドレスが設定されていません。'
    },
    'SEND_EMAIL_ERR_002': {
        'code': 'SEND_EMAIL_ERR_002',
        'message': 'メールのタイトルが空です。'
    },
    'SEND_EMAIL_ERR_003': {
        'code': 'SEND_EMAIL_ERR_003',
        'message': 'メールの本文が空です。'
    },
    'WS_ERR_000': {
        'code': 'WS_ERR_000',
        'message': '選択した「開催日」が正しくありません。'
    },
    'WS_ERR_001': {
        'code': 'WS_ERR_001',
        'message': '選択した「開催日」がすでに予約されました。'
    },
    'WS_ERR_002': {
        'code': 'WS_ERR_002',
        'message': '「surveys」情報がありません。'
    },
    'WS_ERR_003': {
        'code': 'WS_ERR_002',
        'message': '「企業コード」取得に失敗しました。'
    },
    'MES_ERR_100': {
        'code': 'MES_ERR_100',
        'message': '同じデータがすでに登録されています。'
    },
    'TRIAL_ERR_100': {
        'code': 'TRIAL_ERR_100',
        'message': '現在、トライアルは大変込み合っています。日を改めて申込下さい。'
    },
    'WORKSHOP_ERR_100': {
        'code': 'WORKSHOP_ERR_100',
        'message': '現在、ワークショップは大変込み合っています。日を改めて申込下さい。？？？'
    },
    'ACCOUNT_ERR_001': {
        'code': 'ACCOUNT_ERR_001',
        'message': 'メールアドレス（email_address）は必須項目です。'
    },
    'ACCOUNT_ERR_002': {
        'code': 'ACCOUNT_ERR_002',
        'message': '苗字(姓)（last_name）は必須項目です。'
    },
    'ACCOUNT_ERR_003': {
        'code': 'ACCOUNT_ERR_003',
        'message': '名前(名)（first_name）は必須項目です。'
    },
    'ACCOUNT_ERR_COMPANY_CODE': {
        'code': 'ACCOUNT_ERR_COMPANY_CODE',
        'message': '企業コードは必須項目です。'
    },
    'ACCOUNT_ERR_ACCOUNT_EXIST': {
        'code': 'ACCOUNT_ERR_ACCOUNT_EXIST',
        'message': 'アカウントがすでに存在します。'
    },
    'ACCOUNT_ERR_ACCOUNT_NOT_EXIST': {
        'code': 'ACCOUNT_ERR_ACCOUNT_NOT_EXIST',
        'message': 'アカウントは存在しません。'
    },
    'ACCOUNT_ERR_ROLES': {
        'code': 'ACCOUNT_ERR_ROLES',
        'message': 'ロールは必須項目です。'
    },
    'ACCOUNT_ERR_NOT_ROLES': {
        'code': 'ACCOUNT_ERR_NOT_ROLES',
        'message': '権限がありません。'
    },
    'STAFF_ERR_ACCOUNT_EXIST': {
        'code': 'STAFF_ERR_ACCOUNT_EXIST',
        'message': 'アカウントがすでに存在します。'
    },
        'MESASC_CSV_ERR_100': {
        'code': 'MESASC_CSV_ERR_100',
        'message': 'CSVファイルが存在しません。'
    },
}

RESPONSE_HEADERS = {
    'Access-Control-Allow-Headers': 'Content-Type',
    'Access-Control-Allow-Origin': '*',
    'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
}

# lambda名
LAMBDA_SYS_RDS = 'prod-lam-sys-rds'
LAMBDA_SYS_EMAIL = 'prod-lam-sys-email'
LAMBDA_SYS_COMN_PF = 'prod-lam-sys-comn-pf'
LAMBDA_SYS_PAYMENT = 'prod-lam-sys-payment'

ENTRA_ISSUER = 'https://sts.windows.net/'
ENTRA_AUTHORITY_URL = 'https://login.microsoftonline.com/'
ENTRA_AUTHORITY_PARAM = '/oauth2/v2.0/token'
ENTRA_SCOPE = [ 'https://graph.microsoft.com/.default' ]
ENTRA_JSON_URL = 'https://login.microsoftonline.com/common/discovery/keys'
ENTRA_ENDPOINT = 'graph.microsoft.com'

# S3
S3_BUCKET_NAME = '-s3-bt-comn-pf-001'

def handle_error(error_type, error_params=None, error=None):
    print('handle_error>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
    code = 500
    body = {}
    if error_type == 'ERROR':
        code = 500
        message = 'Unknown error occurred.'
        if error_params is not None:
            if type(error_params) is str:
                print('type(error_params) is str:')
                tmp = error_params.split(':')
                if len(tmp) > 1:
                    code = tmp[0]
                    message = tmp[1]
                else:
                    message = error_params
            elif type(error_params) is dict:
                print('type(error_params) is dict:')
                if 'code' in error_params:
                    code = error_params['code']
                if 'message' in error_params:
                    message = error_params['message']
            else:
                print(str(error_params))
                pass
        if error is not None:
            if type(error) is str:
                print('type(error) is str:')
                tmp = error.split(':')
                if len(tmp) > 1:
                    code = tmp[0]
                    message = tmp[1]
                else:
                    message = error
            elif type(error) is dict:
                print('type(error) is dict:')
                if 'code' in error:
                    code = error['code']
                if 'message' in error:
                    message = error['message']
            else:
                print(str(error))
                pass

        body = {
            'code': code,
            'message': message
        }
    elif error_type == 'AUTH0_ERROR':
        code = 400
        
        if error.error_code == 'Bad Request':
            # NO.5293の対応　li 2023/03/06 S
            # error.error_code = 'WORKSHOP_WARN_001'
            error.error_code = 'AUTH0_ERR_001'
            # NO.5293の対応　li 2023/03/06 E
            pass
        if error.error_code == 'auth0_idp_error':
            # NO.5293の対応　li 2023/03/06 S
            # error.error_code = 'WORKSHOP_WARN_001'
            error.error_code = 'AUTH0_ERR_002'
            # NO.5293の対応　li 2023/03/06 E
            pass

        if error.message == 'PasswordHistoryError: Password has previously been used':
            code = 200
            error.message = 'このパスワードは以前に使用されていたためご利用になれません。'
            pass
        elif error.message == 'PasswordStrengthError: Password is too weak':
            code = 200
            error.message = 'このパスワードは弱すぎます。'
            pass
        elif error.message == 'The user already exists.':
            code = 200
            error.message = 'ユーザーはすでに存在します。'
            pass
        # NO.5293の対応　li 2023/03/06 S
        elif error.message == 'The username provided is in use already.':
            code = 400
            error.message = '既にアカウント作成済みのメールアドレスです。'
            pass
        # NO.5293の対応　li 2023/03/06 E

        body = {
            'code': error.error_code,
            'message': error.message
        }
    elif error_type in ERROR_CODE:
        print('elif error_type in ERROR_CODE:')
        if error_params:
            code = 400
            body = {
                'code': ERROR_CODE[error_type]['code'],
                'message': ERROR_CODE[error_type]['message'].format(error_params)
            }
        else:
            code = 400
            body = {
                'code': ERROR_CODE[error_type]['code'],
                'message': ERROR_CODE[error_type]['message']
            }
    else:
        code = 500
        message = 'Unknown error occurred.'
        code = 500
        body = {
            'code': code,
            'message': message
        }

    # if DEV_ENV == 'local':
    #     return {
    #         'statusCode': code,
    #         'headers': RESPONSE_HEADERS,
    #         'body': body
    #     }
    # else:
    #     return {
    #         'statusCode': code,
    #         'headers': RESPONSE_HEADERS,
    #         'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    #         # 'body': body
    #     }


    if DEV_ENV == 'local':
        return {
            'statusCode': code,
            'headers': RESPONSE_HEADERS,
            'body': body
        }
    else:
        # if 'code'in body and body['code'] == 444:
        #     # return {
        #     #     'statusCode': code,
        #     #     'headers': RESPONSE_HEADERS,
        #     #     # 'data': json.dumps(body, default=str, ensure_ascii=False, indent=2)
        #     #     'body': body
        #     # }
        #     return body
        # return {
        #     'statusCode': code,
        #     'headers': RESPONSE_HEADERS,
        #     'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
        #     # 'body': body
        # }
        return {
            'statusCode': code,
            'headers': RESPONSE_HEADERS,
            'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
            # 'body': body
        }