DEV_ENV = 'prod'
###############################################################################
#####     名前:componet.py  
#####     内容：XXXXX
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################
import json
import http.client
# from .parameters import *
from urllib.request import urlopen
from jose import jwt
import logging
import requests
import base64
import secrets
import string
import urllib.parse

import os
PRE_ENTRA_ID_TENANT = '' # 前回のテナント

if DEV_ENV == 'local':
    from .parameters import *
    from .lambda_function import GV
    from .process import Base
    # from .env import *
else:
    from parameters import *
    from lambda_function import GV
    from process import Base
    # from env import *

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)
###############################################################################
#####     名前:　get_token_auth_header  
#####     内容： Token取得
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################


# ----------------------------------------------------------------
# Error handler
class AuthError(Exception):
    def __init__(self, error, status_code):
        self.error = error
        self.status_code = status_code

###############################################################################
#####     名前:main(引数なし)  
#####     内容： 単体デバッグ用
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################
class EntraComponet:

    ###############################################################################
    ###### 初期化処理
    ###### トークンの発行を行う
    ###### 
    ###############################################################################
    def __init__(self):
        global PRE_ENTRA_ID_TENANT
        print(f'tenant:{GV.ENTRA_ID_TENANT}')
        # テナントによって切り替える
        #EntraIDの設定
        logger.debug('entra_component init')

        readDBTable = False
        # 前回取得済みでは  ないならDBからテナント情報を取得する
        if 'PRE_TENANT' not in GV.CONFIG:
            readDBTable = True
        elif 'PRE_TENANT' in GV.CONFIG and GV.CONFIG['PRE_TENANT'] != GV.ENTRA_ID_TENANT:
            readDBTable = True
        
        if readDBTable == True:
            params = {
                'table_name': 'm_auth0_management',
                'filters': {
                    'tenant': GV.ENTRA_ID_TENANT
                }
            }
            base = Base()
            data_m_am = base.get_data(params)
            print(f"data_m_am:{data_m_am}")

            if data_m_am:
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['APP_REDIRECT_URL'] = data_m_am['app_redirect_url']
                GV.CONFIG['APP_RESOURCE_ID'] = data_m_am['app_resource_id'] #オブジェクトID（エンタープライズ）
                GV.CONFIG['APP_RESOURCE_ID_APPSTREAM'] = data_m_am['app_resource_id_appstream']
                GV.CONFIG['APP_ROLE_ID'] = data_m_am['app_role_id']#マニフェストから、’User’のロールID（固定）
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                GV.CONFIG['PRE_TENANT'] = data_m_am['tenant']
                pass
            else:
                return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}        

            # 前回のテナント名を設定
            PRE_ENTRA_ID_TENANT = GV.ENTRA_ID_TENANT

        print(f"GV.CONFIG:{GV.CONFIG}")
        self.ENTRA_API_AUDIENCE = GV.CONFIG['AUTH0_AUDIENCE'] 
        self.ENTRA_CLIENT_ID = GV.CONFIG['AUTH0_CLIENT_ID']
        self.ENTRA_CLIENT_SECRET = GV.CONFIG['AUTH0_CLIENT_SECRET']
        self.ENTRA_TENANT_ID = GV.CONFIG['AUTH0_DOMAIN']
        self.APP_ID = GV.CONFIG['API_AUDIENCE']
        self.APP_REDIRECT_URL = GV.CONFIG['APP_REDIRECT_URL']
        self.APP_RESOURCE_ID = GV.CONFIG['APP_RESOURCE_ID']
        self.APP_RESOURCE_ID_APPSTREAM = GV.CONFIG['APP_RESOURCE_ID_APPSTREAM']
        self.APP_ROLE_ID = GV.CONFIG['APP_ROLE_ID']

        self.ENTRA_ISSUER = GV.ENTRA_ISSUER + self.ENTRA_TENANT_ID +'/' #テナントID
        self.ENTRA_AUTHORITY = GV.ENTRA_AUTHORITY_URL + self.ENTRA_TENANT_ID + GV.ENTRA_AUTHORITY_PARAM #修正

        self.ENTRA_SCOPE = GV.ENTRA_SCOPE #固定値
        self.ENTRA_JSON_URL = GV.ENTRA_JSON_URL
        self.ENTRA_ENDPOINT = GV.ENTRA_ENDPOINT



        '''
        #Auth0 ⇒ Entra
        id ⇒ id
        email ⇒ mail
        phone_number ⇒ mobilePhone
        given_name ⇒ givenName
        family_name ⇒ surname
        blocked ⇒ not accountEnabled
        name ⇒ displayName 
        username ⇒ displayName
        password ⇒ passwordProfile
        email_verified ⇒ officeLocation
        user_metadata ⇒ onPremisesExtensionAttributes extensionAttribute1
        app_metadata ⇒ onPremisesExtensionAttributes extensionAttribute2
        appstream ⇒ onPremisesExtensionAttributes extensionAttribute3

        $select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes
        '''

        # トークンを取得するためのデータ
        payload = {
            'client_id': self.ENTRA_CLIENT_ID,
            'client_secret': self.ENTRA_CLIENT_SECRET,
            'scope': self.ENTRA_SCOPE,
            'grant_type': 'client_credentials'
        }
        logger.debug(self.ENTRA_CLIENT_ID)
        logger.debug(self.ENTRA_CLIENT_SECRET)
        logger.debug(self.ENTRA_SCOPE)
        # トークンを取得
        token_response = requests.post(self.ENTRA_AUTHORITY, data=payload)
        token_response_json = token_response.json()

        if 'access_token' in token_response_json:
            self.TOKEN = token_response_json['access_token']
            logger.info("Get token")
        else:
            self.TOKEN = json.loads("Could not acquire token")
            logger.info("Could not acquire token")


        
    ###############################################################################
    ###### パスワード再発行　
    ######  ⇒　Auth0はパスワード変更のURLを指定メール先に送信する
    ######  ⇒　Entraは新しいパスワード変更を設定する：新パスワードを戻り値にする 未使用のよう。使うと403エラーになる
    ###############################################################################
    def send_change_password(self, email):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logger.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        # path=f"/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes&$filter=mail%20eq%20'" + urllib.parse.quote(email) + "'"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logger.info("Error occured at 'send_change_password:users'.")
            logger.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        for user_dic in user_list:
            #logger.info(f"Me:{conv_dic['mail']}")

            #指定メールアドレスと検索IDのメールアドレスが一致しているか確認
            if email == user_dic['mail'] :
                #新しいパスワード生成（8文字以上？）
                length=8
                pass_chars = string.ascii_letters + string.digits
                password = ''.join(secrets.choice(pass_chars) for x in range(length))     

                logger.info(f"ID:{user_dic['id']}")
                logger.info(f"New Password:{password}")
            
                # 更新するデータを設定(EntraID向け)
                set_data = {
                    "newPassword": password
                }

                #パスワード認証方法の ID(EntraID固定)
                passwordMethodsid = '28c10230-6103-485e-b985-444c60001490'

                #作成クエリ（例:指定したidに一致するユーザーを検索）
                path=f"/v1.0/users/{user_dic['id']}/authentication/methods/{passwordMethodsid}/resetPassword"

                conn.request("POST", path, body=json.dumps(set_data), headers=headers)
                response = conn.getresponse()

                # エラー処理
                if not (200 <= response.status < 300) :
                    logger.info("Error occured at 'send_change_password:resetPassword'.")
                    logger.info(vars(response))
                    return ''

                data = response.read().decode("utf-8")
                conn.close()

                logger.info(f"Response:{data}")
            
                #return response
                return password

        return '' #Error
    
    ###############################################################################
    ###### アプリケーションに割り当てられているユーザー取得　
    ######  ⇒　なぜか取得できない　※Free契約だから？
    ###### 
    ###############################################################################
    def get_app_user_list(self, parameter:GetUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # POSTリクエストでユーザを作成
        #conn.request("GET", f"/v1.0/servicePrincipals(appId='{self.APP_ID}')/appRoleAssignments",  headers=headers)
        conn.request("GET", f"/v1.0/servicePrincipals(appId='{self.APP_ID}')/appRoleAssignedTo",  headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'get_app_user_list:servicePrincipals'.")
            logger.info(vars(response))
            return ''

        data = response.read().decode("utf-8")
        conn.close()

        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        auth_list=[]
        auth_dic={}
        #logger.info(parameter.id)

        for user_dic in user_list:
            auth_dic['id']=user_dic['principalId']
            auth_dic['name']=user_dic['principalDisplayName']
            auth_dic['username']=user_dic['principalDisplayName']

            auth_list.append(auth_dic)
            auth_dic={}

        # 結果を表示
        return auth_list

    ###############################################################################
    ###### ユーザーにアプリケーションを割り当てる　
    ###### 入力パラメータをGetUserParamに設定する（利用はidのみ）
    ###### 戻り値は、JSON
    ###############################################################################
    def set_app_to_user(self, parameter:GetUserParam):

        #parameter.id='7937a54c-acec-4808-928d-b3e18c12b5bb' #手動でコピー

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        #対象ID設定：email(userPrincipalName)
        # 更新するユーザのIDと更新データを設定(EntraID向け)
        set_data = {
            "principalId": parameter.id,
            "resourceId": self.APP_RESOURCE_ID,
            "appRoleId": self.APP_ROLE_ID
        }

        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}/appRoleAssignments"

        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'set_app_to_user:appRoleAssignments'.")
            logger.info(vars(response))
            return ''

        data = response.read().decode("utf-8")
        conn.close()

        #対象ID設定：email(userPrincipalName)
        # 更新するユーザのIDと更新データを設定(EntraID向け)
        set_data = {
            "principalId": parameter.id,
            "resourceId": self.APP_RESOURCE_ID_APPSTREAM,
            "appRoleId": self.APP_ROLE_ID
        }

        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}/appRoleAssignments"

        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'set_app_to_user:appRoleAssignments'.")
            logger.info(vars(response))
            return ''

        data = response.read().decode("utf-8")
        conn.close()

        # 結果を表示
        return json.loads(data)
        '''
        {
            "@odata.context": "https://graph.microsoft.com/v1.0/$metadata#users('4fea7e4e-e6df-49b2-b2f6-02a3e0608530')/appRoleAssignments/$entity",
            "id": "Tn7qT9_mskmy9gKj4GCFMKHPNXdfaLNKijzEbkrod_4",
            "deletedDateTime": null,
            "appRoleId": "18d14569-c3bd-439b-9a66-3a2aee01d14f",
            "createdDateTime": "2024-10-10T10:01:02.9772692Z",
            "principalDisplayName": "NDES Taro",
            "principalId": "4fea7e4e-e6df-49b2-b2f6-02a3e0608530",
            "principalType": "User",
            "resourceDisplayName": "SUP_NDES",
            "resourceId": "5a722468-c752-47b6-9e37-4bb0b3783914"
        }
        '''
    ###############################################################################
    ###### ユーザーリスト取得
    ###### パラメータに応じたユーザーリストを取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user_list(self, parameter:GetUsersParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logger.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        path=f"/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        auth_list=[]
        while path:
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            print(res.status)

            # エラー処理
            if (200 <= res.status < 300):
                data = res.read().decode("utf-8")
                conn.close()

                # JSONデータを辞書型に変換
                conv_dic = json.loads(data)
                user_list = conv_dic['value']
                path = conv_dic.get('@odata.nextLink', None)
                auth_dic={}

                for user_dic in user_list:
                    #print(user)
                    #user_dic = json.loads(user)
                    auth_dic['id']=user_dic['id']
                    auth_dic['email']=user_dic['mail']
                    auth_dic['phone_number']=user_dic['mobilePhone']
                    auth_dic['given_name']=user_dic['givenName']
                    auth_dic['family_name']=user_dic['surname']
                    auth_dic['blocked']=not user_dic['accountEnabled']
                    auth_dic['name']=user_dic['displayName']
                    auth_dic['username']=user_dic['displayName']
                    auth_dic['email_verified']=user_dic['officeLocation']

                    #Attribute1はJSONのためでbase64でencodeされている        
                    if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                        auth_dic['user_metadata']={'data': []}
                    else :
                        base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                        decode_str_1=base64_decode_1.decode()
                        auth_dic['user_metadata']=json.loads(decode_str_1)
                        #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                    #Attribute2はJSONのためでbase64でencodeされている        
                    if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                        auth_dic['app_metadata']={'data': []}
                    else :
                        base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                        decode_str_2=base64_decode_2.decode()
                        auth_dic['app_metadata']=json.loads(decode_str_2)
                        #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                    #Attribute3はJSONではないと仮定
                    auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']

                    auth_list.append(auth_dic)
                    auth_dic={}
            else:
                logger.info("Error occured at 'get_users_by_email:users'.")
                print(f"Error: {res.status}")
                print(res.read().decode())
                break

            conn.close()

        # 結果を表示
        return auth_list
    
    ###############################################################################
    ###### ユーザー情報取得
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user(self, parameter:GetUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logger.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/users/{parameter.id}?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logger.info("Error occured at 'get_user_list:users'.")
            logger.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        auth_dic={}

        auth_dic['id']=conv_dic['id']
        auth_dic['email']=conv_dic['mail']
        auth_dic['phone_number']=conv_dic['mobilePhone']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']
        auth_dic['username']=conv_dic['displayName']
        auth_dic['email_verified']=conv_dic['officeLocation']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata']={'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute2はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
            auth_dic['app_metadata']={'data': []}
        else :
            base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
            decode_str_2=base64_decode_2.decode()
            auth_dic['app_metadata']=json.loads(decode_str_2)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute3はJSONではないと仮定
        auth_dic['appstream']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute3']

        conn.close()

        # 結果を表示
        return auth_dic

    ###############################################################################
    ###### ユーザー情報取得　(Tokenチェック)
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user_by_auth(self, auth):

        # Auth0の場合はSplitしていたが、Entra時はTokenそのものとする
        token = auth

        jsonurl = urlopen(self.ENTRA_JSON_URL)
        jwks = json.loads(jsonurl.read())

        unverified_header = jwt.get_unverified_header(token)
        rsa_key = {}

        for key in jwks["keys"]:
            if key["kid"] == unverified_header["kid"]:
                rsa_key = {
                    "kty": key["kty"],
                    "kid": key["kid"],
                    "use": key["use"],
                    "n": key["n"],
                    "e": key["e"]
                }

        # Auth0バージョンはエラー処理していない（EntraID開発でいれたDebug用処理を残す）
        try:
            payload = jwt.decode(
                token,
                rsa_key,
                algorithms=["RS256"],
                audience=self.ENTRA_API_AUDIENCE,
                issuer=self.ENTRA_ISSUER
            )
        except jwt.ExpiredSignatureError:
            print("code:token_expired  description: token is expired")
        except jwt.JWTClaimsError:
            print("code:invalid_claims description: incorrect claims, please check the audience and issuer")
        except Exception:
            print("code:invalid_header description: Unable to parse authentication token.")

        # ユーザ情報取得　※取得対象者はToken内に記載されたユーザ
        user_param = GetUserParam()
        #logger.info(payload['sub'])
        #'sub': '29ba7061-b0a6-43bd-bb8a-39fa26c88cbb', 
        user_param.id = payload['sub']
        return self.get_user(user_param)

    ###############################################################################
    ###### ユーザー新規登録　※外部ドメインユーザを招待する　2024.10.22変更　
    ###### ユーザーを新規登録する
    ###### ※拡張属性はUpdateで追加
    ###############################################################################
    def create_user(self, parameter:CreateUserParam):
        print("entra_component.py:create_user")

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }
        print(f"parameter:{parameter}")

        # ユーザを作成するためのデータ(EntraID向け)
        create_data = json.dumps({
            "invitedUserEmailAddress": parameter.email,
            "inviteRedirectUrl": self.APP_REDIRECT_URL,
            #"sendInvitationMessage" : False #招待メールを飛ばさない
            "sendInvitationMessage" : True #招待メールを飛ばす
        })

        print("entra_component.py:create_user:ユーザー新規登録　※外部ドメインユーザを招待する")
        # POSTリクエストでユーザを作成
        conn.request("POST", "/v1.0/invitations", body=create_data, headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'create_user:invitations'.")
            logger.info(vars(response))
            return ''

        # 追加されたユーザのOIDを取得し、アプリケーションに割り当て
        # JSONデータを辞書型に変換
        data = response.read().decode("utf-8")
        print(f"response data:{data}")
        data_dic = json.loads(data)
        auth_dic={}

        logger.debug(data_dic)
        auth_dic['email']=data_dic['invitedUserEmailAddress']
        auth_dic['user_id']=parameter.email
        auth_dic['id'] = data_dic['invitedUser']['id']
        auth_dic['inviteRedeemUrl']=data_dic['inviteRedeemUrl']
        auth_dic['status']=data_dic['status']

        #####################################################################
        # 新規ユーザをアプリケーションに登録する
        # ※AppStreamへの追加を実施してない ⇒ テストで確認が必要
        #####################################################################

        set_data = {
            "principalId": data_dic['invitedUser']['id'],
            "resourceId": self.APP_RESOURCE_ID,
            "appRoleId": self.APP_ROLE_ID
        }

        print("entra_component.py:create_user:新規ユーザをアプリケーションに登録する")
        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{auth_dic['id']}/appRoleAssignments"
        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'create_user:appRoleAssignments'.")
            logger.info(vars(response))
            return ''

        data2 = response.read().decode("utf-8")
        print(f"response data:{data2}")
        data2_dic = json.loads(data2)
    
        auth_dic['type']=data2_dic['principalType']
        auth_dic['resource_name']=data2_dic['resourceDisplayName']
       
        conn.close()

        set_data = {
            "principalId": data_dic['invitedUser']['id'],
            "resourceId": self.APP_RESOURCE_ID_APPSTREAM,
            "appRoleId": self.APP_ROLE_ID
        }

        print("entra_component.py:create_user:ユーザーを検索")
        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{auth_dic['id']}/appRoleAssignments"
        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'create_user:appRoleAssignments'.")
            logger.info(vars(response))
            return ''

        data2 = response.read().decode("utf-8")
        data2_dic = json.loads(data2)
        print("entra_component.py:create_user:L.675")
   
        auth_dic['type']=data2_dic['principalType']
        auth_dic['resource_name']=data2_dic['resourceDisplayName']
       
        conn.close()

        # 結果を表示
        return auth_dic

    ###############################################################################
    ###### ユーザー削除　
    ###### ユーザーを削除する
    ###### ※
    ###############################################################################
    def delete_user(self, parameter:CreateUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("DELETE", path, headers=headers)

        # POSTリクエストでユーザを作成
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'delete_user:users'.")
            logger.info(vars(response))
            return ''

        #data = response.read().decode("utf-8")
        conn.close()

        return response

    ###############################################################################
    ###### ユーザー更新　
    ###### 既存のユーザーを更新する（拡張領域を含む）
    ###### ※UpdateUserParamの拡張領域がLISTではなくSTRになっている
    ###############################################################################
    def update_user(self, parameter:UpdateUserParam):

        logger.info(dir(parameter))

        #user_idが存在しない場合エラーとする
        if(not 'id' in dir(parameter)):
            logger.info("user id is not exist.")
            return 'error'

        update_data = {}

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        #user_metadata,app_metadata,appstreamは一括変更となるので、面倒
        #user_metadata,app_metadata,appstreamの全部の項目がある場合 ⇒ 指定されたパラメータを設定する
        if('appstream' in dir(parameter) and 'user_metadata' in dir(parameter) and 'app_metadata' in dir(parameter)):

            # JSONデータを文字列に変換 user_metadata
            # 文字列をバイナリに変換
            binary_data1 =  json.dumps(parameter.user_metadata).encode('utf-8')
            data_encode_str1 = base64.b64encode(binary_data1).decode('utf-8')

            logger.info(data_encode_str1)

            # JSONデータを文字列に変換 app_metadata
            # 文字列をバイナリに変換
            binary_data2 =  json.dumps(parameter.app_metadata).encode('utf-8')
            data_encode_str2 = base64.b64encode(binary_data2).decode('utf-8')

            # appstream
            data_encode_str3=parameter.appstream

            # 更新するユーザのIDと更新データを設定(EntraID向け)
            attribute_data = {
                "onPremisesExtensionAttributes": {
                    #"extensionAttribute1": json.dumps(parameter.user_metadata).encode('utf-8'),
                    "extensionAttribute1": data_encode_str1,
                    "extensionAttribute2": data_encode_str2,
                    "extensionAttribute3": data_encode_str3,
                }
            }
            update_data.update(attribute_data)

        #user_metadata,app_metadata,appstreamのいずれかの項目が１つ以上あって、全部の項目がある場合でない時⇒既存データを取得
        elif('appstream' in dir(parameter) or 'user_metadata' in dir(parameter) or 'app_metadata' in dir(parameter)): 
            #既存データを取得
            current = EntraComponet()
            search_param = GetUserParam()

            search_param.id = parameter.id
            result = current.get_user(search_param)
            conv_dic = result
            user_param = UpdateUserParam()
            user_param.id=conv_dic['id']

            #存在しない項目に設定済みデータを代入する
            if(not 'user_metadata' in dir(parameter)):
                parameter.user_metadata = conv_dic['user_metadata']

            if(not 'app_metadata' in dir(parameter)):
                parameter.app_metadata = conv_dic['app_metadata']

            if(not 'appstream' in dir(parameter)):
                parameter.appstream = conv_dic['appstream']

            # JSONデータを文字列に変換 user_metadata
            # 文字列をバイナリに変換
            binary_data1 =  json.dumps(parameter.user_metadata).encode('utf-8')
            data_encode_str1 = base64.b64encode(binary_data1).decode('utf-8')
            logger.info(data_encode_str1)

            # JSONデータを文字列に変換 app_metadata
            # 文字列をバイナリに変換
            binary_data2 =  json.dumps(parameter.app_metadata).encode('utf-8')
            data_encode_str2 = base64.b64encode(binary_data2).decode('utf-8')
            logger.info(data_encode_str2)

            data_encode_str3 = parameter.appstream

            #対象ID設定：email(userPrincipalName)
            # 更新するユーザのIDと更新データを設定(EntraID向け)
            attribute_data = {
                "onPremisesExtensionAttributes": {
                    #"extensionAttribute1": json.dumps(parameter.user_metadata).encode('utf-8'),
                    "extensionAttribute1": data_encode_str1,
                    "extensionAttribute2": data_encode_str2,
                    "extensionAttribute3": data_encode_str3,
                }
            }

            update_data.update(attribute_data)
        
        #blockedは真偽をひっくり返す
        if('blocked' in dir(parameter) ):
            blocked_data = {
                'accountEnabled': not parameter.blocked,
            }

            update_data.update(blocked_data)

        #password ⇒  'password': 'P@ssW0rdNDES' 'password': 'P@ssW0rd202305'
        if('password' in dir(parameter) ):
            password_data = {
                "passwordProfile": {
                    "password": parameter.password,
                    "forceChangePasswordNextSignIn": False
                }
            }

            update_data.update(password_data)

        #phone_number
        if('phone_number' in dir(parameter) ):
            phone_number_data = {
                'mobilePhone': parameter.phone_number,
            }

            update_data.update(phone_number_data)

        #given_name
        if('given_name' in dir(parameter) ):
            given_name_data = {
                'givenName': parameter.given_name,
            }

            update_data.update(given_name_data)

        #family_name
        if('family_name' in dir(parameter) ):
            family_name_data = {
                'surname': parameter.family_name,
            }

            update_data.update(family_name_data)

        #name or username
        if('name' in dir(parameter) or 'username' in dir(parameter)):
            username_data = {
                'displayName': parameter.username,
            }

            update_data.update(username_data)

        #email_verified
        if('email_verified' in dir(parameter) ):
            email_verified_data = {
                'officeLocation': parameter.email_verified,
            }

            update_data.update(email_verified_data)

        logger.info(update_data)

        # 更新クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("PATCH", path, body=json.dumps(update_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logger.info("Error occured at 'update_user:users'.")
            logger.info(vars(response))
            logger.info(path)
            logger.info(json.dumps(update_data))
            logger.info(headers)
            return ''

        conn.close()
        logger.info(response.status)

        # 結果を表示
        return vars(parameter)

    #ENTRA_ENDPOINT="https://graph.microsoft.com/v1.0/users"

    ###############################################################################
    ###### メールでユーザーを検索
    ######
    ######
    ###############################################################################
    def get_users_by_email(self, parameter:GetUsersByEmailParam):
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        logger.info(parameter.email)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #conn.request("GET", "/api/v2/users-by-email?fields=" + parameter.fields + "&email=" + parameter.email.lower() , None, headers)
        #path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes&$filter=mail%20eq%20'" + urllib.parse.quote(parameter.email) + "'"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logger.info("Error occured at 'get_users_by_email:users'.")
            logger.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        auth_dic={}
        #logger.info(user_list)

        for user_dic in user_list:
            #logger.info(str(user_dic['mail']).lower())
            #指定メールアドレスと検索IDのメールアドレスが一致しているか確認
            if parameter.email.lower() == str(user_dic['mail']).lower() :
                auth_dic['id']=user_dic['id']
                auth_dic['user_id']=user_dic['mail']
                auth_dic['email']=user_dic['mail']
                auth_dic['phone_number']=user_dic['mobilePhone']
                auth_dic['given_name']=user_dic['givenName']
                auth_dic['family_name']=user_dic['surname']
                auth_dic['blocked']=not user_dic['accountEnabled']
                auth_dic['name']=user_dic['displayName']
                auth_dic['username']=user_dic['displayName']
                auth_dic['email_verified']=user_dic['officeLocation']

                #Attribute1はJSONのためでbase64でencodeされている        
                if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                    auth_dic['user_metadata']={'data': []}
                else :
                    base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                    decode_str_1=base64_decode_1.decode()
                    auth_dic['user_metadata']=json.loads(decode_str_1)
                    #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                #Attribute2はJSONのためでbase64でencodeされている        
                if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                    auth_dic['app_metadata']={'data': []}
                else :
                    base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                    decode_str_2=base64_decode_2.decode()
                    auth_dic['app_metadata']=json.loads(decode_str_2)
                    #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                #Attribute3はJSONではないと仮定
                auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']

                logger.info("Find user data by email")

                print('auth_dic', auth_dic)

                return [ auth_dic ]

        logger.info("Can't find user data by email")
        return ''

    ###############################################################################
    ###### Audit Log を取得
    ######　※page対応を内部したので、呼び出し時のpage処理を削除してください
    ######  ※プレミアムライセンスがないと動作しません
    ###############################################################################
    def _get_logs(self, q):

        #初期化
        page_size= 50
        auth_list=[]
        auth_dic={}

        #GET https://graph.microsoft.com/v1.0/auditLogs/signIns?$filter=createdDateTime ge 2024-07-01T00:00:00Z and createdDateTime le 2024-07-14T23:59:59Z

        logger.info(q)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #path=f"/v1.0/auditLogs/signIn?${q}&$top={page_size}"
        path=f"/v1.0/auditLogs/signIns?$top={page_size}"


        while path:

            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
            headers = {
                'Authorization': f'Bearer {self.TOKEN}',
                'Content-Type': 'application/json'
            }

            logger.info(path)

            conn.request("GET", path, headers=headers)
            res = conn.getresponse()

            if (200 <= res.status < 300):
                data = json.loads(res.read().decode())
                entra_list = data.get('value', [])
                path = data.get('@odata.nextLink', None)

                for entra_log in entra_list:

                    auth_dic['type_code'] = entra_log['conditionalAccessStatus']
                    auth_dic['event_type'] = entra_log['status failureReason']
                    auth_dic['date'] = entra_log['createdDateTime']
                    auth_dic['ip'] = entra_log['ipAddress']
                    auth_dic['client_name'] = entra_log['appDisplayName']
                    auth_dic['user_id'] = entra_log['userId']
                    auth_dic['user_name'] = entra_log['userDisplayName']

                    entra_agent = f"{entra_log['deviceDetail']['browser']} / {entra_log['deviceDetail']['operatingSystem']}"

                    auth_dic['user_agent'] = entra_agent
                    auth_dic['log_id'] = entra_log['id']

                    auth_list.append(auth_dic)
                    auth_dic={}

            else:
                print(f"Error: {res.status}")
                print(res.read().decode())
                break

            conn.close()

        return auth_list

    ###############################################################################
    ###### Queryをつかってユーザを検索する（app_metadata内）
    ######　app_metadata.data.staff/trial/workshop/contract/_req_vefification_code:
    ######　app_metadata.data.change_admin_user_vefification_code:
    ######   query = f'app_metadata.data.workshop_req_vefification_code: "{code}"'
    ###############################################################################
    def search_user(self, q):
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #conn.request("GET", "/api/v2/users-by-email?fields=" + parameter.fields + "&email=" + parameter.email.lower() , None, headers)
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logger.info("Error occured at 'get_users_by_email:users'.")
            logger.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        logger.debug(conv_dic)
        user_list = conv_dic['value']
        logger.debug(user_list)

        auth_dic={}
        auth_list=[]
        auth_dic={}

        #logger.info(user_list)

        #Queryが存在する場合、辞書型に変換する
        if len (q) != 0 :
            query_split=q.split(":")
            key_split=str(query_split[0]).split(".")
            #app_metadata.data.staff_req_verification_codeの最後を指定　key_split[2]
            logger.info(key_split[0])
            logger.info(key_split)
            query_dic={key_split[2]:(str(query_split[1]).strip()).strip('"')}
            logger.info(query_dic)
            #logger.info(query_dic.keys())
            #logger.info(query_dic.values())

        #Queryが存在する場合の検索ループ
        for user_dic in user_list:
            auth_dic['id']=user_dic['id']
            auth_dic['email']=user_dic['mail']
            auth_dic['phone_number']=user_dic['mobilePhone']
            auth_dic['given_name']=user_dic['givenName']
            auth_dic['family_name']=user_dic['surname']
            auth_dic['blocked']=not user_dic['accountEnabled']
            auth_dic['name']=user_dic['displayName']
            auth_dic['username']=user_dic['displayName']
            auth_dic['email_verified']=user_dic['officeLocation']

            #Attribute1はJSONのためでbase64でencodeされている        
            if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']={'data': []}
            else :
                base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

            #Attribute2はJSONのためでbase64でencodeされている        
            if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                auth_dic['app_metadata']={'data': []}
            else :
                base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                decode_str_2=base64_decode_2.decode()
                auth_dic['app_metadata']=json.loads(decode_str_2)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

            #Attribute3はJSONではないと仮定
            auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']
            logger.debug(auth_dic)
            #検索Query文字列が存在する場合
            if len (q) != 0 :
                target_item = dict(auth_dic[key_split[0]])
                logger.debug(target_item)
                #値が存在する場合
                if target_item and (key_split[1] in target_item):
                    target_data = target_item.get(key_split[1])
                    logger.debug(target_data)
                    target_dic=dict(target_data) #もしかしてループにする必要あり？
                    logger.debug(target_dic)
                    if key_split[2] in target_dic:

                        target_value=target_dic[key_split[2]]

                    #print(target_item)      
                    #print(target_data)      
                        logging.debug(target_value) 

                    #指定したKEY/VALUEが一致するか？     
                        if(target_value == query_dic[key_split[2]]):
                            #logger.info("Find user data matching query")
                            #ユーザリストに追加する     
                            auth_list.append(auth_dic)
                            auth_dic={}
                    
            else :
                #すべてのユーザデータが対象
                #ユーザリストに追加する     
                auth_list.append(auth_dic)
                auth_dic={}

        # 結果を表示
        return auth_list 
    
    ###############################################################################
    ###### ユーザーが招待中かどうか確認する　
    ###### Verification画面対応
    ###### ※拡張属性はUpdateで追加
    ###############################################################################
    def check_invitation_user(self, email):

        entra = EntraComponet()
        user_param = GetUsersByEmailParam()
        user_param.email = email
        print(email)

        result = entra.get_users_by_email(user_param)
        print(result)
        res_user = result[0]

        if res_user :

            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
            headers = {
                'Content-Type': 'application/json',
                'Authorization': f'Bearer {self.TOKEN}'  
            }

            #logger.info(headers)

            # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
            path = f"/v1.0/users/{res_user['id']}?$select=id,mail,accountEnabled,externalUserState"
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()

            # エラー処理
            if not 200 <= res.status < 300 :
                logger.info("Error occured at 'check_invitation_user:invitations'.")
                logger.info(vars(res))
                conn.close()
                # 結果を表示
                return ''
            else :
                data = json.loads(res.read().decode())
                conn.close()
                print(data.keys())
                auth_dic={}
                auth_dic['id']=data.get('id')
                auth_dic['email']=data.get('mail')
                auth_dic['status']=data.get('externalUserState')

                #承認済みの場合
                if auth_dic['status'] == 'Accepted' :
                    logger.info("User accepted.")
                        # 結果を表示
                    return auth_dic
                else :
                    logger.info(f"Invitation Status : {auth_dic['id']} / {auth_dic['email']} / {auth_dic['status']}")
                    return ''
