import json
from .controller import Base, CustomException, GV, os, logging, json, datetime, timedelta, and_, asc, boto3

import logging
logger = logging.getLogger(__name__)
# logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'workshop'

    def get_all(self, event, context):

        # from ..view.view_workshop import Sub as VW
        # v_w = VW()
        VW = GV.get_module('view_workshop')
        v_w = VW()

        return v_w.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_workshop import Sub as VW
        # v_w = VW()
        VW = GV.get_module('view_workshop')
        v_w = VW()

        v_w.table_config = self.table_name
        return v_w.get_table_schema()

        pass

    # ワークショップ開催日取得
    def get_workshop_date(self):
        logger.debug('get_workshop_date')

        if GV.PATH_PARAMETERS:
            logger.debug(GV.PATH_PARAMETERS)
        else:
            if GV.EVENT_BODY:
                logger.debug(GV.EVENT_BODY)

        # from datetime import datetime
        from dateutil.relativedelta import relativedelta

        logger.debug('# 当月と来月の開催日取得する')

        today = datetime.today()

        logger.debug('# 当月の最初の日を取得する')
        first_date_of_current_month = datetime(today.year, today.month, 1)

        logger.debug('# 再来月の最初の日を取得する')
        day_of_month_after_next = today + relativedelta(months=2)
        first_date_of_month_after_next = datetime(
            day_of_month_after_next.year, day_of_month_after_next.month, 1)

        logger.debug(GV.SYSTEM_ID)
        logger.debug(GV.SERVICE_ID)

        # from ..model.m_workshop_event_date import Sub as MWED
        # m_wed = MWED()
        MWED = GV.get_module('m_workshop_event_date')
        m_wed = MWED()

        logger.debug('# 検索条件')
        filters = []
        filters.append(m_wed.model_class.system_id == GV.SYSTEM_ID)
        filters.append(m_wed.model_class.service_id == GV.SERVICE_ID)
        filters.append(m_wed.model_class.workshop_event_date >=
                       first_date_of_current_month)
        filters.append(m_wed.model_class.workshop_event_date <
                       first_date_of_month_after_next)
        filters = and_(*filters)

        logger.debug('# 並び替え 開催日順')
        col = getattr(m_wed.model_class, 'workshop_event_date', None)
        order_by = asc(col)

        tmp_m_wed = m_wed._get_item_by_filters(
            filters, order_by=order_by, get_all=True)
        logger.debug(tmp_m_wed)
        data_m_wed = []
        for item in tmp_m_wed:

            logger.debug(item)

            # 受付終了Flag
            end_of_reception = False
            if self.NOW > item.workshop_event_date:
                end_of_reception = True

            # ステータス表示名
            status_label = ''

            logger.debug('# ******************************')
            logger.debug('# ・DBに登録されているワークショップ実施日のうち2か月分の午前と午後を表示。')
            logger.debug('# ・今日から3日後より後かつ予約が埋まっていない日時：選択可能')
            logger.debug('# ・今日から3日後より後かつ予約が埋まってる日時：選択不可能。「満席」と表示する。')
            logger.debug('# ・今日から3日後より前の日時：選択不可能。「受付終了」と表示する。')
            logger.debug('# ・1つのみ選択可能')

            today = datetime.now()
            # NO.5284 の対応　li 2023/03/06 S
            # three_days_later = today + timedelta(days=3)
            three_days_later = today + relativedelta(days=3)
            
            if str(item.workshop_event_date)[:10] > str(three_days_later)[:10]:
            # NO.5284 の対応　li 2023/03/06 E

                if item.workshop_request_flg == False:
                    logger.debug('# ・今日から3日後より後かつ予約が埋まっていない日時：選択可能')

                    end_of_reception = False
                    status_label = ''
                else:
                    logger.debug('# ・今日から3日後より後かつ予約が埋まってる日時：選択不可能。「満席」と表示する。')

                    end_of_reception = False
                    status_label = '満席'

            else:
                logger.debug('# ・今日から3日後より前の日時：選択不可能。「受付終了」と表示する。')

                end_of_reception = True
                status_label = '受付終了'

            logger.debug('# ##############################')

            item.workshop_event_date = item.workshop_event_date.strftime(
                '%Y/%m/%d')

            tmp_dc = item.to_dict()

            logger.debug('# クライアント側に返す必要な列を削除')
            del tmp_dc['service_id']
            del tmp_dc['system_id']
            del tmp_dc['cdate']
            del tmp_dc['udate']

            tmp_dc['end_of_reception'] = end_of_reception
            tmp_dc['status_label'] = status_label

            data_m_wed.append(tmp_dc)

        logger.debug(data_m_wed)

        return data_m_wed
        pass

    # 作成する
    def add(self, event, context):
        try:

            if GV.EVENT_BODY is None:
                raise CustomException('SYS_ERR_100')
                
            logger.debug('# ************0704******************') 
            if "tenant" in GV.EVENT_BODY:
                params = {
                    'table_name': 'm_auth0_management',
                    'filters': {
                        'tenant': GV.EVENT_BODY["tenant"]
                    }
                }
                data_m_am = self.get_data(params)
                logger.debug(data_m_am)
    
                if data_m_am:
                    logger.debug('# ************Auth0情報を設定する******************')
                    GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                    GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                    GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                    GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                    GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                    GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                    logger.debug(GV.CONFIG)
                    pass
                else:
                    return {"error": "tenant:" + GV.EVENT_BODY["tenant"] + " は存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 

            data = GV.EVENT_BODY

            is_not_request_user = False

            logger.debug('# ******************************')

            data_t_wrh = None

            if '# データを検証する。':

                logger.debug('# データを検証する。')

                data_t_wrh = {}
                data_t_wrh = data.copy()
                data_t_wrh['workshop_req_id'] = None
                data_t_wrh['system_id'] = GV.SYSTEM_ID
                data_t_wrh['service_id'] = GV.SERVICE_ID
                data_t_wrh['cdate'] = None
                data_t_wrh['udate'] = None

                logger.debug('# ワークショップ申込履歴')
                res_validate = self.validate(
                    't_workshop_request_history', data_t_wrh)
                if res_validate != True:
                    return res_validate

                logger.debug('# アンケート回答情報')
                if 'questionnaires' in data_t_wrh:
                    for q in data_t_wrh['questionnaires']:

                        if isinstance(q['questionnaire_answer'], dict):
                            q['questionnaire_answer'] = json.dumps(
                                q['questionnaire_answer'], ensure_ascii=False)
                        elif isinstance(q['questionnaire_answer'], list):
                            q['questionnaire_answer'] = json.dumps(
                                q['questionnaire_answer'], ensure_ascii=False)

                        logger.debug(q['questionnaire_answer'])

                        data_t_qa = {}
                        data_t_qa = q.copy()
                        data_t_qa['questionnaire_answer_id'] = None
                        data_t_qa['system_id'] = GV.SYSTEM_ID
                        data_t_qa['service_id'] = GV.SERVICE_ID
                        data_t_qa['req_id'] = 0
                        data_t_qa['cdate'] = None
                        data_t_qa['udate'] = None
                        res_validate = self.validate(
                            't_questionnaire_answer', data_t_qa)
                        if res_validate != True:
                            return res_validate

            logger.debug('# ##############################')

            auth0_user = None

            if GV.LOGGEDIN_USER:
                logger.debug('# アカウントがあり、ログインした場合')

                if data['email_address'] != GV.LOGGEDIN_USER['email']:
                    logger.debug(GV.LOGGEDIN_USER)
                    logger.debug(data)

                    logger.debug('# 入力された情報に不備があります。入力内容を確認してください')
                    res = {}
                    res = {
                        'code': '',
                        'message': '入力された情報に不備があります。入力内容を確認してください'
                    }
                    return res
                pass
            else:
                logger.debug('# ログインしてない場合')

                logger.debug('# ******************************')
                logger.debug('# 申込のメールアドレスのAuth0アカウントが存在するかどうかチェックする')

                # from ..auth0 import Sub as auth0_class
                # auth0 = auth0_class()
                auth0_class = GV.get_module_auth0()
                a0 = auth0_class()
                
                users = a0._get_users_by_email(data['email_address'])

                if users and len(users) > 0:
                    # 存在する場合

                    auth0_user = users[0]

                    logger.debug('存在する場合')
                    if auth0_user['email_verified']:

                        is_request_user = False
                        if 'user_metadata' in auth0_user:
                            if 'data' in auth0_user['user_metadata']:
                                for d in auth0_user['user_metadata']['data']:
                                    if 'roles' in d:
                                        if 'request_user' in d['roles']:
                                            is_request_user = True
                                            break
                        
                        if is_request_user == True:

                            # メールアドレス検証済の場合
                            # アカウント作成済みのメッセージを返し、
                            # クライアント側でログイン画面へ遷移するようにする
                            logger.debug('# メールアドレス検証済の場合')
                            logger.debug('# アカウント作成済みのメッセージを返し、')
                            logger.debug('# クライアント側でログイン画面へ遷移するようにする')

                            res = {}
                            res = GV.INFO_CODE['WORKSHOP_I_ACCOUNT_ALREADY_EXISTS']
                            return res
                        
                        else:

                            is_not_request_user = True

                        pass
                    else:
                        # メールアドレス未検証の場合
                        # 検証メールを再送信する
                        # ???
                        logger.debug('# メールアドレス未検証の場合')
                        logger.debug('# 検証メールを再送信する')

                        code = None
                        if 'app_metadata' in auth0_user:
                            if 'workshop_req_vefification_code' in auth0_user['app_metadata']:
                                code = auth0_user['app_metadata']['workshop_req_vefification_code']

                        if code is not None:
                            logger.debug('# ワークショップ申込情報がある場合')

                            logger.debug('# ******************************')
                            logger.debug('# ワークショップ申込完了連絡 メール送信')
                            
                            data_email = {}
                            data_email['service_id'] = GV.SERVICE_ID
                            data_email['mail_type'] = '本人認証とパスワード設定'
                            data_email['email_address'] = data['email_address']
                            data_email['company_name'] = data['company_name']
                            data_email['last_name'] = data['last_name']
                            data_email['first_name'] = data['first_name']
                            data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                            data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                            self.send_email_workshop(data_email)

                            logger.debug('# ##############################')

                            return {}
                        pass
                else:
                    # 存在しない場合
                    # 処理継続
                    logger.debug('# 存在しない場合')
                    logger.debug('# 処理継続')

                    pass

                pass

                logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['email_address']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスで2回目のワークショップ(1回目正常終了)を申し込んだ場合：':

                logger.debug(
                    '# ・申込者が同じシステム＋サービスで2回目のワークショップ(1回目正常終了)を申し込んだ場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                        data_t_mr['workshop_req_id'] is not None:

                    if data_t_mr['status'] == GV.STATUS['ワークショップ申請'] or \
                            data_t_mr['status'] == GV.STATUS['ワークショップ受付'] or \
                            data_t_mr['status'] == GV.STATUS['ワークショップ実施中'] or \
                            data_t_mr['status'] == GV.STATUS['ワークショップ終了']:

                        res = {}
                        res = GV.INFO_CODE['WORKSHOP_I_ALREADY_COMPLETED']

                        logger.debug('# ******************************')
                        logger.debug(
                            '# 2回目の申込のためエラー ワークショップ2回目の申込のためエラー メール送信')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['mail_type'] = 'ワークショップ2回目の申込のためエラー'

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']
                        data_email['company_code'] = data_t_mr['company_code']
                        data_email['last_name'] = data['last_name']
                        data_email['first_name'] = data['first_name']
                        data_email['affiliation_department'] = data['affiliation_department']
                        data_email['email_address'] = data['email_address']
                        data_email['telephone_number'] = data['telephone_number']

                        self.send_email_workshop(data_email, is_append_to=False)
                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# ・申込者が同じシステム＋サービスの他の申込中にワークショップを申し込んだ場合：':

                logger.debug('# ・申込者が同じシステム＋サービスの他の申込中にワークショップを申し込んだ場合：')
                logger.debug('# エラーメッセージを表示。')
                logger.debug('# 営業とサポート(新事推サ)にメール送信。')

                if data_t_mr is not None and \
                    (data_t_mr['trial_req_id'] is not None or
                        data_t_mr['contract_req_id'] is not None):

                    if data_t_mr['status'] in GV.STATUS_APPLYING_TRIAL.keys() or \
                            data_t_mr['status'] in GV.STATUS_APPLYING_CONTRACT.keys():

                        res = {}
                        res = GV.INFO_CODE['WORKSHOP_I_ANOTHER_APPLYING']

                        logger.debug(
                            '# 他に申込中なのでエラー ワークショップ時、他に申込中のためエラー メール送信')
                        
                        # logger.debug('# ******************************')
                        # logger.debug(
                        #     '# 他に申込中なのでエラー ワークショップ時、他に申込中のためエラー メール送信')

                        # data_email = {}
                        # data_email['service_id'] = GV.SERVICE_ID
                        # data_email['mail_type'] = 'ワークショップ時、他に申込中のためエラー'

                        # self.send_email_workshop(data_email)
                        # logger.debug('# ##############################')

                        # logger.debug('# ******************************')

                        # data_user_info = None

                        # if '# ユーザー情報を取得する':

                        #     logger.debug('# ユーザー情報を取得する')

                        #     if data_t_mr['contract_req_id'] is not None:

                        #         logger.debug('# 「本契約申込情報（確認済み）」から情報を取得する')
                                    
                        #         params = {
                        #             'table_name': 't_contract_request_confirmed',
                        #             'filters': {
                        #                 'contract_req_id': data_t_mr['contract_req_id']
                        #             }
                        #         }
                        #         data_t_crc = self.get_data(params)
                        #         if data_t_crc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_crc['company_name']
                        #             data_user_info['company_code'] = data_t_crc['company_code']
                        #             data_user_info['last_name'] = data_t_crc['contract_last_name']
                        #             data_user_info['first_name'] = data_t_crc['contract_first_name']
                        #             data_user_info['affiliation_department'] = data_t_crc['contract_affiliation_department']
                        #             data_user_info['email_address'] = data_t_crc['contract_email_address']
                        #             data_user_info['telephone_number'] = data_t_crc['contract_telephone_number']

                        #     elif data_t_mr['trial_req_id'] is not None:
                                    
                        #         logger.debug('# 「トライアル申込情報（確認済み）」から情報を取得する')

                        #         params = {
                        #             'table_name': 't_trial_request_confirmed',
                        #             'filters': {
                        #                 'trial_req_id': data_t_mr['trial_req_id']
                        #             }
                        #         }
                        #         data_t_trc = self.get_data(params)
                        #         if data_t_trc is not None:
                        #             data_user_info = {}
                        #             data_user_info['company_name'] = data_t_trc['company_name']
                        #             data_user_info['company_code'] = data_t_trc['company_code']
                        #             data_user_info['last_name'] = data_t_trc['last_name']
                        #             data_user_info['first_name'] = data_t_trc['first_name']
                        #             data_user_info['affiliation_department'] = ''
                        #             data_user_info['email_address'] = data_t_trc['email_address']
                        #             data_user_info['telephone_number'] = data_t_trc['telephone_number']

                        # logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        data_email = {}
                        data_email['service_id'] = GV.SERVICE_ID

                        data_email['system_id'] = GV.SYSTEM_ID
                        data_email['service_id'] = GV.SERVICE_ID
                        data_email['system_name'] = GV.SYSTEM_NAME
                        data_email['service_name'] = GV.SERVICE_NAME
                        data_email['company_name'] = data['company_name']

                        # if data_user_info is not None:
                        #     data_email['company_code'] = data_user_info['company_code']
                        # else:
                        #     data_email['company_code'] = ''
                        data_email['company_code'] = data_t_mr['company_code']

                        data_email['last_name'] = data['last_name']
                        data_email['first_name'] = data['first_name']
                        data_email['affiliation_department'] = data['affiliation_department']
                        data_email['email_address'] = data['email_address']
                        data_email['telephone_number'] = data['telephone_number']

                        data_email['status'] = data_t_mr['status']

                        data_email['mail_type'] = 'ワークショップ時、他に申込中のためエラー'

                        self.send_email_workshop(data_email, is_append_to=False)

                        logger.debug('# ##############################')

                        return res

                    pass

            logger.debug('# ##############################')
            # 共通PF5　WebAP診断対応　nakamura.e 2024/07/30 -->
            res = {}
            bIsCanSelectedEvendDay = self.IsCanSelectedEvendDay(data_t_wrh, res)
            if bIsCanSelectedEvendDay == False:
                res = GV.INFO_CODE['WORKSHOP_CANNOT_SELECTED']
                return res
            # 共通PF5　WebAP診断対応　nakamura.e 2024/07/30 <--
            logger.debug('# ******************************')

            logger.debug('# ・上記以外：申込完了画面を表示する。本人認証へ進む。')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            workshop_req_id = None

            if '# テーブル「ワークショップ申込履歴」にデータ登録する':

                logger.debug('# テーブル「ワークショップ申込履歴」にデータ登録する')
                logger.debug('t_workshop_request_history')

                # from ..model.t_workshop_request_history import Sub as TWRH
                # t_wrh = TWRH()
                TWRH = GV.get_module('t_workshop_request_history')
                t_wrh = TWRH()

                tmp_t_wrh = t_wrh._add(data_t_wrh)

                if tmp_t_wrh:
                    workshop_req_id = tmp_t_wrh.workshop_req_id
                    data_t_wrh1 = tmp_t_wrh.to_dict()
                    logger.debug(data_t_wrh1)
                else:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            # logger.debug('# ******************************')
            
            # if '# テーブル「ワークショップ開催日マスタ」にデータ更新する':

            #     logger.debug('# テーブル「ワークショップ開催日マスタ」にデータ更新する')
            #     logger.debug('m_workshop_event_date')

            #     logger.debug('申込フラフ:workshop_request_flgをTrueにする')

            #     # from ..model.m_workshop_event_date import Sub as MWED
            #     # m_wed = MWED()
            #     MWED = GV.get_module('m_workshop_event_date')
            #     m_wed = MWED()

            #     data_m_wed = {}
            #     data_m_wed['workshop_event_date_id'] = data['workshop_event_date_id']
            #     data_m_wed['workshop_request_flg'] = True
            #     tmp_m_wed = m_wed._update(data_m_wed)

            #     if tmp_m_wed:
            #         data_m_wed1 = tmp_m_wed.to_dict()
            #         logger.debug(data_m_wed1)
            #     else:
            #         raise CustomException('SYS_ERR_100')

            # logger.debug('# ##############################')

            logger.debug('# ******************************')
            
            if '# テーブル「アンケート回答情報」にデータ登録する':

                logger.debug('# テーブル「アンケート回答情報」にデータ登録する')
                logger.debug('t_questionnaire_answer')

                data_t_qa = []
                for q in data['questionnaires']:

                    data_t_qa.append(
                        {
                            'system_id': GV.SYSTEM_ID,
                            'service_id': GV.SERVICE_ID,
                            'questionnaire_no': q['questionnaire_no'],
                            'questionnaire_content': q['questionnaire_content'],
                            'questionnaire_answer': q['questionnaire_answer'],
                            # 'questionnaire_type': q['questionnaire_type'],
                            'questionnaire_type': 'workshop',
                            'req_id': workshop_req_id
                        }
                    )

                # from ..model.t_questionnaire_answer import Sub as TQA
                # t_qa = TQA()
                TQA = GV.get_module('t_questionnaire_answer')
                t_qa = TQA()

                tmp_t_qa = t_qa._add(data_t_qa)

                if tmp_t_qa:
                    data_t_qa1 = tmp_t_qa.to_dict()
                    logger.debug(data_t_qa1)
                else:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            if is_not_request_user:

                data_tr = {}
                data_tr['auth0_user_id'] = auth0_user['user_id']
                data_tr['workshop_req_id'] = workshop_req_id
                res = self.regist_workshop_data(data_tr)

                pass

            elif GV.LOGGEDIN_USER:

                data_tr = {}
                data_tr['auth0_user_id'] = GV.LOGGEDIN_USER['sub']
                data_tr['workshop_req_id'] = workshop_req_id
                res = self.regist_workshop_data(data_tr)

                pass
            else:
                import uuid
                code = str(uuid.uuid4())

                logger.debug('# 認証コード生成')
                
                logger.debug('# ************0704******************') 
                code = 'w-' + str(data_m_am['id']) + '-' + code
                logger.debug('# ************0704******************')

                # app_metadata = {
                #     'service_path': GV.SERVICE_PATH,
                #     'workshop_req_id': workshop_req_id,
                #     'workshop_req_vefification_code': code,
                #     'workshop_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                # }

                if auth0_user is not None:
                    logger.debug('# Auth0アカウントがある場合')

                    # logger.debug(auth0_user['app_metadata'])

                    # app_metadata = auth0_user['app_metadata']

                    app_metadata = None

                    if 'app_metadata' in auth0_user:

                        logger.debug(auth0_user['app_metadata'])

                        app_metadata = auth0_user['app_metadata']
                    
                    else:

                        app_metadata = {}

                    if 'data' not in app_metadata:
                        app_metadata['data'] = []
                    
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'workshop_req_id': workshop_req_id,
                            'workshop_req_vefification_code': code,
                            'workshop_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )

                    data_auth0 = {}
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# ******************************')
                    logger.debug('# atuh0 update')
                    a0._update(auth0_user['user_id'], data_auth0)
                    logger.debug('# ##############################')

                    pass
                else:
                    logger.debug('# Auth0アカウントがない場合')

                    app_metadata = {}
                    app_metadata['data'] = []
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'workshop_req_id': workshop_req_id,
                            'workshop_req_vefification_code': code,
                            'workshop_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )
                    
                    data_auth0 = {}
                    data_auth0['email_address'] = data['email_address']
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# data_auth0')
                    logger.debug(data_auth0)

                    logger.debug('# ******************************')
                    logger.debug('# create_data_atuh0')
                    self.create_data_atuh0(data_auth0)
                    logger.debug('# ##############################')

                logger.debug('# ******************************')
                logger.debug('# ワークショップ申込完了連絡 本人認証とパスワード設定 メール送信')

                data_email = {}
                data_email['service_id'] = GV.SERVICE_ID
                data_email['mail_type'] = '本人認証とパスワード設定'
                data_email['email_address'] = data['email_address']
                data_email['company_name'] = data['company_name']
                data_email['last_name'] = data['last_name']
                data_email['first_name'] = data['first_name']
                data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                self.send_email_workshop(data_email)
                
                logger.debug('# ##############################')

                pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass

    def regist_workshop_data(self, data):
        try:
            logger.debug(data)
            res = {}

            company_code = None

            is_first_request = False

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        # 'system_id': GV.SYSTEM_ID,
                        # 'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr is None:
                    pass
                else:
                    if 'company_code' in data_t_mr:
                        if data_t_mr['company_code'].startswith("K"):
                            company_code = data_t_mr['company_code']

            logger.debug('# ##############################')

            data_t_wrh = None

            logger.debug('# ******************************')

            if '# テーブル「ワークショップ申込履歴」からデータ取得':

                logger.debug('# テーブル「ワークショップ申込履歴」からデータ取得')
                logger.debug('# t_workshop_request_history')

                params = {
                    'table_name': 't_workshop_request_history',
                    'filters': {
                        'workshop_req_id': data['workshop_req_id']
                    }
                }
                data_t_wrh = self.get_data(params)

                if data_t_wrh is None:
                    logger.error('# 「ワークショップ申込履歴」からデータ取得失敗')
                    logger.error(params)
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')
    
            if '# 「ワークショップ実施日」が空いているかどうか確認する':

                logger.debug('# 「ワークショップ実施日」が空いているかどうか確認する')
            
                data_t_wed = None

                logger.debug('# ******************************')
                logger.debug('# 「ワークショップ実施日」を取得する')
                
                params = {
                    'table_name': 'm_workshop_event_date',
                    'filters': {
                        'workshop_event_date_id': data_t_wrh['workshop_event_date_id']
                    }
                }
                data_t_wed = self.get_data(params)

                if data_t_wed is None:
                    logger.error('# 「ワークショップ実施日」を取得失敗')
                    logger.error(params)
                    raise CustomException('SYS_ERR_100')

                logger.debug('# ##############################')

                if data_t_wed['workshop_request_flg']  == True:
                        
                    logger.debug('# 「ワークショップ実施日」が空いてない')

                    logger.debug('# ******************************')
                    logger.debug('# ワークショップ申込後に満席になったためエラー メール送信')
                    
                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'ワークショップ申込後に満席になったためエラー'

                    data_email['email_address'] = data_t_wrh['email_address']
                    data_email['company_name'] = data_t_wrh['company_name']
                    data_email['last_name'] = data_t_wrh['last_name']
                    data_email['first_name'] = data_t_wrh['first_name']

                    wed = data_t_wed['workshop_event_date']
                    wed = datetime.strptime(wed[0:19], '%Y-%m-%dT%H:%M:%S')
                    data_email['workshop_event_date'] = wed.strftime('%Y年%m月%d日 %H:%M')

                    wetd = data_t_wed['workshop_event_time_division']
                    if wetd == 'AM':
                        wetd = '午前'
                    elif wetd == 'PM':
                        wetd = '午後'
                    data_email['workshop_event_time_division'] = wetd

                    data_email['affiliation_department'] = data_t_wrh['affiliation_department']
                    data_email['telephone_number'] = data_t_wrh['telephone_number']
                    
                    data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                    self.send_email_workshop(data_email)

                    logger.debug('# ##############################')

                    res = {}
                    res = GV.INFO_CODE['WORKSHOP_INFO_002']
                    return res
                
            logger.debug('# ******************************')
            
            if '# テーブル「ワークショップ開催日マスタ」にデータ更新する':

                logger.debug('# テーブル「ワークショップ開催日マスタ」にデータ更新する')
                logger.debug('m_workshop_event_date')

                logger.debug('申込フラフ:workshop_request_flgをTrueにする')

                MWED = GV.get_module('m_workshop_event_date')
                m_wed = MWED()

                data_m_wed = {}
                data_m_wed['workshop_event_date_id'] = data_t_wrh['workshop_event_date_id']
                data_m_wed['workshop_request_flg'] = True
                tmp_m_wed = m_wed._update(data_m_wed)

                if tmp_m_wed:
                    data_m_wed1 = tmp_m_wed.to_dict()
                    logger.debug(data_m_wed1)
                else:
                    logger.error('# テーブル「ワークショップ開催日マスタ」にデータ更新失敗')
                    logger.error(data_m_wed)
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')
                
            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_c = None
            
            if '# テーブル「企業マスタ」にデータ登録':

                logger.debug('# テーブル「企業マスタ」にデータ登録')
                logger.debug('# m_company')

                if company_code is None:

                    is_first_request = True

                    logger.debug('# 存在しない場合、データを登録')

                    # from ..model.m_company import Sub as MC
                    # m_c = MC()
                    MC = GV.get_module('m_company')
                    m_c = MC()

                    data_m_c_add = {}
                    # 企業コード
                    # data_m_c_add['company_code'] = data['company_code']
                    # # 申込みコード
                    # data_m_c_add['entry_code'] = data['entry_code']
                    # # 営業コード
                    # data_m_c_add['salesman_code'] = data['salesman_code']
                    # 企業名
                    data_m_c_add['company_name'] = data_t_wrh['company_name']
                    # # 企業名(カナ)
                    # data_m_c_add['company_name_kana'] = data['company_name_kana']
                    # 郵便番号
                    data_m_c_add['company_zipcode'] = data_t_wrh['zip_code']
                    # 住所(都道府県)
                    data_m_c_add['company_address_pref'] = data_t_wrh['address_pref']
                    # 住所1
                    data_m_c_add['company_address_1'] = data_t_wrh['address_1']
                    # 住所2
                    data_m_c_add['company_address_2'] = data_t_wrh['address_2']
                    # 住所3
                    data_m_c_add['company_address_3'] = data_t_wrh['address_3']
                    # # 住所1(カナ)
                    # data_m_c_add['company_address_1_kana'] = data['company_address_1_kana']
                    # # 住所2(カナ)
                    # data_m_c_add['company_address_2_kana'] = data['company_address_2_kana']
                    # # 住所3(カナ)
                    # data_m_c_add['company_address_3_kana'] = data['company_address_3_kana']
                    # 電話番号1
                    data_m_c_add['company_tel_1'] = data_t_wrh['telephone_number']
                    # # FAX1
                    # data_m_c_add['company_fax_1'] = data['company_fax_1']
                    # 代表者名(姓)
                    data_m_c_add['company_leader_last'] = data_t_wrh['last_name']
                    # 代表者名(名)
                    data_m_c_add['company_leader_first'] = data_t_wrh['first_name']
                    # # 代表者名(姓)(カナ)
                    # data_m_c_add['company_leader_kana_last'] = data['company_leader_kana_last']
                    # # 代表者名(名)(カナ)
                    # data_m_c_add['company_leader_kana_first'] = data['company_leader_kana_first']
                    # 登録日
                    data_m_c_add['insert_date'] = self.NOW
                    # 更新日
                    data_m_c_add['update_date'] = self.NOW
                    # # 削除フラグ
                    # data_m_c_add['delete_flg'] = data['delete_flg']
                    # # system_usable_flag
                    # data_m_c_add['system_usable_flag'] = data['system_usable_flag']
                    # # 代表者の生年月日
                    # data_m_c_add['company_leader_date_of_birth'] = data['company_leader_date_of_birth']
                    # # 企業備考欄
                    # data_m_c_add['customer_notes'] = data['customer_notes']
                    # # GMO掛け払いのデータ更新あり
                    # data_m_c_add['need_gmo_ps_creditfacility_modifybuyer'] = data['need_gmo_ps_creditfacility_modifybuyer']

                    logger.debug('# データ登録')
                    tmp_m_c = m_c._add(data_m_c_add)

                    if tmp_m_c:
                        data_m_c = tmp_m_c.to_dict()
                        logger.debug(data_m_c)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

                if data_m_c is not None:
                    company_code = data_m_c['company_code']

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_wrc = None
            data_t_wed = None

            if '# テーブル「ワークショップ申込情報（確認済み）」からデータ検索':

                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」からデータ検索')
                logger.debug('# t_workshop_request_confirmed')

                params = {
                    'table_name': 't_workshop_request_confirmed',
                    'filters': {
                        'workshop_req_id': data['workshop_req_id']
                    }
                }
                data_t_wrc = self.get_data(params)

                if data_t_wrc:
                    logger.debug('# 存在する場合、なにもしない')
                    # return {}
                    pass
                else:
                    logger.debug('# 存在しない場合、履歴からのデータを登録')

                    logger.debug('# 履歴のデータをコピー')
                    data_t_wrc = {}
                    data_t_wrc = data_t_wrh.copy()

                    logger.debug('# ******************************')

                    if '# テーブル「ワークショップ申込情報（確認済み）」にデータ登録':

                        logger.debug('# テーブル「ワークショップ申込情報（確認済み）」にデータ登録')
                        logger.debug('# t_workshop_request_confirmed')

                        logger.debug('# 「企業コード」をセットする')
                        data_t_wrc['company_code'] = company_code

                        logger.debug('# ******************************')
                        logger.debug('# 「ワークショップ実施日」をセットする')
                        
                        params = {
                            'table_name': 'm_workshop_event_date',
                            'filters': {
                                'workshop_event_date_id': data_t_wrc['workshop_event_date_id']
                            }
                        }
                        data_t_wed = self.get_data(params)

                        if data_t_wed:
                            data_t_wrc['workshop_event_result_date'] = data_t_wed['workshop_event_date']
                        else:
                            logger.debug('# 【ERROR】「ワークショップ実施日」セット失敗')
                            pass

                        logger.debug('# ##############################')

                        # from ..model.t_workshop_request_confirmed import Sub as TWRC
                        # t_wrc = TWRC()
                        TWRC = GV.get_module('t_workshop_request_confirmed')
                        t_wrc = TWRC()

                        logger.debug('# データ登録')
                        tmp_t_wrc = t_wrc._add(data_t_wrc)

                        if tmp_t_wrc is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# データ登録失敗')
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# データ登録成功')

                        data_t_wrc = tmp_t_wrc.to_dict()
                        logger.debug(data_t_wrc)

                    logger.debug('# ##############################')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                # from ..model.t_manage_request import Sub as TMR
                # t_mr = TMR()
                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()
                
                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr is not None:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')

                    # 企業コード
                    data_t_mr['company_code'] = company_code
                    # ワークショップ申込ID
                    data_t_mr['workshop_req_id'] = data['workshop_req_id']
                    # システム利用可能フラグ
                    logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                    data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                    # ステータス
                    data_t_mr['status'] = GV.STATUS['ワークショップ申請']

                    logger.debug('# データ更新')
                    tmp_t_mr_1 = t_mr._update(data_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    param_t_mr = {}
                    # # 申込管理ID
                    # param_t_mr['manage_req_id'] =
                    # 企業コード
                    param_t_mr['company_code'] = company_code
                    # システムID
                    param_t_mr['system_id'] = GV.SYSTEM_ID
                    # サービスID
                    param_t_mr['service_id'] = GV.SERVICE_ID
                    # # 契約ID
                    # param_t_mr['contract_id'] =
                    # Auth0ユーザーID
                    param_t_mr['auth0_user_id'] = data['auth0_user_id']
                    # # 資料請求ID
                    # param_t_mr['document_req_id'] =
                    # # トライアル環境ストックID
                    # param_t_mr['trial_env_stock_id'] = trial_env_stock_id
                    # # トライアル申込ID
                    # param_t_mr['trial_req_id'] =
                    # ワークショップ申込ID
                    param_t_mr['workshop_req_id'] = data['workshop_req_id']
                    # # 本契約申込ID
                    # param_t_mr['contract_req_id'] =
                    # # 担当営業コード
                    # param_t_mr['salesman_code'] =
                    # システム利用可能フラグ
                    logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                    param_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                    # ステータス
                    param_t_mr['status'] = GV.STATUS['ワークショップ申請']
                    # # 作成日時
                    # param_t_mr['cdate'] =
                    # # 更新日時
                    # param_t_mr['udate'] =

                    logger.debug('# データ登録')
                    tmp_t_mr_1 = t_mr._add(param_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_sys = None

            if '# テーブル「システムマスタ」からデータ取得':

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }
                data_m_sys = self.get_data(params)
                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ取得OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】':

                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】')
                logger.debug('# m_auth_user_info')

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                param_m_aui = {}
                # # Auth0ユーザー情報管理ID
                # param_m_aui['auth_user_info_id'] = ''
                logger.debug('# **************0702****S************')
                # テナント
                param_m_aui['tenant'] = data_t_wrc['tenant']
                logger.debug('# **************0702****E************')
                # Auth0ユーザーID
                param_m_aui['auth0_user_id'] = data['auth0_user_id']
                # ログイン先企業コード
                param_m_aui['company_code'] = company_code
                # ログイン先システムID
                param_m_aui['system_id'] = GV.REQUEST_USER_SYSTEM_ID
                # ログイン先サービスID
                param_m_aui['service_id'] = GV.REQUEST_USER_SERVICE_ID

                logger.debug('# ワークショップ申し込みする際、metadataにはアプリ環境情報はセットしない。')
                # 付与ロールのリスト
                param_m_aui['roles'] = [GV.ROLES_REQUEST_USER]
                # # 作成日時
                # param_m_aui['cdate'] = ''
                # # 更新日時
                # param_m_aui['udate'] = ''

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': param_m_aui['auth0_user_id'],
                        'company_code': param_m_aui['company_code'],
                        'system_id': param_m_aui['system_id'],
                        'service_id': param_m_aui['service_id']
                    }
                }
                data_m_aui = self.get_data(params)
                logger.debug(data_m_aui)

                tmp_m_aui = None

                if data_m_aui:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                    param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                    tmp_m_aui = m_aui._update(param_m_aui)
                    pass
                else:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                    tmp_m_aui = m_aui._add(param_m_aui)
                    pass

                if tmp_m_aui is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'company_code': 'NONE',
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u is not None:
                    logger.debug('# 存在する場合、どうする？')

                    logger.debug('# データ更新')

                    MU = GV.get_module('m_user')
                    m_u = MU()
                    
                    # 企業コード
                    data_m_u['company_code'] = company_code
                    # 名前(姓)
                    data_m_u['name_last'] = data_t_wrc['last_name']
                    # 名前(名)
                    data_m_u['name_first'] = data_t_wrc['first_name']
                    
                    tmp_m_u = m_u._update(data_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'auth0_user_id': data['auth0_user_id'],
                        'company_code': company_code
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')
                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    # from ..model.m_user import Sub as MU
                    # m_u = MU()
                    MU = GV.get_module('m_user')
                    m_u = MU()

                    param_m_u = {}
                    # # ユーザーマスタID
                    # param_m_u['user_master_id'] = data['user_master_id']
                    # Auth0ユーザーID
                    param_m_u['auth0_user_id'] = data['auth0_user_id']
                    # 企業コード
                    param_m_u['company_code'] = company_code
                    # 名前
                    param_m_u['name_last'] = data_t_wrc['last_name']
                    # 名前(姓)
                    param_m_u['name_first'] = data_t_wrc['first_name']
                    # 名前(名)
                    param_m_u['name_last_kana'] = ''
                    # 名前(カナ)(姓)
                    param_m_u['name_first_kana'] = ''
                    # 部署名(カナ)(名)
                    param_m_u['department'] = ''
                    # 役職
                    param_m_u['position'] = ''
                    # メールアドレス
                    param_m_u['email'] = data_t_wrc['email_address']
                    # # 電話番号
                    # param_m_u['tel'] = ''
                    # # 招待コード
                    # param_m_u['invitation_code'] = ''
                    # # 招待日時
                    # param_m_u['invitation_date'] = ''
                    # # 登録日時
                    # param_m_u['cdate'] = ''
                    # # 更新日時
                    # param_m_u['udate'] = ''

                    logger.debug('# データ登録')
                    tmp_m_u = m_u._add(param_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            try:

                logger.debug('# ******************************')

                data['SYSTEM_ID'] = GV.SYSTEM_ID
                data['SERVICE_ID'] = GV.SERVICE_ID
                data['SYSTEM_NAME'] = GV.SYSTEM_NAME
                data['SERVICE_NAME'] = GV.SERVICE_NAME
                data['SERVICE_PATH'] = GV.SERVICE_PATH
                
                input_event = {
                    "stageVariables": {
                        "env": GV.ENV
                    },
                    "httpMethod": "POST",
                    "path": "/api/workshop",
                    "body": {
                        "func": "regist_workshop_data_2",
                        "data": data
                    }
                }

                Payload = json.dumps(input_event, ensure_ascii=False)
                logger.debug("---01: Payload:")
                logger.debug(Payload)

                if GV.DEV_ENV == 'local':
                    pass
                else:
                    # 呼び出し
                    response = boto3.client('lambda').invoke(
                        FunctionName=GV.LAMBDA_SYS_COMN_PF,
                        InvocationType='Event',
                        Payload=Payload
                    )
                    logger.debug("---02: response:")
                    logger.debug(response)
                    # response = {}

                #     res = response

                #     if 'StatusCode' in response and response['StatusCode'] == 200:

                #         # レスポンス読出し
                #         Payload = json.loads(response['Payload'].read())
                #         logger.debug("---03: body:")
                #         logger.debug(Payload)
                #         res = Payload

                # return res

            except Exception as err:
                logger.debug(err)
                # 例外の再送出
                raise
            finally:
                logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {
            'statusCode': 200,
            'body': 'OK'
        }
        pass

    def regist_workshop_data_2(self, data):
        try:
            logger.debug('regist_workshop_data_2')
            logger.debug(data)
            
            GV.SYSTEM_ID = data['SYSTEM_ID']
            GV.SERVICE_ID = data['SERVICE_ID']
            GV.SYSTEM_NAME = data['SYSTEM_NAME']
            GV.SERVICE_NAME = data['SERVICE_NAME']
            GV.SERVICE_PATH = data['SERVICE_PATH']
            
            res = {}

            company_code = None

            is_first_request = False

            logger.debug('# ******************************')

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        # 'system_id': GV.SYSTEM_ID,
                        # 'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr is None:
                    pass
                else:
                    if 'company_code' in data_t_mr:
                        if data_t_mr['company_code'].startswith("K"):
                            company_code = data_t_mr['company_code']

            logger.debug('# ##############################')

            data_t_wrh = None

            logger.debug('# ******************************')

            if '# テーブル「ワークショップ申込履歴」からデータ取得':

                logger.debug('# テーブル「ワークショップ申込履歴」からデータ取得')
                logger.debug('# t_workshop_request_history')

                params = {
                    'table_name': 't_workshop_request_history',
                    'filters': {
                        'workshop_req_id': data['workshop_req_id']
                    }
                }
                data_t_wrh = self.get_data(params)

                if data_t_wrh is None:
                    logger.error('# 「ワークショップ申込履歴」からデータ取得失敗')
                    logger.error(params)
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_sys = None

            if '# テーブル「システムマスタ」からデータ取得':

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }
                data_m_sys = self.get_data(params)
                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ取得OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            ######################################################
            #　ワークショップで環境ストックの割り当てをやめる
            ######################################################

            logger.debug('# ##############################')

            if '# 信用調査':

                logger.debug('# ・選択されたシステムがSimSPかつプロスペクト申請実施日が3か月以内ではない場合、')
                logger.debug('# プロスペクト申請メールを送信する。プロスペクト申請結果をNULLにする。')
                logger.debug('# ・信用調査実施日が3か月以内ではない場合、')
                logger.debug('# 信用調査結果をNULLにする。')
                logger.debug('# 本契約可否判断をNULLにする。')

                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                filters = []
                filters.append(t_mr.model_class.system_id == GV.SYSTEM_ID)
                filters.append(t_mr.model_class.service_id == GV.SERVICE_ID)
                filters.append(t_mr.model_class.company_code == company_code)
                filters = and_(*filters)

                tmp_t_mr = t_mr._get_item_by_filters(filters)

                data_t_mr = None

                if tmp_t_mr:

                    data_t_mr = tmp_t_mr.to_dict()
                    logger.debug(data_t_mr)

                if data_t_mr is not None and is_first_request == False:

                    # 判定？？？
                    if '# ・選択されたシステムがSimSPかつプロスペクト申請実施日が3か月以内ではない場合、':

                        if GV.SERVICE_PATH == 'simsp':

                            # プロスペクト申請結果登録日
                            prospect_request_regist_date = data_t_mr['prospect_request_regist_date']

                            if prospect_request_regist_date is not None:

                                prospect_request_regist_date = datetime.strptime(prospect_request_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')

                                logger.debug('# ******************************')
                                logger.debug('# 3か月後日付を取得する')

                                # from datetime import datetime, date, timedelta
                                from dateutil.relativedelta import relativedelta
                                
                                three_month_after = prospect_request_regist_date.date() + relativedelta(months=3)
                                logger.debug('# ##############################')

                                today = datetime.today().date()

                                if '# プロスペクト申請実施日が3か月以内ではない場合':

                                    logger.debug('# プロスペクト申請実施日が3か月以内ではない場合')

                                    if today > three_month_after:

                                        logger.debug('# プロスペクト申請メールを送信する。')

                                        logger.debug('# ******************************')
                                        logger.debug('# 申込成功 プロスペクト申請 メール送信')

                                        logger.debug('# ******************************')
                                        logger.debug('# 企業情報取得')

                                        params = {
                                            'table_name': 'm_company',
                                            'filters': {
                                                'company_code': company_code
                                            }
                                        }
                                        data_m_com = self.get_data(params)

                                        logger.debug('# ##############################')

                                        data_email = {}
                                        data_email['service_id'] = GV.SERVICE_ID
                                        data_email['mail_type'] = 'プロスペクト申請'

                                        data_email['company_name'] = data_m_com['company_name']
                                        data_email['company_address_pref'] = data_m_com['company_address_pref']
                                        data_email['company_address_1'] = data_m_com['company_address_1']
                                        data_email['company_address_2'] = data_m_com['company_address_2']
                                        data_email['company_address_3'] = data_m_com['company_address_3']
                                        data_email['contract_department'] = data_t_wrh['affiliation_department']
                                        data_email['contract_name_last'] = data_t_wrh['last_name']
                                        data_email['contract_name_first'] = data_t_wrh['first_name']

                                        self.send_email_workshop(data_email)

                                        logger.debug('# ##############################')
                                
                                        logger.debug('# プロスペクト申請結果をNULLにする。')

                                        data_t_mr['prospect_request'] = None

                            else:

                                logger.debug('# ******************************')
                                logger.debug('# 申込成功 プロスペクト申請 メール送信')

                                logger.debug('# ******************************')
                                logger.debug('# 企業情報取得')

                                params = {
                                    'table_name': 'm_company',
                                    'filters': {
                                        'company_code': company_code
                                    }
                                }
                                data_m_com = self.get_data(params)

                                logger.debug('# ##############################')

                                data_email = {}
                                data_email['service_id'] = GV.SERVICE_ID
                                data_email['mail_type'] = 'プロスペクト申請'

                                data_email['company_name'] = data_m_com['company_name']
                                data_email['company_address_pref'] = data_m_com['company_address_pref']
                                data_email['company_address_1'] = data_m_com['company_address_1']
                                data_email['company_address_2'] = data_m_com['company_address_2']
                                data_email['company_address_3'] = data_m_com['company_address_3']
                                data_email['contract_department'] = data_t_wrh['affiliation_department']
                                data_email['contract_name_last'] = data_t_wrh['last_name']
                                data_email['contract_name_first'] = data_t_wrh['first_name']

                                self.send_email_workshop(data_email)

                                logger.debug('# ##############################')

                    if '# ・信用調査実施日が3か月以内ではない場合':

                        # 信用調査結果登録日
                        credit_check_regist_date = data_t_mr['credit_check_regist_date']

                        if credit_check_regist_date is not None:

                            credit_check_regist_date = datetime.strptime(credit_check_regist_date[0:19], '%Y-%m-%dT%H:%M:%S')

                            logger.debug('# ******************************')
                            logger.debug('# 3か月後日付を取得する')

                            # from datetime import datetime, date, timedelta
                            from dateutil.relativedelta import relativedelta
                            
                            three_month_after = credit_check_regist_date.date() + relativedelta(months=3)
                            logger.debug('# ##############################')

                            today = datetime.today().date()

                            if '# ・信用調査実施日が3か月以内ではない場合':

                                logger.debug('# ・信用調査実施日が3か月以内ではない場合')

                                if today > three_month_after:
                            
                                    logger.debug('# 信用調査結果をNULLにする。')

                                    # 信用調査
                                    data_t_mr['credit_check'] = None

                                    logger.debug('# 本契約可否判断をNULLにする。')

                                    #  本契約可否判断 
                                    data_t_mr['contract_judgment'] = None

                else:

                    logger.debug('# ******************************')
                    logger.debug('# 申込成功 プロスペクト申請 メール送信')

                    logger.debug('# ******************************')
                    logger.debug('# 企業情報取得')

                    params = {
                        'table_name': 'm_company',
                        'filters': {
                            'company_code': company_code
                        }
                    }
                    data_m_com = self.get_data(params)

                    logger.debug('# ##############################')

                    data_email = {}
                    data_email['service_id'] = GV.SERVICE_ID
                    data_email['mail_type'] = 'プロスペクト申請'

                    data_email['company_name'] = data_m_com['company_name']
                    data_email['company_address_pref'] = data_m_com['company_address_pref']
                    data_email['company_address_1'] = data_m_com['company_address_1']
                    data_email['company_address_2'] = data_m_com['company_address_2']
                    data_email['company_address_3'] = data_m_com['company_address_3']
                    data_email['contract_department'] = data_t_wrh['affiliation_department']
                    data_email['contract_name_last'] = data_t_wrh['last_name']
                    data_email['contract_name_first'] = data_t_wrh['first_name']

                    self.send_email_workshop(data_email)

                    logger.debug('# ##############################')

                    pass

            logger.debug('# ******************************')

            if '# 申込成功 ワークショップ申込受付 メール送信':

                logger.debug('# 申込成功 ワークショップ申込受付 メール送信')

                data_t_wed = None

                logger.debug('# ******************************')
                logger.debug('# 「ワークショップ実施日」を取得する')
                
                params = {
                    'table_name': 'm_workshop_event_date',
                    'filters': {
                        'workshop_event_date_id': data_t_wrh['workshop_event_date_id']
                    }
                }
                data_t_wed = self.get_data(params)

                if data_t_wed is None:
                    logger.error('# 「ワークショップ実施日」を取得失敗')
                    logger.error(params)
                    raise CustomException('SYS_ERR_100')  

                logger.debug('# ##############################')

                data_email = {}
                data_email['service_id'] = GV.SERVICE_ID
                data_email['mail_type'] = 'ワークショップ申込受付'
                data_email['email_address'] = data_t_wrh['email_address']
                data_email['company_name'] = data_t_wrh['company_name']
                data_email['last_name'] = data_t_wrh['last_name']
                data_email['first_name'] = data_t_wrh['first_name']

                wed = data_t_wed['workshop_event_date']
                wed = datetime.strptime(wed[0:19], '%Y-%m-%dT%H:%M:%S')
                data_email['workshop_event_date'] = wed.strftime('%Y年%m月%d日 %H:%M')

                wetd = data_t_wed['workshop_event_time_division']
                if wetd == 'AM':
                    wetd = '午前'
                elif wetd == 'PM':
                    wetd = '午後'
                data_email['workshop_event_time_division'] = wetd

                data_email['affiliation_department'] = data_t_wrh['affiliation_department']
                data_email['telephone_number'] = data_t_wrh['telephone_number']
                data_email['login_url'] = GV.URL_LOGIN_SIMSP

                self.send_email_workshop(data_email)

            logger.debug('# ##############################')

            pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {
            'statusCode': 200,
            'body': 'OK'
        }
        pass

    # 更新する
    def update(self, event, context):

        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY
        logger.debug(data)

        dt_now = datetime.now()

        logger.debug('# ******************************')

        data_t_mr = None

        if '# 「t_manage_request」を更新する':

            logger.debug('# 「t_manage_request」を更新する')

            TMR = GV.get_module('t_manage_request')
            t_mr = TMR()

            filters = []
            filters.append(t_mr.model_class.system_id == data['system_id'])
            filters.append(t_mr.model_class.service_id == data['service_id'])
            filters.append(t_mr.model_class.company_code == data['company_code'])
            filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
            filters = and_(*filters)

            tmp_t_mr = t_mr._get_item_by_filters(filters)

            if tmp_t_mr is not None:
                data_t_mr = tmp_t_mr.to_dict()

                if data_t_mr['credit_check'] == True:
                    data_t_mr['credit_check'] = 'OK'
                elif data_t_mr['credit_check'] == False:
                    data_t_mr['credit_check'] = 'NG'
                else:
                    data_t_mr['credit_check'] = None

                if data_t_mr['prospect_request'] == True:
                    data_t_mr['prospect_request'] = 'OK'
                elif data_t_mr['prospect_request'] == False:
                    data_t_mr['prospect_request'] = 'NG'
                else:
                    data_t_mr['prospect_request'] = None

                # 信用調査
                if data_t_mr['credit_check'] != data['credit_check']:
                    data_t_mr['credit_check'] = data['credit_check']
                    data_t_mr['credit_check_regist_date'] = dt_now
                
                # プロスペクト申請
                if data_t_mr['prospect_request'] != data['prospect_request']:
                    data_t_mr['prospect_request'] = data['prospect_request']
                    data_t_mr['prospect_request_regist_date'] = dt_now

                tmp_t_mr_update = t_mr._update(data_t_mr)

                if tmp_t_mr_update:
                    data_t_mr_update = tmp_t_mr_update.to_dict()
                    logger.debug(data_t_mr_update)

        logger.debug('# ##############################')
        
        return {}
        pass

    # 削除する
    def delete(self, event, context):
        return {}
        pass

    # プロセス管理
    def process(self, params, data):
        try:
            logger.debug('# ******************************')
            logger.debug('プロセス管理')
            logger.debug(params)
            logger.debug(data)
            
            if 'status' in params:
                
                if params['status'] == 'ワークショップキャンセル':

                    if 'is_from_customer' in params:

                        # 使用済フラグ
                        use_flg = False
                        
                        # 障害 #4713 2024/05/08 L S
                        # 削除済みフラグ
                        deleted_flag = False
                        # 障害 #4713 2024/05/08 L E

                        logger.debug('# お客様からの実施')

                        # ・ワークショップのキャンセル受付メールを申込者、営業ML、サポートMLに送信する。
                        # ・プロセス管理のステータスを「ワークショップキャンセル」にする。
                        # ・ワークショップ実施日管理テーブルのワークショップ実施予定日を予定空き状態に戻す。
                        # ・環境ストックマスタテーブルをシステムID+サービスID+企業コードで検索して、
                        # 　見つかったレコードの企業コードを空欄にする
                        # ・ワークショップを申し込んだユーザーのAuth0アカウント(+Auth0ユーザ情報管理テーブル)から
                        # 　システムID+サービスID+企業コードのメタデータを削除する。
                        # 　※アプリ側のWebサイトにログインできないようにするため。

                        logger.debug('# ******************************')

                        if '# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用不可能にする。':

                            logger.debug('# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用不可能にする。')

                            logger.debug('# ******************************')

                            t_mr = None
                            data_t_mr = None

                            if '# テーブル「申込管理情報」からデータ取得する。':

                                logger.debug('# テーブル「申込管理情報」からデータ取得する。')
                                logger.debug('# t_manage_request')

                                # from ..model.t_manage_request import Sub as TMR
                                # t_mr = TMR()
                                TMR = GV.get_module('t_manage_request')
                                t_mr = TMR()

                                filters = []
                                filters.append(t_mr.model_class.system_id == data['system_id'])
                                filters.append(t_mr.model_class.service_id == data['service_id'])
                                filters.append(t_mr.model_class.company_code == data['company_code'])
                                filters = and_(*filters)

                                tmp_t_mr = t_mr._get_item_by_filters(filters)

                                if tmp_t_mr:

                                    data_t_mr = tmp_t_mr.to_dict()
                                    logger.debug(data_t_mr)

                            logger.debug('# ##############################')

                            if data_t_mr is not None:

                                logger.debug('# ******************************')

                                if '# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】':

                                    logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】')
                                    logger.debug('# m_auth_user_info')

                                    # from ..model.m_auth0_user_info import Sub as MAUI
                                    # m_aui = MAUI()
                                    MAUI = GV.get_module('m_auth0_user_info')
                                    m_aui = MAUI()

                                    filters = []
                                    filters.append(m_aui.model_class.auth0_user_id == data_t_mr['auth0_user_id'])                        
                                    filters.append(m_aui.model_class.company_code == data['company_code'])
                                    filters.append(m_aui.model_class.system_id == data['system_id'])
                                    filters.append(m_aui.model_class.service_id == data['service_id'])
                                    filters = and_(*filters)

                                    tmp_m_aui = m_aui._get_item_by_filters(filters)

                                    if tmp_m_aui:

                                        data_m_aui = tmp_m_aui.to_dict()
                                        logger.debug(data_m_aui)

                                        # if data_m_aui['roles'] is not None and data_m_aui['roles'] != '':
                                        #     roles = json.loads(data_m_aui['roles'])
                                            
                                        #     if GV.ROLES_WORKSHOP_USER in roles:
                                        #         roles.remove(GV.ROLES_WORKSHOP_USER)
                                            
                                        #     data_m_aui['roles'] = json.dumps(roles)
                                        
                                        # logger.debug('# 更新する')
                                        # m_aui._update(data_m_aui)

                                        logger.debug('# 削除する')
                                        m_aui._delete(data_m_aui)

                                    logger.debug('# データ登録OKの場合')

                                logger.debug('# ##############################')

                        logger.debug('# ##############################')


                        logger.debug('# ******************************')

                        if '# テーブル「申込管理情報」を更新する。':

                            logger.debug('# テーブル「申込管理情報」を更新する。')
                            logger.debug('# t_manage_request')

                            # from ..model.t_manage_request import Sub as TMR
                            # t_mr = TMR()
                            TMR = GV.get_module('t_manage_request')
                            t_mr = TMR()

                            filters = []
                            filters.append(t_mr.model_class.system_id == data['system_id'])
                            filters.append(t_mr.model_class.service_id == data['service_id'])
                            filters.append(t_mr.model_class.company_code == data['company_code'])
                            # filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
                            filters = and_(*filters)

                            tmp_t_mr = t_mr._get_item_by_filters(filters)

                            if tmp_t_mr:

                                data_t_mr = tmp_t_mr.to_dict()
                                logger.debug(data_t_mr)

                                # システム利用可能フラグ
                                logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                                data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                                
                                logger.debug('# 「ステータス」を「ワークショップキャンセル」にする')
                                data_t_mr['status'] = GV.STATUS['ワークショップキャンセル']

                                logger.debug('# 更新する')
                                t_mr._update(data_t_mr)

                        logger.debug('# ##############################')

                        workshop_event_date_id = None
                        t_wrc = None
                        data_t_wrc = None

                        logger.debug('# ******************************')

                        if '# ワークショップ実施済みフラグをfalseにする。':
                            
                            logger.debug('# ワークショップ実施済みフラグをfalseにする。')

                            logger.debug('# ******************************')

                            if '# テーブル「ワークショップ申込情報（確認済み）」を更新する。':

                                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を更新する。')
                                logger.debug('# t_workshop_request_confirmed')

                                TWRC = GV.get_module('t_workshop_request_confirmed')
                                t_wrc = TWRC()

                                VW = GV.get_module('view_workshop')
                                v_w = VW()

                                filters = []
                                # filters.append(v_w.model_class.workshop_req_id == data['workshop_req_id'])
                                filters.append(v_w.model_class.system_id == data['system_id'])
                                filters.append(v_w.model_class.service_id == data['service_id'])
                                filters.append(v_w.model_class.company_code == data['company_code'])
                                filters = and_(*filters)

                                tmp_v_w = v_w._get_item_by_filters(filters)

                                if tmp_v_w:

                                    data_t_wrc = tmp_v_w.to_dict()
                                    logger.debug(data_t_wrc)

                                    logger.debug('# ******************************')
                                    
                                    if data_t_wrc['workshop_event_date_id'] is not None:

                                        workshop_event_date_id = data_t_wrc['workshop_event_date_id']

                                        if '# テーブル「ワークショップ開催日マスタ」にデータ更新する':

                                            logger.debug('# テーブル「ワークショップ開催日マスタ」にデータ更新する')
                                            logger.debug('m_workshop_event_date')

                                            logger.debug('申込フラフ:workshop_request_flgをTrueにする')

                                            MWED = GV.get_module('m_workshop_event_date')
                                            m_wed = MWED()

                                            data_m_wed = {}
                                            data_m_wed['workshop_event_date_id'] = data_t_wrc['workshop_event_date_id']
                                            data_m_wed['workshop_request_flg'] = False
                                            tmp_m_wed = m_wed._update(data_m_wed)

                                            if tmp_m_wed:
                                                data_m_wed1 = tmp_m_wed.to_dict()
                                                logger.debug(data_m_wed1)
                                            else:
                                                logger.error('# テーブル「ワークショップ開催日マスタ」にデータ更新失敗')
                                                logger.error(data_m_wed)
                                                raise CustomException('SYS_ERR_100')

                                    logger.debug('# ##############################')

                                    # ???
                                    logger.debug('# 「ワークショップ開催希望日ID」をNoneにする')
                                    data_t_wrc['workshop_event_date_id'] = None

                                    # ???
                                    logger.debug('# 「ワークショップ実施日」をNoneにする')
                                    data_t_wrc['workshop_event_result_date'] = None

                                    logger.debug('# 「ワークショップ実施済みフラグ」をFalseにする')
                                    data_t_wrc['workshop_finished_flg'] = False

                                    logger.debug('# 「ワークショップのキャンセル理由」をセットする')
                                    if 'reason_for_cancel' in data:
                                        data_t_wrc['reason_for_cancel'] = data['reason_for_cancel']

                                    logger.debug('# 更新する')
                                    t_wrc._update(data_t_wrc)

                            logger.debug('# ##############################')

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        if '# マシンが未使用の場合は環境の停止依頼メール送信。':

                            logger.debug('# マシンが未使用の場合は環境の停止依頼メール送信。')

                            data_email = {}
                            data_email['service_id'] = data['service_id']
                            data_email['mail_type'] = '環境の停止依頼'

                            if data_t_wrc['env_id'] is not None:
                                data_email['env_id'] = data_t_wrc['env_id']
                            else:
                                data_email['env_id'] = ''

                            data_email['system_id'] = data_t_wrc['system_id']
                            data_email['service_id'] = data_t_wrc['service_id']
                            data_email['system_name'] = data_t_wrc['system_name']
                            data_email['service_name'] = data_t_wrc['service_name']
                            data_email['company_code'] = data_t_wrc['company_code']
                            data_email['company_name'] = data_t_wrc['company_name']

                            self.send_email_workshop(data_email)
                        
                        logger.debug('# ##############################')
                        

                        logger.debug('# ******************************')

                        if '# マシンが使用済みの場合は環境の削除依頼メールを送信する。':

                            logger.debug('# マシンが使用済みの場合は環境の削除依頼メールを送信する。')
                            
                            # 障害 #4713 2024/05/08 L S
                            # if use_flg == True:
                            if use_flg == True and deleted_flag == False:
                            # 障害 #4713 2024/05/08 L E

                                data_email = {}
                                data_email['service_id'] = data_t_wrc['service_id']
                                data_email['mail_type'] = '環境の削除依頼'

                                if data_t_wrc['env_id'] is not None:
                                    data_email['env_id'] = data_t_wrc['env_id']
                                else:
                                    data_email['env_id'] = ''
                                    
                                data_email['system_id'] = data_t_wrc['system_id']
                                data_email['service_id'] = data_t_wrc['service_id']
                                data_email['system_name'] = data_t_wrc['system_name']
                                data_email['service_name'] = data_t_wrc['service_name']
                                data_email['company_code'] = data_t_wrc['company_code']
                                data_email['company_name'] = data_t_wrc['company_name']

                                self.send_email_workshop(data_email)
                        
                        logger.debug('# ##############################')
                        

                        logger.debug('# ******************************')

                        if '# ワークショップのキャンセル受付メールを申込者、営業ML、サポートMLに送信する。':

                            data_t_wed = None

                            if workshop_event_date_id is not None:

                                logger.debug('# ******************************')
                                logger.debug('# 「ワークショップ実施日」を取得する')
                                
                                params = {
                                    'table_name': 'm_workshop_event_date',
                                    'filters': {
                                        'workshop_event_date_id': workshop_event_date_id
                                    }
                                }
                                data_t_wed = self.get_data(params)

                                if data_t_wed is None:
                                    logger.error('# 「ワークショップ実施日」を取得失敗')
                                    logger.error(params)
                                    raise CustomException('SYS_ERR_100')  

                                logger.debug('# ##############################')

                                logger.debug('# ワークショップのキャンセル受付メールを申込者、営業ML、サポートMLに送信する。')
                                                
                                data_email = {}
                                data_email['service_id'] = data_t_wrc['service_id']
                                data_email['mail_type'] = 'ワークショップのキャンセル受付'
                                data_email['email_address'] = data_t_wrc['email_address']
                                data_email['company_name'] = data_t_wrc['company_name']
                                data_email['last_name'] = data_t_wrc['last_name']
                                data_email['first_name'] = data_t_wrc['first_name']

                                wed = data_t_wed['workshop_event_date']
                                wed = datetime.strptime(wed[0:19], '%Y-%m-%dT%H:%M:%S')
                                data_email['workshop_event_date'] = wed.strftime('%Y年%m月%d日 %H:%M')

                                wetd = data_t_wed['workshop_event_time_division']
                                if wetd == 'AM':
                                    wetd = '午前'
                                elif wetd == 'PM':
                                    wetd = '午後'
                                data_email['workshop_event_time_division'] = wetd

                                data_email['affiliation_department'] = data_t_wrc['affiliation_department']
                                data_email['telephone_number'] = data_t_wrc['telephone_number']
                                data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                                self.send_email_workshop(data_email)
                        
                        logger.debug('# ##############################')

                        pass

                    else:

                        # 使用済フラグ
                        use_flg = False
                        # 障害 #4713 2024/05/08 L S
                        # 削除済みフラグ
                        deleted_flag = False
                        # 障害 #4713 2024/05/08 L E

                        logger.debug('# ******************************')

                        if '# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用不可能にする。':

                            logger.debug('# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用不可能にする。')

                            logger.debug('# ******************************')

                            if '# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】':

                                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】')
                                logger.debug('# m_auth_user_info')

                                # from ..model.m_auth0_user_info import Sub as MAUI
                                # m_aui = MAUI()
                                MAUI = GV.get_module('m_auth0_user_info')
                                m_aui = MAUI()

                                filters = []
                                filters.append(m_aui.model_class.auth0_user_id == data['auth0_user_id'])                        
                                filters.append(m_aui.model_class.company_code == data['company_code'])
                                filters.append(m_aui.model_class.system_id == data['system_id'])
                                filters.append(m_aui.model_class.service_id == data['service_id'])
                                filters = and_(*filters)

                                tmp_m_aui = m_aui._get_item_by_filters(filters)

                                if tmp_m_aui:

                                    data_m_aui = tmp_m_aui.to_dict()
                                    logger.debug(data_m_aui)

                                    # if data_m_aui['roles'] is not None and data_m_aui['roles'] != '':
                                    #     roles = json.loads(data_m_aui['roles'])
                                        
                                    #     if GV.ROLES_WORKSHOP_USER in roles:
                                    #         roles.remove(GV.ROLES_WORKSHOP_USER)
                                        
                                    #     data_m_aui['roles'] = json.dumps(roles)
                                    
                                    # logger.debug('# 更新する')
                                    # m_aui._update(data_m_aui)

                                    logger.debug('# 削除する')
                                    m_aui._delete(data_m_aui)

                                logger.debug('# データ登録OKの場合')

                            logger.debug('# ##############################')
                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        if '# テーブル「申込管理情報」を更新する。':

                            logger.debug('# テーブル「申込管理情報」を更新する。')
                            logger.debug('# t_manage_request')

                            # from ..model.t_manage_request import Sub as TMR
                            # t_mr = TMR()
                            TMR = GV.get_module('t_manage_request')
                            t_mr = TMR()

                            filters = []
                            filters.append(t_mr.model_class.system_id == data['system_id'])
                            filters.append(t_mr.model_class.service_id == data['service_id'])
                            filters.append(t_mr.model_class.company_code == data['company_code'])
                            filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
                            filters = and_(*filters)

                            tmp_t_mr = t_mr._get_item_by_filters(filters)

                            if tmp_t_mr:

                                data_t_mr = tmp_t_mr.to_dict()
                                logger.debug(data_t_mr)

                                # システム利用可能フラグ
                                logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                                data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                                
                                logger.debug('# 「ステータス」を「ワークショップキャンセル」にする')
                                data_t_mr['status'] = GV.STATUS['ワークショップキャンセル']

                                logger.debug('# 更新する')
                                t_mr._update(data_t_mr)

                
                        logger.debug('# ##############################')
                        
                        logger.debug('# ******************************')

                        if '# ワークショップ実施済みフラグをfalseにする。':
                            
                            logger.debug('# ワークショップ実施済みフラグをfalseにする。')

                            logger.debug('# ******************************')

                            if '# テーブル「ワークショップ申込情報（確認済み）」を更新する。':

                                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を更新する。')
                                logger.debug('# t_workshop_request_confirmed')

                                # from ..model.t_workshop_request_confirmed import Sub as TWRC
                                # t_wrc = TWRC()
                                TWRC = GV.get_module('t_workshop_request_confirmed')
                                t_wrc = TWRC()

                                filters = []
                                filters.append(t_wrc.model_class.workshop_req_id == data['workshop_req_id'])
                                filters.append(t_wrc.model_class.system_id == data['system_id'])
                                filters.append(t_wrc.model_class.service_id == data['service_id'])
                                filters.append(t_wrc.model_class.company_code == data['company_code'])
                                filters = and_(*filters)

                                tmp_t_wrc = t_wrc._get_item_by_filters(filters)

                                if tmp_t_wrc:

                                    data_t_wrc = tmp_t_wrc.to_dict()
                                    logger.debug(data_t_wrc)

                                    logger.debug('# ******************************')

                                    if data_t_wrc['workshop_event_date_id'] is not None:
                                    
                                        if '# テーブル「ワークショップ開催日マスタ」にデータ更新する':

                                            logger.debug('# テーブル「ワークショップ開催日マスタ」にデータ更新する')
                                            logger.debug('m_workshop_event_date')

                                            logger.debug('申込フラフ:workshop_request_flgをTrueにする')

                                            MWED = GV.get_module('m_workshop_event_date')
                                            m_wed = MWED()

                                            data_m_wed = {}
                                            data_m_wed['workshop_event_date_id'] = data_t_wrc['workshop_event_date_id']
                                            data_m_wed['workshop_request_flg'] = False
                                            tmp_m_wed = m_wed._update(data_m_wed)

                                            if tmp_m_wed:
                                                data_m_wed1 = tmp_m_wed.to_dict()
                                                logger.debug(data_m_wed1)
                                            else:
                                                logger.error('# テーブル「ワークショップ開催日マスタ」にデータ更新失敗')
                                                logger.error(data_m_wed)
                                                raise CustomException('SYS_ERR_100')

                                    logger.debug('# ##############################')
                                    
                                    # ???
                                    logger.debug('# 「ワークショップ開催希望日ID」をNoneにする')
                                    data_t_wrc['workshop_event_date_id'] = None

                                    # ???
                                    logger.debug('# 「ワークショップ実施日」をNoneにする')
                                    data_t_wrc['workshop_event_result_date'] = None

                                    logger.debug('# 「ワークショップ実施済みフラグ」をFalseにする')
                                    data_t_wrc['workshop_finished_flg'] = False

                                    logger.debug('# 更新する')
                                    t_wrc._update(data_t_wrc)

                            logger.debug('# ##############################')

                        logger.debug('# ##############################')
                                        
                        pass

                    pass

                elif params['status'] == 'ワークショップ受付':
                    
                    logger.debug('# ******************************')

                    if '# テーブル「申込管理情報」を更新する。':

                        logger.debug('# テーブル「申込管理情報」を更新する。')
                        logger.debug('# t_manage_request')

                        # from ..model.t_manage_request import Sub as TMR
                        # t_mr = TMR()
                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        filters = []
                        filters.append(t_mr.model_class.system_id == data['system_id'])
                        filters.append(t_mr.model_class.service_id == data['service_id'])
                        filters.append(t_mr.model_class.company_code == data['company_code'])
                        filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
                        filters = and_(*filters)

                        tmp_t_mr = t_mr._get_item_by_filters(filters)

                        if tmp_t_mr:

                            data_t_mr = tmp_t_mr.to_dict()
                            logger.debug(data_t_mr)

                            # システム利用可能フラグ
                            logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                            data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                            
                            logger.debug('# 「ステータス」を「ワークショップ受付」にする')
                            data_t_mr['status'] = GV.STATUS['ワークショップ受付']

                            logger.debug('# 更新する')
                            t_mr._update(data_t_mr)

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                elif params['status'] == 'ワークショップ実施中':
                    logger.debug('定期実行処理でワークショップ実施日の9:00に処理をする')

                    logger.debug('# ******************************')
                    data_m_sys = None

                    if '# テーブル「システムマスタ」からデータ取得':

                        logger.debug('# テーブル「システムマスタ」からデータ取得')
                        logger.debug('# m_systems')

                        params_m_systems = {
                            'table_name': 'm_systems',
                            'filters': {
                                'system_id': data['system_id']
                            }
                        }

                        data_m_sys = self.get_data(params_m_systems)

                        if data_m_sys is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# データ取得NGの場合')
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# データ取得OKの場合')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')

                    t_mr = None
                    data_t_mr = None

                    if '# テーブル「申込管理情報」からデータ取得する。':

                        logger.debug('# テーブル「申込管理情報」からデータ取得する。')
                        logger.debug('# t_manage_request')

                        # from ..model.t_manage_request import Sub as TMR
                        # t_mr = TMR()
                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        filters = []
                        filters.append(t_mr.model_class.system_id == data['system_id'])
                        filters.append(t_mr.model_class.service_id == data['service_id'])
                        filters.append(t_mr.model_class.company_code == data['company_code'])
                        filters = and_(*filters)

                        tmp_t_mr = t_mr._get_item_by_filters(filters)

                        if tmp_t_mr:

                            data_t_mr = tmp_t_mr.to_dict()
                            logger.debug(data_t_mr)

                    logger.debug('# ##############################')
                    
                    # logger.debug('# ******************************')

                    # data_t_wrc = None

                    # if '# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。':

                    #     logger.debug('# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。')
                    #     logger.debug('# t_workshop_request_confirmed')

                    #     #  from ..model.t_workshop_request_confirmed import Sub as TWRC
                    #     #  t_wrc = TWRC()
                    #     TWRC = GV.get_module('t_workshop_request_confirmed')
                    #     t_wrc = TWRC()

                    #     filters = []
                    #     filters.append(t_wrc.model_class.system_id == data['system_id'])
                    #     filters.append(t_wrc.model_class.service_id == data['service_id'])
                    #     filters.append(t_wrc.model_class.company_code == data['company_code'])
                    #     filters = and_(*filters)

                    #     tmp_t_wrc = t_wrc._get_item_by_filters(filters)

                    #     if tmp_t_wrc:

                    #         data_t_wrc = tmp_t_wrc.to_dict()
                    #         logger.debug(data_t_wrc)

                    # logger.debug('# ##############################')
                   
                    logger.debug('# ******************************')

                    logger.debug('# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用可能にする。')

                    if '# テーブル「Auth0ユーザー情報管理」にデータ登録【ワークショップユーザー】':

                        logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録【ワークショップユーザー】')
                        logger.debug('# m_auth_user_info')

                        # from ..model.m_auth0_user_info import Sub as MAUI
                        # m_aui = MAUI()
                        MAUI = GV.get_module('m_auth0_user_info')
                        m_aui = MAUI()

                        # ワークショップユーザーメタデータサンプル
                        # "company_code":"K00001",
                        # "system_id":"SYS00001",
                        # "service_id":"SRV00001",
                        # "activedirectory_username":"ENV00001.user001@simulation.space",
                        # "appstream_stackname":"SYS00001-SRV00001-appstream-stack-activedirectory-ENV00001",
                        # "roles":[
                        #     "workshop_user"
                        # ]

                        param_m_aui = {}
                        # Auth0ユーザーID
                        param_m_aui['auth0_user_id'] = data_t_mr['auth0_user_id']
                        # ログイン先企業コード
                        param_m_aui['company_code'] = data['company_code']
                        # ログイン先システムID
                        param_m_aui['system_id'] = data['system_id']
                        # ログイン先サービスID
                        param_m_aui['service_id'] = data['service_id']
                        # activedirectory_username
                        # ENV00001.user001@simulation.space
                        tmp_adun = data_m_es['env_id']
                        # tmp_adun += '.' + 'user001'
                        tmp_adun += '.' + 'user000'
                        tmp_adun += '@' + data_m_sys['ad_domain_name']
                        param_m_aui['activedirectory_username'] = tmp_adun
                        # appstream_stackname
                        # SYS00001-SRV00001-appstream-stack-activedirectory-ENV00001
                        tmp_assn = data['system_id'] + '-'
                        tmp_assn += data['service_id'] + '-'
                        tmp_assn += 'appstream-stack-activedirectory' + '-'
                        tmp_assn += data_m_es['env_id']
                        param_m_aui['appstream_stackname'] = tmp_assn
                        # 付与ロールのリスト
                        param_m_aui['roles'] = [GV.ROLES_WORKSHOP_USER]

                        params_m_auth0_user_info = {
                            'table_name': 'm_auth0_user_info',
                            'filters': {
                                'auth0_user_id': param_m_aui['auth0_user_id'],
                                'company_code': param_m_aui['company_code'],
                                'system_id': param_m_aui['system_id'],
                                'service_id': param_m_aui['service_id']
                            }
                        }
                        data_m_aui = self.get_data(params_m_auth0_user_info)
                        logger.debug(data_m_aui)

                        tmp_m_aui = None

                        if data_m_aui:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                            param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                            tmp_m_aui = m_aui._update(param_m_aui)
                            pass
                        else:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                            tmp_m_aui = m_aui._add(param_m_aui)
                            pass

                        if tmp_m_aui is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# データ登録NGの場合')
                            raise CustomException('SYS_ERR_100')

                        logger.debug('# データ登録OKの場合')

                    logger.debug('# ##############################')

                    logger.debug('# ******************************')
                    
                    if '# テーブル「申込管理情報」を更新する。':

                        logger.debug('# テーブル「申込管理情報」を更新する。')
                        logger.debug('# t_manage_request')

                        # # from ..model.t_manage_request import Sub as TMR
                        # # t_mr = TMR()
                        # TMR = GV.get_module('t_manage_request')
                        # t_mr = TMR()

                        # filters = []
                        # filters.append(t_mr.model_class.system_id == data['system_id'])
                        # filters.append(t_mr.model_class.service_id == data['service_id'])
                        # filters.append(t_mr.model_class.company_code == data['company_code'])
                        # # filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
                        # filters = and_(*filters)

                        # tmp_t_mr = t_mr._get_item_by_filters(filters)

                        # if tmp_t_mr:

                        #     data_t_mr = tmp_t_mr.to_dict()
                        #     logger.debug(data_t_mr)

                        #     logger.debug('# 「ステータス」を「ワークショップ実施中」にする')
                        #     data_t_mr['status'] = GV.STATUS['ワークショップ実施中']

                        #     logger.debug('# 更新する')
                        #     t_mr._update(data_t_mr)

                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']

                        logger.debug('# 「ステータス」を「ワークショップ実施中」にする')
                        data_t_mr['status'] = GV.STATUS['ワークショップ実施中']

                        logger.debug(data_t_mr)

                        logger.debug('# 更新する')
                        t_mr._update(data_t_mr)

                    logger.debug('# ##############################')

                    pass

                    pass

                elif params['status'] == 'ワークショップ終了':

                    if 'send_delete_env_mail' in data:

                        if data['send_delete_env_mail'] == True:

                            t_wrc = None
                            data_t_wrc = None

                            logger.debug('# ******************************')

                            if '# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。':

                                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。')
                                logger.debug('# t_workshop_request_confirmed')

                                TWRC = GV.get_module('t_workshop_request_confirmed')
                                t_wrc = TWRC()

                                VW = GV.get_module('view_workshop')
                                v_w = VW()

                                filters = []
                                filters.append(v_w.model_class.system_id == data['system_id'])
                                filters.append(v_w.model_class.service_id == data['service_id'])
                                filters.append(v_w.model_class.company_code == data['company_code'])
                                filters = and_(*filters)

                                tmp_v_w = v_w._get_item_by_filters(filters)

                                if tmp_v_w:

                                    data_t_wrc = tmp_v_w.to_dict()
                                    logger.debug(data_t_wrc)

                            logger.debug('# ##############################')

                            logger.debug('# ******************************')

                            if '# 環境の削除依頼メールを送信する。':
                                
                                # 障害 #4713 2024/05/08 L S
                                if data_t_wrc['deleted_flag'] == False:
                                    logger.debug('# 環境の削除依頼メールを送信する。')
    
                                    data_email = {}
                                    data_email['service_id'] = data['service_id']
                                    data_email['mail_type'] = '環境の削除依頼'
    
                                    if data_t_wrc['env_id'] is not None:
                                        data_email['env_id'] = data_t_wrc['env_id']
                                    else:
                                        data_email['env_id'] = ''
    
                                    data_email['system_id'] = data_t_wrc['system_id']
                                    data_email['service_id'] = data_t_wrc['service_id']
                                    data_email['system_name'] = data_t_wrc['system_name']
                                    data_email['service_name'] = data_t_wrc['service_name']
                                    data_email['company_code'] = data_t_wrc['company_code']
                                    data_email['company_name'] = data_t_wrc['company_name']
                                    
                                    self.send_email_workshop(data_email)
                                
                                # 障害 #4713 2024/05/08 L E
                            
                            logger.debug('# ##############################')

                        pass

                    else:

                        logger.debug('# 前提条件')
                        logger.debug('# ・ワークショップ実施日時が登録されている')
                        
                        logger.debug('定期実行処理でワークショップ実施日の18:00に処理をする')

                        t_wrc = None
                        data_t_wrc = None

                        logger.debug('# ******************************')

                        if '# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。':

                            logger.debug('# テーブル「ワークショップ申込情報（確認済み）」からデータ取得する。')
                            logger.debug('# t_workshop_request_confirmed')

                            TWRC = GV.get_module('t_workshop_request_confirmed')
                            t_wrc = TWRC()

                            VW = GV.get_module('view_workshop')
                            v_w = VW()

                            filters = []
                            filters.append(v_w.model_class.system_id == data['system_id'])
                            filters.append(v_w.model_class.service_id == data['service_id'])
                            filters.append(v_w.model_class.company_code == data['company_code'])
                            filters = and_(*filters)

                            tmp_v_w = v_w._get_item_by_filters(filters)

                            if tmp_v_w:

                                data_t_wrc = tmp_v_w.to_dict()
                                logger.debug(data_t_wrc)

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        if '# 前提条件をチェックする。':

                            logger.debug('# 前提条件をチェックする。')
                            logger.debug('# ・ワークショップ実施日時が登録されている')
                        
                            if data_t_wrc is not None and data_t_wrc['workshop_event_result_date'] is None:
                                logger.debug('# ワークショップ実施日時が登録されてない')
                                data['code'] = 'NG'
                                data['message'] = 'ワークショップ実施日時が登録されてない'
                                return data

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        
                        t_mr = None
                        data_t_mr = None

                        if '# テーブル「申込管理情報」からデータを取得する。':

                            logger.debug('# テーブル「申込管理情報」からデータを取得する。')
                            logger.debug('# t_manage_request')

                            # from ..model.t_manage_request import Sub as TMR
                            # t_mr = TMR()
                            TMR = GV.get_module('t_manage_request')
                            t_mr = TMR()

                            filters = []
                            filters.append(t_mr.model_class.system_id == data['system_id'])
                            filters.append(t_mr.model_class.service_id == data['service_id'])
                            filters.append(t_mr.model_class.company_code == data['company_code'])
                            filters = and_(*filters)

                            tmp_t_mr = t_mr._get_item_by_filters(filters)

                            if tmp_t_mr:

                                data_t_mr = tmp_t_mr.to_dict()
                                logger.debug(data_t_mr)

                        logger.debug('# ##############################')
                        
                        logger.debug('# ******************************')

                        logger.debug('# お客様のAuth0アカウントのメタデータを更新してワークショップ環境を利用不可能にする。')

                        if '# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】':

                            logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ削除【ワークショップユーザー】')
                            logger.debug('# m_auth_user_info')

                            # from ..model.m_auth0_user_info import Sub as MAUI
                            # m_aui = MAUI()
                            MAUI = GV.get_module('m_auth0_user_info')
                            m_aui = MAUI()

                            filters = []
                            filters.append(m_aui.model_class.auth0_user_id == data_t_mr['auth0_user_id'])                        
                            filters.append(m_aui.model_class.company_code == data['company_code'])
                            filters.append(m_aui.model_class.system_id == data['system_id'])
                            filters.append(m_aui.model_class.service_id == data['service_id'])
                            filters = and_(*filters)

                            tmp_m_aui = m_aui._get_item_by_filters(filters)

                            if tmp_m_aui:

                                data_m_aui = tmp_m_aui.to_dict()
                                logger.debug(data_m_aui)

                                roles = None
                                if data_m_aui['roles'] is not None and data_m_aui['roles'] != '':
                                    roles = json.loads(data_m_aui['roles'])
                                    
                                    if GV.ROLES_WORKSHOP_USER in roles:
                                        roles.remove(GV.ROLES_WORKSHOP_USER)
                                
                                has_roles = False
                                if roles is not None:
                                    if len(roles) > 0:
                                        data_m_aui['roles'] = json.dumps(roles)
                                        has_roles = True
    
                                if has_roles == False:
                                    m_aui._delete(data_m_aui)
                                else:
                                    logger.debug('# 更新する')
                                    m_aui._update(data_m_aui)


                            logger.debug('# データ登録OKの場合')

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        if '# 環境の停止依頼メールを送信する。':

                            logger.debug('# 環境の停止依頼メールを送信する。')

                            data_email = {}
                            data_email['service_id'] = data['service_id']
                            data_email['mail_type'] = '環境の停止依頼'

                            if data_t_wrc['env_id'] is not None:
                                data_email['env_id'] = data_t_wrc['env_id']
                            else:
                                data_email['env_id'] = ''

                            data_email['system_id'] = data_t_wrc['system_id']
                            data_email['service_id'] = data_t_wrc['service_id']
                            data_email['system_name'] = data_t_wrc['system_name']
                            data_email['service_name'] = data_t_wrc['service_name']
                            data_email['company_code'] = data_t_wrc['company_code']
                            data_email['company_name'] = data_t_wrc['company_name']
                            
                            self.send_email_workshop(data_email)
                        
                        logger.debug('# ##############################')

                        logger.debug('# ******************************')

                        if '# ワークショップ実施済みフラグをtrueにする。':

                            logger.debug('# ワークショップ実施済みフラグをtrueにする。')

                            if '# テーブル「ワークショップ申込情報（確認済み）」を更新する。':

                                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を更新する。')
                                logger.debug('# t_workshop_request_confirmed')
                                
                                logger.debug('# 「ワークショップ実施済みフラグ」をTrueにする')
                                data_t_wrc['workshop_finished_flg'] = True

                                logger.debug('# 更新する')
                                t_wrc._update(data_t_wrc)

                            logger.debug('# ##############################')

                        logger.debug('# ##############################')

                        logger.debug('# ******************************')
                        
                        if '# テーブル「申込管理情報」を更新する。':

                            logger.debug('# テーブル「申込管理情報」を更新する。')
                            logger.debug('# t_manage_request')

                            # # from ..model.t_manage_request import Sub as TMR
                            # # t_mr = TMR()
                            # TMR = GV.get_module('t_manage_request')
                            # t_mr = TMR()

                            # filters = []
                            # filters.append(t_mr.model_class.system_id == data['system_id'])
                            # filters.append(t_mr.model_class.service_id == data['service_id'])
                            # filters.append(t_mr.model_class.company_code == data['company_code'])
                            # filters.append(t_mr.model_class.workshop_req_id == data['workshop_req_id'])
                            # filters = and_(*filters)

                            # tmp_t_mr = t_mr._get_item_by_filters(filters)

                            # if tmp_t_mr:

                            #     data_t_mr = tmp_t_mr.to_dict()
                            #     logger.debug(data_t_mr)

                            #     logger.debug('# 「ステータス」を「ワークショップ終了」にする')
                            #     data_t_mr['status'] = GV.STATUS['ワークショップ終了']

                            #     logger.debug('# 更新する')
                            #     t_mr._update(data_t_mr)

                            # システム利用可能フラグ
                            logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                            data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                            
                            logger.debug('# 「ステータス」を「ワークショップ終了」にする')
                            data_t_mr['status'] = GV.STATUS['ワークショップ終了']

                            logger.debug('# 更新する')
                            t_mr._update(data_t_mr)

                        logger.debug('# ##############################')

                        pass

                    pass

            return data
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            
            logger.debug('# ##############################')
        pass

    # 定期実行
    # ワークショップ時の環境起動依頼
    # ワークショップ実施日のn日前に「ワークショップ時の環境起動依頼」メールを送信する
    def periodic_execution_environment_activation_request(self, data=None):
        try:
            logger.debug('# ******************************')

            logger.debug('# 定期実行')
            logger.debug('# ワークショップ時の環境起動依頼')
            logger.debug('# ワークショップ実施日のn日前に「ワークショップ時の環境起動依頼」メールを送信する')
            logger.debug('# periodic_execution_environment_activation_request')

            logger.debug('# ******************************')

            list_n_days_ago = GV.WORKSHOP_PEEAR_LIST_N_DAYS_AGO

            for n in list_n_days_ago:

                if '# N日前のデータを取得':

                    today = datetime.now()
                    n_days_later = today + timedelta(days=n)
                    logger.debug('n_days_later')
                    logger.debug(n_days_later)

                    logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を検索する。')
                    logger.debug('# t_workshop_request_confirmed')

                    from sqlalchemy import Date, cast
                    from datetime import date

                    VW = GV.get_module('view_workshop')
                    v_w = VW()

                    filters = []
                    filters.append(v_w.model_class.env_id != None)
                    filters.append(cast(v_w.model_class.workshop_event_result_date, Date) == n_days_later.date())
                    filters = and_(*filters)

                    tmp_v_w = v_w._get_item_by_filters(filters, get_all=True)

                    if tmp_v_w is not None:

                        for t in tmp_v_w:

                            d = t.to_dict()
                            logger.debug(d)

                            logger.debug('# ******************************')
                            logger.debug('# 「ワークショップ時の環境起動依頼」メールを送信する')

                            logger.debug('# メール ワークショップ時の環境起動依頼')

                            data_email = {}
                            data_email['env_id'] = d['env_id']
                            data_email['system_id'] = d['system_id']
                            data_email['service_id'] = d['service_id']
                            data_email['system_name'] = d['system_name']
                            data_email['service_name'] = d['service_name']
                            data_email['company_code'] = d['company_code']

                            wed = d['workshop_event_date']
                            wed = datetime.strptime(wed[0:19], '%Y-%m-%dT%H:%M:%S')
                            data_email['workshop_event_date'] = wed.strftime('%Y年%m月%d日 %H:%M')

                            wetd = d['workshop_event_time_division']
                            if wetd == 'AM':
                                wetd = '午前'
                            elif wetd == 'PM':
                                wetd = '午後'
                            data_email['workshop_event_time_division'] = wetd

                            data_email['mail_type'] = 'ワークショップ時の環境起動依頼'

                            self.send_email_workshop(data_email)

                            logger.debug('# ##############################')


            logger.debug('# ##############################')

            if data is None:
                data = {}

            return data
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    # 定期実行
    # ワークショップ実施中
    # 定期実行処理でワークショップ実施日の9:00に処理をする
    def periodic_execution_in_progress(self, data=None):
        try:
            logger.debug('# ******************************')

            logger.debug('# 定期実行')
            logger.debug('# ワークショップ実施中')
            logger.debug('# 定期実行処理でワークショップ実施日の9:00に処理をする')
            
            logger.debug('# ******************************')

            if '# 当日のデータを取得':

                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を検索する。')
                logger.debug('# t_workshop_request_confirmed')

                from sqlalchemy import Date, cast
                from datetime import date

                # from ..model.t_workshop_request_confirmed import Sub as TWRC
                # t_wrc = TWRC()
                TWRC = GV.get_module('t_workshop_request_confirmed')
                t_wrc = TWRC()

                filters = []
                filters.append(cast(t_wrc.model_class.workshop_event_result_date, Date) == date.today())
                filters = and_(*filters)

                tmp_t_wrc = t_wrc._get_item_by_filters(filters, get_all=True)

                if tmp_t_wrc is not None:

                    for t in tmp_t_wrc:

                        d = t.to_dict()
                        logger.debug(d)

                        params_process = {
                            "status": "ワークショップ実施中"
                        }
                        data_process = {
                            "company_code": d['company_code'],
                            "system_id": d['system_id'],
                            "service_id": d['service_id']
                        }
                        self.process(params_process, data_process)

                        logger.debug('# Auth0ユーザ情報管理で当日ワークショップを行うユーザのworkshop_userのロールがついたレコードの削除する。')
                        logger.debug('# m_auth0_user_info')

                        MAUI = GV.get_module('m_auth0_user_info')
                        m_aui = MAUI()

                        filters = []
                        filters.append(m_aui.model_class.company_code == d['company_code'])
                        filters.append(m_aui.model_class.system_id == d['system_id'])
                        filters.append(m_aui.model_class.service_id == d['service_id'])
                        filters = and_(*filters)
                        tmp_m_aui = m_aui._get_item_by_filters(filters, get_all=True)
                        
                        if tmp_m_aui is not None and len(tmp_m_aui) > 0:
                            
                            for t in tmp_m_aui:
                                d = t.to_dict()
                                
                                if GV.ROLES_WORKSHOP_USER in d['roles']:
                                    tmp_m_aui_delete = m_aui._delete(d)

                                  
            logger.debug('# ##############################')

            if data is None:
                data = {}

            return data
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    # 定期実行
    # ワークショップ終了
    # 定期実行処理でワークショップ実施日の18:00に処理をする
    def periodic_execution_finished(self, data=None):
        try:
            logger.debug('# ******************************')

            logger.debug('# 定期実行')
            logger.debug('# ワークショップ終了')
            logger.debug('# 定期実行処理でワークショップ実施日の18:00に処理をする')
            
            logger.debug('# ******************************')

            if '# 当日のデータを取得':

                logger.debug('# テーブル「ワークショップ申込情報（確認済み）」を検索する。')
                logger.debug('# t_workshop_request_confirmed')

                from sqlalchemy import Date, cast
                from datetime import date

                # from ..model.t_workshop_request_confirmed import Sub as TWRC
                # t_wrc = TWRC()
                TWRC = GV.get_module('t_workshop_request_confirmed')
                t_wrc = TWRC()

                filters = []
                filters.append(cast(t_wrc.model_class.workshop_event_result_date, Date) == date.today())
                filters = and_(*filters)

                tmp_t_wrc = t_wrc._get_item_by_filters(filters, get_all=True)

                if tmp_t_wrc is not None:

                    for t in tmp_t_wrc:

                        d = t.to_dict()
                        logger.debug(d)

                        params_process = {
                            "status": "ワークショップ終了"
                        }
                        data_process = {
                            "company_code": d['company_code'],
                            "system_id": d['system_id'],
                            "service_id": d['service_id']
                        }
                        self.process(params_process, data_process)

                
            logger.debug('# ##############################')

            logger.debug('# 定期実行')
            logger.debug('# ワークショップ終了')
            logger.debug('# 環境削除依頼')
            logger.debug('# ワークショップの実施1週間後、プロセル管理のステータスが「本契約申請～本契約利用中」になっていない場合')
            logger.debug('# 環境の削除依頼メールをサポート(新事推開)に送信する。')
            
            logger.debug('# ******************************')

            if '# 1週間前のデータを取得':

                today = datetime.now()
                one_week_ago = today + timedelta(weeks=-1)
                logger.debug('one_week_ago')
                logger.debug(one_week_ago)

                logger.debug('# テーブル「view_workshop」を検索する。')
                logger.debug('# view_workshop')

                from sqlalchemy import Date, cast
                from datetime import date

                VW = GV.get_module('view_workshop')
                v_w = VW()

                filters = []
                filters.append(~v_w.model_class.status.in_([GV.STATUS['本契約申請'], GV.STATUS['本契約受付'], GV.STATUS['本契約利用中']]) )
                # filters.append(cast(v_w.model_class.workshop_event_result_date, Date) == one_week_ago.date())
                filters.append(cast(v_w.model_class.workshop_event_result_date, Date) <= one_week_ago.date())
                filters.append(v_w.model_class.env_id != None)
                filters = and_(*filters)

                tmp_v_w = v_w._get_item_by_filters(filters, get_all=True)

                if tmp_v_w is not None:

                    for t in tmp_v_w:

                        logger.debug('# 環境の削除依頼メールをサポート(新事推開)に送信する。')

                        d = t.to_dict()
                        logger.debug(d)

                        params_process = {
                            "status": "ワークショップ終了"
                        }
                        data_process = {
                            "company_code": d['company_code'],
                            "system_id": d['system_id'],
                            "service_id": d['service_id'],
                            "send_delete_env_mail": True
                        }
                        self.process(params_process, data_process)

            logger.debug('# ##############################')

            if data is None:
                data = {}

            return data
        except Exception as e:
            logger.debug(e)
            # 例外の再送出
            raise
        finally:
            logger.debug('# ##############################')

    def send_email_workshop(self, data, is_append_to=True):
        logger.debug('# ******************************')
        logger.debug('# send_email_workshop')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if is_append_to == True:
                if 'email_address' in data:
                        mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id']) 
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

    # 共通PF5　WebAP診断対応　nakamura.e 2024/07/30 -->
    def IsCanSelectedEvendDay(self, data_t_wrh, res):
        logger.debug('# ******************************')
        logger.debug('# IsCanSelectedEvendDay')
        logger.debug(data_t_wrh)

        try:
            # from ..model.m_workshop_event_date import Sub as MWED
            # m_wed = MWED()
            MWED = GV.get_module('m_workshop_event_date')
            m_wed = MWED()

            today = datetime.now()
            three_days_later = today + timedelta(days=3)

            logger.debug('# 検索条件')
            filters = []
            filters.append(m_wed.model_class.workshop_event_date_id == data_t_wrh["workshop_event_date_id"])
            filters.append(m_wed.model_class.system_id == GV.SYSTEM_ID)
            filters.append(m_wed.model_class.service_id == GV.SERVICE_ID)
            # 今日から3日後より後かつ予約が埋まっていない日時：選択可能
            filters.append(m_wed.model_class.workshop_event_date > three_days_later)
            filters.append(m_wed.model_class.workshop_request_flg == False)
            filters = and_(*filters)

            logger.debug('# 並び替え 開催日順')
            col = getattr(m_wed.model_class, 'workshop_event_date', None)
            order_by = asc(col)

            tmp_m_wed = m_wed._get_item_by_filters(
                filters, order_by=order_by, get_all=True)

            res = {}

            #検索にHitしない場合は選択できない日付なのでエラー終了
            # if tmp_m_wed and len(tmp_m_wed.count) < 1:
            #logger.debug(tmp_m_wed)
            if tmp_m_wed:
                logger.debug(tmp_m_wed)
            else:
                logger.debug('# 選択できないワークショップ実施日を指定されているのでエラー')
                return False

            return True
        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
    # 共通PF5　WebAP診断対応　nakamura.e 2024/07/30 <--