from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime, re

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'staff'

    def get_all(self, event, context):
        # --> 共通PF4 サプライヤー用表示 2024/02/08 nakamura.e
        view_name = 'view_staff'
        if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
            view_name = 'view_staff_supplier'

        # from ..view.view_staff import Sub as VS
        # v_s = VS()
        VS = GV.get_module(view_name)
        # <-- 共通PF4 サプライヤー用表示 2024/02/08 nakamura.e
        v_s = VS()

        return v_s.get_all(event, context)

        pass
    
    def get_table_schema(self):
        # --> 共通PF4 サプライヤー用表示 2024/02/08 nakamura.e
        view_name = 'view_staff'
        if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
            view_name = 'view_staff_supplier'

        # from ..view.view_staff import Sub as VS
        # v_s = VS()
        VS = GV.get_module(view_name)
        # <-- 共通PF4 サプライヤー用表示 2024/02/08 nakamura.e
        v_s = VS()

        v_s.table_config = self.table_name
        return v_s.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')
        
        logger.debug('# ************0704******************') 
        params = {
            'table_name': 'm_auth0_management',
            'filters': {
                'tenant': GV.CONFIG['AUTH0_TENANT']
            }
        }
        data_m_am = self.get_data(params)
        logger.debug(data_m_am)

        if data_m_am:
            logger.debug('# ************Auth0情報を設定する******************')
            GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
            GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
            GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
            GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
            GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
            GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
            logger.debug(GV.CONFIG)
            pass
        else:
            return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0704******************') 

        data = GV.EVENT_BODY

        data_a0 = None

        logger.debug('# ******************************')
        logger.debug('# Auth0アカウントが存在するかどうかチェックする')

        auth0_class = GV.get_module_auth0()
        logger.debug('# Auth0アカウントが存在するかどうかチェックする')
        a0 = auth0_class()

        users = a0._get_users_by_email(data['email'])

        if users and len(users) > 0:
            
            logger.debug('存在する場合')

            # raise CustomException('STAFF_ERR_ACCOUNT_EXIST')

            data_a0 = users[0]
        
        else:
            pass

        logger.debug('# ##############################')

        MS = GV.get_module('m_staff')
        m_s = MS()
        # --> 共通PF4 スタッフ登録されている場合はスタッフを作成しない 2024/03/05 nakamura.e

        filters = []
        filters.append(m_s.model_class.email == data['email']) 
        filters = and_(*filters)
        tmp_m_s = m_s._get_item_by_filters(filters)


        if tmp_m_s is None:
            tmp_m_s = m_s._add(data)
        # <-- 共通PF4 スタッフ登録されている場合はスタッフを作成しない 2024/03/05 nakamura.e


        if tmp_m_s is not None and data_a0 is None:

            data_m_s = tmp_m_s.to_dict()
            # --> 共通PF4 ロール自動設定 2024/02/07 nakamura.e
            if '# m_auth0_user_info':
                logger.debug('# 「m_auth0_user_info」を更新する')
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                params_m_aui = {}
                params_m_aui['auth0_user_id'] = data_m_s['auth0_user_id']
                params_m_aui['company_code'] = '000000'
                params_m_aui['system_id'] = 'SYS90001'
                params_m_aui['service_id'] = 'SRV90001'
                # サプライヤーでロールを追加。NDESスタッフにする場合は手動で切り替える
                params_m_aui['roles'] = '["supplier_staff", "' + GV.SYSTEM_NAME.lower() + '_support"]'
                        
                params_m_aui['blocked'] = False

                logger.debug('# ************0704******************') 
                params_m_aui['tenant'] = GV.CONFIG['AUTH0_TENANT']
                logger.debug('# ************0704******************') 

                tmp_m_aui = m_aui._add(params_m_aui)
            # <-- 共通PF4 ロール自動設定 2024/02/07 nakamura.e
            import uuid
            code = str(uuid.uuid4())

            logger.debug('# 認証コード生成')
            logger.debug('# ************0704******************') 
            code = 's-' + str(data_m_am['id']) + '-' + code
            logger.debug('# ************0704******************')

            logger.debug('# ******************************')
            logger.debug('# atuh0 update')
            
            app_metadata = {}
            app_metadata['data'] = []
            app_metadata['data'].append(
                {
                    'staff_req_vefification_code': code,
                    'staff_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                }
            )

            data_auth0 = {}
            data_auth0['app_metadata'] = app_metadata

            logger.debug('# data_auth0')
            logger.debug(data_auth0)

            a0._update(data_m_s['auth0_user_id'], data_auth0)
            
            logger.debug('# ##############################')

            logger.debug('# ******************************')
            logger.debug('# パスワードリセット メール送信')
            
            data_email = {}
            data_email['service_id'] = 'SRV90001'
            data_email['mail_type'] = 'スタッフ用パスワードリセット'
            data_email['email_address'] = data_m_s['email']

            data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
            data_email['login_url'] = f'{GV.URL_CLOUD_SERVICE_USER_MANAGE}'

            self.send_email_staff(data_email)

            logger.debug('# ##############################')
            # --> 共通PF4 サプライヤーの場合、既存のアカウントに選択しているシステムのロールを追加 2024/03/04 nakamura.e
        elif tmp_m_s is not None and data_a0 is not None:
            # Auth0アカウントがある場合
            data_m_s = tmp_m_s.to_dict()
            try:
                AUI = GV.get_module('auth0_user_info')
                aui = AUI()

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': data_m_s['auth0_user_id'],
                        'system_id': GV.STAFF_SYSTEM_ID,
                        'service_id': GV.STAFF_SERVICE_ID,
                        'company_code': GV.STAFF_COMPANY_CODE
                    }
                }
                data_aui = aui.get_data(params)
                print(data_aui)
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                #　スタッフの場合
                if data_aui is not None:
                    roles_new = data_aui['roles']

                    # システムのサポート用ロールがなければ追加
                    if GV.SYSTEM_NAME.lower() + '_' not in roles_new:
                        roles_new = re.sub( '\]', ', "'  + GV.SYSTEM_NAME.lower() + '_support"]',roles_new )

                    # サプライヤーのロールがなければ追加
                    if 'supplier_staff' not in roles_new:
                        roles_new = re.sub( '\]', ', "supplier_staff"]',roles_new )

                    # 空文字列なら消す
                    if '"",' in roles_new:
                        roles_new = re.sub( '"" *, *', '',roles_new )

                    # 空文字列なら消す
                    if '[,' in roles_new:
                        roles_new = re.sub( '\[ *, *', '[',roles_new )

                    data_aui['roles'] = roles_new
                    tmp_update_aui = m_aui._update(data_aui)
                else:
                    #　スタッフじゃない場合、Auth0にメタデータを追加
                    params_m_aui = {}
                    params_m_aui['auth0_user_id'] = data_m_s['auth0_user_id']
                    params_m_aui['company_code'] = '000000'
                    params_m_aui['system_id'] = 'SYS90001'
                    params_m_aui['service_id'] = 'SRV90001'
                    if GV.LOGGEDIN_USER_IS_SUPPLIER == True:
                        # サプライヤー
                        params_m_aui['roles'] = '["supplier_staff", "' + GV.SYSTEM_NAME.lower() + '_support"]'
                            
                    params_m_aui['blocked'] = False

                    tmp_m_aui = m_aui._update(params_m_aui)
            except Exception as e:
                print(e)
                raise
            # <-- 共通PF4 サプライヤーの場合、既存のアカウントに選択しているシステムのロールを追加 2024/03/04 nakamura.e
        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_staff import Sub as MS
        # m_s = MS()
        MS = GV.get_module('m_staff')
        m_s = MS()

        tmp_m_s = m_s._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_staff import Sub as MS
        # m_s = MS()
        MS = GV.get_module('m_staff')
        m_s = MS()
        # --> 共通PF4 サプライヤーの場合、システム名を持っているロールでフィルタ 2024/02/08 nakamura.e
        staff_del_flag = True
        try:
            AUI = GV.get_module('auth0_user_info')
            aui = AUI()

            params = {
                'table_name': 'm_auth0_user_info',
                'filters': {
                    'auth0_user_id': data['auth0_user_id'],
                    'system_id': GV.STAFF_SYSTEM_ID,
                    'service_id': GV.STAFF_SERVICE_ID,
                    'company_code': GV.STAFF_COMPANY_CODE
                }
            }
            data_aui = aui.get_data(params)
            print(data_aui)
            roles_new = data_aui['roles']
            # システムのサポート用ロールを消す
            for i in range(0,5):
                ##後ろに","がつく場合
                roles_new = re.sub( ' *"'  + GV.SYSTEM_NAME.lower() + '_[a-z]+" *, *','', roles_new )
                ##前に","がつく場合
                roles_new = re.sub( ' *, *"'  + GV.SYSTEM_NAME.lower() + '_[a-z]+"','', roles_new )

            #if "supplier_staff" in roles_new and "_support" not in roles_new:
            if re.search('\[ *"supplier_staff" *\]', roles_new):
                # サプライヤーのロールだけ残っていたら消す
                roles_new = re.sub('\[ *"supplier_staff" *\]','[""]', roles_new )
            elif re.search('\[ *"general_staff" *\]', roles_new):
                # 一般スタッフのロールだけ残っていたら消す
                roles_new = re.sub('\[ *"general_staff" *\]','[""]', roles_new )
            elif re.search('\[ *"admin_staff" *\]', roles_new):
                # 管理者スタッフのロールだけ残っていたら消す
                roles_new = re.sub('\[ *"admin_staff" *\]','[""]', roles_new )
            else:
                staff_del_flag = False

            data_aui['roles'] = roles_new
            MAUI = GV.get_module('m_auth0_user_info')
            m_aui = MAUI()
            tmp_update_aui = m_aui._update(data_aui)
        except Exception as e:
            print(e)
            raise

        if staff_del_flag == True:
            # スタッフの削除
            tmp_m_s = m_s._delete(data)
        # <-- 共通PF4 サプライヤーの場合、システム名を持っているロールでフィルタ 2024/02/08 nakamura.e
        return {}
    
    def reset_password(self, data):

        logger.debug('# ************0704******************') 
        params = {
            'table_name': 'm_auth0_management',
            'filters': {
                'tenant': GV.CONFIG['AUTH0_TENANT']
            }
        }
        data_m_am = self.get_data(params)
        logger.debug(data_m_am)

        if data_m_am:
            logger.debug('# ************Auth0情報を設定する******************')
            GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
            GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
            GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
            GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
            GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
            GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
            logger.debug(GV.CONFIG)
            pass
        else:
            return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
        logger.debug('# ************0704******************') 

        import uuid
        code = str(uuid.uuid4())

        logger.debug('# 認証コード生成')

        logger.debug('# ************0704******************') 
        code = 's-' + str(data_m_am['id']) + '-' + code
        logger.debug('# ************0704******************')

        logger.debug('# ******************************')
        logger.debug('# atuh0 update')
        
        app_metadata = {}
        app_metadata['data'] = []
        app_metadata['data'].append(
            {
                'staff_req_vefification_code': code,
                'staff_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
            }
        )

        data_auth0 = {}
        data_auth0['app_metadata'] = app_metadata

        logger.debug('# data_auth0')
        logger.debug(data_auth0)

        auth0_class = GV.get_module_auth0()
        a0 = auth0_class()

        a0._update(data['auth0_user_id'], data_auth0)
        
        logger.debug('# ##############################')

        logger.debug('# ******************************')
        logger.debug('# パスワードリセット メール送信')
        
        data_email = {}
        data_email['service_id'] = 'SRV90001'
        data_email['mail_type'] = 'スタッフ用パスワードリセット'
        data_email['email_address'] = data['email']

        data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
        data_email['login_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}'

        self.send_email_staff(data_email)

        logger.debug('# ##############################')

        return {}

    def send_email_staff(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_staff')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if 'email_address' in data:
                mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id']) 
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')