from .controller import Base, CustomException, GV, logging, os, and_, or_, datetime
import boto3
import csv
import json
import pandas as pd
import io
from io import StringIO
import numpy as np
import re
import psycopg2

logger = logging.getLogger(__name__)
# logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'send_mail'

    CSV_COL = [
       "メールID",
       "システムID",
       "サービスID",
       "サービス名",
       "メールの種類",
       "メールの送信TO",
       "メールの送信CC",
       "メールの送信BCC",
       "送信元",
       "件名",
       "本文"  
    ]

    def get_all(self, event, context):

        # from ..view.view_send_mail import Sub as VSM
        # v_sm = VSM()
        VSM = GV.get_module('view_send_mail')
        v_sm = VSM()

        return v_sm.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_send_mail import Sub as VSM
        # v_sm = VSM()
        VSM = GV.get_module('view_send_mail')
        v_sm = VSM()

        v_sm.table_config = self.table_name
        return v_sm.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_send_mail import Sub as MSM
        # m_sm = MSM()
        MSM = GV.get_module('m_send_mail')
        m_sm = MSM()
        
        tmp_m_sm = m_sm._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_send_mail import Sub as MSM
        # m_sm = MSM()
        MSM = GV.get_module('m_send_mail')
        m_sm = MSM()

        tmp_m_sm = m_sm._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_send_mail import Sub as MSM
        # m_sm = MSM()
        MSM = GV.get_module('m_send_mail')
        m_sm = MSM()

        tmp_m_sm = m_sm._delete(data)

        return {}
    
    def import_csv(self, data):
        print('import_csv-----------------')
        print(data)

        msg = ''
        records = []

        try:
            # CSV文字列をStringIOオブジェクトに変換
            csv_file = StringIO(data)
            reader = csv.reader(csv_file)

            csv_rows = list(reader)
            # 行数が2未満の場合はエラー
            if len(csv_rows) < 2:
                raise CustomException('MNBSI_CSV_ERR_100')
            # ヘッダー行やデータ行が空の場合もエラーを発生
            if any(row == [] for row in csv_rows[:2]):
                raise CustomException('MNBSI_CSV_ERR_100')

            # ヘッダーチェック
            if csv_rows[0] != self.CSV_COL:
                raise CustomException('MNBSI_CSV_ERR_101')

            # 各行をループ処理
            for i, row in enumerate(csv_rows[1:], start=1):
                # カラムの数がヘッダーの数と一致しない場合はエラーを発生
                if len(row) != len(self.CSV_COL):
                    raise CustomException('MNBSI_CSV_ERR_102')

                record = {}
                for j, c in enumerate(row):
                            if len(c) > 0 and c[0] == '"':
                                c = c[1:]
                            if len(c) > 0 and c[len(c) - 1] == '"':
                                c = c[0:len(c) - 1]
                            pass
                            
                            # メールID
                            if j == 0:
                                """
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'メールID'])
                                """
                                record['mail_id'] = c
                                
                            # システムID
                            elif j == 1:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'システムID'])
                                # record['system_id'] = c
                            # サービスID
                            elif j == 2:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'サービスID'])
                                record['service_id'] = c
                            # サービス名
                            elif j == 3:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'サービス名'])
                                # record['サービス名'] = c
                            # メールの種類
                            elif j == 4:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, 'メールの種類'])
                                record['mail_type'] = c
                            # メールの送信TO:
                            elif j == 5:
                                #if c.strip() == '':
                                #    raise CustomException('MNBSI_CSV_ERR_103', [i, 'メールの送TO'])
                                record['mail_to'] = c
                            # メールの送信CC
                            elif j == 6:
                                #if c.strip() == '':
                                #    raise CustomException('MNBSI_CSV_ERR_103', [i, 'メールの送信CC'])
                                record['mail_cc'] = c
                            # メールの送信BCC
                            elif j == 7:
                                #if c.strip() == '':
                                #    raise CustomException('MNBSI_CSV_ERR_103', [i, 'メールの送信BCC'])
                                record['mail_bcc'] = c
                            # 送信元
                            elif j == 8:
                                #if c.strip() == '':
                                #    raise CustomException('MNBSI_CSV_ERR_103', [i, '送信元'])
                                record['mail_send_from'] = c
                        
                            # 件名
                            elif j == 9:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '件名'])
                                record['mail_subject'] = c
                            # 本文
                            elif j == 10:
                                if c.strip() == '':
                                    raise CustomException('MNBSI_CSV_ERR_103', [i, '本文'])
                                record['mail_body'] = c

                records.append(record)

            print('*******************************')
            msg = self.bulk_insert(records)
            print('-------------------------------')

            res = {'message': msg}
            return res

        except Exception as e:
            print(e)
            raise

    def bulk_insert(self, records):
        print('bulk_insert -------------------------------')
        print('bulk_insert -------------------------------start')
        print(datetime.now())
        
        # ・処理終了時に新規追加件数と更新件数をメッセージ表示する。
        cnt_ins = []
        cnt_upd = []
        
        arr_contract_id = []
        
        temp_msg_top = ''

        VSM = GV.get_module('view_send_mail')
        v_sm = VSM()
        
        MSM = GV.get_module('m_send_mail')
        m_sm = MSM()
        
        #VMNBSI = GV.get_module('view_new_biz_sys_info')
        #v_m_nbsi = VMNBSI()

        #MNBSI = GV.get_module('m_new_biz_sys_info')
        #m_nbsi = MNBSI()
        
        for i, r in enumerate(records):
            
            arr_contract_id.append(r['mail_id'])
            print('arr_contract_id',arr_contract_id)
            
            temp_msg_top = '連携ファイル取り込みCSVのデータの' + str(i + 1) + '行目'
            
            # myapp.methods.check_input.check_new_biz_sys_info_bulk(record);
            
            # // 案件番号(契約ID+"YYYY")
            """
            filters = []
            filters.append(v_sm.model_class.mail_id == r['mail_id'])
            filters = and_(*filters)
            tmp_ci = v_sm._get_item_by_filters(filters)
            if tmp_ci is None:
                raise CustomException('MNBSI_CSV_ERR_104', r['mail_id'])
            
            # 企業コードセット
            r['system_id'] = tmp_ci.system_id
            
            pass
        
            # Inputファイルの取引先コード、案件番号(契約ID+"YYYY")に、
            # 企業情報管理アプリに存在しない取引先コード、契約IDが含まれる場合はエラー表示
            # 取引先コード
            filters = []
            filters.append(v_sm.model_class.system_id == tmp_ci.system_id)
            filters.append(v_sm.model_class.new_biz_sys_company_id == r['system_id'])
            filters = and_(*filters)
            tmp_ci = v_sm._get_item_by_filters(filters)
            if tmp_ci is None:
                raise CustomException('MNBSI_CSV_ERR_105', r['system_id'])
            
            pass
            """
        
            #   // ・同じ契約ID、プロジェクト種類のレコードがすでにある場合は
            #   // 　そのレコードの契約番号、契約開始日、契約終了日、PJコードを上書きする。
            #   // 　無い場合は新規登録。
            #   // ・契約IDは「案件番号」から取得する。
            #   // ・新規登録時は契約IDから企業コード、プロジェクト種類から売上区分IDを取得する。
            # v_sm = VSM()
            filters = []
            filters.append(m_sm.model_class.mail_id == r['mail_id'])
            filters = and_(*filters)
            tmp_m_sm= m_sm._get_item_by_filters(filters)
                      
            if tmp_m_sm:
                
                r['mail_id'] = tmp_m_sm.mail_id
                
                tmp = m_sm._update(r)
                r = tmp.to_dict()

                # 更新件数
                if r['mail_id'] not in cnt_upd:
                    cnt_upd.append(r['mail_id'])
                                
                pass
            else:

                tmp = m_sm._add(r)
                r = tmp.to_dict()
                
                # 新規追加件数
                if r['mail_id'] not in cnt_ins:
                    cnt_ins.append(r['mail_id'])
                    
                pass
            
            pass
        
        #   // 一括取り込み成功後
        #   // 同じ契約IDで契約番号、プロジェクト種類、PJコード等が空の場合はレコードを削除
        for c_id in arr_contract_id:

            filters = []
            filters.append(v_sm.model_class.mail_id == c_id)
 
            filters = and_(*filters)
            tmp_v_sm = v_sm._get_item_by_filters(filters)
            """
            if tmp_v_sm:

                m_sm._delete(tmp_v_sm.to_dict())
            """
        
        pass
    
        # # // ・処理終了時に新規追加件数と更新件数をメッセージ表示する。
        # msg = '連携ファイル取り込み処理が完了しました。'
        # msg += '新規追加件数：' + str(len(cnt_ins))
        # msg += '更新件数：' + str(len(cnt_upd))
        msg = {
            'cnt_ins': cnt_ins,
            'cnt_upd': cnt_upd
        }
        
        print(datetime.now())
        print('bulk_insert -------------------------------end')
        
        return msg