from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime
from pprint import pprint
from sqlalchemy import extract

import re

logger = logging.getLogger(__name__)

logger.setLevel(logging.DEBUG)


class Sub(Base):

    table_name = 'ma_contract'

    def get_all(self, event, context):

        # from ..view.view_ma_contract import Sub as VT
        # v_t = VT()
        VT = GV.get_module('view_ma_contract')
        v_t = VT()

        return v_t.get_all(event, context)

        pass

    def get_table_schema(self):

        # from ..view.view_ma_contract import Sub as VT
        # v_t = VT()
        VT = GV.get_module('view_ma_contract')
        v_t = VT()

        v_t.table_config = self.table_name
        return v_t.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        print("||||||||||||add||||||||||||||")
        try:

            if GV.EVENT_BODY is None:
                raise CustomException('SYS_ERR_100')
                
            logger.debug('# ************0704******************') 
            params = {
                'table_name': 'm_auth0_management',
                'filters': {
                    'tenant': GV.CONFIG['AUTH0_TENANT']
                }
            }
            data_m_am = self.get_data(params)
            logger.debug(data_m_am)

            if data_m_am:
                logger.debug('# ************Auth0情報を設定する******************')
                GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                logger.debug(GV.CONFIG)
                pass
            else:
                return {"error": "tenant:" + GV.CONFIG['AUTH0_TENANT'] + " は存在しないので、システム者にご連絡ください。"}
            logger.debug('# ************0704******************') 

            data = GV.EVENT_BODY

            is_not_request_user = False

            logger.debug('# ******************************')

            data_t_trh = None

            if '# データを検証する。':

                logger.debug('# データを検証する。')

                data_t_trh = {}
                data_t_trh = data.copy()
                data_t_trh['ma_contract_req_id'] = None
                data_t_trh['system_id'] = GV.SYSTEM_ID
                data_t_trh['service_id'] = GV.SERVICE_ID
                data_t_trh['ma_contract_manage_id'] = None
                data_t_trh['company_code'] = None
                data_t_trh['ma_contract_start_date'] = None
                data_t_trh['ma_contract_end_date'] = None
                data_t_trh['cdate'] = None
                data_t_trh['udate'] = None
                logger.debug('# **************0702****S************')
                data_t_trh['tenant'] = GV.CONFIG['AUTH0_TENANT']
                logger.debug('# **************0702****E************')

                # print("||||||||data_t_trh|||||||||")
                # print(data_t_trh)

                res_validate = self.validate(
                    't_ma_contract_request_history', data_t_trh)
                if res_validate != True:
                    return res_validate

            logger.debug('# ##############################')

            auth0_user = None

            if GV.LOGGEDIN_USER and GV.URL_PATH_TABLE_NAME != 'ma_contract':
                logger.debug('# アカウントがあり、ログインした場合')
                pass
            else:
                logger.debug('# ログインしてない場合')

                logger.debug('# ******************************')
                logger.debug('# 申込のメールアドレスのAuth0アカウントが存在するかどうかチェックする')

                # from ..auth0 import Sub as auth0_class
                # auth0 = auth0_class()
                auth0_class = GV.get_module_auth0()
                a0 = auth0_class()

                users = a0._get_users_by_email(data['email_address'])

                if users and len(users) > 0:
                    # 存在する場合

                    auth0_user = users[0]

                    logger.debug('存在する場合')
                    if auth0_user['email_verified']:

                        is_not_request_user = True

                        pass
                    else:
                        # メールアドレス未検証の場合
                        # 検証メールを再送信する
                        # ???
                        logger.debug('# メールアドレス未検証の場合')
                        logger.debug('# 検証メールを再送信する')

                        code = None
                        if 'app_metadata' in auth0_user:
                            if 'ma_contract_req_vefification_code' in auth0_user['app_metadata']:
                                code = auth0_user['app_metadata']['ma_contract_req_vefification_code']

                        if code is not None:
                            logger.debug('# 保守契約企業利用申込情報がある場合')

                            logger.debug('# ******************************')
                            logger.debug('# 保守契約企業利用申込完了連絡 メール送信')
                            
                            data_email = {}
                            data_email['service_id'] = GV.SERVICE_ID
                            data_email['mail_type'] = '保守契約企業本人認証とパスワード設定'
                            data_email['email_address'] = data['email_address']
                            data_email['company_name'] = data['company_name']
                            data_email['last_name'] = data['last_name']
                            data_email['first_name'] = data['first_name']
                            data_email['free_usage_count_upper_limit'] = data['available_date']
                            data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                            data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                            self.send_email_ma_contract(data_email)
                            
                            logger.debug('# ##############################')

                            return {}

                        pass
                else:
                    # 存在しない場合
                    # 処理継続
                    logger.debug('# 存在しない場合')
                    logger.debug('# 処理継続')

                    pass

                pass

                logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」からデータ検索':

                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['email_address']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            logger.debug('# ・上記以外：申込完了画面を表示する。本人認証へ進む。')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル【保守契約企業利用申込情報履歴】にデータ登録する':

                logger.debug('# テーブル【保守契約企業利用申込情報履歴】にデータ登録する')
                logger.debug('# t_ma_contract_request_history')

                # from ..model.t_ma_contract_request_history import Sub as TTRH
                # t_trh = TTRH()
                TTRH = GV.get_module('t_ma_contract_request_history')
                t_trh = TTRH()

                tmp_t_trh = t_trh._add(data_t_trh)

                if tmp_t_trh:
                    logger.debug(tmp_t_trh)
                    pass
                else:
                    raise CustomException('SYS_ERR_100')
                    pass

            logger.debug('# ##############################')

            
            if is_not_request_user:
                # print("|||||is_not_request_user||||")

                data_tr = {}
                data_tr['auth0_user_id'] = auth0_user['user_id']
                data_tr['ma_contract_req_id'] = tmp_t_trh.ma_contract_req_id
                res = self.regist_ma_contract_data(data_tr)

                pass

            elif GV.LOGGEDIN_USER and GV.URL_PATH_TABLE_NAME != 'ma_contract':
                # print("|||||LOGGEDIN_USER||||")

                data_tr = {}
                data_tr['auth0_user_id'] = GV.LOGGEDIN_USER['sub']
                data_tr['ma_contract_req_id'] = tmp_t_trh.ma_contract_req_id
                res = self.regist_ma_contract_data(data_tr)

                pass
            else:
                import uuid
                code = str(uuid.uuid4())

                logger.debug('# 認証コード生成')
                
                logger.debug('# ************0704******************') 
                code = 'm-' + str(data_m_am['id']) + '-' + code
                logger.debug('# ************0704******************')

                # app_metadata = {
                #     'service_path': GV.SERVICE_PATH,
                #     'ma_contract_req_id': tmp_t_trh.ma_contract_req_id,
                #     'ma_contract_req_vefification_code': code,
                #     'ma_contract_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                # }
                
                if auth0_user is not None:
                    logger.debug('# Auth0アカウントがある場合')

                    # data_auth0 = {}
                    # data_auth0['app_metadata'] = app_metadata

                    # logger.debug('# data_auth0')
                    # logger.debug(data_auth0)

                    app_metadata = {}

                    if 'app_metadata' in auth0_user:

                        logger.debug(auth0_user['app_metadata'])

                        app_metadata = auth0_user['app_metadata']

                    if 'data' not in app_metadata:
                        app_metadata['data'] = []
                    
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'ma_contract_req_id': tmp_t_trh.ma_contract_req_id,
                            'ma_contract_req_vefification_code': code,
                            'ma_contract_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )

                    data_auth0 = {}
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# ******************************')
                    logger.debug('# atuh0 update')
                    a0._update(auth0_user['user_id'], data_auth0)
                    logger.debug('# ##############################')

                    pass
                else:
                    logger.debug('# Auth0アカウントがない場合')

                    app_metadata = {}
                    app_metadata['data'] = []
                    app_metadata['data'].append(
                        {
                            'service_path': GV.SERVICE_PATH,
                            'ma_contract_req_id': tmp_t_trh.ma_contract_req_id,
                            'ma_contract_req_vefification_code': code,
                            'ma_contract_req_date': datetime.now().strftime('%Y-%m-%d %H:%M:%S.%f')
                        }
                    )
                    
                    data_auth0 = {}
                    data_auth0['email_address'] = data['email_address']
                    data_auth0['app_metadata'] = app_metadata

                    logger.debug('# data_auth0')
                    logger.debug(data_auth0)

                    logger.debug('# ******************************')
                    logger.debug('# create_data_atuh0')
                    self.create_data_atuh0(data_auth0)
                    logger.debug('# ##############################')

                logger.debug('# ******************************')
                logger.debug('# 保守契約企業利用申込完了連絡 メール送信')

                data_email = {}
                data_email['service_id'] = GV.SERVICE_ID
                data_email['mail_type'] = '保守契約企業本人認証とパスワード設定'
                data_email['email_address'] = data['email_address']
                data_email['company_name'] = data['company_name']
                data_email['last_name'] = data['last_name']
                data_email['first_name'] = data['first_name']
                data_email['free_usage_count_upper_limit'] = data['available_date']
                data_email['regist_url'] = f'{GV.URL_CLOUD_SERVICE_PORTAL}verification?code={code}'
                data_email['cloud_service_entry_portal_url'] = GV.URL_CLOUD_SERVICE_ENTRY_PORTAL

                self.send_email_ma_contract(data_email)
                
                logger.debug('# ##############################')

                pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass

    def regist_ma_contract_data(self, data):
        try:
            logger.debug(data)
            res = {}

            logger.debug('# ******************************')

            data_t_trh = None

            if '# テーブル「保守契約企業利用申込履歴」からデータ取得':

                logger.debug('# テーブル「保守契約企業利用申込履歴」からデータ取得')
                logger.debug('# t_ma_contract_request_history')

                params = {
                    'table_name': 't_ma_contract_request_history',
                    'filters': {
                        'ma_contract_req_id': data['ma_contract_req_id']
                    }
                }
                data_t_trh = self.get_data(params)

                if data_t_trh is None:
                    raise CustomException('SYS_ERR_100')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_tes = None

            if '# 「保守契約企業利用環境ストックマスタ」からデータ取得':

                logger.debug('# 「保守契約企業利用環境ストックマスタ」からデータ取得')
                logger.debug('# m_ma_contract_env_stock')
                
                data_m_tes = {'ma_contract_env_stock_id': None, 'ma_contract_company_code': GV.MA_CONTRACT_COMPANY_CODE, 'system_id': GV.SYSTEM_ID, 'service_id': GV.SERVICE_ID, 'use_flg': False}


            logger.debug('# ******************************')

            data_t_mr = None

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

            logger.debug('# ##############################')

            data_t_trc = None

            param_t_trc = {}

            logger.debug('# 履歴のデータをコピー')
            param_t_trc = data_t_trh.copy()

            logger.debug('# ******************************')

            if '# テーブル「保守契約企業利用申込情報（確認済み）」からデータ登録':

                logger.debug('# テーブル「保守契約企業利用申込情報（確認済み）」からデータ登録')
                logger.debug('# t_ma_contract_request_confirmed')

                logger.debug('# 「企業コード」をセットする')
                if data_t_mr is not None:
                    param_t_trc['company_code'] = data_t_mr['company_code']
                elif data_m_tes is not None:
                    param_t_trc['company_code'] = data_m_tes['ma_contract_company_code']

                logger.debug('# 「保守契約企業利用環境ストックID」をセットする')
                if data_m_tes is not None:
                    param_t_trc['ma_contract_env_stock_id'] = data_m_tes['ma_contract_env_stock_id']

                logger.debug('# 「保守契約企業利用開始日」をセットする')
                # param_t_trc['ma_contract_start_date'] = self.NOW
                param_t_trc['ma_contract_start_date'] = None

                logger.debug('# 「保守契約企業利用終了日」をセットする')
                logger.debug('# 24h')
                # param_t_trc['ma_contract_end_date'] = self.NOW + timedelta(hours=24)
                param_t_trc['ma_contract_end_date'] = None
                
                # logger.debug('# 「利用可能上限回数」をセットする')
                # param_t_trc['available_date'] = data_m_tes['ma_contract_env_stock_id']
                
                logger.debug('# 「今月利用した回数」をセットする')
                # VT = GV.get_module('view_ma_contract')
                # v_t = VT()
    
                # filters = []
                # filters.append(v_t.model_class.system_id == GV.SYSTEM_ID)
                # filters.append(v_t.model_class.service_id == GV.SERVICE_ID)
                # # filters.append(v_t.model_class.ma_contract_start_date >
                # #               datetime.now().strftime("%Y-%m"))
                # filters.append(extract('year', v_t.model_class.ma_contract_start_date) == datetime.now().year)
                # filters.append(extract('month', v_t.model_class.ma_contract_start_date) == datetime.now().month)
                # filters = and_(*filters)
    
                # tmp_v_t = v_t._get_item_by_filters(filters, get_all=True)

                # param_t_trc['count'] = len(tmp_v_t) + 1
                # print("|||||||")
                # print(tmp_v_t)
                param_t_trc['count'] = 0

                # from ..model.t_ma_contract_request_confirmed import Sub as TTRC
                # t_trc = TTRC()
                TTRC = GV.get_module('t_ma_contract_request_confirmed')
                t_trc = TTRC()

                logger.debug('# データ登録')
                tmp_t_trc = t_trc._add(param_t_trc)

                if tmp_t_trc is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録失敗')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録成功')

                data_t_trc = tmp_t_trc.to_dict()
                logger.debug(data_t_trc)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】':

                logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録 【申込ユーザー】')
                logger.debug('# m_auth_user_info')

                # from ..model.m_auth0_user_info import Sub as MAUI
                # m_aui = MAUI()
                MAUI = GV.get_module('m_auth0_user_info')
                m_aui = MAUI()

                param_m_aui = {}
                # # Auth0ユーザー情報管理ID
                # param_m_aui['auth_user_info_id'] = ''
                logger.debug('# **************0702****S************')
                # テナント
                param_m_aui['tenant'] = GV.CONFIG['AUTH0_TENANT']
                logger.debug('# **************0702****E************')
                # Auth0ユーザーID
                param_m_aui['auth0_user_id'] = data['auth0_user_id']
                # ログイン先企業コード
                if data_m_tes is not None:
                    param_m_aui['company_code'] = data_m_tes['ma_contract_company_code']
                # ログイン先システムID
                param_m_aui['system_id'] = GV.REQUEST_USER_SYSTEM_ID
                # ログイン先サービスID
                param_m_aui['service_id'] = GV.REQUEST_USER_SERVICE_ID

                logger.debug('# ワークショップ申し込みする際、metadataにはアプリ環境情報はセットしない。')
                # 付与ロールのリスト
                param_m_aui['roles'] = [GV.ROLES_REQUEST_USER]
                # # 作成日時
                # param_m_aui['cdate'] = ''
                # # 更新日時
                # param_m_aui['udate'] = ''

                params = {
                    'table_name': 'm_auth0_user_info',
                    'filters': {
                        'auth0_user_id': param_m_aui['auth0_user_id'],
                        'company_code': param_m_aui['company_code'],
                        'system_id': param_m_aui['system_id'],
                        'service_id': param_m_aui['service_id']
                    }
                }
                data_m_aui = self.get_data(params)
                logger.debug(data_m_aui)

                tmp_m_aui = None

                if data_m_aui:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                    param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                    tmp_m_aui = m_aui._update(param_m_aui)
                    pass
                else:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                    tmp_m_aui = m_aui._add(param_m_aui)
                    pass

                if tmp_m_aui is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ登録NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ登録OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            data_m_sys = None

            if '# テーブル「システムマスタ」からデータ取得':

                logger.debug('# テーブル「システムマスタ」からデータ取得')
                logger.debug('# m_systems')

                params = {
                    'table_name': 'm_systems',
                    'filters': {
                        'system_id': GV.SYSTEM_ID
                    }
                }

                data_m_sys = self.get_data(params)

                if data_m_sys is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# データ取得NGの場合')
                    raise CustomException('SYS_ERR_100')

                logger.debug('# データ取得OKの場合')

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「Auth0ユーザー情報管理」にデータ登録':

                if data_m_tes is None:
                    logger.debug(
                        '# 保守契約企業利用環境のユーザーの割り当てができていないので「保守契約企業利用用」のメタデータは登録しません。')
                    pass

                else:

                    logger.debug('# テーブル「Auth0ユーザー情報管理」にデータ登録')
                    logger.debug('# m_auth_user_info')

                    # from ..model.m_auth0_user_info import Sub as MAUI
                    # m_aui = MAUI()
                    MAUI = GV.get_module('m_auth0_user_info')
                    m_aui = MAUI()

                    param_m_aui = {}
                    # # Auth0ユーザー情報管理ID
                    # param_m_aui['auth_user_info_id'] = ''
                    logger.debug('# **************0702****S************')
                    # テナント
                    param_m_aui['tenant'] = GV.CONFIG['AUTH0_TENANT']
                    logger.debug('# **************0702****E************')
                    # Auth0ユーザーID
                    param_m_aui['auth0_user_id'] = data['auth0_user_id']
                    # ログイン先企業コード
                    param_m_aui['company_code'] = data_m_tes['ma_contract_company_code']
                    # ログイン先システムID
                    param_m_aui['system_id'] = data_m_tes['system_id']
                    # ログイン先サービスID
                    param_m_aui['service_id'] = data_m_tes['service_id']
                    # activedirectory_username、appstream_stacknameはログイン時に割り振るので、登録時は空です
                    # activedirectory_username
                    # 000001.user001@simulation.space
                    param_m_aui['activedirectory_username'] = None
                    # appstream_stackname
                    # SYS00001-SRV00001-appstream-stack-activedirectory-000001
                    param_m_aui['appstream_stackname'] = None
                    # 付与ロールのリスト
                    param_m_aui['roles'] = [GV.ROLES_MA_CONTRACT_USER]
                    # # 作成日時
                    # param_m_aui['cdate'] = ''
                    # # 更新日時
                    # param_m_aui['udate'] = ''

                    params = {
                        'table_name': 'm_auth0_user_info',
                        'filters': {
                            'auth0_user_id': param_m_aui['auth0_user_id'],
                            'company_code': param_m_aui['company_code'],
                            'system_id': param_m_aui['system_id'],
                            'service_id': param_m_aui['service_id']
                        }
                    }
                    data_m_aui = self.get_data(params)
                    logger.debug(data_m_aui)

                    tmp_m_aui = None

                    if data_m_aui:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                        param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                        tmp_m_aui = m_aui._update(param_m_aui)
                        pass
                    else:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                        tmp_m_aui = m_aui._add(param_m_aui)
                        pass

                    if tmp_m_aui is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# データ登録NGの場合')
                        raise CustomException('SYS_ERR_100')

                    logger.debug('# データ登録OKの場合')
            
            logger.debug('# ##############################')
            
            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                logger.debug('# m_user')

                params = {
                    'table_name': 'm_user',
                    'filters': {
                        'company_code': 'NONE',
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_m_u = self.get_data(params)

                if data_m_u is not None:
                    logger.debug('# 存在する場合、どうする？')

                    logger.debug('# データ更新')

                    MU = GV.get_module('m_user')
                    m_u = MU()

                    # 企業コード
                    data_m_u['company_code'] = data_m_tes['ma_contract_company_code']
                    # 名前(姓)
                    data_m_u['name_last'] = data_t_trc['last_name']
                    # 名前(名)
                    data_m_u['name_first'] = data_t_trc['first_name']

                    tmp_m_u = m_u._update(data_m_u)

                    if tmp_m_u:
                        logger.debug(tmp_m_u.to_dict())
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            if '# テーブル「ユーザーマスタ」にデータ登録':

                if data_m_tes is None:
                    logger.debug(
                        '# 保守契約企業利用環境のユーザーの割り当てができていないので「保守契約企業利用用」のメタデータは登録しません。')
                    pass

                else:

                    logger.debug('# テーブル「ユーザーマスタ」にデータ登録')
                    logger.debug('# m_user')

                    params = {
                        'table_name': 'm_user',
                        'filters': {
                            'auth0_user_id': data['auth0_user_id'],
                            'company_code': data_m_tes['ma_contract_company_code']
                        }
                    }
                    data_m_u = self.get_data(params)

                    if data_m_u:
                        logger.debug('# 存在する場合、どうする？')
                        logger.debug('# ???')
                        pass
                    else:
                        logger.debug('# 存在しない場合、データを登録')

                        # from ..model.m_user import Sub as MU
                        # m_u = MU()
                        MU = GV.get_module('m_user')
                        m_u = MU()

                        param_m_u = {}
                        # Auth0ユーザーID
                        param_m_u['auth0_user_id'] = data['auth0_user_id']
                        # 企業コード
                        param_m_u['company_code'] = data_m_tes['ma_contract_company_code']
                        # 名前
                        param_m_u['name_last'] = data_t_trc['last_name']
                        # 名前(姓)
                        param_m_u['name_first'] = data_t_trc['first_name']
                        # 名前(名)
                        param_m_u['name_last_kana'] = ''
                        # 名前(カナ)(姓)
                        param_m_u['name_first_kana'] = ''
                        # 部署名(カナ)(名)
                        param_m_u['department'] = ''
                        # 役職
                        param_m_u['position'] = ''
                        # メールアドレス
                        param_m_u['email'] = data_t_trc['email_address']
                        # # 電話番号
                        # param_m_u['tel'] = ''
                        # # 招待コード
                        # param_m_u['invitation_code'] = ''
                        # # 招待日時
                        # param_m_u['invitation_date'] = ''

                        logger.debug('# データ登録')
                        tmp_m_u = m_u._add(param_m_u)

                        if tmp_m_u:
                            logger.debug(tmp_m_u.to_dict())
                            pass
                        else:
                            raise CustomException('SYS_ERR_100')
                            pass

            logger.debug('# ##############################')

            if '# テーブル「申込管理情報」にデータ登録':

                logger.debug('# テーブル「申込管理情報」にデータ登録')
                logger.debug('# t_manage_request')

                # from ..model.t_manage_request import Sub as TMR
                # t_mr = TMR()
                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()

                logger.debug('# 同じ「Auth0ユーザーID」のデータが登録されているかどうか確認')
                logger.debug('# 検索条件「システムID」、「サービスID」、「Auth0ユーザーID」')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': GV.SYSTEM_ID,
                        'service_id': GV.SERVICE_ID,
                        'auth0_user_id': data['auth0_user_id']
                    }
                }
                data_t_mr = self.get_data(params)

                if data_t_mr:
                    logger.debug('# 存在する場合、どうする？')
                    logger.debug('# ???')

                    # 保守契約企業利用申込ID
                    data_t_mr['ma_contract_req_id'] = data['ma_contract_req_id']
                    # # 企業コード
                    # if data_m_tes is not None:
                    #     data_t_mr['company_code'] = data_m_tes['ma_contract_company_code']
                    # ステータス
                    if data_m_tes is not None:
                        data_t_mr['status'] = GV.STATUS['保守契約企業利用中']
                    else:
                        data_t_mr['status'] = GV.STATUS['保守契約企業利用キャンセル']

                    logger.debug('# データ更新')
                    tmp_t_mr_1 = t_mr._update(data_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

                    pass
                else:
                    logger.debug('# 存在しない場合、データを登録')

                    param_t_mr = {}
                    # # 申込管理ID
                    # param_t_mr['manage_req_id'] =
                    # 企業コード
                    if data_m_tes is not None:
                        param_t_mr['company_code'] = data_m_tes['ma_contract_company_code']
                    # システムID
                    param_t_mr['system_id'] = GV.SYSTEM_ID
                    # サービスID
                    param_t_mr['service_id'] = GV.SERVICE_ID
                    # # 契約ID
                    # param_t_mr['contract_id'] =
                    # Auth0ユーザーID
                    param_t_mr['auth0_user_id'] = data['auth0_user_id']
                    # # 資料請求ID
                    # param_t_mr['document_req_id'] =
                    # # 保守契約企業利用環境ストックID
                    # param_t_mr['ma_contract_env_stock_id'] = ma_contract_env_stock_id
                    # 保守契約企業利用申込ID
                    param_t_mr['ma_contract_req_id'] = data['ma_contract_req_id']
                    # # ワークショップ申込ID
                    # param_t_mr['workshop_req_id'] =
                    # # 本契約申込ID
                    # param_t_mr['contract_req_id'] =
                    # # 担当営業コード
                    # param_t_mr['salesman_code'] =
                    if data_m_tes is not None:
                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                        param_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                        # ステータス
                        param_t_mr['status'] = GV.STATUS['保守契約企業利用可能']
                    else:
                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「使用不可(申込情報の変更が将来的には使用可能):0」にする')
                        param_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']
                        # ステータス
                        param_t_mr['status'] = GV.STATUS['保守契約企業利用キャンセル']
                    # # 作成日時
                    # param_t_mr['cdate'] =
                    # # 更新日時
                    # param_t_mr['udate'] =

                    logger.debug('# データ登録')
                    tmp_t_mr_1 = t_mr._add(param_t_mr)

                    if tmp_t_mr_1:
                        data_t_mr_1 = tmp_t_mr_1.to_dict()
                        logger.debug(data_t_mr_1)
                        pass
                    else:
                        raise CustomException('SYS_ERR_100')
                        pass

            logger.debug('# ##############################')

            logger.debug('# 申込成功 保守契約企業申込受付 メール送信')

            data_email = {}
            data_email['service_id'] = GV.SERVICE_ID
            data_email['mail_type'] = '保守契約企業申込受付'
            data_email['email_address'] = data_t_trc['email_address']
            data_email['company_name'] = data_t_trc['company_name']
            data_email['last_name'] = data_t_trc['last_name']
            data_email['first_name'] = data_t_trc['first_name']
            data_email['free_usage_count_upper_limit'] = data_t_trc['available_date']
            data_email['telephone_number'] = data_t_trc['telephone_number']
            data_email['login_url'] = GV.URL_LOGIN_SIMSP

            self.send_email_ma_contract(data_email)

            pass

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {
            'statusCode': 200,
            'body': 'OK'
        }
        pass

    def send_email_ma_contract(self, data, is_append_to=True):
        logger.debug('# ******************************')
        logger.debug('# send_email_ma_contract')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if is_append_to == True:
                if 'email_address' in data:
                    mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id']) 
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}
            
            # ???
            result = self.send_email(mail_template, mail_parameter)
           
            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

    def terminate_ma_contract(self):
        logger.debug('# terminate_ma_contract')
        try:

            logger.debug('# ******************************')
            logger.debug('# テーブル「保守契約企業利用申込情報（確認済み）」からデータ検索')
            logger.debug('''# 定期実行処理で保守契約企業利用の期間が過ぎているかチェックを行い、処理する''')
            logger.debug('# 「ma_contract_start_date」からconfigで指定した時間超えたデータを検索する')

            TTRC = GV.get_module('t_ma_contract_request_confirmed')
            t_trc = TTRC()

            VT = GV.get_module('view_ma_contract')
            v_t = VT()
            
            end_hour, end_minute, end_second = 0, 0, 0
            if ':' in GV.MACONTRACT_END_TIME:
                end_hour, end_minute = map(int, GV.MACONTRACT_END_TIME.split(':'))
            
            current_datetime = datetime.now()
            end_of_day = current_datetime.replace(hour=end_hour, minute=end_minute, second=end_second, microsecond=0)
            
            # print(end_of_day)

            filters = []
            filters.append(v_t.model_class.ma_contract_env_stock_id.is_not(None))
            filters.append(v_t.model_class.ma_contract_start_date < end_of_day )
            # filters.append(v_t.model_class.ma_contract_start_date >
            #                datetime.now() + timedelta(hours=-2))
            #  + GV.MACONTRACT_END_TIME
            filters = and_(*filters)

            tmp_v_t = v_t._get_item_by_filters(filters, get_all=True)

            if tmp_v_t is None or len(tmp_v_t) == 0:
                logger.debug('# 存在しない場合、なにもしない')
                return {}
                pass

            logger.debug('''# 保守契約企業利用環境のユーザの割り当ての解除。
                            お客様のAuth0アカウントのメタデータを更新して保守契約企業利用環境を利用不可能にする。
                            アプリ側のユーザ環境の初期化依頼メール送信。
                            保守契約企業利用の終了日を設定。''')

            for t in tmp_v_t:
                d = t.to_dict()
                logger.debug(d)

                logger.debug('# ******************************')

                logger.debug('# 保守契約企業利用環境のユーザの割り当ての解除。')

                ma_contract_env_stock_id = d['ma_contract_env_stock_id']

                if '# テーブル「申込管理情報」からデータ検索':

                    logger.debug('# テーブル「申込管理情報」からデータ検索')
                    logger.debug('# t_manage_request')

                    params = {
                        'table_name': 't_manage_request',
                        'filters': {
                            'system_id': d['system_id'],
                            'service_id': d['service_id'],
                            'auth0_user_id': d['email_address'],
                            'ma_contract_req_id': d['ma_contract_req_id']
                        }
                    }
                    data_t_mr = self.get_data(params)

                    if data_t_mr is not None:
                        if data_t_mr['status'] == GV.STATUS['保守契約企業利用中'] or data_t_mr['status'] == GV.STATUS['保守契約企業利用可能']:
                            if int(d['available_date']) > int(d['count']):
                                data_t_mr['status'] = GV.STATUS['保守契約企業利用可能']
                                # システム利用可能フラグ
                                logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                                data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                            else:
                                data_t_mr['status'] = GV.STATUS['保守契約企業利用終了']
                                # システム利用終了フラグ
                                logger.debug('# 使用不可(申込情報の変更が将来的には使用可能) 0する')
                                data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['使用不可(申込情報の変更が将来的には使用可能)']

                            # from ..model.t_manage_request import Sub as TMR
                            # t_mr = TMR()
                            TMR = GV.get_module('t_manage_request')
                            t_mr = TMR()

                            tmp_t_mr = t_mr._update(data_t_mr)

                            if tmp_t_mr:
                                data_t_mr = tmp_t_mr.to_dict()
                                logger.debug(data_t_mr)
                                pass

                logger.debug('# ##############################')

                logger.debug('# ******************************')

                logger.debug('# 保守契約企業利用の終了日を設定。')
                
                # # 年を取得する
                # str_year = extract('year', d['ma_contract_start_date'])
                
                # # 月を取得する
                # str_month = extract('month', d['ma_contract_start_date'])
                
                # # 日を取得する
                # str_day = extract('day', d['ma_contract_start_date'])
                # print("|||||||||||")
                # print(d['ma_contract_start_date'])
                # 日期
                date_part = d['ma_contract_start_date'].split('T')[0]
                
                # 拼接时间部分
                combined_datetime_str = f"{date_part} 23:59"
                
                # 将组合字符串转换为日期时间对象
                combined_datetime = datetime.strptime(combined_datetime_str, "%Y-%m-%d %H:%M")

                d['ma_contract_end_date'] = combined_datetime

                logger.debug('# 保守契約企業利用環境ストックIDを空欄にする(ユーザ割り当てを解除)')
                d['ma_contract_env_stock_id'] = None

                t_trc._update(d)
                
                logger.debug('# ************0807******************')

                logger.debug('# ##############################')
                
                # 保守契約利用日の終了時の定期実行でレコードの削除、Auth0のメタデータの削除が必要
                if '# 保守契約利用日の終了時の定期実行でレコードの削除、Auth0のメタデータの削除が必要':

                    logger.debug('# 保守契約利用日の終了時の定期実行でレコードの削除、Auth0のメタデータの削除が必要')
                    
                    if "tenant" in d:
                        params = {
                            'table_name': 'm_auth0_management',
                            'filters': {
                                'tenant': d['tenant']
                            }
                        }
                        data_m_am = self.get_data(params)
                        logger.debug(data_m_am)
            
                        if data_m_am:
                            logger.debug('# ************Auth0情報を設定する******************')
                            GV.CONFIG['AUTH0_AUDIENCE'] = data_m_am['management_api_audience']
                            GV.CONFIG['AUTH0_CLIENT_ID'] = data_m_am['api_clientid']
                            GV.CONFIG['AUTH0_CLIENT_SECRET'] = data_m_am['api_client_secret']
                            GV.CONFIG['AUTH0_DOMAIN'] = data_m_am['domain']
                            GV.CONFIG['API_AUDIENCE'] = data_m_am['api_audience']
                            GV.CONFIG['AUTH0_TENANT'] = data_m_am['tenant']
                            logger.debug(GV.CONFIG)
                            pass
                        else:
                            return {"error": "tenant:" + GV.EVENT_BODY["tenant"] + " は存在しないので、システム者にご連絡ください。"}

                    # m_aui = MAUI()
                    MAUI = GV.get_module('m_auth0_user_info')
                    m_aui = MAUI()

                    param_m_aui = {}
                    # # Auth0ユーザー情報管理ID
                    # param_m_aui['auth_user_info_id'] = ''
                    # テナント
                    param_m_aui['tenant'] = d['tenant']
                    # Auth0ユーザーID
                    param_m_aui['auth0_user_id'] = d['email_address']
                    # ログイン先企業コード
                    param_m_aui['company_code'] = d['company_code']
                    # ログイン先システムID
                    param_m_aui['system_id'] = d['system_id']
                    # ログイン先サービスID
                    param_m_aui['service_id'] = d['service_id']
                    # activedirectory_username
                    param_m_aui['activedirectory_username'] = None
                    # appstream_stackname
                    param_m_aui['appstream_stackname'] = None
                    # # 作成日時
                    # param_m_aui['cdate'] = ''
                    # # 更新日時
                    # param_m_aui['udate'] = ''
    
                    params = {
                        'table_name': 'm_auth0_user_info',
                        'filters': {
                            'auth0_user_id': param_m_aui['auth0_user_id'],
                            'company_code': param_m_aui['company_code'],
                            'system_id': param_m_aui['system_id'],
                            'service_id': param_m_aui['service_id'],
                            'tenant': param_m_aui['tenant']
                        }
                    }
                    data_m_aui = self.get_data(params)
                    logger.debug(data_m_aui)
    
                    tmp_m_aui = None
    
                    if data_m_aui:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>1')
                        param_m_aui['auth_user_info_id'] = data_m_aui['auth_user_info_id']
                        tmp_m_aui = m_aui._update(param_m_aui)
                        pass
                    else:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>2')
                        tmp_m_aui = m_aui._add(param_m_aui)
                        pass
    
                    if tmp_m_aui is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# データ登録NGの場合')
                        raise CustomException('SYS_ERR_100')
    
                    logger.debug('# データ登録OKの場合')
    
                logger.debug('# ##############################')
                logger.debug('# ************0807******************')

                logger.debug('# ******************************')

                logger.debug('# アプリ側のユーザ環境の初期化依頼メール送信。')

                data_email = {}
                data_email['service_id'] = d['service_id']
                data_email['mail_type'] = '保守契約企業利用後の初期化依頼'

                data_email['ma_contract_env_stock_id'] = ma_contract_env_stock_id
                data_email['ma_contract_company_code'] = d['ma_contract_company_code']
                data_email['ma_contract_user_id'] = d['ma_contract_user_id']
                data_email['system_id'] = d['system_id']
                data_email['service_id'] = d['service_id']
                data_email['system_name'] = d['system_name']
                data_email['service_name'] = d['service_name']

                self.send_email_ma_contract(data_email)
        
                logger.debug('# ##############################')

                logger.debug('''# サポートが手動でユーザ環境の初期化をする。
                             終了後にユーザ管理サイトで初期化フラグをtrueにする。''')

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass
    
    def terminate_ma_contract_count0(self):
        logger.debug('# terminate_ma_contract_count0')
        try:
            logger.debug('# ******************************')
            logger.debug('# テーブル「保守契約企業利用申込情報（確認済み）」からデータ検索')
            logger.debug('# 毎月1日に利用した回数を0回にリセットす')

            # 6439の対応　今日は月の最初チェックを削除する   S   
            # if self.is_first_day_of_month():
            # 6439の対応　今日は月の最初チェックを削除する   E
            TTRC = GV.get_module('t_ma_contract_request_confirmed')
            t_trc = TTRC()
            
            filters = []
            filters = and_(*filters)
            tmp_m_trc = t_trc._get_item_by_filters(filters, get_all=True)
            
            if tmp_m_trc is None:
                logger.debug('# 今日は月の最初の日ではありません')
                pass
            
            for tmp_m_trc_t in tmp_m_trc:
                
                ma_contract_env_stock_id = ''
                
                param_t_trc = tmp_m_trc_t.to_dict()
                logger.debug('# 「今月利用した回数」をセットする')
                param_t_trc['count'] = 0
                param_t_trc['ma_contract_start_date'] = None
                param_t_trc['ma_contract_end_date'] = None
                

                t_trc._update(param_t_trc)
                logger.debug('# 毎月1日に利用した回数を0回にリセットしました。')
                
                
                if '# テーブル「申込管理情報」からデータ検索':

                    logger.debug('# テーブル「申込管理情報」からデータ検索')
                    logger.debug('# t_manage_request')

                    params = {
                        'table_name': 't_manage_request',
                        'filters': {
                            'system_id': param_t_trc['system_id'],
                            'service_id': param_t_trc['service_id'],
                            'auth0_user_id': param_t_trc['email_address'],
                            'ma_contract_req_id': param_t_trc['ma_contract_req_id']
                        }
                    }
                    data_t_mr = self.get_data(params)

                    if data_t_mr is not None:
                        data_t_mr['status'] = GV.STATUS['保守契約企業利用可能']

                        # from ..model.t_manage_request import Sub as TMR
                        # t_mr = TMR()
                        TMR = GV.get_module('t_manage_request')
                        t_mr = TMR()

                        # システム利用可能フラグ
                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                        data_t_mr['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                        
                        tmp_t_mr = t_mr._update(data_t_mr)

                        if tmp_t_mr:
                            data_t_mr = tmp_t_mr.to_dict()
                            logger.debug(data_t_mr)
                            pass

                logger.debug('# ##############################')
            
            
                # 6439の対応　メール送信を削除する   S  
                # logger.debug('# 保守契約企業今月のご利用可能回数の通知 メール送信')

                # data_email = {}
                # data_email['service_id'] = param_t_trc['service_id']
                # data_email['mail_type'] = '保守契約企業今月のご利用可能回数の通知'
                # data_email['email_address'] = param_t_trc['email_address']
                # data_email['company_name'] = param_t_trc['company_name']
                # data_email['last_name'] = param_t_trc['last_name']
                # data_email['first_name'] = param_t_trc['first_name']
                # data_email['free_usage_upper_limit'] = param_t_trc['available_date']
                # data_email['telephone_number'] = param_t_trc['telephone_number']
                # data_email['login_url'] = GV.URL_LOGIN_SIMSP
    
                # self.send_email_ma_contract(data_email) 
                # 6439の対応　メール送信を削除する   E

            # 6439の対応　今日は月の最初チェックを削除する   S   
            # else:
            #     logger.debug('# 今日は月の最初の日ではありません。')
            # 6439の対応　今日は月の最初チェックを削除する   E
            logger.debug('# ##############################')
            
                
        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise

        return {}
        pass

    # 6439の対応　今日は月の最初チェックを削除する   S      
    # def is_first_day_of_month(self):
    #     logger.debug('# ###########今日は月の最初###################')
    #     today = datetime.now()
    #     # print(today.day == 28)
    #     return today.day == 1
    # 6439の対応　今日は月の最初チェックを削除する   E

    def DataUpdate(self,data):
        logger.debug('# ###########画面のデータの更新###################')
        print(data)
        try:
            res = {}

            logger.debug('# テーブル「申込管理情報」からデータ検索')
            logger.debug('# DataUpdate')

            params = {
                'table_name': 't_ma_contract_request_confirmed',
                'filters': {
                    'system_id': data['system_id'],
                    'service_id': data['service_id'],
                    'ma_contract_req_id': data['ma_contract_req_id']
                }
            }
            data_t_mr = self.get_data(params)

            if data_t_mr is not None:
                
                str_available_date = data_t_mr['available_date']
                # print("|||||||")
                # print(data)
                # print(data_t_mr)
                # if int(data['available_date']) < int(data_t_mr['count']):
                #     print("222222222222")
                #     raise CustomException(GV.INFO_CODE['MA_CONTRACT_I_COUNT'])
                #     pass

                logger.debug('# テーブル【保守契約企業利用申込情報履歴】にデータ登録する')
                logger.debug('# t_ma_contract_request_history')

                # from ..model.t_ma_contract_request_history import Sub as TTRH
                # t_trh = TTRH()
                TTRH = GV.get_module('t_ma_contract_request_history')
                t_trh = TTRH()
                
                data_t_trh = {}
                data_t_trh['ma_contract_req_id'] = None
                data_t_trh['system_id'] = data['system_id']
                data_t_trh['service_id'] = data['service_id']
                data_t_trh['company_name'] = data['company_name']
                data_t_trh['telephone_number'] = data['telephone_number']
                data_t_trh['last_name'] = data['last_name']
                data_t_trh['first_name'] = data['first_name']
                data_t_trh['email_address'] = data['email_address']
                data_t_trh['ma_contract_env_stock_id'] = data['ma_contract_env_stock_id']
                data_t_trh['ma_contract_start_date'] = data['ma_contract_start_date']
                data_t_trh['ma_contract_end_date'] = data['ma_contract_end_date']
                data_t_trh['available_date'] = data['available_date']
                data_t_trh['count'] = data['count']
                data_t_trh['cdate'] = None
                data_t_trh['udate'] = None

                tmp_t_trh = t_trh._add(data_t_trh)

                if tmp_t_trh:
                    logger.debug(tmp_t_trh)
                    pass
                

                # from ..model.t_manage_request import Sub as TMR
                # t_mr = TMR()
                logger.debug('# テーブル【保守契約企業利用申込情報】にデータ更新する')
                logger.debug('# t_ma_contract_request_confirmed')
                TMCRC = GV.get_module('t_ma_contract_request_confirmed')
                t_mcrc = TMCRC()
                
                data_t_mr['last_name'] = data['last_name']
                data_t_mr['first_name'] = data['first_name']
                data_t_mr['telephone_number'] = data['telephone_number']
                data_t_mr['company_name'] = data['company_name']
                data_t_mr['available_date'] = data['available_date']
                data_t_mr['udate'] = None
                
                tmp_t_mrrc = t_mcrc._update(data_t_mr)

                if tmp_t_mrrc:
                    data_t_mr = tmp_t_mrrc.to_dict()
                    logger.debug(data_t_mr)
                    pass
                
                logger.debug('# テーブル「申込管理情報」からデータ検索')
                logger.debug('# t_manage_request')

                params = {
                    'table_name': 't_manage_request',
                    'filters': {
                        'system_id': data['system_id'],
                        'service_id': data['service_id'],
                        'auth0_user_id': data['email_address'],
                        'ma_contract_req_id': data['ma_contract_req_id']
                    }
                }
                data_t_mr1 = self.get_data(params)

                logger.debug('# t_manage_request')
                TMR = GV.get_module('t_manage_request')
                t_mr = TMR()
                
                if (data['status'] == GV.STATUS['保守契約企業利用終了'] ):
                    if int(str_available_date) < int(data['available_date']):
                        data_t_mr1['status'] = GV.STATUS['保守契約企業利用可能']
                        logger.debug('# 「システム利用可能フラグ」を「全機能使用可能:2」にする')
                        data_t_mr1['system_usable_flag'] = GV.SYSTEM_USABLE_FLAG['全機能使用可能']
                        
                        tmp_t_mr = t_mr._update(data_t_mr1)
                        
                        if tmp_t_mr:
                            data_t_mr1 = tmp_t_mr.to_dict()
                            logger.debug(data_t_mr1)
                            pass

            logger.debug('# ##############################')

        except Exception as e:
            logger.debug('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
            logger.debug(e)
            # 例外の再送出
            raise
        