from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime, asc

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'file_manage'

    def get_all(self, event, context):

        # from ..view.view_file_manage import Sub as VFM
        # v_fm = VFM()
        VFM = GV.get_module('view_file_manage')
        v_fm = VFM()

        return v_fm.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_file_manage import Sub as VFM
        # v_fm = VFM()
        VFM = GV.get_module('view_file_manage')
        v_fm = VFM()

        v_fm.table_config = self.table_name
        return v_fm.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_file_manage import Sub as MEM
        # m_fm = MEM()
        MEM = GV.get_module('m_file_manage')
        m_fm = MEM()

        tmp_m_fm = m_fm._add(data)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_file_manage import Sub as MEM
        # m_fm = MEM()
        MEM = GV.get_module('m_file_manage')
        m_fm = MEM()

        tmp_m_fm = m_fm._update(data)

        return {}
    
    # 削除する
    def delete(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_file_manage import Sub as MEM
        # m_fm = MEM()
        MEM = GV.get_module('m_file_manage')
        m_fm = MEM()

        tmp_m_fm = m_fm._delete(data)

        return {}


    # 資料ファイルのURLを取得する
    def get_file_urls_terms(self):

        logger.debug('# ******************************')
        logger.debug('# サービス名を取得する')

        MSRV = GV.get_module('m_services')
        m_srv = MSRV()
            
        filters = []
        filters = and_(*filters)

        tmp_m_srv = m_srv._get_item_by_filters(filters, get_all=True)

        dict_service = {}            
        for t in tmp_m_srv:
            logger.debug(t.to_dict())
            dict_service[t.service_id] = t.service_name

        logger.debug('# ##############################')

        MFM = GV.get_module('m_file_manage')
        m_fm = MFM()

        filters = []
        filters.append(m_fm.model_class.file_type == 'terms')
        filters.append(m_fm.model_class.file_explain == '利用規約')
        filters = and_(*filters)
        
        col = getattr(m_fm.model_class, 'service_id', None)
        order_by = asc(col)
        
        tmp_m_fm = m_fm._get_item_by_filters(filters, order_by=order_by, get_all=True)

        data_m_fm = []
        for t in tmp_m_fm:
            d = t.to_dict()

            if d['service_id'] in dict_service:
                d['service_name'] = dict_service[d['service_id']]
            
            del d['file_manage_id']
            del d['file_no']
            del d['file_type']
            del d['system_id']
            del d['service_id']
            del d['cdate']
            del d['udate']

            data_m_fm.append(d)
        
        return data_m_fm
    
        pass