from .controller import Base, CustomException, GV, os, logging, json, timedelta, and_, datetime

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'env_stock'

    def get_all(self, event, context):

        VES = GV.get_module('view_env_stock')
        v_es = VES()

        return v_es.get_all(event, context)

        pass
    
    def get_table_schema(self):

        VES = GV.get_module('view_env_stock')
        v_es = VES()

        v_es.table_config = self.table_name
        return v_es.get_table_schema()

        pass

    # 作成する
    def add(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        # from ..model.m_env_stock import Sub as MES
        # m_es = MES()
        MES = GV.get_module('m_env_stock')
        m_es = MES()

        tmp_m_es = m_es._add(data)

        if tmp_m_es is not None:
            
            data_m_es = tmp_m_es.to_dict()

            self.set_mscone_lic_datas(data_m_es)

        return {}
    
    # 更新する
    def update(self, event, context):
        
        if GV.EVENT_BODY is None:
            raise CustomException('SYS_ERR_100')

        data = GV.EVENT_BODY

        return self._update(data)

    # 更新する
    def _update(self, data):
        # from ..model.m_env_stock import Sub as MES
        # m_es = MES()
        MES = GV.get_module('m_env_stock')
        m_es = MES()

        logger.debug('# ******************************')

        logger.debug('# ・環境ストックが交換された場合(間違ってGRDAE/HULLのマシンを付けたので、SimSPに変えるなど)')
        logger.debug('#   ・「環境ストックを外された場合」と「企業コード発行済みであとから環境ストックが割り当てられた場合」の処理をする')

        data_m_es_old = None

        filters = []
        filters.append(m_es.model_class.env_id == data['env_id'])
        filters = and_(*filters)

        tmp_m_es_get = m_es._get_item_by_filters(filters)
        if tmp_m_es_get is not None:
            data_m_es_old = tmp_m_es_get.to_dict()

            if data_m_es_old['company_code'] is not None:
                if data_m_es_old['company_code'] != data['company_code']:
                    data_m_es_old['company_code'] = None
                    self.set_mscone_lic_datas(data_m_es_old)
           
        logger.debug('# ##############################')

        tmp_m_es = m_es._update(data)

        if tmp_m_es is not None:
            
            data_m_es = tmp_m_es.to_dict()

            self.set_mscone_lic_datas(data_m_es)

        return {}
    
    # 環境起動通知メール送信
    def send_environment_startup_notification_email(self, data):
        
        logger.debug('# send_environment_startup_notification_email')

        logger.debug('# ******************************')
        logger.debug('# 環境起動完了通知メール送信ボタン(営業宛)')
        logger.debug(data)

        data_email = {}
        data_email = data
        data_email['service_id'] = data['service_id']
        data_email['mail_type'] = '環境起動通知'
        data_email['env_id'] = data['env_id']
        data_email['system_id'] = data['system_id']
        data_email['service_id'] = data['service_id']
        data_email['system_name'] = data['system_name']
        data_email['service_name'] = data['service_name']
        data_email['company_code'] = data['company_code']

        logger.debug('# ******************************')
        logger.debug('# 企業情報を取得する')
        
        MCOM = GV.get_module('m_company')
        m_com = MCOM()
        
        filters = []
        filters.append(m_com.model_class.company_code == data['company_code'])
        filters = and_(*filters)

        tmp_m_com = m_com._get_item_by_filters(filters)

        if tmp_m_com is not None:
            data_m_com = tmp_m_com.to_dict()

            data_email['company_name'] = data_m_com['company_name']
            # data_email['last_name']  = data_m_com['company_leader_last']
            # data_email['first_name'] = data_m_com['company_leader_first']
            
        logger.debug('# ##############################')

        self.send_email_env_stock(data_email)

        logger.debug('# ##############################')

        return {}
    
    def send_email_env_stock(self, data):
        logger.debug('# ******************************')
        logger.debug('# send_email_contract')

        try:
            mail_parameter = {}

            mail_parameter = data.copy()

            mail_parameter['to_address'] = []
            if 'email_address' in data:
                mail_parameter['to_address'].append(data['email_address'])

            logger.debug('# mail_parameter ----------------')
            logger.debug(mail_parameter)

            mail_template = None

            # from ..model.m_send_mail import Sub as MSM
            # m_sm = MSM()
            MSM = GV.get_module('m_send_mail')
            m_sm = MSM()

            filters = []
            filters.append(m_sm.model_class.service_id == data['service_id'])
            filters.append(m_sm.model_class.mail_type == data['mail_type'])
            filters = and_(*filters)
            tmp_m_sm = m_sm._get_item_by_filters(filters)
            if tmp_m_sm:
                logger.debug(tmp_m_sm)
                mail_template = tmp_m_sm.to_dict()

            logger.debug(mail_template)
            logger.debug(mail_parameter)

            result = {}

            # ???
            result = self.send_email(mail_template, mail_parameter)

            return result

        except Exception as err:
            # return error_handling(inspect.currentframe().f_code.co_name, err)
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')

    def set_mscone_lic_datas(self, data):
        logger.debug('# ******************************')
        logger.debug('# set_mscone_lic_datas')

        logger.debug('# data')
        logger.debug(data)

        logger.debug('# ******************************')

        if 'company_code' in data and data['company_code'] is not None:
            pass
        else:
            logger.debug('# ・環境ストックを外された場合(間違ってGRDAE/HULLのマシンを付けたので外した。ワークショップキャンセル、本契約キャンセルなど)')
            logger.debug('#   ・mscone_lic.m_companyをenv_idでクエリーして、company_codeを空欄にする。')
            logger.debug('#   ・mscone_lic.m_directory_userのdirectory_usernameをenv_idでクエリー。')
            logger.debug('#     ・検索結果のcompany_code、user_emailを空欄にする')

            logger.debug('# ******************************')

            MCML = GV.get_module('m_company_mscone_lic')
            m_c_ml = MCML()

            filters = []
            filters.append(m_c_ml.model_class.env_id == data['env_id'])
            filters = and_(*filters)

            tmp_m_c_ml = m_c_ml._get_item_by_filters(filters)

            if tmp_m_c_ml is not None:
                data_m_c_ml = tmp_m_c_ml.to_dict()

                data_m_c_ml['company_code'] = None

                tmp_m_c_ml_update = m_c_ml._update(data_m_c_ml)

                if tmp_m_c_ml_update is None:
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# mscone_lic.m_companyデータ登録NGの場合')
                    raise CustomException('SYS_ERR_100')
                
                data_m_c_ml_update = tmp_m_c_ml_update.to_dict()
                logger.debug('data_m_c_ml_update')
                logger.debug(data_m_c_ml_update)

            logger.debug('# ##############################')

            logger.debug('# ******************************')

            MDU = GV.get_module('m_directory_user')
            m_du = MDU()

            filters = []
            filters.append(m_du.model_class.directory_username.like(data['env_id'] + '.' + '%'))
            filters = and_(*filters)

            tmp_m_du = m_du._get_item_by_filters(filters, get_all=True)

            if tmp_m_du is not None:

                for t_m_du in tmp_m_du:

                    data_m_du = t_m_du.to_dict()

                    data_m_du['company_code'] = None
                    data_m_du['user_email'] = None

                    tmp_m_du_update = m_du._update(data_m_du)

                    if tmp_m_du_update is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# mscone_lic.m_directory_userデータ更新NGの場合')
                        raise CustomException('SYS_ERR_100')
                    
                    data_m_du_update = tmp_m_du_update.to_dict()
                    logger.debug('data_m_du_update')
                    logger.debug(data_m_du_update)

            logger.debug('# ##############################')

            return
            
            pass

        logger.debug('# ##############################')

        # service_path = 'simsp'
        # system_id = None
        # service_id = None

        # logger.debug('# ******************************')

        # logger.debug('# 「システムID」を取得する')
        # logger.debug('# テーブル「システムマスタ」からデータ検索')
        # logger.debug('# m_systems')

        # MSYS = GV.get_module('m_systems')
        # m_sys = MSYS()

        # filters = []
        # filters.append(m_sys.model_class.system_name == GV.SYSTEM_SERVICE[service_path]['system_name'])
        # filters = and_(*filters)

        # tmp_m_sys = m_sys._get_item_by_filters(filters)

        # if tmp_m_sys is not None:
        #     data_m_sys = tmp_m_sys.to_dict()
        #     system_id = data_m_sys['system_id']
        #     pass

        # logger.debug('# ##############################')

        # logger.debug('# ******************************')

        # logger.debug('# 「サービスID」を取得する')
        # logger.debug('# テーブル「サービスマスタ」からデータ検索')
        # logger.debug('# m_services')

        # MSRV = GV.get_module('m_services')
        # m_srv = MSRV()

        # filters = []
        # filters.append(m_srv.model_class.service_name == GV.SYSTEM_SERVICE[service_path]['service_name'])
        # filters = and_(*filters)

        # tmp_m_srv = m_srv._get_item_by_filters(filters)

        # if tmp_m_srv is not None:
        #     data_m_srv = tmp_m_srv.to_dict()
        #     service_id = data_m_srv['service_id']
        #     pass

        # logger.debug('# ##############################')

        # if ('system_id' in data and data['system_id'] == system_id) and \
        #     ('service_id' in data and data['service_id'] == service_id):
        #     pass
        # else:
        #     print(GV.SERVICE_PATH)
        #     print(GV.SYSTEM_ID)
        #     print(GV.SYSTEM)
        #     print('$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$')
        #     return
        
        logger.debug('# ・企業コード発行済みであとから環境ストックが割り当てられた場合')
        logger.debug('#   ・mscone_lic.m_companyのenv_idをenv_idでクエリーして、company_codeを設定する。')
        logger.debug('#   ・mscone_lic.m_directory_userのdirectory_usernameをenv_idでクエリー')
        logger.debug('#     ・0件の場合')
        logger.debug('#       ・mscone_lic.m_directory_userに5ユーザーを追加する。directory_usernameは「env_id +"."+ user000～004」。')
        logger.debug('#       ・company_codeを設定する。')
        logger.debug('#       ・「env_id +"."+ user000」のuser_emailに申込(契約)をしたユーザーのメールアドレスを設定する')
        logger.debug('#     ・0件以外の場合')
        logger.debug('#       ・company_codeを上書きする')
        logger.debug('#       ・「env_id +"."+ user000」のuser_emailに申込(契約)をしたユーザーのメールアドレスを設定する')

        try:
            
            logger.debug('# ******************************')

            if '# ・企業コード発行時に環境ストックが割り当てられる場合':

                logger.debug('# SimSPと共通PFのDB登録')
                logger.debug('# ・企業コード発行時に環境ストックが割り当てられる場合')
                logger.debug('#   ・mscone_lic.m_companyのenv_idをenv_idでクエリーして、company_codeを設定する。')

                data_m_c_ml = None

                logger.debug('# ******************************')
                MCML = GV.get_module('m_company_mscone_lic')
                m_c_ml = MCML()

                filters = []
                filters.append(m_c_ml.model_class.env_id == data['env_id'])
                filters = and_(*filters)

                tmp_m_c_ml = m_c_ml._get_item_by_filters(filters)

                if tmp_m_c_ml is not None:
                    data_m_c_ml = tmp_m_c_ml.to_dict()

                    data_m_c_ml['company_code'] = data['company_code']

                    tmp_m_c_ml_update = m_c_ml._update(data_m_c_ml)

                    if tmp_m_c_ml_update is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# mscone_lic.m_companyデータ登録NGの場合')
                        raise CustomException('SYS_ERR_100')
                    
                    data_m_c_ml_update = tmp_m_c_ml_update.to_dict()
                    logger.debug('data_m_c_ml_update')
                    logger.debug(data_m_c_ml_update)

                logger.debug('# ##############################')

                if data_m_c_ml is not None:

                    logger.debug('# ・mscone_lic.m_directory_userのdirectory_usernameをenv_idでクエリー')

                    logger.debug('# ******************************')
                    MDU = GV.get_module('m_directory_user')
                    m_du = MDU()

                    filters = []
                    filters.append(m_du.model_class.directory_username.like(data['env_id'] + '.' + '%'))
                    filters = and_(*filters)

                    tmp_m_du = m_du._get_item_by_filters(filters, get_all=True)
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    print(tmp_m_du)
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')

                    if tmp_m_du is None or (tmp_m_du is not None and len(tmp_m_du) < 1):

                        logger.debug('#   ・0件の場合')
                        logger.debug('#     ・mscone_lic.m_directory_userに5ユーザーを追加する。directory_usernameは「env_id +"."+ user000～004」。')
                        logger.debug('#     ・company_codeを設定する。')

                        for idx_m_du in range(5):

                            data_m_du = {}
                            data_m_du['company_code'] = data['company_code']
                            data_m_du['directory_username'] = data['env_id'] + '.' + 'user' + '00' + str(idx_m_du)

                            tmp_m_du_add = m_du._add(data_m_du)

                            if tmp_m_du_add is None:
                                logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                logger.debug('# mscone_lic.m_directory_userデータ登録NGの場合')
                                raise CustomException('SYS_ERR_100')
                            
                            data_m_du_add = tmp_m_du_add.to_dict()
                            logger.debug('data_m_du_add')
                            logger.debug(data_m_du_add)
                    
                    else:

                        logger.debug('#   ・0件以外の場合')
                        logger.debug('#     ・company_codeを上書きする')

                        for t_m_du in tmp_m_du:

                            data_m_du = t_m_du.to_dict()
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            print(data_m_du)
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')

                            data_m_du['company_code'] = data['company_code']
                            data_m_du['user_email'] = None

                            tmp_m_du_update = m_du._update(data_m_du)

                            if tmp_m_du_update is None:
                                logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                                logger.debug('# mscone_lic.m_directory_userデータ更新NGの場合')
                                raise CustomException('SYS_ERR_100')
                            
                            data_m_du_update = tmp_m_du_update.to_dict()
                            logger.debug('data_m_du_update')
                            logger.debug(data_m_du_update)

                    logger.debug('# ******************************')            
                    logger.debug('#     ・「env_id +"."+ user000」のuser_emailに申込(契約)をしたユーザーのメールアドレスを設定する')
                    
                    data_t_mr = None

                    logger.debug('# ******************************')
                    logger.debug('# t_manage_request')

                    TMR = GV.get_module('t_manage_request')
                    t_mr = TMR()

                    filters = []
                    filters.append(t_mr.model_class.system_id == data['system_id'])
                    filters.append(t_mr.model_class.service_id == data['service_id'])
                    filters.append(t_mr.model_class.company_code == data['company_code'])
                    filters = and_(*filters)

                    tmp_t_mr = t_mr._get_item_by_filters(filters)

                    if tmp_t_mr is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# t_manage_requestデータ取得NGの場合')
                        raise CustomException('SYS_ERR_100')
                    
                    data_t_mr = tmp_t_mr.to_dict()

                    logger.debug('# ##############################')

                    data_m_u = None

                    logger.debug('# ******************************')
                    logger.debug('# m_user')

                    MU = GV.get_module('m_user')
                    m_u = MU()

                    filters = []
                    filters.append(m_u.model_class.company_code == data['company_code'])
                    filters.append(m_u.model_class.auth0_user_id == data_t_mr['auth0_user_id'])
                    filters = and_(*filters)

                    tmp_m_u = m_u._get_item_by_filters(filters)

                    if tmp_m_u is None:
                        logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                        logger.debug('# m_userデータ取得NGの場合')
                        raise CustomException('SYS_ERR_100')
                    
                    data_m_u = tmp_m_u.to_dict()
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    print(data_m_u)
                    logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                    logger.debug('# ##############################')
                    
                    filters = []
                    filters.append(m_du.model_class.company_code == data['company_code'])
                    filters.append(m_du.model_class.directory_username == data['env_id'] + '.' + 'user' + '000')
                    filters = and_(*filters)

                    tmp_m_du = m_du._get_item_by_filters(filters)

                    if tmp_m_du is not None:

                        data_m_du = tmp_m_du.to_dict()

                        data_m_du['user_email'] = data_m_u['email']

                        tmp_m_du_update = m_du._update(data_m_du)

                        if tmp_m_du_update is None:
                            logger.debug('# >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>')
                            logger.debug('# mscone_lic.m_directory_userデータ更新NGの場合')
                            raise CustomException('SYS_ERR_100')
                        
                        data_m_du_update = tmp_m_du_update.to_dict()
                        logger.debug('data_m_du_update')
                        logger.debug(data_m_du_update)

                    logger.debug('# ##############################')

                    logger.debug('# ##############################')

            logger.debug('# ##############################')

        except Exception as err:
            logger.debug(err)
            # 例外の再送出
            raise
        finally:
            pass
            logger.debug('# ##############################')
        
        pass