from .controller import Base, CustomException, GV, os, logging, json, datetime, timedelta, and_, desc
import boto3
import csv
import json

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub(Base):

    table_name = 'entry_site_app_settings_confirmed'
  
    CSV_COL = [
        "レコードの開始行", # 0
        "レコード番号", # 1
        "アプリ表示名", # 2
        "ボタン表示[資料請求]", # 4
        "ボタン表示[トライアル]", # 5
        "ボタン表示[ワークショップ]", # 6
        "ボタン表示[本契約]", # 7
        "サプライヤID", # 8
        "システムID", # 9
        "アプリ説明", # 11
        "資料請求説明", # 12
        "トライアル説明", # 13
        "トライアル申込み完了", # 14
        "ワークショップ説明", # 15
        "ワークショップ申し込み完了", # 16
        "アンケート説明", # 17
        "本契約説明", # 18
        "本契約申込み完了", # 20
        "ステータス",
        "作業者", # 24
        "一覧追加用コード",
        "更新者", # 21
        "作成者", # 22
        "更新日時", # 23
        "作成日時", # 24
        "アンケート質問", # 25
        "アンケート回答選択肢(\"|\"区切り)", # 26
        "アンケート回答タイプ", # 27
        "必須項目[必須]", # 28
        "資料説明タイトル", # 29
        "資料説明本文", # 30
        "アプリ画像", # 31
        "利用規約(PDF)", # 32
        "資料画像", # 33
        "資料ファイル", # 34
        "個人情報の取扱(PDF)", #35
        "支払方法の説明画像" #36
    ]

    def get_all(self, event, context):

        # from ..view.view_auth0_role_info import Sub as VARI
        # v_ari = VARI()
        VARI = GV.get_module('view_entry_site_app_settings_confirmed')
        v_ari = VARI()

        return v_ari.get_all(event, context)

        pass
    
    def get_table_schema(self):

        # from ..view.view_auth0_role_info import Sub as VARI
        # v_ari = VARI()
        VARI = GV.get_module('view_entry_site_app_settings_confirmed')
        v_ari = VARI()

        v_ari.table_config = self.table_name
        return v_ari.get_table_schema()

        pass

    # アンケート設定一覧
    def get_entry_site_questionnaire_manage_confirmed(self):

        logger.debug('# get_entry_site_questionnaire_manage_confirmed')

        VCS = GV.get_module('view_entry_site_questionnaire_manage_confirmed')
        v_cs = VCS()

        return v_cs.get_all(None, None)

        pass

    def import_csv(self):
      logger.debug('# ******************************')
      logger.debug('import_csv----------')
      logger.debug(self)
  
      s3 = boto3.resource('s3')
      if GV.ENV == 'LOCAL':
         BUCKET_NAME = GV.ENV_CONFIG['LOCAL']['BUCKET_NAME']
      else:
         BUCKET_NAME = GV.ENV.lower() + GV.S3_BUCKET_NAME
      bucket = s3.Bucket(BUCKET_NAME)
      s3_kintone_csv_path = 'kintone/csv/'
      fileExist = False
  
      try:
          logger.debug('# ##############################')
  
          prefix = s3_kintone_csv_path
          file_list = bucket.objects.filter(Prefix=prefix)
          
          files = os.listdir('/tmp/')

          for o in file_list:
              
              target_csv_file = o.key
              # print('-----|||------')
              # print(target_csv_file)
              if ".csv" in target_csv_file and target_csv_file.startswith(s3_kintone_csv_path + "申込ポータルサイトアプリごとの登録"):
                  fileExist = True
              
                  filepath = '/tmp/'
                  file_name = filepath + o.key.split('/')[-1]
                  print('++++++++++++')
                  print(file_name)
                  # S3からファイルダウンロード 
                  bucket.download_file(o.key, file_name)
                  print('++++++++++++')
                  
                  # 申込ポータルサイト情報登録
                  self.insert_infrastructure_m_entry_site(file_name)
    
          if not fileExist:
             raise CustomException('MESASC_CSV_ERR_100')
          
          pass
        
          return {}
  
      except Exception as e:
          logger.debug(e)
          # 例外の再送出
          raise
      finally:
          logger.debug('# ##############################')
  
    # 申込ポータルサイト情報登録
    def insert_infrastructure_m_entry_site(self, file_name):
      print('insert_infrastructure_m_entry_site|||||')
      # strRow = ''
      cur = []
      
      # テーブルデータを削除する
      # self.del_user_infrastructure_m_entry_site()

      delete_m_entry_site_document_request_manage_confirmed = True
      delete_entry_site_questionnaire_manage_confirmed = True
  
      with open(file_name, encoding='utf-8') as f:
          d_reader = csv.DictReader(f)
          # 行数カウント
          count = sum(1 for row in d_reader)
          if count < 1:
              raise CustomException('MNBSI_CSV_ERR_100')
          
          f.seek(0)
          for i, row in enumerate(d_reader):
            # print("||||||||||||")
            # print(len(','.join(list(row))))
            # print(len(','.join(self.CSV_COL)))
            # print(row)
            if i == 0:
                if ','.join(list(row)) != ','.join(self.CSV_COL):
                    raise CustomException('MNBSI_CSV_ERR_101')
                pass
            else:
              if row["システムID"].strip() == '':
                  raise CustomException('MNBSI_CSV_ERR_103', [i, 'システムID'])
              
              if row['システムID'] == GV.SYSTEM_ID:
                if len(row) != len(self.CSV_COL):
                  raise CustomException('MNBSI_CSV_ERR_102')
            
                if 'レコードの開始行' in row and row['レコードの開始行'] == '*':
                  # user_infrastructure.m_entry_site_app_settings_confirmed更新
                  self.update_user_infrastructure_m_entry_site_app_settings_confirmed(row, row_num=i, delete_flg=True)
                
                if row['資料説明タイトル'] != '' or row['資料説明本文'] != '':
                  # user_infrastructure.m_entry_site_document_request_manage_confirmed更新
                  self.update_user_infrastructure_m_entry_site_document_request_manage_confirmed(row, row_num=i, delete_flg=delete_m_entry_site_document_request_manage_confirmed)
                  delete_m_entry_site_document_request_manage_confirmed = False
                
                if row['アンケート質問'] != '' or row['アンケート回答選択肢("|"区切り)'] != '' or row['アンケート回答タイプ'] != '' or row['必須項目[必須]'] != '':
                  # user_infrastructure.m_entry_site_questionnaire_manage_confirmed更新
                  self.update_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(row, row_num=i, delete_flg=delete_entry_site_questionnaire_manage_confirmed)
                  delete_entry_site_questionnaire_manage_confirmed = False  
                  
      # 課金アップロード履歴テーブル登録用のファイル名
      name = file_name.split('/')[-1]
  
      return 
    
    # def int_user_infrastructure_m_entry_site_app_settings_confirmed(self,item):
    #   logger.info('int_user_infrastructure_m_entry_site_app_settings_confirmed!!!')
  
    #   res = {}
    #   print('-----------------------')
    #   logger.info(item)
    #   print('-----------------------')
  
    #   try:
    #     record = {
    #       '$id': {'value': None},
    #       'ステータス': {'value': None},
    #       '作業者': {'value': None},
    #       'レコード番号': {'value': None},
    #       '作成者': {'value': None},
    #       '作成日時': {'value': None},
    #       '更新者': {'value': None},
    #       '更新日時': {'value': None},
    #       'entry_site_app_setting_id': { 'value': ''},
    #       'supplier_id': { 'value': ''},
    #       'system_id': { 'value': ''},
    #       'app_display_flag': { 'value': ''},
    #       'app_display_name': { 'value': ''},
    #       'handling_of_personal_information': { 'value': ''},
    #       'top_app_description': { 'value': ''},
    #       'top_document_request_btn_flag': { 'value': ''},
    #       'top_trial_btn_flag': { 'value': ''},
    #       'top_workshop_btn_flag': { 'value': ''},
    #       'top_contract_btn_flag': { 'value': None},
    #       'document_request_descritpion': { 'value': None},
    #       'trial_description': { 'value': None},
    #       'trial_application_completed': { 'value': ''},
    #       'workshop_description': { 'value': None},
    #       'workshop_application_completed': { 'value': ''},
    #       'workshop_questionnaire_description': { 'value': ''},
    #       'contract_description': { 'value': ''},
    #       'contract_terms_text': { 'value': ''},
    #       'contract_application_completed': { 'value': ''},
    #       'top_app_image_url': { 'value': ''},
    #       'contract_terms_file_url': { 'value': ''},
    #     }
        
    #     # '申込ポータルサイトアプリ設定ID'
    #     record["entry_site_app_setting_id"]["value"] = item["レコード番号"]
    #     # 'サプライヤーID'
    #     record["supplier_id"]["value"] = item["サプライヤID"]
    #     # 'システムID'
    #     record["system_id"]["value"] = item["システムID"]
    #     # 'アプリ表示OnOff'
    #     # record["app_display_flag"]["value"] = item["アプリ表示"]
    #     if item["アプリ表示"] == 'Off':
    #       record["app_display_flag"]["value"] = False
    #     else:
    #       record["app_display_flag"]["value"] = True
    #     # 'アプリ表示名'
    #     record["app_display_name"]["value"] = item["アプリ表示名"]
    #     # '個人情報取り扱い'
    #     record["handling_of_personal_information"]["value"] = item["個人情報取り扱い本文"]
    #     # 'アプリ説明'
    #     record["top_app_description"]["value"] = item["アプリ説明"]
    #     # '資料請求OnOff'
    #     # record["top_document_request_btn_flag"]["value"] = item['ボタン表示[資料請求]']
    #     if item['ボタン表示[資料請求]'] == '1':
    #       record["top_document_request_btn_flag"]["value"] = True
    #     else:
    #       record["top_document_request_btn_flag"]["value"] = False
    #     # 'フリートライアルOnOff'
    #     # record["top_trial_btn_flag"]["value"] = item['ボタン表示[トライアル]']
    #     if item['ボタン表示[トライアル]'] == '1':
    #       record["top_trial_btn_flag"]["value"] = True
    #     else:
    #       record["top_trial_btn_flag"]["value"] = False
    #     # 'ワークショップOnOff'
    #     # record["top_workshop_btn_flag"]["value"] = item['ボタン表示[ワークショップ]']
    #     if item['ボタン表示[ワークショップ]'] == '1':
    #       record["top_workshop_btn_flag"]["value"] = True
    #     else:
    #       record["top_workshop_btn_flag"]["value"] = False
    #     # '本契約OnOff'
    #     # record["top_contract_btn_flag"]["value"] = item['ボタン表示[本契約]']
    #     if item['ボタン表示[本契約]'] == '1':
    #       record["top_contract_btn_flag"]["value"] = True
    #     else:
    #       record["top_contract_btn_flag"]["value"] = False
    #     # '資料請求説明'
    #     record["document_request_descritpion"]["value"] = item["資料請求説明"]
    #     # 'フリートライアル説明'
    #     record["trial_description"]["value"] = item["トライアル説明"]
    #     # '申込み完了'
    #     record["trial_application_completed"]["value"] = item["トライアル申込み完了"]
    #     # 'ワークショップ説明'
    #     record["workshop_description"]["value"] = item["ワークショップ説明"]
    #     # '申込み完了'
    #     record["workshop_application_completed"]["value"] = item["ワークショップ申し込み完了"]
    #     # 'アンケート説明'
    #     record["workshop_questionnaire_description"]["value"] = item["アンケート説明"]
    #     # '本契約説明'
    #     record["contract_description"]["value"] = item["本契約説明"]
    #     # '利用規約のテキスト'
    #     record["contract_terms_text"]["value"] = item["利用規約"]
    #     # '申込み完了'
    #     record["contract_application_completed"]["value"] = item["本契約申込み完了"]
    #     # # '登録日時'
    #     # record["cdate"]["value"] = item["作成日時"]
    #     # # '更新日時'
    #     # record["udate"]["value"] = item["更新日時"]
    #     'アプリ画像URL'
    #     record["top_app_image_url"]["value"] = item["アプリ画像URL"] 
    #     '利用規約のPDFファイルURL'
    #     record["contract_terms_file_url"]["value"] = item["利用規約のPDFファイルURL"]
    #     print('+++++++++++++++++++++++++++')
    #     print(record)
    #     print('+++++++++++++++++++++++++++')
    #     input_event = {
    #         'stageVariables': {
    #             'env': GV.ENV
    #         },
    #         'httpMethod': 'POST',
    #         'path': '/rds/user_infrastructure/m_entry_site_app_settings_confirmed',
    #         'body': json.dumps(
    #             {
    #                 'record': record
    #             }
    #         )
    #     }
  
    #     Payload = json.dumps(input_event)
    #     print("---01: Payload:", Payload)
  
    #     # 呼び出し
    #     response = boto3.client('lambda').invoke(
    #         FunctionName='evo-lam-sys-rds',
    #         InvocationType='RequestResponse',
    #         Payload=Payload
    #     )
    #     print("---02: response:", response)
  
    #     res = response
  
    #     result = None
    #     if 'StatusCode' in response and response['StatusCode'] == 200:
  
    #         # レスポンス読出し
    #         Payload = json.loads(response['Payload'].read())
    #         print("---03: body:", Payload)
    #         res = Payload
  
    #   except Exception as err:
    #       # return error_handling(inspect.currentframe().f_code.co_name, err)
    #       logger.debug(err)
    #       # 例外の再送出
    #       raise
  
    #   return res
  
    # def int_user_infrastructure_m_entry_site_document_request_manage_confirmed(self,item):
    #   logger.info('int_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')
  
    #   res = {}
    #   print('-----------------------')
    #   logger.info(item)
    #   print('-----------------------')
  
    #   try:
    #     record = {
    #       '$id': {'value': None},
    #       'ステータス': {'value': None},
    #       '作業者': {'value': None},
    #       'レコード番号': {'value': None},
    #       '作成者': {'value': None},
    #       '作成日時': {'value': None},
    #       '更新者': {'value': None},
    #       '更新日時': {'value': None},
    #       'document_request_file_temp_id': { 'value': ''},
    #       'system_id': { 'value': ''},
    #       'document_request_file_title': { 'value': ''},
    #       'document_request_file_description': { 'value': ''},
    #       'document_request_file_image_url': { 'value': ''},
    #       'document_request_file_url': { 'value': ''},
    #     }
        
    #     # '申込ポータルサイトアプリ設定ID'
    #     # record["document_request_file_temp_id"]["value"] = item["レコード番号"]
    #     # 'システムID'
    #     record["system_id"]["value"] = item["システムID"]
    #     # '資料説明タイトル'
    #     record["document_request_file_title"]["value"] = item["資料説明タイトル"]
    #     # '資料説明本文'
    #     record["document_request_file_description"]["value"] = item["資料説明本文"]
    #     # '資料画像URL'
    #     record["document_request_file_image_url"]["value"] = item["資料画像URL"]
    #     # '資料URL'
    #     record["document_request_file_url"]["value"] = item["資料URL"]
  
    #     input_event = {
    #         'stageVariables': {
    #             'env': GV.ENV
    #         },
    #         'httpMethod': 'POST',
    #         'path': '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed',
    #         'body': json.dumps(
    #             {
    #                 'record': record
    #             }
    #         )
    #     }
  
    #     Payload = json.dumps(input_event)
    #     print("---01: Payload:", Payload)
  
    #     # 呼び出し
    #     response = boto3.client('lambda').invoke(
    #         FunctionName='evo-lam-sys-rds',
    #         InvocationType='RequestResponse',
    #         Payload=Payload
    #     )
    #     print("---02: response:", response)
  
    #     res = response
  
    #     result = None
    #     if 'StatusCode' in response and response['StatusCode'] == 200:
  
    #         # レスポンス読出し
    #         Payload = json.loads(response['Payload'].read())
    #         print("---03: body:", Payload)
    #         res = Payload
  
    #   except Exception as err:
    #       # return error_handling(inspect.currentframe().f_code.co_name, err)
    #       logger.debug(err)
    #       # 例外の再送出
    #       raise
  
    #   return res
  
    # def int_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(self,item):
    #   logger.info('int_user_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')
  
    #   res = {}
    #   print('-----------------------')
    #   logger.info(item)
    #   print('-----------------------')
  
    #   try:
    #     record = {
    #       '$id': {'value': None},
    #       'ステータス': {'value': None},
    #       '作業者': {'value': None},
    #       'レコード番号': {'value': None},
    #       '作成者': {'value': None},
    #       '作成日時': {'value': None},
    #       '更新者': {'value': None},
    #       '更新日時': {'value': None},
    #       'questionnaire_temp_id': { 'value': ''},
    #       'system_id': { 'value': ''},
    #       'questionnaire_location': { 'value': ''},
    #       'questionnaire_question': { 'value': ''},
    #       'questionnaire_answer_choices': { 'value': ''},
    #       'questionnaire_anser_type': { 'value': ''},
    #       'required': { 'value': ''},
    #     }
        
    #     # 'アンケート一時管理ID'
    #     # record["questionnaire_temp_id"]["value"] = item["レコード番号"]
    #     # 'システムID'
    #     record["system_id"]["value"] = item["システムID"]
    #     # 'アンケートの場所'
    #     record["questionnaire_location"]["value"] = 'workshop'
    #     # 'アンケート質問'
    #     record["questionnaire_question"]["value"] = item["アンケート質問"]
    #     # 'アンケート回答選択肢'
    #     record["questionnaire_answer_choices"]["value"] = item['アンケート回答選択肢("|"区切り)']
    #     # 'アンケート回答タイプ'
    #     record["questionnaire_anser_type"]["value"] = item['アンケート回答タイプ']
    #     # '必須項目'
    #     # record["required"]["value"] = item['必須項目[必須]']
    #     if item['必須項目[必須]'] == '1':
    #       record["required"]["value"] = True
    #     else:
    #       record["required"]["value"] = False
  
    #     input_event = {
    #         'stageVariables': {
    #             'env': GV.ENV
    #         },
    #         'httpMethod': 'POST',
    #         'path': '/rds/user_infrastructure/m_entry_site_questionnaire_manage_confirmed',
    #         'body': json.dumps(
    #             {
    #                 'record': record
    #             }
    #         )
    #     }
  
    #     Payload = json.dumps(input_event)
    #     print("---01: Payload:", Payload)
  
    #     # 呼び出し
    #     response = boto3.client('lambda').invoke(
    #         evo-FunctionName='lam-sys-rds',
    #         InvocationType='RequestResponse',
    #         Payload=Payload
    #     )
    #     print("---02: response:", response)
  
    #     res = response
  
    #     result = None
    #     if 'StatusCode' in response and response['StatusCode'] == 200:
  
    #         # レスポンス読出し
    #         Payload = json.loads(response['Payload'].read())
    #         print("---03: body:", Payload)
    #         res = Payload
  
    #   except Exception as err:
    #       # return error_handling(inspect.currentframe().f_code.co_name, err)
    #       logger.debug(err)
    #       # 例外の再送出
    #       raise
  
    #   return res
  
    # def del_user_infrastructure_m_entry_site_document_request_manage_confirmed(self,item):
    #   logger.info('del_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')
  
    #   res = {}
    #   print('-----------------------')
    #   logger.info(item)
    #   print('-----------------------')
  
    #   try:
    #     record = {
    #       '$id': {'value': None},
    #       'ステータス': {'value': None},
    #       '作業者': {'value': None},
    #       'レコード番号': {'value': None},
    #       '作成者': {'value': None},
    #       '作成日時': {'value': None},
    #       '更新者': {'value': None},
    #       '更新日時': {'value': None},
    #       'system_id': { 'value': ''},
    #     }
        
    #     # 'システムID'
    #     record["system_id"]["value"] = item["システムID"]
  
    #     input_event = {
    #         'stageVariables': {
    #             'env': GV.ENV
    #         },
    #         'httpMethod': 'POST',
    #         'path': '/rds/user_infrastructure/m_entry_site_document_request_manage_confirmed_del',
    #         'body': json.dumps(
    #             {
    #                 'record': record
    #             }
    #         )
    #     }
  
    #     Payload = json.dumps(input_event)
    #     print("---01: Payload:", Payload)
  
    #     # 呼び出し
    #     response = boto3.client('lambda').invoke(
    #         evo-FunctionName='lam-sys-rds',
    #         InvocationType='RequestResponse',
    #         Payload=Payload
    #     )
    #     print("---02: response:", response)
  
    #     res = response
  
    #     result = None
    #     if 'StatusCode' in response and response['StatusCode'] == 200:
  
    #         # レスポンス読出し
    #         Payload = json.loads(response['Payload'].read())
    #         print("---03: body:", Payload)
    #         res = Payload
  
    #   except Exception as err:
    #       # return error_handling(inspect.currentframe().f_code.co_name, err)
    #       logger.debug(err)
    #       # 例外の再送出
    #       raise
  
    #   return res
  
    # def del_user_infrastructure_m_entry_site(self):
    #   logger.info('del_user_infrastructure_m_entry_site!!!')
  
    #   res = {}
  
    #   try:
    #     record = {
    #       '$id': {'value': None},
    #       'ステータス': {'value': None},
    #       '作業者': {'value': None},
    #       'レコード番号': {'value': None},
    #       '作成者': {'value': None},
    #       '作成日時': {'value': None},
    #       '更新者': {'value': None},
    #       '更新日時': {'value': None},
    #     }
        
    #     # 'システムID'
    #     # record["system_id"]["value"] = item["システムID"]
  
    #     input_event = {
    #         'stageVariables': {
    #             'env': GV.ENV
    #         },
    #         'httpMethod': 'POST',
    #         'path': '/rds/user_infrastructure/m_entry_site_del',
    #         'body': json.dumps(
    #             {
    #                 'record': record
    #             }
    #         )
    #     }
  
    #     Payload = json.dumps(input_event)
    #     print("---01: Payload:", Payload)
  
    #     # 呼び出し
    #     response = boto3.client('lambda').invoke(
    #         evo-FunctionName='lam-sys-rds',
    #         InvocationType='RequestResponse',
    #         Payload=Payload
    #     )
    #     print("---02: response:", response)
  
    #     res = response
  
    #     result = None
    #     if 'StatusCode' in response and response['StatusCode'] == 200:
  
    #         # レスポンス読出し
    #         Payload = json.loads(response['Payload'].read())
    #         print("---03: body:", Payload)
    #         res = Payload
  
    #   except Exception as err:
    #       # return error_handling(inspect.currentframe().f_code.co_name, err)
    #       logger.debug(err)
    #       # 例外の再送出
    #       raise
  
    #   return res
    
    def update_user_infrastructure_m_entry_site_questionnaire_manage_confirmed(self,item,row_num=0,delete_flg=False):
      logger.info('update_user_infrastructure_m_entry_site_questionnaire_manage_confirmed!!!')
  
      res = {}
      print('-----------------------')
      logger.info(item)
      print('-----------------------')
  
      try:
        MESQMC = GV.get_module('m_entry_site_questionnaire_manage_confirmed')
        m_esqmc = MESQMC()

        record = {}
        # 'システムID'
        record["system_id"] = item["システムID"]
        # 'アンケートの場所'
        record["questionnaire_location"] = 'workshop'
        # 'アンケート質問'
        record["questionnaire_question"] = item["アンケート質問"]
        # 'アンケート回答選択肢'
        record["questionnaire_answer_choices"] = item['アンケート回答選択肢("|"区切り)']
        # 'アンケート回答タイプ'
        record["questionnaire_anser_type"] = item['アンケート回答タイプ']
        if item['必須項目[必須]'] == '1':
          record["required"] = True
        else:
          record["required"] = False

        if delete_flg:
          # システムIDを指定
          filters = []
          filters.append(m_esqmc.model_class.system_id == GV.SYSTEM_ID)
          filters = and_(*filters)
          tmp_m_esqmc = m_esqmc._get_item_by_filters(filters=filters, get_all=True)
          # レコードを削除
          for tmp_data in tmp_m_esqmc:
            m_esqmc._delete(tmp_data.to_dict())
        
        # レコードを追加
        m_esqmc._add(record)
      except Exception as e:
          logger.debug(e)
          # 例外の再送出
          raise  
    
      pass  
    
    def update_user_infrastructure_m_entry_site_document_request_manage_confirmed(self,item,row_num=0,delete_flg=False):
      logger.info('update_user_infrastructure_m_entry_site_document_request_manage_confirmed!!!')
  
      print('-----------------------')
      logger.info(item)
      print('-----------------------')
  
      try:
        MESDRMC = GV.get_module('m_entry_site_document_request_manage_confirmed')
        m_esdrmc = MESDRMC()

        record = {}
        # 'システムID'
        record["system_id"] = item["システムID"]
        # '資料説明タイトル'
        record["document_request_file_title"] = item["資料説明タイトル"]
        # '資料説明本文'
        record["document_request_file_description"] = item["資料説明本文"]
        # '資料画像URL'
        record["document_request_file_image_url"] = item["資料画像"]
        # '資料URL'
        record["document_request_file_url"] = item["資料ファイル"]

    
        if delete_flg:
          # システムIDでフィルタ
          filters = []
          filters.append(m_esdrmc.model_class.system_id == GV.SYSTEM_ID)
          filters = and_(*filters)
          tmp_m_esdrmc = m_esdrmc._get_item_by_filters(filters=filters, get_all=True)
          # レコードを削除
          for tmp_data in tmp_m_esdrmc:
            m_esdrmc._delete(tmp_data.to_dict())

        # レコードを追加
        m_esdrmc._add(record)
      except Exception as e:
          logger.debug(e)
          # 例外の再送出
          raise  
    
      pass
    
    def update_user_infrastructure_m_entry_site_app_settings_confirmed(self,item,row_num=0,delete_flg=False):
      logger.info('update_user_infrastructure_m_entry_site_app_settings_confirmed!!!')
  
      print('-----------------------')
      logger.info(item)
      print('-----------------------')

      try:
        MESASC = GV.get_module('m_entry_site_app_settings_confirmed')
        m_esasc = MESASC()

        record = {}
        # '申込ポータルサイトアプリ設定ID'
        if item["レコード番号"].strip() == '':
          raise CustomException('MNBSI_CSV_ERR_103', [row_num, 'レコード番号'])
        record["entry_site_app_setting_id"] = item["レコード番号"]
        # 'サプライヤーID'
        if item["サプライヤID"].strip() == '':
          raise CustomException('MNBSI_CSV_ERR_103', [row_num, 'サプライヤID'])
        record["supplier_id"] = item["サプライヤID"]
        # 'システムID'
        record["system_id"] = item["システムID"]
        # 'アプリ表示OnOff'
        # if item["アプリ表示"] == 'Off':
        #   record["app_display_flag"] = False
        # else:
        #   record["app_display_flag"] = True
        # 'アプリ表示名'
        record["app_display_name"] = item["アプリ表示名"]
        # # '個人情報取り扱い'
        # record["handling_of_personal_information"] = item["個人情報取り扱い本文"]
        # 'アプリ説明'
        record["top_app_description"] = item["アプリ説明"]
        # '資料請求OnOff'
        if item['ボタン表示[資料請求]'] == '1':
          record["top_document_request_btn_flag"] = True
        else:
          record["top_document_request_btn_flag"] = False
        # 'フリートライアルOnOff'
        if item['ボタン表示[トライアル]'] == '1':
          record["top_trial_btn_flag"] = True
        else:
          record["top_trial_btn_flag"] = False
        # 'ワークショップOnOff'
        if item['ボタン表示[ワークショップ]'] == '1':
          record["top_workshop_btn_flag"] = True
        else:
          record["top_workshop_btn_flag"] = False
        # '本契約OnOff'
        if item['ボタン表示[本契約]'] == '1':
          record["top_contract_btn_flag"] = True
        else:
          record["top_contract_btn_flag"] = False
        # '資料請求説明'
        record["document_request_descritpion"] = item["資料請求説明"]
        # 'フリートライアル説明'
        record["trial_description"] = item["トライアル説明"]
        # '申込み完了'
        record["trial_application_completed"] = item["トライアル申込み完了"]
        # 'ワークショップ説明'
        record["workshop_description"] = item["ワークショップ説明"]
        # '申込み完了'
        record["workshop_application_completed"] = item["ワークショップ申し込み完了"]
        # 'アンケート説明'
        record["workshop_questionnaire_description"] = item["アンケート説明"]
        # '本契約説明'
        record["contract_description"] = item["本契約説明"]
        # '利用規約のテキスト'
        # record["contract_terms_text"] = item["利用規約"]
        # '申込み完了'
        record["contract_application_completed"] = item["本契約申込み完了"]
        'アプリ画像URL'
        record["top_app_image_url"] = item["アプリ画像"] 
        '利用規約のPDFファイルURL'
        record["contract_terms_file_url"] = item["利用規約(PDF)"]
        # 一覧追加用コード
        record["entry_site_app_setting_registration_code"] = item["一覧追加用コード"]
         # 個人情報の取扱(PDF)
        record["handling_of_personal_information_file_url"] = item["個人情報の取扱(PDF)"]
        # お支払い方法の説明画像URL
        record["payment_method_explanation_image_url"] = item["支払方法の説明画像"]
        print('+++++++++++++++++++++++++++')
        print(record)
        print('+++++++++++++++++++++++++++')
        
        if delete_flg:
          # システムIDでフィルタ
          filters = []
          filters.append(m_esasc.model_class.system_id == GV.SYSTEM_ID)
          filters = and_(*filters)
          tmp_m_esasc = m_esasc._get_item_by_filters(filters=filters, get_all=True)
          # レコードを削除
          for tmp_data in tmp_m_esasc:
            m_esasc._delete(tmp_data.to_dict())

        # レコードを追加
        m_esasc._add(record)
      except Exception as e:
          logger.debug(e)
          # 例外の再送出
          raise  
    
      pass