DEV_ENV = 'prod'

import logging
import os
import json
from sqlalchemy import create_engine, inspect, or_, and_, cast, desc, asc

if DEV_ENV == 'local':
    from .lambda_function import DEV_ENV, GV, CustomException
    # from .env import *
    from .entra_component import *
else:
    from lambda_function import DEV_ENV, GV, CustomException
    # from env import *
    from entra_component import *

logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

class Sub:

    table_name = 'base_auth0'

    auth0 = None
    auth0Users = None

    def __init__(self):
        # Users管理クライアントインスタンスを作成する

        # get_token = GetToken(
        #     AUTH0_DOMAIN, AUTH0_CLIENT_ID, AUTH0_CLIENT_SECRET)
        # token_response = get_token.client_credentials(AUTH0_AUDIENCE)
        # mgmt_api_token = token_response['access_token']

        # self.auth0 = Auth0(AUTH0_DOMAIN, mgmt_api_token)
        # self.auth0Users = Users(AUTH0_DOMAIN, mgmt_api_token)
        """
        get_token = GetToken(
            GV.CONFIG['AUTH0_DOMAIN'], GV.CONFIG['AUTH0_CLIENT_ID'], GV.CONFIG['AUTH0_CLIENT_SECRET'])
        token_response = get_token.client_credentials(GV.CONFIG['AUTH0_AUDIENCE'])
        mgmt_api_token = token_response['access_token']

        self.auth0 = Auth0(GV.CONFIG['AUTH0_DOMAIN'], mgmt_api_token)
        self.auth0Users = Users(GV.CONFIG['AUTH0_DOMAIN'], mgmt_api_token)
        """
        logger.debug('base_auth0_init')

        # auth0UserList = auth0Users.list(
        #     q = "user_metadata.companys.name:company1",
        # )
        # print('auth0UserList---------------------------------')
        # print(auth0UserList)


    def _get_users_by_email(self, email):

        ##################################################
        # Entra置き換え 
        ##################################################
        #users = self.auth0.users_by_email.search_users_by_email(email)
        print(f'email, {email}')
        entra = EntraComponet()
        params = GetUsersByEmailParam()
        params.email = email
        users = entra.get_users_by_email(params)

        print(users)

        return users

        pass

    # 新しいユーザーを作成する
    def _add(self, user_data):
        print('--------------- _add')
        print(user_data)

        try:

            '''
            default_data = {
                # "email": email,
                # "password": password,
                "blocked": False,
                "connection": "Username-Password-Authentication",  # ユーザー名-パスワード認証を使用する
                # "email_verified": False,
                "verify_email": False,
            }

            user_data.update(default_data)

            print(user_data)

            created_user = self.auth0.users.create(user_data)
            '''

            ##################################################
            # Entra置き換え 
            ##################################################
            entra = EntraComponet()
            params1 = CreateUserParam()
            print(f'user_Data, {user_data.keys()}')
            params1.user_id = user_data['user_id']
            params1.email = user_data['email']
            params1.username = user_data['username']
            params1.password = user_data['password']
            
            created_user = entra.create_user(params1)
            
            param_TIU = {}
            param_TIU['id'] = created_user['id']
            update_flg = False
            if 'user_metadata' in user_data:
                param_TIU['user_metadata'] = json.dumps(user_data['user_metadata'])
                update_flg = True
                for data in user_data['user_metadata']['data']:
                    if data['activedirectory_username'] is not None:
                        param_TIU['appstream'] = data['activedirectory_username']
            if 'app_metadata' in user_data:
                param_TIU['app_metadata'] = json.dumps(user_data['app_metadata'])
                update_flg = True
            if 'blocked' in user_data:
                param_TIU['blocked'] = user_data['blocked']
                update_flg = True
            if 'email' in user_data:
                param_TIU['email'] = user_data['email']
                update_flg = True
            if 'email_verified' in user_data:
                param_TIU['email_verified'] = user_data['email_verified']
                update_flg = True
            if 'family_name' in user_data:
                param_TIU['family_name'] = user_data['family_name']
                update_flg = True
            if 'given_name' in user_data:
                param_TIU['given_name'] = user_data['given_name']
                update_flg = True
            if 'name' in user_data:
                param_TIU['name'] = user_data['name']
                update_flg = True
            if 'nickname' in user_data:
                param_TIU['nickname'] = user_data['nickname']
                update_flg = True
            if 'password' in user_data:
                param_TIU['password'] = user_data['password']
                update_flg = True
            if 'phone_number' in user_data:
                param_TIU['phone_number'] = user_data['phone_number']
                update_flg = True
            if 'phone_verified' in user_data:
                param_TIU['phone_verified'] = user_data['phone_verified']
                update_flg = True
            if 'picture' in user_data:
                param_TIU['picture'] = user_data['picture']
                update_flg = True
            if 'username' in user_data:
                param_TIU['username'] = user_data['username']
                update_flg = True
            if 'verify_email' in user_data:
                param_TIU['verify_email'] = user_data['verify_email']
                update_flg = True
            if 'tenant' in user_data:
                param_TIU['tenant'] = user_data['tenant']
                update_flg = True

            print("ユーザーが作成されました:", created_user)
            if update_flg:
                TIU = GV.get_module('t_invitation_user')
                add_TIU = TIU()
                logger.debug(TIU)
                logger.debug(param_TIU)
                add_TIU._add(param_TIU)
                print("ユーザーデータをDBに保存ました")
            else:
                print("ユーザーデータは付加していません")
            
            return created_user

        except Exception as e:
            print(e)
            # 例外の再送出
            raise
        pass

    # ユーザーを更新する
    def _update(self, user_id, user_data):
        print('--------------- _update')
        print(user_id)
        print(user_data)
        id = self._get_users_by_email(user_id)[0]['id']
        logger.debug(id)
        entra = EntraComponet()
        check = entra.check_invitation_user(user_id)
        ##################################################
        # Entra置き換え 
        ##################################################
        #updated_user = self.auth0.users.update(user_id, user_data)
        if check == '':
            updated_user = {'user_id': user_id, 'mail': user_id}
            #認証されていたないからDB保存
            print('MS未認証')
            param_TIU = {}
            param_TIU['id'] = id
            update_flg = False
            if 'user_metadata' in user_data:
                param_TIU['user_metadata'] = json.dumps(user_data['user_metadata'])
                update_flg = True
                for data in user_data['user_metadata']['data']:
                    if data['system_id'] == 'SYS00001':
                        param_TIU['appstream'] = data['activedirectory_username']
            if 'app_metadata' in user_data:
                param_TIU['app_metadata'] = json.dumps(user_data['app_metadata'])
                update_flg = True
            if 'blocked' in user_data:
                param_TIU['blocked'] = user_data['blocked']
                update_flg = True
            if 'email' in user_data:
                param_TIU['email'] = user_data['email']
                update_flg = True
            if 'email_verified' in user_data:
                param_TIU['email_verified'] = user_data['email_verified']
                update_flg = True
            if 'family_name' in user_data:
                param_TIU['family_name'] = user_data['family_name']
                update_flg = True
            if 'given_name' in user_data:
                param_TIU['given_name'] = user_data['given_name']
                update_flg = True
            if 'name' in user_data:
                param_TIU['name'] = user_data['name']
                update_flg = True
            if 'nickname' in user_data:
                param_TIU['nickname'] = user_data['nickname']
                update_flg = True
            if 'password' in user_data:
                param_TIU['password'] = user_data['password']
                update_flg = True
            if 'phone_number' in user_data:
                param_TIU['phone_number'] = user_data['phone_number']
                update_flg = True
            if 'phone_verified' in user_data:
                param_TIU['phone_verified'] = user_data['phone_verified']
                update_flg = True
            if 'picture' in user_data:
                param_TIU['picture'] = user_data['picture']
                update_flg = True
            if 'username' in user_data:
                param_TIU['username'] = user_data['username']
                update_flg = True
            if 'verify_email' in user_data:
                param_TIU['verify_email'] = user_data['verify_email']
                update_flg = True
            if 'tenant' in user_data:
                param_TIU['tenant'] = user_data['tenant']
                update_flg = True

            if update_flg:
                TIU = GV.get_module('t_invitation_user')
                add_TIU = TIU()
                filters = []
                filters.append(add_TIU.model_class.id == id) 
                filters = and_(*filters)
                get_data = add_TIU._get_item_by_filters(filters)
                if get_data is None:
                    print('テーブルにデータなし')
                    logger.debug(TIU)
                    logger.debug(param_TIU)
                    add_TIU._add(param_TIU)
                    print("ユーザーデータをDBに保存ました")
                else:
                    print('テーブルにデータあり')
                    logger.debug(TIU)
                    logger.debug(param_TIU)
                    add_TIU._update(param_TIU)
                    print("ユーザーデータをDBに保存ました")
        else:
            entra = EntraComponet()
            params = UpdateUserParam()
            logger.debug(user_data)
            params.id = id
            if 'user_metadata' in user_data:
                params.user_metadata = user_data['user_metadata']
                for data in user_data['user_metadata']['data']:
                    if data['activedirectory_username'] is not None:
                        params.appstream = data['activedirectory_username']
            if 'app_metadata' in user_data:
                params.app_metadata = user_data['app_metadata']
            if 'blocked' in user_data:
                params.blocked = user_data['blocked']
            if 'email' in user_data:
                params.email = user_data['email']
            if 'email_verified' in user_data:
                params.email_verified = user_data['email_verified']
            if 'family_name' in user_data:
                params.family_name = user_data['family_name']
            if 'given_name' in user_data:
                params.given_name = user_data['given_name']
            if 'name' in user_data:
                params.name = user_data['name']
            if 'nickname' in user_data:
                params.nickname = user_data['nickname']
            if 'password' in user_data:
                params.password = user_data['password']
            if 'phone_number' in user_data:
                params.phone_number = user_data['phone_number']
            if 'phone_verified' in user_data:
                params.phone_verified = user_data['phone_verified']
            if 'picture' in user_data:
                params.picture = user_data['picture']
            if 'username' in user_data:
                params.username = user_data['username']
            if 'verify_email' in user_data:
                params.verify_email = user_data['verify_email']
    
            updated_user = entra.update_user(params)
        
        entra_2 = EntraComponet()
        params_2 = GetUserParam()
        params_2.id = id
        entra_2.set_app_to_user(params_2)

        print("ユーザーが更新されました:", updated_user)
        return updated_user
        pass

    ##################################################
    # 変更なし
    ##################################################
    def get_table_schema(self):

        custom_column_info = None
        with open(f'{GV.CUR_PATH}/config/{self.table_name}.json', encoding='utf-8') as f:
            custom_column_info = json.load(f)
            print(custom_column_info)

        return custom_column_info

    def _get_logs(self, query=None):
        print('_get_logs')

        ##################################################
        #ライセンス必要なため画面からダウンロードで当面回避する
        ##################################################

        #res = self.auth0.logs.search(q=query)

        return res

        pass
    
    def _search_user(self, query=None):
        print('_search_user')

        ##################################################
        # Entra置き換え 
        ##################################################
        #res = self.auth0.users.list(q=query)
         #Queryが存在する場合、辞書型に変換する
        
        if len (query) != 0 :
            query_split=query.split(":")
            key_split=str(query_split[0]).split(".")
            #app_metadata.data.staff_req_verification_codeの最後を指定　key_split[2]
            print(key_split[0])
            print(key_split)
            query_dic={key_split[2]:(str(query_split[1]).strip()).strip('"')}
            print(query_dic)
        params = {
                    'table_name': 't_invitation_user',
                    'filters': {}
                }
        get_TIU = GV.get_module('t_invitation_user')
        users = get_TIU()
        filter = []
        filters = and_(*filter)
        get_user = users._get_item_by_filters(filters, get_all=True)
        logger.debug(get_user)
        users_list = []
        for i in get_user:
            dic_i = i.to_dict()
            users_list.append(dic_i)
        logger.debug(users_list)

        auth_list = []
        print('users_list',users_list[0])
        print(type(users_list[0]))
        for user_dic in users_list:
            try:
                user_dic['app_metadata'] = json.loads(user_dic['app_metadata'])
            except:
                user_dic['app_metadata'] = user_dic['app_metadata']
            try:
                user_dic['user_metadata'] = json.loads(user_dic['user_metadata'])
            except:
                user_dic['user_metadata'] = {'data': []}
            user_dic['user_id'] = user_dic['email']
            #検索Query文字列が存在する場合
            if len (query) != 0 :
                print('検索Query文字列が存在する場合')
                target_item = user_dic[key_split[0]]
                print(target_item)
                if (type(target_item) is str):
                    print('文字列の場合')
                    target_item = json.loads(target_item)
                #値が存在する場合
                if target_item and (key_split[1] in target_item):
                    print('値が存在する場合')
                    print(target_item)
                    target_data = target_item[key_split[1]]
                    print(target_data)
                    target_dic=dict(target_data[0]) #もしかしてループにする必要あり？
                    print('target_dic', target_dic)
                    print('target_item', target_item)      
                    print('target_data', target_data)
                    print('キーでループ')
                    if key_split[2] in target_dic:
                        target_value=target_dic[key_split[2]]
                        #指定したKEY/VALUEが一致するか？     
                        if (target_value == query_dic[key_split[2]]):
                            print("Find user data matching query")
                            #ユーザリストに追加する
                            auth_list.append(user_dic)
                            user_dic={}
                    
            else :
                #すべてのユーザデータが対象
                #ユーザリストに追加する     
                auth_list.append(auth_dic)
                auth_dic={}
        print('DB終了', auth_list)  

        if (auth_list == []):
            print('metadata確認')
            entra = EntraComponet()
            entra_users = entra.get_user_list(GetUsersParam())
            for user_dic in entra_users:
                try:
                    user_dic['app_metadata'] = json.loads(user_dic['app_metadata'])
                except:
                    user_dic['app_metadata'] = user_dic['app_metadata']
                try:
                    user_dic['user_metadata'] = json.loads(user_dic['user_metadata'])
                except:
                    user_dic['user_metadata'] = user_dic['user_metadata']
                user_dic['user_id'] = user_dic['email']
                #検索Query文字列が存在する場合
                if len (query) != 0 :
                    print('検索Query文字列が存在する場合')
                    target_item = user_dic[key_split[0]]
                    print(target_item)
                    if (type(target_item) is str):
                        print('文字列の場合')
                        print('target_item',target_item)
                        print(len(target_item))
                        if len(target_item)==0:
                            continue
                        target_item = json.loads(target_item)
                    #値が存在する場合
                    if target_item and (key_split[1] in target_item):
                        print('値が存在する場合')
                        print(target_item)
                        target_data = target_item[key_split[1]]
                        print(target_data)
                        if target_data == []:
                            print('[]ならcontinue')
                            continue
                        for t_data in target_data:
                            target_dic=dict(t_data) #もしかしてループにする必要あり？
                            print('target_dic', target_dic)
                            print('target_item', target_item)      
                            print('t_data', t_data)
                            print('キーでループ')
                            if key_split[2] in target_dic:
                                target_value=target_dic[key_split[2]]
                                #指定したKEY/VALUEが一致するか？     
                                if (target_value == query_dic[key_split[2]]):
                                    print("Find user data matching query")
                                    #ユーザリストに追加する
                                    auth_list.append(user_dic)
                                    user_dic={}
                        
                else :
                    #すべてのユーザデータが対象
                    #ユーザリストに追加する     
                    auth_list.append(auth_dic)
                    auth_dic={}
            print('entra終了', auth_list)  
        entra_2 = EntraComponet()
        check = entra_2.check_invitation_user(auth_list[0]['email'])
        if check == '':
            return ''
        print('return auth_list',auth_list)
        return {'users': auth_list}

        pass


# # メインプログラム
# if __name__ == "__main__":
#     # search_users('user_metadata.companys.name:company1')
#     # search_users()
#     api = Auth0API()
#     api.get_all()

#     # # ユーザーを作成する
#     # email = "test@example.com"
#     # password = "Test1234!"
#     # create_user(email, password)

#     # # ユーザーIDを取得する（実際に作成されたユーザーのIDに置き換える）
#     # user_id = "auth0|1234567890"

#     # # ユーザー情報を読み込む
#     # get_user(user_id)

#     # # ユーザーのメールアドレスを更新する
#     # new_email = "new_email@example.com"
#     # update_user(user_id, new_email)

#     # # ユーザーを削除する
#     # delete_user(user_id)
