import base64
import calendar
import copy
from dataclasses import dataclass
import dataclasses
import json
import math
import string
import sys
import random
import datetime

import boto3
import os

import psycopg2

import common_func as cf
import subprocess
import datetime
import configparser
from collections import defaultdict, Counter
from operator import itemgetter
import configparser

# フェーズ2 ------------------------S
from decimal import Decimal, ROUND_HALF_UP
# フェーズ2 ------------------------E

#課金情報取得API

# 設定ファイル
config = configparser.ConfigParser()
config.read('./setting.cfg', 'UTF-8')

SETTING_BUCKET_NAME = config['S3']['BUCKET_NAME']
# BUCKET_NAME = '{env}-lam-new-reports-get-965166023933'
# OBJECT_KEY_NAME = 'billing-infrastructure/setting/smartbilling_setting.json'
s3_base_path = 'billing-infrastructure/charges/Daily'
s3_log_path = 'billing-infrastructure/logs/charges'
file_name_h = 'simsp_cloud_used_'

#program_path = '/opt/app/MSCOneProject'        # Linux
program_path = os.getcwd()
s3 = boto3.resource('s3')

# ログの初期設定を行う
_logger = cf.setup_logger()

#_logger.info('ログ出力のテストだよ！INFO')
#_logger.error('ログ出力のテストだよ！ERROR')

def i_print(str):
    print(str)
    _logger.info(str)

def e_print(str):
    print(str)
    _logger.error(str)

i_print('開始 ' + ' ' + os.path.basename(__file__))


# 設定情報取得
try:
    i_print('[設定情報取得]============================================================')
    setting_bucket = s3.Bucket(SETTING_BUCKET_NAME)
    api_id = None
    api_pass = None
    content_type = None
    tenant_id = None
    url = None
    proxiy_settings = None
    headers = None
    proxies = None
     # bucket = s3.Bucket(BUCKET_NAME.replace("{env}", sys.argv[1]))
#     obj = setting_bucket.Object(OBJECT_KEY_NAME)
#     #i_print(bucket)
#     response = obj.get()
#     body = response['Body'].read()
#     #i_print(body)
#     settings = json.loads(body.decode('utf-8'))
#     smartbilling_settings = settings['smartbilling']
#     proxiy_settings = settings['proxies']
#     #datamart_settings = settings['datamart_host']

#     api_id = settings['smartbilling']['api_id']
#     api_pass = settings['smartbilling']['api_pass']
#     content_type = settings['smartbilling']['Content-Type']
#     tenant_id = settings['smartbilling']['X-SmartBilling-TenantId']
#     # カタログ情報（通常商品）検索（料⾦情報履歴取得）
#     url = settings['smartbilling']['url']

#     i_print('api_id : ' + api_id)
#     i_print('api_pass : ' + api_pass)
#     i_print('content_type : ' + content_type)
#     i_print('tenant_id : ' + tenant_id)
#     i_print('url : ' + url)
#     i_print('http : ' + proxiy_settings['http'] + ':80')
#     i_print('https : ' + proxiy_settings['https'] + ':443')
    i_print('datamart DBHOST : ' + config['DATAMART']['DB_HOST'] )
    i_print('datamart DBNAME : ' + config['DATAMART']['DB_NAME'] )
    i_print('datamart DBPORT : ' + config['DATAMART']['DB_PORT'] )
    i_print('datamart DBUSER : ' + config['DATAMART']['DB_USER'])
    i_print('datamart DBPASSWORD : ' + config['DATAMART']['DB_PASSWORD'] )


#     # proxy設定
#     proxies = {
#         'http': proxiy_settings['http'],
#         'https': proxiy_settings['https']
#     }
#     # setting proxy to smartbilling
#     proxy_http = 'http://' + proxiy_settings['http'] + ':80'
#     auth_key_encoded = base64.b64encode('{}:{}'.format(api_id, api_pass).encode('utf-8'))
#     ##header設定
#     headers = {'Content-Type': content_type
#         , 'X-SmartBilling-TenantId': tenant_id}
    i_print('[設定情報取得完了]============================================================')
except Exception as e:
    e_print('設定の読み込みに失敗しました。')
    e_print('call api: subscriptionSubscriptionIdGet end')
    e_print(e.args)
    e_print('終了 ' + ' ' + os.path.basename(__file__))

    sys.exit()



# def get_datamart(target_date):
#     # Get datamart(select view)
#     try:
#         data = {}
#         data['target_date'] = target_date
#         # 企業コードの取得 pre-post
#         sql_company = """
#                 WITH query as(
#                     SELECT *
# 	                FROM public.billing_prepost_license_used_day_before_1year
# 	                where start_day = %(target_date)s
#                 ), tab as( 
#                 SELECT co.company_code,
#                     co.company_name,
#                     co.company_name_kana
#                 FROM ( SELECT DISTINCT query.project_id
#                         FROM query) sol
#                     JOIN red_dwh_001_public_mscone_lic_user_infrastructure_m_company co ON co.company_code = sol.project_id
#                 )
#                 select to_json(tab) 
#                 from tab;
#                     """
#         # テスト用
#         #sql_company = """
#         #    select to_json(red_dwh_001_public_mscone_lic_user_infrastructure_m_company)
#         #    from public.red_dwh_001_public_mscone_lic_user_infrastructure_m_company;
#         #    """
#         i_print('[利用量情報取得開始]============================================================')
#         i_print("プリポストを使用した企業を取得開始")
#         i_print("query Get use_prepost m_company start")
#         cur = cf.mscone_query_env(sql_company,  
#                                     config['DATAMART']['DB_NAME'],
#                                     config['DATAMART']['DB_HOST'],
#                                     config['DATAMART']['DB_USER'],
#                                     config['DATAMART']['DB_PASSWORD'],
#                                     config['DATAMART']['DB_PORT'],
#                                     data)
#         i_print(cur)

#         i_print("query Get use_prepost m_company end")
#         i_print("プリポストを使用した企業を取得完了")

#         # 企業コードの取得
#         sql_company_solver = """
#                 WITH query as(
#                 SELECT *
#                     FROM public.billing_solver_server_used_day_before_1year
#                     where start_day = %(target_date)s
#                 ), tab as( 
#                 SELECT co.company_code,
#                     co.company_name,
#                     co.company_name_kana
#                 FROM ( SELECT DISTINCT query.company_code
#                         FROM query) sol
#                     JOIN red_dwh_001_public_mscone_lic_user_infrastructure_m_company co ON co.company_code = sol.company_code
#                 )
#                 select to_json(tab) 
#                 from tab;
#             """
#         i_print("ソルバーを使用した企業を取得開始")
#         i_print("query Get use_solver m_company start")
#         cur_solver = cf.mscone_query_env(sql_company_solver,  
#                                         config['DATAMART']['DB_NAME'],
#                                         config['DATAMART']['DB_HOST'],
#                                         config['DATAMART']['DB_USER'],
#                                         config['DATAMART']['DB_PASSWORD'],
#                                         config['DATAMART']['DB_PORT'],
#                                         data)
#         i_print(cur_solver)

#         i_print("query Get use_solver m_company end")
#         i_print("ソルバーを使用した企業を取得完了")
        
#         if len(cur) + len(cur_solver) == 0:
#             i_print("利用企業無し。")
#             return {'statusCode': 200,
#                     'message': '対象データがありませんでした。'}
#         result_co = []
#         billing_info = {}
#         company_code_check_list = []
#         #print('len(cur) OK')
#         i_print("利用料登録対象企業の企業情報取得開始")
#         # Get customerId
#         for row in cur:
#             info = {}
#             if row[0]['company_code'] not in company_code_check_list:
#                 company_code_check_list.append(row[0]['company_code'])
#                 info['company_code'] = row[0]['company_code']
#                 #print('company_code OK')
#                 info['company_name'] = row[0]['company_name']
#                 #print('company_name OK')
#                 info['company_name_kana'] = row[0]['company_name_kana']
#                 #print('company_name_kana OK')
#                 # 課金情報の取得
#                 i_print('SmartBillingから情報取得開始：' + info['company_name'])
#                 tp = get_smartbilling(info)
#                 if 'statusCode' in  tp and tp['statusCode'] == 400:
#                     e_print('SmartBillingとの通信に失敗しました。status:400')
#                     raise
#                 #print('tp OK')
#                 if len(tp) == 0:
#                     i_print('[faild] Smartbillingから対象のデータが取得できませんでした。。customerId: ' + info['company_code'])
#                 else:
#                     i_print('return billing_info')
#                     billing_info = tp
#                     i_print(billing_info)
#                     i_print('SmartBillingから情報取得完了：' + info['company_name'])
#                     result_co.append(billing_info)
#         # Get customerId
#         for row in cur_solver:
#             info = {}
#             if row[0]['company_code'] not in company_code_check_list:
#                 company_code_check_list.append(row[0]['company_code'])
#                 info['company_code'] = row[0]['company_code']
#                 #print('company_code OK')
#                 info['company_name'] = row[0]['company_name']
#                 #print('company_name OK')
#                 info['company_name_kana'] = row[0]['company_name_kana']
#                 #print('company_name_kana OK')
#                 # 課金情報の取得
#                 i_print('SmartBillingから情報取得開始：' + info['company_name'])
#                 tp = get_smartbilling(info)

#                 if 'statusCode' in  tp and tp['statusCode'] == 400:
#                     e_print('SmartBillingとの通信に失敗しました。status:400')
#                     raise
#                 #print('tp OK')
#                 if len(tp) == 0:
#                     i_print('[faild] Smartbillingから対象のデータが取得できませんでした。。customerId: ' + info['company_code'])
#                 else:
#                     i_print('return billing_info')
#                     billing_info = tp
#                     i_print(billing_info)
#                     i_print('SmartBillingから情報取得完了：' + info['company_name'])
#                     result_co.append(billing_info)
#         #print('result_co')
#         #print(result_co)
#         #print(len(result_co))
#             #if 'statusCode' in tp['statusCode']:
#             #    print('statusCode: ' + tp['statusCode'])
#             #    print('Smartbillingからの企業情報の取得ができませんでした。処理を中止します。')
#             #    return {
#             #        'statusCode': 400,
#             #        'body': json.dumps('error!')
#             #    }

#         """
#         # Test Start
#         info = {}
#         info['company_code'] = '999998'
#         info['company_name'] = '株式会社アイ・エス・テクノロジー'
#         info['company_name_kana'] = 'カブシキカイシャアイエステクノロジー'
#         # 課金情報の取得
#         billing_info = get_smartbilling(info)
#         #billing_info['company_code'] = row[0]['company_code']
#         result_co.append(billing_info)
#         # Test End
#         """
#         # プリポスト―使用履歴取得
#         sql_prepost = """
#                 WITH tab as (
#                     SELECT *
#                         FROM public.billing_prepost_license_used_day_before_1year
#                         where start_day = %(target_date)s
# 					)
# 					select to_json(tab)
#                 	from tab
#                 """
#         i_print("プリポストの利用量を取得開始")
#         i_print("pre-post query start")
#         cur = cf.mscone_query_env(sql_prepost,
#                                     config['DATAMART']['DB_NAME'],
#                                     config['DATAMART']['DB_HOST'],
#                                     config['DATAMART']['DB_USER'],
#                                     config['DATAMART']['DB_PASSWORD'],
#                                     config['DATAMART']['DB_PORT'],
#                                     data)     
#         i_print(cur)
#         i_print("pre-post query end")
#         i_print("プリポストの利用量を取得完了")
#         # ソルバー―使用履歴取得
#         sql_solver = """
#                 WITH tab as (
#                     SELECT *
#                         FROM public.billing_solver_server_used_day_before_1year
#                         where start_day = %(target_date)s
# 					)
# 					select to_json(tab)
#                 	from tab
#                 """
#         i_print("ソルバーの利用量を取得開始")
#         i_print("solver query start")
#         cur_solver = cf.mscone_query_env(sql_solver,
#                                         config['DATAMART']['DB_NAME'],
#                                         config['DATAMART']['DB_HOST'],
#                                         config['DATAMART']['DB_USER'],
#                                         config['DATAMART']['DB_PASSWORD'],
#                                         config['DATAMART']['DB_PORT'],
#                                         data)
#         i_print("solver query end")
#         i_print("ソルバーの利用量を取得完了")

#         ## 契約商品情報取得

#         #プリポストとソルバーのデータをがっさんする
#         #ソルバーの取得データの形式をプリポストにそろえる
#         print('ソルバーの取得データの形式をプリポストにそろえる')
#         i_print('プリポスト・ソルバーのデータ形式の統合開始')
#         usage_list_tmp = []
#         for  row in cur_solver:
#             #カラム名をそろえる
#             tmp = {'user_email':'solver'}
#             tmp['project_id'] = row[0]['company_code']
#             tmp['user_email'] = row[0]['username']
#             tmp['product_id'] = row[0]['product']
#             tmp['start_day'] = row[0]['start_day']
#             tmp['start_time'] = row[0]['start_time']
#             tmp['end_day'] = row[0]['end_day']
#             tmp['end_time'] = row[0]['end_time']
#             tmp['date_time'] = row[0]['date_time']
#             tmp['explanation'] = row[0]['explanation']
#             tmp['duration_mm'] = row[0]['duration_mm']
#             print(tmp)
#             usage_list_tmp.append(tmp)
#             #tmp_taple = tuple(tmp_list)
#             #cur.append(tmp_taple)
#         #プリポストの取得データusage_listに追加
#         print('プリポストの取得データusage_listに追加')
#         for row in cur:
#             tmp = {}
#             tmp['project_id'] = row[0]['project_id']
#             tmp['user_email'] = row[0]['user_email']
#             tmp['product_id'] = row[0]['product_id']
#             tmp['start_day'] = row[0]['start_day']
#             tmp['start_time'] = row[0]['start_time']
#             tmp['end_day'] = row[0]['end_day']
#             tmp['end_time'] = row[0]['end_time']
#             tmp['date_time'] = row[0]['date_time']
#             tmp['explanation'] = row[0]['explanation']
#             tmp['duration_mm'] = row[0]['duration_mm']
#             print(tmp)
#             usage_list_tmp.append(tmp)
#             #tmp_taple = tuple(tmp_list)
#             #cur.append(tmp_taple)
#         i_print('プリポスト・ソルバーのデータ形式の統合完了')

#         #usage_list_tmpから同じ企業コード、アプリケーション、日にちのものがあるかチェックし、
#         #有れば利用時間の加算、無ければ要素の追加をする。
#         print('usage_list_tmpから同じ企業コード、アプリケーション、日にちのものがあるかチェック')
#         i_print('同じ企業コード、アプリケーション、日にちのプリポスト・ソルバーの利用量合算開始')
#         usage_list_dic = {}
#         for usage in usage_list_tmp:
#                 print(usage)
#                 if usage['project_id'] not in usage_list_dic:
#                     print('OK')
#                     usage_list_dic[usage['project_id']] = {}
#                 if usage['application_name'] not in usage_list_dic[usage['project_id']]:
#                     print('OK')
#                     usage_list_dic[usage['project_id']][usage['application_name']] = usage
#                 else:
#                     usage_list_dic[usage['project_id']][usage['application_name']]['duration_mm'] = usage_list_dic[usage['project_id']][usage['application_name']]['duration_mm'] + usage['duration_mm']
#                 print('OKOK')
#                 print(usage_list_dic)
#         i_print(usage_list_dic)
#         #usage_list_dicをcurに置き換え
#         #list(tuple{dic})の形式
#         tmp_cur = []
#         for usage_list_key in usage_list_dic:
#             for usage_app in usage_list_dic[usage_list_key]:
#                 tmp_dic = {}
#                 tmp_list = []
#                 tmp_dic['project_id'] = usage_list_key
#                 tmp_dic['user_email'] = usage_list_dic[usage_list_key][usage_app]['user_email']
#                 tmp_dic['application_name'] = usage_app
#                 tmp_dic['start_day'] = usage_list_dic[usage_list_key][usage_app]['start_day']
#                 tmp_dic['start_time'] = usage_list_dic[usage_list_key][usage_app]['start_time']
#                 tmp_dic['end_day'] = usage_list_dic[usage_list_key][usage_app]['end_day']
#                 tmp_dic['end_time'] = usage_list_dic[usage_list_key][usage_app]['end_time']
#                 tmp_dic['date_time'] = usage_list_dic[usage_list_key][usage_app]['date_time']
#                 tmp_dic['explanation'] = usage_list_dic[usage_list_key][usage_app]['explanation']
#                 tmp_dic['duration_mm'] = -(-usage_list_dic[usage_list_key][usage_app]['duration_mm'] // 60)#分に変換　切り上げ
#                 tmp_dic['amount'] = usage_list_dic[usage_list_key][usage_app]['amount']
#                 tmp_list.append(tmp_dic)
#                 tmp_taple = tuple(tmp_list)
#                 tmp_cur.append(tmp_taple)
#         cur = tmp_cur
#         i_print(cur)
#         i_print('同じ企業コード、アプリケーション、日にちのプリポスト・ソルバーの利用量合算完了')
#         result = []
#         cnt = 1
#         #for row in cur:
#         i_print('利用量ファイルの形式にデータ成型開始')
#         for row in cur:
#             info = {}
#             for co in result_co:
#                 i_print(co)
#                 if row[0]['project_id'] == co['company_code']:
#                     for bil in co['billings']:
#                         if row[0]['application_name'] == bil['additionalText07']:
#                             info['通番'] = cnt  # 通番
#                             info['課金ID'] = bil['chargingId']   # 課金ID
#                             info['開始日'] = row[0]['start_day']  # 開始日
#                             info['開始時刻'] = row[0]['start_time'] # 開始時刻
#                             info['終了日'] = row[0]['end_day']  # 終了日
#                             info['終了時刻'] = row[0]['end_time'] # 終了時刻
#                             info['発生日時'] = row[0]['date_time'] # 発生日時
#                             info['説明'] = row[0]['explanation']   # 説明
#                             info['利用量'] = row[0]['duration_mm']  # 利用量
#                             result.append(info)
#                             cnt += 1
#         i_print(result)
#         i_print('利用量ファイルの形式にデータ成型完了')
#     except Exception as e:
#         e_print('Datamartの取得に失敗しました。')
#         e_print(e.args)
#         raise
#         return

#     # SmartbillingにUpload
#     # 一時保存場所
#     filepath = program_path + '/tmp/'
#     try:
#         i_print('CSVファイル作成開始')
#         # CSV絶対パス作成
#         file_name = cf.create_local_fulpath(filepath, 'pre', target_date).replace('prepost', 'license')
#         i_print('file_name = ' + file_name)
#         # CSV作成
#         cf.create_csv_at_list_dic(result, file_name)
#         # S3に保存
#         # s3 path check & Create + 年と月を取得
#         path = cf.create_s3_key(s3_base_path)
#         setting_bucket.upload_file(file_name, path + cf.creat_file_name('pre', target_date).replace('prepost', 'license'))
#         i_print('CSVの作成に成功しました。')
#     except Exception as e:
#         e_print('CSVの作成に失敗しました。')
#         e_print(e.args)
#         raise
#         return
#     i_print('CSVファイル作成完了')

#     # Smartbilling Upload
    
#     try:
#         i_print('課金情報ファイル登録開始')
#         #file_name = '/opt/app/MSCOneProject/tmp/billing_solver_msc_lic_20220409.csv'
#         chargeType = '利用量'
#         sourceService = 'MSCOneサービス'
#         url_bill = url + '/charges/fileUpload'
#         print('----------------------------------------------------------')
#         #print('auth_key_encoded: ' + auth_key_encoded)
#         #print('path: ' + file_name)
#         #print('tenant_id: ' + tenant_id)
#         #print('url_bill: ' + url_bill)
#         #print('proxy_http: ' + proxy_http)
#         #print('chargeType: ' + chargeType)
#         #print('sourceService: ' + sourceService)
#         res = cf.post(auth_key_encoded, file_name, tenant_id, url_bill, proxy_http, chargeType, sourceService)
#         #print(res.json())
#         print('----------------------------------------------------------')
#         i_print('課金情報ファイル登録完了')
#     except Exception as e:
#         print('課金情報ファイルのアップロードに失敗しました。')
#         print(e.args)
#         raise
#         return
    
#     print('calling api:' + sys.argv[0] + ' end')
#     return {
#         'statusCode': 200,
#         #'body': json.dumps(data_charges, ensure_ascii=False)
#     }
    
def get_smartbilling(info):
    info_billing = {}
    info_billing['company_code'] = info['company_code']
    # 顧客検索
    try:
        i_print('[顧客情報取得]================================================')
        # 検索条件
        params = {
            "limit": 100,
            "offset": 0,
            "customerName ": info['company_name'],
            "kanaCharacters": info['company_name_kana'],
            "additionalText2": info['company_code']
            #"additionalText2": '999998'
        }

        url_sub = url + '/customers'
        i_print('----------------------------------------------------------')
        i_print('limit: ' + str(params['limit']))
        i_print('offset: ' + str(params['offset']))
        i_print('customerName: ' + info['company_name'])
        i_print('kanaCharacters: ' + info['company_name_kana'])
        i_print('url_sub: ' + url_sub)
        res = cf.get_api(url_sub, params, headers, proxies, api_id, api_pass)
        data = res.json()
        i_print(data)
        if data['total'] == 0:
            info_billing['statusCode'] = 400
            return info_billing
        else:
            for key in data['customers']:
                i_print(key)
                i_print('顧客ID: ' + key['customerId'])
                customerId = key['customerId']
        i_print('----------------------------------------------------------')
    except:
        e_print('SmartBillingとの通信に失敗しました。(顧客情報)')
        e_print('call api:' + sys.argv[0] + ' end')
        import traceback
        traceback.print_exc()
        #raise
        return {
            'statusCode': 400,
            'body': json.dumps('error!')
        }
    if str(res.status_code) == '200':
        i_print('Success')
    else:
        e_print('Failure Exit')
        sys.exit('400')

    # 契約情報取得
    try:
        i_print('[契約情報取得]========================================================')
        # 検索条件
        params = {
            "limit": 10,
            "offset": 0
        }

        url_sub = url + '/customers/' + customerId +'/subscriptions'
        i_print('----------------------------------------------------------')
        i_print('limit: ' + str(params['limit']))
        i_print('offset: ' + str(params['offset']))
        i_print('url_sub: ' + url_sub)
        res = cf.get_api(url_sub, params, headers, proxies, api_id, api_pass)
        data = res.json()
        i_print(data)
        if len(data) != 0:
            for key in data['subscriptions']:
                i_print(key)
                i_print(key['subscriptionId'])
                subscriptionId = key['subscriptionId']
                info_billing['startDate'] = key['startDate']

        i_print('----------------------------------------------------------')
    except:
        e_print('SmartBillingとの通信に失敗しました。(契約情報)')
        e_print('call api:' + sys.argv[0] + ' end')
        import traceback
        traceback.print_exc()
        #raise
        return {
            'statusCode': 400,
            'body': json.dumps('error!')
        }
    if str(res.status_code) == '200':
        i_print('Success')
    else:
        e_print('Failure')
        sys.exit('400')

    product_list_tmp = []
    # 契約商品取得
    try:
        i_print('[契約商品取得]========================================================')
        # 検索条件
        params = {
            "limit": 10,
            "offset": 0,
        }
        url_cont_sub = url + '/subscriptions/' + subscriptionId + '/productInstances'
        i_print('----------------------------------------------------------')
        i_print('limit: ' + str(params['limit']))
        i_print('offset: ' + str(params['offset']))
        i_print('url_cont_sub : ' + url_cont_sub)
        res = cf.get_api(url_cont_sub, params, headers, proxies, api_id, api_pass)
        data = res.json()
        for key in data['productInstances']:
            i_print(key)
            if key['chargeMethod']=='段階変動従量' or key['chargeMethod']=='固定従量':
                product = {}
                product['chargingId'] = key['chargingId']
                product['productId'] = key['productId']
                product_list_tmp.append(product)
        i_print('----------------------------------------------------------')
        i_print('product_list_tmp:')
        i_print(product_list_tmp)
    except:
        e_print('SmartBillingとの通信に失敗しました。(契約商品情報)')
        e_print('call api:' + sys.argv[0] + ' end')
        import traceback
        traceback.print_exc()
        #raise
        return {
            'statusCode': 400,
            'body': json.dumps('error!')
        }
    if str(res.status_code) == '200':
        i_print('Success')
    else:
        e_print('Failure')

    # カタログ商品取得
    product_list = []
    try:
        i_print('[カタログ商品取得]=====================================================')
        i_print('----------------------------------------------------------')
        for onKey in product_list_tmp:
            # 検索条件
            url_pro = url + '/products/' + onKey['productId']
            i_print(url_pro)
            res = cf.get_api_url(url_pro, headers, proxies, api_id, api_pass)
            data = res.json()
            i_print(data)
            info = {}
            #if 'プリポスト' == data['products']['additionalText08']:
            info['chargingId'] = onKey['chargingId']
            info['additionalText07'] = data['products']['additionalText07']
            product_list.append(info)
        i_print('----------------------------------------------------------')
        info_billing['billings'] = product_list
    except:
        e_print('SmartBillingとの通信に失敗しました。(カタログ商品取得)')
        e_print('call api:' + sys.argv[0] + ' end')
        import traceback
        traceback.print_exc()
        #raise
        return {
            'statusCode': 400,
            'body': json.dumps('error!')
        }

    if str(res.status_code) == '200':
        i_print('Success')
    else:
        e_print('Failure')
        sys.exit('400')
    i_print(info_billing)

    return info_billing

###
#
###
def get_datamart_not_smartbilling(target_date):
    # Get datamart(select view)
    
    # フェーズ2 ------------------------S
    system_name = None
    # フェーズ2 ------------------------E
    
    try:
        data = {}
        data['target_date'] = target_date
        next_day_target_date = (datetime.datetime.strptime(target_date, '%Y-%m-%d') + datetime.timedelta(days=1)).strftime('%Y-%m-%d')
        data['next_day_target_date'] = next_day_target_date
        # 企業コードの取得 pre-post
        sql_company = """
                WITH tab as(              
                    SELECT
                        DISTINCT(company_code) AS project_id
                    FROM
                        public.billing_solver_used_hs_3_month
                    WHERE
                        %(target_date)s between start_day and COALESCE(end_day, %(next_day_target_date)s)
                    UNION
                    SELECT
                        DISTINCT(project_id)
                    FROM
                        public.billing_prepost_license_hs_3_months
                    WHERE
                        %(target_date)s between start_day and COALESCE(end_day, %(next_day_target_date)s)
                )
                SELECT to_json(tab) FROM tab
                """

        i_print('[利用量情報取得開始]============================================================')
        i_print("MSCOneサービスを使用した企業を取得開始")
        i_print("query Get use_prepost m_company start")
        cur = cf.mscone_query_env(sql_company,
                                    config['DATAMART']['DB_NAME'],
                                    config['DATAMART']['DB_HOST'],
                                    config['DATAMART']['DB_USER'],
                                    config['DATAMART']['DB_PASSWORD'],
                                    config['DATAMART']['DB_PORT'],
                                    data)
        # local用
        #cur = cf.query_local(sql_company,data)
        i_print(cur)

        i_print("query Get use_prepost m_company end")
        i_print("MSCOneサービスを使用した企業を取得完了")

        # Phase3 ------------------------------------------------------ START
        # フリートライアルの企業を除く処理を追加
        # フリートライアル期間は、料金を請求しないため
        if not cur:
            i_print('対象データ 0')
            return  {
                'statusCode': 200,
            }
        print('フェーズ3 ADD 契約情報の確認 開始')
        company_list = []
        for row in cur:
            company_list.append(row[0]['project_id'])
        i_print(company_list)
        # 契約のある企業コードを取得する
        # 条件：m_contractに契約が無い or 契約期間の範囲外
        cur_list = cf.get_m_contract_company_code(company_list, target_date)
        i_print(cur_list)
        i_print('フェーズ3 ADD 契約情報の確認 終了')
        if not cur_list:
            i_print('対象データ 0')
            return  {
                'statusCode': 200,
            }
        if cur_list is None:
            i_print('対象データ 0')
            return  {
                'statusCode': 200,
            }
        target_company_list = []
        for row in cur_list:
            target_company_list.append(row[0]['project_id'])
        # Phase3 ------------------------------------------------------ END
        
        company_code_check_list = []
        # print('len(cur) OK')

        # プリポスト―クラウド使用履歴取得
        #sql_prepost = """
        #        WITH tab as (
        #            SELECT *
        #                FROM public.billing_prepost_license_cloud_hs_3_months
        #                where %(target_date)s between start_day and end_day
		#			)
		#			select to_json(tab)
        #        	from tab
        #        """
        
        # フェーズ3 ----------------------------- S
        company_list = "'" + "','".join(target_company_list) + "'"
        sql_prepost = '''
                WITH tab as (
                    SELECT project_id,
                           product_id,
                           start_day,
                           start_time,
                           COALESCE(end_day, 'next_day_target_date') as end_day,
                           end_time
                        FROM public.billing_prepost_license_cloud_hs_3_months
                        where 'target_date' between start_day and COALESCE(end_day, 'next_day_target_date')
                        and project_id IN ( ''' + company_list + ''')
					)
					select to_json(tab)
                	from tab
                '''
        sql_prepost = sql_prepost.replace('next_day_target_date', next_day_target_date).replace('target_date', target_date)
        # フェーズ3 ----------------------------- E
        i_print("プリポストのクラウド利用量を取得開始")
        i_print("pre-post query start")
        #cur = cf.mscone_query_env(sql_prepost,
        #                            config['DATAMART']['DB_NAME'],
        #                            config['DATAMART']['DB_HOST'],
        #                            config['DATAMART']['DB_USER'],
        #                            config['DATAMART']['DB_PASSWORD'],
        #                            config['DATAMART']['DB_PORT'],
        #                            data)
        
        # フェーズ3 ----------------------------- S
        cur = cf.mscone_query_env(sql_prepost,
                                    config['DATAMART']['DB_NAME'],
                                    config['DATAMART']['DB_HOST'],
                                    config['DATAMART']['DB_USER'],
                                    config['DATAMART']['DB_PASSWORD'],
                                    config['DATAMART']['DB_PORT'],
                                    target_company_list)
        # フェーズ3 ----------------------------- E
        # local
        #cur = cf.query_local(sql_prepost, data)
        print('取得結果-------------------------')
        i_print(cur)
        i_print("pre-post query end")
        i_print("プリポストのクラウド利用量を取得完了")

        # ソルバー―使用履歴取得
        #sql_solver = """
        #        WITH tab as (
        #            SELECT *
        #                FROM public.billing_solver_used_cloud_hs_3_month
        #                where %(target_date)s between start_day and end_day
		#			)
		#			select to_json(tab)
        #        	from tab
        #        """
                
        sql_solver = '''
                WITH tab as (
                    SELECT company_code,
                           product_id,
                           start_day,
                           start_time,
                           COALESCE(end_day, 'next_day_target_date') as end_day,
                           end_time
                        FROM public.billing_solver_used_cloud_hs_3_month
                        where 'target_date' between start_day and COALESCE(end_day, 'next_day_target_date') 
                        AND company_code IN ( ''' + company_list + ''')
					)
					select to_json(tab)
                	from tab
                '''

        i_print("ソルバーのクラウド利用量を取得開始")
        i_print("solver query start")
        #cur_solver = cf.mscone_query_env(sql_solver,
        #                                config['DATAMART']['DB_NAME'],
        #                                config['DATAMART']['DB_HOST'],
        #                                config['DATAMART']['DB_USER'],
        #                                config['DATAMART']['DB_PASSWORD'],
        #                                config['DATAMART']['DB_PORT'],
        #                                data)
        sql_solver = sql_solver.replace('next_day_target_date', next_day_target_date).replace('target_date', target_date)
        cur_solver = cf.mscone_query_env(sql_solver,
                                        config['DATAMART']['DB_NAME'],
                                        config['DATAMART']['DB_HOST'],
                                        config['DATAMART']['DB_USER'],
                                        config['DATAMART']['DB_PASSWORD'],
                                        config['DATAMART']['DB_PORT'],
                                        target_company_list)
        # local
        #cur_solver = cf.query_local(sql_solver, data)
        i_print("solver query end")
        i_print("ソルバーのクラウド利用量を取得完了")

        # プリポストとソルバーのデータをがっさんする
        # ソルバーの取得データの形式をプリポストにそろえる
        print('ソルバーの取得データの形式をプリポストにそろえる')
        i_print('プリポスト・ソルバーのデータ形式の統合開始')
        usage_list_tmp = []
        print(cur_solver)
        target_d = string_to_datetime(target_date)
        print(target_d)
        deletionkey = randomname(12)
        for row in cur_solver:
            print('loop for row in cur_solver:')
            print(row)
            # カラム名をそろえる
            tmp = {}
            tmp['project_id'] = row[0]['company_code']
            tmp['product_id'] = row[0]['product_id']
            # tmp['chargingid'] = row[0]['company_code'] + row[0]['product_id'][-6:]    # Phase3
            contract_id = cf.get_contract_id(row[0]['company_code'], row[0]['product_id'])[0][0]['contract_id']
            tmp['chargingid'] = contract_id + row[0]['product_id']
            seconds = 0
            start_d = string_to_datetime(row[0]['start_day'])
            print(start_d)
            end_d = string_to_datetime(row[0]['end_day'])
            print(end_d)
            if target_d == start_d:
                if start_d == end_d:
                    print('開始日=終了日 ------------')
                    tmp['start_day'] = start_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = end_d.date().strftime('%Y/%m/%d')
                    tmp['end_time'] = '23:59:59'
                    seconds = calc_timedelta(row[0]['start_time'], row[0]['end_time'])
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)         # 時間
                else:
                    print('開始日<終了日 ------------')
                    tmp['start_day'] = start_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    # 終了日を[開始日+1days 00:00:00]にする
                    end_time = start_d + datetime.timedelta(days=1)  # 開始日+1日
                    tmp['end_day'] = row[0]['start_day']  # 開始日と終了日は同じになる
                    tmp['end_time'] = '23:59:59'
                    end_time_str = end_time.strftime('%Y-%m-%dT%H:%M:%S')  # フォーマット変更
                    print(end_time_str)
                    seconds = calc_timedelta(row[0]['start_time'], end_time_str)
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)  # 時間
            elif target_d > start_d:
                print('ターゲット日>開始日 --------------')
                if target_d == end_d:
                    # 日跨ぎの終わり
                    print('ターゲット日の00:00:00～終了日')
                    # 開始日をターゲット日にする(target_date 00:00:00)
                    # 終了日はそのまま
                    tmp['start_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = row[0]['end_day']
                    tmp['end_time'] = '23:59:59'
                    start_time_str = target_d.strftime('%Y-%m-%dT%H:%M:%S')  # フォーマット変更
                    print(start_time_str)
                    seconds = calc_timedelta(start_time_str, row[0]['end_time'])
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)  # 時間
                else:
                    # 日跨ぎの中間
                    print('ターゲット日 < 終了日 --------------')
                    # 1440 分 / 24 時を設定する
                    tmp['start_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['end_time'] = '23:59:59'
                    tmp['duration_mm'] = 1440  # 分(1日)
                    # tmp['duration_hh'] = 24  # 時間(1日)

            print(get_last_date(target_d))
            #tmp['date_time'] = get_last_date(target_d).strftime('%Y/%m/%d %H:%M:%S')  # 月末「YYYY/MM/DDTHH:MM:SS」
            tmp['date_time'] = target_d.strftime('%Y/%m/%d %H:%M:%S')
            tmp['explanation'] = target_d.strftime('%m') + '月利用分'
            # tmp['explanation'] = row[0]['explanation']          # 〇〇月利用分
            tmp['deletionkey'] = deletionkey
            print(tmp)
            usage_list_tmp.append(tmp)
            # tmp_taple = tuple(tmp_list)
            # cur.append(tmp_taple)
        # プリポストの取得データusage_listに追加
        print('プリポストの取得データusage_listに追加')
        for row in cur:
            print('loop for row in cur:')
            tmp = {}
            tmp['project_id'] = row[0]['project_id']
            tmp['product_id'] = row[0]['product_id']
            # tmp['chargingid'] = row[0]['project_id'] + row[0]['product_id'][-6:]  #Phase3
            contract_id = cf.get_contract_id(row[0]['project_id'], row[0]['product_id'])[0][0]['contract_id']
            tmp['chargingid'] = contract_id + row[0]['product_id']
            seconds = 0
            start_d = string_to_datetime(row[0]['start_day'])
            print(start_d)
            end_d = string_to_datetime(row[0]['end_day'])
            print(end_d)
            if target_d == start_d:
                if start_d == end_d:
                    print('開始日=終了日 ------------')
                    tmp['start_day'] = start_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = end_d.date().strftime('%Y/%m/%d')
                    tmp['end_time'] = '23:59:59'
                    seconds = calc_timedelta(row[0]['start_time'], row[0]['end_time'])
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)  # 時間
                else:
                    print('開始日<終了日 ------------')
                    tmp['start_day'] = start_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    # 終了日を[開始日+1days 00:00:00]にする
                    end_time = start_d + datetime.timedelta(days=1)  # 開始日+1日
                    tmp['end_day'] = row[0]['start_day']  # 開始日と終了日は同じになる
                    tmp['end_time'] = '23:59:59'
                    end_time_str = end_time.strftime('%Y-%m-%dT%H:%M:%S')  # フォーマット変更
                    print(end_time_str)
                    seconds = calc_timedelta(row[0]['start_time'], end_time_str)
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)  # 時間
            elif target_d > start_d:
                print('ターゲット日>開始日 --------------')
                if target_d == end_d:
                    # 日跨ぎの終わり
                    print('ターゲット日の00:00:00～終了日')
                    # 開始日をターゲット日にする(target_date 00:00:00)
                    # 終了日はそのまま
                    tmp['start_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = row[0]['end_day']
                    tmp['end_time'] = '23:59:59'
                    start_time_str = target_d.strftime('%Y-%m-%dT%H:%M:%S')  # フォーマット変更
                    print(start_time_str)
                    seconds = calc_timedelta(start_time_str, row[0]['end_time'])
                    tmp['duration_mm'] = math.ceil(seconds / 60)  # 分
                    # tmp['duration_hh'] = math.ceil(seconds / 3600)  # 時間
                else:
                    # 日跨ぎの中間
                    print('ターゲット日 < 終了日 --------------')
                    # 1440 分 / 24 時を設定する
                    tmp['start_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['start_time'] = '00:00:00'
                    tmp['end_day'] = target_d.date().strftime('%Y/%m/%d')
                    tmp['end_time'] = '23:59:59'
                    tmp['duration_mm'] = 1440  # 分(1日)
                    # tmp['duration_hh'] = 24  # 時間(1日)

            print(get_last_date(target_d))
            tmp['date_time'] = get_last_date(target_d).strftime('%Y/%m/%d %H:%M:%S')  # 月末「YYYY/MM/DDTHH:MM:SS」
            tmp['date_time'] = target_d.strftime('%Y/%m/%d %H:%M:%S')
            tmp['explanation'] = target_d.strftime('%m') + '月利用分'
            tmp['deletionkey'] = deletionkey
            print(tmp)
            usage_list_tmp.append(tmp)
            # tmp_taple = tuple(tmp_list)
            # cur.append(tmp_taple)
        i_print('プリポスト・ソルバーのデータ形式の統合完了')

        # =======================================================================
        print('usage_list_tmpから同じ企業コード、アプリケーション、日にちのものがあるかチェック')
        i_print('同じ企業コード、アプリケーション、日にちのプリポスト・ソルバーの利用量合算開始')
        usage_list_dic = {}
        for usage in usage_list_tmp:
            print(usage)
            if usage['project_id'] not in usage_list_dic:
                print('OK: project_id')
                usage_list_dic[usage['project_id']] = {}
                print(usage_list_dic)
            if usage['product_id'] not in usage_list_dic[usage['project_id']]:
                print('OK: product_id')
                usage_list_dic[usage['project_id']][usage['product_id']] = usage
                print(usage_list_dic)
            else:
                usage_list_dic[usage['project_id']][usage['product_id']]['duration_mm'] = \
                    usage_list_dic[usage['project_id']][usage['product_id']]['duration_mm'] + usage['duration_mm']
                print('duration_mm add')
                print(usage_list_dic)
            print('OKOK')
            print(usage_list_dic)
        print(usage_list_dic)
        i_print(usage_list_dic)
        # usage_list_dicをcurに置き換え
        # list(tuple{dic})の形式
        tmp_cur = []
        for usage_list_key in usage_list_dic:  # 企業ID
            for usage_app in usage_list_dic[usage_list_key]:  # 企業ID→商品コード
                tmp_dic = {}
                tmp_list = []
                tmp_dic['project_id'] = usage_list_key
                tmp_dic['chargingid'] = usage_list_dic[usage_list_key][usage_app]['chargingid']
                tmp_dic['product_id'] = usage_app
                tmp_dic['start_day'] = usage_list_dic[usage_list_key][usage_app]['start_day']
                tmp_dic['start_time'] = usage_list_dic[usage_list_key][usage_app]['start_time']
                tmp_dic['end_day'] = usage_list_dic[usage_list_key][usage_app]['end_day']
                tmp_dic['end_time'] = usage_list_dic[usage_list_key][usage_app]['end_time']
                tmp_dic['date_time'] = usage_list_dic[usage_list_key][usage_app]['date_time']
                tmp_dic['explanation'] = usage_list_dic[usage_list_key][usage_app]['explanation']
                tmp_dic['duration_mm'] = -(-usage_list_dic[usage_list_key][usage_app]['duration_mm'])  # 分に変換　切り上げ
                tmp_dic['duration_hh'] = math.ceil(tmp_dic['duration_mm'] / 60)  # 時間に変換　切り上げ
                tmp_dic['deletionkey'] = usage_list_dic[usage_list_key][usage_app]['deletionkey']
                # tmp_dic['amount'] = usage_list_dic[usage_list_key][usage_app]['amount']
                tmp_list.append(tmp_dic)
                tmp_taple = tuple(tmp_list)
                tmp_cur.append(tmp_taple)
        cur = copy.deepcopy(tmp_cur)
        i_print(cur)
        i_print('同じ企業コード、アプリケーション、日にちのプリポスト・ソルバーの利用量合算完了')

        # フェーズ2 ------------------------S
        # プリポスト、ソルバーの契約に紐づく商品情報を取得します。
        i_print('各企業の契約している契約商品を取得する　開始')
        data = {}
        data['target_date'] = target_date
        contract_data = cf.get_contract_product(data)
        i_print(contract_data)
        i_print('各企業の契約している契約商品を取得する　完了')
        # フェーズ2 ------------------------E
        
        # =======================================================================
        # 確認用
        # cur = copy.deepcopy(usage_list_tmp)
        result = []
        cnt = 1
        # for row in cur:
        i_print('利用量ファイルの形式にデータ成型開始')
        # print(usage_list_tmp)
        for row in tmp_cur:
            print(row)
            # for row in usage_list_tmp:
            info = {}
            # フェーズ2 ------------------------S
            # info['通番'] = cnt  # 通番
            # info['課金ID'] = row[0]['chargingid']  # 課金ID(企業コード+商品コードの下3桁)
            # info['開始日'] = row[0]['start_day']  # 開始日
            # info['開始時刻'] = row[0]['start_time']  # 開始時刻
            # info['終了日'] = row[0]['end_day']  # 終了日
            # info['終了時刻'] = row[0]['end_time']  # 終了時刻
            # info['発生日時'] = row[0]['date_time']  # 発生日時
            # info['説明'] = row[0]['explanation']  # 説明
            # info['利用量'] = row[0]['duration_mm']  # 利用量
            # info['削除キー'] = ''  # 削除キー
            # フェーズ2 ------------------------S
            if cnt == 1:
                system_name = get_system_name(contract_data, row[0]['project_id'], row[0]['product_id'])
                if system_name is None:
                    e_print('システム名称が取得できませんでした。')
                    e_print('システム名称がありません. 企業コード: ' + row[0]['project_id'] + ' 商品コード: ' + row[0]['product_id'])
                    e_print('ファイル名：' + file_name)
                    break
            # フェーズ2 ------------------------E
            info['project_id'] = row[0]['project_id']
            info['chargingid'] = row[0]['chargingid']
            info['product_id'] = row[0]['product_id']
            info['start_day'] = row[0]['start_day']
            info['start_time'] = row[0]['start_time']
            info['end_day'] = row[0]['end_day']
            info['end_time'] = row[0]['end_time']
            info['date_time'] = row[0]['date_time']
            info['explanation'] = row[0]['explanation']
            # info['duration_mm'] = row[0]['duration_mm']
            # info['duration_hh'] = row[0]['duration_hh']
            # 利用量登録は単位に合わせてアプリ側で登録方法を変更。
            # 新しいサービスが追加された場合、利用量取得・登録処理は新規作成。
            info['usage'] = ''
            for d in contract_data:
                if d[0]['chargingid'] == row[0]['chargingid']:
                    if d[0]['calc_unit'].find('分') > -1:
                        info['usage'] = row[0]['duration_mm']
                        pass
                    elif d[0]['calc_unit'].find('時間') > -1:
                        info['usage'] = row[0]['duration_hh']
            info['deletionkey'] = row[0]['deletionkey']
            # フェーズ2 ------------------------E
            result.append(info)
            print(result)
            cnt += 1
        i_print(result)
        i_print('利用量ファイルの形式にデータ成型完了')

    except Exception as e:
        e_print('Datamartの取得に失敗しました。')
        e_print('利用量ファイルの形式にデータ成型 失敗')
        e_print(e.args)
        raise
        return
    # フェーズ2 ------------------------S
    if system_name is not None:
    # フェーズ2 ------------------------E
    
        # SmartbillingにUpload
        # 一時保存場所
        # フェーズ2 ------------------------S
        # filepath = program_path + '/tmp/'
        filepath = '/tmp/'
        # フェーズ2 ------------------------E
        # local用
        #filepath = 'C:/tmp/'
        try:
            i_print('CSVファイル作成開始')
            # CSV絶対パス作成
            file_name = cf.create_local_fulpath(filepath, 'sol', target_date)
            i_print('file_name = ' + file_name)
            # CSV作成
            # フェーズ2 ------------------------S
            # cf.create_csv_at_list_dic(result, file_name)
            cf.create_csv_at_list_dic_new(result, file_name)
            # フェーズ2 ------------------------E
            # # フェーズ2 ------------------------S
            # files = os.listdir(filepath)
            # print(files)
            # # フェーズ2 ------------------------E
            # S3に保存
            # s3 path check & Create + 年と月を取得
            # フェーズ2 ------------------------S
            # path = cf.create_s3_key(s3_base_path)
            path = cf.create_s3_key(s3_base_path + '/' + system_name[0])
            # フェーズ2 ------------------------E
            setting_bucket.upload_file(file_name, path + cf.creat_file_name('sol', target_date))
            i_print('CSVの作成に成功しました。')
        except Exception as e:
            e_print('CSVの作成に失敗しました。')
            e_print(e.args)
            raise
            return
        i_print('CSVファイル作成完了')
    
        # 課金アップロード履歴テーブル登録用のファイル名
        name = file_name.split('/')[-1]

    print('calling api:' + sys.argv[0] + ' end')
    return {
        'statusCode': 200,
        # 'body': json.dumps(data_charges, ensure_ascii=False)
    }
# 2022/10/25 追加 -------------------------------------------
# 日付文字列→日付
def string_to_datetime(string):
    return datetime.datetime.strptime(string, "%Y-%m-%d")

def string_to_datetime_time(string):
    print('string_to_datetime_time()')
    return datetime.datetime.strptime(string, "%Y-%m-%dT%H:%M:%S")

# 任意の日付の月末を取得
def get_last_date(dt):
    return dt.replace(day=calendar.monthrange(dt.year, dt.month)[1])

# 時間の差分を秒で返す
def calc_timedelta(start_time:string, end_time:string):
    if start_time is None:
        return 0
    #if end_time is None:
    try:
        print(start_time)
        print(type(start_time))
        print(end_time)
        print(type(end_time))
        # start_timeの翌日0時で差分を取る

        #start_time_time = datetime.datetime.strftime(start_time, '%Y-%m-%d %H:%M:%S')
        start_time_time = datetime.datetime.fromisoformat(start_time)

        print(type(start_time_time))
        #end_time_time = datetime.datetime.strftime(end_time, '%Y-%m-%d %H:%M:%S')
        end_time_time = datetime.datetime.fromisoformat(end_time)
        print('時間の差分')
        tdelta = abs(end_time_time - start_time_time)
        seconds = tdelta.seconds
        print(str(seconds) + '秒')
    except Exception as e:
        e_print('日付差分計算 エラー calc_timedelta()')
        e_print(e.args)
    return seconds
# フェーズ2 ------------------------S
# # ----------------------------------------------------------
# # 料金の計算
# def calc_amount(dic, chargingid, duration):
#     i_print('料金計算開始 calc_amount()')
#     try:
#         total = 0
#         for d in dic:
#             if d[0]['chargingid'] == chargingid:
#                 total = duration * d[0]['one_off_payment']
#                 #total = (duration / 60) * d[0]['one_off_payment']
#                 #total += (duration % 60) * d[0]['one_off_payment']
#         print('計算結果: ' + str(round(total)))
#         i_print('料金計算終了 calc_amount()')
#     except Exception as e:
#         e_print('料金計算 エラー calc_amount()')
#         e_print(e.args)
#     return round(total)
# ----------------------------------------------------------
# 料金の計算
def calc_amount(dic, chargingid, duration):
    i_print('料金計算開始 calc_amount()')
    try:
        total = 0
        for d in dic:
            if d[0]['chargingid'] == chargingid:
                total = duration * d[0]['one_off_payment']
                #total = (duration / 60) * d[0]['one_off_payment']
                #total += (duration % 60) * d[0]['one_off_payment']
        print('計算結果: ' + str(total))
        print('計算結果: ' + str(Decimal(str(total)).quantize(Decimal('0'), rounding=ROUND_HALF_UP)))
        i_print('料金計算終了 calc_amount()')
    except Exception as e:
        e_print('料金計算 エラー calc_amount()')
        e_print(e.args)
    return Decimal(str(total)).quantize(Decimal('0'), rounding=ROUND_HALF_UP)
# フェーズ2 ------------------------E
# フェーズ2 ------------------------S
# 料金の計算
def calc_amount_new(dic, dic_n):
    i_print('料金計算開始 calc_amount()')
    try:
        total = 0
        for d in dic:
            if d[0]['chargingid'] == dic_n[0]['chargingid']:
                calc_unit = int(d[0]['calc_unit'].split('　')[0])
                if d[0]['calc_unit'].find('分') > -1:
                    total = math.ceil(dic_n[0]['duration_mm'] / calc_unit) * d[0]['one_off_payment']
                    pass
                elif d[0]['calc_unit'].find('時間') > -1:
                    total = math.ceil(dic_n[0]['duration_hh'] / calc_unit) * d[0]['one_off_payment']
        print('計算結果: ' + str(total))
        print('計算結果: ' + str(Decimal(str(total)).quantize(Decimal('0'), rounding=ROUND_HALF_UP)))
        i_print('料金計算終了 calc_amount()')
    except Exception as e:
        e_print('料金計算 エラー calc_amount()')
        e_print(e.args)
    return Decimal(str(total)).quantize(Decimal('0'), rounding=ROUND_HALF_UP)
# フェーズ2 ------------------------E

# # 契約IDを取得
# def get_contract_id(dic, project_id):
#     i_print('契約ID取得開始 get_contract_id() : ' + project_id)
#     try:
#         for d in dic:
#             #print(d[0]['company_code'])
#             if d[0]['company_code'] == project_id:
#                 return d[0]['contract_id']
#         i_print('契約ID取得終了 get_contract_id() : ' + project_id)
#     except Exception as e:
#         e_print('契約ID取得 エラー get_contract_id() : ' + project_id)
#         e_print(e.args)
#         return

# def get_contract_product_id(dic, project_id,product_code):
#     i_print('契約ID取得開始 get_contract_contract_id() : ' + project_id)
#     try:
#         for d in dic:
#             #print(d[0]['company_code'])
#             if d[0]['company_code'] == project_id and d[0]['product_code'] == product_code:
#                 return d[0]['contract_product_id']
#         i_print('契約ID取得終了 get_contract_contract_id() : ' + project_id)
#     except Exception as e:
#         e_print('契約ID取得 エラー get_contract_contract_id() : ' + project_id)
#         e_print(e.args)
#         return

# フェーズ2 ------------------------S
# システム名称を取得
def get_system_name(dic, project_id, product_code):
    i_print('システム名称開始 get_system_name() : ' + project_id)
    try:
        for d in dic:
            #print(d[0]['company_code'])
            if d[0]['company_code'] == project_id and d[0]['product_code'] == product_code:
                return (d[0]['system_id'], d[0]['system_name'])
        i_print('システム名称取得終了 get_system_name() : ' + project_id + ' ' + product_code)
    except Exception as e:
        e_print('システム名称取得 エラー get_system_name() : ' + project_id + ' ' + product_code)
        e_print(e.args)
        return
# フェーズ2 ------------------------E
"""
 プリポストの集計を行う
 　日付、企業、ユーザー、アプリケーションのレコードを
 　日付、企業、アプリケーションのレコードに集計する。
"""
def prepost_usage_totaling(list):
    re_list = []
    copy_list = copy.deepcopy(list)
    for li in list:
        if len(copy_list) > 1:
            copy_list.pop(0)
        for co in copy_list:
            if li[0]['project_id'] == co[0]['project_id'] and li[0]['application_name'] == co[0]['application_name']:
                tmp = {}

                tmp['project_id'] = co[0]['project_id']
                tmp['application_name'] = co[0]['application_name']
                tmp['product_id'] = co[0]['product_id']
                tmp['start_day'] = co[0]['start_day']
                tmp['start_time'] = co[0]['start_time']
                tmp['end_day'] = co[0]['end_day']
                tmp['end_time'] = co[0]['end_time']
                tmp['date_time'] = co[0]['date_time']
                tmp['explanation'] = co[0]['explanation']
                tmp['duration_mm'] += co[0]['duration_mm']
                print(tmp)
                re_list.append(tmp)

    return re_list

# 日付文字列、日付型変換
def change_format_str_date(str):
    return datetime.datetime.strptime(str, '%Y-%m-%dT%H:%M:%S')

# 分と残りの秒を返す
def get_m_s(td):
    m, s = divmod(td.seconds, 60)
    return m, s
# 日時の差分から秒数を返す
def get_datetime_seconds(td):
    return td.seconds

# 削除キーの採番：ランダム　英数字12桁
def randomname(n):
   return ''.join(random.choices(string.ascii_letters + string.digits, k=n))

# if __name__ == "__main__":
def main(target_date):
    try:
        i_print('クラウド利用量登録処理　開始')
        # フェーズ2 ------------------------S
        # target_date = ''
        # if len(sys.argv) == 3:
        #     target_date = sys.argv[2]
        # else:
        #     yesterday = datetime.datetime.now() + datetime.timedelta(days=-1)
        #     target_date = yesterday.strftime('%Y-%m-%d')
        # if len(sys.argv) > 1 and'smartbilling' == sys.argv[1]:
        #     rep = get_datamart(target_date)
        #     i_print(rep)
        # else:
        #     print('not smartbilling')
        #     get_datamart_not_smartbilling(target_date)
        
        if target_date:
            pass
        else:
            yesterday = datetime.datetime.now() + datetime.timedelta(days=-1)
            target_date = yesterday.strftime('%Y-%m-%d')
            # target_date = '2022-10-28'
            print('not smartbilling')

        get_datamart_not_smartbilling(target_date)
        # フェーズ2 ------------------------E
        
        i_print('終了 ' + ' ' + os.path.basename(__file__))
        i_print('クラウド利用量登録処理　終了')
    except Exception as e:
        e_print(e)
        i_print('登録に失敗したため、メール送信します。')
        # フェーズ2 ------------------------S
        """
        data = {}
        data['mail_id'] = 'SM000009'
        result = cf.get_error_mail_address_id(data)
        title = result[0][0]['mail_subject'].replace('PATTERN', 'Cloud').replace('YYYY/MM/DD',
                                                                                   datetime.datetime.now().strftime(
                                                                                       "%Y/%m/%d"))
        body = result[0][0]['mail_body'].replace('PATTERN', 'Cloud').replace('YYYY/MM/DD',
                                                                               datetime.datetime.now().strftime(
                                                                                   "%Y/%m/%d"))
        From_ADDRESS = result[0][0].get('mail_send_from')
        to = result[0][0].get('mail_to')
        cc = result[0][0].get('mail_cc')
        bcc = result[0][0].get('mail_bcc')     
        """
        # """
        config = configparser.ConfigParser()
        mode = 'submit'
        config.read('./mail.conf', 'UTF-8')
        title = config['TITLE'][mode].replace('PATTERN', 'Cloud').replace('YYYY/MM/DD', datetime.datetime.now().strftime("%Y/%m/%d"))
        body = config['BODY'][mode].replace('PATTERN', 'Cloud').replace('YYYY/MM/DD', datetime.datetime.now().strftime("%Y/%m/%d"))
        From_ADDRESS = config['ADDRESS']['from_address']
        From_NAME = config['ADDRESS']['from_name']
        to = config['ADDRESS']['to']
        cc = config['ADDRESS']['cc']
        bcc = config['ADDRESS']['bcc']
        # """
        # フェーズ2 ------------------------E
        cf.send_mail(title,body,From_ADDRESS,to,cc,bcc)
        i_print('メール送信完了。')
        e_print('終了 ' + ' ' + os.path.basename(__file__))

    finally:
        pass
        #S3にログアップロード
        path = s3_log_path + '/' + datetime.datetime.now().strftime("%Y") + '/' + datetime.datetime.now().strftime("%Y%m") + '-lam-sys-ssp-cloud-charge' + '.txt'
        cf.log_upload(setting_bucket, path)

def lambda_handler(event, context):
    
    print(event)
    
    event_body = {}
    if 'body' in event and event['body'] is not None: 
        event_body = event['body']

    target_date = ''
    if 'target_date' in event_body:
        target_date = event_body['target_date']
                
    main(target_date)

    # TODO implement
    return {
        'statusCode': 200,
        'body': json.dumps('Hello from Lambda!')
    }