import os
import json
import datetime
from datetime import date
import psycopg2_simsp
import psycopg2_compf
import time
from common.component import *
import boto3
from common.parameters import *
# 対象アプリ名
CHECKNAMES = ['Simulation-Space']
# チェック対象の企業の状態（解約の場合、ディスクは既に削除されているはずなので、ここでの処理不要）
CHECKSTATES = ['一時休止','利用中','停止']

# -----Mail-----#
MAIL_SYS_FROM = 'info@mono-pf.com'
TITLE_NOTICE = '【Simulation-Space】一定期間未ログイン時のファイル削除の事前連絡'
TITLE_DELETE = '【Simulation-Space】ご利用中のファイルを削除しました'
# -----Mail-----#

"""
メール送信
"""
def sendmail(from_address, to_address, title, text, html):
    print(to_address)
    client = boto3.client('ses', region_name='ap-northeast-1')
    response = client.send_email(
        Source='info@mono-pf.com',
        Destination={
            'ToAddresses': [to_address],
        },
        Message={
            'Subject': {
                'Data': title,
                'Charset': 'UTF-8'
            },
            'Body': {
                'Text': {
                    'Data': text,
                    'Charset': 'UTF-8'
                }
            }
        }
    )
    
def mail_deletion_notice(to_address, company_name, day):

    with open('mail/mail_alert_login_txt.txt','r',encoding="utf-8_sig") as f:
        text_message = f.read()
        lines = f.readlines()
    text_message = text_message.replace('--UserName',to_address).replace('--CompanyName', company_name).replace('--Day', day)

    with open('mail/mail_alert_login_html.txt','r',encoding="utf-8_sig") as f:
        html_message = f.read()
    html_message = html_message.replace('--UserName',to_address).replace('--CompanyName', company_name).replace('--Day', day)

    sendmail(MAIL_SYS_FROM, to_address, TITLE_NOTICE, text_message, html_message)
    
def mail_delete(to_address, company_name):

    with open('mail/mail_delete_txt.txt','r',encoding="utf-8_sig") as f:
        text_message = f.read()
        lines = f.readlines()
    text_message = text_message.replace('--UserName',to_address).replace('--CompanyName', company_name)

    with open('mail/mail_delete_html.txt','r',encoding="utf-8_sig") as f:
        html_message = f.read()
    html_message = html_message.replace('--UserName',to_address).replace('--CompanyName', company_name)

    sendmail(MAIL_SYS_FROM, to_address, TITLE_DELETE, text_message, html_message)
        
def lambda_handler(event, context):
    print('START lambda_handler')
    # 1.企業毎にユーザーのemailを取得
    data = psycopg2_compf.select('''
        select con.subscription_name,con.company_code,com.company_name,con.service_usable_status 
        from user_infrastructure.m_contract as con
        left outer join user_infrastructure.m_company as com
        on con.company_code = com.company_code 
        where com.company_code = con.company_code 
        and con.service_usable_status is not null
        and con.service_usable_status != ''
    ''', {})
    print('QryRes=' + str(data))
    dt = date.today()
    finished = []
    for code in data:
        print('company_code=' + code['company_code'])
        if not (code['subscription_name'] in CHECKNAMES):
            continue # チェック対象のアプリでなければ、スキップ
        if not (code['service_usable_status'] in CHECKSTATES):
            continue # チェック対象の状態でなければ、スキップ

        if code['company_code'] in finished:
            continue # 既にチェック済みなら、スキップ
        finished.append(code['company_code'])
        
        ## 企業毎にemailリストを取得する
        email_lst = psycopg2_compf.select('''
            SELECT
                auth0_user_id AS auth0_user_id
                ,email
                ,name_last
                ,name_first
            FROM
                user_infrastructure.m_user
            WHERE
                company_code = %(company_code)s
        ''', {'company_code' : code['company_code']})

        if email_lst is not None:
            day = 1000
            for dic in email_lst:
                ## Auth0のユーザー情報取得
                # Auth0登録情報取得
                auth0 = Auth0Component()
                user_param = GetUserParam()
                user_param.id = dic['auth0_user_id']
                auth0_userdata = auth0.get_user(user_param)
                print(auth0_userdata)
                # 最終ログイン
                try:
                    login = str(auth0_userdata['last_login']).replace('T', ' ').replace('Z', '').split('.')[0]
                    print('last login=' + login)
                    tdatetime = datetime.datetime.strptime(login, '%Y-%m-%d %H:%M:%S') + datetime.timedelta(hours=9)
                    tdate = datetime.date(tdatetime.year, tdatetime.month, tdatetime.day)
                    print('last login date=' + str(tdate))
                    td2 = dt - tdate
                    print('days from last login=' + str(td2.days))
                    if day > td2.days: #最小のログイン日数を設定
                        day = td2.days
                except Exception as e:
                    dic['last_login'] = 'ログイン履歴なし'
                    print(e)
                print('name: ' + user_param.id + ' 未ログイン経過日数：' + str(day) + '日')
            # dayに最短のログイン日までの日数が入っている

            #day = 31
            if day == 21 or day == 26 or day == 28 or day == 29 or day == 30:
                #21 = 10日前/26 = 5日前/28 = 3日前/29 = 2日前/30 = 1日前
                print('警告メール送信')
                print('企業名： ' + code['company_name'])
                print('未ログイン日数： ' + str(day) + '日間')
                for dic in email_lst:
                    mail_deletion_notice(dic['email'], code['company_name'], str((31-day)))
            elif day >= 31:
                if day == 31:
                    print('削除メール送信')
                    for d in email_lst:
                        mail_delete(d['email'], code['company_name'])
                # ファイル削除
                # 接続文字列の取得
                try:
                    res = psycopg2_simsp.select('''
                        SELECT
                            bridge_instance_id
                            ,env_id
                        FROM
                            mscone_lic.m_company
                        WHERE
                            company_code = %(company_code)s
                    ''', {'company_code' : code['company_code']})
                    print('bridge_instance_id=' + res[0]['bridge_instance_id'])
                    print('env_id=' + res[0]['env_id'])
                    cmdstr = 'rm -rf /home/admin@mono-pf.com/mnt/' + res[0]['env_id'] + '/*'
                    print('cmdstr=' + cmdstr)
                    ssm = boto3.client('ssm')
                    r = ssm.send_command(
                            InstanceIds = [ res[0]['bridge_instance_id'] ],
                            DocumentName = 'AWS-RunShellScript',
                            Parameters = {
                                "commands": [ cmdstr ]
                            }
                        )
                except Exception as e:
                    print('ERROR delete_file')
                    print(e)
                    return {
                        'statusCode': 400,
                        'body': json.dumps('ERROR delete_file')
                    }
    # TODO implement
    return {
        'statusCode': 200,
        'body': json.dumps('Hello from Lambda!')
    }
