M_REGULAR_PRODUCTS = {
    # 商品コード
    'product_code': {
        'label': '商品コード',
        'min': 9,
        'max': 9,
        'is_required': True
    },
    # 商品名
    'product_name': {
        'label': '商品名',
        'min': 0,
        'max': 85,
        'is_required': True
    },
    # 請求内訳名
    'billing_identifier': {
        'label': '請求内訳名',
        'min': 0,
        'max': 25,
        'is_required': False,
        'is_not_null': True
    },
    # 適用開始日
    'applicable_start_date': {
        'label': '適用開始日',
        'min': 10,
        'max': 10,
        'is_required': True,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd',
    },
    # 適用終了日
    'applicable_end_date': {
        'label': '適用終了日',
        'min': 10,
        'max': 10,
        'is_required': False,
        'is_date': True,
        'date_format': '%Y/%m/%d',
        'date_format_description': 'yyyy/mm/dd',
    },
    # 計算方法
    'calc_method': {
        'label': '計算方法',
        'min': 0,
        'max': 128,
        'is_required': True
    },
    # 計算単位
    'calc_unit': {
        'label': '計算単位',
        'min': 0,
        'max': 9,
        'is_required': False
    },
    # 単金（円）
    'one_off_payment': {
        'label': '単金（円）',
        'min': 0,
        'max': 999999999,
        'is_required': False,
        'is_intger': True
    },
    # カタログ金額（円)
    'catalog_amount': {
        'label': 'カタログ金額（円)',
        'min': 0,
        'max': 999999999,
        'is_required': False,
        'is_intger': True
    },
    # テキ01 システム名->システムID
    'system_id': {
        'label': 'システムID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # テキ07 利用明細料金合算対象
    'subject_to_combined_charges': {
        'label': '利用明細料金合算対象',
        'min': 9,
        'max': 9,
        'is_required': False
    },
    # テキ08 課金区分
    'billing_category': {
        'label': '課金区分',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # テキ05 売上報告出力位置
    'sales_report_position': {
        'label': '売上報告出力位置',
        'min': 0,
        'max': 9999,
        'is_required': False,
        'is_intger': True
    },
    # テキ06 利用明細表示順番
    'itemized_account_position': {
        'label': '利用明細表示順番',
        'min': 0,
        'max': 9999,
        'is_required': False,
        'is_intger': True
    }
    # # 最終更新日時
    # 'udate': {
    #     'label' : '最終更新日時',
    #     'min' : 0,
    #     'max' : 10,
    #     'is_required' : True
    # },
}


class MRegularProducts:
    def __init__(self):
        # 商品ID
        self.product_id: str
        # 商品コード
        self.product_code: str
        # 商品名
        self.product_name: str
        # 請求内訳名
        self.billing_identifier: str
        # 適用開始日
        self.applicable_start_date: str
        # 適用終了日
        self.applicable_end_date: str
        # 計算方法
        self.calc_method: str
        # 計算単位
        self.calc_unit: str
        # 単金（円）
        self.one_off_payment: str
        # カタログ金額（円)
        self.catalog_amount: str
        # システムID
        self.system_id: str
        # サービスID
        self.service_id: str
        # テキ05 売上報告出力位置
        self.sales_report_position: str
        # テキ06 利用明細表示順番
        self.itemized_account_position: str
        # テキ07 利用明細料金合算対象
        self.subject_to_combined_charges: str
        # テキ08 課金区分
        self.billing_category: str
        # 売上区分ID
        self.sales_category_id: str
        # 最終更新日時
        self.udate: str
        self.product_group_id: str

    def set_product_id(self, product_id):
        self.product_id = product_id
        
    def set_product_code(self, product_code):
        self.product_code = product_code

    def set_product_name(self, product_name):
        self.product_name = product_name

    def set_billing_identifier(self, billing_identifier):
        self.billing_identifier = billing_identifier

    def set_applicable_start_date(self, applicable_start_date):
        self.applicable_start_date = applicable_start_date

    def set_applicable_end_date(self, applicable_end_date):
        self.applicable_end_date = applicable_end_date

    def set_calc_method(self, calc_method):
        self.calc_method = calc_method

    def set_calc_unit(self, calc_unit):
        self.calc_unit = calc_unit

    def set_one_off_payment(self, one_off_payment):
        self.one_off_payment = one_off_payment

    def set_catalog_amount(self, catalog_amount):
        self.catalog_amount = catalog_amount

    def set_system_id(self, system_id):
        self.system_id = system_id
        
    def set_service_id(self, service_id):
        self.service_id = service_id

    def set_sales_report_position(self, sales_report_position):
        self.sales_report_position = sales_report_position

    def set_itemized_account_position(self, itemized_account_position):
        self.itemized_account_position = itemized_account_position
        
    def set_subject_to_combined_charges(self, subject_to_combined_charges):
        self.subject_to_combined_charges = subject_to_combined_charges

    def set_billing_category(self, billing_category):
        self.billing_category = billing_category

    def set_sales_category_id(self, sales_category_id):
        self.sales_category_id = sales_category_id

    def set_udate(self, udate):
        self.udate = udate
        
    def set_product_group_id(self, product_group_id):
        self.product_group_id = product_group_id


M_SYSTEMS = {
    # システムID
    'system_id': {
        'label': 'システムID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # システム名
    'system_name': {
        'label': 'システム名',
        'min': 0,
        'max': 64,
        'is_required': True
    },
    # Prefix
    'prefix': {
        'label': 'Prefix',
        'min': 3,
        'max': 3,
        'is_required': True
    },
    # # 請求金額の計算にSmartBillingを使う
    # 'use_smartbilling': {
    #     'label': '請求金額の計算にSmartBillingを使う',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': True,
    #     'is_in': ['使う', '使わない']
    # },
    # # GMO掛け払いの枠保証希望上限金額
    # 'gmo_ps_req_upper_limit': {
    #     'label': 'GMO掛け払いの枠保証希望上限金額',
    #     'min': 0,
    #     'max': 0,
    #     'is_required': False,
    #     'is_intger': True
    # }
}


class MSystems:
    def __init__(self):
        # システムID
        self.system_id: str
        # システム名
        self.system_name: str
        # Prefix
        self.prefix: str
        # # use_smartbilling
        # self.use_smartbilling: str
        # # gmo_ps_req_upper_limit
        # self.gmo_ps_req_upper_limit: str

    def set_system_id(self, system_id):
        self.system_id = system_id

    def set_system_name(self, system_name):
        self.system_name = system_name

    def set_prefix(self, prefix):
        self.prefix = prefix

    # def set_use_smartbilling(self, use_smartbilling):
    #     self.use_smartbilling = use_smartbilling

    # def set_gmo_ps_req_upper_limit(self, gmo_ps_req_upper_limit):
    #     self.gmo_ps_req_upper_limit = gmo_ps_req_upper_limit


M_SERVICES = {
    # サービスID
    'service_id': {
        'label': 'サービスID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # # システムID
    # 'system_id': {
    #     'label': 'システムID',
    #     'min': 8,
    #     'max': 8,
    #     'is_required': True
    # },
    # サービス名
    'service_name': {
        'label': 'サービス名',
        'min': 0,
        'max': 256,
        'is_required': True
    },
    # # 商品コード
    # 'product_code': {
    #     'label': '商品コード',
    #     'min': 9,
    #     'max': 9,
    #     'is_required': True
    # },
    # SmartBillingを使用
    'use_smartbilling': {
        'label' : 'SmartBillingを使用',
        'min' : 0,
        'max' : 0,
        'is_required' : True,
        'is_in': ['使う', '使わない']
    },
    # GMO掛け払いの枠保証希望上限金額
    'gmo_ps_req_upper_limit': {
        'label': 'GMO掛け払いの枠保証希望上限金額',
        'min': 0,
        'max': 10000000,
        'is_required': False,
        'is_intger': True
    },
    # 請求書の郵送手数料の商品ID
    'handling_charge_product_id': {
        'label': '請求書の郵送手数料の商品ID',
        'min': 0,
        'max': 8,
        'is_required': False
    }
}


class MServices:
    def __init__(self):
        # サービスID
        self.service_id: str
        # # システムID
        # self.system_id: str
        # サービス名
        self.service_name: str
        # # 商品コード
        # self.product_code: str
        # SmartBillingを使用
        self.use_smartbilling: str
        # 最終更新日時
        self.udate: str
        # GMO掛け払いの枠保証希望上限金額
        self.gmo_ps_req_upper_limit: str
        # 請求書の郵送手数料の商品ID
        self.handling_charge_product_id: str
        

    def set_service_id(self, service_id):
        self.service_id = service_id

    # def set_system_id(self, system_id):
    #     self.system_id = system_id

    def set_service_name(self, service_name):
        self.service_name = service_name

    # def set_product_code(self, product_code):
    #     self.product_code = product_code

    def set_use_smartbilling(self, use_smartbilling):
        self.use_smartbilling = use_smartbilling

    def set_udate(self, udate):
        self.udate = udate
        
    def set_gmo_ps_req_upper_limit(self, gmo_ps_req_upper_limit):
        self.gmo_ps_req_upper_limit = gmo_ps_req_upper_limit
        
    def set_handling_charge_product_id(self, handling_charge_product_id):
        self.handling_charge_product_id = handling_charge_product_id
        

# フェーズ2 ------------------------S

M_SERVICES_AND_RELATED_SALES_CATEGORIES = {
    # サービスID
    'service_id': {
        'label': 'サービスID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # 売上区分ID
    'sales_category_id': {
        'label': '売上区分ID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
}


class MServicesAndRelatedSalesCategories:
    def __init__(self):
        # サービスID
        self.service_id: str
        # 売上区分ID
        self.sales_category_id: str
        

    def set_service_id(self, service_id):
        self.service_id = service_id

    def set_sales_category_id(self, sales_category_id):
        self.sales_category_id = sales_category_id



M_ESTIMATED_ORDER_AMOUNTS = {
    # 企業コード
    'company_code': {
        'label': '企業コード',
        'min': 6,
        'max': 6,
        'is_required': True
    },
    # 売上区分ID
    'sales_category_id': {
        'label': '売上区分ID',
        'min': 8,
        'max': 8,
        'is_required': True
    },
    # 受注見込金額
    'estimated_order_amount': {
        'label': '受注見込金額',
        'min': 0,
        'max': 999999999,
        'is_required': False,
        'is_intger': True
    },
}

class MEstimatedOrderAmounts:
    def __init__(self):
        # 企業コード
        self.company_code: str
        # 売上区分ID
        self.sales_category_id: str
        # 受注見込金額
        self.estimated_order_amount: str
        

    def set_company_code(self, company_code):
        self.company_code = company_code

    def set_sales_category_id(self, sales_category_id):
        self.sales_category_id = sales_category_id

    def set_estimated_order_amount(self, estimated_order_amount):
        self.estimated_order_amount = estimated_order_amount

tax_rate = {
    # 課税区分ID
    'taxation_code_id': {
        'label': '課税区分ID',
        'min': 6,
        'max': 6,
        'is_required': True
    },
    # 課税名称
    'taxation_name': {
        'label': '課税名称',
        'min': 0,
        'max': 256,
        'is_required': False
    },
    # 税率
    'taxation_tax_rate': {
        'label': '税率',
        'min': 0,
        'max': 99,
        'is_required': False,
        'is_float': True
    },
    # 適用開始日
    'applicable_start_date': {
        'label': '適用開始日',
        'min': 10,
        'max': 10,
        'is_required': True
    },
    # 適用終了日
    'applicable_end_date': {
        'label': '適用終了日',
        'min': 10,
        'max': 10,
        'is_required': False
    }
}

class TaxRate:
    def __init__(self):
        # 課税区分ID
        self.taxation_code_id: str
        # 課税名称
        self.taxation_name: str
        # 税率
        self.taxation_tax_rate: str
        # 適用開始日
        self.applicable_start_date: str
        # 適用終了日
        self.applicable_end_date: str
        

    def set_taxation_code_id(self, taxation_code_id):
        self.taxation_code_id = taxation_code_id

    def set_taxation_name(self, taxation_name):
        self.taxation_name = taxation_name

    def set_taxation_tax_rate(self, taxation_tax_rate):
        self.taxation_tax_rate = taxation_tax_rate
        
    def set_applicable_start_date(self, applicable_start_date):
        self.applicable_start_date = applicable_start_date
        
    def set_applicable_end_date(self, applicable_end_date):
        self.applicable_end_date = applicable_end_date

# フェーズ2 ------------------------E