import boto3
import botocore.exceptions
import datetime
import json
import global_value as GV
import psycopg2_compf
from error_function import error_handling
from dateutil.relativedelta import relativedelta
import inspect

# 計算対象日
TARGET_DATE = None
# 計算モード
CALC_MODE = 'MONTHLY'
# 利用量を取得するLambda
LAMBDA_EXECUTIONLOGCHARGE = GV.ENV.lower() + '-lam-sim-executionLogCharge'
# 利用料金を計算するLambda
LAMBDA_BILLINGCALCULATION = GV.ENV.lower() + '-lam-sys-billing-calculation'
BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
s3_base_path = 'billing-infrastructure/charges/Daily'
SYSTEM_ID = 'SYS00001'

def lambda_handler(event, context):

    file_exist = False
    try:
        usage_amount = 0
        target_file_list = []

        s3 = boto3.resource('s3')
        setting_bucket = s3.Bucket(BUCKET_NAME)

        if 'target_date' not in event or event['target_date'] is None:
            today = datetime.date.today()
            # 昨日の日付を取得
            yesterday = today + relativedelta(days=-1)
            # YYYY-MM-DD形式でフォーマット
            TARGET_DATE = yesterday.strftime("%Y-%m-%d")
        else:
            TARGET_DATE = event['target_date'].upper()
        print(TARGET_DATE)

        if CALC_MODE == 'MONTHLY':
            # 月初から昨日までの利用量を取得
            print('月初から昨日までの利用量を取得開始')
            path = create_s3_key(datetime.datetime.strptime(TARGET_DATE, '%Y-%m-%d'), s3_base_path + '/' + SYSTEM_ID)
            prefix = path + TARGET_DATE.replace('-', '')
            file_list = setting_bucket.objects.filter(Prefix=prefix)
            if list(file_list.limit(1)):
                # ファイルが存在する場合はそれを使う
                file_exist = True
            else:
                response = boto3.client('lambda').invoke(
                    FunctionName=LAMBDA_EXECUTIONLOGCHARGE,
                    InvocationType='RequestResponse',
                    Payload=json.dumps({'target_date' : TARGET_DATE, 'calc_mode' : CALC_MODE})
                )
                if 'StatusCode' in response and response['StatusCode'] == 200:
                    # レスポンス読出し
                    Payload = json.loads(response['Payload'].read())
                    print("---03: body:")
                    print(Payload)
            
            print('月初から昨日までの利用量を取得完了')

            print('月初から昨日までの利用料金を計算開始')
            file_list = setting_bucket.objects.filter(Prefix=prefix)
            
            for o in file_list:            
                target_csv_file = o.key
                target_file_list.append(target_csv_file)

            response = boto3.client('lambda').invoke(
                FunctionName=LAMBDA_BILLINGCALCULATION,
                InvocationType='RequestResponse',
                Payload=json.dumps(
                    {
                        'body' : {
                            "saveToDB": False,
                            "target_date": TARGET_DATE,
                            "target_files": target_file_list
                        }
                    })
            )
            if 'StatusCode' in response and response['StatusCode'] == 200:
                # レスポンス読出し
                Payload = json.loads(response['Payload'].read())
                print("---03: body:")
                print(Payload)
                calc_data = json.loads(Payload['body'])

                # 今月の利用状況を取得
                usate_data = select_usage(datetime.datetime.strptime(TARGET_DATE, '%Y-%m-%d'))
                # upload_idを最大値に調整
                next_upload_id = get_upload_id()
                pk_list = []
                for data in calc_data:
                    update = False
                    data['upload_id'] += next_upload_id
                    # PKが重複していないかチェック。重複している場合はupload_idをカウントアップ。
                    while cehck_pk(pk_list, data['upload_id'], data['serial_number']):
                        data['upload_id'] += 1
                    for this_mont_usage_data in usate_data:
                        if data['chargingid'] == this_mont_usage_data['chargingid']:
                            # 利用状況更新
                            update_usage(data)
                            update = True
                            break
                    if not update:
                        # 利用状況をDB登録
                        insert_usage(data)
                print('今月の利用料金（従量）：' + str(usage_amount))
            else:
                raise '月初から昨日までの利用料金計算に失敗しました'
            print('月初から昨日までの利用料金を計算終了')
        elif CALC_MODE == 'DAILY':
            pass

        # 利用量CSVファイルを削除
        if not file_exist:
            deleteTargetFiles(target_file_list)

        return {
            'statusCode': 200,
            'body': 'OK'
        }

    except Exception as e:
        print('今月の利用料金の取得に失敗しました。')
        print(e.args)
        print(GV.ENV.lower())
        # 利用量CSVファイルを削除
        if not file_exist:
            deleteTargetFiles(target_file_list)
        return error_handling(inspect.currentframe().f_code.co_name, e, GV.TARGET_DATE)

# upload_idの最大値を取得
def get_upload_id(): 
    try:
        sql = '''
            SELECT Max(upload_id) AS max FROM "billing_infrastructure".t_qs_billing_information
        '''
        rows = psycopg2_compf.select(sql, None)
        print(rows[0])
        if rows[0]['max'] is None:
            rows[0]['max'] = 0
        return rows[0]['max'] + 1
    except Exception as e:
        print('利用状況の登録に失敗しました。')
        print(e.args)

# 今月の利用状況をDBから取得
def select_usage(target_date):
    try:
        sql = '''
            SELECT * 
            FROM "billing_infrastructure".t_qs_billing_information
            WHERE dateandtimeofoccurrence = %(dateandtimeofoccurrence)s;
        '''
        # 今月1日の日付を取得
        first_date = target_date.replace(day=1)
        # YYYY-MM-DD形式でフォーマット
        formatted_first_date = first_date.strftime("%Y-%m-%d")
        rows = psycopg2_compf.select(sql, {'dateandtimeofoccurrence': formatted_first_date})
        print(rows)
        return rows
    except Exception as e:
        print('利用状況の登録に失敗しました。')
        print(e.args)

# 利用状況をDB更新
def update_usage(data):
    try:
        sql = '''
            UPDATE "billing_infrastructure".t_qs_billing_information
            SET 
                end_date = %(end_date)s,
                usage = %(usage)s,
                amount = %(amount)s,
                charge_flg = %(charge_flg)s
            WHERE
                chargingid = %(chargingid)s and start_date = %(start_date)s;
        '''
        psycopg2_compf.update(sql, data)
        return
    except Exception as e:
        print('利用状況の更新に失敗しました。')
        print(e.args)

# 利用状況をDBに登録
def insert_usage(data):
    try:
        sql = '''
            INSERT 
                INTO "billing_infrastructure".t_qs_billing_information( 
                    upload_id,
                    serial_number,
                    system_name,
                    chargingid,
                    contract_product_id,
                    contract_id,
                    start_date,
                    end_date,
                    usage,
                    amount,
                    deletion_key,
                    dateandtimeofoccurrence,
                    registrationsituation,
                    charge_flg
                )
                VALUES ( 
                    %(upload_id)s, 
                    %(serial_number)s, 
                    %(system_name)s,
                    %(chargingid)s,
                    %(contract_product_id)s,
                    %(contract_id)s,
                    %(start_date)s, 
                    %(end_date)s, 
                    %(usage)s,
                    %(amount)s,
                    %(deletion_key)s,
                    %(dateandtimeofoccurrence)s,
                    %(registrationsituation)s,
                    %(charge_flg)s
                );
        '''
        psycopg2_compf.insert(sql, data)
        return
    except Exception as e:
        print('利用状況の登録に失敗しました。')
        print(e.args)

# PKが重複していないかチェック
def cehck_pk(pk_list, upload_id, serial_number):
    if str(upload_id) + '-' + str(serial_number) in pk_list:
        return True
    pk_list.append(str(upload_id) + '-' + str(serial_number))
    return False
        
# 利用量CSVファイルが存在するファイルパスの作成
def create_s3_key(d_today :datetime, path: str):
    # date today
    str_year = str(d_today)[0:4]
    str_month = str(d_today)[5:7]
    str_key = path + '/year=' + str_year + '/month=' + str_month + '/'
    # str_key = KEY + '/year=2021/month=07/'
    print(str_key)
    return str_key

# 契約IDから契約情報を取得
def getContract(contract_id):
    try:
        sql = '''
            SELECT
                mc.company_code,
                mc.contract_id,
                tmr.system_id,
                msys.system_name,
                tmr.service_id,
                msrv.service_name
            FROM user_infrastructure.m_contract mc
            JOIN user_infrastructure.t_manage_request tmr ON tmr.contract_id = mc.contract_id
            JOIN billing_infrastructure.m_systems msys ON msys.system_id = tmr.system_id
            JOIN billing_infrastructure.m_services msrv ON msrv.service_id = tmr.service_id
            WHERE
                mc.contract_id = %(contract_id)s
            AND
                ((mc.subscription_start_date < now() AND mc.subscription_end_date IS NULL)
                OR (mc.subscription_start_date < now() AND mc.subscription_end_date > now()))
        '''
        rows = psycopg2_compf.select(sql, {'contract_id' : contract_id})
        print(rows)
        return rows[0]
    except Exception as e:
        print('契約情報の取得に失敗しました。')
        print(e.args)

# S3のファイル削除
def deleteTargetFiles(target_file_list):
    for file in target_file_list:
        try:
            boto3.client('s3').delete_object(Bucket=BUCKET_NAME, Key=file)
        except botocore.exceptions.ClientError as e:
            "FILE NOT FOUND."

if __name__ == '__main__':
    lambda_handler({}, None)