import boto3
import csv
import json
from io import StringIO
import datetime
import math
import psycopg2
import psycopg2.extras
import configparser
import random
import string
import global_value as GV
import psycopg2_simsp
import psycopg2_compf
from error_function import error_handling
import inspect

s33 = boto3.client('s3')
cw = boto3.client('cloudwatch')

# 設定ファイル
# BUCKET_NAME = 'env-mcl-mgmt-phase3'
# PATH_NAME = 'user-infrastructure/'
# OBJECT_KEY_NAME = 'config.json'
s3 = boto3.resource('s3')

# 今日の日付を取得
today = datetime.date.today()

# 1日前の日付を計算
yesterday = today - datetime.timedelta(days=1)
# yesterday = today

def lambda_handler(event, context):
    
    print(event)

    try:

        event_body = {}
        if 'body' in event and event['body'] is not None: 
            event_body = json.loads(event['body'])
        
        query_string_parameters = {}
        if 'queryStringParameters' in event and event['queryStringParameters'] is not None: 
            query_string_parameters = event['queryStringParameters']

        # if 'env' not in  event or event['env'] is None:
        #     res = {}
        #     res['error_code'] = ''
        #     res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
        #     print(res)
        #     return
        
        # GV.ENV = event['env'].upper()
        
        if 'target_date' not in  event or event['target_date'] is None:
            GV.TARGET_DATE = str(yesterday)
        else:
            GV.TARGET_DATE = event['target_date'].upper()
        print(GV.TARGET_DATE)

        BUCKET_NAME = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        PATH_NAME = 'user-infrastructure/'
        OBJECT_KEY_NAME = 'config.json'
        
        bucket = s3.Bucket(BUCKET_NAME)
        obj = bucket.Object(PATH_NAME + GV.ENV.lower() + '_' + OBJECT_KEY_NAME)
        response = obj.get()
        body = response['Body'].read()
        ENV_CONFIG = json.loads(body.decode('utf-8'))
        
        # GV.CONFIG = {}
        # GV.CONFIG['AUTH0_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_AUDIENCE']
        # GV.CONFIG['AUTH0_CLIENT_ID'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_ID']
        # GV.CONFIG['AUTH0_CLIENT_SECRET'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_CLIENT_SECRET']
        # GV.CONFIG['AUTH0_DOMAIN'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_DOMAIN']
        # # GV.CONFIG['AUTH0_ROLE_IDS'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLE_IDS']
        # # フェーズ2 ------------------------S
        # GV.CONFIG['AUTH0_ROLES'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'AUTH0_ROLES']
        # # フェーズ2 ------------------------E
        # GV.CONFIG['API_AUDIENCE'] = ENV_CONFIG[GV.ENV]['AUTH0'][GV.ENV + '_' + 'API_AUDIENCE']
        # GV.CONFIG['ALGORITHMS'] = ["RS256"]
        
        # GV.CONFIG_MSCONE_LIC = {}
        # GV.CONFIG_MSCONE_LIC['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_HOST']
        # GV.CONFIG_MSCONE_LIC['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PORT']
        # # GV.CONFIG_MSCONE_LIC['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABSE_PORT']
        # GV.CONFIG_MSCONE_LIC['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_NAME']
        # GV.CONFIG_MSCONE_LIC['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_USERNAME']
        # GV.CONFIG_MSCONE_LIC['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['MSCONE_LIC'][GV.ENV + '_' + 'DATABASE_PASSWORD']

        # GV.CONFIG_COMN_PF = {}
        # GV.CONFIG_COMN_PF['DATABASE_HOST'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_HOST']
        # GV.CONFIG_COMN_PF['DATABASE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PORT']
        # # GV.CONFIG_COMN_PF['DATABSE_PORT'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABSE_PORT']
        # GV.CONFIG_COMN_PF['DATABASE_NAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_NAME']
        # GV.CONFIG_COMN_PF['DATABASE_USERNAME'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_USERNAME']
        # GV.CONFIG_COMN_PF['DATABASE_PASSWORD'] = ENV_CONFIG[GV.ENV]['COMN_PF'][GV.ENV + '_' + 'DATABASE_PASSWORD']
        # print("--------------")
        # # データベースタ情報を取得する
        # COM_DB_NAME = GV.CONFIG_COMN_PF['DATABASE_NAME'] 
        # COM_DB_HOST = GV.CONFIG_COMN_PF['DATABASE_HOST']
        # COM_DB_USER = GV.CONFIG_COMN_PF['DATABASE_USERNAME']
        # COM_DB_PASS = GV.CONFIG_COMN_PF['DATABASE_PASSWORD']
        # COM_DB_PORT = GV.CONFIG_COMN_PF['DATABASE_PORT']
        # COM_DB_PORT = GV.CONFIG_COMN_PF['DATABSE_PORT']

        # solver場合
        GV.EXEC_TYPE = 'solver'
        print('起動タイプ「' + GV.EXEC_TYPE + '」の利用量ファイル作成開始')
        
        resultData = mscone_lic_t_exec_history_solver_sel()
        
        if len(resultData) > 0:
            target_strings = []
            for item in resultData:
                target_strings.append(item['billing_code'])
            # 契約データ一覧を取得する
            chargingidDataTable = select_m_contract(target_strings)
                
            # testdata 2024/06/24
            # chargingidDataTable = [{
            #     'system_id':'SYS00019',
            #     'service_id':'SRV0001',
            #     'env_id':'000001',
            #     'company_code':'K10002',
            #     'contract_id':'CON1000002',
            #     'product_code':'SSP000020'
            # },
            # {
            #     'system_id':'SYS00019',
            #     'service_id':'SRV0001',
            #     'env_id':'000002',
            #     'company_code':'K10002',
            #     'contract_id':'CON1000002',
            #     'product_code':'SSP000021'
            # },
            # {
            #     'system_id':'SYS00020',
            #     'service_id':'SRV0002',
            #     'env_id':'000001',
            #     'company_code':'K10002',
            #     'contract_id':'CON1000002',
            #     'product_code':'SSP000020'
            # },
            # {
            #     'system_id':'SYS00020',
            #     'service_id':'SRV0002',
            #     'env_id':'000002',
            #     'company_code':'K10002',
            #     'contract_id':'CON1000002',
            #     'product_code':'SSP000021'
            # },
            # {
            #     'system_id':'SYS00020',
            #     'service_id':'SRV0002',
            #     'env_id':'000003',
            #     'company_code':'K10002',
            #     'contract_id':'CON1000002',
            #     'product_code':'SSP000021'
            # }]
            
            # システムIDグループのデータ
            systemGroup_list = []
            trm_data = {}
            # print(chargingidDataTable)
            for item in chargingidDataTable:
                
                # print(item)
                if (len(systemGroup_list) == 0):
                    systemGroup_list.append(item)
                else:
                    if (trm_data['system_id'] == item['system_id']):
                        systemGroup_list.append(item)
                    else:
                        # システムIDグループのデータ処理
                        systemlist_data = systemList(systemGroup_list,trm_data['system_id'],resultData)
                        systemGroup_list = []
                        systemGroup_list.append(item)
                    
                trm_data = item
            
            # システムIDグループのデータ処理
            if len(trm_data) != 0:
                systemlist_data = systemList(systemGroup_list,trm_data['system_id'],resultData)
        
        print('起動タイプ「' + GV.EXEC_TYPE + '」の利用量ファイル作成完了')
        

        # app場合
        
        GV.EXEC_TYPE = 'app'
        print('起動タイプ「' + GV.EXEC_TYPE + '」の利用量ファイル作成開始')
        
        resultData = mscone_lic_t_exec_history_app_sel()
        if len(resultData) > 0:
            target_strings = []
            for item in resultData:
                target_strings.append(item['billing_code'])
            # 契約データ一覧を取得する
            chargingidDataTable = select_m_contract(target_strings)

            # システムIDグループのデータ
            systemGroup_list = []
            trm_data = {}
            # print(chargingidDataTable)
            for item in chargingidDataTable:
                
                # print(item)
                if (len(systemGroup_list) == 0):
                    systemGroup_list.append(item)
                else:
                    if (trm_data['system_id'] == item['system_id']):
                        systemGroup_list.append(item)
                    else:
                        # システムIDグループのデータ処理
                        systemlist_data = systemList(systemGroup_list,trm_data['system_id'],resultData)
                        systemGroup_list = []
                        systemGroup_list.append(item)
                    
                trm_data = item
            
            # システムIDグループのデータ処理
            if len(trm_data) != 0:
                systemlist_data = systemList(systemGroup_list,trm_data['system_id'],resultData)
        
        print('起動タイプ「' + GV.EXEC_TYPE + '」の利用量ファイル作成完了')
        # return error_handling(inspect.currentframe().f_code.co_name, "test", GV.TARGET_DATE)

        return {
            'statusCode': 200,
            'body': json.dumps('Data exported to S3')
        }

    except Exception as e:
        print('AppStream2.0の利用量ファイル作成に失敗しました。')
        print(e.args)
        print(GV.ENV.lower())
        return error_handling(inspect.currentframe().f_code.co_name, e, GV.TARGET_DATE)

# システムIDグループのデータ処理
def systemList(in_data,systemId_str,in_data2):
    cloudwatchArr_data = []
    
    # メトリクスのFleetリストを作成する
    fleetlist_data = fleetlist(in_data)
    # print(fleetlist_data)
    for item in fleetlist_data:
        input_data = {}
        cloudwatchcsv_data = {}

        # 企業コード
        input_data['project_id'] = item['project_id']
        # 課金ID
        input_data['chargingid'] = item['chargingid']
        # 商品ID
        input_data['product_id'] = item['product_id']
        # 取得なデータの開始時間
        input_data['start_time_str'] = item['start_time_str']
        # 取得なデータの終了時間
        input_data['end_time_str'] = item['end_time_str']
        
        minutes_between = 0
        # print('-------------')
        # print(item)
        for item2 in in_data2:
            # print(item2)
            if (item['billing_code'] == item2['billing_code'] and item['env_id'] == item2['project_id'] ):

                if item2['end_date'] is None or str(item2['start_date'].strftime('%Y-%m-%d')) < str(GV.TARGET_DATE):
                    time1_str  = GV.TARGET_DATE + ' 00:00:00'
                else:
                    time1_str = str(item2['start_date'])
                if item2['end_date'] is None or str(item2['end_date'].strftime('%Y-%m-%d')) > str(GV.TARGET_DATE):
                    time2_str = GV.TARGET_DATE + ' 23:59:59'
                else:
                    time2_str = str(item2['end_date'])
                    
                time1 = datetime.datetime.strptime(time1_str, '%Y-%m-%d %H:%M:%S')
                time2 = datetime.datetime.strptime(time2_str, '%Y-%m-%d %H:%M:%S')
                
                # print('----------')
                # print(time1)
                # print(time2)
                time_difference = time2 - time1
                # print(time_difference)
                seconds = time_difference.seconds
                
                if seconds % 60 != 0:
                    time_difference += datetime.timedelta(minutes=1)
    
                minutes_between += time_difference.total_seconds() // 60
                # print(minutes_between)
        
        # 取得なデータの終了時間
        input_data['usage'] = minutes_between

        # CSVデータの作成する
        cloudwatchcsv_data = cloudwatchcsv_file(minutes_between,input_data)
        cloudwatchArr_data.append(cloudwatchcsv_data)

    # CSVファイルはS3に保存する
    if (len(cloudwatchArr_data) > 0):
        s3_csvfile(cloudwatchArr_data,systemId_str) 
    
# メトリクスのFleetリストを作成する
def fleetlist(in_data):
    # print(in_data)
    fleetlist_list = []
    for item in in_data:
        # print(item)
        trm_data = {}
        # 企業コード
        trm_data['project_id'] = item['company_code']
        # 商品コード
        trm_data['product_id'] = item['product_code']
        # 課金ID
        trm_data['chargingid'] = item['contract_id'] + item['product_code']
        # 課金
        trm_data['billing_code'] = item['billing_code']
        # 環境ID
        trm_data['env_id'] = item['env_id']
        # 取得なデータの開始時間
        trm_data['start_time_str'] = str(GV.TARGET_DATE) + ' 00:00:00'
        # 取得なデータの終了時間
        trm_data['end_time_str'] = str(GV.TARGET_DATE) + ' 23:59:59'
        
        fleetlist_list.append(trm_data)
    
    return fleetlist_list
        
# CSVデータの作成する
def cloudwatchcsv_file(in_data,indata1):
    try:
        
        cloudwatchcsv = {}
        # # テスト

        if (in_data > 0 ):
            print('起動タイプ「' + GV.EXEC_TYPE + '」CSVデータの作成開始')
            
            date1 = datetime.datetime.strptime(indata1['start_time_str'], "%Y-%m-%d %H:%M:%S")
            date2 = datetime.datetime.strptime(indata1['end_time_str'], "%Y-%m-%d %H:%M:%S")
            # 企業コード
            cloudwatchcsv['project_id'] = indata1['project_id']
            # 課金ID
            cloudwatchcsv['chargingid'] = indata1['chargingid']
            # 商品ID
            cloudwatchcsv['product_id'] = indata1['product_id']
            # 開始の日	
            cloudwatchcsv['start_day'] = date1.strftime('%Y-%m-%d').replace('-','/')
            # 開始の時間
            cloudwatchcsv['start_time'] = date1.strftime('%H:%M:%S')
            # 終了の日	
            cloudwatchcsv['end_day'] = date2.strftime('%Y-%m-%d').replace('-','/')
            # 終了の時間
            cloudwatchcsv['end_time'] = date2.strftime('%H:%M:%S')
            # 発生日時
            cloudwatchcsv['date_time'] = str(date1).replace('-','/')
            # 登録状況
            cloudwatchcsv['explanation'] = date1.strftime('%m') + "月利用分"
            # 利用量
            cloudwatchcsv['usage'] = int(indata1['usage'])
            # 削除キー
            cloudwatchcsv['deletionkey'] = randomname(12)
            
            print(cloudwatchcsv)
            
            print('起動タイプ「' + GV.EXEC_TYPE + '」CSVデータの作成完了')
    except Exception as e:
        print('CSVデータの作成に失敗しました。')
        print(e.args)
        return error_handling(inspect.currentframe().f_code.co_name, e, GV.TARGET_DATE)
        
    return cloudwatchcsv

# CSVファイルはS3に保存する
def s3_csvfile(in_data,systemId_str):
    try:
        print('起動タイプ「' + GV.EXEC_TYPE + '」CSVファイルはS3に保存開始')
        
        # CSV形式に変換して、S3にアップロードします
        bucket_name = GV.ENV.lower() + '-s3-bt-comn-pf-001'
        filename = str(GV.TARGET_DATE).replace("-","") + '_t_exec_history_' + GV.EXEC_TYPE + '.csv'
        filenameAll = 'billing-infrastructure/charges/Daily/' + systemId_str + '/year=' + str(GV.TARGET_DATE).split('-')[0] + '/month=' + str(GV.TARGET_DATE).split('-')[1]  + '/' + filename
        
        csv.register_dialect('myDialect', delimiter=',', quotechar='"', quoting=csv.QUOTE_ALL)
        csv_data= []
    
        keys = ['project_id','chargingid','product_id','start_day','start_time','end_day','end_time','usage','deletionkey','explanation','date_time']
        csv_data.append(keys)
        for item in in_data:
            if 'project_id' in item:
                timestr = str(item['project_id']) + "," + str(item['chargingid']) + "," + str(item['product_id']) + "," + str(item['start_day']) + "," + str(item['start_time'])  + "," +  str(item['end_day']) + "," + str(item['end_time'])  + "," + str(item['usage']) + "," + str(item['deletionkey']) + "," + str(item['explanation']) + "," + str(item['date_time']) 
                csv_data.append(timestr.split(","))
     
        # print(csv_data)
        csv_buffer = StringIO()
        writer = csv.writer(csv_buffer, dialect='myDialect')
        for row in csv_data:
            writer.writerow(row)
    
        # 
        response = s33.put_object(
            Bucket=bucket_name,
            Body=csv_buffer.getvalue(),
            Key=filenameAll
        )
        
        print('起動タイプ「' + GV.EXEC_TYPE + '」CSVファイルはS3に保存完了')
    except Exception as e:
        print('CSVファイルはS3に保存に失敗しました。')
        print(e.args)
        return error_handling(inspect.currentframe().f_code.co_name, e, GV.TARGET_DATE)

# 削除キーの採番：ランダム　英数字12桁
def randomname(n):
   return ''.join(random.choices(string.ascii_letters + string.digits, k=n))

# 日本語からUTC
def japanToUtc(in_data,dateType):
    # print(in_data)
    jst = datetime.timezone(datetime.timedelta(hours=9), 'JST')

    japan_time_str = in_data
    
    japan_time = datetime.datetime.strptime(japan_time_str, '%Y-%m-%d %H:%M:%S').replace(tzinfo=jst)
    if (dateType == 'end'):
        japan_time = japan_time + datetime.timedelta(hours=0, minutes=0, seconds=1)
    
    utc_time = japan_time.astimezone(datetime.timezone.utc)
    
    ret_time = utc_time.strftime('%Y-%m-%d') + 'T' + utc_time.strftime('%H:%M:%S')  + 'Z'
    
    # print (ret_time)
    
    return ret_time

#　テーブル「t_exec_history」のデータを取得
def mscone_lic_t_exec_history_solver_sel():
    print('mscone_lic_t_exec_history_solver_sel')
    # print(event)

    try:

        sql = '''
            SELECT
            exec_type                                   -- exec_type
            , username                                  -- username
            , project_id                                -- project_id
            , t_solver_list_id                          -- t_solver_list_id
            , instance_type                             -- instance_type
            , status                                    -- status
            , start_date                                -- start_date
            , end_date                                  -- end_date
            , billing_code                              -- billing_code
        FROM
            mscone_lic.view_billing_solver_log 
        WHERE
            DATE(start_date) <= %(target_date)s::date
            AND (end_date IS NULL OR DATE(end_date) >= %(target_date)s::date)
            --AND status in ('正常','エラー','キャンセル')
            AND status in ('計算完了','エラー','キャンセル')
        '''

        #
        t_exec_history_data = {}
        t_exec_history_data['target_date'] = GV.TARGET_DATE
        rows = psycopg2_simsp.select(sql,t_exec_history_data)

        # print(rows)

        # print("データを取得しました！")
        
        return rows

    except (Exception, psycopg2.Error) as error:
        print("PostgreSQLへのデータにエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, error, GV.TARGET_DATE)

#　テーブル「t_exec_history」のデータを取得
def mscone_lic_t_exec_history_app_sel():
    print('mscone_lic_t_exec_history_app_sel')
    # print(event)

    try:

        sql = '''
            SELECT
                  exec_type                                 -- exec_type
                , username                                  -- username
                , project_id                                -- project_id
                --, image_name                                -- image_name
                , fleet_name                                -- fleet_name
                , stack_name                                -- stack_name
                , instance_type                             -- instance_type
                , start_date                                -- start_date
                , end_date                                  -- end_date
                , billing_code    
            FROM
                mscone_lic.view_billing_app_log 
            WHERE
                
                DATE(start_date) <= %(target_date)s::date AND (end_date IS NULL OR DATE(end_date) >= %(target_date)s::date)
        '''
        t_exec_history_data = {}
        t_exec_history_data['target_date'] = GV.TARGET_DATE
        rows = psycopg2_simsp.select(sql,t_exec_history_data)

        # print(rows)

        # print("データを取得しました！")
        
        return rows
        

    except (Exception, psycopg2.Error) as error:
        print("PostgreSQLへのデータにエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, error, GV.TARGET_DATE)


# 処理データ一覧を取得する
def select_m_contract(billing_codeArr):
    print('select_m_contract')
    print(billing_codeArr)

    sql = '''
        SELECT  
            m_regular_products.system_id
           ,m_regular_products.service_id
           ,m_regular_products.product_id
           ,m_regular_products.product_code 
           ,m_regular_products.billing_code
           ,m_contract.company_code
           ,m_contract.contract_id
           ,user_infrastructure.m_env_stock.env_id
        FROM 
            billing_infrastructure.m_regular_products
            INNER JOIN user_infrastructure.m_contract_product
                    ON m_contract_product.product_id = m_regular_products.product_id
                    AND DATE(m_contract_product.use_start_date) <= %(target_date)s::date 
                    AND (m_contract_product.use_end_date IS NULL OR DATE(m_contract_product.use_end_date) >= %(target_date)s::date)
            INNER JOIN user_infrastructure.m_contract
                    ON m_contract.contract_id = m_contract_product.contract_id
                    AND DATE(m_contract.subscription_start_date) <= %(target_date)s::date 
                    AND (m_contract.subscription_end_date IS NULL OR DATE(m_contract.subscription_end_date) >= %(target_date)s::date)
            INNER JOIN user_infrastructure.m_env_stock
                    ON m_env_stock.system_id = m_regular_products.system_id
                    AND m_env_stock.service_id = m_regular_products.service_id
                    AND m_env_stock.company_code = m_contract.company_code
        WHERE  DATE(m_regular_products.applicable_start_date) <= %(target_date)s::date 
            AND (m_regular_products.applicable_end_date IS NULL OR DATE(m_regular_products.applicable_end_date) >= %(target_date)s::date)
            AND (m_regular_products.billing_code IN %(billing_codes)s)
        ORDER BY m_regular_products.system_id,m_regular_products.service_id,m_contract.company_code,m_regular_products.product_id
    '''
    rows = []

    t_exec_history_data = {}
    t_exec_history_data['target_date'] = GV.TARGET_DATE
    billing_codes = tuple(code for code in billing_codeArr)
    # print(billing_codes)
    t_exec_history_data['billing_codes'] = billing_codes
    rows = psycopg2_compf.select(sql,t_exec_history_data)

    return rows  
