import json
import datetime
import boto3
import logging
import global_value as GV
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

def error_handling(func_name, err, dataYYYYMMDD):
    logger.info('error_handling')
    print(err)
    print(GV.ENV)
    
    # import traceback
    # traceback.print_exc()
    
    # error_message = ''
    # # 関数名
    # error_message += '【関数名】' + '\n'
    # error_message += func_name + '\n'
    # # エラー内容
    # error_message += '【エラー内容】' + '\n'
    # error_message += traceback.format_exc()
    dataYYYYMMDD = str(dataYYYYMMDD).replace("-","/")
    send_system_administrator_change_notification_email(dataYYYYMMDD)
    
    res = {}
    res['error_code'] = ''
    res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
    return {
        'statusCode': 500,
        'headers': {
            'Access-Control-Allow-Headers': 'Content-Type',
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
        },
        'body': json.dumps(res)
    }

def send_system_administrator_change_notification_email(dataYYYYMMDD):
    # システム管理者変更連絡メール送信

    logger.info('send_system_administrator_change_notification_email!!!')

    SEND_EMAIL_FIELD_IDS = [
        # 
        "dataYYmmdd"
    ]

    mail_parameter = {}

    mail_parameter['dataYYmmdd'] = dataYYYYMMDD

    print(mail_parameter['dataYYmmdd'])

    # システム管理者のメールアドレス
    mail_parameter["to_address"] = []

    result = get_email_template()

    if 'statusCode' in result and (result['statusCode'] == 400 or result['statusCode'] == 500):
        return result

    mail_template = {}
    if 'body' in result:
        result_body = json.loads(result['body'])
        if 'result' in result_body:
            rows = result_body['result']
            print(rows)
            print(rows[0])
            if len(rows) > 0:
                mail_template = rows[0]

    print(mail_template)
    print(mail_parameter)

    result = send_email(mail_template, mail_parameter,dataYYYYMMDD)

    return result

def get_email_template():

    logger.info('get_email_template!!!')

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'GET',
            'path': '/rds/user_infrastructure/m_send_mail',
            'queryStringParameters': {
                'service_id': 'SRV00001',
                'mail_type': '利用量登録失敗',
            }
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-sys-rds',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        print(err)
        import traceback
        traceback.print_exc()

    return res

def send_email(mail_template, mail_parameter,dataYYYYMMDD):
    
    from_address = ''
    to_address = []
    cc_address = []
    bcc_address = []
    title = ""
    message = ""

    if "mail_send_from" in mail_template:
        from_address = mail_template["mail_send_from"]

    if not from_address:
        return error_400("送信元アドレスが設定されていません。")

    if "mail_to" in mail_template:
        if not mail_template["mail_to"] is None and len(mail_template["mail_to"]) > 0:
            arr_value = mail_template["mail_to"].split(';')
            for val in arr_value:
                to_address.append(val)

    if "to_address" in mail_parameter:
        to_address.extend(mail_parameter["to_address"])
        set(to_address)

    # if len(to_address) < 1:
    #     return error_400("宛先アドレスが設定されていません。")

    if "mail_cc" in mail_template:
        if not mail_template["mail_cc"] is None and len(mail_template["mail_cc"]) > 0:
            arr_value = mail_template["mail_cc"].split(';')
            for val in arr_value:
                cc_address.append(val)

    if "cc_address" in mail_parameter:
        cc_address.extend(mail_parameter["cc_address"])
        set(cc_address)

    if "mail_bcc" in mail_template:
        if not mail_template["mail_bcc"] is None and len(mail_template["mail_bcc"]) > 0:
            arr_value = mail_template["mail_bcc"].split(';')
            for val in arr_value:
                bcc_address.append(val)

    if "bcc_address" in mail_parameter:
        bcc_address.extend(mail_parameter["bcc_address"])
        set(bcc_address)

    if "mail_subject" in mail_template:
        title = mail_template["mail_subject"].replace("{{dataYYmmdd}}", dataYYYYMMDD)

    if not title:
        return error_400("メールのタイトルが空です。")

    if "mail_body" in mail_template:
        message = mail_template["mail_body"]

    if not message:
        return error_400("メールの本文が空です。")

    if 'to_address' in mail_parameter:
        del mail_parameter['to_address']
    if 'cc_address' in mail_parameter:
        del mail_parameter['cc_address']
    if 'bcc_address' in mail_parameter:
        del mail_parameter['bcc_address']

    for key in mail_parameter:
        # print('--11')
        # print(key)
        # print('---11')
        title = title.replace("{{" + key + "}}", mail_parameter[key])

    for key in mail_parameter:
        message = message.replace("{{" + key + "}}", mail_parameter[key])

    res = {}

    try:

        input_event = {
            'stageVariables': {
                'env': GV.ENV
            },
            'httpMethod': 'POST',
            'path': '/email/send',
            'body': json.dumps(
                {
                    'from_address': from_address,
                    'to_address': to_address,
                    'cc_address': cc_address,
                    'bcc_address': bcc_address,
                    'title': title,
                    'message': message
                }
            )
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            # FunctionName='lam-sys-email',
            FunctionName='prod-lam-sys-email',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:

            # レスポンス読出し
            Payload = json.loads(response['Payload'].read())
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        print(err)
        import traceback
        traceback.print_exc()

    return res

def error_400(message, code=None):
    body = {
        'error_code': code,
        'error_message': message
    }
    return {
        'statusCode': 400,
        'headers': RESPONSE_HEADERS,
        # 'body': json.dumps(body)
        'body': json.dumps(body, default=str, ensure_ascii=False, indent=2)
    }

