###############################################################################
#####     名前:componet.py  
#####     内容：XXXXX
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################
import sys
sys.path.append('/opt/Lib/site-packages/')
import json
import http.client
from common.auth0.v2.parameters import *
from urllib.request import urlopen
#from jose import jwt
import logging
import requests
import base64
import secrets
import string
from logging import StreamHandler, FileHandler, Formatter
from logging import INFO, DEBUG, NOTSET
import io
import urllib.parse

###############################################################################
#####     名前:　get_token_auth_header  
#####     内容： Token取得
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################

def get_token_auth_header(auth):
    #Flaskのsessionで取得
    access_token = auth

    if not access_token:
        raise AuthError({"code": "authorization_header_missing",
                        "description":
                            "Authorization header is expected"}, 401)

    return access_token

# ----------------------------------------------------------------
# Error handler
class AuthError(Exception):
    def __init__(self, error, status_code):
        self.error = error
        self.status_code = status_code

###############################################################################
#####     名前:main(引数なし)  
#####     内容： 単体デバッグ用
#####     作成日：2024/9/18　　作成者：宅美仁史（新事）
#####     更新日：XXXX/XX/XX　　更新者：XXXXX
#####     更新内容：XXXXXXXXXXXXXXXXXXXXXXXX
###############################################################################
class Auth0Component:
    # ストリームハンドラの設定
    stream_handler = StreamHandler()
    stream_handler.setLevel(INFO)
    stream_handler.setFormatter(Formatter("%(message)s"))

    # ルートロガーの設定   
    logging.basicConfig(level=NOTSET, handlers=[stream_handler])

    ###############################################################################
    ###### 初期化処理
    ###### トークンの発行を行う
    ###### 
    ###############################################################################
    def __init__(self, config):
        #EntraIDの設定
        self.ENTRA_TENANT_ID = config['AUTH0_DOMAIN']
        self.ENTRA_API_AUDIENCE = config['AUTH0_AUDIENCE'] 
        self.ENTRA_CLIENT_ID = config['AUTH0_CLIENT_ID']
        self.ENTRA_CLIENT_SECRET = config['AUTH0_CLIENT_SECRET']
        self.APP_ID=config['API_AUDIENCE']
        logging.debug('GV 読み込み')
        
        self.ENTRA_ISSUER = 'https://sts.windows.net/' + self.ENTRA_TENANT_ID +'/' #テナントID
        self.ENTRA_AUTHORITY="https://login.microsoftonline.com/" + self.ENTRA_TENANT_ID + "/oauth2/v2.0/token" #修正
        self.APP_REDIRECT_URL="https://apr01.mono-pf.com/ndes/invitation"
        self.ENTRA_SCOPE=[ "https://graph.microsoft.com/.default" ] #固定値
        self.ENTRA_JSON_URL="https://login.microsoftonline.com/common/discovery/keys"
        self.APP_RESOURCE_ID="5a722468-c752-47b6-9e37-4bb0b3783914" #オブジェクトID（エンタープライズ）
        self.ENTRA_ENDPOINT="graph.microsoft.com"
        self.APP_ROLE_ID="18d14569-c3bd-439b-9a66-3a2aee01d14f" #マニフェストから、’User’のロールID（固定）
        
        #self.APP_ID="7f73d30d-f523-4934-b3c6-1c97b54de6ac" #オブジェクトID（アプリ登録）

        '''
        #Auth0 ⇒ Entra
        id ⇒ id
        email ⇒ mail
        phone_number ⇒ mobilePhone
        given_name ⇒ givenName
        family_name ⇒ surname
        blocked ⇒ not accountEnabled
        name ⇒ displayName 
        username ⇒ displayName
        password ⇒ passwordProfile
        email_verified ⇒ officeLocation
        user_metadata ⇒ onPremisesExtensionAttributes extensionAttribute1
        app_metadata ⇒ onPremisesExtensionAttributes extensionAttribute2
        appstream ⇒ onPremisesExtensionAttributes extensionAttribute3

        $select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes
        '''

        # トークンを取得するためのデータ
        payload = {
            'client_id': self.ENTRA_CLIENT_ID,
            'client_secret': self.ENTRA_CLIENT_SECRET,
            'scope': self.ENTRA_SCOPE,
            'grant_type': 'client_credentials'
        }

        # トークンを取得
        token_response = requests.post(self.ENTRA_AUTHORITY, data=payload)
        token_response_json = token_response.json()

        if 'access_token' in token_response_json:
            self.TOKEN = token_response_json['access_token']
            logging.info("Get token")
        else:
            self.TOKEN = json.loads("Could not acquire token")
            logging.info("Could not acquire token")
    def get_access_token_info(self, auth):  
        token = auth.split(" ")[1]
        # token = auth
        #try:
        # HTTPSConnectionを使用してAPIを呼び出す
        self.ENTRA_ENDPOINT = "graph.microsoft.com"
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {token}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/me?$select=userPrincipalName,surname,id,mail,givenName,accountEnabled,displayName,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()
        data = res.read().decode("utf-8")

        conv_dic = json.loads(data)
        print(conv_dic)
        auth_dic={}

        auth_dic['user_id']=conv_dic['id']
        auth_dic['username']=conv_dic['userPrincipalName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['email']=conv_dic['mail']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata']={'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute2はJSONではないと仮定
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
            auth_dic['app_metadata']={'data': []}
        else :
            base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
            decode_str_2=base64_decode_2.decode()
            auth_dic['app_metadata']=json.loads(decode_str_2)

        conn.close()
        """
        except Exception:
            raise AuthError({"code": "invalid_header",
                            "description":
                                "Unable to get authentication"
                                " token."}, 400)"""
        print(auth_dic)
        return auth_dic
    ###############################################################################
    ###### パスワード再発行　
    ######  ⇒　Auth0はパスワード変更のURLを指定メール先に送信する
    ######  ⇒　Entraは新しいパスワード変更を設定する：新パスワードを戻り値にする 未使用のよう。使うと403エラーになる
    ###############################################################################
    def send_change_password(self, email):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        # path=f"/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes&$filter=mail%20eq%20'" + urllib.parse.quote(email) + "'"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logging.info("Error occured at 'send_change_password:users'.")
            logging.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        for user_dic in user_list:
            #logging.info(f"Me:{conv_dic['mail']}")

            #指定メールアドレスと検索IDのメールアドレスが一致しているか確認
            if email == user_dic['mail'] :
                #新しいパスワード生成（8文字以上？）
                length=8
                pass_chars = string.ascii_letters + string.digits
                password = ''.join(secrets.choice(pass_chars) for x in range(length))     

                logging.info(f"ID:{user_dic['id']}")
                logging.info(f"New Password:{password}")
            
                # 更新するデータを設定(EntraID向け)
                set_data = {
                    "newPassword": password
                }

                #パスワード認証方法の ID(EntraID固定)
                passwordMethodsid = '28c10230-6103-485e-b985-444c60001490'

                #作成クエリ（例:指定したidに一致するユーザーを検索）
                path=f"/v1.0/users/{user_dic['id']}/authentication/methods/{passwordMethodsid}/resetPassword"

                conn.request("POST", path, body=json.dumps(set_data), headers=headers)
                response = conn.getresponse()

                # エラー処理
                if not (200 <= response.status < 300) :
                    logging.info("Error occured at 'send_change_password:resetPassword'.")
                    logging.info(vars(response))
                    return ''

                data = response.read().decode("utf-8")
                conn.close()

                logging.info(f"Response:{data}")
            
                #return response
                return password

        return '' #Error
    
    ###############################################################################
    ###### アプリケーションに割り当てられているユーザー取得　
    ######  ⇒　なぜか取得できない　※Free契約だから？
    ###### 
    ###############################################################################
    def get_app_user_list(self, parameter:GetUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # POSTリクエストでユーザを作成
        #conn.request("GET", f"/v1.0/servicePrincipals(appId='{self.APP_ID}')/appRoleAssignments",  headers=headers)
        conn.request("GET", f"/v1.0/servicePrincipals(appId='{self.APP_ID}')/appRoleAssignedTo",  headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'get_app_user_list:servicePrincipals'.")
            logging.info(vars(response))
            return ''

        data = response.read().decode("utf-8")
        conn.close()

        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        auth_list=[]
        auth_dic={}
        #logging.info(parameter.id)

        for user_dic in user_list:
            auth_dic['id']=user_dic['principalId']
            auth_dic['name']=user_dic['principalDisplayName']
            auth_dic['username']=user_dic['principalDisplayName']

            auth_list.append(auth_dic)
            auth_dic={}

        # 結果を表示
        return auth_list

    ###############################################################################
    ###### ユーザーにアプリケーションを割り当てる　
    ###### 入力パラメータをGetUserParamに設定する（利用はidのみ）
    ###### 戻り値は、JSON
    ###############################################################################
    def set_app_to_user(self, parameter:GetUserParam):

        #parameter.id='7937a54c-acec-4808-928d-b3e18c12b5bb' #手動でコピー

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        #対象ID設定：email(userPrincipalName)
        # 更新するユーザのIDと更新データを設定(EntraID向け)
        set_data = {
            "principalId": parameter.id,
            "resourceId": self.APP_RESOURCE_ID,
            "appRoleId": self.APP_ROLE_ID
        }

        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}/appRoleAssignments"

        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'set_app_to_user:appRoleAssignments'.")
            logging.info(vars(response))
            return ''

        data = response.read().decode("utf-8")
        conn.close()

        # 結果を表示
        return json.loads(data)
        '''
        {
            "@odata.context": "https://graph.microsoft.com/v1.0/$metadata#users('4fea7e4e-e6df-49b2-b2f6-02a3e0608530')/appRoleAssignments/$entity",
            "id": "Tn7qT9_mskmy9gKj4GCFMKHPNXdfaLNKijzEbkrod_4",
            "deletedDateTime": null,
            "appRoleId": "18d14569-c3bd-439b-9a66-3a2aee01d14f",
            "createdDateTime": "2024-10-10T10:01:02.9772692Z",
            "principalDisplayName": "NDES Taro",
            "principalId": "4fea7e4e-e6df-49b2-b2f6-02a3e0608530",
            "principalType": "User",
            "resourceDisplayName": "SUP_NDES",
            "resourceId": "5a722468-c752-47b6-9e37-4bb0b3783914"
        }
        '''
    ###############################################################################
    ###### ユーザーリスト取得
    ###### パラメータに応じたユーザーリストを取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user_list(self, parameter:GetUsersParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        path=f"/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        auth_list=[]
        while path:
            conn.request("GET", path, headers=headers)
            res = conn.getresponse()
            print(res.status)

            # エラー処理
            if (200 <= res.status < 300):
                data = res.read().decode("utf-8")
                conn.close()

                # JSONデータを辞書型に変換
                conv_dic = json.loads(data)
                user_list = conv_dic['value']
                path = conv_dic.get('@odata.nextLink', None)
                auth_dic={}

                for user_dic in user_list:
                    #print(user)
                    #user_dic = json.loads(user)
                    auth_dic['id']=user_dic['id']
                    auth_dic['email']=user_dic['mail']
                    auth_dic['phone_number']=user_dic['mobilePhone']
                    auth_dic['given_name']=user_dic['givenName']
                    auth_dic['family_name']=user_dic['surname']
                    auth_dic['blocked']=not user_dic['accountEnabled']
                    auth_dic['name']=user_dic['displayName']
                    auth_dic['username']=user_dic['displayName']
                    auth_dic['email_verified']=user_dic['officeLocation']

                    #Attribute1はJSONのためでbase64でencodeされている        
                    if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                        auth_dic['user_metadata']={'data': []}
                    else :
                        base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                        decode_str_1=base64_decode_1.decode()
                        auth_dic['user_metadata']=json.loads(decode_str_1)
                        #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                    #Attribute2はJSONのためでbase64でencodeされている        
                    if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                        auth_dic['app_metadata']={'data': []}
                    else :
                        base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                        decode_str_2=base64_decode_2.decode()
                        auth_dic['app_metadata']=json.loads(decode_str_2)
                        #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                    #Attribute3はJSONではないと仮定
                    auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']

                    auth_list.append(auth_dic)
                    auth_dic={}
            else:
                logging.info("Error occured at 'get_users_by_email:users'.")
                print(f"Error: {res.status}")
                print(res.read().decode())
                break

            conn.close()

        # 結果を表示
        return auth_list
    
    ###############################################################################
    ###### ユーザー情報取得
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    def get_user(self, parameter:GetUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Content-Type': 'application/json',
            'Authorization': f'Bearer {self.TOKEN}'  
        }

        #logging.info(headers)

        # 検索クエリ（例：指定したidに一致するユーザーを検索　& 指定した項目のみ出力）
        path=f"/v1.0/users/{parameter.id}?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logging.info("Error occured at 'get_user_list:users'.")
            logging.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        auth_dic={}

        auth_dic['id']=conv_dic['id']
        auth_dic['email']=conv_dic['mail']
        auth_dic['phone_number']=conv_dic['mobilePhone']
        auth_dic['given_name']=conv_dic['givenName']
        auth_dic['family_name']=conv_dic['surname']
        auth_dic['blocked']=not conv_dic['accountEnabled']
        auth_dic['name']=conv_dic['displayName']
        auth_dic['username']=conv_dic['displayName']
        auth_dic['email_verified']=conv_dic['officeLocation']

        #Attribute1はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
            auth_dic['user_metadata']={'data': []}
        else :
            base64_decode_1= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
            decode_str_1=base64_decode_1.decode()
            auth_dic['user_metadata']=json.loads(decode_str_1)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute2はJSONのためでbase64でencodeされている        
        if not conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
            auth_dic['app_metadata']={'data': []}
        else :
            base64_decode_2= base64.b64decode(conv_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
            decode_str_2=base64_decode_2.decode()
            auth_dic['app_metadata']=json.loads(decode_str_2)
            #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

        #Attribute3はJSONではないと仮定
        auth_dic['appstream']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute3']

        conn.close()

        # 結果を表示
        return auth_dic

    ###############################################################################
    ###### ユーザー情報取得　(Tokenチェック)
    ###### 個別ユーザー情報を取得する
    ###### ※現行パラメータを使用したが、ID指定のみで第2引数’’、第3引数は影響しない
    ###############################################################################
    # def get_user_by_auth(self, auth):

    #     # Auth0の場合はSplitしていたが、Entra時はTokenそのものとする
    #     token = auth

    #     jsonurl = urlopen(self.ENTRA_JSON_URL)
    #     jwks = json.loads(jsonurl.read())

    #     unverified_header = jwt.get_unverified_header(token)
    #     rsa_key = {}

    #     for key in jwks["keys"]:
    #         if key["kid"] == unverified_header["kid"]:
    #             rsa_key = {
    #                 "kty": key["kty"],
    #                 "kid": key["kid"],
    #                 "use": key["use"],
    #                 "n": key["n"],
    #                 "e": key["e"]
    #             }

    #     # Auth0バージョンはエラー処理していない（EntraID開発でいれたDebug用処理を残す）
    #     try:
    #         payload = jwt.decode(
    #             token,
    #             rsa_key,
    #             algorithms=["RS256"],
    #             audience=self.ENTRA_API_AUDIENCE,
    #             issuer=self.ENTRA_ISSUER
    #         )
    #     except jwt.ExpiredSignatureError:
    #         print("code:token_expired  description: token is expired")
    #     except jwt.JWTClaimsError:
    #         print("code:invalid_claims description: incorrect claims, please check the audience and issuer")
    #     except Exception:
    #         print("code:invalid_header description: Unable to parse authentication token.")

    #     # ユーザ情報取得　※取得対象者はToken内に記載されたユーザ
    #     user_param = GetUserParam()
    #     #logging.info(payload['sub'])
    #     #'sub': '29ba7061-b0a6-43bd-bb8a-39fa26c88cbb', 
    #     user_param.id = payload['sub']
    #     return self.get_user(user_param)

    ###############################################################################
    ###### ユーザー新規登録　※外部ドメインユーザを招待する　2024.10.22変更　
    ###### ユーザーを新規登録する
    ###### ※拡張属性はUpdateで追加
    ###############################################################################
    def create_user(self, parameter:CreateUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # ユーザを作成するためのデータ(EntraID向け)
        create_data = json.dumps({
            "invitedUserEmailAddress": parameter.email,
            "inviteRedirectUrl": self.APP_REDIRECT_URL,
            #"sendInvitationMessage" : False #招待メールを飛ばさない
            "sendInvitationMessage" : True #招待メールを飛ばす
        })

        # POSTリクエストでユーザを作成
        conn.request("POST", "/v1.0/invitations", body=create_data, headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'create_user:invitations'.")
            logging.info(vars(response))
            return ''

        # 追加されたユーザのOIDを取得し、アプリケーションに割り当て
        # JSONデータを辞書型に変換
        data = response.read().decode("utf-8")
        data_dic = json.loads(data)
        auth_dic={}

        logging.debug(data_dic)
        auth_dic['email']=data_dic['invitedUserEmailAddress']
        auth_dic['user_id']=data_dic['invitedUser']['id']
        auth_dic['inviteRedeemUrl']=data_dic['inviteRedeemUrl']
        auth_dic['status']=data_dic['status']

        #####################################################################
        # 新規ユーザをアプリケーションに登録する
        # ※AppStreamへの追加を実施してない ⇒ テストで確認が必要
        #####################################################################

        set_data = {
            "principalId": auth_dic['user_id'],
            "resourceId": self.APP_RESOURCE_ID,
            "appRoleId": self.APP_ROLE_ID
        }

        # 作成クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{auth_dic['user_id']}/appRoleAssignments"
        conn.request("POST", path, body=json.dumps(set_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'create_user:appRoleAssignments'.")
            logging.info(vars(response))
            return ''

        data2 = response.read().decode("utf-8")
        data2_dic = json.loads(data2)
    
        auth_dic['type']=data2_dic['principalType']
        auth_dic['resource_name']=data2_dic['resourceDisplayName']
       
        conn.close()

        # 結果を表示
        return auth_dic

    ###############################################################################
    ###### ユーザー削除　
    ###### ユーザーを削除する
    ###### ※
    ###############################################################################
    def delete_user(self, parameter:CreateUserParam):

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("DELETE", path, headers=headers)

        # POSTリクエストでユーザを作成
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'delete_user:users'.")
            logging.info(vars(response))
            return ''

        #data = response.read().decode("utf-8")
        conn.close()

        return response

    ###############################################################################
    ###### ユーザー更新　
    ###### 既存のユーザーを更新する（拡張領域を含む）
    ###### ※UpdateUserParamの拡張領域がLISTではなくSTRになっている
    ###############################################################################
    def update_user(self, parameter:UpdateUserParam):
        user = self.get_users_by_email(parameter)
        result = json.loads(user['body'])[0]
        id = result['id']
        logging.info(dir(parameter))

        #user_idが存在しない場合エラーとする
        if(not 'id' in dir(parameter)):
            logging.info("user id is not exist.")
            return 'error'

        update_data = {}

        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        #user_metadata,app_metadata,appstreamは一括変更となるので、面倒
        #user_metadata,app_metadata,appstreamの全部の項目がある場合 ⇒ 指定されたパラメータを設定する
        if('appstream' in dir(parameter) and 'user_metadata' in dir(parameter) and 'user_metadata' in dir(parameter)):

            # JSONデータを文字列に変換 user_metadata
            # 文字列をバイナリに変換
            binary_data1 =  json.dumps(parameter.user_metadata).encode('utf-8')
            data_encode_str1 = base64.b64encode(binary_data1).decode('utf-8')

            logging.info(data_encode_str1)

            # JSONデータを文字列に変換 app_metadata
            # 文字列をバイナリに変換
            binary_data2 =  json.dumps(parameter.app_metadata).encode('utf-8')
            data_encode_str2 = base64.b64encode(binary_data2).decode('utf-8')

            # appstream
            data_encode_str3=parameter.appstream

            # 更新するユーザのIDと更新データを設定(EntraID向け)
            attribute_data = {
                "onPremisesExtensionAttributes": {
                    #"extensionAttribute1": json.dumps(parameter.user_metadata).encode('utf-8'),
                    "extensionAttribute1": data_encode_str1,
                    "extensionAttribute2": data_encode_str2,
                    "extensionAttribute3": data_encode_str3,
                }
            }
            update_data.update(attribute_data)

        #user_metadata,app_metadata,appstreamのいずれかの項目が１つ以上あって、全部の項目がある場合でない時⇒既存データを取得
        elif('appstream' in dir(parameter) or 'user_metadata' in dir(parameter) or 'user_metadata' in dir(parameter)): 
            #既存データを取得
            conv_dic = result
    
            user_param = UpdateUserParam()
            user_param.id=conv_dic['id']

            #存在しない項目に設定済みデータを代入する
            if(not 'user_metadata' in dir(parameter)):
                parameter.user_metadata = conv_dic['user_metadata']

            if(not 'app_metadata' in dir(parameter)):
                parameter.app_metadata = conv_dic['app_metadata']

            if(not 'appstream' in dir(parameter)):
                parameter.appstream = conv_dic['appstream']

            # JSONデータを文字列に変換 user_metadata
            # 文字列をバイナリに変換
            binary_data1 =  json.dumps(parameter.user_metadata).encode('utf-8')
            data_encode_str1 = base64.b64encode(binary_data1).decode('utf-8')
            logging.info(data_encode_str1)

            # JSONデータを文字列に変換 app_metadata
            # 文字列をバイナリに変換
            binary_data2 =  json.dumps(parameter.app_metadata).encode('utf-8')
            data_encode_str2 = base64.b64encode(binary_data2).decode('utf-8')
            logging.info(data_encode_str2)

            data_encode_str3 = parameter.appstream

            #対象ID設定：email(userPrincipalName)
            # 更新するユーザのIDと更新データを設定(EntraID向け)
            attribute_data = {
                "onPremisesExtensionAttributes": {
                    #"extensionAttribute1": json.dumps(parameter.user_metadata).encode('utf-8'),
                    "extensionAttribute1": data_encode_str1,
                    "extensionAttribute2": data_encode_str2,
                    "extensionAttribute3": data_encode_str3,
                }
            }

            update_data.update(attribute_data)
        
        #blockedは真偽をひっくり返す
        if('blocked' in dir(parameter) ):
            blocked_data = {
                'accountEnabled': not parameter.blocked,
            }

            update_data.update(blocked_data)

        #password ⇒  'password': 'P@ssW0rdNDES' 'password': 'P@ssW0rd202305'
        if('password' in dir(parameter) ):
            password_data = {
                "passwordProfile": {
                    "password": parameter.password,
                    "forceChangePasswordNextSignIn": False
                }
            }

            update_data.update(password_data)

        #phone_number
        if('phone_number' in dir(parameter) ):
            phone_number_data = {
                'mobilePhone': parameter.phone_number,
            }

            update_data.update(phone_number_data)

        #given_name
        if('given_name' in dir(parameter) ):
            given_name_data = {
                'givenName': parameter.given_name,
            }

            update_data.update(given_name_data)

        #family_name
        if('family_name' in dir(parameter) ):
            family_name_data = {
                'surname': parameter.family_name,
            }

            update_data.update(family_name_data)

        #name or username
        if('name' in dir(parameter) or 'username' in dir(parameter)):
            username_data = {
                'displayName': parameter.username,
            }

            update_data.update(username_data)

        #email_verified
        if('email_verified' in dir(parameter) ):
            email_verified_data = {
                'officeLocation': parameter.email_verified,
            }

            update_data.update(email_verified_data)

        logging.info(update_data)

        # 更新クエリ（例：指定したidに一致するユーザーを検索）
        path=f"/v1.0/users/{parameter.id}"
        conn.request("PATCH", path, body=json.dumps(update_data), headers=headers)
        response = conn.getresponse()

        # エラー処理
        if not (200 <= response.status < 300) :
            logging.info("Error occured at 'delete_user:users'.")
            logging.info(vars(response))
            return ''

        conn.close()
        logging.info(response.status)

        # 結果を表示
        return vars(parameter)

    #ENTRA_ENDPOINT="https://graph.microsoft.com/v1.0/users"

    ###############################################################################
    ###### メールでユーザーを検索
    ######
    ######
    ###############################################################################
    def get_users_by_email(self, parameter:GetUsersByEmailParam):
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        logging.info(parameter.email)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #conn.request("GET", "/api/v2/users-by-email?fields=" + parameter.fields + "&email=" + parameter.email.lower() , None, headers)
        #path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes&$filter=mail%20eq%20'" + urllib.parse.quote(parameter.email) + "'"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            print("Error occured at 'get_users_by_email:users'.")
            logging.info(vars(res))
            return res

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        user_list = conv_dic['value']

        auth_dic={}
        #logging.info(user_list)

        for user_dic in user_list:
            #logging.info(str(user_dic['mail']).lower())
            #指定メールアドレスと検索IDのメールアドレスが一致しているか確認
            if parameter.email.lower() == str(user_dic['mail']).lower() :
                auth_dic['id']=user_dic['id']
                auth_dic['user_id']=user_dic['mail']
                auth_dic['email']=user_dic['mail']
                auth_dic['phone_number']=user_dic['mobilePhone']
                auth_dic['given_name']=user_dic['givenName']
                auth_dic['family_name']=user_dic['surname']
                auth_dic['blocked']=not user_dic['accountEnabled']
                auth_dic['name']=user_dic['displayName']
                auth_dic['username']=user_dic['displayName']
                auth_dic['email_verified']=user_dic['officeLocation']

                #Attribute1はJSONのためでbase64でencodeされている        
                if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                    auth_dic['user_metadata']={'data': []}
                else :
                    base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                    decode_str_1=base64_decode_1.decode()
                    auth_dic['user_metadata']=json.loads(decode_str_1)
                    #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                #Attribute2はJSONのためでbase64でencodeされている        
                if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                    auth_dic['app_metadata']={'data': []}
                else :
                    base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                    decode_str_2=base64_decode_2.decode()
                    auth_dic['app_metadata']=json.loads(decode_str_2)
                    #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

                #Attribute3はJSONではないと仮定
                auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']

                print("Find user data by email")
                response = {}
                response_data = json.dumps([auth_dic]) # レスポンスのボディ
                status_code = 200
                reason = 'OK'
                headers = {'Content-Type': 'application/json'}
                response['body'] = response_data  # レスポンスボディ
                response['status'] = status_code
                response['reason'] = reason
                response['headers'] = headers
                return response

        print("Can't find user data by email")
        # ダミーのHTTPレスポンスを作成
        response_data = b'[]'  # レスポンスのボディ
        status_code = 200
        reason = 'OK'
        headers = {'Content-Type': 'application/json'}

        # HTTPResponseオブジェクトを作成
        sock = None  # 本来はソケットが必要です
        response = {}
        response['body'] = response_data  # レスポンスボディ
        response['status'] = status_code
        response['reason'] = reason
        response['headers'] = headers

        return response

    ###############################################################################
    ###### Audit Log を取得
    ######　※page対応を内部したので、呼び出し時のpage処理を削除してください
    ######  ※プレミアムライセンスがないと動作しません
    ###############################################################################
    def get_AuditLog(self, startdate, enddate):

        #初期化
        page_size= 50
        auth_list=[]
        auth_dic={}

        #GET https://graph.microsoft.com/v1.0/auditLogs/signIns?$filter=createdDateTime ge 2024-07-01T00:00:00Z and createdDateTime le 2024-07-14T23:59:59Z

        search_query = f'filter=createdDateTime ge {startdate} and createdDateTime le {enddate}' 
        logging.info(search_query)

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #path=f"/v1.0/auditLogs/signIn?${search_query}&$top={page_size}"
        path=f"/v1.0/auditLogs/signIns?$top={page_size}"


        while path:

            # HTTPSConnectionを使用してAPIを呼び出す
            conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
            headers = {
                'Authorization': f'Bearer {self.TOKEN}',
                'Content-Type': 'application/json'
            }

            logging.info(path)

            conn.request("GET", path, headers=headers)
            res = conn.getresponse()

            if (200 <= res.status < 300):
                data = json.loads(res.read().decode())
                entra_list = data.get('value', [])
                path = data.get('@odata.nextLink', None)

                for entra_log in entra_list:

                    auth_dic['type_code'] = entra_log['conditionalAccessStatus']
                    auth_dic['event_type'] = entra_log['status failureReason']
                    auth_dic['date'] = entra_log['createdDateTime']
                    auth_dic['ip'] = entra_log['ipAddress']
                    auth_dic['client_name'] = entra_log['appDisplayName']
                    auth_dic['user_id'] = entra_log['userId']
                    auth_dic['user_name'] = entra_log['userDisplayName']

                    entra_agent = f"{entra_log['deviceDetail']['browser']} / {entra_log['deviceDetail']['operatingSystem']}"

                    auth_dic['user_agent'] = entra_agent
                    auth_dic['log_id'] = entra_log['id']

                    auth_list.append(auth_dic)
                    auth_dic={}

            else:
                print(f"Error: {res.status}")
                print(res.read().decode())
                break

            conn.close()

        return auth_list

    ###############################################################################
    ###### Queryをつかってユーザを検索する（app_metadata内）
    ######　app_metadata.data.staff/trial/workshop/contract/_req_vefification_code:
    ######　app_metadata.data.change_admin_user_vefification_code:
    ######   query = f'app_metadata.data.workshop_req_vefification_code: "{code}"'
    ###############################################################################
    def search_user(self, q):
        # HTTPSConnectionを使用してAPIを呼び出す
        conn = http.client.HTTPSConnection(self.ENTRA_ENDPOINT)
        headers = {
            'Authorization': f'Bearer {self.TOKEN}',
            'Content-Type': 'application/json'
        }

        # 検索クエリ（例：指定したidに一致するユーザーを検索 & 指定した項目のみ出力）
        #conn.request("GET", "/api/v2/users-by-email?fields=" + parameter.fields + "&email=" + parameter.email.lower() , None, headers)
        path="/v1.0/users?$select=id,mail,mobilePhone,surname,givenName,accountEnabled,displayName,officeLocation,onPremisesExtensionAttributes"
        conn.request("GET", path, headers=headers)
        res = conn.getresponse()

        # エラー処理
        if not (200 <= res.status < 300) :
            logging.info("Error occured at 'get_users_by_email:users'.")
            logging.info(vars(res))
            return ''

        data = res.read().decode("utf-8")
        conv_dic = json.loads(data)
        logging.debug(conv_dic)
        user_list = conv_dic['value']
        logging.debug(user_list)

        auth_dic={}
        auth_list=[]
        auth_dic={}

        #logging.info(user_list)

        #Queryが存在する場合、辞書型に変換する
        if len (q) != 0 :
            query_split=q.split(":")
            key_split=str(query_split[0]).split(".")
            #app_metadata.data.staff_req_verification_codeの最後を指定　key_split[2]
            logging.info(key_split[0])
            logging.info(key_split)
            query_dic={key_split[2]:(str(query_split[1]).strip()).strip('"')}
            logging.info(query_dic)
            #logging.info(query_dic.keys())
            #logging.info(query_dic.values())

        #Queryが存在する場合の検索ループ
        for user_dic in user_list:
            auth_dic['id']=user_dic['id']
            auth_dic['email']=user_dic['mail']
            auth_dic['phone_number']=user_dic['mobilePhone']
            auth_dic['given_name']=user_dic['givenName']
            auth_dic['family_name']=user_dic['surname']
            auth_dic['blocked']=not user_dic['accountEnabled']
            auth_dic['name']=user_dic['displayName']
            auth_dic['username']=user_dic['displayName']
            auth_dic['email_verified']=user_dic['officeLocation']

            #Attribute1はJSONのためでbase64でencodeされている        
            if not user_dic['onPremisesExtensionAttributes']['extensionAttribute1'] :
                auth_dic['user_metadata']={'data': []}
            else :
                base64_decode_1= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute1'])
                decode_str_1=base64_decode_1.decode()
                auth_dic['user_metadata']=json.loads(decode_str_1)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

            #Attribute2はJSONのためでbase64でencodeされている        
            if not user_dic['onPremisesExtensionAttributes']['extensionAttribute2'] :
                auth_dic['app_metadata']={'data': []}
            else :
                base64_decode_2= base64.b64decode(user_dic['onPremisesExtensionAttributes']['extensionAttribute2'])
                decode_str_2=base64_decode_2.decode()
                auth_dic['app_metadata']=json.loads(decode_str_2)
                #auth_dic['user_metadata']=conv_dic['onPremisesExtensionAttributes']['extensionAttribute1']

            #Attribute3はJSONではないと仮定
            auth_dic['appstream']=user_dic['onPremisesExtensionAttributes']['extensionAttribute3']
            logging.debug(auth_dic)
            #検索Query文字列が存在する場合
            if len (q) != 0 :
                target_item = dict(auth_dic[key_split[0]])
                logging.debug(target_item)
                #値が存在する場合
                if target_item and (key_split[1] in target_item):
                    target_data = target_item.get(key_split[1])
                    logging.debug(target_data)
    ##バグあり。指定したkeyを持ってないユーザーのデータを処理するとエラー終了。指定したKEY/VALUEが正常に取得できていない
                    target_dic=dict(target_data) #もしかしてループにする必要あり？
                    logging.debug(target_dic)
                    if key_split[2] in target_dic:

                        target_value=target_dic[key_split[2]]

                    #print(target_item)      
                    #print(target_data)      
                        logging.debug(target_value) 

                    #指定したKEY/VALUEが一致するか？     
                        if(target_value == query_dic[key_split[2]]):
                            #logging.info("Find user data matching query")
                            #ユーザリストに追加する     
                            auth_list.append(auth_dic)
                            auth_dic={}
                    
            else :
                #すべてのユーザデータが対象
                #ユーザリストに追加する     
                auth_list.append(auth_dic)
                auth_dic={}

        # 結果を表示
        return auth_list
