import sys
import re
import inspect

import psycopg2
import psycopg2.extras

import logging
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

sys.path.append('../../')
from error_function import error_handling

class PDBCComponent:
    
    DATABASE_HOST = ''
    DATABASE_PORT = ''
    # DATABSE_PORT = ''
    DATABASE_NAME = ''
    DATABASE_USERNAME = ''
    DATABASE_PASSWORD = ''

    def __init__(self, config):
        #認証情報取得
        self.DATABASE_HOST = config["DATABASE_HOST"]
        # self.DATABSE_PORT = config["DATABSE_PORT"]
        self.DATABASE_PORT = config["DATABASE_PORT"]
        self.DATABASE_NAME = config["DATABASE_NAME"]
        self.DATABASE_USERNAME = config["DATABASE_USERNAME"]
        self.DATABASE_PASSWORD = config["DATABASE_PASSWORD"]

    def connection(self):
        con = None
        try:
            # con = psycopg2.connect("host=" + self.DATABASE_HOST +
            #                         " port=" + self.DATABSE_PORT +
            #                         " dbname=" + self.DATABASE_NAME +
            #                         " user=" + self.DATABASE_USERNAME +
            #                         " password=" + self.DATABASE_PASSWORD)
            con = psycopg2.connect("host=" + self.DATABASE_HOST +
                                    " port=" + self.DATABASE_PORT +
                                    " dbname=" + self.DATABASE_NAME +
                                    " user=" + self.DATABASE_USERNAME +
                                    " password=" + self.DATABASE_PASSWORD)
            logger.debug(con)
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        con.autocommit = True
        return con

    def close(self, connection:psycopg2):
        try:
            connection.close
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)

    """
    SELECT実行
    """
    def select_param(self, sql, param):
        con = self.connection()
        try:
            #辞書型でSelect結果を返却する
            with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
                if param is None:
                    cur.execute(sql)
                else:
                    cur.execute(sql, param)
                results = cur.fetchall()
                rows = []
                
                for row in results:
                    rows.append(dict(row))
            return rows
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    def select(self, schema, condition):

        table_name = type(condition).__name__
        table_columns = vars(condition)
        #SQL生成
        sql = 'SELECT * FROM '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        condition_columns = vars(condition)
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in table_columns:
                if table_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + '%('+column + ')s AND '
            sql = sql[:-5]
        sql += ';'
        con = self.connection()
        try:
            #辞書型でSelect結果を返却する
            with con.cursor(cursor_factory=psycopg2.extras.DictCursor) as cur:
                cur.execute(sql, condition.__dict__)
                results = cur.fetchall()
                rows = []
                
                for row in results:
                    rows.append(dict(row))
            return rows
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    """
    INSERT実行
    """
    def insert_param(self, sql, param):
        con = self.connection()
        try:
            new_id = None
            with con.cursor() as cur:
                cur.execute(sql, param)
                new_id = cur.fetchone()[0]
            con.commit()
            return new_id
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)


    def insert(self, schema, param):
        logger.debug('insert')
        table_name = type(param).__name__
        table_columns = vars(param)
        #SQL生成
        sql = 'INSERT INTO '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        sql += ' '
        column_names = '('
        values = '('
        for column in table_columns:
            column_names += (column + ',')
            values += '%('+column + ')s,'

        column_names = column_names[:-1]
        values = values[:-1]
        column_names += ') VALUES '
        values += ')'
        
        values += ' RETURNING *;'

        sql += column_names
        sql += values

        con = self.connection()
        try:
            new_id = None
            with con.cursor() as cur:
                logger.debug('cur')
                logger.debug(cur)
                cur.execute(sql,  param.__dict__)
                new_id = cur.fetchone()[0]
            logger.debug('new_id')
            logger.debug(new_id)
            con.commit()
            return new_id
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    """
    UPDATE実行
    """
    def update_param(self, sql, param):
        con = self.connect()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param)
            con.commit()
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    def update(self, schema, param, condition):
        table_name = type(param).__name__
        param_columns = vars(param)
        condition_columns = vars(condition)
        #SQL生成
        sql = 'UPDATE '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        #更新値
        sql += ' SET '
        for column in param_columns:
            sql += column + ' = ' + '%('+column + ')s,'
        sql = sql[:-1]
        #条件値
        if len(condition_columns) != 0:
            sql += ' WHERE '
            for column in condition_columns:
                if condition_columns[column] == None:
                    sql += column + ' IS NULL AND '
                else :
                    sql += column + ' = ' + self.param_replace(condition_columns[column]) + ' AND '
            sql = sql[:-5]
        sql += ';'

        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param.__dict__)
            con.commit()
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    """
    DELETE実行
    """
    def delete_param(self, sql, param):
        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, param)
            con.commit()
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    def delete(self, schema, condition):
        table_name = type(condition).__name__
        table_columns = vars(condition)
        #SQL生成
        sql = 'DELETE FROM '
        sql += schema+'.'
        sql += self.camel_to_snake(table_name)
        #条件値
        condition_columns = vars(condition)
        sql += ' WHERE '
        for column in table_columns:
            sql += column + ' = ' + self.param_replace(table_columns[column]) + ' AND '
        sql = sql[:-5]
        sql += ';'

        con = self.connection()
        try:
            with con.cursor() as cur:
                cur.execute(sql, None)
            con.commit()
        except Exception as err:
            return error_handling(inspect.currentframe().f_code.co_name, err)
        finally:
            self.close(con)

    def camel_to_snake(self, s):
        return re.sub("((?<=[a-z0-9])[A-Z]|(?!^)[A-Z](?=[a-z]))", r"_\1", s).lower()

    def param_replace(self, val):
        if type(val) is str:
            val = val.replace("'", "''")
            val = val.replace("\\", "\\\\")
            return "'" + val + "'"
        return str(val)