from datetime import datetime
import psycopg2_simsp
from error_function import error_handling
import inspect
import json
import logging
import boto3
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

def lambda_handler(event, context):
    
    try:
        res = {}
        # 必要項目のチェック
        required_keys = ['exec_type', 'session_type', 'username', 'project_id']
        for key in required_keys:
            if key not in event:
                res['error_code'] = ''
                res['error_message'] = "エラー:Lambda側で変数: " + str(key) + " が必要です。"
                logger.info(res['error_message'])
                return {
                    'statusCode': 500,
                    'headers': {
                        'Access-Control-Allow-Headers': 'Content-Type',
                        'Access-Control-Allow-Origin': '*',
                        'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
                    },
                    'body': json.dumps(res)
                }

        # AppStream2.0のログDB登録
        res = mscone_lic_t_exec_history_inst(event, context)
        
        logger.info(res)
        
        return res
        
    except Exception as error:
        logger.info("lambda_handlerにエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, error)

#　テーブル「t_exec_history」のデータを挿入
def mscone_lic_t_exec_history_inst(event, context):
    logger.info('mscone_lic_t_exec_history_inst')
    # print(event)
    
    res = {}
    res['error_code'] = None
    res['error_message'] = None
    res['result'] = {}
    
    try:
        dt_now = datetime.now()
        
        # INSERT文のためのサンプルデータ
        t_exec_history_tab = ['exec_type', 'session_type','username','project_id','t_solver_list_id',
        'image_name','fleet_name', 'stack_name','instance_type','billing_code','cdate','udate']
        
        t_exec_history_data = {}
        for key in t_exec_history_tab:
            if key in event:
                t_exec_history_data[key] = event[key]
            else:
                t_exec_history_data[key] = None
                
        t_exec_history_data['cdate'] = dt_now.strftime('%Y-%m-%d %H:%M:%S')
        t_exec_history_data['udate'] = dt_now.strftime('%Y-%m-%d %H:%M:%S')
        
        # print(t_exec_history_data)
        # パラメータを持つSQL文
        sql = '''
            INSERT INTO mscone_lic.t_exec_history(
                exec_type, session_type, username, project_id, t_solver_list_id,
                image_name, fleet_name, stack_name, instance_type, billing_code,
                cdate, udate
            ) 
            VALUES (
                %(exec_type)s, %(session_type)s, %(username)s, %(project_id)s,
                %(t_solver_list_id)s, %(image_name)s, %(fleet_name)s, %(stack_name)s,
                %(instance_type)s, %(billing_code)s, %(cdate)s, %(udate)s
            )
        '''
    
        # PostgreSQLデータベースに接続します
        conn = psycopg2_simsp.connect()
        conn.autocommit = True
        cursor = conn.cursor()
    
        # INSERT文を実行します
        cursor.execute(sql, t_exec_history_data)
        
        conn.commit()

        # データベースとの通信を閉じます
        cursor.close()
        conn.close()
        logger.info(t_exec_history_data)
        logger.info("データを正常に挿入しました！")
        
        # exec_history_id取得する
        resultData = mscone_lic_t_exec_history_sel(t_exec_history_data)
        print("resultData")
        print(resultData)
        if len(resultData) > 0:
            target_strings = []
            for item in resultData:
                print(item)
                # 起動数更新
                result = user_infrastructure_m_app_concurrent_count(event, item['exec_history_id'])
                print(result)
        
                if 'statusCode' in result and (result['statusCode'] == 300):
                    result_body = json.loads(result['body'])
                    return error_handling(inspect.currentframe().f_code.co_name, result_body)
                logger.info("起動数更新しました！")
        # error_handling(inspect.currentframe().f_code.co_name, '')  #---·`テストメール

    except Exception as error:
        logger.info("PostgreSQLへのデータ挿入中にエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, error)
    finally:
        # データベース接続を閉じます
        if conn:
            conn.close()
            
    return {
        'statusCode': 200,
        'headers': {
            'Access-Control-Allow-Headers': 'Content-Type',
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
        },
        'body': json.dumps(res, default=str, ensure_ascii=False, indent=2)
    }
    
#　テーブル「t_exec_history」のデータを取得
def mscone_lic_t_exec_history_sel(t_exec_history_item):
    print('mscone_lic_t_exec_history_solver_sel||')
    # print(t_exec_history_item)

    try:

        sql = '''
            SELECT
            exec_history_id                                   -- exec_history_id
        FROM
            mscone_lic.t_exec_history 
        WHERE
            exec_type = %(exec_type)s
            AND session_type = %(session_type)s
            AND username = %(username)s
            AND project_id = %(project_id)s
        ORDER by exec_history_id DESC
        LIMIT 1
        '''

        #
        t_exec_history_data = {}
        t_exec_history_data['exec_type'] = t_exec_history_item['exec_type']
        t_exec_history_data['session_type'] = t_exec_history_item['session_type']
        t_exec_history_data['username'] =  t_exec_history_item['username']
        t_exec_history_data['project_id'] =  t_exec_history_item['project_id']
        rows = psycopg2_simsp.select(sql,t_exec_history_data)

        # print(rows)

        # print("データを取得しました！")
        
        return rows

    except Exception as error:
        print("PostgreSQLへのデータにエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, error)

# 起動数更新
def user_infrastructure_m_app_concurrent_count(event, context):

    logger.info('user_infrastructure_m_app_concurrent_count!!!')

    res = {}

    try:

        input_event = {
            'exec_history_id': context
        }

        Payload = json.dumps(input_event)
        print("---01: Payload:", Payload)

        # 呼び出し
        response = boto3.client('lambda').invoke(
            FunctionName='prod-lam-simsp-updateConcurrentExecution',
            InvocationType='RequestResponse',
            Payload=Payload
        )
        print("---02: response:", response)

        res = response
        print(res)

        result = None
        if 'StatusCode' in response and response['StatusCode'] == 200:
            # レスポンス読出し
            Payload = response
            print("---03: body:", Payload)
            res = Payload

    except Exception as err:
        print("user_infrastructure_m_app_concurrent_countにエラーが発生しました:", error)
        return error_handling(inspect.currentframe().f_code.co_name, err)

    return res


