import json

def error_handling(func_name, err):
    
    print(err)
    
    import traceback
    traceback.print_exc()
    
    error_message = ''
    # 関数名
    error_message += '【関数名】' + '\n'
    error_message += func_name + '\n'
    # エラー内容
    error_message += '【エラー内容】' + '\n'
    error_message += traceback.format_exc()
    send_alarm_email(error_message)
    
    res = {}
    res['error_code'] = ''
    res['error_message'] = 'エラー:Lambda側で異常が発生しました。'
    return {
        'statusCode': 500,
        'headers': {
            'Access-Control-Allow-Headers': 'Content-Type',
            'Access-Control-Allow-Origin': '*',
            'Access-Control-Allow-Methods': 'GET, POST, PUT, OPTIONS'
        },
        'body': json.dumps(res)
    }
    
def send_alarm_email(error_message):
    
    print('send_alarm_email!!!')

    try:
        from component import MailComponent
        
        MAIL_FROM = "info@simsp.mono-pf.com"
    
        MAIL_TO = ['nakamura.e@ndes.co.jp']

        # テスト
        title = 'Lambda「prod-lam-simsp-writeExecLog」側には異常発生しました'
        mail = MailComponent()
        res = mail.sendmail_text(MAIL_FROM, MAIL_TO, title, error_message)
        print(res)
      
    except Exception as err:
        print(err)
        import traceback
        traceback.print_exc()
